/*

 @ author, GLSL & OpenGL code author Athanasios Theocharidis, 2012-2015

*/

uniform sampler2D texture;
uniform bool oldLCDStyleTransparency;
uniform bool useBlackBackground;
uniform bool useSmoothBorderEdges;
uniform float transparency;
uniform int blendingType;
uniform float blendingValue;
uniform float width;
uniform float height;

const vec4 BLACK_COLOR = vec4(0.0);
const vec4 WHITE_COLOR = vec4(1.0);

void applyOldStyleTransparency();
vec3 applyInterpolation(in int, in vec3, in vec3, in float, in float);
vec4 applySmoothBorderEdges(in vec2, in vec4, in int);

void main()
{
  if (oldLCDStyleTransparency)
    applyOldStyleTransparency();

  vec2 screenSize  = vec2(width, height);
  vec2 texCoords   = vec2(gl_FragCoord.xy / screenSize);
  vec3 originalRGB = texture2D(texture, texCoords).rgb;

  vec2 stp0 = vec2(1.0 / width,  0.0);
  vec2 st0p = vec2(0.0        ,  1.0 / height);
  vec2 stpp = vec2(1.0 / width,  1.0 / height);
  vec2 stpm = vec2(1.0 / width, -1.0 / height);

  vec3 i00   = originalRGB;
  vec3 im1m1 = texture2D(texture, texCoords - stpp).rgb;
  vec3 ip1p1 = texture2D(texture, texCoords + stpp).rgb;
  vec3 im1p1 = texture2D(texture, texCoords - stpm).rgb;
  vec3 ip1m1 = texture2D(texture, texCoords + stpm).rgb;
  vec3 im10  = texture2D(texture, texCoords - stp0).rgb;
  vec3 ip10  = texture2D(texture, texCoords + stp0).rgb;
  vec3 i0m1  = texture2D(texture, texCoords - st0p).rgb;
  vec3 i0p1  = texture2D(texture, texCoords + st0p).rgb;

  vec3 filteredRGB = vec3(0.0);
  filteredRGB += 1.0 * (im1m1 + ip1m1 + ip1p1 + im1p1);
  filteredRGB += 2.0 * (im10  + ip10  + i0m1  + i0p1);
  filteredRGB += 4.0 * (i00);
  filteredRGB /= 16.0;

  if ( all( equal( filteredRGB, vec3(0.0) ) ) )
  {
    gl_FragColor = useBlackBackground ? BLACK_COLOR 
                                      : useSmoothBorderEdges ? applySmoothBorderEdges(screenSize, WHITE_COLOR, blendingType) 
                                                             :                                    WHITE_COLOR;
  }
  else
  {
    gl_FragColor = useSmoothBorderEdges ? applySmoothBorderEdges(screenSize, transparency * vec4(applyInterpolation(blendingType, originalRGB, filteredRGB, blendingValue, 1.0), 1.0), blendingType)
                                        :                                    transparency * vec4(applyInterpolation(blendingType, originalRGB, filteredRGB, blendingValue, 1.0), 1.0);
  }  
}