/*

 @ author, GLSL & OpenGL code author Athanasios Theocharidis, 2012-2015

*/

uniform sampler2D texture;
uniform bool oldLCDStyleTransparency;
uniform bool useBlackBackground;
uniform bool useSmoothBorderEdges;
uniform float transparency;
uniform int blendingType;
uniform float blendingValue;
uniform float width;
uniform float height;
uniform float embossAngle;

const float PI            = 3.14159265;
const float PI_OVER_4     = PI / 4.0;
const float SIN_PI_OVER_4 = 0.707;
const vec4 BLACK_COLOR    = vec4(0.0);
const vec4 WHITE_COLOR    = vec4(1.0);

void applyOldStyleTransparency();
vec3 applyInterpolation(in int, in vec3, in vec3, in float, in float);
vec4 applySmoothBorderEdges(in vec2, in vec4, in int);

void main()
{
  if (oldLCDStyleTransparency)
    applyOldStyleTransparency();

  vec2 screenSize  = vec2(width, height);
  vec2 texCoords   = vec2(gl_FragCoord.xy / screenSize);
  vec3 originalRGB = texture2D(texture, texCoords).rgb;

  vec2 stp0 = vec2(1.0 / width,  0.0);
  vec2 st0p = vec2(0.0        ,  1.0 / height);
  vec2 stpp = vec2(1.0 / width,  1.0 / height);
  vec2 stpm = vec2(1.0 / width, -1.0 / height);

  vec3 i00   = originalRGB;
  vec3 im1m1 = texture2D(texture, texCoords - stpp).rgb;
  vec3 ip1p1 = texture2D(texture, texCoords + stpp).rgb;
  vec3 im1p1 = texture2D(texture, texCoords - stpm).rgb;
  vec3 ip1m1 = texture2D(texture, texCoords + stpm).rgb;
  vec3 im10  = texture2D(texture, texCoords - stp0).rgb;
  vec3 ip10  = texture2D(texture, texCoords + stp0).rgb;
  vec3 i0m1  = texture2D(texture, texCoords - st0p).rgb;
  vec3 i0p1  = texture2D(texture, texCoords + st0p).rgb;

  float radians = embossAngle * (PI / 180.0);
  vec3 differences = vec3(0.0);
  if ( (0.0 * PI_OVER_4) <= radians  &&  radians <= (1.0 * PI_OVER_4) )
  {
    float t = ( radians - (0.0 * PI_OVER_4) ) / PI_OVER_4;
    differences = (  (i00 - ip10) * sin( (1.0 - t) * PI_OVER_4 ) + (i00 - ip1p1) * sin( t * PI_OVER_4 )  ) / SIN_PI_OVER_4;
  }
  else if ( (1.0 * PI_OVER_4) < radians  &&  radians <= (2.0 * PI_OVER_4) )
  {
    float t = ( radians - (1.0 * PI_OVER_4) ) / PI_OVER_4;
    differences = (  (i00 - ip1p1) * sin( (1.0 - t) * PI_OVER_4 ) + (i00 - i0p1) * sin( t * PI_OVER_4 )  ) / SIN_PI_OVER_4;
  }
  else if ( (2.0 * PI_OVER_4) < radians  &&  radians <= (3. * PI_OVER_4) )
  {
    float t = ( radians - (2.0 * PI_OVER_4) ) / PI_OVER_4;
    differences = (  (i00 - i0p1) * sin( (1.0 - t) * PI_OVER_4 ) + (i00 - im1p1) * sin( t * PI_OVER_4 )  ) / SIN_PI_OVER_4;
  }
  else if ( (3.0 * PI_OVER_4) < radians  &&  radians <= (4. * PI_OVER_4) )
  {
    float t = ( radians - (3.0 * PI_OVER_4) ) / PI_OVER_4;
    differences = (  (i00 - im1p1) * sin( (1.0- t ) * PI_OVER_4 ) + (i00 - im10) * sin( t * PI_OVER_4 )  ) / SIN_PI_OVER_4;
  }
  else if ( (4.0 * PI_OVER_4) < radians  &&  radians <= (5.0 * PI_OVER_4) )
  {
    float t = ( radians - (4.0 * PI_OVER_4) ) / PI_OVER_4;
    differences = (  (i00 - im10) * sin( (1.0 - t) * PI_OVER_4 ) + (i00 - im1m1) * sin( t * PI_OVER_4 )  ) / SIN_PI_OVER_4;
  }
  else if ( (5.0 * PI_OVER_4) < radians  &&  radians <= (6.0 * PI_OVER_4) )
  {
    float t = ( radians - (5.0 * PI_OVER_4) ) / PI_OVER_4;
    differences = (  (i00 - im1m1) * sin( (1.0 - t) * PI_OVER_4 ) + (i00 - i0m1) * sin( t * PI_OVER_4 )  ) / SIN_PI_OVER_4;
  }
  else if ( (6.0 * PI_OVER_4) < radians  &&  radians <= (7.0 * PI_OVER_4) )
  {
    float t = ( radians - (6.0 * PI_OVER_4) ) / PI_OVER_4;
    differences = (  (i00 - i0m1) * sin( (1.0 - t) * PI_OVER_4 ) + (i00 - ip1m1) * sin( t * PI_OVER_4 )  ) / SIN_PI_OVER_4;
  }
  else if ( (7.0 * PI_OVER_4) < radians )
  {
    float t = ( radians - (7.0 * PI_OVER_4) ) / PI_OVER_4;
    differences = (  (i00 - ip1m1) * sin( (1.0 - t) * PI_OVER_4 ) + (i00 - ip10) * sin( t * PI_OVER_4 )  ) / SIN_PI_OVER_4;
  }

  float max = differences.r;
  if( abs(differences.g) > abs(max) )
    max = differences.g;
  if( abs(differences.b) > abs(max) )
    max = differences.b;

  float gray = clamp(max + 0.5, 0.0, 1.0);
  vec3 grayVersion  = transparency * vec3(gray);
  vec3 colorVersion = transparency * gray * i00;

  if ( all( equal( colorVersion, vec3(0.0) ) ) )
  {
    gl_FragColor = useBlackBackground ? BLACK_COLOR 
                                      : useSmoothBorderEdges ? applySmoothBorderEdges(screenSize, WHITE_COLOR, blendingType) 
                                                             :                                    WHITE_COLOR;
  }
  else
  {
    gl_FragColor = useSmoothBorderEdges ? applySmoothBorderEdges(screenSize, transparency * vec4(applyInterpolation(blendingType, grayVersion, colorVersion, blendingValue, 1.0), 1.0), blendingType)
                                        :                                    transparency * vec4(applyInterpolation(blendingType, grayVersion, colorVersion, blendingValue, 1.0), 1.0);
  }                                                          
}