/*

 @ author, GLSL & OpenGL code author Athanasios Theocharidis, 2012-2015

*/

uniform sampler2D texture;
uniform bool oldLCDStyleTransparency;
uniform bool useBlackBackground;
uniform bool useSmoothBorderEdges;
uniform float transparency;
uniform int blendingType;
uniform float blendingValue;
uniform float width;
uniform float height;

const vec3 WEIGHT_LUMINANCE_VECTOR = vec3(0.2125, 0.7154, 0.0721);
const vec4 BLACK_COLOR             = vec4(0.0);
const vec4 WHITE_COLOR             = vec4(1.0);

void applyOldStyleTransparency();
vec3 applyInterpolation(in int, in vec3, in vec3, in float, in float);
vec4 applySmoothBorderEdges(in vec2, in vec4, in int);

void main()
{
  if (oldLCDStyleTransparency)
    applyOldStyleTransparency();

  vec2 screenSize  = vec2(width, height);
  vec2 texCoords   = vec2(gl_FragCoord.xy / screenSize);
  vec3 originalRGB = texture2D(texture, texCoords).rgb;

  vec2 stp0 = vec2(1.0 / width,  0.0);
  vec2 st0p = vec2(0.0        ,  1.0 / height);
  vec2 stpp = vec2(1.0 / width,  1.0 / height);
  vec2 stpm = vec2(1.0 / width, -1.0 / height);

  float i00   = dot(originalRGB, WEIGHT_LUMINANCE_VECTOR);
  float im1m1 = dot(texture2D(texture, texCoords - stpp).rgb, WEIGHT_LUMINANCE_VECTOR);
  float ip1p1 = dot(texture2D(texture, texCoords + stpp).rgb, WEIGHT_LUMINANCE_VECTOR);
  float im1p1 = dot(texture2D(texture, texCoords - stpm).rgb, WEIGHT_LUMINANCE_VECTOR);
  float ip1m1 = dot(texture2D(texture, texCoords + stpm).rgb, WEIGHT_LUMINANCE_VECTOR);
  float im10  = dot(texture2D(texture, texCoords - stp0).rgb, WEIGHT_LUMINANCE_VECTOR);
  float ip10  = dot(texture2D(texture, texCoords + stp0).rgb, WEIGHT_LUMINANCE_VECTOR);
  float i0m1  = dot(texture2D(texture, texCoords - st0p).rgb, WEIGHT_LUMINANCE_VECTOR);
  float i0p1  = dot(texture2D(texture, texCoords + st0p).rgb, WEIGHT_LUMINANCE_VECTOR);

  float h = -1.0 * im1p1 - 2.0 * i0p1 - 1.0 * ip1p1  +  1.0 * im1m1 + 2.0 * i0m1 + 1.0 * ip1m1;
  float v = -1.0 * im1m1 - 2.0 * im10 - 1.0 * im1p1  +  1.0 * ip1m1 + 2.0 * ip10 + 1.0 * ip1p1;

  float magnitude  = sqrt(h * h + v * v);
  vec3 filteredRGB = vec3(magnitude, magnitude, 0.0); // vec3(magnitude, magnitude, magnitude); // for black border color

  if ( all( equal( filteredRGB, vec3(0.0) ) ) )
  {
    gl_FragColor = useBlackBackground ? BLACK_COLOR 
                                      : useSmoothBorderEdges ? applySmoothBorderEdges(screenSize, WHITE_COLOR, blendingType) 
                                                             :                                    WHITE_COLOR;
  }
  else
  {
    gl_FragColor = useSmoothBorderEdges ? applySmoothBorderEdges(screenSize, transparency * vec4(applyInterpolation(blendingType, originalRGB, filteredRGB, blendingValue, 1.0), 1.0), blendingType)
                                        :                                    transparency * vec4(applyInterpolation(blendingType, originalRGB, filteredRGB, blendingValue, 1.0), 1.0);
  }
}