/*

 @ author, GLSL & OpenGL code author Athanasios Theocharidis, 2012-2015

*/

uniform sampler2D frameBufferSampler;
uniform bool oldLCDStyleTransparency;
uniform vec2 frameBufferResolution = vec2(512, 512);
uniform float FXAA_SpanMax   = 8.0;
uniform float FXAA_ReduceMul = 1.0 / 8.0;
uniform float FXAA_ReduceMin = 1.0 / 128.0;

const vec3 LUMA = vec3(0.299, 0.587, 0.114);

void applyOldStyleTransparency();

void main()
{
  if (oldLCDStyleTransparency)
    applyOldStyleTransparency();

  vec2 texCoords = vec2(gl_FragCoord.xy / frameBufferResolution);
  vec3 rgbNW = texture2D(frameBufferSampler, texCoords + (vec2(-1.0, -1.0) / frameBufferResolution)).xyz;
  vec3 rgbNE = texture2D(frameBufferSampler, texCoords + (vec2( 1.0, -1.0) / frameBufferResolution)).xyz;
  vec3 rgbSW = texture2D(frameBufferSampler, texCoords + (vec2(-1.0,  1.0) / frameBufferResolution)).xyz;
  vec3 rgbSE = texture2D(frameBufferSampler, texCoords + (vec2( 1.0,  1.0) / frameBufferResolution)).xyz;
  vec4 rgbM  = texture2D(frameBufferSampler, texCoords);

  float lumaNW = dot(rgbNW,    LUMA);
  float lumaNE = dot(rgbNE,    LUMA);
  float lumaSW = dot(rgbSW,    LUMA);
  float lumaSE = dot(rgbSE,    LUMA);
  float lumaM  = dot(rgbM.rgb, LUMA);

  float lumaMin = min(lumaM, min(min(lumaNW, lumaNE), min(lumaSW, lumaSE)));
  float lumaMax = max(lumaM, max(max(lumaNW, lumaNE), max(lumaSW, lumaSE)));

  vec2 dir = vec2(-((lumaNW + lumaNE) - (lumaSW + lumaSE)), ((lumaNW + lumaSW) - (lumaNE + lumaSE)));
  float dirReduce = max((lumaNW + lumaNE + lumaSW + lumaSE) * (0.25 * FXAA_ReduceMul), FXAA_ReduceMin);
  float rcpDirMin = 1.0 / (min(abs(dir.x), abs(dir.y)) + dirReduce);

  dir = min(vec2(FXAA_SpanMax, FXAA_SpanMax), max(vec2(-FXAA_SpanMax, -FXAA_SpanMax), dir * rcpDirMin)) / frameBufferResolution;

  vec3 rgbA = (1.0 / 2.0) * (texture2D(frameBufferSampler, texCoords + dir * (1.0 / 3.0 - 0.5)).xyz + texture2D(frameBufferSampler, texCoords + dir * (2.0 / 3.0 - 0.5)).xyz);
  vec3 rgbB = rgbA * (1.0 / 2.0) + (1.0 / 4.0) * (texture2D(frameBufferSampler, texCoords + dir * (0.0 / 3.0 - 0.5)).xyz + texture2D(frameBufferSampler, texCoords + dir * (3.0 / 3.0 - 0.5)).xyz);
  float lumaB = dot(rgbB, LUMA);

  gl_FragColor = ((lumaB < lumaMin) || (lumaB > lumaMax)) ? vec4(rgbA, rgbM.a) : vec4(rgbB, rgbM.a);
}