/**
*
*  Cube Capping GLSL code.
*
* @author Thanos Theo, Michael Kargas, 2012-2015
* @version 6.0.0.0
*/

VS_VARYING vec4 cubeCappingPosition;

void main()
{
  #if USE_TEXTURE_MATRIX_PLANE_TRANSFORMATIONS
    // the gl_TextureMatrix includes the plane transformation
    // thus use this and avoid the ftranform() which uses
    // the standard glsl sate model view & projection matrices
    cubeCappingPosition = gl_TextureMatrix[0] * gl_Vertex;
  #else
    // use direct projection for gl_Position below instead of ftransform()
    // as gl_Vertex already includes the scale z transformation
    // in its vertices for the plane and the model view matrix
    // is already set for the cube via the glsl state
    cubeCappingPosition = gl_Vertex;
  #endif
  gl_Position = gl_ProjectionMatrix * cubeCappingPosition;  
}