/*

 @ author, GLSL & OpenGL code author Athanasios Theocharidis, Michael Kargas, 2008-2009-2010

*/

uniform sampler2D bump2DTexture;
uniform sampler2D bumpEmboss2DTexture;

uniform float bumpTimer;
uniform float bumpTransparency;
uniform bool bumpOldLCDStyleTransparency;
uniform int bumpState;
uniform float bumpSize;
uniform float bumpPx;
uniform float bumpPy;

const vec4 LIGHT_SPECULAR_COLOR = vec4(1.0, 1.0, 1.0, 1.0); // white specular color
const vec2 CENTER_POINT = vec2(0.5, 0.5);
const vec2 BOTTOM_RIGHT_POINT = vec2(0.0, 0.0);

void applyOldStyleTransparency();

void main()
{
  if (bumpOldLCDStyleTransparency)
    applyOldStyleTransparency();

  vec2 tcoords = gl_TexCoord[0].st;
  vec2 tcoordsLightSpecular = 128.0 * vec2(tcoords - CENTER_POINT);

  vec4 bump2DTextureColor = (bumpState == 0) ? texture2D(bumpEmboss2DTexture, tcoords) : texture2D(bump2DTexture, tcoords);
  if (bump2DTextureColor.a == 0.0) discard;
  bump2DTextureColor.rgb *= ( 0.5 + 0.45 * sin(bumpTimer) );

  float neighborFragmentX = (1.0 / bumpPx);
  float neighborFragmentY = (1.0 / bumpPy);

  tcoords.s -= neighborFragmentX;
  float neighborLeft =  texture2D(bumpEmboss2DTexture, tcoords).a;

  tcoords.s += 2.0 * neighborFragmentX;
  float neighborRight = texture2D(bumpEmboss2DTexture, tcoords).a;

  tcoords.s -= neighborFragmentX;
  tcoords.t += neighborFragmentY;
  float neighborUp = texture2D(bumpEmboss2DTexture, tcoords).a;

  tcoords.t -= 2.0 * neighborFragmentY;
  float neighborDown = texture2D(bumpEmboss2DTexture, tcoords).a;

  float dx = 0.75 * (neighborRight - neighborLeft);
  float dy = 0.75 * (neighborUp    - neighborDown);

  float lightSpecular = bumpSize / distance(vec2( (bumpPx / bumpPy) * ( tcoordsLightSpecular.s + 48.0 * (sin(bumpTimer) + dx) ), tcoordsLightSpecular.t + 48.0 * (cos(bumpTimer) + dy) ), BOTTOM_RIGHT_POINT);

  gl_FragColor = bumpTransparency * mix(bump2DTextureColor, LIGHT_SPECULAR_COLOR, lightSpecular);
}