/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share.sampled.file;

import java.io.File;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.spi.AudioFileWriter;
import org.tritonus.share.ArraySet;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.AudioFormats;
import org.tritonus.share.sampled.AudioUtils;
import org.tritonus.share.sampled.TConversionTool;
import org.tritonus.share.sampled.file.AudioOutputStream;
import org.tritonus.share.sampled.file.TDataOutputStream;
import org.tritonus.share.sampled.file.TNonSeekableDataOutputStream;
import org.tritonus.share.sampled.file.TSeekableDataOutputStream;

public abstract class TAudioFileWriter
extends AudioFileWriter {
    protected static final int ALL = -1;
    public static AudioFormat.Encoding PCM_SIGNED = new AudioFormat.Encoding("PCM_SIGNED");
    public static AudioFormat.Encoding PCM_UNSIGNED = new AudioFormat.Encoding("PCM_UNSIGNED");
    private static final int BUFFER_LENGTH = 16384;
    protected static final AudioFileFormat.Type[] NULL_TYPE_ARRAY = new AudioFileFormat.Type[0];
    private Collection m_audioFileTypes;
    private Collection m_audioFormats;

    protected TAudioFileWriter(Collection collection, Collection collection2) {
        if (TDebug.TraceAudioFileWriter) {
            TDebug.out("TAudioFileWriter.<init>(): begin");
        }
        this.m_audioFileTypes = collection;
        this.m_audioFormats = collection2;
        if (TDebug.TraceAudioFileWriter) {
            TDebug.out("TAudioFileWriter.<init>(): end");
        }
    }

    @Override
    public AudioFileFormat.Type[] getAudioFileTypes() {
        return this.m_audioFileTypes.toArray(NULL_TYPE_ARRAY);
    }

    @Override
    public boolean isFileTypeSupported(AudioFileFormat.Type type) {
        return this.m_audioFileTypes.contains(type);
    }

    @Override
    public AudioFileFormat.Type[] getAudioFileTypes(AudioInputStream object) {
        object = ((AudioInputStream)object).getFormat();
        ArraySet arraySet = new ArraySet();
        for (AudioFileFormat.Type type : this.m_audioFileTypes) {
            if (!this.isAudioFormatSupportedImpl((AudioFormat)object, type)) continue;
            arraySet.add(type);
        }
        return arraySet.toArray(NULL_TYPE_ARRAY);
    }

    @Override
    public boolean isFileTypeSupported(AudioFileFormat.Type type, AudioInputStream audioInputStream) {
        return this.isFileTypeSupported(type) && (this.isAudioFormatSupportedImpl(audioInputStream.getFormat(), type) || this.findConvertableFormat(audioInputStream.getFormat(), type) != null);
    }

    @Override
    public int write(AudioInputStream audioInputStream, AudioFileFormat.Type object, File object2) {
        boolean bl;
        AudioFormat audioFormat;
        if (TDebug.TraceAudioFileWriter) {
            TDebug.out(">TAudioFileWriter.write(.., File): called");
            TDebug.out("class: " + this.getClass().getName());
        }
        if (!this.isFileTypeSupported((AudioFileFormat.Type)object)) {
            if (TDebug.TraceAudioFileWriter) {
                TDebug.out("< file type is not supported");
            }
            throw new IllegalArgumentException("file type is not supported.");
        }
        AudioFormat audioFormat2 = audioInputStream.getFormat();
        if (TDebug.TraceAudioFileWriter) {
            TDebug.out("input format: " + audioFormat2);
        }
        if (this.isAudioFormatSupportedImpl(audioFormat2, (AudioFileFormat.Type)object)) {
            if (TDebug.TraceAudioFileWriter) {
                TDebug.out("input format is supported directely");
            }
            audioFormat = audioFormat2;
            bl = false;
        } else {
            if (TDebug.TraceAudioFileWriter) {
                TDebug.out("input format is not supported directely; trying to find a convertable format");
            }
            if ((audioFormat = this.findConvertableFormat(audioFormat2, (AudioFileFormat.Type)object)) != null) {
                bl = true;
                if (audioFormat.getSampleSizeInBits() == 8 && audioFormat.getEncoding().equals(audioFormat2.getEncoding())) {
                    bl = false;
                }
            } else {
                if (TDebug.TraceAudioFileWriter) {
                    TDebug.out("< input format is not supported and not convertable.");
                }
                throw new IllegalArgumentException("format not supported and not convertable");
            }
        }
        long l2 = AudioUtils.getLengthInBytes(audioInputStream);
        object2 = new TSeekableDataOutputStream((File)object2);
        object = this.getAudioOutputStream(audioFormat, l2, (AudioFileFormat.Type)object, (TDataOutputStream)object2);
        int n2 = this.writeImpl(audioInputStream, (AudioOutputStream)object, bl);
        if (TDebug.TraceAudioFileWriter) {
            TDebug.out("< wrote " + n2 + " bytes.");
        }
        return n2;
    }

    @Override
    public int write(AudioInputStream audioInputStream, AudioFileFormat.Type object, OutputStream outputStream) {
        boolean bl;
        AudioFormat audioFormat;
        if (!this.isFileTypeSupported((AudioFileFormat.Type)object)) {
            throw new IllegalArgumentException("file type is not supported.");
        }
        if (TDebug.TraceAudioFileWriter) {
            TDebug.out(">TAudioFileWriter.write(.., OutputStream): called");
            TDebug.out("class: " + this.getClass().getName());
        }
        AudioFormat audioFormat2 = audioInputStream.getFormat();
        if (TDebug.TraceAudioFileWriter) {
            TDebug.out("input format: " + audioFormat2);
        }
        if (this.isAudioFormatSupportedImpl(audioFormat2, (AudioFileFormat.Type)object)) {
            if (TDebug.TraceAudioFileWriter) {
                TDebug.out("input format is supported directely");
            }
            audioFormat = audioFormat2;
            bl = false;
        } else {
            if (TDebug.TraceAudioFileWriter) {
                TDebug.out("input format is not supported directely; trying to find a convertable format");
            }
            if ((audioFormat = this.findConvertableFormat(audioFormat2, (AudioFileFormat.Type)object)) != null) {
                bl = true;
                if (audioFormat.getSampleSizeInBits() == 8 && audioFormat.getEncoding().equals(audioFormat2.getEncoding())) {
                    bl = false;
                }
            } else {
                if (TDebug.TraceAudioFileWriter) {
                    TDebug.out("< format is not supported");
                }
                throw new IllegalArgumentException("format not supported and not convertable");
            }
        }
        long l2 = AudioUtils.getLengthInBytes(audioInputStream);
        outputStream = new TNonSeekableDataOutputStream(outputStream);
        object = this.getAudioOutputStream(audioFormat, l2, (AudioFileFormat.Type)object, (TDataOutputStream)((Object)outputStream));
        int n2 = this.writeImpl(audioInputStream, (AudioOutputStream)object, bl);
        if (TDebug.TraceAudioFileWriter) {
            TDebug.out("< wrote " + n2 + " bytes.");
        }
        return n2;
    }

    protected int writeImpl(AudioInputStream audioInputStream, AudioOutputStream audioOutputStream, boolean bl) {
        if (TDebug.TraceAudioFileWriter) {
            TDebug.out(">TAudioFileWriter.writeImpl(): called");
            TDebug.out("class: " + this.getClass().getName());
        }
        int n2 = 0;
        audioInputStream.getFormat();
        AudioFormat audioFormat = audioOutputStream.getFormat();
        int n3 = audioFormat.getFrameSize() / audioFormat.getChannels();
        int n4 = 16384 / audioFormat.getFrameSize() * audioFormat.getFrameSize();
        byte[] byArray = new byte[n4];
        while (true) {
            if (TDebug.TraceAudioFileWriter) {
                TDebug.out("trying to read (bytes): " + n4);
            }
            int n5 = audioInputStream.read(byArray);
            if (TDebug.TraceAudioFileWriter) {
                TDebug.out("read (bytes): " + n5);
            }
            if (n5 == -1) break;
            if (bl) {
                TConversionTool.changeOrderOrSign(byArray, 0, n5, n3);
            }
            n5 = audioOutputStream.write(byArray, 0, n5);
            n2 += n5;
        }
        if (TDebug.TraceAudioFileWriter) {
            TDebug.out("<TAudioFileWriter.writeImpl(): after main loop. Wrote " + n2 + " bytes");
        }
        audioOutputStream.close();
        return n2;
    }

    protected Iterator getSupportedAudioFormats(AudioFileFormat.Type type) {
        return this.m_audioFormats.iterator();
    }

    protected boolean isAudioFormatSupportedImpl(AudioFormat audioFormat, AudioFileFormat.Type object) {
        if (TDebug.TraceAudioFileWriter) {
            TDebug.out("> TAudioFileWriter.isAudioFormatSupportedImpl(): format to test: " + audioFormat);
            TDebug.out("class: " + this.getClass().getName());
        }
        object = this.getSupportedAudioFormats((AudioFileFormat.Type)object);
        while (object.hasNext()) {
            AudioFormat audioFormat2 = (AudioFormat)object.next();
            if (TDebug.TraceAudioFileWriter) {
                TDebug.out("matching against format : " + audioFormat2);
            }
            if (!AudioFormats.matches(audioFormat2, audioFormat)) continue;
            if (TDebug.TraceAudioFileWriter) {
                TDebug.out("<...succeeded.");
            }
            return true;
        }
        if (TDebug.TraceAudioFileWriter) {
            TDebug.out("< ... failed");
        }
        return false;
    }

    protected abstract AudioOutputStream getAudioOutputStream(AudioFormat var1, long var2, AudioFileFormat.Type var4, TDataOutputStream var5);

    private AudioFormat findConvertableFormat(AudioFormat audioFormat, AudioFileFormat.Type type) {
        if (TDebug.TraceAudioFileWriter) {
            TDebug.out("TAudioFileWriter.findConvertableFormat(): input format: " + audioFormat);
        }
        if (!this.isFileTypeSupported(type)) {
            if (TDebug.TraceAudioFileWriter) {
                TDebug.out("< input file type is not supported.");
            }
            return null;
        }
        Object object = audioFormat.getEncoding();
        if ((((AudioFormat.Encoding)object).equals(PCM_SIGNED) || ((AudioFormat.Encoding)object).equals(PCM_UNSIGNED)) && audioFormat.getSampleSizeInBits() == 8) {
            object = this.convertFormat(audioFormat, true, false);
            if (TDebug.TraceAudioFileWriter) {
                TDebug.out("trying output format: " + object);
            }
            if (this.isAudioFormatSupportedImpl((AudioFormat)object, type)) {
                if (TDebug.TraceAudioFileWriter) {
                    TDebug.out("< ... succeeded");
                }
                return object;
            }
            object = this.convertFormat(audioFormat, false, true);
            if (TDebug.TraceAudioFileWriter) {
                TDebug.out("trying output format: " + object);
            }
            if (this.isAudioFormatSupportedImpl((AudioFormat)object, type)) {
                if (TDebug.TraceAudioFileWriter) {
                    TDebug.out("< ... succeeded");
                }
                return object;
            }
            object = this.convertFormat(audioFormat, true, true);
            if (TDebug.TraceAudioFileWriter) {
                TDebug.out("trying output format: " + object);
            }
            if (this.isAudioFormatSupportedImpl((AudioFormat)object, type)) {
                if (TDebug.TraceAudioFileWriter) {
                    TDebug.out("< ... succeeded");
                }
                return object;
            }
            if (TDebug.TraceAudioFileWriter) {
                TDebug.out("< ... failed");
            }
            return null;
        }
        if (((AudioFormat.Encoding)object).equals(PCM_SIGNED) && (audioFormat.getSampleSizeInBits() == 16 || audioFormat.getSampleSizeInBits() == 24 || audioFormat.getSampleSizeInBits() == 32)) {
            object = this.convertFormat(audioFormat, false, true);
            if (TDebug.TraceAudioFileWriter) {
                TDebug.out("trying output format: " + object);
            }
            if (this.isAudioFormatSupportedImpl((AudioFormat)object, type)) {
                if (TDebug.TraceAudioFileWriter) {
                    TDebug.out("< ... succeeded");
                }
                return object;
            }
            if (TDebug.TraceAudioFileWriter) {
                TDebug.out("< ... failed");
            }
            return null;
        }
        if (TDebug.TraceAudioFileWriter) {
            TDebug.out("< ... failed");
        }
        return null;
    }

    private AudioFormat convertFormat(AudioFormat audioFormat, boolean bl, boolean bl2) {
        AudioFormat.Encoding encoding = PCM_SIGNED;
        if (audioFormat.getEncoding().equals(PCM_UNSIGNED) != bl) {
            encoding = PCM_UNSIGNED;
        }
        return new AudioFormat(encoding, audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getFrameSize(), audioFormat.getFrameRate(), audioFormat.isBigEndian() ^ bl2);
    }
}

