/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share.sampled.convert;

import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.AudioUtils;
import org.tritonus.share.sampled.convert.TAudioInputStream;

public abstract class TSynchronousFilteredAudioInputStream
extends TAudioInputStream {
    private AudioInputStream originalStream;
    private AudioFormat originalFormat;
    private int originalFrameSize;
    private int newFrameSize;
    protected byte[] buffer = null;
    private boolean m_bConvertInPlace = false;

    public TSynchronousFilteredAudioInputStream(AudioInputStream audioInputStream, AudioFormat audioFormat) {
        super(audioInputStream, audioFormat, audioInputStream.getFrameLength());
        this.originalStream = audioInputStream;
        this.originalFormat = audioInputStream.getFormat();
        this.originalFrameSize = this.originalFormat.getFrameSize() <= 0 ? 1 : this.originalFormat.getFrameSize();
        int n2 = this.newFrameSize = this.getFormat().getFrameSize() <= 0 ? 1 : this.getFormat().getFrameSize();
        if (TDebug.TraceAudioConverter) {
            TDebug.out("TSynchronousFilteredAudioInputStream: original format =" + AudioUtils.format2ShortStr(this.originalFormat));
            TDebug.out("TSynchronousFilteredAudioInputStream: converted format=" + AudioUtils.format2ShortStr(this.getFormat()));
        }
        this.m_bConvertInPlace = false;
    }

    protected boolean enableConvertInPlace() {
        if (this.newFrameSize >= this.originalFrameSize) {
            this.m_bConvertInPlace = true;
        }
        return this.m_bConvertInPlace;
    }

    protected abstract int convert(byte[] var1, byte[] var2, int var3, int var4);

    protected void convertInPlace(byte[] byArray, int n2, int n3) {
        throw new RuntimeException("Illegal call to convertInPlace");
    }

    @Override
    public int read() {
        if (this.newFrameSize != 1) {
            throw new IOException("frame size must be 1 to read a single byte");
        }
        byte[] byArray = new byte[1];
        int n2 = this.read(byArray);
        if (n2 == -1) {
            return -1;
        }
        if (n2 == 0) {
            return -1;
        }
        return byArray[0] & 0xFF;
    }

    private void clearBuffer() {
        this.buffer = null;
    }

    public AudioInputStream getOriginalStream() {
        return this.originalStream;
    }

    public AudioFormat getOriginalFormat() {
        return this.originalFormat;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        int n4;
        byte[] byArray2;
        int n5 = n3 / this.newFrameSize;
        int n6 = n5 * this.originalFrameSize;
        if (TDebug.TraceAudioConverter) {
            TDebug.out("> TSynchronousFilteredAIS.read(buffer[" + byArray.length + "], " + n2 + " ," + n3 + " bytes ^=" + n5 + " frames)");
        }
        if (this.m_bConvertInPlace) {
            byArray2 = byArray;
            n5 = n2;
        } else {
            if (this.buffer == null || this.buffer.length < n6) {
                this.buffer = new byte[n6];
            }
            byArray2 = this.buffer;
            n5 = 0;
        }
        int n7 = this.originalStream.read(byArray2, n5, n6);
        if (n7 == -1) {
            this.clearBuffer();
            return -1;
        }
        n5 = n7 / this.originalFrameSize;
        if (TDebug.TraceAudioConverter) {
            TDebug.out("original.read returned " + n7 + " bytes ^=" + n5 + " frames");
        }
        if (this.m_bConvertInPlace) {
            this.convertInPlace(byArray, n2, n5);
            n4 = n5;
        } else {
            n4 = this.convert(this.buffer, byArray, n2, n5);
        }
        if (TDebug.TraceAudioConverter) {
            TDebug.out("< converted " + n4 + " frames");
        }
        return n4 * this.newFrameSize;
    }

    @Override
    public long skip(long l2) {
        long l3 = l2 / (long)this.newFrameSize;
        return this.originalStream.skip(l3 * (long)this.originalFrameSize) / (long)this.originalFrameSize * (long)this.newFrameSize;
    }

    @Override
    public int available() {
        return this.originalStream.available() / this.originalFrameSize * this.newFrameSize;
    }

    @Override
    public void close() {
        this.originalStream.close();
        this.clearBuffer();
    }

    @Override
    public void mark(int n2) {
        this.originalStream.mark((n2 /= this.newFrameSize) * this.originalFrameSize);
    }

    @Override
    public void reset() {
        this.originalStream.reset();
    }

    @Override
    public boolean markSupported() {
        return this.originalStream.markSupported();
    }

    private int getFrameSize() {
        return this.getFormat().getFrameSize();
    }
}

