/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share.sampled.convert;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import org.tritonus.share.TCircularBuffer;
import org.tritonus.share.TCircularBuffer$Trigger;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.convert.TAudioInputStream;

public abstract class TAsynchronousFilteredAudioInputStream
extends TAudioInputStream
implements TCircularBuffer$Trigger {
    private static final int DEFAULT_BUFFER_SIZE = 327670;
    private static final int DEFAULT_MIN_AVAILABLE = 4096;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private TCircularBuffer m_circularBuffer;
    private int m_nMinAvailable;
    private byte[] m_abSingleByte;

    public TAsynchronousFilteredAudioInputStream(AudioFormat audioFormat, long l2) {
        this(audioFormat, l2, 327670, 4096);
    }

    public TAsynchronousFilteredAudioInputStream(AudioFormat audioFormat, long l2, int n2, int n3) {
        super(new ByteArrayInputStream(EMPTY_BYTE_ARRAY), audioFormat, l2);
        if (TDebug.TraceAudioConverter) {
            TDebug.out("TAsynchronousFilteredAudioInputStream.<init>(): begin");
        }
        this.m_circularBuffer = new TCircularBuffer(n2, false, true, this);
        this.m_nMinAvailable = n3;
        if (TDebug.TraceAudioConverter) {
            TDebug.out("TAsynchronousFilteredAudioInputStream.<init>(): end");
        }
    }

    public TCircularBuffer getCircularBuffer() {
        return this.m_circularBuffer;
    }

    public boolean writeMore() {
        return this.getCircularBuffer().availableWrite() > this.m_nMinAvailable;
    }

    @Override
    public int read() {
        if (this.m_abSingleByte == null) {
            this.m_abSingleByte = new byte[1];
        }
        int n2 = this.read(this.m_abSingleByte) == -1 ? -1 : this.m_abSingleByte[0] & 0xFF;
        return n2;
    }

    @Override
    public int read(byte[] byArray) {
        if (TDebug.TraceAudioConverter) {
            TDebug.out("TAsynchronousFilteredAudioInputStream.read(byte[]): begin");
        }
        int n2 = this.read(byArray, 0, byArray.length);
        if (TDebug.TraceAudioConverter) {
            TDebug.out("TAsynchronousFilteredAudioInputStream.read(byte[]): end");
        }
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        if (TDebug.TraceAudioConverter) {
            TDebug.out("TAsynchronousFilteredAudioInputStream.read(byte[], int, int): begin");
        }
        int n4 = this.m_circularBuffer.read(byArray, n2, n3);
        if (TDebug.TraceAudioConverter) {
            TDebug.out("TAsynchronousFilteredAudioInputStream.read(byte[], int, int): end");
        }
        return n4;
    }

    @Override
    public long skip(long l2) {
        for (long i2 = 0L; i2 < l2; ++i2) {
            if (this.read() != -1) continue;
            return i2;
        }
        return l2;
    }

    @Override
    public int available() {
        return this.m_circularBuffer.availableRead();
    }

    @Override
    public void close() {
        this.m_circularBuffer.close();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int n2) {
    }

    @Override
    public void reset() {
        throw new IOException("mark not supported");
    }
}

