/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share.sampled;

import java.util.Iterator;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import org.tritonus.share.sampled.AudioFormats;

public class AudioUtils {
    public static long getLengthInBytes(AudioInputStream audioInputStream) {
        return AudioUtils.getLengthInBytes(audioInputStream.getFormat(), audioInputStream.getFrameLength());
    }

    public static long getLengthInBytes(AudioFormat audioFormat, long l2) {
        int n2 = audioFormat.getFrameSize();
        if (l2 >= 0L && n2 > 0) {
            return l2 * (long)n2;
        }
        return -1L;
    }

    public static boolean containsFormat(AudioFormat audioFormat, Iterator iterator) {
        while (iterator.hasNext()) {
            if (!AudioFormats.matches((AudioFormat)iterator.next(), audioFormat)) continue;
            return true;
        }
        return false;
    }

    public static long millis2Bytes(long l2, AudioFormat audioFormat) {
        return AudioUtils.millis2Bytes(l2, audioFormat.getFrameRate(), audioFormat.getFrameSize());
    }

    public static long millis2Bytes(long l2, float f2, int n2) {
        return (long)((float)l2 * f2 / 1000.0f * (float)n2);
    }

    public static long millis2BytesFrameAligned(long l2, AudioFormat audioFormat) {
        return AudioUtils.millis2BytesFrameAligned(l2, audioFormat.getFrameRate(), audioFormat.getFrameSize());
    }

    public static long millis2BytesFrameAligned(long l2, float f2, int n2) {
        return (long)((float)l2 * f2 / 1000.0f) * (long)n2;
    }

    public static long millis2Frames(long l2, AudioFormat audioFormat) {
        return AudioUtils.millis2Frames(l2, audioFormat.getFrameRate());
    }

    public static long millis2Frames(long l2, float f2) {
        return (long)((float)l2 * f2 / 1000.0f);
    }

    public static long bytes2Millis(long l2, AudioFormat audioFormat) {
        return (long)((float)l2 / audioFormat.getFrameRate() * 1000.0f / (float)audioFormat.getFrameSize());
    }

    public static long frames2Millis(long l2, AudioFormat audioFormat) {
        return (long)((float)l2 / audioFormat.getFrameRate() * 1000.0f);
    }

    public static String NS_or_number(int n2) {
        if (n2 == -1) {
            return "NOT_SPECIFIED";
        }
        return String.valueOf(n2);
    }

    public static String NS_or_number(float f2) {
        if (f2 == -1.0f) {
            return "NOT_SPECIFIED";
        }
        return String.valueOf(f2);
    }

    public static String format2ShortStr(AudioFormat audioFormat) {
        return audioFormat.getEncoding() + "-" + AudioUtils.NS_or_number(audioFormat.getChannels()) + "ch-" + AudioUtils.NS_or_number(audioFormat.getSampleSizeInBits()) + "bit-" + AudioUtils.NS_or_number((int)audioFormat.getSampleRate()) + "Hz-" + (audioFormat.isBigEndian() ? "be" : "le");
    }
}

