/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share.sampled;

import java.util.Collection;
import java.util.Iterator;
import javax.sound.sampled.AudioFormat;
import org.tritonus.share.ArraySet;
import org.tritonus.share.sampled.AudioFormats;

public class AudioFormatSet
extends ArraySet {
    protected static final AudioFormat[] EMPTY_FORMAT_ARRAY = new AudioFormat[0];

    public AudioFormatSet() {
    }

    public AudioFormatSet(Collection collection) {
        super(collection);
    }

    @Override
    public boolean add(AudioFormat audioFormat) {
        if (audioFormat == null || !(audioFormat instanceof AudioFormat)) {
            return false;
        }
        return super.add(audioFormat);
    }

    public boolean contains(AudioFormat audioFormat) {
        if (audioFormat == null || !(audioFormat instanceof AudioFormat)) {
            return false;
        }
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!AudioFormats.equals(audioFormat, (AudioFormat)iterator.next())) continue;
            return true;
        }
        return false;
    }

    public AudioFormat get(AudioFormat audioFormat) {
        if (audioFormat == null || !(audioFormat instanceof AudioFormat)) {
            return null;
        }
        for (AudioFormat audioFormat2 : this) {
            if (!AudioFormats.equals(audioFormat, audioFormat2)) continue;
            return audioFormat2;
        }
        return null;
    }

    public AudioFormat getAudioFormat(AudioFormat audioFormat) {
        return this.get(audioFormat);
    }

    public AudioFormat matches(AudioFormat audioFormat) {
        if (audioFormat == null) {
            return null;
        }
        for (AudioFormat audioFormat2 : this) {
            if (!AudioFormats.matches(audioFormat, audioFormat2)) continue;
            return audioFormat2;
        }
        return null;
    }

    public AudioFormat[] toAudioFormatArray() {
        return this.toArray(EMPTY_FORMAT_ARRAY);
    }

    @Override
    public void add(int n2, AudioFormat audioFormat) {
        throw new UnsupportedOperationException("unsupported");
    }

    @Override
    public AudioFormat set(int n2, AudioFormat audioFormat) {
        throw new UnsupportedOperationException("unsupported");
    }
}

