/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share;

import org.tritonus.share.TCircularBuffer$Trigger;
import org.tritonus.share.TDebug;

public class TCircularBuffer {
    private boolean m_bBlockingRead;
    private boolean m_bBlockingWrite;
    private byte[] m_abData;
    private int m_nSize;
    private long m_lReadPos;
    private long m_lWritePos;
    private TCircularBuffer$Trigger m_trigger;
    private boolean m_bOpen;

    public TCircularBuffer(int n2, boolean bl, boolean bl2, TCircularBuffer$Trigger tCircularBuffer$Trigger) {
        this.m_bBlockingRead = bl;
        this.m_bBlockingWrite = bl2;
        this.m_nSize = n2;
        this.m_abData = new byte[this.m_nSize];
        this.m_lReadPos = 0L;
        this.m_lWritePos = 0L;
        this.m_trigger = tCircularBuffer$Trigger;
        this.m_bOpen = true;
    }

    public void close() {
        this.m_bOpen = false;
    }

    private boolean isOpen() {
        return this.m_bOpen;
    }

    public int availableRead() {
        return (int)(this.m_lWritePos - this.m_lReadPos);
    }

    public int availableWrite() {
        return this.m_nSize - this.availableRead();
    }

    private int getReadPos() {
        return (int)(this.m_lReadPos % (long)this.m_nSize);
    }

    private int getWritePos() {
        return (int)(this.m_lWritePos % (long)this.m_nSize);
    }

    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] byArray, int n2, int n3) {
        if (TDebug.TraceCircularBuffer) {
            TDebug.out(">TCircularBuffer.read(): called.");
            this.dumpInternalState();
        }
        if (!this.isOpen()) {
            if (this.availableRead() > 0) {
                n3 = Math.min(n3, this.availableRead());
                if (TDebug.TraceCircularBuffer) {
                    TDebug.out("reading rest in closed buffer, length: " + n3);
                }
            } else {
                if (TDebug.TraceCircularBuffer) {
                    TDebug.out("< not open. returning -1.");
                }
                return -1;
            }
        }
        TCircularBuffer tCircularBuffer = this;
        synchronized (tCircularBuffer) {
            if (this.m_trigger != null && this.availableRead() < n3) {
                if (TDebug.TraceCircularBuffer) {
                    TDebug.out("executing trigger.");
                }
                this.m_trigger.execute();
            }
            if (!this.m_bBlockingRead) {
                n3 = Math.min(this.availableRead(), n3);
            }
            int n4 = n3;
            while (n4 > 0) {
                while (this.availableRead() == 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        if (!TDebug.TraceAllExceptions) continue;
                        TDebug.out(interruptedException);
                    }
                }
                int n5 = Math.min(this.availableRead(), n4);
                while (n5 > 0) {
                    int n6 = Math.min(n5, this.m_nSize - this.getReadPos());
                    System.arraycopy(this.m_abData, this.getReadPos(), byArray, n2, n6);
                    this.m_lReadPos += (long)n6;
                    n2 += n6;
                    n5 -= n6;
                    n4 -= n6;
                }
                this.notifyAll();
            }
            if (TDebug.TraceCircularBuffer) {
                TDebug.out("After read:");
                this.dumpInternalState();
                TDebug.out("< completed. Read " + n3 + " bytes");
            }
            return n3;
        }
    }

    public int write(byte[] byArray) {
        return this.write(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(byte[] byArray, int n2, int n3) {
        if (TDebug.TraceCircularBuffer) {
            TDebug.out(">TCircularBuffer.write(): called; nLength: " + n3);
            this.dumpInternalState();
        }
        TCircularBuffer tCircularBuffer = this;
        synchronized (tCircularBuffer) {
            if (TDebug.TraceCircularBuffer) {
                TDebug.out("entered synchronized block.");
            }
            if (!this.m_bBlockingWrite) {
                n3 = Math.min(this.availableWrite(), n3);
            }
            int n4 = n3;
            while (n4 > 0) {
                while (this.availableWrite() == 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        if (!TDebug.TraceAllExceptions) continue;
                        TDebug.out(interruptedException);
                    }
                }
                int n5 = Math.min(this.availableWrite(), n4);
                while (n5 > 0) {
                    int n6 = Math.min(n5, this.m_nSize - this.getWritePos());
                    System.arraycopy(byArray, n2, this.m_abData, this.getWritePos(), n6);
                    this.m_lWritePos += (long)n6;
                    n2 += n6;
                    n5 -= n6;
                    n4 -= n6;
                }
                this.notifyAll();
            }
            if (TDebug.TraceCircularBuffer) {
                TDebug.out("After write:");
                this.dumpInternalState();
                TDebug.out("< completed. Wrote " + n3 + " bytes");
            }
            return n3;
        }
    }

    private void dumpInternalState() {
        TDebug.out("m_lReadPos  = " + this.m_lReadPos + " ^= " + this.getReadPos());
        TDebug.out("m_lWritePos = " + this.m_lWritePos + " ^= " + this.getWritePos());
        TDebug.out("availableRead()  = " + this.availableRead());
        TDebug.out("availableWrite() = " + this.availableWrite());
    }
}

