/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.convert.jorbis;

import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import org.tritonus.sampled.convert.jorbis.JorbisFormatConversionProvider$DecodedJorbisAudioInputStream;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.AudioFormats;
import org.tritonus.share.sampled.convert.TEncodingFormatConversionProvider;

public class JorbisFormatConversionProvider
extends TEncodingFormatConversionProvider {
    private static final AudioFormat.Encoding VORBIS = new AudioFormat.Encoding("VORBIS");
    private static final AudioFormat.Encoding PCM_SIGNED = new AudioFormat.Encoding("PCM_SIGNED");
    private static final AudioFormat[] INPUT_FORMATS = new AudioFormat[]{new AudioFormat(VORBIS, -1.0f, -1, 1, -1, -1.0f, false), new AudioFormat(VORBIS, -1.0f, -1, 1, -1, -1.0f, true), new AudioFormat(VORBIS, -1.0f, -1, 2, -1, -1.0f, false), new AudioFormat(VORBIS, -1.0f, -1, 2, -1, -1.0f, true)};
    private static final AudioFormat[] OUTPUT_FORMATS = new AudioFormat[]{new AudioFormat(PCM_SIGNED, -1.0f, 16, 1, 2, -1.0f, false), new AudioFormat(PCM_SIGNED, -1.0f, 16, 1, 2, -1.0f, true), new AudioFormat(PCM_SIGNED, -1.0f, 16, 2, 4, -1.0f, false), new AudioFormat(PCM_SIGNED, -1.0f, 16, 2, 4, -1.0f, true)};

    public JorbisFormatConversionProvider() {
        super(Arrays.asList(INPUT_FORMATS), Arrays.asList(OUTPUT_FORMATS));
    }

    @Override
    public AudioInputStream getAudioInputStream(AudioFormat object, AudioInputStream audioInputStream) {
        if (TDebug.TraceAudioConverter) {
            TDebug.out(">JorbisFormatConversionProvider.getAudioInputStream(): begin");
            TDebug.out("checking if conversion supported");
            TDebug.out("from: " + audioInputStream.getFormat());
            TDebug.out("to: " + object);
        }
        if (this.isConversionSupported((AudioFormat)(object = this.getDefaultTargetFormat((AudioFormat)object, audioInputStream.getFormat())), audioInputStream.getFormat())) {
            if (TDebug.TraceAudioConverter) {
                TDebug.out("conversion supported; trying to create DecodedJorbisAudioInputStream");
            }
        } else {
            if (TDebug.TraceAudioConverter) {
                TDebug.out("conversion not supported; throwing IllegalArgumentException");
                TDebug.out("<");
            }
            throw new IllegalArgumentException("conversion not supported");
        }
        object = new JorbisFormatConversionProvider$DecodedJorbisAudioInputStream((AudioFormat)object, audioInputStream);
        if (TDebug.TraceAudioConverter) {
            TDebug.out("<JorbisFormatConversionProvider.getAudioInputStream(): end");
        }
        return object;
    }

    protected AudioFormat getDefaultTargetFormat(AudioFormat audioFormat, AudioFormat audioFormat2) {
        if (TDebug.TraceAudioConverter) {
            TDebug.out("JorbisFormatConversionProvider.getDefaultTargetFormat(): target format: " + audioFormat);
        }
        if (TDebug.TraceAudioConverter) {
            TDebug.out("JorbisFormatConversionProvider.getDefaultTargetFormat(): source format: " + audioFormat2);
        }
        AudioFormat audioFormat3 = null;
        for (AudioFormat audioFormat4 : this.getCollectionTargetFormats()) {
            if (!AudioFormats.matches(audioFormat, audioFormat4)) continue;
            audioFormat3 = audioFormat4;
        }
        if (audioFormat3 == null) {
            throw new IllegalArgumentException("conversion not supported");
        }
        if (TDebug.TraceAudioConverter) {
            TDebug.out("JorbisFormatConversionProvider.getDefaultTargetFormat(): new target format: " + audioFormat3);
        }
        audioFormat3 = new AudioFormat(audioFormat.getEncoding(), audioFormat2.getSampleRate(), audioFormat3.getSampleSizeInBits(), audioFormat3.getChannels(), audioFormat3.getFrameSize(), audioFormat2.getSampleRate(), audioFormat3.isBigEndian());
        if (TDebug.TraceAudioConverter) {
            TDebug.out("JorbisFormatConversionProvider.getDefaultTargetFormat(): really new target format: " + audioFormat3);
        }
        return audioFormat3;
    }
}

