/*
 * Decompiled with CFR 0.152.
 */
package javax.media.opengl;

import java.io.PrintStream;
import java.lang.reflect.Array;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import javax.media.opengl.GL;

public class TraceGL
implements GL {
    private PrintStream stream;
    private int indent = 0;
    private GL downstreamGL;

    public TraceGL(GL gL, PrintStream printStream) {
        if (gL == null) {
            throw new IllegalArgumentException("null downstreamGL");
        }
        this.downstreamGL = gL;
        this.stream = printStream;
    }

    @Override
    public void glBegin(int n2) {
        this.printIndent();
        this.print("glBegin(" + n2 + ")");
        this.downstreamGL.glBegin(n2);
        this.println("");
    }

    @Override
    public void glAccum(int n2, float f2) {
        this.printIndent();
        this.print("glAccum(" + n2 + "," + f2 + ")");
        this.downstreamGL.glAccum(n2, f2);
        this.println("");
    }

    @Override
    public void glActiveStencilFaceEXT(int n2) {
        this.printIndent();
        this.print("glActiveStencilFaceEXT(" + n2 + ")");
        this.downstreamGL.glActiveStencilFaceEXT(n2);
        this.println("");
    }

    @Override
    public void glActiveTexture(int n2) {
        this.printIndent();
        this.print("glActiveTexture(" + n2 + ")");
        this.downstreamGL.glActiveTexture(n2);
        this.println("");
    }

    @Override
    public void glActiveVaryingNV(int n2, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glActiveVaryingNV(" + n2 + "," + byteBuffer + ")");
        this.downstreamGL.glActiveVaryingNV(n2, byteBuffer);
        this.println("");
    }

    @Override
    public void glActiveVaryingNV(int n2, byte[] byArray, int n3) {
        this.printIndent();
        this.print("glActiveVaryingNV(" + n2 + "," + this.dumpArray(byArray) + "," + n3 + ")");
        this.downstreamGL.glActiveVaryingNV(n2, byArray, n3);
        this.println("");
    }

    @Override
    public void glAlphaFragmentOp1ATI(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.printIndent();
        this.print("glAlphaFragmentOp1ATI(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + ")");
        this.downstreamGL.glAlphaFragmentOp1ATI(n2, n3, n4, n5, n6, n7);
        this.println("");
    }

    @Override
    public void glAlphaFragmentOp2ATI(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        this.printIndent();
        this.print("glAlphaFragmentOp2ATI(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + ")");
        this.downstreamGL.glAlphaFragmentOp2ATI(n2, n3, n4, n5, n6, n7, n8, n9, n10);
        this.println("");
    }

    @Override
    public void glAlphaFragmentOp3ATI(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13) {
        this.printIndent();
        this.print("glAlphaFragmentOp3ATI(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + n11 + "," + n12 + "," + n13 + ")");
        this.downstreamGL.glAlphaFragmentOp3ATI(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13);
        this.println("");
    }

    @Override
    public void glAlphaFunc(int n2, float f2) {
        this.printIndent();
        this.print("glAlphaFunc(" + n2 + "," + f2 + ")");
        this.downstreamGL.glAlphaFunc(n2, f2);
        this.println("");
    }

    @Override
    public void glApplyTextureEXT(int n2) {
        this.printIndent();
        this.print("glApplyTextureEXT(" + n2 + ")");
        this.downstreamGL.glApplyTextureEXT(n2);
        this.println("");
    }

    @Override
    public boolean glAreProgramsResidentNV(int n2, IntBuffer intBuffer, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glAreProgramsResidentNV(" + n2 + "," + intBuffer + "," + byteBuffer + ")");
        n2 = this.downstreamGL.glAreProgramsResidentNV(n2, intBuffer, byteBuffer) ? 1 : 0;
        this.println(" = " + (n2 != 0));
        return n2 != 0;
    }

    @Override
    public boolean glAreProgramsResidentNV(int n2, int[] nArray, int n3, byte[] byArray, int n4) {
        this.printIndent();
        this.print("glAreProgramsResidentNV(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + "," + this.dumpArray(byArray) + "," + n4 + ")");
        n2 = this.downstreamGL.glAreProgramsResidentNV(n2, nArray, n3, byArray, n4) ? 1 : 0;
        this.println(" = " + (n2 != 0));
        return n2 != 0;
    }

    @Override
    public boolean glAreTexturesResident(int n2, IntBuffer intBuffer, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glAreTexturesResident(" + n2 + "," + intBuffer + "," + byteBuffer + ")");
        n2 = this.downstreamGL.glAreTexturesResident(n2, intBuffer, byteBuffer) ? 1 : 0;
        this.println(" = " + (n2 != 0));
        return n2 != 0;
    }

    @Override
    public boolean glAreTexturesResident(int n2, int[] nArray, int n3, byte[] byArray, int n4) {
        this.printIndent();
        this.print("glAreTexturesResident(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + "," + this.dumpArray(byArray) + "," + n4 + ")");
        n2 = this.downstreamGL.glAreTexturesResident(n2, nArray, n3, byArray, n4) ? 1 : 0;
        this.println(" = " + (n2 != 0));
        return n2 != 0;
    }

    @Override
    public void glArrayElement(int n2) {
        this.printIndent();
        this.print("glArrayElement(" + n2 + ")");
        this.downstreamGL.glArrayElement(n2);
        this.println("");
    }

    @Override
    public void glArrayObjectATI(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.printIndent();
        this.print("glArrayObjectATI(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + ")");
        this.downstreamGL.glArrayObjectATI(n2, n3, n4, n5, n6, n7);
        this.println("");
    }

    @Override
    public void glAsyncMarkerSGIX(int n2) {
        this.printIndent();
        this.print("glAsyncMarkerSGIX(" + n2 + ")");
        this.downstreamGL.glAsyncMarkerSGIX(n2);
        this.println("");
    }

    @Override
    public void glAttachObjectARB(int n2, int n3) {
        this.printIndent();
        this.print("glAttachObjectARB(" + n2 + "," + n3 + ")");
        this.downstreamGL.glAttachObjectARB(n2, n3);
        this.println("");
    }

    @Override
    public void glAttachShader(int n2, int n3) {
        this.printIndent();
        this.print("glAttachShader(" + n2 + "," + n3 + ")");
        this.downstreamGL.glAttachShader(n2, n3);
        this.println("");
    }

    @Override
    public void glBeginFragmentShaderATI() {
        this.printIndent();
        this.print("glBeginFragmentShaderATI()");
        this.downstreamGL.glBeginFragmentShaderATI();
        this.println("");
    }

    @Override
    public void glBeginOcclusionQueryNV(int n2) {
        this.printIndent();
        this.print("glBeginOcclusionQueryNV(" + n2 + ")");
        this.downstreamGL.glBeginOcclusionQueryNV(n2);
        this.println("");
    }

    @Override
    public void glBeginQuery(int n2, int n3) {
        this.printIndent();
        this.print("glBeginQuery(" + n2 + "," + n3 + ")");
        this.downstreamGL.glBeginQuery(n2, n3);
        this.println("");
    }

    @Override
    public void glBeginQueryARB(int n2, int n3) {
        this.printIndent();
        this.print("glBeginQueryARB(" + n2 + "," + n3 + ")");
        this.downstreamGL.glBeginQueryARB(n2, n3);
        this.println("");
    }

    @Override
    public void glBeginTransformFeedbackNV(int n2) {
        this.printIndent();
        this.print("glBeginTransformFeedbackNV(" + n2 + ")");
        this.downstreamGL.glBeginTransformFeedbackNV(n2);
        this.println("");
    }

    @Override
    public void glBeginVertexShaderEXT() {
        this.printIndent();
        this.print("glBeginVertexShaderEXT()");
        this.downstreamGL.glBeginVertexShaderEXT();
        this.println("");
    }

    @Override
    public void glBindAttribLocation(int n2, int n3, String string) {
        this.printIndent();
        this.print("glBindAttribLocation(" + n2 + "," + n3 + "," + string + ")");
        this.downstreamGL.glBindAttribLocation(n2, n3, string);
        this.println("");
    }

    @Override
    public void glBindAttribLocationARB(int n2, int n3, String string) {
        this.printIndent();
        this.print("glBindAttribLocationARB(" + n2 + "," + n3 + "," + string + ")");
        this.downstreamGL.glBindAttribLocationARB(n2, n3, string);
        this.println("");
    }

    @Override
    public void glBindBuffer(int n2, int n3) {
        this.printIndent();
        this.print("glBindBuffer(" + n2 + "," + n3 + ")");
        this.downstreamGL.glBindBuffer(n2, n3);
        this.println("");
    }

    @Override
    public void glBindBufferARB(int n2, int n3) {
        this.printIndent();
        this.print("glBindBufferARB(" + n2 + "," + n3 + ")");
        this.downstreamGL.glBindBufferARB(n2, n3);
        this.println("");
    }

    @Override
    public void glBindBufferBaseNV(int n2, int n3, int n4) {
        this.printIndent();
        this.print("glBindBufferBaseNV(" + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glBindBufferBaseNV(n2, n3, n4);
        this.println("");
    }

    @Override
    public void glBindBufferOffsetNV(int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glBindBufferOffsetNV(" + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glBindBufferOffsetNV(n2, n3, n4, n5);
        this.println("");
    }

    @Override
    public void glBindBufferRangeNV(int n2, int n3, int n4, int n5, int n6) {
        this.printIndent();
        this.print("glBindBufferRangeNV(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + ")");
        this.downstreamGL.glBindBufferRangeNV(n2, n3, n4, n5, n6);
        this.println("");
    }

    @Override
    public void glBindFragDataLocationEXT(int n2, int n3, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glBindFragDataLocationEXT(" + n2 + "," + n3 + "," + byteBuffer + ")");
        this.downstreamGL.glBindFragDataLocationEXT(n2, n3, byteBuffer);
        this.println("");
    }

    @Override
    public void glBindFragDataLocationEXT(int n2, int n3, byte[] byArray, int n4) {
        this.printIndent();
        this.print("glBindFragDataLocationEXT(" + n2 + "," + n3 + "," + this.dumpArray(byArray) + "," + n4 + ")");
        this.downstreamGL.glBindFragDataLocationEXT(n2, n3, byArray, n4);
        this.println("");
    }

    @Override
    public void glBindFragmentShaderATI(int n2) {
        this.printIndent();
        this.print("glBindFragmentShaderATI(" + n2 + ")");
        this.downstreamGL.glBindFragmentShaderATI(n2);
        this.println("");
    }

    @Override
    public void glBindFramebufferEXT(int n2, int n3) {
        this.printIndent();
        this.print("glBindFramebufferEXT(" + n2 + "," + n3 + ")");
        this.downstreamGL.glBindFramebufferEXT(n2, n3);
        this.println("");
    }

    @Override
    public int glBindLightParameterEXT(int n2, int n3) {
        this.printIndent();
        this.print("glBindLightParameterEXT(" + n2 + "," + n3 + ")");
        n2 = this.downstreamGL.glBindLightParameterEXT(n2, n3);
        this.println(" = " + n2);
        return n2;
    }

    @Override
    public int glBindMaterialParameterEXT(int n2, int n3) {
        this.printIndent();
        this.print("glBindMaterialParameterEXT(" + n2 + "," + n3 + ")");
        n2 = this.downstreamGL.glBindMaterialParameterEXT(n2, n3);
        this.println(" = " + n2);
        return n2;
    }

    @Override
    public int glBindParameterEXT(int n2) {
        this.printIndent();
        this.print("glBindParameterEXT(" + n2 + ")");
        n2 = this.downstreamGL.glBindParameterEXT(n2);
        this.println(" = " + n2);
        return n2;
    }

    @Override
    public void glBindProgramARB(int n2, int n3) {
        this.printIndent();
        this.print("glBindProgramARB(" + n2 + "," + n3 + ")");
        this.downstreamGL.glBindProgramARB(n2, n3);
        this.println("");
    }

    @Override
    public void glBindProgramNV(int n2, int n3) {
        this.printIndent();
        this.print("glBindProgramNV(" + n2 + "," + n3 + ")");
        this.downstreamGL.glBindProgramNV(n2, n3);
        this.println("");
    }

    @Override
    public void glBindRenderbufferEXT(int n2, int n3) {
        this.printIndent();
        this.print("glBindRenderbufferEXT(" + n2 + "," + n3 + ")");
        this.downstreamGL.glBindRenderbufferEXT(n2, n3);
        this.println("");
    }

    @Override
    public int glBindTexGenParameterEXT(int n2, int n3, int n4) {
        this.printIndent();
        this.print("glBindTexGenParameterEXT(" + n2 + "," + n3 + "," + n4 + ")");
        n2 = this.downstreamGL.glBindTexGenParameterEXT(n2, n3, n4);
        this.println(" = " + n2);
        return n2;
    }

    @Override
    public void glBindTexture(int n2, int n3) {
        this.printIndent();
        this.print("glBindTexture(" + n2 + "," + n3 + ")");
        this.downstreamGL.glBindTexture(n2, n3);
        this.println("");
    }

    @Override
    public int glBindTextureUnitParameterEXT(int n2, int n3) {
        this.printIndent();
        this.print("glBindTextureUnitParameterEXT(" + n2 + "," + n3 + ")");
        n2 = this.downstreamGL.glBindTextureUnitParameterEXT(n2, n3);
        this.println(" = " + n2);
        return n2;
    }

    @Override
    public void glBindVertexArrayAPPLE(int n2) {
        this.printIndent();
        this.print("glBindVertexArrayAPPLE(" + n2 + ")");
        this.downstreamGL.glBindVertexArrayAPPLE(n2);
        this.println("");
    }

    @Override
    public void glBindVertexShaderEXT(int n2) {
        this.printIndent();
        this.print("glBindVertexShaderEXT(" + n2 + ")");
        this.downstreamGL.glBindVertexShaderEXT(n2);
        this.println("");
    }

    @Override
    public void glBitmap(int n2, int n3, float f2, float f3, float f4, float f5, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glBitmap(" + n2 + "," + n3 + "," + f2 + "," + f3 + "," + f4 + "," + f5 + "," + byteBuffer + ")");
        this.downstreamGL.glBitmap(n2, n3, f2, f3, f4, f5, byteBuffer);
        this.println("");
    }

    @Override
    public void glBitmap(int n2, int n3, float f2, float f3, float f4, float f5, byte[] byArray, int n4) {
        this.printIndent();
        this.print("glBitmap(" + n2 + "," + n3 + "," + f2 + "," + f3 + "," + f4 + "," + f5 + "," + this.dumpArray(byArray) + "," + n4 + ")");
        this.downstreamGL.glBitmap(n2, n3, f2, f3, f4, f5, byArray, n4);
        this.println("");
    }

    @Override
    public void glBitmap(int n2, int n3, float f2, float f3, float f4, float f5, long l2) {
        this.printIndent();
        this.print("glBitmap(" + n2 + "," + n3 + "," + f2 + "," + f3 + "," + f4 + "," + f5 + "," + l2 + ")");
        this.downstreamGL.glBitmap(n2, n3, f2, f3, f4, f5, l2);
        this.println("");
    }

    @Override
    public void glBlendColor(float f2, float f3, float f4, float f5) {
        this.printIndent();
        this.print("glBlendColor(" + f2 + "," + f3 + "," + f4 + "," + f5 + ")");
        this.downstreamGL.glBlendColor(f2, f3, f4, f5);
        this.println("");
    }

    @Override
    public void glBlendEquation(int n2) {
        this.printIndent();
        this.print("glBlendEquation(" + n2 + ")");
        this.downstreamGL.glBlendEquation(n2);
        this.println("");
    }

    @Override
    public void glBlendEquationSeparate(int n2, int n3) {
        this.printIndent();
        this.print("glBlendEquationSeparate(" + n2 + "," + n3 + ")");
        this.downstreamGL.glBlendEquationSeparate(n2, n3);
        this.println("");
    }

    @Override
    public void glBlendEquationSeparateEXT(int n2, int n3) {
        this.printIndent();
        this.print("glBlendEquationSeparateEXT(" + n2 + "," + n3 + ")");
        this.downstreamGL.glBlendEquationSeparateEXT(n2, n3);
        this.println("");
    }

    @Override
    public void glBlendFunc(int n2, int n3) {
        this.printIndent();
        this.print("glBlendFunc(" + n2 + "," + n3 + ")");
        this.downstreamGL.glBlendFunc(n2, n3);
        this.println("");
    }

    @Override
    public void glBlendFuncSeparate(int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glBlendFuncSeparate(" + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glBlendFuncSeparate(n2, n3, n4, n5);
        this.println("");
    }

    @Override
    public void glBlendFuncSeparateEXT(int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glBlendFuncSeparateEXT(" + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glBlendFuncSeparateEXT(n2, n3, n4, n5);
        this.println("");
    }

    @Override
    public void glBlendFuncSeparateINGR(int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glBlendFuncSeparateINGR(" + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glBlendFuncSeparateINGR(n2, n3, n4, n5);
        this.println("");
    }

    @Override
    public void glBlitFramebufferEXT(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        this.printIndent();
        this.print("glBlitFramebufferEXT(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + n11 + ")");
        this.downstreamGL.glBlitFramebufferEXT(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11);
        this.println("");
    }

    @Override
    public void glBufferData(int n2, int n3, Buffer buffer, int n4) {
        this.printIndent();
        this.print("glBufferData(" + n2 + "," + n3 + "," + buffer + "," + n4 + ")");
        this.downstreamGL.glBufferData(n2, n3, buffer, n4);
        this.println("");
    }

    @Override
    public void glBufferDataARB(int n2, int n3, Buffer buffer, int n4) {
        this.printIndent();
        this.print("glBufferDataARB(" + n2 + "," + n3 + "," + buffer + "," + n4 + ")");
        this.downstreamGL.glBufferDataARB(n2, n3, buffer, n4);
        this.println("");
    }

    @Override
    public void glBufferParameteriAPPLE(int n2, int n3, int n4) {
        this.printIndent();
        this.print("glBufferParameteriAPPLE(" + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glBufferParameteriAPPLE(n2, n3, n4);
        this.println("");
    }

    @Override
    public int glBufferRegionEnabled() {
        this.printIndent();
        this.print("glBufferRegionEnabled()");
        int n2 = this.downstreamGL.glBufferRegionEnabled();
        this.println(" = " + n2);
        return n2;
    }

    @Override
    public void glBufferSubData(int n2, int n3, int n4, Buffer buffer) {
        this.printIndent();
        this.print("glBufferSubData(" + n2 + "," + n3 + "," + n4 + "," + buffer + ")");
        this.downstreamGL.glBufferSubData(n2, n3, n4, buffer);
        this.println("");
    }

    @Override
    public void glBufferSubDataARB(int n2, int n3, int n4, Buffer buffer) {
        this.printIndent();
        this.print("glBufferSubDataARB(" + n2 + "," + n3 + "," + n4 + "," + buffer + ")");
        this.downstreamGL.glBufferSubDataARB(n2, n3, n4, buffer);
        this.println("");
    }

    @Override
    public void glCallList(int n2) {
        this.printIndent();
        this.print("glCallList(" + n2 + ")");
        this.downstreamGL.glCallList(n2);
        this.println("");
    }

    @Override
    public void glCallLists(int n2, int n3, Buffer buffer) {
        this.printIndent();
        this.print("glCallLists(" + n2 + "," + n3 + "," + buffer + ")");
        this.downstreamGL.glCallLists(n2, n3, buffer);
        this.println("");
    }

    @Override
    public int glCheckFramebufferStatusEXT(int n2) {
        this.printIndent();
        this.print("glCheckFramebufferStatusEXT(" + n2 + ")");
        n2 = this.downstreamGL.glCheckFramebufferStatusEXT(n2);
        this.println(" = " + n2);
        return n2;
    }

    @Override
    public void glClampColorARB(int n2, int n3) {
        this.printIndent();
        this.print("glClampColorARB(" + n2 + "," + n3 + ")");
        this.downstreamGL.glClampColorARB(n2, n3);
        this.println("");
    }

    @Override
    public void glClear(int n2) {
        this.printIndent();
        this.print("glClear(" + n2 + ")");
        this.downstreamGL.glClear(n2);
        this.println("");
    }

    @Override
    public void glClearAccum(float f2, float f3, float f4, float f5) {
        this.printIndent();
        this.print("glClearAccum(" + f2 + "," + f3 + "," + f4 + "," + f5 + ")");
        this.downstreamGL.glClearAccum(f2, f3, f4, f5);
        this.println("");
    }

    @Override
    public void glClearColor(float f2, float f3, float f4, float f5) {
        this.printIndent();
        this.print("glClearColor(" + f2 + "," + f3 + "," + f4 + "," + f5 + ")");
        this.downstreamGL.glClearColor(f2, f3, f4, f5);
        this.println("");
    }

    @Override
    public void glClearColorIiEXT(int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glClearColorIiEXT(" + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glClearColorIiEXT(n2, n3, n4, n5);
        this.println("");
    }

    @Override
    public void glClearColorIuiEXT(int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glClearColorIuiEXT(" + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glClearColorIuiEXT(n2, n3, n4, n5);
        this.println("");
    }

    @Override
    public void glClearDepth(double d2) {
        this.printIndent();
        this.print("glClearDepth(" + d2 + ")");
        this.downstreamGL.glClearDepth(d2);
        this.println("");
    }

    @Override
    public void glClearDepthdNV(double d2) {
        this.printIndent();
        this.print("glClearDepthdNV(" + d2 + ")");
        this.downstreamGL.glClearDepthdNV(d2);
        this.println("");
    }

    @Override
    public void glClearIndex(float f2) {
        this.printIndent();
        this.print("glClearIndex(" + f2 + ")");
        this.downstreamGL.glClearIndex(f2);
        this.println("");
    }

    @Override
    public void glClearStencil(int n2) {
        this.printIndent();
        this.print("glClearStencil(" + n2 + ")");
        this.downstreamGL.glClearStencil(n2);
        this.println("");
    }

    @Override
    public void glClientActiveTexture(int n2) {
        this.printIndent();
        this.print("glClientActiveTexture(" + n2 + ")");
        this.downstreamGL.glClientActiveTexture(n2);
        this.println("");
    }

    @Override
    public void glClientActiveVertexStreamATI(int n2) {
        this.printIndent();
        this.print("glClientActiveVertexStreamATI(" + n2 + ")");
        this.downstreamGL.glClientActiveVertexStreamATI(n2);
        this.println("");
    }

    @Override
    public void glClipPlane(int n2, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glClipPlane(" + n2 + "," + doubleBuffer + ")");
        this.downstreamGL.glClipPlane(n2, doubleBuffer);
        this.println("");
    }

    @Override
    public void glClipPlane(int n2, double[] dArray, int n3) {
        this.printIndent();
        this.print("glClipPlane(" + n2 + "," + this.dumpArray(dArray) + "," + n3 + ")");
        this.downstreamGL.glClipPlane(n2, dArray, n3);
        this.println("");
    }

    @Override
    public void glColor3b(byte by, byte by2, byte by3) {
        this.printIndent();
        this.print("glColor3b(" + by + "," + by2 + "," + by3 + ")");
        this.downstreamGL.glColor3b(by, by2, by3);
        this.println("");
    }

    @Override
    public void glColor3bv(ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glColor3bv(" + byteBuffer + ")");
        this.downstreamGL.glColor3bv(byteBuffer);
        this.println("");
    }

    @Override
    public void glColor3bv(byte[] byArray, int n2) {
        this.printIndent();
        this.print("glColor3bv(" + this.dumpArray(byArray) + "," + n2 + ")");
        this.downstreamGL.glColor3bv(byArray, n2);
        this.println("");
    }

    @Override
    public void glColor3d(double d2, double d3, double d4) {
        this.printIndent();
        this.print("glColor3d(" + d2 + "," + d3 + "," + d4 + ")");
        this.downstreamGL.glColor3d(d2, d3, d4);
        this.println("");
    }

    @Override
    public void glColor3dv(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glColor3dv(" + doubleBuffer + ")");
        this.downstreamGL.glColor3dv(doubleBuffer);
        this.println("");
    }

    @Override
    public void glColor3dv(double[] dArray, int n2) {
        this.printIndent();
        this.print("glColor3dv(" + this.dumpArray(dArray) + "," + n2 + ")");
        this.downstreamGL.glColor3dv(dArray, n2);
        this.println("");
    }

    @Override
    public void glColor3f(float f2, float f3, float f4) {
        this.printIndent();
        this.print("glColor3f(" + f2 + "," + f3 + "," + f4 + ")");
        this.downstreamGL.glColor3f(f2, f3, f4);
        this.println("");
    }

    @Override
    public void glColor3fVertex3fSUN(float f2, float f3, float f4, float f5, float f6, float f7) {
        this.printIndent();
        this.print("glColor3fVertex3fSUN(" + f2 + "," + f3 + "," + f4 + "," + f5 + "," + f6 + "," + f7 + ")");
        this.downstreamGL.glColor3fVertex3fSUN(f2, f3, f4, f5, f6, f7);
        this.println("");
    }

    @Override
    public void glColor3fVertex3fvSUN(FloatBuffer floatBuffer, FloatBuffer floatBuffer2) {
        this.printIndent();
        this.print("glColor3fVertex3fvSUN(" + floatBuffer + "," + floatBuffer2 + ")");
        this.downstreamGL.glColor3fVertex3fvSUN(floatBuffer, floatBuffer2);
        this.println("");
    }

    @Override
    public void glColor3fVertex3fvSUN(float[] fArray, int n2, float[] fArray2, int n3) {
        this.printIndent();
        this.print("glColor3fVertex3fvSUN(" + this.dumpArray(fArray) + "," + n2 + "," + this.dumpArray(fArray2) + "," + n3 + ")");
        this.downstreamGL.glColor3fVertex3fvSUN(fArray, n2, fArray2, n3);
        this.println("");
    }

    @Override
    public void glColor3fv(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glColor3fv(" + floatBuffer + ")");
        this.downstreamGL.glColor3fv(floatBuffer);
        this.println("");
    }

    @Override
    public void glColor3fv(float[] fArray, int n2) {
        this.printIndent();
        this.print("glColor3fv(" + this.dumpArray(fArray) + "," + n2 + ")");
        this.downstreamGL.glColor3fv(fArray, n2);
        this.println("");
    }

    @Override
    public void glColor3hNV(short s2, short s3, short s4) {
        this.printIndent();
        this.print("glColor3hNV(" + s2 + "," + s3 + "," + s4 + ")");
        this.downstreamGL.glColor3hNV(s2, s3, s4);
        this.println("");
    }

    @Override
    public void glColor3hvNV(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glColor3hvNV(" + shortBuffer + ")");
        this.downstreamGL.glColor3hvNV(shortBuffer);
        this.println("");
    }

    @Override
    public void glColor3hvNV(short[] sArray, int n2) {
        this.printIndent();
        this.print("glColor3hvNV(" + this.dumpArray(sArray) + "," + n2 + ")");
        this.downstreamGL.glColor3hvNV(sArray, n2);
        this.println("");
    }

    @Override
    public void glColor3i(int n2, int n3, int n4) {
        this.printIndent();
        this.print("glColor3i(" + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glColor3i(n2, n3, n4);
        this.println("");
    }

    @Override
    public void glColor3iv(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glColor3iv(" + intBuffer + ")");
        this.downstreamGL.glColor3iv(intBuffer);
        this.println("");
    }

    @Override
    public void glColor3iv(int[] nArray, int n2) {
        this.printIndent();
        this.print("glColor3iv(" + this.dumpArray(nArray) + "," + n2 + ")");
        this.downstreamGL.glColor3iv(nArray, n2);
        this.println("");
    }

    @Override
    public void glColor3s(short s2, short s3, short s4) {
        this.printIndent();
        this.print("glColor3s(" + s2 + "," + s3 + "," + s4 + ")");
        this.downstreamGL.glColor3s(s2, s3, s4);
        this.println("");
    }

    @Override
    public void glColor3sv(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glColor3sv(" + shortBuffer + ")");
        this.downstreamGL.glColor3sv(shortBuffer);
        this.println("");
    }

    @Override
    public void glColor3sv(short[] sArray, int n2) {
        this.printIndent();
        this.print("glColor3sv(" + this.dumpArray(sArray) + "," + n2 + ")");
        this.downstreamGL.glColor3sv(sArray, n2);
        this.println("");
    }

    @Override
    public void glColor3ub(byte by, byte by2, byte by3) {
        this.printIndent();
        this.print("glColor3ub(" + by + "," + by2 + "," + by3 + ")");
        this.downstreamGL.glColor3ub(by, by2, by3);
        this.println("");
    }

    @Override
    public void glColor3ubv(ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glColor3ubv(" + byteBuffer + ")");
        this.downstreamGL.glColor3ubv(byteBuffer);
        this.println("");
    }

    @Override
    public void glColor3ubv(byte[] byArray, int n2) {
        this.printIndent();
        this.print("glColor3ubv(" + this.dumpArray(byArray) + "," + n2 + ")");
        this.downstreamGL.glColor3ubv(byArray, n2);
        this.println("");
    }

    @Override
    public void glColor3ui(int n2, int n3, int n4) {
        this.printIndent();
        this.print("glColor3ui(" + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glColor3ui(n2, n3, n4);
        this.println("");
    }

    @Override
    public void glColor3uiv(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glColor3uiv(" + intBuffer + ")");
        this.downstreamGL.glColor3uiv(intBuffer);
        this.println("");
    }

    @Override
    public void glColor3uiv(int[] nArray, int n2) {
        this.printIndent();
        this.print("glColor3uiv(" + this.dumpArray(nArray) + "," + n2 + ")");
        this.downstreamGL.glColor3uiv(nArray, n2);
        this.println("");
    }

    @Override
    public void glColor3us(short s2, short s3, short s4) {
        this.printIndent();
        this.print("glColor3us(" + s2 + "," + s3 + "," + s4 + ")");
        this.downstreamGL.glColor3us(s2, s3, s4);
        this.println("");
    }

    @Override
    public void glColor3usv(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glColor3usv(" + shortBuffer + ")");
        this.downstreamGL.glColor3usv(shortBuffer);
        this.println("");
    }

    @Override
    public void glColor3usv(short[] sArray, int n2) {
        this.printIndent();
        this.print("glColor3usv(" + this.dumpArray(sArray) + "," + n2 + ")");
        this.downstreamGL.glColor3usv(sArray, n2);
        this.println("");
    }

    @Override
    public void glColor4b(byte by, byte by2, byte by3, byte by4) {
        this.printIndent();
        this.print("glColor4b(" + by + "," + by2 + "," + by3 + "," + by4 + ")");
        this.downstreamGL.glColor4b(by, by2, by3, by4);
        this.println("");
    }

    @Override
    public void glColor4bv(ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glColor4bv(" + byteBuffer + ")");
        this.downstreamGL.glColor4bv(byteBuffer);
        this.println("");
    }

    @Override
    public void glColor4bv(byte[] byArray, int n2) {
        this.printIndent();
        this.print("glColor4bv(" + this.dumpArray(byArray) + "," + n2 + ")");
        this.downstreamGL.glColor4bv(byArray, n2);
        this.println("");
    }

    @Override
    public void glColor4d(double d2, double d3, double d4, double d5) {
        this.printIndent();
        this.print("glColor4d(" + d2 + "," + d3 + "," + d4 + "," + d5 + ")");
        this.downstreamGL.glColor4d(d2, d3, d4, d5);
        this.println("");
    }

    @Override
    public void glColor4dv(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glColor4dv(" + doubleBuffer + ")");
        this.downstreamGL.glColor4dv(doubleBuffer);
        this.println("");
    }

    @Override
    public void glColor4dv(double[] dArray, int n2) {
        this.printIndent();
        this.print("glColor4dv(" + this.dumpArray(dArray) + "," + n2 + ")");
        this.downstreamGL.glColor4dv(dArray, n2);
        this.println("");
    }

    @Override
    public void glColor4f(float f2, float f3, float f4, float f5) {
        this.printIndent();
        this.print("glColor4f(" + f2 + "," + f3 + "," + f4 + "," + f5 + ")");
        this.downstreamGL.glColor4f(f2, f3, f4, f5);
        this.println("");
    }

    @Override
    public void glColor4fNormal3fVertex3fSUN(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11) {
        this.printIndent();
        this.print("glColor4fNormal3fVertex3fSUN(" + f2 + "," + f3 + "," + f4 + "," + f5 + "," + f6 + "," + f7 + "," + f8 + "," + f9 + "," + f10 + "," + f11 + ")");
        this.downstreamGL.glColor4fNormal3fVertex3fSUN(f2, f3, f4, f5, f6, f7, f8, f9, f10, f11);
        this.println("");
    }

    @Override
    public void glColor4fNormal3fVertex3fvSUN(FloatBuffer floatBuffer, FloatBuffer floatBuffer2, FloatBuffer floatBuffer3) {
        this.printIndent();
        this.print("glColor4fNormal3fVertex3fvSUN(" + floatBuffer + "," + floatBuffer2 + "," + floatBuffer3 + ")");
        this.downstreamGL.glColor4fNormal3fVertex3fvSUN(floatBuffer, floatBuffer2, floatBuffer3);
        this.println("");
    }

    @Override
    public void glColor4fNormal3fVertex3fvSUN(float[] fArray, int n2, float[] fArray2, int n3, float[] fArray3, int n4) {
        this.printIndent();
        this.print("glColor4fNormal3fVertex3fvSUN(" + this.dumpArray(fArray) + "," + n2 + "," + this.dumpArray(fArray2) + "," + n3 + "," + this.dumpArray(fArray3) + "," + n4 + ")");
        this.downstreamGL.glColor4fNormal3fVertex3fvSUN(fArray, n2, fArray2, n3, fArray3, n4);
        this.println("");
    }

    @Override
    public void glColor4fv(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glColor4fv(" + floatBuffer + ")");
        this.downstreamGL.glColor4fv(floatBuffer);
        this.println("");
    }

    @Override
    public void glColor4fv(float[] fArray, int n2) {
        this.printIndent();
        this.print("glColor4fv(" + this.dumpArray(fArray) + "," + n2 + ")");
        this.downstreamGL.glColor4fv(fArray, n2);
        this.println("");
    }

    @Override
    public void glColor4hNV(short s2, short s3, short s4, short s5) {
        this.printIndent();
        this.print("glColor4hNV(" + s2 + "," + s3 + "," + s4 + "," + s5 + ")");
        this.downstreamGL.glColor4hNV(s2, s3, s4, s5);
        this.println("");
    }

    @Override
    public void glColor4hvNV(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glColor4hvNV(" + shortBuffer + ")");
        this.downstreamGL.glColor4hvNV(shortBuffer);
        this.println("");
    }

    @Override
    public void glColor4hvNV(short[] sArray, int n2) {
        this.printIndent();
        this.print("glColor4hvNV(" + this.dumpArray(sArray) + "," + n2 + ")");
        this.downstreamGL.glColor4hvNV(sArray, n2);
        this.println("");
    }

    @Override
    public void glColor4i(int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glColor4i(" + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glColor4i(n2, n3, n4, n5);
        this.println("");
    }

    @Override
    public void glColor4iv(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glColor4iv(" + intBuffer + ")");
        this.downstreamGL.glColor4iv(intBuffer);
        this.println("");
    }

    @Override
    public void glColor4iv(int[] nArray, int n2) {
        this.printIndent();
        this.print("glColor4iv(" + this.dumpArray(nArray) + "," + n2 + ")");
        this.downstreamGL.glColor4iv(nArray, n2);
        this.println("");
    }

    @Override
    public void glColor4s(short s2, short s3, short s4, short s5) {
        this.printIndent();
        this.print("glColor4s(" + s2 + "," + s3 + "," + s4 + "," + s5 + ")");
        this.downstreamGL.glColor4s(s2, s3, s4, s5);
        this.println("");
    }

    @Override
    public void glColor4sv(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glColor4sv(" + shortBuffer + ")");
        this.downstreamGL.glColor4sv(shortBuffer);
        this.println("");
    }

    @Override
    public void glColor4sv(short[] sArray, int n2) {
        this.printIndent();
        this.print("glColor4sv(" + this.dumpArray(sArray) + "," + n2 + ")");
        this.downstreamGL.glColor4sv(sArray, n2);
        this.println("");
    }

    @Override
    public void glColor4ub(byte by, byte by2, byte by3, byte by4) {
        this.printIndent();
        this.print("glColor4ub(" + by + "," + by2 + "," + by3 + "," + by4 + ")");
        this.downstreamGL.glColor4ub(by, by2, by3, by4);
        this.println("");
    }

    @Override
    public void glColor4ubVertex2fSUN(byte by, byte by2, byte by3, byte by4, float f2, float f3) {
        this.printIndent();
        this.print("glColor4ubVertex2fSUN(" + by + "," + by2 + "," + by3 + "," + by4 + "," + f2 + "," + f3 + ")");
        this.downstreamGL.glColor4ubVertex2fSUN(by, by2, by3, by4, f2, f3);
        this.println("");
    }

    @Override
    public void glColor4ubVertex2fvSUN(ByteBuffer byteBuffer, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glColor4ubVertex2fvSUN(" + byteBuffer + "," + floatBuffer + ")");
        this.downstreamGL.glColor4ubVertex2fvSUN(byteBuffer, floatBuffer);
        this.println("");
    }

    @Override
    public void glColor4ubVertex2fvSUN(byte[] byArray, int n2, float[] fArray, int n3) {
        this.printIndent();
        this.print("glColor4ubVertex2fvSUN(" + this.dumpArray(byArray) + "," + n2 + "," + this.dumpArray(fArray) + "," + n3 + ")");
        this.downstreamGL.glColor4ubVertex2fvSUN(byArray, n2, fArray, n3);
        this.println("");
    }

    @Override
    public void glColor4ubVertex3fSUN(byte by, byte by2, byte by3, byte by4, float f2, float f3, float f4) {
        this.printIndent();
        this.print("glColor4ubVertex3fSUN(" + by + "," + by2 + "," + by3 + "," + by4 + "," + f2 + "," + f3 + "," + f4 + ")");
        this.downstreamGL.glColor4ubVertex3fSUN(by, by2, by3, by4, f2, f3, f4);
        this.println("");
    }

    @Override
    public void glColor4ubVertex3fvSUN(ByteBuffer byteBuffer, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glColor4ubVertex3fvSUN(" + byteBuffer + "," + floatBuffer + ")");
        this.downstreamGL.glColor4ubVertex3fvSUN(byteBuffer, floatBuffer);
        this.println("");
    }

    @Override
    public void glColor4ubVertex3fvSUN(byte[] byArray, int n2, float[] fArray, int n3) {
        this.printIndent();
        this.print("glColor4ubVertex3fvSUN(" + this.dumpArray(byArray) + "," + n2 + "," + this.dumpArray(fArray) + "," + n3 + ")");
        this.downstreamGL.glColor4ubVertex3fvSUN(byArray, n2, fArray, n3);
        this.println("");
    }

    @Override
    public void glColor4ubv(ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glColor4ubv(" + byteBuffer + ")");
        this.downstreamGL.glColor4ubv(byteBuffer);
        this.println("");
    }

    @Override
    public void glColor4ubv(byte[] byArray, int n2) {
        this.printIndent();
        this.print("glColor4ubv(" + this.dumpArray(byArray) + "," + n2 + ")");
        this.downstreamGL.glColor4ubv(byArray, n2);
        this.println("");
    }

    @Override
    public void glColor4ui(int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glColor4ui(" + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glColor4ui(n2, n3, n4, n5);
        this.println("");
    }

    @Override
    public void glColor4uiv(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glColor4uiv(" + intBuffer + ")");
        this.downstreamGL.glColor4uiv(intBuffer);
        this.println("");
    }

    @Override
    public void glColor4uiv(int[] nArray, int n2) {
        this.printIndent();
        this.print("glColor4uiv(" + this.dumpArray(nArray) + "," + n2 + ")");
        this.downstreamGL.glColor4uiv(nArray, n2);
        this.println("");
    }

    @Override
    public void glColor4us(short s2, short s3, short s4, short s5) {
        this.printIndent();
        this.print("glColor4us(" + s2 + "," + s3 + "," + s4 + "," + s5 + ")");
        this.downstreamGL.glColor4us(s2, s3, s4, s5);
        this.println("");
    }

    @Override
    public void glColor4usv(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glColor4usv(" + shortBuffer + ")");
        this.downstreamGL.glColor4usv(shortBuffer);
        this.println("");
    }

    @Override
    public void glColor4usv(short[] sArray, int n2) {
        this.printIndent();
        this.print("glColor4usv(" + this.dumpArray(sArray) + "," + n2 + ")");
        this.downstreamGL.glColor4usv(sArray, n2);
        this.println("");
    }

    @Override
    public void glColorFragmentOp1ATI(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.printIndent();
        this.print("glColorFragmentOp1ATI(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + ")");
        this.downstreamGL.glColorFragmentOp1ATI(n2, n3, n4, n5, n6, n7, n8);
        this.println("");
    }

    @Override
    public void glColorFragmentOp2ATI(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        this.printIndent();
        this.print("glColorFragmentOp2ATI(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + n11 + ")");
        this.downstreamGL.glColorFragmentOp2ATI(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11);
        this.println("");
    }

    @Override
    public void glColorFragmentOp3ATI(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14) {
        this.printIndent();
        this.print("glColorFragmentOp3ATI(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + n11 + "," + n12 + "," + n13 + "," + n14 + ")");
        this.downstreamGL.glColorFragmentOp3ATI(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14);
        this.println("");
    }

    @Override
    public void glColorMask(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.printIndent();
        this.print("glColorMask(" + bl + "," + bl2 + "," + bl3 + "," + bl4 + ")");
        this.downstreamGL.glColorMask(bl, bl2, bl3, bl4);
        this.println("");
    }

    @Override
    public void glColorMaskIndexedEXT(int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.printIndent();
        this.print("glColorMaskIndexedEXT(" + n2 + "," + bl + "," + bl2 + "," + bl3 + "," + bl4 + ")");
        this.downstreamGL.glColorMaskIndexedEXT(n2, bl, bl2, bl3, bl4);
        this.println("");
    }

    @Override
    public void glColorMaterial(int n2, int n3) {
        this.printIndent();
        this.print("glColorMaterial(" + n2 + "," + n3 + ")");
        this.downstreamGL.glColorMaterial(n2, n3);
        this.println("");
    }

    @Override
    public void glColorPointer(int n2, int n3, int n4, Buffer buffer) {
        this.printIndent();
        this.print("glColorPointer(" + n2 + "," + n3 + "," + n4 + "," + buffer + ")");
        this.downstreamGL.glColorPointer(n2, n3, n4, buffer);
        this.println("");
    }

    @Override
    public void glColorPointer(int n2, int n3, int n4, long l2) {
        this.printIndent();
        this.print("glColorPointer(" + n2 + "," + n3 + "," + n4 + "," + l2 + ")");
        this.downstreamGL.glColorPointer(n2, n3, n4, l2);
        this.println("");
    }

    @Override
    public void glColorSubTable(int n2, int n3, int n4, int n5, int n6, Buffer buffer) {
        this.printIndent();
        this.print("glColorSubTable(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + buffer + ")");
        this.downstreamGL.glColorSubTable(n2, n3, n4, n5, n6, buffer);
        this.println("");
    }

    @Override
    public void glColorSubTable(int n2, int n3, int n4, int n5, int n6, long l2) {
        this.printIndent();
        this.print("glColorSubTable(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + l2 + ")");
        this.downstreamGL.glColorSubTable(n2, n3, n4, n5, n6, l2);
        this.println("");
    }

    @Override
    public void glColorTable(int n2, int n3, int n4, int n5, int n6, Buffer buffer) {
        this.printIndent();
        this.print("glColorTable(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + buffer + ")");
        this.downstreamGL.glColorTable(n2, n3, n4, n5, n6, buffer);
        this.println("");
    }

    @Override
    public void glColorTable(int n2, int n3, int n4, int n5, int n6, long l2) {
        this.printIndent();
        this.print("glColorTable(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + l2 + ")");
        this.downstreamGL.glColorTable(n2, n3, n4, n5, n6, l2);
        this.println("");
    }

    @Override
    public void glColorTableEXT(int n2, int n3, int n4, int n5, int n6, Buffer buffer) {
        this.printIndent();
        this.print("glColorTableEXT(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + buffer + ")");
        this.downstreamGL.glColorTableEXT(n2, n3, n4, n5, n6, buffer);
        this.println("");
    }

    @Override
    public void glColorTableParameterfv(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glColorTableParameterfv(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glColorTableParameterfv(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glColorTableParameterfv(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glColorTableParameterfv(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glColorTableParameterfv(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glColorTableParameteriv(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glColorTableParameteriv(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glColorTableParameteriv(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glColorTableParameteriv(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glColorTableParameteriv(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glColorTableParameteriv(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glCombinerInputNV(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.printIndent();
        this.print("glCombinerInputNV(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + ")");
        this.downstreamGL.glCombinerInputNV(n2, n3, n4, n5, n6, n7);
        this.println("");
    }

    @Override
    public void glCombinerOutputNV(int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, boolean bl2, boolean bl3) {
        this.printIndent();
        this.print("glCombinerOutputNV(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + bl + "," + bl2 + "," + bl3 + ")");
        this.downstreamGL.glCombinerOutputNV(n2, n3, n4, n5, n6, n7, n8, bl, bl2, bl3);
        this.println("");
    }

    @Override
    public void glCombinerParameterfNV(int n2, float f2) {
        this.printIndent();
        this.print("glCombinerParameterfNV(" + n2 + "," + f2 + ")");
        this.downstreamGL.glCombinerParameterfNV(n2, f2);
        this.println("");
    }

    @Override
    public void glCombinerParameterfvNV(int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glCombinerParameterfvNV(" + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glCombinerParameterfvNV(n2, floatBuffer);
        this.println("");
    }

    @Override
    public void glCombinerParameterfvNV(int n2, float[] fArray, int n3) {
        this.printIndent();
        this.print("glCombinerParameterfvNV(" + n2 + "," + this.dumpArray(fArray) + "," + n3 + ")");
        this.downstreamGL.glCombinerParameterfvNV(n2, fArray, n3);
        this.println("");
    }

    @Override
    public void glCombinerParameteriNV(int n2, int n3) {
        this.printIndent();
        this.print("glCombinerParameteriNV(" + n2 + "," + n3 + ")");
        this.downstreamGL.glCombinerParameteriNV(n2, n3);
        this.println("");
    }

    @Override
    public void glCombinerParameterivNV(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glCombinerParameterivNV(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glCombinerParameterivNV(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glCombinerParameterivNV(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glCombinerParameterivNV(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glCombinerParameterivNV(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glCombinerStageParameterfvNV(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glCombinerStageParameterfvNV(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glCombinerStageParameterfvNV(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glCombinerStageParameterfvNV(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glCombinerStageParameterfvNV(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glCombinerStageParameterfvNV(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glCompileShader(int n2) {
        this.printIndent();
        this.print("glCompileShader(" + n2 + ")");
        this.downstreamGL.glCompileShader(n2);
        this.println("");
    }

    @Override
    public void glCompileShaderARB(int n2) {
        this.printIndent();
        this.print("glCompileShaderARB(" + n2 + ")");
        this.downstreamGL.glCompileShaderARB(n2);
        this.println("");
    }

    @Override
    public void glCompressedTexImage1D(int n2, int n3, int n4, int n5, int n6, int n7, Buffer buffer) {
        this.printIndent();
        this.print("glCompressedTexImage1D(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + buffer + ")");
        this.downstreamGL.glCompressedTexImage1D(n2, n3, n4, n5, n6, n7, buffer);
        this.println("");
    }

    @Override
    public void glCompressedTexImage1D(int n2, int n3, int n4, int n5, int n6, int n7, long l2) {
        this.printIndent();
        this.print("glCompressedTexImage1D(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + l2 + ")");
        this.downstreamGL.glCompressedTexImage1D(n2, n3, n4, n5, n6, n7, l2);
        this.println("");
    }

    @Override
    public void glCompressedTexImage2D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, Buffer buffer) {
        this.printIndent();
        this.print("glCompressedTexImage2D(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + buffer + ")");
        this.downstreamGL.glCompressedTexImage2D(n2, n3, n4, n5, n6, n7, n8, buffer);
        this.println("");
    }

    @Override
    public void glCompressedTexImage2D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, long l2) {
        this.printIndent();
        this.print("glCompressedTexImage2D(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + l2 + ")");
        this.downstreamGL.glCompressedTexImage2D(n2, n3, n4, n5, n6, n7, n8, l2);
        this.println("");
    }

    @Override
    public void glCompressedTexImage3D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Buffer buffer) {
        this.printIndent();
        this.print("glCompressedTexImage3D(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + buffer + ")");
        this.downstreamGL.glCompressedTexImage3D(n2, n3, n4, n5, n6, n7, n8, n9, buffer);
        this.println("");
    }

    @Override
    public void glCompressedTexImage3D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, long l2) {
        this.printIndent();
        this.print("glCompressedTexImage3D(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + l2 + ")");
        this.downstreamGL.glCompressedTexImage3D(n2, n3, n4, n5, n6, n7, n8, n9, l2);
        this.println("");
    }

    @Override
    public void glCompressedTexSubImage1D(int n2, int n3, int n4, int n5, int n6, int n7, Buffer buffer) {
        this.printIndent();
        this.print("glCompressedTexSubImage1D(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + buffer + ")");
        this.downstreamGL.glCompressedTexSubImage1D(n2, n3, n4, n5, n6, n7, buffer);
        this.println("");
    }

    @Override
    public void glCompressedTexSubImage1D(int n2, int n3, int n4, int n5, int n6, int n7, long l2) {
        this.printIndent();
        this.print("glCompressedTexSubImage1D(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + l2 + ")");
        this.downstreamGL.glCompressedTexSubImage1D(n2, n3, n4, n5, n6, n7, l2);
        this.println("");
    }

    @Override
    public void glCompressedTexSubImage2D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Buffer buffer) {
        this.printIndent();
        this.print("glCompressedTexSubImage2D(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + buffer + ")");
        this.downstreamGL.glCompressedTexSubImage2D(n2, n3, n4, n5, n6, n7, n8, n9, buffer);
        this.println("");
    }

    @Override
    public void glCompressedTexSubImage2D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, long l2) {
        this.printIndent();
        this.print("glCompressedTexSubImage2D(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + l2 + ")");
        this.downstreamGL.glCompressedTexSubImage2D(n2, n3, n4, n5, n6, n7, n8, n9, l2);
        this.println("");
    }

    @Override
    public void glCompressedTexSubImage3D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, Buffer buffer) {
        this.printIndent();
        this.print("glCompressedTexSubImage3D(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + n11 + "," + buffer + ")");
        this.downstreamGL.glCompressedTexSubImage3D(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, buffer);
        this.println("");
    }

    @Override
    public void glCompressedTexSubImage3D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, long l2) {
        this.printIndent();
        this.print("glCompressedTexSubImage3D(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + n11 + "," + l2 + ")");
        this.downstreamGL.glCompressedTexSubImage3D(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, l2);
        this.println("");
    }

    @Override
    public void glConvolutionFilter1D(int n2, int n3, int n4, int n5, int n6, Buffer buffer) {
        this.printIndent();
        this.print("glConvolutionFilter1D(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + buffer + ")");
        this.downstreamGL.glConvolutionFilter1D(n2, n3, n4, n5, n6, buffer);
        this.println("");
    }

    @Override
    public void glConvolutionFilter1D(int n2, int n3, int n4, int n5, int n6, long l2) {
        this.printIndent();
        this.print("glConvolutionFilter1D(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + l2 + ")");
        this.downstreamGL.glConvolutionFilter1D(n2, n3, n4, n5, n6, l2);
        this.println("");
    }

    @Override
    public void glConvolutionFilter2D(int n2, int n3, int n4, int n5, int n6, int n7, Buffer buffer) {
        this.printIndent();
        this.print("glConvolutionFilter2D(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + buffer + ")");
        this.downstreamGL.glConvolutionFilter2D(n2, n3, n4, n5, n6, n7, buffer);
        this.println("");
    }

    @Override
    public void glConvolutionFilter2D(int n2, int n3, int n4, int n5, int n6, int n7, long l2) {
        this.printIndent();
        this.print("glConvolutionFilter2D(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + l2 + ")");
        this.downstreamGL.glConvolutionFilter2D(n2, n3, n4, n5, n6, n7, l2);
        this.println("");
    }

    @Override
    public void glConvolutionParameterf(int n2, int n3, float f2) {
        this.printIndent();
        this.print("glConvolutionParameterf(" + n2 + "," + n3 + "," + f2 + ")");
        this.downstreamGL.glConvolutionParameterf(n2, n3, f2);
        this.println("");
    }

    @Override
    public void glConvolutionParameterfv(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glConvolutionParameterfv(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glConvolutionParameterfv(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glConvolutionParameterfv(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glConvolutionParameterfv(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glConvolutionParameterfv(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glConvolutionParameteri(int n2, int n3, int n4) {
        this.printIndent();
        this.print("glConvolutionParameteri(" + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glConvolutionParameteri(n2, n3, n4);
        this.println("");
    }

    @Override
    public void glConvolutionParameteriv(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glConvolutionParameteriv(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glConvolutionParameteriv(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glConvolutionParameteriv(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glConvolutionParameteriv(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glConvolutionParameteriv(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glCopyColorSubTable(int n2, int n3, int n4, int n5, int n6) {
        this.printIndent();
        this.print("glCopyColorSubTable(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + ")");
        this.downstreamGL.glCopyColorSubTable(n2, n3, n4, n5, n6);
        this.println("");
    }

    @Override
    public void glCopyColorTable(int n2, int n3, int n4, int n5, int n6) {
        this.printIndent();
        this.print("glCopyColorTable(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + ")");
        this.downstreamGL.glCopyColorTable(n2, n3, n4, n5, n6);
        this.println("");
    }

    @Override
    public void glCopyConvolutionFilter1D(int n2, int n3, int n4, int n5, int n6) {
        this.printIndent();
        this.print("glCopyConvolutionFilter1D(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + ")");
        this.downstreamGL.glCopyConvolutionFilter1D(n2, n3, n4, n5, n6);
        this.println("");
    }

    @Override
    public void glCopyConvolutionFilter2D(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.printIndent();
        this.print("glCopyConvolutionFilter2D(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + ")");
        this.downstreamGL.glCopyConvolutionFilter2D(n2, n3, n4, n5, n6, n7);
        this.println("");
    }

    @Override
    public void glCopyPixels(int n2, int n3, int n4, int n5, int n6) {
        this.printIndent();
        this.print("glCopyPixels(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + ")");
        this.downstreamGL.glCopyPixels(n2, n3, n4, n5, n6);
        this.println("");
    }

    @Override
    public void glCopyTexImage1D(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.printIndent();
        this.print("glCopyTexImage1D(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + ")");
        this.downstreamGL.glCopyTexImage1D(n2, n3, n4, n5, n6, n7, n8);
        this.println("");
    }

    @Override
    public void glCopyTexImage2D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.printIndent();
        this.print("glCopyTexImage2D(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + ")");
        this.downstreamGL.glCopyTexImage2D(n2, n3, n4, n5, n6, n7, n8, n9);
        this.println("");
    }

    @Override
    public void glCopyTexSubImage1D(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.printIndent();
        this.print("glCopyTexSubImage1D(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + ")");
        this.downstreamGL.glCopyTexSubImage1D(n2, n3, n4, n5, n6, n7);
        this.println("");
    }

    @Override
    public void glCopyTexSubImage2D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.printIndent();
        this.print("glCopyTexSubImage2D(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + ")");
        this.downstreamGL.glCopyTexSubImage2D(n2, n3, n4, n5, n6, n7, n8, n9);
        this.println("");
    }

    @Override
    public void glCopyTexSubImage3D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        this.printIndent();
        this.print("glCopyTexSubImage3D(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + ")");
        this.downstreamGL.glCopyTexSubImage3D(n2, n3, n4, n5, n6, n7, n8, n9, n10);
        this.println("");
    }

    @Override
    public int glCreateProgram() {
        this.printIndent();
        this.print("glCreateProgram()");
        int n2 = this.downstreamGL.glCreateProgram();
        this.println(" = " + n2);
        return n2;
    }

    @Override
    public int glCreateProgramObjectARB() {
        this.printIndent();
        this.print("glCreateProgramObjectARB()");
        int n2 = this.downstreamGL.glCreateProgramObjectARB();
        this.println(" = " + n2);
        return n2;
    }

    @Override
    public int glCreateShader(int n2) {
        this.printIndent();
        this.print("glCreateShader(" + n2 + ")");
        n2 = this.downstreamGL.glCreateShader(n2);
        this.println(" = " + n2);
        return n2;
    }

    @Override
    public int glCreateShaderObjectARB(int n2) {
        this.printIndent();
        this.print("glCreateShaderObjectARB(" + n2 + ")");
        n2 = this.downstreamGL.glCreateShaderObjectARB(n2);
        this.println(" = " + n2);
        return n2;
    }

    @Override
    public void glCullFace(int n2) {
        this.printIndent();
        this.print("glCullFace(" + n2 + ")");
        this.downstreamGL.glCullFace(n2);
        this.println("");
    }

    @Override
    public void glCullParameterdvEXT(int n2, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glCullParameterdvEXT(" + n2 + "," + doubleBuffer + ")");
        this.downstreamGL.glCullParameterdvEXT(n2, doubleBuffer);
        this.println("");
    }

    @Override
    public void glCullParameterdvEXT(int n2, double[] dArray, int n3) {
        this.printIndent();
        this.print("glCullParameterdvEXT(" + n2 + "," + this.dumpArray(dArray) + "," + n3 + ")");
        this.downstreamGL.glCullParameterdvEXT(n2, dArray, n3);
        this.println("");
    }

    @Override
    public void glCullParameterfvEXT(int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glCullParameterfvEXT(" + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glCullParameterfvEXT(n2, floatBuffer);
        this.println("");
    }

    @Override
    public void glCullParameterfvEXT(int n2, float[] fArray, int n3) {
        this.printIndent();
        this.print("glCullParameterfvEXT(" + n2 + "," + this.dumpArray(fArray) + "," + n3 + ")");
        this.downstreamGL.glCullParameterfvEXT(n2, fArray, n3);
        this.println("");
    }

    @Override
    public void glCurrentPaletteMatrixARB(int n2) {
        this.printIndent();
        this.print("glCurrentPaletteMatrixARB(" + n2 + ")");
        this.downstreamGL.glCurrentPaletteMatrixARB(n2);
        this.println("");
    }

    @Override
    public void glDeformSGIX(int n2) {
        this.printIndent();
        this.print("glDeformSGIX(" + n2 + ")");
        this.downstreamGL.glDeformSGIX(n2);
        this.println("");
    }

    @Override
    public void glDeformationMap3dSGIX(int n2, double d2, double d3, int n3, int n4, double d4, double d5, int n5, int n6, double d6, double d7, int n7, int n8, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glDeformationMap3dSGIX(" + n2 + "," + d2 + "," + d3 + "," + n3 + "," + n4 + "," + d4 + "," + d5 + "," + n5 + "," + n6 + "," + d6 + "," + d7 + "," + n7 + "," + n8 + "," + doubleBuffer + ")");
        this.downstreamGL.glDeformationMap3dSGIX(n2, d2, d3, n3, n4, d4, d5, n5, n6, d6, d7, n7, n8, doubleBuffer);
        this.println("");
    }

    @Override
    public void glDeformationMap3dSGIX(int n2, double d2, double d3, int n3, int n4, double d4, double d5, int n5, int n6, double d6, double d7, int n7, int n8, double[] dArray, int n9) {
        this.printIndent();
        this.print("glDeformationMap3dSGIX(" + n2 + "," + d2 + "," + d3 + "," + n3 + "," + n4 + "," + d4 + "," + d5 + "," + n5 + "," + n6 + "," + d6 + "," + d7 + "," + n7 + "," + n8 + "," + this.dumpArray(dArray) + "," + n9 + ")");
        this.downstreamGL.glDeformationMap3dSGIX(n2, d2, d3, n3, n4, d4, d5, n5, n6, d6, d7, n7, n8, dArray, n9);
        this.println("");
    }

    @Override
    public void glDeformationMap3fSGIX(int n2, float f2, float f3, int n3, int n4, float f4, float f5, int n5, int n6, float f6, float f7, int n7, int n8, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glDeformationMap3fSGIX(" + n2 + "," + f2 + "," + f3 + "," + n3 + "," + n4 + "," + f4 + "," + f5 + "," + n5 + "," + n6 + "," + f6 + "," + f7 + "," + n7 + "," + n8 + "," + floatBuffer + ")");
        this.downstreamGL.glDeformationMap3fSGIX(n2, f2, f3, n3, n4, f4, f5, n5, n6, f6, f7, n7, n8, floatBuffer);
        this.println("");
    }

    @Override
    public void glDeformationMap3fSGIX(int n2, float f2, float f3, int n3, int n4, float f4, float f5, int n5, int n6, float f6, float f7, int n7, int n8, float[] fArray, int n9) {
        this.printIndent();
        this.print("glDeformationMap3fSGIX(" + n2 + "," + f2 + "," + f3 + "," + n3 + "," + n4 + "," + f4 + "," + f5 + "," + n5 + "," + n6 + "," + f6 + "," + f7 + "," + n7 + "," + n8 + "," + this.dumpArray(fArray) + "," + n9 + ")");
        this.downstreamGL.glDeformationMap3fSGIX(n2, f2, f3, n3, n4, f4, f5, n5, n6, f6, f7, n7, n8, fArray, n9);
        this.println("");
    }

    @Override
    public void glDeleteAsyncMarkersSGIX(int n2, int n3) {
        this.printIndent();
        this.print("glDeleteAsyncMarkersSGIX(" + n2 + "," + n3 + ")");
        this.downstreamGL.glDeleteAsyncMarkersSGIX(n2, n3);
        this.println("");
    }

    @Override
    public void glDeleteBufferRegion(int n2) {
        this.printIndent();
        this.print("glDeleteBufferRegion(" + n2 + ")");
        this.downstreamGL.glDeleteBufferRegion(n2);
        this.println("");
    }

    @Override
    public void glDeleteBuffers(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glDeleteBuffers(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glDeleteBuffers(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glDeleteBuffers(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glDeleteBuffers(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glDeleteBuffers(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glDeleteBuffersARB(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glDeleteBuffersARB(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glDeleteBuffersARB(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glDeleteBuffersARB(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glDeleteBuffersARB(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glDeleteBuffersARB(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glDeleteFencesAPPLE(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glDeleteFencesAPPLE(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glDeleteFencesAPPLE(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glDeleteFencesAPPLE(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glDeleteFencesAPPLE(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glDeleteFencesAPPLE(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glDeleteFencesNV(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glDeleteFencesNV(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glDeleteFencesNV(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glDeleteFencesNV(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glDeleteFencesNV(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glDeleteFencesNV(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glDeleteFragmentShaderATI(int n2) {
        this.printIndent();
        this.print("glDeleteFragmentShaderATI(" + n2 + ")");
        this.downstreamGL.glDeleteFragmentShaderATI(n2);
        this.println("");
    }

    @Override
    public void glDeleteFramebuffersEXT(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glDeleteFramebuffersEXT(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glDeleteFramebuffersEXT(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glDeleteFramebuffersEXT(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glDeleteFramebuffersEXT(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glDeleteFramebuffersEXT(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glDeleteLists(int n2, int n3) {
        this.printIndent();
        this.print("glDeleteLists(" + n2 + "," + n3 + ")");
        this.downstreamGL.glDeleteLists(n2, n3);
        this.println("");
    }

    @Override
    public void glDeleteObjectARB(int n2) {
        this.printIndent();
        this.print("glDeleteObjectARB(" + n2 + ")");
        this.downstreamGL.glDeleteObjectARB(n2);
        this.println("");
    }

    @Override
    public void glDeleteOcclusionQueriesNV(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glDeleteOcclusionQueriesNV(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glDeleteOcclusionQueriesNV(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glDeleteOcclusionQueriesNV(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glDeleteOcclusionQueriesNV(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glDeleteOcclusionQueriesNV(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glDeleteProgram(int n2) {
        this.printIndent();
        this.print("glDeleteProgram(" + n2 + ")");
        this.downstreamGL.glDeleteProgram(n2);
        this.println("");
    }

    @Override
    public void glDeleteProgramsARB(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glDeleteProgramsARB(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glDeleteProgramsARB(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glDeleteProgramsARB(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glDeleteProgramsARB(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glDeleteProgramsARB(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glDeleteProgramsNV(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glDeleteProgramsNV(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glDeleteProgramsNV(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glDeleteProgramsNV(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glDeleteProgramsNV(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glDeleteProgramsNV(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glDeleteQueries(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glDeleteQueries(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glDeleteQueries(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glDeleteQueries(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glDeleteQueries(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glDeleteQueries(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glDeleteQueriesARB(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glDeleteQueriesARB(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glDeleteQueriesARB(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glDeleteQueriesARB(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glDeleteQueriesARB(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glDeleteQueriesARB(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glDeleteRenderbuffersEXT(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glDeleteRenderbuffersEXT(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glDeleteRenderbuffersEXT(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glDeleteRenderbuffersEXT(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glDeleteRenderbuffersEXT(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glDeleteRenderbuffersEXT(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glDeleteShader(int n2) {
        this.printIndent();
        this.print("glDeleteShader(" + n2 + ")");
        this.downstreamGL.glDeleteShader(n2);
        this.println("");
    }

    @Override
    public void glDeleteTextures(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glDeleteTextures(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glDeleteTextures(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glDeleteTextures(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glDeleteTextures(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glDeleteTextures(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glDeleteVertexArraysAPPLE(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glDeleteVertexArraysAPPLE(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glDeleteVertexArraysAPPLE(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glDeleteVertexArraysAPPLE(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glDeleteVertexArraysAPPLE(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glDeleteVertexArraysAPPLE(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glDeleteVertexShaderEXT(int n2) {
        this.printIndent();
        this.print("glDeleteVertexShaderEXT(" + n2 + ")");
        this.downstreamGL.glDeleteVertexShaderEXT(n2);
        this.println("");
    }

    @Override
    public void glDepthBoundsEXT(double d2, double d3) {
        this.printIndent();
        this.print("glDepthBoundsEXT(" + d2 + "," + d3 + ")");
        this.downstreamGL.glDepthBoundsEXT(d2, d3);
        this.println("");
    }

    @Override
    public void glDepthBoundsdNV(double d2, double d3) {
        this.printIndent();
        this.print("glDepthBoundsdNV(" + d2 + "," + d3 + ")");
        this.downstreamGL.glDepthBoundsdNV(d2, d3);
        this.println("");
    }

    @Override
    public void glDepthFunc(int n2) {
        this.printIndent();
        this.print("glDepthFunc(" + n2 + ")");
        this.downstreamGL.glDepthFunc(n2);
        this.println("");
    }

    @Override
    public void glDepthMask(boolean bl) {
        this.printIndent();
        this.print("glDepthMask(" + bl + ")");
        this.downstreamGL.glDepthMask(bl);
        this.println("");
    }

    @Override
    public void glDepthRange(double d2, double d3) {
        this.printIndent();
        this.print("glDepthRange(" + d2 + "," + d3 + ")");
        this.downstreamGL.glDepthRange(d2, d3);
        this.println("");
    }

    @Override
    public void glDepthRangedNV(double d2, double d3) {
        this.printIndent();
        this.print("glDepthRangedNV(" + d2 + "," + d3 + ")");
        this.downstreamGL.glDepthRangedNV(d2, d3);
        this.println("");
    }

    @Override
    public void glDetachObjectARB(int n2, int n3) {
        this.printIndent();
        this.print("glDetachObjectARB(" + n2 + "," + n3 + ")");
        this.downstreamGL.glDetachObjectARB(n2, n3);
        this.println("");
    }

    @Override
    public void glDetachShader(int n2, int n3) {
        this.printIndent();
        this.print("glDetachShader(" + n2 + "," + n3 + ")");
        this.downstreamGL.glDetachShader(n2, n3);
        this.println("");
    }

    @Override
    public void glDetailTexFuncSGIS(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glDetailTexFuncSGIS(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glDetailTexFuncSGIS(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glDetailTexFuncSGIS(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glDetailTexFuncSGIS(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glDetailTexFuncSGIS(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glDisable(int n2) {
        this.printIndent();
        this.print("glDisable(" + n2 + ")");
        this.downstreamGL.glDisable(n2);
        this.println("");
    }

    @Override
    public void glDisableClientState(int n2) {
        this.printIndent();
        this.print("glDisableClientState(" + n2 + ")");
        this.downstreamGL.glDisableClientState(n2);
        this.println("");
    }

    @Override
    public void glDisableIndexedEXT(int n2, int n3) {
        this.printIndent();
        this.print("glDisableIndexedEXT(" + n2 + "," + n3 + ")");
        this.downstreamGL.glDisableIndexedEXT(n2, n3);
        this.println("");
    }

    @Override
    public void glDisableVariantClientStateEXT(int n2) {
        this.printIndent();
        this.print("glDisableVariantClientStateEXT(" + n2 + ")");
        this.downstreamGL.glDisableVariantClientStateEXT(n2);
        this.println("");
    }

    @Override
    public void glDisableVertexAttribAPPLE(int n2, int n3) {
        this.printIndent();
        this.print("glDisableVertexAttribAPPLE(" + n2 + "," + n3 + ")");
        this.downstreamGL.glDisableVertexAttribAPPLE(n2, n3);
        this.println("");
    }

    @Override
    public void glDisableVertexAttribArray(int n2) {
        this.printIndent();
        this.print("glDisableVertexAttribArray(" + n2 + ")");
        this.downstreamGL.glDisableVertexAttribArray(n2);
        this.println("");
    }

    @Override
    public void glDisableVertexAttribArrayARB(int n2) {
        this.printIndent();
        this.print("glDisableVertexAttribArrayARB(" + n2 + ")");
        this.downstreamGL.glDisableVertexAttribArrayARB(n2);
        this.println("");
    }

    @Override
    public void glDrawArrays(int n2, int n3, int n4) {
        this.printIndent();
        this.print("glDrawArrays(" + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glDrawArrays(n2, n3, n4);
        this.println("");
    }

    @Override
    public void glDrawArraysInstancedEXT(int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glDrawArraysInstancedEXT(" + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glDrawArraysInstancedEXT(n2, n3, n4, n5);
        this.println("");
    }

    @Override
    public void glDrawBuffer(int n2) {
        this.printIndent();
        this.print("glDrawBuffer(" + n2 + ")");
        this.downstreamGL.glDrawBuffer(n2);
        this.println("");
    }

    @Override
    public void glDrawBufferRegion(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.printIndent();
        this.print("glDrawBufferRegion(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + ")");
        this.downstreamGL.glDrawBufferRegion(n2, n3, n4, n5, n6, n7, n8);
        this.println("");
    }

    @Override
    public void glDrawBuffers(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glDrawBuffers(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glDrawBuffers(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glDrawBuffers(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glDrawBuffers(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glDrawBuffers(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glDrawBuffersARB(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glDrawBuffersARB(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glDrawBuffersARB(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glDrawBuffersARB(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glDrawBuffersARB(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glDrawBuffersARB(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glDrawBuffersATI(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glDrawBuffersATI(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glDrawBuffersATI(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glDrawBuffersATI(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glDrawBuffersATI(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glDrawBuffersATI(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glDrawElementArrayAPPLE(int n2, int n3, int n4) {
        this.printIndent();
        this.print("glDrawElementArrayAPPLE(" + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glDrawElementArrayAPPLE(n2, n3, n4);
        this.println("");
    }

    @Override
    public void glDrawElementArrayATI(int n2, int n3) {
        this.printIndent();
        this.print("glDrawElementArrayATI(" + n2 + "," + n3 + ")");
        this.downstreamGL.glDrawElementArrayATI(n2, n3);
        this.println("");
    }

    @Override
    public void glDrawElements(int n2, int n3, int n4, Buffer buffer) {
        this.printIndent();
        this.print("glDrawElements(" + n2 + "," + n3 + "," + n4 + "," + buffer + ")");
        this.downstreamGL.glDrawElements(n2, n3, n4, buffer);
        this.println("");
    }

    @Override
    public void glDrawElements(int n2, int n3, int n4, long l2) {
        this.printIndent();
        this.print("glDrawElements(" + n2 + "," + n3 + "," + n4 + "," + l2 + ")");
        this.downstreamGL.glDrawElements(n2, n3, n4, l2);
        this.println("");
    }

    @Override
    public void glDrawElementsInstancedEXT(int n2, int n3, int n4, Buffer buffer, int n5) {
        this.printIndent();
        this.print("glDrawElementsInstancedEXT(" + n2 + "," + n3 + "," + n4 + "," + buffer + "," + n5 + ")");
        this.downstreamGL.glDrawElementsInstancedEXT(n2, n3, n4, buffer, n5);
        this.println("");
    }

    @Override
    public void glDrawMeshArraysSUN(int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glDrawMeshArraysSUN(" + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glDrawMeshArraysSUN(n2, n3, n4, n5);
        this.println("");
    }

    @Override
    public void glDrawPixels(int n2, int n3, int n4, int n5, Buffer buffer) {
        this.printIndent();
        this.print("glDrawPixels(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + buffer + ")");
        this.downstreamGL.glDrawPixels(n2, n3, n4, n5, buffer);
        this.println("");
    }

    @Override
    public void glDrawPixels(int n2, int n3, int n4, int n5, long l2) {
        this.printIndent();
        this.print("glDrawPixels(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + l2 + ")");
        this.downstreamGL.glDrawPixels(n2, n3, n4, n5, l2);
        this.println("");
    }

    @Override
    public void glDrawRangeElementArrayAPPLE(int n2, int n3, int n4, int n5, int n6) {
        this.printIndent();
        this.print("glDrawRangeElementArrayAPPLE(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + ")");
        this.downstreamGL.glDrawRangeElementArrayAPPLE(n2, n3, n4, n5, n6);
        this.println("");
    }

    @Override
    public void glDrawRangeElementArrayATI(int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glDrawRangeElementArrayATI(" + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glDrawRangeElementArrayATI(n2, n3, n4, n5);
        this.println("");
    }

    @Override
    public void glDrawRangeElements(int n2, int n3, int n4, int n5, int n6, Buffer buffer) {
        this.printIndent();
        this.print("glDrawRangeElements(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + buffer + ")");
        this.downstreamGL.glDrawRangeElements(n2, n3, n4, n5, n6, buffer);
        this.println("");
    }

    @Override
    public void glDrawRangeElements(int n2, int n3, int n4, int n5, int n6, long l2) {
        this.printIndent();
        this.print("glDrawRangeElements(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + l2 + ")");
        this.downstreamGL.glDrawRangeElements(n2, n3, n4, n5, n6, l2);
        this.println("");
    }

    @Override
    public void glEdgeFlag(boolean bl) {
        this.printIndent();
        this.print("glEdgeFlag(" + bl + ")");
        this.downstreamGL.glEdgeFlag(bl);
        this.println("");
    }

    @Override
    public void glEdgeFlagPointer(int n2, Buffer buffer) {
        this.printIndent();
        this.print("glEdgeFlagPointer(" + n2 + "," + buffer + ")");
        this.downstreamGL.glEdgeFlagPointer(n2, buffer);
        this.println("");
    }

    @Override
    public void glEdgeFlagPointer(int n2, long l2) {
        this.printIndent();
        this.print("glEdgeFlagPointer(" + n2 + "," + l2 + ")");
        this.downstreamGL.glEdgeFlagPointer(n2, l2);
        this.println("");
    }

    @Override
    public void glEdgeFlagv(ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glEdgeFlagv(" + byteBuffer + ")");
        this.downstreamGL.glEdgeFlagv(byteBuffer);
        this.println("");
    }

    @Override
    public void glEdgeFlagv(byte[] byArray, int n2) {
        this.printIndent();
        this.print("glEdgeFlagv(" + this.dumpArray(byArray) + "," + n2 + ")");
        this.downstreamGL.glEdgeFlagv(byArray, n2);
        this.println("");
    }

    @Override
    public void glElementPointerAPPLE(int n2, Buffer buffer) {
        this.printIndent();
        this.print("glElementPointerAPPLE(" + n2 + "," + buffer + ")");
        this.downstreamGL.glElementPointerAPPLE(n2, buffer);
        this.println("");
    }

    @Override
    public void glElementPointerATI(int n2, Buffer buffer) {
        this.printIndent();
        this.print("glElementPointerATI(" + n2 + "," + buffer + ")");
        this.downstreamGL.glElementPointerATI(n2, buffer);
        this.println("");
    }

    @Override
    public void glElementPointerATI(int n2, long l2) {
        this.printIndent();
        this.print("glElementPointerATI(" + n2 + "," + l2 + ")");
        this.downstreamGL.glElementPointerATI(n2, l2);
        this.println("");
    }

    @Override
    public void glEnable(int n2) {
        this.printIndent();
        this.print("glEnable(" + n2 + ")");
        this.downstreamGL.glEnable(n2);
        this.println("");
    }

    @Override
    public void glEnableClientState(int n2) {
        this.printIndent();
        this.print("glEnableClientState(" + n2 + ")");
        this.downstreamGL.glEnableClientState(n2);
        this.println("");
    }

    @Override
    public void glEnableIndexedEXT(int n2, int n3) {
        this.printIndent();
        this.print("glEnableIndexedEXT(" + n2 + "," + n3 + ")");
        this.downstreamGL.glEnableIndexedEXT(n2, n3);
        this.println("");
    }

    @Override
    public void glEnableVariantClientStateEXT(int n2) {
        this.printIndent();
        this.print("glEnableVariantClientStateEXT(" + n2 + ")");
        this.downstreamGL.glEnableVariantClientStateEXT(n2);
        this.println("");
    }

    @Override
    public void glEnableVertexAttribAPPLE(int n2, int n3) {
        this.printIndent();
        this.print("glEnableVertexAttribAPPLE(" + n2 + "," + n3 + ")");
        this.downstreamGL.glEnableVertexAttribAPPLE(n2, n3);
        this.println("");
    }

    @Override
    public void glEnableVertexAttribArray(int n2) {
        this.printIndent();
        this.print("glEnableVertexAttribArray(" + n2 + ")");
        this.downstreamGL.glEnableVertexAttribArray(n2);
        this.println("");
    }

    @Override
    public void glEnableVertexAttribArrayARB(int n2) {
        this.printIndent();
        this.print("glEnableVertexAttribArrayARB(" + n2 + ")");
        this.downstreamGL.glEnableVertexAttribArrayARB(n2);
        this.println("");
    }

    @Override
    public void glEnd() {
        this.indent -= 2;
        this.printIndent();
        this.print("glEnd()");
        this.downstreamGL.glEnd();
        this.println("");
    }

    @Override
    public void glEndFragmentShaderATI() {
        this.printIndent();
        this.print("glEndFragmentShaderATI()");
        this.downstreamGL.glEndFragmentShaderATI();
        this.println("");
    }

    @Override
    public void glEndList() {
        this.indent -= 2;
        this.printIndent();
        this.print("glEndList()");
        this.downstreamGL.glEndList();
        this.println("");
    }

    @Override
    public void glEndOcclusionQueryNV() {
        this.printIndent();
        this.print("glEndOcclusionQueryNV()");
        this.downstreamGL.glEndOcclusionQueryNV();
        this.println("");
    }

    @Override
    public void glEndQuery(int n2) {
        this.printIndent();
        this.print("glEndQuery(" + n2 + ")");
        this.downstreamGL.glEndQuery(n2);
        this.println("");
    }

    @Override
    public void glEndQueryARB(int n2) {
        this.printIndent();
        this.print("glEndQueryARB(" + n2 + ")");
        this.downstreamGL.glEndQueryARB(n2);
        this.println("");
    }

    @Override
    public void glEndTransformFeedbackNV() {
        this.printIndent();
        this.print("glEndTransformFeedbackNV()");
        this.downstreamGL.glEndTransformFeedbackNV();
        this.println("");
    }

    @Override
    public void glEndVertexShaderEXT() {
        this.printIndent();
        this.print("glEndVertexShaderEXT()");
        this.downstreamGL.glEndVertexShaderEXT();
        this.println("");
    }

    @Override
    public void glEvalCoord1d(double d2) {
        this.printIndent();
        this.print("glEvalCoord1d(" + d2 + ")");
        this.downstreamGL.glEvalCoord1d(d2);
        this.println("");
    }

    @Override
    public void glEvalCoord1dv(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glEvalCoord1dv(" + doubleBuffer + ")");
        this.downstreamGL.glEvalCoord1dv(doubleBuffer);
        this.println("");
    }

    @Override
    public void glEvalCoord1dv(double[] dArray, int n2) {
        this.printIndent();
        this.print("glEvalCoord1dv(" + this.dumpArray(dArray) + "," + n2 + ")");
        this.downstreamGL.glEvalCoord1dv(dArray, n2);
        this.println("");
    }

    @Override
    public void glEvalCoord1f(float f2) {
        this.printIndent();
        this.print("glEvalCoord1f(" + f2 + ")");
        this.downstreamGL.glEvalCoord1f(f2);
        this.println("");
    }

    @Override
    public void glEvalCoord1fv(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glEvalCoord1fv(" + floatBuffer + ")");
        this.downstreamGL.glEvalCoord1fv(floatBuffer);
        this.println("");
    }

    @Override
    public void glEvalCoord1fv(float[] fArray, int n2) {
        this.printIndent();
        this.print("glEvalCoord1fv(" + this.dumpArray(fArray) + "," + n2 + ")");
        this.downstreamGL.glEvalCoord1fv(fArray, n2);
        this.println("");
    }

    @Override
    public void glEvalCoord2d(double d2, double d3) {
        this.printIndent();
        this.print("glEvalCoord2d(" + d2 + "," + d3 + ")");
        this.downstreamGL.glEvalCoord2d(d2, d3);
        this.println("");
    }

    @Override
    public void glEvalCoord2dv(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glEvalCoord2dv(" + doubleBuffer + ")");
        this.downstreamGL.glEvalCoord2dv(doubleBuffer);
        this.println("");
    }

    @Override
    public void glEvalCoord2dv(double[] dArray, int n2) {
        this.printIndent();
        this.print("glEvalCoord2dv(" + this.dumpArray(dArray) + "," + n2 + ")");
        this.downstreamGL.glEvalCoord2dv(dArray, n2);
        this.println("");
    }

    @Override
    public void glEvalCoord2f(float f2, float f3) {
        this.printIndent();
        this.print("glEvalCoord2f(" + f2 + "," + f3 + ")");
        this.downstreamGL.glEvalCoord2f(f2, f3);
        this.println("");
    }

    @Override
    public void glEvalCoord2fv(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glEvalCoord2fv(" + floatBuffer + ")");
        this.downstreamGL.glEvalCoord2fv(floatBuffer);
        this.println("");
    }

    @Override
    public void glEvalCoord2fv(float[] fArray, int n2) {
        this.printIndent();
        this.print("glEvalCoord2fv(" + this.dumpArray(fArray) + "," + n2 + ")");
        this.downstreamGL.glEvalCoord2fv(fArray, n2);
        this.println("");
    }

    @Override
    public void glEvalMapsNV(int n2, int n3) {
        this.printIndent();
        this.print("glEvalMapsNV(" + n2 + "," + n3 + ")");
        this.downstreamGL.glEvalMapsNV(n2, n3);
        this.println("");
    }

    @Override
    public void glEvalMesh1(int n2, int n3, int n4) {
        this.printIndent();
        this.print("glEvalMesh1(" + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glEvalMesh1(n2, n3, n4);
        this.println("");
    }

    @Override
    public void glEvalMesh2(int n2, int n3, int n4, int n5, int n6) {
        this.printIndent();
        this.print("glEvalMesh2(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + ")");
        this.downstreamGL.glEvalMesh2(n2, n3, n4, n5, n6);
        this.println("");
    }

    @Override
    public void glEvalPoint1(int n2) {
        this.printIndent();
        this.print("glEvalPoint1(" + n2 + ")");
        this.downstreamGL.glEvalPoint1(n2);
        this.println("");
    }

    @Override
    public void glEvalPoint2(int n2, int n3) {
        this.printIndent();
        this.print("glEvalPoint2(" + n2 + "," + n3 + ")");
        this.downstreamGL.glEvalPoint2(n2, n3);
        this.println("");
    }

    @Override
    public void glExecuteProgramNV(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glExecuteProgramNV(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glExecuteProgramNV(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glExecuteProgramNV(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glExecuteProgramNV(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glExecuteProgramNV(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glExtractComponentEXT(int n2, int n3, int n4) {
        this.printIndent();
        this.print("glExtractComponentEXT(" + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glExtractComponentEXT(n2, n3, n4);
        this.println("");
    }

    @Override
    public void glFeedbackBuffer(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glFeedbackBuffer(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glFeedbackBuffer(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glFinalCombinerInputNV(int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glFinalCombinerInputNV(" + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glFinalCombinerInputNV(n2, n3, n4, n5);
        this.println("");
    }

    @Override
    public void glFinish() {
        this.printIndent();
        this.print("glFinish()");
        this.downstreamGL.glFinish();
        this.println("");
    }

    @Override
    public int glFinishAsyncSGIX(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glFinishAsyncSGIX(" + intBuffer + ")");
        int n2 = this.downstreamGL.glFinishAsyncSGIX(intBuffer);
        this.println(" = " + n2);
        return n2;
    }

    @Override
    public int glFinishAsyncSGIX(int[] nArray, int n2) {
        this.printIndent();
        this.print("glFinishAsyncSGIX(" + this.dumpArray(nArray) + "," + n2 + ")");
        int n3 = this.downstreamGL.glFinishAsyncSGIX(nArray, n2);
        this.println(" = " + n3);
        return n3;
    }

    @Override
    public void glFinishFenceAPPLE(int n2) {
        this.printIndent();
        this.print("glFinishFenceAPPLE(" + n2 + ")");
        this.downstreamGL.glFinishFenceAPPLE(n2);
        this.println("");
    }

    @Override
    public void glFinishFenceNV(int n2) {
        this.printIndent();
        this.print("glFinishFenceNV(" + n2 + ")");
        this.downstreamGL.glFinishFenceNV(n2);
        this.println("");
    }

    @Override
    public void glFinishObjectAPPLE(int n2, int n3) {
        this.printIndent();
        this.print("glFinishObjectAPPLE(" + n2 + "," + n3 + ")");
        this.downstreamGL.glFinishObjectAPPLE(n2, n3);
        this.println("");
    }

    @Override
    public void glFinishRenderAPPLE() {
        this.printIndent();
        this.print("glFinishRenderAPPLE()");
        this.downstreamGL.glFinishRenderAPPLE();
        this.println("");
    }

    @Override
    public void glFinishTextureSUNX() {
        this.printIndent();
        this.print("glFinishTextureSUNX()");
        this.downstreamGL.glFinishTextureSUNX();
        this.println("");
    }

    @Override
    public void glFlush() {
        this.printIndent();
        this.print("glFlush()");
        this.downstreamGL.glFlush();
        this.println("");
    }

    @Override
    public void glFlushMappedBufferRangeAPPLE(int n2, int n3, int n4) {
        this.printIndent();
        this.print("glFlushMappedBufferRangeAPPLE(" + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glFlushMappedBufferRangeAPPLE(n2, n3, n4);
        this.println("");
    }

    @Override
    public void glFlushPixelDataRangeNV(int n2) {
        this.printIndent();
        this.print("glFlushPixelDataRangeNV(" + n2 + ")");
        this.downstreamGL.glFlushPixelDataRangeNV(n2);
        this.println("");
    }

    @Override
    public void glFlushRasterSGIX() {
        this.printIndent();
        this.print("glFlushRasterSGIX()");
        this.downstreamGL.glFlushRasterSGIX();
        this.println("");
    }

    @Override
    public void glFlushRenderAPPLE() {
        this.printIndent();
        this.print("glFlushRenderAPPLE()");
        this.downstreamGL.glFlushRenderAPPLE();
        this.println("");
    }

    @Override
    public void glFlushVertexArrayRangeAPPLE(int n2, Buffer buffer) {
        this.printIndent();
        this.print("glFlushVertexArrayRangeAPPLE(" + n2 + "," + buffer + ")");
        this.downstreamGL.glFlushVertexArrayRangeAPPLE(n2, buffer);
        this.println("");
    }

    @Override
    public void glFlushVertexArrayRangeNV() {
        this.printIndent();
        this.print("glFlushVertexArrayRangeNV()");
        this.downstreamGL.glFlushVertexArrayRangeNV();
        this.println("");
    }

    @Override
    public void glFogCoordPointer(int n2, int n3, Buffer buffer) {
        this.printIndent();
        this.print("glFogCoordPointer(" + n2 + "," + n3 + "," + buffer + ")");
        this.downstreamGL.glFogCoordPointer(n2, n3, buffer);
        this.println("");
    }

    @Override
    public void glFogCoordPointer(int n2, int n3, long l2) {
        this.printIndent();
        this.print("glFogCoordPointer(" + n2 + "," + n3 + "," + l2 + ")");
        this.downstreamGL.glFogCoordPointer(n2, n3, l2);
        this.println("");
    }

    @Override
    public void glFogCoordPointerEXT(int n2, int n3, Buffer buffer) {
        this.printIndent();
        this.print("glFogCoordPointerEXT(" + n2 + "," + n3 + "," + buffer + ")");
        this.downstreamGL.glFogCoordPointerEXT(n2, n3, buffer);
        this.println("");
    }

    @Override
    public void glFogCoordPointerEXT(int n2, int n3, long l2) {
        this.printIndent();
        this.print("glFogCoordPointerEXT(" + n2 + "," + n3 + "," + l2 + ")");
        this.downstreamGL.glFogCoordPointerEXT(n2, n3, l2);
        this.println("");
    }

    @Override
    public void glFogCoordd(double d2) {
        this.printIndent();
        this.print("glFogCoordd(" + d2 + ")");
        this.downstreamGL.glFogCoordd(d2);
        this.println("");
    }

    @Override
    public void glFogCoorddEXT(double d2) {
        this.printIndent();
        this.print("glFogCoorddEXT(" + d2 + ")");
        this.downstreamGL.glFogCoorddEXT(d2);
        this.println("");
    }

    @Override
    public void glFogCoorddv(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glFogCoorddv(" + doubleBuffer + ")");
        this.downstreamGL.glFogCoorddv(doubleBuffer);
        this.println("");
    }

    @Override
    public void glFogCoorddv(double[] dArray, int n2) {
        this.printIndent();
        this.print("glFogCoorddv(" + this.dumpArray(dArray) + "," + n2 + ")");
        this.downstreamGL.glFogCoorddv(dArray, n2);
        this.println("");
    }

    @Override
    public void glFogCoorddvEXT(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glFogCoorddvEXT(" + doubleBuffer + ")");
        this.downstreamGL.glFogCoorddvEXT(doubleBuffer);
        this.println("");
    }

    @Override
    public void glFogCoorddvEXT(double[] dArray, int n2) {
        this.printIndent();
        this.print("glFogCoorddvEXT(" + this.dumpArray(dArray) + "," + n2 + ")");
        this.downstreamGL.glFogCoorddvEXT(dArray, n2);
        this.println("");
    }

    @Override
    public void glFogCoordf(float f2) {
        this.printIndent();
        this.print("glFogCoordf(" + f2 + ")");
        this.downstreamGL.glFogCoordf(f2);
        this.println("");
    }

    @Override
    public void glFogCoordfEXT(float f2) {
        this.printIndent();
        this.print("glFogCoordfEXT(" + f2 + ")");
        this.downstreamGL.glFogCoordfEXT(f2);
        this.println("");
    }

    @Override
    public void glFogCoordfv(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glFogCoordfv(" + floatBuffer + ")");
        this.downstreamGL.glFogCoordfv(floatBuffer);
        this.println("");
    }

    @Override
    public void glFogCoordfv(float[] fArray, int n2) {
        this.printIndent();
        this.print("glFogCoordfv(" + this.dumpArray(fArray) + "," + n2 + ")");
        this.downstreamGL.glFogCoordfv(fArray, n2);
        this.println("");
    }

    @Override
    public void glFogCoordfvEXT(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glFogCoordfvEXT(" + floatBuffer + ")");
        this.downstreamGL.glFogCoordfvEXT(floatBuffer);
        this.println("");
    }

    @Override
    public void glFogCoordfvEXT(float[] fArray, int n2) {
        this.printIndent();
        this.print("glFogCoordfvEXT(" + this.dumpArray(fArray) + "," + n2 + ")");
        this.downstreamGL.glFogCoordfvEXT(fArray, n2);
        this.println("");
    }

    @Override
    public void glFogCoordhNV(short s2) {
        this.printIndent();
        this.print("glFogCoordhNV(" + s2 + ")");
        this.downstreamGL.glFogCoordhNV(s2);
        this.println("");
    }

    @Override
    public void glFogCoordhvNV(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glFogCoordhvNV(" + shortBuffer + ")");
        this.downstreamGL.glFogCoordhvNV(shortBuffer);
        this.println("");
    }

    @Override
    public void glFogCoordhvNV(short[] sArray, int n2) {
        this.printIndent();
        this.print("glFogCoordhvNV(" + this.dumpArray(sArray) + "," + n2 + ")");
        this.downstreamGL.glFogCoordhvNV(sArray, n2);
        this.println("");
    }

    @Override
    public void glFogFuncSGIS(int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glFogFuncSGIS(" + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glFogFuncSGIS(n2, floatBuffer);
        this.println("");
    }

    @Override
    public void glFogFuncSGIS(int n2, float[] fArray, int n3) {
        this.printIndent();
        this.print("glFogFuncSGIS(" + n2 + "," + this.dumpArray(fArray) + "," + n3 + ")");
        this.downstreamGL.glFogFuncSGIS(n2, fArray, n3);
        this.println("");
    }

    @Override
    public void glFogf(int n2, float f2) {
        this.printIndent();
        this.print("glFogf(" + n2 + "," + f2 + ")");
        this.downstreamGL.glFogf(n2, f2);
        this.println("");
    }

    @Override
    public void glFogfv(int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glFogfv(" + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glFogfv(n2, floatBuffer);
        this.println("");
    }

    @Override
    public void glFogfv(int n2, float[] fArray, int n3) {
        this.printIndent();
        this.print("glFogfv(" + n2 + "," + this.dumpArray(fArray) + "," + n3 + ")");
        this.downstreamGL.glFogfv(n2, fArray, n3);
        this.println("");
    }

    @Override
    public void glFogi(int n2, int n3) {
        this.printIndent();
        this.print("glFogi(" + n2 + "," + n3 + ")");
        this.downstreamGL.glFogi(n2, n3);
        this.println("");
    }

    @Override
    public void glFogiv(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glFogiv(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glFogiv(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glFogiv(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glFogiv(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glFogiv(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glFragmentColorMaterialSGIX(int n2, int n3) {
        this.printIndent();
        this.print("glFragmentColorMaterialSGIX(" + n2 + "," + n3 + ")");
        this.downstreamGL.glFragmentColorMaterialSGIX(n2, n3);
        this.println("");
    }

    @Override
    public void glFragmentLightModelfSGIX(int n2, float f2) {
        this.printIndent();
        this.print("glFragmentLightModelfSGIX(" + n2 + "," + f2 + ")");
        this.downstreamGL.glFragmentLightModelfSGIX(n2, f2);
        this.println("");
    }

    @Override
    public void glFragmentLightModelfvSGIX(int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glFragmentLightModelfvSGIX(" + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glFragmentLightModelfvSGIX(n2, floatBuffer);
        this.println("");
    }

    @Override
    public void glFragmentLightModelfvSGIX(int n2, float[] fArray, int n3) {
        this.printIndent();
        this.print("glFragmentLightModelfvSGIX(" + n2 + "," + this.dumpArray(fArray) + "," + n3 + ")");
        this.downstreamGL.glFragmentLightModelfvSGIX(n2, fArray, n3);
        this.println("");
    }

    @Override
    public void glFragmentLightModeliSGIX(int n2, int n3) {
        this.printIndent();
        this.print("glFragmentLightModeliSGIX(" + n2 + "," + n3 + ")");
        this.downstreamGL.glFragmentLightModeliSGIX(n2, n3);
        this.println("");
    }

    @Override
    public void glFragmentLightModelivSGIX(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glFragmentLightModelivSGIX(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glFragmentLightModelivSGIX(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glFragmentLightModelivSGIX(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glFragmentLightModelivSGIX(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glFragmentLightModelivSGIX(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glFragmentLightfSGIX(int n2, int n3, float f2) {
        this.printIndent();
        this.print("glFragmentLightfSGIX(" + n2 + "," + n3 + "," + f2 + ")");
        this.downstreamGL.glFragmentLightfSGIX(n2, n3, f2);
        this.println("");
    }

    @Override
    public void glFragmentLightfvSGIX(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glFragmentLightfvSGIX(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glFragmentLightfvSGIX(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glFragmentLightfvSGIX(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glFragmentLightfvSGIX(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glFragmentLightfvSGIX(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glFragmentLightiSGIX(int n2, int n3, int n4) {
        this.printIndent();
        this.print("glFragmentLightiSGIX(" + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glFragmentLightiSGIX(n2, n3, n4);
        this.println("");
    }

    @Override
    public void glFragmentLightivSGIX(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glFragmentLightivSGIX(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glFragmentLightivSGIX(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glFragmentLightivSGIX(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glFragmentLightivSGIX(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glFragmentLightivSGIX(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glFragmentMaterialfSGIX(int n2, int n3, float f2) {
        this.printIndent();
        this.print("glFragmentMaterialfSGIX(" + n2 + "," + n3 + "," + f2 + ")");
        this.downstreamGL.glFragmentMaterialfSGIX(n2, n3, f2);
        this.println("");
    }

    @Override
    public void glFragmentMaterialfvSGIX(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glFragmentMaterialfvSGIX(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glFragmentMaterialfvSGIX(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glFragmentMaterialfvSGIX(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glFragmentMaterialfvSGIX(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glFragmentMaterialfvSGIX(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glFragmentMaterialiSGIX(int n2, int n3, int n4) {
        this.printIndent();
        this.print("glFragmentMaterialiSGIX(" + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glFragmentMaterialiSGIX(n2, n3, n4);
        this.println("");
    }

    @Override
    public void glFragmentMaterialivSGIX(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glFragmentMaterialivSGIX(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glFragmentMaterialivSGIX(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glFragmentMaterialivSGIX(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glFragmentMaterialivSGIX(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glFragmentMaterialivSGIX(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glFrameZoomSGIX(int n2) {
        this.printIndent();
        this.print("glFrameZoomSGIX(" + n2 + ")");
        this.downstreamGL.glFrameZoomSGIX(n2);
        this.println("");
    }

    @Override
    public void glFramebufferRenderbufferEXT(int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glFramebufferRenderbufferEXT(" + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glFramebufferRenderbufferEXT(n2, n3, n4, n5);
        this.println("");
    }

    @Override
    public void glFramebufferTexture1DEXT(int n2, int n3, int n4, int n5, int n6) {
        this.printIndent();
        this.print("glFramebufferTexture1DEXT(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + ")");
        this.downstreamGL.glFramebufferTexture1DEXT(n2, n3, n4, n5, n6);
        this.println("");
    }

    @Override
    public void glFramebufferTexture2DEXT(int n2, int n3, int n4, int n5, int n6) {
        this.printIndent();
        this.print("glFramebufferTexture2DEXT(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + ")");
        this.downstreamGL.glFramebufferTexture2DEXT(n2, n3, n4, n5, n6);
        this.println("");
    }

    @Override
    public void glFramebufferTexture3DEXT(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.printIndent();
        this.print("glFramebufferTexture3DEXT(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + ")");
        this.downstreamGL.glFramebufferTexture3DEXT(n2, n3, n4, n5, n6, n7);
        this.println("");
    }

    @Override
    public void glFramebufferTextureEXT(int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glFramebufferTextureEXT(" + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glFramebufferTextureEXT(n2, n3, n4, n5);
        this.println("");
    }

    @Override
    public void glFramebufferTextureFaceEXT(int n2, int n3, int n4, int n5, int n6) {
        this.printIndent();
        this.print("glFramebufferTextureFaceEXT(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + ")");
        this.downstreamGL.glFramebufferTextureFaceEXT(n2, n3, n4, n5, n6);
        this.println("");
    }

    @Override
    public void glFramebufferTextureLayerEXT(int n2, int n3, int n4, int n5, int n6) {
        this.printIndent();
        this.print("glFramebufferTextureLayerEXT(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + ")");
        this.downstreamGL.glFramebufferTextureLayerEXT(n2, n3, n4, n5, n6);
        this.println("");
    }

    @Override
    public void glFreeObjectBufferATI(int n2) {
        this.printIndent();
        this.print("glFreeObjectBufferATI(" + n2 + ")");
        this.downstreamGL.glFreeObjectBufferATI(n2);
        this.println("");
    }

    @Override
    public void glFrontFace(int n2) {
        this.printIndent();
        this.print("glFrontFace(" + n2 + ")");
        this.downstreamGL.glFrontFace(n2);
        this.println("");
    }

    @Override
    public void glFrustum(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.printIndent();
        this.print("glFrustum(" + d2 + "," + d3 + "," + d4 + "," + d5 + "," + d6 + "," + d7 + ")");
        this.downstreamGL.glFrustum(d2, d3, d4, d5, d6, d7);
        this.println("");
    }

    @Override
    public int glGenAsyncMarkersSGIX(int n2) {
        this.printIndent();
        this.print("glGenAsyncMarkersSGIX(" + n2 + ")");
        n2 = this.downstreamGL.glGenAsyncMarkersSGIX(n2);
        this.println(" = " + n2);
        return n2;
    }

    @Override
    public void glGenBuffers(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGenBuffers(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGenBuffers(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glGenBuffers(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glGenBuffers(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glGenBuffers(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glGenBuffersARB(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGenBuffersARB(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGenBuffersARB(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glGenBuffersARB(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glGenBuffersARB(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glGenBuffersARB(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glGenFencesAPPLE(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGenFencesAPPLE(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGenFencesAPPLE(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glGenFencesAPPLE(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glGenFencesAPPLE(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glGenFencesAPPLE(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glGenFencesNV(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGenFencesNV(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGenFencesNV(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glGenFencesNV(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glGenFencesNV(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glGenFencesNV(n2, nArray, n3);
        this.println("");
    }

    @Override
    public int glGenFragmentShadersATI(int n2) {
        this.printIndent();
        this.print("glGenFragmentShadersATI(" + n2 + ")");
        n2 = this.downstreamGL.glGenFragmentShadersATI(n2);
        this.println(" = " + n2);
        return n2;
    }

    @Override
    public void glGenFramebuffersEXT(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGenFramebuffersEXT(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGenFramebuffersEXT(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glGenFramebuffersEXT(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glGenFramebuffersEXT(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glGenFramebuffersEXT(n2, nArray, n3);
        this.println("");
    }

    @Override
    public int glGenLists(int n2) {
        this.printIndent();
        this.print("glGenLists(" + n2 + ")");
        n2 = this.downstreamGL.glGenLists(n2);
        this.println(" = " + n2);
        return n2;
    }

    @Override
    public void glGenOcclusionQueriesNV(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGenOcclusionQueriesNV(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGenOcclusionQueriesNV(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glGenOcclusionQueriesNV(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glGenOcclusionQueriesNV(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glGenOcclusionQueriesNV(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glGenProgramsARB(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGenProgramsARB(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGenProgramsARB(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glGenProgramsARB(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glGenProgramsARB(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glGenProgramsARB(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glGenProgramsNV(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGenProgramsNV(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGenProgramsNV(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glGenProgramsNV(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glGenProgramsNV(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glGenProgramsNV(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glGenQueries(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGenQueries(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGenQueries(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glGenQueries(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glGenQueries(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glGenQueries(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glGenQueriesARB(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGenQueriesARB(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGenQueriesARB(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glGenQueriesARB(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glGenQueriesARB(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glGenQueriesARB(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glGenRenderbuffersEXT(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGenRenderbuffersEXT(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGenRenderbuffersEXT(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glGenRenderbuffersEXT(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glGenRenderbuffersEXT(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glGenRenderbuffersEXT(n2, nArray, n3);
        this.println("");
    }

    @Override
    public int glGenSymbolsEXT(int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glGenSymbolsEXT(" + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        n2 = this.downstreamGL.glGenSymbolsEXT(n2, n3, n4, n5);
        this.println(" = " + n2);
        return n2;
    }

    @Override
    public void glGenTextures(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGenTextures(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGenTextures(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glGenTextures(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glGenTextures(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glGenTextures(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glGenVertexArraysAPPLE(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGenVertexArraysAPPLE(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGenVertexArraysAPPLE(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glGenVertexArraysAPPLE(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glGenVertexArraysAPPLE(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glGenVertexArraysAPPLE(n2, nArray, n3);
        this.println("");
    }

    @Override
    public int glGenVertexShadersEXT(int n2) {
        this.printIndent();
        this.print("glGenVertexShadersEXT(" + n2 + ")");
        n2 = this.downstreamGL.glGenVertexShadersEXT(n2);
        this.println(" = " + n2);
        return n2;
    }

    @Override
    public void glGenerateMipmapEXT(int n2) {
        this.printIndent();
        this.print("glGenerateMipmapEXT(" + n2 + ")");
        this.downstreamGL.glGenerateMipmapEXT(n2);
        this.println("");
    }

    @Override
    public void glGetActiveAttrib(int n2, int n3, int n4, IntBuffer intBuffer, IntBuffer intBuffer2, IntBuffer intBuffer3, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glGetActiveAttrib(" + n2 + "," + n3 + "," + n4 + "," + intBuffer + "," + intBuffer2 + "," + intBuffer3 + "," + byteBuffer + ")");
        this.downstreamGL.glGetActiveAttrib(n2, n3, n4, intBuffer, intBuffer2, intBuffer3, byteBuffer);
        this.println("");
    }

    @Override
    public void glGetActiveAttrib(int n2, int n3, int n4, int[] nArray, int n5, int[] nArray2, int n6, int[] nArray3, int n7, byte[] byArray, int n8) {
        this.printIndent();
        this.print("glGetActiveAttrib(" + n2 + "," + n3 + "," + n4 + "," + this.dumpArray(nArray) + "," + n5 + "," + this.dumpArray(nArray2) + "," + n6 + "," + this.dumpArray(nArray3) + "," + n7 + "," + this.dumpArray(byArray) + "," + n8 + ")");
        this.downstreamGL.glGetActiveAttrib(n2, n3, n4, nArray, n5, nArray2, n6, nArray3, n7, byArray, n8);
        this.println("");
    }

    @Override
    public void glGetActiveAttribARB(int n2, int n3, int n4, IntBuffer intBuffer, IntBuffer intBuffer2, IntBuffer intBuffer3, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glGetActiveAttribARB(" + n2 + "," + n3 + "," + n4 + "," + intBuffer + "," + intBuffer2 + "," + intBuffer3 + "," + byteBuffer + ")");
        this.downstreamGL.glGetActiveAttribARB(n2, n3, n4, intBuffer, intBuffer2, intBuffer3, byteBuffer);
        this.println("");
    }

    @Override
    public void glGetActiveAttribARB(int n2, int n3, int n4, int[] nArray, int n5, int[] nArray2, int n6, int[] nArray3, int n7, byte[] byArray, int n8) {
        this.printIndent();
        this.print("glGetActiveAttribARB(" + n2 + "," + n3 + "," + n4 + "," + this.dumpArray(nArray) + "," + n5 + "," + this.dumpArray(nArray2) + "," + n6 + "," + this.dumpArray(nArray3) + "," + n7 + "," + this.dumpArray(byArray) + "," + n8 + ")");
        this.downstreamGL.glGetActiveAttribARB(n2, n3, n4, nArray, n5, nArray2, n6, nArray3, n7, byArray, n8);
        this.println("");
    }

    @Override
    public void glGetActiveUniform(int n2, int n3, int n4, IntBuffer intBuffer, IntBuffer intBuffer2, IntBuffer intBuffer3, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glGetActiveUniform(" + n2 + "," + n3 + "," + n4 + "," + intBuffer + "," + intBuffer2 + "," + intBuffer3 + "," + byteBuffer + ")");
        this.downstreamGL.glGetActiveUniform(n2, n3, n4, intBuffer, intBuffer2, intBuffer3, byteBuffer);
        this.println("");
    }

    @Override
    public void glGetActiveUniform(int n2, int n3, int n4, int[] nArray, int n5, int[] nArray2, int n6, int[] nArray3, int n7, byte[] byArray, int n8) {
        this.printIndent();
        this.print("glGetActiveUniform(" + n2 + "," + n3 + "," + n4 + "," + this.dumpArray(nArray) + "," + n5 + "," + this.dumpArray(nArray2) + "," + n6 + "," + this.dumpArray(nArray3) + "," + n7 + "," + this.dumpArray(byArray) + "," + n8 + ")");
        this.downstreamGL.glGetActiveUniform(n2, n3, n4, nArray, n5, nArray2, n6, nArray3, n7, byArray, n8);
        this.println("");
    }

    @Override
    public void glGetActiveUniformARB(int n2, int n3, int n4, IntBuffer intBuffer, IntBuffer intBuffer2, IntBuffer intBuffer3, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glGetActiveUniformARB(" + n2 + "," + n3 + "," + n4 + "," + intBuffer + "," + intBuffer2 + "," + intBuffer3 + "," + byteBuffer + ")");
        this.downstreamGL.glGetActiveUniformARB(n2, n3, n4, intBuffer, intBuffer2, intBuffer3, byteBuffer);
        this.println("");
    }

    @Override
    public void glGetActiveUniformARB(int n2, int n3, int n4, int[] nArray, int n5, int[] nArray2, int n6, int[] nArray3, int n7, byte[] byArray, int n8) {
        this.printIndent();
        this.print("glGetActiveUniformARB(" + n2 + "," + n3 + "," + n4 + "," + this.dumpArray(nArray) + "," + n5 + "," + this.dumpArray(nArray2) + "," + n6 + "," + this.dumpArray(nArray3) + "," + n7 + "," + this.dumpArray(byArray) + "," + n8 + ")");
        this.downstreamGL.glGetActiveUniformARB(n2, n3, n4, nArray, n5, nArray2, n6, nArray3, n7, byArray, n8);
        this.println("");
    }

    @Override
    public void glGetActiveVaryingNV(int n2, int n3, int n4, IntBuffer intBuffer, IntBuffer intBuffer2, IntBuffer intBuffer3, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glGetActiveVaryingNV(" + n2 + "," + n3 + "," + n4 + "," + intBuffer + "," + intBuffer2 + "," + intBuffer3 + "," + byteBuffer + ")");
        this.downstreamGL.glGetActiveVaryingNV(n2, n3, n4, intBuffer, intBuffer2, intBuffer3, byteBuffer);
        this.println("");
    }

    @Override
    public void glGetActiveVaryingNV(int n2, int n3, int n4, int[] nArray, int n5, int[] nArray2, int n6, int[] nArray3, int n7, byte[] byArray, int n8) {
        this.printIndent();
        this.print("glGetActiveVaryingNV(" + n2 + "," + n3 + "," + n4 + "," + this.dumpArray(nArray) + "," + n5 + "," + this.dumpArray(nArray2) + "," + n6 + "," + this.dumpArray(nArray3) + "," + n7 + "," + this.dumpArray(byArray) + "," + n8 + ")");
        this.downstreamGL.glGetActiveVaryingNV(n2, n3, n4, nArray, n5, nArray2, n6, nArray3, n7, byArray, n8);
        this.println("");
    }

    @Override
    public void glGetArrayObjectfvATI(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetArrayObjectfvATI(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glGetArrayObjectfvATI(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glGetArrayObjectfvATI(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glGetArrayObjectfvATI(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glGetArrayObjectfvATI(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glGetArrayObjectivATI(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetArrayObjectivATI(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetArrayObjectivATI(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetArrayObjectivATI(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetArrayObjectivATI(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetArrayObjectivATI(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGetAttachedObjectsARB(int n2, int n3, IntBuffer intBuffer, IntBuffer intBuffer2) {
        this.printIndent();
        this.print("glGetAttachedObjectsARB(" + n2 + "," + n3 + "," + intBuffer + "," + intBuffer2 + ")");
        this.downstreamGL.glGetAttachedObjectsARB(n2, n3, intBuffer, intBuffer2);
        this.println("");
    }

    @Override
    public void glGetAttachedObjectsARB(int n2, int n3, int[] nArray, int n4, int[] nArray2, int n5) {
        this.printIndent();
        this.print("glGetAttachedObjectsARB(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + "," + this.dumpArray(nArray2) + "," + n5 + ")");
        this.downstreamGL.glGetAttachedObjectsARB(n2, n3, nArray, n4, nArray2, n5);
        this.println("");
    }

    @Override
    public void glGetAttachedShaders(int n2, int n3, IntBuffer intBuffer, IntBuffer intBuffer2) {
        this.printIndent();
        this.print("glGetAttachedShaders(" + n2 + "," + n3 + "," + intBuffer + "," + intBuffer2 + ")");
        this.downstreamGL.glGetAttachedShaders(n2, n3, intBuffer, intBuffer2);
        this.println("");
    }

    @Override
    public void glGetAttachedShaders(int n2, int n3, int[] nArray, int n4, int[] nArray2, int n5) {
        this.printIndent();
        this.print("glGetAttachedShaders(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + "," + this.dumpArray(nArray2) + "," + n5 + ")");
        this.downstreamGL.glGetAttachedShaders(n2, n3, nArray, n4, nArray2, n5);
        this.println("");
    }

    @Override
    public int glGetAttribLocation(int n2, String string) {
        this.printIndent();
        this.print("glGetAttribLocation(" + n2 + "," + string + ")");
        n2 = this.downstreamGL.glGetAttribLocation(n2, string);
        this.println(" = " + n2);
        return n2;
    }

    @Override
    public int glGetAttribLocationARB(int n2, String string) {
        this.printIndent();
        this.print("glGetAttribLocationARB(" + n2 + "," + string + ")");
        n2 = this.downstreamGL.glGetAttribLocationARB(n2, string);
        this.println(" = " + n2);
        return n2;
    }

    @Override
    public void glGetBooleanIndexedvEXT(int n2, int n3, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glGetBooleanIndexedvEXT(" + n2 + "," + n3 + "," + byteBuffer + ")");
        this.downstreamGL.glGetBooleanIndexedvEXT(n2, n3, byteBuffer);
        this.println("");
    }

    @Override
    public void glGetBooleanIndexedvEXT(int n2, int n3, byte[] byArray, int n4) {
        this.printIndent();
        this.print("glGetBooleanIndexedvEXT(" + n2 + "," + n3 + "," + this.dumpArray(byArray) + "," + n4 + ")");
        this.downstreamGL.glGetBooleanIndexedvEXT(n2, n3, byArray, n4);
        this.println("");
    }

    @Override
    public void glGetBooleanv(int n2, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glGetBooleanv(" + n2 + "," + byteBuffer + ")");
        this.downstreamGL.glGetBooleanv(n2, byteBuffer);
        this.println("");
    }

    @Override
    public void glGetBooleanv(int n2, byte[] byArray, int n3) {
        this.printIndent();
        this.print("glGetBooleanv(" + n2 + "," + this.dumpArray(byArray) + "," + n3 + ")");
        this.downstreamGL.glGetBooleanv(n2, byArray, n3);
        this.println("");
    }

    @Override
    public void glGetBufferParameteriv(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetBufferParameteriv(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetBufferParameteriv(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetBufferParameteriv(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetBufferParameteriv(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetBufferParameteriv(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGetBufferParameterivARB(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetBufferParameterivARB(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetBufferParameterivARB(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetBufferParameterivARB(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetBufferParameterivARB(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetBufferParameterivARB(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGetBufferSubData(int n2, int n3, int n4, Buffer buffer) {
        this.printIndent();
        this.print("glGetBufferSubData(" + n2 + "," + n3 + "," + n4 + "," + buffer + ")");
        this.downstreamGL.glGetBufferSubData(n2, n3, n4, buffer);
        this.println("");
    }

    @Override
    public void glGetBufferSubDataARB(int n2, int n3, int n4, Buffer buffer) {
        this.printIndent();
        this.print("glGetBufferSubDataARB(" + n2 + "," + n3 + "," + n4 + "," + buffer + ")");
        this.downstreamGL.glGetBufferSubDataARB(n2, n3, n4, buffer);
        this.println("");
    }

    @Override
    public void glGetClipPlane(int n2, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glGetClipPlane(" + n2 + "," + doubleBuffer + ")");
        this.downstreamGL.glGetClipPlane(n2, doubleBuffer);
        this.println("");
    }

    @Override
    public void glGetClipPlane(int n2, double[] dArray, int n3) {
        this.printIndent();
        this.print("glGetClipPlane(" + n2 + "," + this.dumpArray(dArray) + "," + n3 + ")");
        this.downstreamGL.glGetClipPlane(n2, dArray, n3);
        this.println("");
    }

    @Override
    public void glGetColorTable(int n2, int n3, int n4, Buffer buffer) {
        this.printIndent();
        this.print("glGetColorTable(" + n2 + "," + n3 + "," + n4 + "," + buffer + ")");
        this.downstreamGL.glGetColorTable(n2, n3, n4, buffer);
        this.println("");
    }

    @Override
    public void glGetColorTable(int n2, int n3, int n4, long l2) {
        this.printIndent();
        this.print("glGetColorTable(" + n2 + "," + n3 + "," + n4 + "," + l2 + ")");
        this.downstreamGL.glGetColorTable(n2, n3, n4, l2);
        this.println("");
    }

    @Override
    public void glGetColorTableEXT(int n2, int n3, int n4, Buffer buffer) {
        this.printIndent();
        this.print("glGetColorTableEXT(" + n2 + "," + n3 + "," + n4 + "," + buffer + ")");
        this.downstreamGL.glGetColorTableEXT(n2, n3, n4, buffer);
        this.println("");
    }

    @Override
    public void glGetColorTableParameterfv(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetColorTableParameterfv(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glGetColorTableParameterfv(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glGetColorTableParameterfv(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glGetColorTableParameterfv(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glGetColorTableParameterfv(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glGetColorTableParameterfvEXT(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetColorTableParameterfvEXT(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glGetColorTableParameterfvEXT(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glGetColorTableParameterfvEXT(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glGetColorTableParameterfvEXT(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glGetColorTableParameterfvEXT(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glGetColorTableParameteriv(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetColorTableParameteriv(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetColorTableParameteriv(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetColorTableParameteriv(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetColorTableParameteriv(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetColorTableParameteriv(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGetColorTableParameterivEXT(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetColorTableParameterivEXT(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetColorTableParameterivEXT(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetColorTableParameterivEXT(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetColorTableParameterivEXT(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetColorTableParameterivEXT(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGetCombinerInputParameterfvNV(int n2, int n3, int n4, int n5, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetCombinerInputParameterfvNV(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + floatBuffer + ")");
        this.downstreamGL.glGetCombinerInputParameterfvNV(n2, n3, n4, n5, floatBuffer);
        this.println("");
    }

    @Override
    public void glGetCombinerInputParameterfvNV(int n2, int n3, int n4, int n5, float[] fArray, int n6) {
        this.printIndent();
        this.print("glGetCombinerInputParameterfvNV(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(fArray) + "," + n6 + ")");
        this.downstreamGL.glGetCombinerInputParameterfvNV(n2, n3, n4, n5, fArray, n6);
        this.println("");
    }

    @Override
    public void glGetCombinerInputParameterivNV(int n2, int n3, int n4, int n5, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetCombinerInputParameterivNV(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + intBuffer + ")");
        this.downstreamGL.glGetCombinerInputParameterivNV(n2, n3, n4, n5, intBuffer);
        this.println("");
    }

    @Override
    public void glGetCombinerInputParameterivNV(int n2, int n3, int n4, int n5, int[] nArray, int n6) {
        this.printIndent();
        this.print("glGetCombinerInputParameterivNV(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(nArray) + "," + n6 + ")");
        this.downstreamGL.glGetCombinerInputParameterivNV(n2, n3, n4, n5, nArray, n6);
        this.println("");
    }

    @Override
    public void glGetCombinerOutputParameterfvNV(int n2, int n3, int n4, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetCombinerOutputParameterfvNV(" + n2 + "," + n3 + "," + n4 + "," + floatBuffer + ")");
        this.downstreamGL.glGetCombinerOutputParameterfvNV(n2, n3, n4, floatBuffer);
        this.println("");
    }

    @Override
    public void glGetCombinerOutputParameterfvNV(int n2, int n3, int n4, float[] fArray, int n5) {
        this.printIndent();
        this.print("glGetCombinerOutputParameterfvNV(" + n2 + "," + n3 + "," + n4 + "," + this.dumpArray(fArray) + "," + n5 + ")");
        this.downstreamGL.glGetCombinerOutputParameterfvNV(n2, n3, n4, fArray, n5);
        this.println("");
    }

    @Override
    public void glGetCombinerOutputParameterivNV(int n2, int n3, int n4, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetCombinerOutputParameterivNV(" + n2 + "," + n3 + "," + n4 + "," + intBuffer + ")");
        this.downstreamGL.glGetCombinerOutputParameterivNV(n2, n3, n4, intBuffer);
        this.println("");
    }

    @Override
    public void glGetCombinerOutputParameterivNV(int n2, int n3, int n4, int[] nArray, int n5) {
        this.printIndent();
        this.print("glGetCombinerOutputParameterivNV(" + n2 + "," + n3 + "," + n4 + "," + this.dumpArray(nArray) + "," + n5 + ")");
        this.downstreamGL.glGetCombinerOutputParameterivNV(n2, n3, n4, nArray, n5);
        this.println("");
    }

    @Override
    public void glGetCombinerStageParameterfvNV(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetCombinerStageParameterfvNV(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glGetCombinerStageParameterfvNV(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glGetCombinerStageParameterfvNV(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glGetCombinerStageParameterfvNV(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glGetCombinerStageParameterfvNV(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glGetCompressedTexImage(int n2, int n3, Buffer buffer) {
        this.printIndent();
        this.print("glGetCompressedTexImage(" + n2 + "," + n3 + "," + buffer + ")");
        this.downstreamGL.glGetCompressedTexImage(n2, n3, buffer);
        this.println("");
    }

    @Override
    public void glGetCompressedTexImage(int n2, int n3, long l2) {
        this.printIndent();
        this.print("glGetCompressedTexImage(" + n2 + "," + n3 + "," + l2 + ")");
        this.downstreamGL.glGetCompressedTexImage(n2, n3, l2);
        this.println("");
    }

    @Override
    public void glGetConvolutionFilter(int n2, int n3, int n4, Buffer buffer) {
        this.printIndent();
        this.print("glGetConvolutionFilter(" + n2 + "," + n3 + "," + n4 + "," + buffer + ")");
        this.downstreamGL.glGetConvolutionFilter(n2, n3, n4, buffer);
        this.println("");
    }

    @Override
    public void glGetConvolutionFilter(int n2, int n3, int n4, long l2) {
        this.printIndent();
        this.print("glGetConvolutionFilter(" + n2 + "," + n3 + "," + n4 + "," + l2 + ")");
        this.downstreamGL.glGetConvolutionFilter(n2, n3, n4, l2);
        this.println("");
    }

    @Override
    public void glGetConvolutionParameterfv(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetConvolutionParameterfv(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glGetConvolutionParameterfv(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glGetConvolutionParameterfv(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glGetConvolutionParameterfv(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glGetConvolutionParameterfv(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glGetConvolutionParameteriv(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetConvolutionParameteriv(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetConvolutionParameteriv(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetConvolutionParameteriv(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetConvolutionParameteriv(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetConvolutionParameteriv(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGetDetailTexFuncSGIS(int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetDetailTexFuncSGIS(" + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glGetDetailTexFuncSGIS(n2, floatBuffer);
        this.println("");
    }

    @Override
    public void glGetDetailTexFuncSGIS(int n2, float[] fArray, int n3) {
        this.printIndent();
        this.print("glGetDetailTexFuncSGIS(" + n2 + "," + this.dumpArray(fArray) + "," + n3 + ")");
        this.downstreamGL.glGetDetailTexFuncSGIS(n2, fArray, n3);
        this.println("");
    }

    @Override
    public void glGetDoublev(int n2, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glGetDoublev(" + n2 + "," + doubleBuffer + ")");
        this.downstreamGL.glGetDoublev(n2, doubleBuffer);
        this.println("");
    }

    @Override
    public void glGetDoublev(int n2, double[] dArray, int n3) {
        this.printIndent();
        this.print("glGetDoublev(" + n2 + "," + this.dumpArray(dArray) + "," + n3 + ")");
        this.downstreamGL.glGetDoublev(n2, dArray, n3);
        this.println("");
    }

    @Override
    public int glGetError() {
        this.printIndent();
        this.print("glGetError()");
        int n2 = this.downstreamGL.glGetError();
        this.println(" = " + n2);
        return n2;
    }

    @Override
    public void glGetFenceivNV(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetFenceivNV(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetFenceivNV(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetFenceivNV(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetFenceivNV(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetFenceivNV(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGetFinalCombinerInputParameterfvNV(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetFinalCombinerInputParameterfvNV(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glGetFinalCombinerInputParameterfvNV(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glGetFinalCombinerInputParameterfvNV(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glGetFinalCombinerInputParameterfvNV(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glGetFinalCombinerInputParameterfvNV(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glGetFinalCombinerInputParameterivNV(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetFinalCombinerInputParameterivNV(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetFinalCombinerInputParameterivNV(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetFinalCombinerInputParameterivNV(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetFinalCombinerInputParameterivNV(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetFinalCombinerInputParameterivNV(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGetFloatv(int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetFloatv(" + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glGetFloatv(n2, floatBuffer);
        this.println("");
    }

    @Override
    public void glGetFloatv(int n2, float[] fArray, int n3) {
        this.printIndent();
        this.print("glGetFloatv(" + n2 + "," + this.dumpArray(fArray) + "," + n3 + ")");
        this.downstreamGL.glGetFloatv(n2, fArray, n3);
        this.println("");
    }

    @Override
    public void glGetFogFuncSGIS(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetFogFuncSGIS(" + floatBuffer + ")");
        this.downstreamGL.glGetFogFuncSGIS(floatBuffer);
        this.println("");
    }

    @Override
    public void glGetFogFuncSGIS(float[] fArray, int n2) {
        this.printIndent();
        this.print("glGetFogFuncSGIS(" + this.dumpArray(fArray) + "," + n2 + ")");
        this.downstreamGL.glGetFogFuncSGIS(fArray, n2);
        this.println("");
    }

    @Override
    public int glGetFragDataLocationEXT(int n2, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glGetFragDataLocationEXT(" + n2 + "," + byteBuffer + ")");
        n2 = this.downstreamGL.glGetFragDataLocationEXT(n2, byteBuffer);
        this.println(" = " + n2);
        return n2;
    }

    @Override
    public int glGetFragDataLocationEXT(int n2, byte[] byArray, int n3) {
        this.printIndent();
        this.print("glGetFragDataLocationEXT(" + n2 + "," + this.dumpArray(byArray) + "," + n3 + ")");
        n2 = this.downstreamGL.glGetFragDataLocationEXT(n2, byArray, n3);
        this.println(" = " + n2);
        return n2;
    }

    @Override
    public void glGetFragmentLightfvSGIX(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetFragmentLightfvSGIX(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glGetFragmentLightfvSGIX(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glGetFragmentLightfvSGIX(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glGetFragmentLightfvSGIX(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glGetFragmentLightfvSGIX(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glGetFragmentLightivSGIX(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetFragmentLightivSGIX(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetFragmentLightivSGIX(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetFragmentLightivSGIX(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetFragmentLightivSGIX(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetFragmentLightivSGIX(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGetFragmentMaterialfvSGIX(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetFragmentMaterialfvSGIX(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glGetFragmentMaterialfvSGIX(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glGetFragmentMaterialfvSGIX(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glGetFragmentMaterialfvSGIX(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glGetFragmentMaterialfvSGIX(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glGetFragmentMaterialivSGIX(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetFragmentMaterialivSGIX(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetFragmentMaterialivSGIX(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetFragmentMaterialivSGIX(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetFragmentMaterialivSGIX(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetFragmentMaterialivSGIX(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGetFramebufferAttachmentParameterivEXT(int n2, int n3, int n4, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetFramebufferAttachmentParameterivEXT(" + n2 + "," + n3 + "," + n4 + "," + intBuffer + ")");
        this.downstreamGL.glGetFramebufferAttachmentParameterivEXT(n2, n3, n4, intBuffer);
        this.println("");
    }

    @Override
    public void glGetFramebufferAttachmentParameterivEXT(int n2, int n3, int n4, int[] nArray, int n5) {
        this.printIndent();
        this.print("glGetFramebufferAttachmentParameterivEXT(" + n2 + "," + n3 + "," + n4 + "," + this.dumpArray(nArray) + "," + n5 + ")");
        this.downstreamGL.glGetFramebufferAttachmentParameterivEXT(n2, n3, n4, nArray, n5);
        this.println("");
    }

    @Override
    public int glGetHandleARB(int n2) {
        this.printIndent();
        this.print("glGetHandleARB(" + n2 + ")");
        n2 = this.downstreamGL.glGetHandleARB(n2);
        this.println(" = " + n2);
        return n2;
    }

    @Override
    public void glGetHistogram(int n2, boolean bl, int n3, int n4, Buffer buffer) {
        this.printIndent();
        this.print("glGetHistogram(" + n2 + "," + bl + "," + n3 + "," + n4 + "," + buffer + ")");
        this.downstreamGL.glGetHistogram(n2, bl, n3, n4, buffer);
        this.println("");
    }

    @Override
    public void glGetHistogram(int n2, boolean bl, int n3, int n4, long l2) {
        this.printIndent();
        this.print("glGetHistogram(" + n2 + "," + bl + "," + n3 + "," + n4 + "," + l2 + ")");
        this.downstreamGL.glGetHistogram(n2, bl, n3, n4, l2);
        this.println("");
    }

    @Override
    public void glGetHistogramParameterfv(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetHistogramParameterfv(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glGetHistogramParameterfv(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glGetHistogramParameterfv(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glGetHistogramParameterfv(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glGetHistogramParameterfv(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glGetHistogramParameteriv(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetHistogramParameteriv(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetHistogramParameteriv(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetHistogramParameteriv(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetHistogramParameteriv(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetHistogramParameteriv(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGetImageTransformParameterfvHP(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetImageTransformParameterfvHP(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glGetImageTransformParameterfvHP(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glGetImageTransformParameterfvHP(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glGetImageTransformParameterfvHP(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glGetImageTransformParameterfvHP(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glGetImageTransformParameterivHP(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetImageTransformParameterivHP(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetImageTransformParameterivHP(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetImageTransformParameterivHP(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetImageTransformParameterivHP(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetImageTransformParameterivHP(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGetInfoLogARB(int n2, int n3, IntBuffer intBuffer, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glGetInfoLogARB(" + n2 + "," + n3 + "," + intBuffer + "," + byteBuffer + ")");
        this.downstreamGL.glGetInfoLogARB(n2, n3, intBuffer, byteBuffer);
        this.println("");
    }

    @Override
    public void glGetInfoLogARB(int n2, int n3, int[] nArray, int n4, byte[] byArray, int n5) {
        this.printIndent();
        this.print("glGetInfoLogARB(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + "," + this.dumpArray(byArray) + "," + n5 + ")");
        this.downstreamGL.glGetInfoLogARB(n2, n3, nArray, n4, byArray, n5);
        this.println("");
    }

    @Override
    public int glGetInstrumentsSGIX() {
        this.printIndent();
        this.print("glGetInstrumentsSGIX()");
        int n2 = this.downstreamGL.glGetInstrumentsSGIX();
        this.println(" = " + n2);
        return n2;
    }

    @Override
    public void glGetIntegerIndexedvEXT(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetIntegerIndexedvEXT(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetIntegerIndexedvEXT(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetIntegerIndexedvEXT(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetIntegerIndexedvEXT(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetIntegerIndexedvEXT(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGetIntegerv(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetIntegerv(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGetIntegerv(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glGetIntegerv(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glGetIntegerv(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glGetIntegerv(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glGetInvariantBooleanvEXT(int n2, int n3, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glGetInvariantBooleanvEXT(" + n2 + "," + n3 + "," + byteBuffer + ")");
        this.downstreamGL.glGetInvariantBooleanvEXT(n2, n3, byteBuffer);
        this.println("");
    }

    @Override
    public void glGetInvariantBooleanvEXT(int n2, int n3, byte[] byArray, int n4) {
        this.printIndent();
        this.print("glGetInvariantBooleanvEXT(" + n2 + "," + n3 + "," + this.dumpArray(byArray) + "," + n4 + ")");
        this.downstreamGL.glGetInvariantBooleanvEXT(n2, n3, byArray, n4);
        this.println("");
    }

    @Override
    public void glGetInvariantFloatvEXT(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetInvariantFloatvEXT(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glGetInvariantFloatvEXT(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glGetInvariantFloatvEXT(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glGetInvariantFloatvEXT(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glGetInvariantFloatvEXT(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glGetInvariantIntegervEXT(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetInvariantIntegervEXT(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetInvariantIntegervEXT(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetInvariantIntegervEXT(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetInvariantIntegervEXT(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetInvariantIntegervEXT(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGetLightfv(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetLightfv(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glGetLightfv(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glGetLightfv(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glGetLightfv(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glGetLightfv(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glGetLightiv(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetLightiv(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetLightiv(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetLightiv(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetLightiv(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetLightiv(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGetListParameterfvSGIX(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetListParameterfvSGIX(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glGetListParameterfvSGIX(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glGetListParameterfvSGIX(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glGetListParameterfvSGIX(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glGetListParameterfvSGIX(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glGetListParameterivSGIX(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetListParameterivSGIX(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetListParameterivSGIX(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetListParameterivSGIX(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetListParameterivSGIX(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetListParameterivSGIX(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGetLocalConstantBooleanvEXT(int n2, int n3, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glGetLocalConstantBooleanvEXT(" + n2 + "," + n3 + "," + byteBuffer + ")");
        this.downstreamGL.glGetLocalConstantBooleanvEXT(n2, n3, byteBuffer);
        this.println("");
    }

    @Override
    public void glGetLocalConstantBooleanvEXT(int n2, int n3, byte[] byArray, int n4) {
        this.printIndent();
        this.print("glGetLocalConstantBooleanvEXT(" + n2 + "," + n3 + "," + this.dumpArray(byArray) + "," + n4 + ")");
        this.downstreamGL.glGetLocalConstantBooleanvEXT(n2, n3, byArray, n4);
        this.println("");
    }

    @Override
    public void glGetLocalConstantFloatvEXT(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetLocalConstantFloatvEXT(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glGetLocalConstantFloatvEXT(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glGetLocalConstantFloatvEXT(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glGetLocalConstantFloatvEXT(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glGetLocalConstantFloatvEXT(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glGetLocalConstantIntegervEXT(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetLocalConstantIntegervEXT(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetLocalConstantIntegervEXT(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetLocalConstantIntegervEXT(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetLocalConstantIntegervEXT(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetLocalConstantIntegervEXT(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGetMapAttribParameterfvNV(int n2, int n3, int n4, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetMapAttribParameterfvNV(" + n2 + "," + n3 + "," + n4 + "," + floatBuffer + ")");
        this.downstreamGL.glGetMapAttribParameterfvNV(n2, n3, n4, floatBuffer);
        this.println("");
    }

    @Override
    public void glGetMapAttribParameterfvNV(int n2, int n3, int n4, float[] fArray, int n5) {
        this.printIndent();
        this.print("glGetMapAttribParameterfvNV(" + n2 + "," + n3 + "," + n4 + "," + this.dumpArray(fArray) + "," + n5 + ")");
        this.downstreamGL.glGetMapAttribParameterfvNV(n2, n3, n4, fArray, n5);
        this.println("");
    }

    @Override
    public void glGetMapAttribParameterivNV(int n2, int n3, int n4, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetMapAttribParameterivNV(" + n2 + "," + n3 + "," + n4 + "," + intBuffer + ")");
        this.downstreamGL.glGetMapAttribParameterivNV(n2, n3, n4, intBuffer);
        this.println("");
    }

    @Override
    public void glGetMapAttribParameterivNV(int n2, int n3, int n4, int[] nArray, int n5) {
        this.printIndent();
        this.print("glGetMapAttribParameterivNV(" + n2 + "," + n3 + "," + n4 + "," + this.dumpArray(nArray) + "," + n5 + ")");
        this.downstreamGL.glGetMapAttribParameterivNV(n2, n3, n4, nArray, n5);
        this.println("");
    }

    @Override
    public void glGetMapControlPointsNV(int n2, int n3, int n4, int n5, int n6, boolean bl, Buffer buffer) {
        this.printIndent();
        this.print("glGetMapControlPointsNV(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + bl + "," + buffer + ")");
        this.downstreamGL.glGetMapControlPointsNV(n2, n3, n4, n5, n6, bl, buffer);
        this.println("");
    }

    @Override
    public void glGetMapParameterfvNV(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetMapParameterfvNV(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glGetMapParameterfvNV(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glGetMapParameterfvNV(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glGetMapParameterfvNV(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glGetMapParameterfvNV(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glGetMapParameterivNV(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetMapParameterivNV(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetMapParameterivNV(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetMapParameterivNV(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetMapParameterivNV(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetMapParameterivNV(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGetMapdv(int n2, int n3, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glGetMapdv(" + n2 + "," + n3 + "," + doubleBuffer + ")");
        this.downstreamGL.glGetMapdv(n2, n3, doubleBuffer);
        this.println("");
    }

    @Override
    public void glGetMapdv(int n2, int n3, double[] dArray, int n4) {
        this.printIndent();
        this.print("glGetMapdv(" + n2 + "," + n3 + "," + this.dumpArray(dArray) + "," + n4 + ")");
        this.downstreamGL.glGetMapdv(n2, n3, dArray, n4);
        this.println("");
    }

    @Override
    public void glGetMapfv(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetMapfv(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glGetMapfv(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glGetMapfv(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glGetMapfv(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glGetMapfv(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glGetMapiv(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetMapiv(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetMapiv(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetMapiv(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetMapiv(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetMapiv(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGetMaterialfv(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetMaterialfv(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glGetMaterialfv(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glGetMaterialfv(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glGetMaterialfv(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glGetMaterialfv(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glGetMaterialiv(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetMaterialiv(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetMaterialiv(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetMaterialiv(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetMaterialiv(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetMaterialiv(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGetMinmax(int n2, boolean bl, int n3, int n4, Buffer buffer) {
        this.printIndent();
        this.print("glGetMinmax(" + n2 + "," + bl + "," + n3 + "," + n4 + "," + buffer + ")");
        this.downstreamGL.glGetMinmax(n2, bl, n3, n4, buffer);
        this.println("");
    }

    @Override
    public void glGetMinmax(int n2, boolean bl, int n3, int n4, long l2) {
        this.printIndent();
        this.print("glGetMinmax(" + n2 + "," + bl + "," + n3 + "," + n4 + "," + l2 + ")");
        this.downstreamGL.glGetMinmax(n2, bl, n3, n4, l2);
        this.println("");
    }

    @Override
    public void glGetMinmaxParameterfv(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetMinmaxParameterfv(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glGetMinmaxParameterfv(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glGetMinmaxParameterfv(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glGetMinmaxParameterfv(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glGetMinmaxParameterfv(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glGetMinmaxParameteriv(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetMinmaxParameteriv(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetMinmaxParameteriv(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetMinmaxParameteriv(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetMinmaxParameteriv(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetMinmaxParameteriv(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGetObjectBufferfvATI(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetObjectBufferfvATI(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glGetObjectBufferfvATI(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glGetObjectBufferfvATI(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glGetObjectBufferfvATI(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glGetObjectBufferfvATI(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glGetObjectBufferivATI(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetObjectBufferivATI(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetObjectBufferivATI(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetObjectBufferivATI(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetObjectBufferivATI(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetObjectBufferivATI(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGetObjectParameterfvARB(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetObjectParameterfvARB(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glGetObjectParameterfvARB(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glGetObjectParameterfvARB(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glGetObjectParameterfvARB(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glGetObjectParameterfvARB(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glGetObjectParameterivARB(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetObjectParameterivARB(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetObjectParameterivARB(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetObjectParameterivARB(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetObjectParameterivARB(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetObjectParameterivARB(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGetOcclusionQueryivNV(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetOcclusionQueryivNV(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetOcclusionQueryivNV(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetOcclusionQueryivNV(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetOcclusionQueryivNV(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetOcclusionQueryivNV(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGetOcclusionQueryuivNV(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetOcclusionQueryuivNV(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetOcclusionQueryuivNV(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetOcclusionQueryuivNV(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetOcclusionQueryuivNV(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetOcclusionQueryuivNV(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGetPixelMapfv(int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetPixelMapfv(" + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glGetPixelMapfv(n2, floatBuffer);
        this.println("");
    }

    @Override
    public void glGetPixelMapfv(int n2, float[] fArray, int n3) {
        this.printIndent();
        this.print("glGetPixelMapfv(" + n2 + "," + this.dumpArray(fArray) + "," + n3 + ")");
        this.downstreamGL.glGetPixelMapfv(n2, fArray, n3);
        this.println("");
    }

    @Override
    public void glGetPixelMapfv(int n2, long l2) {
        this.printIndent();
        this.print("glGetPixelMapfv(" + n2 + "," + l2 + ")");
        this.downstreamGL.glGetPixelMapfv(n2, l2);
        this.println("");
    }

    @Override
    public void glGetPixelMapuiv(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetPixelMapuiv(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGetPixelMapuiv(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glGetPixelMapuiv(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glGetPixelMapuiv(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glGetPixelMapuiv(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glGetPixelMapuiv(int n2, long l2) {
        this.printIndent();
        this.print("glGetPixelMapuiv(" + n2 + "," + l2 + ")");
        this.downstreamGL.glGetPixelMapuiv(n2, l2);
        this.println("");
    }

    @Override
    public void glGetPixelMapusv(int n2, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glGetPixelMapusv(" + n2 + "," + shortBuffer + ")");
        this.downstreamGL.glGetPixelMapusv(n2, shortBuffer);
        this.println("");
    }

    @Override
    public void glGetPixelMapusv(int n2, short[] sArray, int n3) {
        this.printIndent();
        this.print("glGetPixelMapusv(" + n2 + "," + this.dumpArray(sArray) + "," + n3 + ")");
        this.downstreamGL.glGetPixelMapusv(n2, sArray, n3);
        this.println("");
    }

    @Override
    public void glGetPixelMapusv(int n2, long l2) {
        this.printIndent();
        this.print("glGetPixelMapusv(" + n2 + "," + l2 + ")");
        this.downstreamGL.glGetPixelMapusv(n2, l2);
        this.println("");
    }

    @Override
    public void glGetPixelTexGenParameterfvSGIS(int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetPixelTexGenParameterfvSGIS(" + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glGetPixelTexGenParameterfvSGIS(n2, floatBuffer);
        this.println("");
    }

    @Override
    public void glGetPixelTexGenParameterfvSGIS(int n2, float[] fArray, int n3) {
        this.printIndent();
        this.print("glGetPixelTexGenParameterfvSGIS(" + n2 + "," + this.dumpArray(fArray) + "," + n3 + ")");
        this.downstreamGL.glGetPixelTexGenParameterfvSGIS(n2, fArray, n3);
        this.println("");
    }

    @Override
    public void glGetPixelTexGenParameterivSGIS(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetPixelTexGenParameterivSGIS(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGetPixelTexGenParameterivSGIS(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glGetPixelTexGenParameterivSGIS(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glGetPixelTexGenParameterivSGIS(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glGetPixelTexGenParameterivSGIS(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glGetPolygonStipple(ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glGetPolygonStipple(" + byteBuffer + ")");
        this.downstreamGL.glGetPolygonStipple(byteBuffer);
        this.println("");
    }

    @Override
    public void glGetPolygonStipple(byte[] byArray, int n2) {
        this.printIndent();
        this.print("glGetPolygonStipple(" + this.dumpArray(byArray) + "," + n2 + ")");
        this.downstreamGL.glGetPolygonStipple(byArray, n2);
        this.println("");
    }

    @Override
    public void glGetPolygonStipple(long l2) {
        this.printIndent();
        this.print("glGetPolygonStipple(" + l2 + ")");
        this.downstreamGL.glGetPolygonStipple(l2);
        this.println("");
    }

    @Override
    public void glGetProgramEnvParameterIivNV(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetProgramEnvParameterIivNV(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetProgramEnvParameterIivNV(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetProgramEnvParameterIivNV(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetProgramEnvParameterIivNV(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetProgramEnvParameterIivNV(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGetProgramEnvParameterIuivNV(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetProgramEnvParameterIuivNV(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetProgramEnvParameterIuivNV(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetProgramEnvParameterIuivNV(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetProgramEnvParameterIuivNV(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetProgramEnvParameterIuivNV(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGetProgramEnvParameterdvARB(int n2, int n3, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glGetProgramEnvParameterdvARB(" + n2 + "," + n3 + "," + doubleBuffer + ")");
        this.downstreamGL.glGetProgramEnvParameterdvARB(n2, n3, doubleBuffer);
        this.println("");
    }

    @Override
    public void glGetProgramEnvParameterdvARB(int n2, int n3, double[] dArray, int n4) {
        this.printIndent();
        this.print("glGetProgramEnvParameterdvARB(" + n2 + "," + n3 + "," + this.dumpArray(dArray) + "," + n4 + ")");
        this.downstreamGL.glGetProgramEnvParameterdvARB(n2, n3, dArray, n4);
        this.println("");
    }

    @Override
    public void glGetProgramEnvParameterfvARB(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetProgramEnvParameterfvARB(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glGetProgramEnvParameterfvARB(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glGetProgramEnvParameterfvARB(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glGetProgramEnvParameterfvARB(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glGetProgramEnvParameterfvARB(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glGetProgramInfoLog(int n2, int n3, IntBuffer intBuffer, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glGetProgramInfoLog(" + n2 + "," + n3 + "," + intBuffer + "," + byteBuffer + ")");
        this.downstreamGL.glGetProgramInfoLog(n2, n3, intBuffer, byteBuffer);
        this.println("");
    }

    @Override
    public void glGetProgramInfoLog(int n2, int n3, int[] nArray, int n4, byte[] byArray, int n5) {
        this.printIndent();
        this.print("glGetProgramInfoLog(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + "," + this.dumpArray(byArray) + "," + n5 + ")");
        this.downstreamGL.glGetProgramInfoLog(n2, n3, nArray, n4, byArray, n5);
        this.println("");
    }

    @Override
    public void glGetProgramLocalParameterIivNV(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetProgramLocalParameterIivNV(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetProgramLocalParameterIivNV(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetProgramLocalParameterIivNV(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetProgramLocalParameterIivNV(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetProgramLocalParameterIivNV(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGetProgramLocalParameterIuivNV(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetProgramLocalParameterIuivNV(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetProgramLocalParameterIuivNV(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetProgramLocalParameterIuivNV(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetProgramLocalParameterIuivNV(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetProgramLocalParameterIuivNV(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGetProgramLocalParameterdvARB(int n2, int n3, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glGetProgramLocalParameterdvARB(" + n2 + "," + n3 + "," + doubleBuffer + ")");
        this.downstreamGL.glGetProgramLocalParameterdvARB(n2, n3, doubleBuffer);
        this.println("");
    }

    @Override
    public void glGetProgramLocalParameterdvARB(int n2, int n3, double[] dArray, int n4) {
        this.printIndent();
        this.print("glGetProgramLocalParameterdvARB(" + n2 + "," + n3 + "," + this.dumpArray(dArray) + "," + n4 + ")");
        this.downstreamGL.glGetProgramLocalParameterdvARB(n2, n3, dArray, n4);
        this.println("");
    }

    @Override
    public void glGetProgramLocalParameterfvARB(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetProgramLocalParameterfvARB(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glGetProgramLocalParameterfvARB(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glGetProgramLocalParameterfvARB(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glGetProgramLocalParameterfvARB(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glGetProgramLocalParameterfvARB(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glGetProgramNamedParameterdvNV(int n2, int n3, String string, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glGetProgramNamedParameterdvNV(" + n2 + "," + n3 + "," + string + "," + doubleBuffer + ")");
        this.downstreamGL.glGetProgramNamedParameterdvNV(n2, n3, string, doubleBuffer);
        this.println("");
    }

    @Override
    public void glGetProgramNamedParameterdvNV(int n2, int n3, String string, double[] dArray, int n4) {
        this.printIndent();
        this.print("glGetProgramNamedParameterdvNV(" + n2 + "," + n3 + "," + string + "," + this.dumpArray(dArray) + "," + n4 + ")");
        this.downstreamGL.glGetProgramNamedParameterdvNV(n2, n3, string, dArray, n4);
        this.println("");
    }

    @Override
    public void glGetProgramNamedParameterfvNV(int n2, int n3, String string, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetProgramNamedParameterfvNV(" + n2 + "," + n3 + "," + string + "," + floatBuffer + ")");
        this.downstreamGL.glGetProgramNamedParameterfvNV(n2, n3, string, floatBuffer);
        this.println("");
    }

    @Override
    public void glGetProgramNamedParameterfvNV(int n2, int n3, String string, float[] fArray, int n4) {
        this.printIndent();
        this.print("glGetProgramNamedParameterfvNV(" + n2 + "," + n3 + "," + string + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glGetProgramNamedParameterfvNV(n2, n3, string, fArray, n4);
        this.println("");
    }

    @Override
    public void glGetProgramParameterdvNV(int n2, int n3, int n4, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glGetProgramParameterdvNV(" + n2 + "," + n3 + "," + n4 + "," + doubleBuffer + ")");
        this.downstreamGL.glGetProgramParameterdvNV(n2, n3, n4, doubleBuffer);
        this.println("");
    }

    @Override
    public void glGetProgramParameterdvNV(int n2, int n3, int n4, double[] dArray, int n5) {
        this.printIndent();
        this.print("glGetProgramParameterdvNV(" + n2 + "," + n3 + "," + n4 + "," + this.dumpArray(dArray) + "," + n5 + ")");
        this.downstreamGL.glGetProgramParameterdvNV(n2, n3, n4, dArray, n5);
        this.println("");
    }

    @Override
    public void glGetProgramParameterfvNV(int n2, int n3, int n4, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetProgramParameterfvNV(" + n2 + "," + n3 + "," + n4 + "," + floatBuffer + ")");
        this.downstreamGL.glGetProgramParameterfvNV(n2, n3, n4, floatBuffer);
        this.println("");
    }

    @Override
    public void glGetProgramParameterfvNV(int n2, int n3, int n4, float[] fArray, int n5) {
        this.printIndent();
        this.print("glGetProgramParameterfvNV(" + n2 + "," + n3 + "," + n4 + "," + this.dumpArray(fArray) + "," + n5 + ")");
        this.downstreamGL.glGetProgramParameterfvNV(n2, n3, n4, fArray, n5);
        this.println("");
    }

    @Override
    public void glGetProgramStringARB(int n2, int n3, Buffer buffer) {
        this.printIndent();
        this.print("glGetProgramStringARB(" + n2 + "," + n3 + "," + buffer + ")");
        this.downstreamGL.glGetProgramStringARB(n2, n3, buffer);
        this.println("");
    }

    @Override
    public void glGetProgramStringNV(int n2, int n3, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glGetProgramStringNV(" + n2 + "," + n3 + "," + byteBuffer + ")");
        this.downstreamGL.glGetProgramStringNV(n2, n3, byteBuffer);
        this.println("");
    }

    @Override
    public void glGetProgramStringNV(int n2, int n3, byte[] byArray, int n4) {
        this.printIndent();
        this.print("glGetProgramStringNV(" + n2 + "," + n3 + "," + this.dumpArray(byArray) + "," + n4 + ")");
        this.downstreamGL.glGetProgramStringNV(n2, n3, byArray, n4);
        this.println("");
    }

    @Override
    public void glGetProgramiv(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetProgramiv(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetProgramiv(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetProgramiv(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetProgramiv(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetProgramiv(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGetProgramivARB(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetProgramivARB(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetProgramivARB(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetProgramivARB(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetProgramivARB(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetProgramivARB(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGetProgramivNV(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetProgramivNV(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetProgramivNV(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetProgramivNV(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetProgramivNV(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetProgramivNV(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGetQueryObjecti64vEXT(int n2, int n3, LongBuffer longBuffer) {
        this.printIndent();
        this.print("glGetQueryObjecti64vEXT(" + n2 + "," + n3 + "," + longBuffer + ")");
        this.downstreamGL.glGetQueryObjecti64vEXT(n2, n3, longBuffer);
        this.println("");
    }

    @Override
    public void glGetQueryObjecti64vEXT(int n2, int n3, long[] lArray, int n4) {
        this.printIndent();
        this.print("glGetQueryObjecti64vEXT(" + n2 + "," + n3 + "," + this.dumpArray(lArray) + "," + n4 + ")");
        this.downstreamGL.glGetQueryObjecti64vEXT(n2, n3, lArray, n4);
        this.println("");
    }

    @Override
    public void glGetQueryObjectiv(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetQueryObjectiv(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetQueryObjectiv(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetQueryObjectiv(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetQueryObjectiv(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetQueryObjectiv(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGetQueryObjectivARB(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetQueryObjectivARB(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetQueryObjectivARB(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetQueryObjectivARB(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetQueryObjectivARB(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetQueryObjectivARB(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGetQueryObjectui64vEXT(int n2, int n3, LongBuffer longBuffer) {
        this.printIndent();
        this.print("glGetQueryObjectui64vEXT(" + n2 + "," + n3 + "," + longBuffer + ")");
        this.downstreamGL.glGetQueryObjectui64vEXT(n2, n3, longBuffer);
        this.println("");
    }

    @Override
    public void glGetQueryObjectui64vEXT(int n2, int n3, long[] lArray, int n4) {
        this.printIndent();
        this.print("glGetQueryObjectui64vEXT(" + n2 + "," + n3 + "," + this.dumpArray(lArray) + "," + n4 + ")");
        this.downstreamGL.glGetQueryObjectui64vEXT(n2, n3, lArray, n4);
        this.println("");
    }

    @Override
    public void glGetQueryObjectuiv(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetQueryObjectuiv(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetQueryObjectuiv(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetQueryObjectuiv(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetQueryObjectuiv(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetQueryObjectuiv(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGetQueryObjectuivARB(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetQueryObjectuivARB(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetQueryObjectuivARB(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetQueryObjectuivARB(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetQueryObjectuivARB(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetQueryObjectuivARB(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGetQueryiv(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetQueryiv(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetQueryiv(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetQueryiv(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetQueryiv(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetQueryiv(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGetQueryivARB(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetQueryivARB(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetQueryivARB(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetQueryivARB(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetQueryivARB(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetQueryivARB(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGetRenderbufferParameterivEXT(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetRenderbufferParameterivEXT(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetRenderbufferParameterivEXT(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetRenderbufferParameterivEXT(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetRenderbufferParameterivEXT(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetRenderbufferParameterivEXT(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGetSeparableFilter(int n2, int n3, int n4, Buffer buffer, Buffer buffer2, Buffer buffer3) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n2 + "," + n3 + "," + n4 + "," + buffer + "," + buffer2 + "," + buffer3 + ")");
        this.downstreamGL.glGetSeparableFilter(n2, n3, n4, buffer, buffer2, buffer3);
        this.println("");
    }

    @Override
    public void glGetSeparableFilter(int n2, int n3, int n4, long l2, long l3, long l4) {
        this.printIndent();
        this.print("glGetSeparableFilter(" + n2 + "," + n3 + "," + n4 + "," + l2 + "," + l3 + "," + l4 + ")");
        this.downstreamGL.glGetSeparableFilter(n2, n3, n4, l2, l3, l4);
        this.println("");
    }

    @Override
    public void glGetShaderInfoLog(int n2, int n3, IntBuffer intBuffer, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glGetShaderInfoLog(" + n2 + "," + n3 + "," + intBuffer + "," + byteBuffer + ")");
        this.downstreamGL.glGetShaderInfoLog(n2, n3, intBuffer, byteBuffer);
        this.println("");
    }

    @Override
    public void glGetShaderInfoLog(int n2, int n3, int[] nArray, int n4, byte[] byArray, int n5) {
        this.printIndent();
        this.print("glGetShaderInfoLog(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + "," + this.dumpArray(byArray) + "," + n5 + ")");
        this.downstreamGL.glGetShaderInfoLog(n2, n3, nArray, n4, byArray, n5);
        this.println("");
    }

    @Override
    public void glGetShaderSource(int n2, int n3, IntBuffer intBuffer, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glGetShaderSource(" + n2 + "," + n3 + "," + intBuffer + "," + byteBuffer + ")");
        this.downstreamGL.glGetShaderSource(n2, n3, intBuffer, byteBuffer);
        this.println("");
    }

    @Override
    public void glGetShaderSource(int n2, int n3, int[] nArray, int n4, byte[] byArray, int n5) {
        this.printIndent();
        this.print("glGetShaderSource(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + "," + this.dumpArray(byArray) + "," + n5 + ")");
        this.downstreamGL.glGetShaderSource(n2, n3, nArray, n4, byArray, n5);
        this.println("");
    }

    @Override
    public void glGetShaderSourceARB(int n2, int n3, IntBuffer intBuffer, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glGetShaderSourceARB(" + n2 + "," + n3 + "," + intBuffer + "," + byteBuffer + ")");
        this.downstreamGL.glGetShaderSourceARB(n2, n3, intBuffer, byteBuffer);
        this.println("");
    }

    @Override
    public void glGetShaderSourceARB(int n2, int n3, int[] nArray, int n4, byte[] byArray, int n5) {
        this.printIndent();
        this.print("glGetShaderSourceARB(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + "," + this.dumpArray(byArray) + "," + n5 + ")");
        this.downstreamGL.glGetShaderSourceARB(n2, n3, nArray, n4, byArray, n5);
        this.println("");
    }

    @Override
    public void glGetShaderiv(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetShaderiv(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetShaderiv(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetShaderiv(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetShaderiv(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetShaderiv(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGetSharpenTexFuncSGIS(int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetSharpenTexFuncSGIS(" + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glGetSharpenTexFuncSGIS(n2, floatBuffer);
        this.println("");
    }

    @Override
    public void glGetSharpenTexFuncSGIS(int n2, float[] fArray, int n3) {
        this.printIndent();
        this.print("glGetSharpenTexFuncSGIS(" + n2 + "," + this.dumpArray(fArray) + "," + n3 + ")");
        this.downstreamGL.glGetSharpenTexFuncSGIS(n2, fArray, n3);
        this.println("");
    }

    @Override
    public String glGetString(int n2) {
        this.printIndent();
        this.print("glGetString(" + n2 + ")");
        String string = this.downstreamGL.glGetString(n2);
        this.println(" = " + string);
        return string;
    }

    @Override
    public void glGetTexBumpParameterfvATI(int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetTexBumpParameterfvATI(" + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glGetTexBumpParameterfvATI(n2, floatBuffer);
        this.println("");
    }

    @Override
    public void glGetTexBumpParameterfvATI(int n2, float[] fArray, int n3) {
        this.printIndent();
        this.print("glGetTexBumpParameterfvATI(" + n2 + "," + this.dumpArray(fArray) + "," + n3 + ")");
        this.downstreamGL.glGetTexBumpParameterfvATI(n2, fArray, n3);
        this.println("");
    }

    @Override
    public void glGetTexBumpParameterivATI(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetTexBumpParameterivATI(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glGetTexBumpParameterivATI(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glGetTexBumpParameterivATI(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glGetTexBumpParameterivATI(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glGetTexBumpParameterivATI(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glGetTexEnvfv(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetTexEnvfv(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glGetTexEnvfv(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glGetTexEnvfv(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glGetTexEnvfv(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glGetTexEnvfv(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glGetTexEnviv(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetTexEnviv(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetTexEnviv(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetTexEnviv(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetTexEnviv(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetTexEnviv(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGetTexFilterFuncSGIS(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetTexFilterFuncSGIS(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glGetTexFilterFuncSGIS(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glGetTexFilterFuncSGIS(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glGetTexFilterFuncSGIS(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glGetTexFilterFuncSGIS(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glGetTexGendv(int n2, int n3, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glGetTexGendv(" + n2 + "," + n3 + "," + doubleBuffer + ")");
        this.downstreamGL.glGetTexGendv(n2, n3, doubleBuffer);
        this.println("");
    }

    @Override
    public void glGetTexGendv(int n2, int n3, double[] dArray, int n4) {
        this.printIndent();
        this.print("glGetTexGendv(" + n2 + "," + n3 + "," + this.dumpArray(dArray) + "," + n4 + ")");
        this.downstreamGL.glGetTexGendv(n2, n3, dArray, n4);
        this.println("");
    }

    @Override
    public void glGetTexGenfv(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetTexGenfv(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glGetTexGenfv(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glGetTexGenfv(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glGetTexGenfv(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glGetTexGenfv(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glGetTexGeniv(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetTexGeniv(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetTexGeniv(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetTexGeniv(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetTexGeniv(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetTexGeniv(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGetTexImage(int n2, int n3, int n4, int n5, Buffer buffer) {
        this.printIndent();
        this.print("glGetTexImage(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + buffer + ")");
        this.downstreamGL.glGetTexImage(n2, n3, n4, n5, buffer);
        this.println("");
    }

    @Override
    public void glGetTexImage(int n2, int n3, int n4, int n5, long l2) {
        this.printIndent();
        this.print("glGetTexImage(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + l2 + ")");
        this.downstreamGL.glGetTexImage(n2, n3, n4, n5, l2);
        this.println("");
    }

    @Override
    public void glGetTexLevelParameterfv(int n2, int n3, int n4, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetTexLevelParameterfv(" + n2 + "," + n3 + "," + n4 + "," + floatBuffer + ")");
        this.downstreamGL.glGetTexLevelParameterfv(n2, n3, n4, floatBuffer);
        this.println("");
    }

    @Override
    public void glGetTexLevelParameterfv(int n2, int n3, int n4, float[] fArray, int n5) {
        this.printIndent();
        this.print("glGetTexLevelParameterfv(" + n2 + "," + n3 + "," + n4 + "," + this.dumpArray(fArray) + "," + n5 + ")");
        this.downstreamGL.glGetTexLevelParameterfv(n2, n3, n4, fArray, n5);
        this.println("");
    }

    @Override
    public void glGetTexLevelParameteriv(int n2, int n3, int n4, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetTexLevelParameteriv(" + n2 + "," + n3 + "," + n4 + "," + intBuffer + ")");
        this.downstreamGL.glGetTexLevelParameteriv(n2, n3, n4, intBuffer);
        this.println("");
    }

    @Override
    public void glGetTexLevelParameteriv(int n2, int n3, int n4, int[] nArray, int n5) {
        this.printIndent();
        this.print("glGetTexLevelParameteriv(" + n2 + "," + n3 + "," + n4 + "," + this.dumpArray(nArray) + "," + n5 + ")");
        this.downstreamGL.glGetTexLevelParameteriv(n2, n3, n4, nArray, n5);
        this.println("");
    }

    @Override
    public void glGetTexParameterIivEXT(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetTexParameterIivEXT(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetTexParameterIivEXT(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetTexParameterIivEXT(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetTexParameterIivEXT(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetTexParameterIivEXT(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGetTexParameterIuivEXT(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetTexParameterIuivEXT(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetTexParameterIuivEXT(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetTexParameterIuivEXT(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetTexParameterIuivEXT(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetTexParameterIuivEXT(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGetTexParameterfv(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetTexParameterfv(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glGetTexParameterfv(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glGetTexParameterfv(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glGetTexParameterfv(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glGetTexParameterfv(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glGetTexParameteriv(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetTexParameteriv(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetTexParameteriv(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetTexParameteriv(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetTexParameteriv(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetTexParameteriv(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGetTrackMatrixivNV(int n2, int n3, int n4, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetTrackMatrixivNV(" + n2 + "," + n3 + "," + n4 + "," + intBuffer + ")");
        this.downstreamGL.glGetTrackMatrixivNV(n2, n3, n4, intBuffer);
        this.println("");
    }

    @Override
    public void glGetTrackMatrixivNV(int n2, int n3, int n4, int[] nArray, int n5) {
        this.printIndent();
        this.print("glGetTrackMatrixivNV(" + n2 + "," + n3 + "," + n4 + "," + this.dumpArray(nArray) + "," + n5 + ")");
        this.downstreamGL.glGetTrackMatrixivNV(n2, n3, n4, nArray, n5);
        this.println("");
    }

    @Override
    public void glGetTransformFeedbackVaryingNV(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetTransformFeedbackVaryingNV(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetTransformFeedbackVaryingNV(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetTransformFeedbackVaryingNV(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetTransformFeedbackVaryingNV(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetTransformFeedbackVaryingNV(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public int glGetUniformBufferSizeEXT(int n2, int n3) {
        this.printIndent();
        this.print("glGetUniformBufferSizeEXT(" + n2 + "," + n3 + ")");
        n2 = this.downstreamGL.glGetUniformBufferSizeEXT(n2, n3);
        this.println(" = " + n2);
        return n2;
    }

    @Override
    public int glGetUniformLocation(int n2, String string) {
        this.printIndent();
        this.print("glGetUniformLocation(" + n2 + "," + string + ")");
        n2 = this.downstreamGL.glGetUniformLocation(n2, string);
        this.println(" = " + n2);
        return n2;
    }

    @Override
    public int glGetUniformLocationARB(int n2, String string) {
        this.printIndent();
        this.print("glGetUniformLocationARB(" + n2 + "," + string + ")");
        n2 = this.downstreamGL.glGetUniformLocationARB(n2, string);
        this.println(" = " + n2);
        return n2;
    }

    @Override
    public int glGetUniformOffsetEXT(int n2, int n3) {
        this.printIndent();
        this.print("glGetUniformOffsetEXT(" + n2 + "," + n3 + ")");
        n2 = this.downstreamGL.glGetUniformOffsetEXT(n2, n3);
        this.println(" = " + n2);
        return n2;
    }

    @Override
    public void glGetUniformfv(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetUniformfv(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glGetUniformfv(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glGetUniformfv(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glGetUniformfv(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glGetUniformfv(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glGetUniformfvARB(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetUniformfvARB(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glGetUniformfvARB(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glGetUniformfvARB(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glGetUniformfvARB(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glGetUniformfvARB(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glGetUniformiv(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetUniformiv(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetUniformiv(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetUniformiv(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetUniformiv(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetUniformiv(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGetUniformivARB(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetUniformivARB(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetUniformivARB(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetUniformivARB(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetUniformivARB(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetUniformivARB(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGetUniformuivEXT(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetUniformuivEXT(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetUniformuivEXT(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetUniformuivEXT(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetUniformuivEXT(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetUniformuivEXT(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGetVariantArrayObjectfvATI(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetVariantArrayObjectfvATI(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glGetVariantArrayObjectfvATI(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glGetVariantArrayObjectfvATI(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glGetVariantArrayObjectfvATI(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glGetVariantArrayObjectfvATI(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glGetVariantArrayObjectivATI(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetVariantArrayObjectivATI(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetVariantArrayObjectivATI(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetVariantArrayObjectivATI(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetVariantArrayObjectivATI(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetVariantArrayObjectivATI(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGetVariantBooleanvEXT(int n2, int n3, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glGetVariantBooleanvEXT(" + n2 + "," + n3 + "," + byteBuffer + ")");
        this.downstreamGL.glGetVariantBooleanvEXT(n2, n3, byteBuffer);
        this.println("");
    }

    @Override
    public void glGetVariantBooleanvEXT(int n2, int n3, byte[] byArray, int n4) {
        this.printIndent();
        this.print("glGetVariantBooleanvEXT(" + n2 + "," + n3 + "," + this.dumpArray(byArray) + "," + n4 + ")");
        this.downstreamGL.glGetVariantBooleanvEXT(n2, n3, byArray, n4);
        this.println("");
    }

    @Override
    public void glGetVariantFloatvEXT(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetVariantFloatvEXT(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glGetVariantFloatvEXT(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glGetVariantFloatvEXT(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glGetVariantFloatvEXT(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glGetVariantFloatvEXT(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glGetVariantIntegervEXT(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetVariantIntegervEXT(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetVariantIntegervEXT(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetVariantIntegervEXT(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetVariantIntegervEXT(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetVariantIntegervEXT(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public int glGetVaryingLocationNV(int n2, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glGetVaryingLocationNV(" + n2 + "," + byteBuffer + ")");
        n2 = this.downstreamGL.glGetVaryingLocationNV(n2, byteBuffer);
        this.println(" = " + n2);
        return n2;
    }

    @Override
    public int glGetVaryingLocationNV(int n2, byte[] byArray, int n3) {
        this.printIndent();
        this.print("glGetVaryingLocationNV(" + n2 + "," + this.dumpArray(byArray) + "," + n3 + ")");
        n2 = this.downstreamGL.glGetVaryingLocationNV(n2, byArray, n3);
        this.println(" = " + n2);
        return n2;
    }

    @Override
    public void glGetVertexAttribArrayObjectfvATI(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetVertexAttribArrayObjectfvATI(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glGetVertexAttribArrayObjectfvATI(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glGetVertexAttribArrayObjectfvATI(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glGetVertexAttribArrayObjectfvATI(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glGetVertexAttribArrayObjectfvATI(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glGetVertexAttribArrayObjectivATI(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetVertexAttribArrayObjectivATI(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetVertexAttribArrayObjectivATI(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetVertexAttribArrayObjectivATI(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetVertexAttribArrayObjectivATI(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetVertexAttribArrayObjectivATI(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGetVertexAttribIivEXT(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetVertexAttribIivEXT(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetVertexAttribIivEXT(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetVertexAttribIivEXT(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetVertexAttribIivEXT(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetVertexAttribIivEXT(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGetVertexAttribIuivEXT(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetVertexAttribIuivEXT(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetVertexAttribIuivEXT(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetVertexAttribIuivEXT(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetVertexAttribIuivEXT(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetVertexAttribIuivEXT(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGetVertexAttribdv(int n2, int n3, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glGetVertexAttribdv(" + n2 + "," + n3 + "," + doubleBuffer + ")");
        this.downstreamGL.glGetVertexAttribdv(n2, n3, doubleBuffer);
        this.println("");
    }

    @Override
    public void glGetVertexAttribdv(int n2, int n3, double[] dArray, int n4) {
        this.printIndent();
        this.print("glGetVertexAttribdv(" + n2 + "," + n3 + "," + this.dumpArray(dArray) + "," + n4 + ")");
        this.downstreamGL.glGetVertexAttribdv(n2, n3, dArray, n4);
        this.println("");
    }

    @Override
    public void glGetVertexAttribdvARB(int n2, int n3, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glGetVertexAttribdvARB(" + n2 + "," + n3 + "," + doubleBuffer + ")");
        this.downstreamGL.glGetVertexAttribdvARB(n2, n3, doubleBuffer);
        this.println("");
    }

    @Override
    public void glGetVertexAttribdvARB(int n2, int n3, double[] dArray, int n4) {
        this.printIndent();
        this.print("glGetVertexAttribdvARB(" + n2 + "," + n3 + "," + this.dumpArray(dArray) + "," + n4 + ")");
        this.downstreamGL.glGetVertexAttribdvARB(n2, n3, dArray, n4);
        this.println("");
    }

    @Override
    public void glGetVertexAttribdvNV(int n2, int n3, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glGetVertexAttribdvNV(" + n2 + "," + n3 + "," + doubleBuffer + ")");
        this.downstreamGL.glGetVertexAttribdvNV(n2, n3, doubleBuffer);
        this.println("");
    }

    @Override
    public void glGetVertexAttribdvNV(int n2, int n3, double[] dArray, int n4) {
        this.printIndent();
        this.print("glGetVertexAttribdvNV(" + n2 + "," + n3 + "," + this.dumpArray(dArray) + "," + n4 + ")");
        this.downstreamGL.glGetVertexAttribdvNV(n2, n3, dArray, n4);
        this.println("");
    }

    @Override
    public void glGetVertexAttribfv(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetVertexAttribfv(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glGetVertexAttribfv(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glGetVertexAttribfv(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glGetVertexAttribfv(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glGetVertexAttribfv(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glGetVertexAttribfvARB(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetVertexAttribfvARB(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glGetVertexAttribfvARB(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glGetVertexAttribfvARB(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glGetVertexAttribfvARB(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glGetVertexAttribfvARB(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glGetVertexAttribfvNV(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glGetVertexAttribfvNV(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glGetVertexAttribfvNV(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glGetVertexAttribfvNV(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glGetVertexAttribfvNV(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glGetVertexAttribfvNV(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glGetVertexAttribiv(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetVertexAttribiv(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetVertexAttribiv(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetVertexAttribiv(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetVertexAttribiv(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetVertexAttribiv(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGetVertexAttribivARB(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetVertexAttribivARB(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetVertexAttribivARB(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetVertexAttribivARB(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetVertexAttribivARB(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetVertexAttribivARB(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGetVertexAttribivNV(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glGetVertexAttribivNV(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glGetVertexAttribivNV(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glGetVertexAttribivNV(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glGetVertexAttribivNV(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glGetVertexAttribivNV(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glGlobalAlphaFactorbSUN(byte by) {
        this.printIndent();
        this.print("glGlobalAlphaFactorbSUN(" + by + ")");
        this.downstreamGL.glGlobalAlphaFactorbSUN(by);
        this.println("");
    }

    @Override
    public void glGlobalAlphaFactordSUN(double d2) {
        this.printIndent();
        this.print("glGlobalAlphaFactordSUN(" + d2 + ")");
        this.downstreamGL.glGlobalAlphaFactordSUN(d2);
        this.println("");
    }

    @Override
    public void glGlobalAlphaFactorfSUN(float f2) {
        this.printIndent();
        this.print("glGlobalAlphaFactorfSUN(" + f2 + ")");
        this.downstreamGL.glGlobalAlphaFactorfSUN(f2);
        this.println("");
    }

    @Override
    public void glGlobalAlphaFactoriSUN(int n2) {
        this.printIndent();
        this.print("glGlobalAlphaFactoriSUN(" + n2 + ")");
        this.downstreamGL.glGlobalAlphaFactoriSUN(n2);
        this.println("");
    }

    @Override
    public void glGlobalAlphaFactorsSUN(short s2) {
        this.printIndent();
        this.print("glGlobalAlphaFactorsSUN(" + s2 + ")");
        this.downstreamGL.glGlobalAlphaFactorsSUN(s2);
        this.println("");
    }

    @Override
    public void glGlobalAlphaFactorubSUN(byte by) {
        this.printIndent();
        this.print("glGlobalAlphaFactorubSUN(" + by + ")");
        this.downstreamGL.glGlobalAlphaFactorubSUN(by);
        this.println("");
    }

    @Override
    public void glGlobalAlphaFactoruiSUN(int n2) {
        this.printIndent();
        this.print("glGlobalAlphaFactoruiSUN(" + n2 + ")");
        this.downstreamGL.glGlobalAlphaFactoruiSUN(n2);
        this.println("");
    }

    @Override
    public void glGlobalAlphaFactorusSUN(short s2) {
        this.printIndent();
        this.print("glGlobalAlphaFactorusSUN(" + s2 + ")");
        this.downstreamGL.glGlobalAlphaFactorusSUN(s2);
        this.println("");
    }

    @Override
    public void glHint(int n2, int n3) {
        this.printIndent();
        this.print("glHint(" + n2 + "," + n3 + ")");
        this.downstreamGL.glHint(n2, n3);
        this.println("");
    }

    @Override
    public void glHintPGI(int n2, int n3) {
        this.printIndent();
        this.print("glHintPGI(" + n2 + "," + n3 + ")");
        this.downstreamGL.glHintPGI(n2, n3);
        this.println("");
    }

    @Override
    public void glHistogram(int n2, int n3, int n4, boolean bl) {
        this.printIndent();
        this.print("glHistogram(" + n2 + "," + n3 + "," + n4 + "," + bl + ")");
        this.downstreamGL.glHistogram(n2, n3, n4, bl);
        this.println("");
    }

    @Override
    public void glIglooInterfaceSGIX(int n2, Buffer buffer) {
        this.printIndent();
        this.print("glIglooInterfaceSGIX(" + n2 + "," + buffer + ")");
        this.downstreamGL.glIglooInterfaceSGIX(n2, buffer);
        this.println("");
    }

    @Override
    public void glImageTransformParameterfHP(int n2, int n3, float f2) {
        this.printIndent();
        this.print("glImageTransformParameterfHP(" + n2 + "," + n3 + "," + f2 + ")");
        this.downstreamGL.glImageTransformParameterfHP(n2, n3, f2);
        this.println("");
    }

    @Override
    public void glImageTransformParameterfvHP(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glImageTransformParameterfvHP(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glImageTransformParameterfvHP(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glImageTransformParameterfvHP(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glImageTransformParameterfvHP(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glImageTransformParameterfvHP(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glImageTransformParameteriHP(int n2, int n3, int n4) {
        this.printIndent();
        this.print("glImageTransformParameteriHP(" + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glImageTransformParameteriHP(n2, n3, n4);
        this.println("");
    }

    @Override
    public void glImageTransformParameterivHP(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glImageTransformParameterivHP(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glImageTransformParameterivHP(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glImageTransformParameterivHP(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glImageTransformParameterivHP(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glImageTransformParameterivHP(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glIndexFuncEXT(int n2, float f2) {
        this.printIndent();
        this.print("glIndexFuncEXT(" + n2 + "," + f2 + ")");
        this.downstreamGL.glIndexFuncEXT(n2, f2);
        this.println("");
    }

    @Override
    public void glIndexMask(int n2) {
        this.printIndent();
        this.print("glIndexMask(" + n2 + ")");
        this.downstreamGL.glIndexMask(n2);
        this.println("");
    }

    @Override
    public void glIndexMaterialEXT(int n2, int n3) {
        this.printIndent();
        this.print("glIndexMaterialEXT(" + n2 + "," + n3 + ")");
        this.downstreamGL.glIndexMaterialEXT(n2, n3);
        this.println("");
    }

    @Override
    public void glIndexPointer(int n2, int n3, Buffer buffer) {
        this.printIndent();
        this.print("glIndexPointer(" + n2 + "," + n3 + "," + buffer + ")");
        this.downstreamGL.glIndexPointer(n2, n3, buffer);
        this.println("");
    }

    @Override
    public void glIndexd(double d2) {
        this.printIndent();
        this.print("glIndexd(" + d2 + ")");
        this.downstreamGL.glIndexd(d2);
        this.println("");
    }

    @Override
    public void glIndexdv(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glIndexdv(" + doubleBuffer + ")");
        this.downstreamGL.glIndexdv(doubleBuffer);
        this.println("");
    }

    @Override
    public void glIndexdv(double[] dArray, int n2) {
        this.printIndent();
        this.print("glIndexdv(" + this.dumpArray(dArray) + "," + n2 + ")");
        this.downstreamGL.glIndexdv(dArray, n2);
        this.println("");
    }

    @Override
    public void glIndexf(float f2) {
        this.printIndent();
        this.print("glIndexf(" + f2 + ")");
        this.downstreamGL.glIndexf(f2);
        this.println("");
    }

    @Override
    public void glIndexfv(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glIndexfv(" + floatBuffer + ")");
        this.downstreamGL.glIndexfv(floatBuffer);
        this.println("");
    }

    @Override
    public void glIndexfv(float[] fArray, int n2) {
        this.printIndent();
        this.print("glIndexfv(" + this.dumpArray(fArray) + "," + n2 + ")");
        this.downstreamGL.glIndexfv(fArray, n2);
        this.println("");
    }

    @Override
    public void glIndexi(int n2) {
        this.printIndent();
        this.print("glIndexi(" + n2 + ")");
        this.downstreamGL.glIndexi(n2);
        this.println("");
    }

    @Override
    public void glIndexiv(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glIndexiv(" + intBuffer + ")");
        this.downstreamGL.glIndexiv(intBuffer);
        this.println("");
    }

    @Override
    public void glIndexiv(int[] nArray, int n2) {
        this.printIndent();
        this.print("glIndexiv(" + this.dumpArray(nArray) + "," + n2 + ")");
        this.downstreamGL.glIndexiv(nArray, n2);
        this.println("");
    }

    @Override
    public void glIndexs(short s2) {
        this.printIndent();
        this.print("glIndexs(" + s2 + ")");
        this.downstreamGL.glIndexs(s2);
        this.println("");
    }

    @Override
    public void glIndexsv(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glIndexsv(" + shortBuffer + ")");
        this.downstreamGL.glIndexsv(shortBuffer);
        this.println("");
    }

    @Override
    public void glIndexsv(short[] sArray, int n2) {
        this.printIndent();
        this.print("glIndexsv(" + this.dumpArray(sArray) + "," + n2 + ")");
        this.downstreamGL.glIndexsv(sArray, n2);
        this.println("");
    }

    @Override
    public void glIndexub(byte by) {
        this.printIndent();
        this.print("glIndexub(" + by + ")");
        this.downstreamGL.glIndexub(by);
        this.println("");
    }

    @Override
    public void glIndexubv(ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glIndexubv(" + byteBuffer + ")");
        this.downstreamGL.glIndexubv(byteBuffer);
        this.println("");
    }

    @Override
    public void glIndexubv(byte[] byArray, int n2) {
        this.printIndent();
        this.print("glIndexubv(" + this.dumpArray(byArray) + "," + n2 + ")");
        this.downstreamGL.glIndexubv(byArray, n2);
        this.println("");
    }

    @Override
    public void glInitNames() {
        this.printIndent();
        this.print("glInitNames()");
        this.downstreamGL.glInitNames();
        this.println("");
    }

    @Override
    public void glInsertComponentEXT(int n2, int n3, int n4) {
        this.printIndent();
        this.print("glInsertComponentEXT(" + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glInsertComponentEXT(n2, n3, n4);
        this.println("");
    }

    @Override
    public void glInstrumentsBufferSGIX(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glInstrumentsBufferSGIX(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glInstrumentsBufferSGIX(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glInstrumentsBufferSGIX(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glInstrumentsBufferSGIX(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glInstrumentsBufferSGIX(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glInterleavedArrays(int n2, int n3, Buffer buffer) {
        this.printIndent();
        this.print("glInterleavedArrays(" + n2 + "," + n3 + "," + buffer + ")");
        this.downstreamGL.glInterleavedArrays(n2, n3, buffer);
        this.println("");
    }

    @Override
    public void glInterleavedArrays(int n2, int n3, long l2) {
        this.printIndent();
        this.print("glInterleavedArrays(" + n2 + "," + n3 + "," + l2 + ")");
        this.downstreamGL.glInterleavedArrays(n2, n3, l2);
        this.println("");
    }

    @Override
    public boolean glIsAsyncMarkerSGIX(int n2) {
        this.printIndent();
        this.print("glIsAsyncMarkerSGIX(" + n2 + ")");
        n2 = this.downstreamGL.glIsAsyncMarkerSGIX(n2) ? 1 : 0;
        this.println(" = " + (n2 != 0));
        return n2 != 0;
    }

    @Override
    public boolean glIsBuffer(int n2) {
        this.printIndent();
        this.print("glIsBuffer(" + n2 + ")");
        n2 = this.downstreamGL.glIsBuffer(n2) ? 1 : 0;
        this.println(" = " + (n2 != 0));
        return n2 != 0;
    }

    @Override
    public boolean glIsBufferARB(int n2) {
        this.printIndent();
        this.print("glIsBufferARB(" + n2 + ")");
        n2 = this.downstreamGL.glIsBufferARB(n2) ? 1 : 0;
        this.println(" = " + (n2 != 0));
        return n2 != 0;
    }

    @Override
    public boolean glIsEnabled(int n2) {
        this.printIndent();
        this.print("glIsEnabled(" + n2 + ")");
        n2 = this.downstreamGL.glIsEnabled(n2) ? 1 : 0;
        this.println(" = " + (n2 != 0));
        return n2 != 0;
    }

    @Override
    public boolean glIsEnabledIndexedEXT(int n2, int n3) {
        this.printIndent();
        this.print("glIsEnabledIndexedEXT(" + n2 + "," + n3 + ")");
        n2 = this.downstreamGL.glIsEnabledIndexedEXT(n2, n3) ? 1 : 0;
        this.println(" = " + (n2 != 0));
        return n2 != 0;
    }

    @Override
    public boolean glIsFenceAPPLE(int n2) {
        this.printIndent();
        this.print("glIsFenceAPPLE(" + n2 + ")");
        n2 = this.downstreamGL.glIsFenceAPPLE(n2) ? 1 : 0;
        this.println(" = " + (n2 != 0));
        return n2 != 0;
    }

    @Override
    public boolean glIsFenceNV(int n2) {
        this.printIndent();
        this.print("glIsFenceNV(" + n2 + ")");
        n2 = this.downstreamGL.glIsFenceNV(n2) ? 1 : 0;
        this.println(" = " + (n2 != 0));
        return n2 != 0;
    }

    @Override
    public boolean glIsFramebufferEXT(int n2) {
        this.printIndent();
        this.print("glIsFramebufferEXT(" + n2 + ")");
        n2 = this.downstreamGL.glIsFramebufferEXT(n2) ? 1 : 0;
        this.println(" = " + (n2 != 0));
        return n2 != 0;
    }

    @Override
    public boolean glIsList(int n2) {
        this.printIndent();
        this.print("glIsList(" + n2 + ")");
        n2 = this.downstreamGL.glIsList(n2) ? 1 : 0;
        this.println(" = " + (n2 != 0));
        return n2 != 0;
    }

    @Override
    public boolean glIsObjectBufferATI(int n2) {
        this.printIndent();
        this.print("glIsObjectBufferATI(" + n2 + ")");
        n2 = this.downstreamGL.glIsObjectBufferATI(n2) ? 1 : 0;
        this.println(" = " + (n2 != 0));
        return n2 != 0;
    }

    @Override
    public boolean glIsOcclusionQueryNV(int n2) {
        this.printIndent();
        this.print("glIsOcclusionQueryNV(" + n2 + ")");
        n2 = this.downstreamGL.glIsOcclusionQueryNV(n2) ? 1 : 0;
        this.println(" = " + (n2 != 0));
        return n2 != 0;
    }

    @Override
    public boolean glIsProgram(int n2) {
        this.printIndent();
        this.print("glIsProgram(" + n2 + ")");
        n2 = this.downstreamGL.glIsProgram(n2) ? 1 : 0;
        this.println(" = " + (n2 != 0));
        return n2 != 0;
    }

    @Override
    public boolean glIsProgramARB(int n2) {
        this.printIndent();
        this.print("glIsProgramARB(" + n2 + ")");
        n2 = this.downstreamGL.glIsProgramARB(n2) ? 1 : 0;
        this.println(" = " + (n2 != 0));
        return n2 != 0;
    }

    @Override
    public boolean glIsProgramNV(int n2) {
        this.printIndent();
        this.print("glIsProgramNV(" + n2 + ")");
        n2 = this.downstreamGL.glIsProgramNV(n2) ? 1 : 0;
        this.println(" = " + (n2 != 0));
        return n2 != 0;
    }

    @Override
    public boolean glIsQuery(int n2) {
        this.printIndent();
        this.print("glIsQuery(" + n2 + ")");
        n2 = this.downstreamGL.glIsQuery(n2) ? 1 : 0;
        this.println(" = " + (n2 != 0));
        return n2 != 0;
    }

    @Override
    public boolean glIsQueryARB(int n2) {
        this.printIndent();
        this.print("glIsQueryARB(" + n2 + ")");
        n2 = this.downstreamGL.glIsQueryARB(n2) ? 1 : 0;
        this.println(" = " + (n2 != 0));
        return n2 != 0;
    }

    @Override
    public boolean glIsRenderbufferEXT(int n2) {
        this.printIndent();
        this.print("glIsRenderbufferEXT(" + n2 + ")");
        n2 = this.downstreamGL.glIsRenderbufferEXT(n2) ? 1 : 0;
        this.println(" = " + (n2 != 0));
        return n2 != 0;
    }

    @Override
    public boolean glIsShader(int n2) {
        this.printIndent();
        this.print("glIsShader(" + n2 + ")");
        n2 = this.downstreamGL.glIsShader(n2) ? 1 : 0;
        this.println(" = " + (n2 != 0));
        return n2 != 0;
    }

    @Override
    public boolean glIsTexture(int n2) {
        this.printIndent();
        this.print("glIsTexture(" + n2 + ")");
        n2 = this.downstreamGL.glIsTexture(n2) ? 1 : 0;
        this.println(" = " + (n2 != 0));
        return n2 != 0;
    }

    @Override
    public boolean glIsVariantEnabledEXT(int n2, int n3) {
        this.printIndent();
        this.print("glIsVariantEnabledEXT(" + n2 + "," + n3 + ")");
        n2 = this.downstreamGL.glIsVariantEnabledEXT(n2, n3) ? 1 : 0;
        this.println(" = " + (n2 != 0));
        return n2 != 0;
    }

    @Override
    public boolean glIsVertexArrayAPPLE(int n2) {
        this.printIndent();
        this.print("glIsVertexArrayAPPLE(" + n2 + ")");
        n2 = this.downstreamGL.glIsVertexArrayAPPLE(n2) ? 1 : 0;
        this.println(" = " + (n2 != 0));
        return n2 != 0;
    }

    @Override
    public boolean glIsVertexAttribEnabledAPPLE(int n2, int n3) {
        this.printIndent();
        this.print("glIsVertexAttribEnabledAPPLE(" + n2 + "," + n3 + ")");
        n2 = this.downstreamGL.glIsVertexAttribEnabledAPPLE(n2, n3) ? 1 : 0;
        this.println(" = " + (n2 != 0));
        return n2 != 0;
    }

    @Override
    public void glLightEnviSGIX(int n2, int n3) {
        this.printIndent();
        this.print("glLightEnviSGIX(" + n2 + "," + n3 + ")");
        this.downstreamGL.glLightEnviSGIX(n2, n3);
        this.println("");
    }

    @Override
    public void glLightModelf(int n2, float f2) {
        this.printIndent();
        this.print("glLightModelf(" + n2 + "," + f2 + ")");
        this.downstreamGL.glLightModelf(n2, f2);
        this.println("");
    }

    @Override
    public void glLightModelfv(int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glLightModelfv(" + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glLightModelfv(n2, floatBuffer);
        this.println("");
    }

    @Override
    public void glLightModelfv(int n2, float[] fArray, int n3) {
        this.printIndent();
        this.print("glLightModelfv(" + n2 + "," + this.dumpArray(fArray) + "," + n3 + ")");
        this.downstreamGL.glLightModelfv(n2, fArray, n3);
        this.println("");
    }

    @Override
    public void glLightModeli(int n2, int n3) {
        this.printIndent();
        this.print("glLightModeli(" + n2 + "," + n3 + ")");
        this.downstreamGL.glLightModeli(n2, n3);
        this.println("");
    }

    @Override
    public void glLightModeliv(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glLightModeliv(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glLightModeliv(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glLightModeliv(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glLightModeliv(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glLightModeliv(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glLightf(int n2, int n3, float f2) {
        this.printIndent();
        this.print("glLightf(" + n2 + "," + n3 + "," + f2 + ")");
        this.downstreamGL.glLightf(n2, n3, f2);
        this.println("");
    }

    @Override
    public void glLightfv(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glLightfv(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glLightfv(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glLightfv(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glLightfv(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glLightfv(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glLighti(int n2, int n3, int n4) {
        this.printIndent();
        this.print("glLighti(" + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glLighti(n2, n3, n4);
        this.println("");
    }

    @Override
    public void glLightiv(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glLightiv(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glLightiv(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glLightiv(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glLightiv(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glLightiv(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glLineStipple(int n2, short s2) {
        this.printIndent();
        this.print("glLineStipple(" + n2 + "," + s2 + ")");
        this.downstreamGL.glLineStipple(n2, s2);
        this.println("");
    }

    @Override
    public void glLineWidth(float f2) {
        this.printIndent();
        this.print("glLineWidth(" + f2 + ")");
        this.downstreamGL.glLineWidth(f2);
        this.println("");
    }

    @Override
    public void glLinkProgram(int n2) {
        this.printIndent();
        this.print("glLinkProgram(" + n2 + ")");
        this.downstreamGL.glLinkProgram(n2);
        this.println("");
    }

    @Override
    public void glLinkProgramARB(int n2) {
        this.printIndent();
        this.print("glLinkProgramARB(" + n2 + ")");
        this.downstreamGL.glLinkProgramARB(n2);
        this.println("");
    }

    @Override
    public void glListBase(int n2) {
        this.printIndent();
        this.print("glListBase(" + n2 + ")");
        this.downstreamGL.glListBase(n2);
        this.println("");
    }

    @Override
    public void glListParameterfSGIX(int n2, int n3, float f2) {
        this.printIndent();
        this.print("glListParameterfSGIX(" + n2 + "," + n3 + "," + f2 + ")");
        this.downstreamGL.glListParameterfSGIX(n2, n3, f2);
        this.println("");
    }

    @Override
    public void glListParameterfvSGIX(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glListParameterfvSGIX(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glListParameterfvSGIX(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glListParameterfvSGIX(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glListParameterfvSGIX(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glListParameterfvSGIX(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glListParameteriSGIX(int n2, int n3, int n4) {
        this.printIndent();
        this.print("glListParameteriSGIX(" + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glListParameteriSGIX(n2, n3, n4);
        this.println("");
    }

    @Override
    public void glListParameterivSGIX(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glListParameterivSGIX(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glListParameterivSGIX(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glListParameterivSGIX(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glListParameterivSGIX(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glListParameterivSGIX(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glLoadIdentity() {
        this.printIndent();
        this.print("glLoadIdentity()");
        this.downstreamGL.glLoadIdentity();
        this.println("");
    }

    @Override
    public void glLoadIdentityDeformationMapSGIX(int n2) {
        this.printIndent();
        this.print("glLoadIdentityDeformationMapSGIX(" + n2 + ")");
        this.downstreamGL.glLoadIdentityDeformationMapSGIX(n2);
        this.println("");
    }

    @Override
    public void glLoadMatrixd(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glLoadMatrixd(" + doubleBuffer + ")");
        this.downstreamGL.glLoadMatrixd(doubleBuffer);
        this.println("");
    }

    @Override
    public void glLoadMatrixd(double[] dArray, int n2) {
        this.printIndent();
        this.print("glLoadMatrixd(" + this.dumpArray(dArray) + "," + n2 + ")");
        this.downstreamGL.glLoadMatrixd(dArray, n2);
        this.println("");
    }

    @Override
    public void glLoadMatrixf(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glLoadMatrixf(" + floatBuffer + ")");
        this.downstreamGL.glLoadMatrixf(floatBuffer);
        this.println("");
    }

    @Override
    public void glLoadMatrixf(float[] fArray, int n2) {
        this.printIndent();
        this.print("glLoadMatrixf(" + this.dumpArray(fArray) + "," + n2 + ")");
        this.downstreamGL.glLoadMatrixf(fArray, n2);
        this.println("");
    }

    @Override
    public void glLoadName(int n2) {
        this.printIndent();
        this.print("glLoadName(" + n2 + ")");
        this.downstreamGL.glLoadName(n2);
        this.println("");
    }

    @Override
    public void glLoadProgramNV(int n2, int n3, int n4, String string) {
        this.printIndent();
        this.print("glLoadProgramNV(" + n2 + "," + n3 + "," + n4 + "," + string + ")");
        this.downstreamGL.glLoadProgramNV(n2, n3, n4, string);
        this.println("");
    }

    @Override
    public void glLoadTransposeMatrixd(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glLoadTransposeMatrixd(" + doubleBuffer + ")");
        this.downstreamGL.glLoadTransposeMatrixd(doubleBuffer);
        this.println("");
    }

    @Override
    public void glLoadTransposeMatrixd(double[] dArray, int n2) {
        this.printIndent();
        this.print("glLoadTransposeMatrixd(" + this.dumpArray(dArray) + "," + n2 + ")");
        this.downstreamGL.glLoadTransposeMatrixd(dArray, n2);
        this.println("");
    }

    @Override
    public void glLoadTransposeMatrixf(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glLoadTransposeMatrixf(" + floatBuffer + ")");
        this.downstreamGL.glLoadTransposeMatrixf(floatBuffer);
        this.println("");
    }

    @Override
    public void glLoadTransposeMatrixf(float[] fArray, int n2) {
        this.printIndent();
        this.print("glLoadTransposeMatrixf(" + this.dumpArray(fArray) + "," + n2 + ")");
        this.downstreamGL.glLoadTransposeMatrixf(fArray, n2);
        this.println("");
    }

    @Override
    public void glLockArraysEXT(int n2, int n3) {
        this.printIndent();
        this.print("glLockArraysEXT(" + n2 + "," + n3 + ")");
        this.downstreamGL.glLockArraysEXT(n2, n3);
        this.println("");
    }

    @Override
    public void glLogicOp(int n2) {
        this.printIndent();
        this.print("glLogicOp(" + n2 + ")");
        this.downstreamGL.glLogicOp(n2);
        this.println("");
    }

    @Override
    public void glMap1d(int n2, double d2, double d3, int n3, int n4, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glMap1d(" + n2 + "," + d2 + "," + d3 + "," + n3 + "," + n4 + "," + doubleBuffer + ")");
        this.downstreamGL.glMap1d(n2, d2, d3, n3, n4, doubleBuffer);
        this.println("");
    }

    @Override
    public void glMap1d(int n2, double d2, double d3, int n3, int n4, double[] dArray, int n5) {
        this.printIndent();
        this.print("glMap1d(" + n2 + "," + d2 + "," + d3 + "," + n3 + "," + n4 + "," + this.dumpArray(dArray) + "," + n5 + ")");
        this.downstreamGL.glMap1d(n2, d2, d3, n3, n4, dArray, n5);
        this.println("");
    }

    @Override
    public void glMap1f(int n2, float f2, float f3, int n3, int n4, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glMap1f(" + n2 + "," + f2 + "," + f3 + "," + n3 + "," + n4 + "," + floatBuffer + ")");
        this.downstreamGL.glMap1f(n2, f2, f3, n3, n4, floatBuffer);
        this.println("");
    }

    @Override
    public void glMap1f(int n2, float f2, float f3, int n3, int n4, float[] fArray, int n5) {
        this.printIndent();
        this.print("glMap1f(" + n2 + "," + f2 + "," + f3 + "," + n3 + "," + n4 + "," + this.dumpArray(fArray) + "," + n5 + ")");
        this.downstreamGL.glMap1f(n2, f2, f3, n3, n4, fArray, n5);
        this.println("");
    }

    @Override
    public void glMap2d(int n2, double d2, double d3, int n3, int n4, double d4, double d5, int n5, int n6, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glMap2d(" + n2 + "," + d2 + "," + d3 + "," + n3 + "," + n4 + "," + d4 + "," + d5 + "," + n5 + "," + n6 + "," + doubleBuffer + ")");
        this.downstreamGL.glMap2d(n2, d2, d3, n3, n4, d4, d5, n5, n6, doubleBuffer);
        this.println("");
    }

    @Override
    public void glMap2d(int n2, double d2, double d3, int n3, int n4, double d4, double d5, int n5, int n6, double[] dArray, int n7) {
        this.printIndent();
        this.print("glMap2d(" + n2 + "," + d2 + "," + d3 + "," + n3 + "," + n4 + "," + d4 + "," + d5 + "," + n5 + "," + n6 + "," + this.dumpArray(dArray) + "," + n7 + ")");
        this.downstreamGL.glMap2d(n2, d2, d3, n3, n4, d4, d5, n5, n6, dArray, n7);
        this.println("");
    }

    @Override
    public void glMap2f(int n2, float f2, float f3, int n3, int n4, float f4, float f5, int n5, int n6, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glMap2f(" + n2 + "," + f2 + "," + f3 + "," + n3 + "," + n4 + "," + f4 + "," + f5 + "," + n5 + "," + n6 + "," + floatBuffer + ")");
        this.downstreamGL.glMap2f(n2, f2, f3, n3, n4, f4, f5, n5, n6, floatBuffer);
        this.println("");
    }

    @Override
    public void glMap2f(int n2, float f2, float f3, int n3, int n4, float f4, float f5, int n5, int n6, float[] fArray, int n7) {
        this.printIndent();
        this.print("glMap2f(" + n2 + "," + f2 + "," + f3 + "," + n3 + "," + n4 + "," + f4 + "," + f5 + "," + n5 + "," + n6 + "," + this.dumpArray(fArray) + "," + n7 + ")");
        this.downstreamGL.glMap2f(n2, f2, f3, n3, n4, f4, f5, n5, n6, fArray, n7);
        this.println("");
    }

    @Override
    public ByteBuffer glMapBuffer(int n2, int n3) {
        this.printIndent();
        this.print("glMapBuffer(" + n2 + "," + n3 + ")");
        ByteBuffer byteBuffer = this.downstreamGL.glMapBuffer(n2, n3);
        this.println(" = " + byteBuffer);
        return byteBuffer;
    }

    @Override
    public ByteBuffer glMapBufferARB(int n2, int n3) {
        this.printIndent();
        this.print("glMapBufferARB(" + n2 + "," + n3 + ")");
        ByteBuffer byteBuffer = this.downstreamGL.glMapBufferARB(n2, n3);
        this.println(" = " + byteBuffer);
        return byteBuffer;
    }

    @Override
    public void glMapControlPointsNV(int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, Buffer buffer) {
        this.printIndent();
        this.print("glMapControlPointsNV(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + bl + "," + buffer + ")");
        this.downstreamGL.glMapControlPointsNV(n2, n3, n4, n5, n6, n7, n8, bl, buffer);
        this.println("");
    }

    @Override
    public void glMapGrid1d(int n2, double d2, double d3) {
        this.printIndent();
        this.print("glMapGrid1d(" + n2 + "," + d2 + "," + d3 + ")");
        this.downstreamGL.glMapGrid1d(n2, d2, d3);
        this.println("");
    }

    @Override
    public void glMapGrid1f(int n2, float f2, float f3) {
        this.printIndent();
        this.print("glMapGrid1f(" + n2 + "," + f2 + "," + f3 + ")");
        this.downstreamGL.glMapGrid1f(n2, f2, f3);
        this.println("");
    }

    @Override
    public void glMapGrid2d(int n2, double d2, double d3, int n3, double d4, double d5) {
        this.printIndent();
        this.print("glMapGrid2d(" + n2 + "," + d2 + "," + d3 + "," + n3 + "," + d4 + "," + d5 + ")");
        this.downstreamGL.glMapGrid2d(n2, d2, d3, n3, d4, d5);
        this.println("");
    }

    @Override
    public void glMapGrid2f(int n2, float f2, float f3, int n3, float f4, float f5) {
        this.printIndent();
        this.print("glMapGrid2f(" + n2 + "," + f2 + "," + f3 + "," + n3 + "," + f4 + "," + f5 + ")");
        this.downstreamGL.glMapGrid2f(n2, f2, f3, n3, f4, f5);
        this.println("");
    }

    @Override
    public void glMapParameterfvNV(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glMapParameterfvNV(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glMapParameterfvNV(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glMapParameterfvNV(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glMapParameterfvNV(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glMapParameterfvNV(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glMapParameterivNV(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glMapParameterivNV(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glMapParameterivNV(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glMapParameterivNV(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glMapParameterivNV(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glMapParameterivNV(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glMapVertexAttrib1dAPPLE(int n2, int n3, double d2, double d3, int n4, int n5, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glMapVertexAttrib1dAPPLE(" + n2 + "," + n3 + "," + d2 + "," + d3 + "," + n4 + "," + n5 + "," + doubleBuffer + ")");
        this.downstreamGL.glMapVertexAttrib1dAPPLE(n2, n3, d2, d3, n4, n5, doubleBuffer);
        this.println("");
    }

    @Override
    public void glMapVertexAttrib1dAPPLE(int n2, int n3, double d2, double d3, int n4, int n5, double[] dArray, int n6) {
        this.printIndent();
        this.print("glMapVertexAttrib1dAPPLE(" + n2 + "," + n3 + "," + d2 + "," + d3 + "," + n4 + "," + n5 + "," + this.dumpArray(dArray) + "," + n6 + ")");
        this.downstreamGL.glMapVertexAttrib1dAPPLE(n2, n3, d2, d3, n4, n5, dArray, n6);
        this.println("");
    }

    @Override
    public void glMapVertexAttrib1fAPPLE(int n2, int n3, float f2, float f3, int n4, int n5, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glMapVertexAttrib1fAPPLE(" + n2 + "," + n3 + "," + f2 + "," + f3 + "," + n4 + "," + n5 + "," + floatBuffer + ")");
        this.downstreamGL.glMapVertexAttrib1fAPPLE(n2, n3, f2, f3, n4, n5, floatBuffer);
        this.println("");
    }

    @Override
    public void glMapVertexAttrib1fAPPLE(int n2, int n3, float f2, float f3, int n4, int n5, float[] fArray, int n6) {
        this.printIndent();
        this.print("glMapVertexAttrib1fAPPLE(" + n2 + "," + n3 + "," + f2 + "," + f3 + "," + n4 + "," + n5 + "," + this.dumpArray(fArray) + "," + n6 + ")");
        this.downstreamGL.glMapVertexAttrib1fAPPLE(n2, n3, f2, f3, n4, n5, fArray, n6);
        this.println("");
    }

    @Override
    public void glMapVertexAttrib2dAPPLE(int n2, int n3, double d2, double d3, int n4, int n5, double d4, double d5, int n6, int n7, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glMapVertexAttrib2dAPPLE(" + n2 + "," + n3 + "," + d2 + "," + d3 + "," + n4 + "," + n5 + "," + d4 + "," + d5 + "," + n6 + "," + n7 + "," + doubleBuffer + ")");
        this.downstreamGL.glMapVertexAttrib2dAPPLE(n2, n3, d2, d3, n4, n5, d4, d5, n6, n7, doubleBuffer);
        this.println("");
    }

    @Override
    public void glMapVertexAttrib2dAPPLE(int n2, int n3, double d2, double d3, int n4, int n5, double d4, double d5, int n6, int n7, double[] dArray, int n8) {
        this.printIndent();
        this.print("glMapVertexAttrib2dAPPLE(" + n2 + "," + n3 + "," + d2 + "," + d3 + "," + n4 + "," + n5 + "," + d4 + "," + d5 + "," + n6 + "," + n7 + "," + this.dumpArray(dArray) + "," + n8 + ")");
        this.downstreamGL.glMapVertexAttrib2dAPPLE(n2, n3, d2, d3, n4, n5, d4, d5, n6, n7, dArray, n8);
        this.println("");
    }

    @Override
    public void glMapVertexAttrib2fAPPLE(int n2, int n3, float f2, float f3, int n4, int n5, float f4, float f5, int n6, int n7, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glMapVertexAttrib2fAPPLE(" + n2 + "," + n3 + "," + f2 + "," + f3 + "," + n4 + "," + n5 + "," + f4 + "," + f5 + "," + n6 + "," + n7 + "," + floatBuffer + ")");
        this.downstreamGL.glMapVertexAttrib2fAPPLE(n2, n3, f2, f3, n4, n5, f4, f5, n6, n7, floatBuffer);
        this.println("");
    }

    @Override
    public void glMapVertexAttrib2fAPPLE(int n2, int n3, float f2, float f3, int n4, int n5, float f4, float f5, int n6, int n7, float[] fArray, int n8) {
        this.printIndent();
        this.print("glMapVertexAttrib2fAPPLE(" + n2 + "," + n3 + "," + f2 + "," + f3 + "," + n4 + "," + n5 + "," + f4 + "," + f5 + "," + n6 + "," + n7 + "," + this.dumpArray(fArray) + "," + n8 + ")");
        this.downstreamGL.glMapVertexAttrib2fAPPLE(n2, n3, f2, f3, n4, n5, f4, f5, n6, n7, fArray, n8);
        this.println("");
    }

    @Override
    public void glMaterialf(int n2, int n3, float f2) {
        this.printIndent();
        this.print("glMaterialf(" + n2 + "," + n3 + "," + f2 + ")");
        this.downstreamGL.glMaterialf(n2, n3, f2);
        this.println("");
    }

    @Override
    public void glMaterialfv(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glMaterialfv(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glMaterialfv(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glMaterialfv(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glMaterialfv(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glMaterialfv(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glMateriali(int n2, int n3, int n4) {
        this.printIndent();
        this.print("glMateriali(" + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glMateriali(n2, n3, n4);
        this.println("");
    }

    @Override
    public void glMaterialiv(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glMaterialiv(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glMaterialiv(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glMaterialiv(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glMaterialiv(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glMaterialiv(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glMatrixIndexPointerARB(int n2, int n3, int n4, Buffer buffer) {
        this.printIndent();
        this.print("glMatrixIndexPointerARB(" + n2 + "," + n3 + "," + n4 + "," + buffer + ")");
        this.downstreamGL.glMatrixIndexPointerARB(n2, n3, n4, buffer);
        this.println("");
    }

    @Override
    public void glMatrixIndexPointerARB(int n2, int n3, int n4, long l2) {
        this.printIndent();
        this.print("glMatrixIndexPointerARB(" + n2 + "," + n3 + "," + n4 + "," + l2 + ")");
        this.downstreamGL.glMatrixIndexPointerARB(n2, n3, n4, l2);
        this.println("");
    }

    @Override
    public void glMatrixIndexubvARB(int n2, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glMatrixIndexubvARB(" + n2 + "," + byteBuffer + ")");
        this.downstreamGL.glMatrixIndexubvARB(n2, byteBuffer);
        this.println("");
    }

    @Override
    public void glMatrixIndexubvARB(int n2, byte[] byArray, int n3) {
        this.printIndent();
        this.print("glMatrixIndexubvARB(" + n2 + "," + this.dumpArray(byArray) + "," + n3 + ")");
        this.downstreamGL.glMatrixIndexubvARB(n2, byArray, n3);
        this.println("");
    }

    @Override
    public void glMatrixIndexuivARB(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glMatrixIndexuivARB(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glMatrixIndexuivARB(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glMatrixIndexuivARB(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glMatrixIndexuivARB(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glMatrixIndexuivARB(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glMatrixIndexusvARB(int n2, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glMatrixIndexusvARB(" + n2 + "," + shortBuffer + ")");
        this.downstreamGL.glMatrixIndexusvARB(n2, shortBuffer);
        this.println("");
    }

    @Override
    public void glMatrixIndexusvARB(int n2, short[] sArray, int n3) {
        this.printIndent();
        this.print("glMatrixIndexusvARB(" + n2 + "," + this.dumpArray(sArray) + "," + n3 + ")");
        this.downstreamGL.glMatrixIndexusvARB(n2, sArray, n3);
        this.println("");
    }

    @Override
    public void glMatrixMode(int n2) {
        this.printIndent();
        this.print("glMatrixMode(" + n2 + ")");
        this.downstreamGL.glMatrixMode(n2);
        this.println("");
    }

    @Override
    public void glMinmax(int n2, int n3, boolean bl) {
        this.printIndent();
        this.print("glMinmax(" + n2 + "," + n3 + "," + bl + ")");
        this.downstreamGL.glMinmax(n2, n3, bl);
        this.println("");
    }

    @Override
    public void glMultMatrixd(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glMultMatrixd(" + doubleBuffer + ")");
        this.downstreamGL.glMultMatrixd(doubleBuffer);
        this.println("");
    }

    @Override
    public void glMultMatrixd(double[] dArray, int n2) {
        this.printIndent();
        this.print("glMultMatrixd(" + this.dumpArray(dArray) + "," + n2 + ")");
        this.downstreamGL.glMultMatrixd(dArray, n2);
        this.println("");
    }

    @Override
    public void glMultMatrixf(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glMultMatrixf(" + floatBuffer + ")");
        this.downstreamGL.glMultMatrixf(floatBuffer);
        this.println("");
    }

    @Override
    public void glMultMatrixf(float[] fArray, int n2) {
        this.printIndent();
        this.print("glMultMatrixf(" + this.dumpArray(fArray) + "," + n2 + ")");
        this.downstreamGL.glMultMatrixf(fArray, n2);
        this.println("");
    }

    @Override
    public void glMultTransposeMatrixd(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glMultTransposeMatrixd(" + doubleBuffer + ")");
        this.downstreamGL.glMultTransposeMatrixd(doubleBuffer);
        this.println("");
    }

    @Override
    public void glMultTransposeMatrixd(double[] dArray, int n2) {
        this.printIndent();
        this.print("glMultTransposeMatrixd(" + this.dumpArray(dArray) + "," + n2 + ")");
        this.downstreamGL.glMultTransposeMatrixd(dArray, n2);
        this.println("");
    }

    @Override
    public void glMultTransposeMatrixf(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glMultTransposeMatrixf(" + floatBuffer + ")");
        this.downstreamGL.glMultTransposeMatrixf(floatBuffer);
        this.println("");
    }

    @Override
    public void glMultTransposeMatrixf(float[] fArray, int n2) {
        this.printIndent();
        this.print("glMultTransposeMatrixf(" + this.dumpArray(fArray) + "," + n2 + ")");
        this.downstreamGL.glMultTransposeMatrixf(fArray, n2);
        this.println("");
    }

    @Override
    public void glMultiDrawArrays(int n2, IntBuffer intBuffer, IntBuffer intBuffer2, int n3) {
        this.printIndent();
        this.print("glMultiDrawArrays(" + n2 + "," + intBuffer + "," + intBuffer2 + "," + n3 + ")");
        this.downstreamGL.glMultiDrawArrays(n2, intBuffer, intBuffer2, n3);
        this.println("");
    }

    @Override
    public void glMultiDrawArrays(int n2, int[] nArray, int n3, int[] nArray2, int n4, int n5) {
        this.printIndent();
        this.print("glMultiDrawArrays(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + "," + this.dumpArray(nArray2) + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glMultiDrawArrays(n2, nArray, n3, nArray2, n4, n5);
        this.println("");
    }

    @Override
    public void glMultiDrawArraysEXT(int n2, IntBuffer intBuffer, IntBuffer intBuffer2, int n3) {
        this.printIndent();
        this.print("glMultiDrawArraysEXT(" + n2 + "," + intBuffer + "," + intBuffer2 + "," + n3 + ")");
        this.downstreamGL.glMultiDrawArraysEXT(n2, intBuffer, intBuffer2, n3);
        this.println("");
    }

    @Override
    public void glMultiDrawArraysEXT(int n2, int[] nArray, int n3, int[] nArray2, int n4, int n5) {
        this.printIndent();
        this.print("glMultiDrawArraysEXT(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + "," + this.dumpArray(nArray2) + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glMultiDrawArraysEXT(n2, nArray, n3, nArray2, n4, n5);
        this.println("");
    }

    @Override
    public void glMultiDrawElementArrayAPPLE(int n2, IntBuffer intBuffer, IntBuffer intBuffer2, int n3) {
        this.printIndent();
        this.print("glMultiDrawElementArrayAPPLE(" + n2 + "," + intBuffer + "," + intBuffer2 + "," + n3 + ")");
        this.downstreamGL.glMultiDrawElementArrayAPPLE(n2, intBuffer, intBuffer2, n3);
        this.println("");
    }

    @Override
    public void glMultiDrawElementArrayAPPLE(int n2, int[] nArray, int n3, int[] nArray2, int n4, int n5) {
        this.printIndent();
        this.print("glMultiDrawElementArrayAPPLE(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + "," + this.dumpArray(nArray2) + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glMultiDrawElementArrayAPPLE(n2, nArray, n3, nArray2, n4, n5);
        this.println("");
    }

    @Override
    public void glMultiDrawElements(int n2, IntBuffer intBuffer, int n3, Buffer[] bufferArray, int n4) {
        this.printIndent();
        this.print("glMultiDrawElements(" + n2 + "," + intBuffer + "," + n3 + "," + this.dumpArray(bufferArray) + "," + n4 + ")");
        this.downstreamGL.glMultiDrawElements(n2, intBuffer, n3, bufferArray, n4);
        this.println("");
    }

    @Override
    public void glMultiDrawElements(int n2, int[] nArray, int n3, int n4, Buffer[] bufferArray, int n5) {
        this.printIndent();
        this.print("glMultiDrawElements(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + "," + n4 + "," + this.dumpArray(bufferArray) + "," + n5 + ")");
        this.downstreamGL.glMultiDrawElements(n2, nArray, n3, n4, bufferArray, n5);
        this.println("");
    }

    @Override
    public void glMultiDrawElementsEXT(int n2, IntBuffer intBuffer, int n3, Buffer[] bufferArray, int n4) {
        this.printIndent();
        this.print("glMultiDrawElementsEXT(" + n2 + "," + intBuffer + "," + n3 + "," + this.dumpArray(bufferArray) + "," + n4 + ")");
        this.downstreamGL.glMultiDrawElementsEXT(n2, intBuffer, n3, bufferArray, n4);
        this.println("");
    }

    @Override
    public void glMultiDrawElementsEXT(int n2, int[] nArray, int n3, int n4, Buffer[] bufferArray, int n5) {
        this.printIndent();
        this.print("glMultiDrawElementsEXT(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + "," + n4 + "," + this.dumpArray(bufferArray) + "," + n5 + ")");
        this.downstreamGL.glMultiDrawElementsEXT(n2, nArray, n3, n4, bufferArray, n5);
        this.println("");
    }

    @Override
    public void glMultiDrawRangeElementArrayAPPLE(int n2, int n3, int n4, IntBuffer intBuffer, IntBuffer intBuffer2, int n5) {
        this.printIndent();
        this.print("glMultiDrawRangeElementArrayAPPLE(" + n2 + "," + n3 + "," + n4 + "," + intBuffer + "," + intBuffer2 + "," + n5 + ")");
        this.downstreamGL.glMultiDrawRangeElementArrayAPPLE(n2, n3, n4, intBuffer, intBuffer2, n5);
        this.println("");
    }

    @Override
    public void glMultiDrawRangeElementArrayAPPLE(int n2, int n3, int n4, int[] nArray, int n5, int[] nArray2, int n6, int n7) {
        this.printIndent();
        this.print("glMultiDrawRangeElementArrayAPPLE(" + n2 + "," + n3 + "," + n4 + "," + this.dumpArray(nArray) + "," + n5 + "," + this.dumpArray(nArray2) + "," + n6 + "," + n7 + ")");
        this.downstreamGL.glMultiDrawRangeElementArrayAPPLE(n2, n3, n4, nArray, n5, nArray2, n6, n7);
        this.println("");
    }

    @Override
    public void glMultiModeDrawArraysIBM(IntBuffer intBuffer, IntBuffer intBuffer2, IntBuffer intBuffer3, int n2, int n3) {
        this.printIndent();
        this.print("glMultiModeDrawArraysIBM(" + intBuffer + "," + intBuffer2 + "," + intBuffer3 + "," + n2 + "," + n3 + ")");
        this.downstreamGL.glMultiModeDrawArraysIBM(intBuffer, intBuffer2, intBuffer3, n2, n3);
        this.println("");
    }

    @Override
    public void glMultiModeDrawArraysIBM(int[] nArray, int n2, int[] nArray2, int n3, int[] nArray3, int n4, int n5, int n6) {
        this.printIndent();
        this.print("glMultiModeDrawArraysIBM(" + this.dumpArray(nArray) + "," + n2 + "," + this.dumpArray(nArray2) + "," + n3 + "," + this.dumpArray(nArray3) + "," + n4 + "," + n5 + "," + n6 + ")");
        this.downstreamGL.glMultiModeDrawArraysIBM(nArray, n2, nArray2, n3, nArray3, n4, n5, n6);
        this.println("");
    }

    @Override
    public void glMultiModeDrawElementsIBM(IntBuffer intBuffer, IntBuffer intBuffer2, int n2, Buffer[] bufferArray, int n3, int n4) {
        this.printIndent();
        this.print("glMultiModeDrawElementsIBM(" + intBuffer + "," + intBuffer2 + "," + n2 + "," + this.dumpArray(bufferArray) + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glMultiModeDrawElementsIBM(intBuffer, intBuffer2, n2, bufferArray, n3, n4);
        this.println("");
    }

    @Override
    public void glMultiModeDrawElementsIBM(int[] nArray, int n2, int[] nArray2, int n3, int n4, Buffer[] bufferArray, int n5, int n6) {
        this.printIndent();
        this.print("glMultiModeDrawElementsIBM(" + this.dumpArray(nArray) + "," + n2 + "," + this.dumpArray(nArray2) + "," + n3 + "," + n4 + "," + this.dumpArray(bufferArray) + "," + n5 + "," + n6 + ")");
        this.downstreamGL.glMultiModeDrawElementsIBM(nArray, n2, nArray2, n3, n4, bufferArray, n5, n6);
        this.println("");
    }

    @Override
    public void glMultiTexCoord1d(int n2, double d2) {
        this.printIndent();
        this.print("glMultiTexCoord1d(" + n2 + "," + d2 + ")");
        this.downstreamGL.glMultiTexCoord1d(n2, d2);
        this.println("");
    }

    @Override
    public void glMultiTexCoord1dv(int n2, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord1dv(" + n2 + "," + doubleBuffer + ")");
        this.downstreamGL.glMultiTexCoord1dv(n2, doubleBuffer);
        this.println("");
    }

    @Override
    public void glMultiTexCoord1dv(int n2, double[] dArray, int n3) {
        this.printIndent();
        this.print("glMultiTexCoord1dv(" + n2 + "," + this.dumpArray(dArray) + "," + n3 + ")");
        this.downstreamGL.glMultiTexCoord1dv(n2, dArray, n3);
        this.println("");
    }

    @Override
    public void glMultiTexCoord1f(int n2, float f2) {
        this.printIndent();
        this.print("glMultiTexCoord1f(" + n2 + "," + f2 + ")");
        this.downstreamGL.glMultiTexCoord1f(n2, f2);
        this.println("");
    }

    @Override
    public void glMultiTexCoord1fv(int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord1fv(" + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glMultiTexCoord1fv(n2, floatBuffer);
        this.println("");
    }

    @Override
    public void glMultiTexCoord1fv(int n2, float[] fArray, int n3) {
        this.printIndent();
        this.print("glMultiTexCoord1fv(" + n2 + "," + this.dumpArray(fArray) + "," + n3 + ")");
        this.downstreamGL.glMultiTexCoord1fv(n2, fArray, n3);
        this.println("");
    }

    @Override
    public void glMultiTexCoord1hNV(int n2, short s2) {
        this.printIndent();
        this.print("glMultiTexCoord1hNV(" + n2 + "," + s2 + ")");
        this.downstreamGL.glMultiTexCoord1hNV(n2, s2);
        this.println("");
    }

    @Override
    public void glMultiTexCoord1hvNV(int n2, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord1hvNV(" + n2 + "," + shortBuffer + ")");
        this.downstreamGL.glMultiTexCoord1hvNV(n2, shortBuffer);
        this.println("");
    }

    @Override
    public void glMultiTexCoord1hvNV(int n2, short[] sArray, int n3) {
        this.printIndent();
        this.print("glMultiTexCoord1hvNV(" + n2 + "," + this.dumpArray(sArray) + "," + n3 + ")");
        this.downstreamGL.glMultiTexCoord1hvNV(n2, sArray, n3);
        this.println("");
    }

    @Override
    public void glMultiTexCoord1i(int n2, int n3) {
        this.printIndent();
        this.print("glMultiTexCoord1i(" + n2 + "," + n3 + ")");
        this.downstreamGL.glMultiTexCoord1i(n2, n3);
        this.println("");
    }

    @Override
    public void glMultiTexCoord1iv(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord1iv(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glMultiTexCoord1iv(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glMultiTexCoord1iv(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glMultiTexCoord1iv(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glMultiTexCoord1iv(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glMultiTexCoord1s(int n2, short s2) {
        this.printIndent();
        this.print("glMultiTexCoord1s(" + n2 + "," + s2 + ")");
        this.downstreamGL.glMultiTexCoord1s(n2, s2);
        this.println("");
    }

    @Override
    public void glMultiTexCoord1sv(int n2, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord1sv(" + n2 + "," + shortBuffer + ")");
        this.downstreamGL.glMultiTexCoord1sv(n2, shortBuffer);
        this.println("");
    }

    @Override
    public void glMultiTexCoord1sv(int n2, short[] sArray, int n3) {
        this.printIndent();
        this.print("glMultiTexCoord1sv(" + n2 + "," + this.dumpArray(sArray) + "," + n3 + ")");
        this.downstreamGL.glMultiTexCoord1sv(n2, sArray, n3);
        this.println("");
    }

    @Override
    public void glMultiTexCoord2d(int n2, double d2, double d3) {
        this.printIndent();
        this.print("glMultiTexCoord2d(" + n2 + "," + d2 + "," + d3 + ")");
        this.downstreamGL.glMultiTexCoord2d(n2, d2, d3);
        this.println("");
    }

    @Override
    public void glMultiTexCoord2dv(int n2, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord2dv(" + n2 + "," + doubleBuffer + ")");
        this.downstreamGL.glMultiTexCoord2dv(n2, doubleBuffer);
        this.println("");
    }

    @Override
    public void glMultiTexCoord2dv(int n2, double[] dArray, int n3) {
        this.printIndent();
        this.print("glMultiTexCoord2dv(" + n2 + "," + this.dumpArray(dArray) + "," + n3 + ")");
        this.downstreamGL.glMultiTexCoord2dv(n2, dArray, n3);
        this.println("");
    }

    @Override
    public void glMultiTexCoord2f(int n2, float f2, float f3) {
        this.printIndent();
        this.print("glMultiTexCoord2f(" + n2 + "," + f2 + "," + f3 + ")");
        this.downstreamGL.glMultiTexCoord2f(n2, f2, f3);
        this.println("");
    }

    @Override
    public void glMultiTexCoord2fv(int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord2fv(" + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glMultiTexCoord2fv(n2, floatBuffer);
        this.println("");
    }

    @Override
    public void glMultiTexCoord2fv(int n2, float[] fArray, int n3) {
        this.printIndent();
        this.print("glMultiTexCoord2fv(" + n2 + "," + this.dumpArray(fArray) + "," + n3 + ")");
        this.downstreamGL.glMultiTexCoord2fv(n2, fArray, n3);
        this.println("");
    }

    @Override
    public void glMultiTexCoord2hNV(int n2, short s2, short s3) {
        this.printIndent();
        this.print("glMultiTexCoord2hNV(" + n2 + "," + s2 + "," + s3 + ")");
        this.downstreamGL.glMultiTexCoord2hNV(n2, s2, s3);
        this.println("");
    }

    @Override
    public void glMultiTexCoord2hvNV(int n2, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord2hvNV(" + n2 + "," + shortBuffer + ")");
        this.downstreamGL.glMultiTexCoord2hvNV(n2, shortBuffer);
        this.println("");
    }

    @Override
    public void glMultiTexCoord2hvNV(int n2, short[] sArray, int n3) {
        this.printIndent();
        this.print("glMultiTexCoord2hvNV(" + n2 + "," + this.dumpArray(sArray) + "," + n3 + ")");
        this.downstreamGL.glMultiTexCoord2hvNV(n2, sArray, n3);
        this.println("");
    }

    @Override
    public void glMultiTexCoord2i(int n2, int n3, int n4) {
        this.printIndent();
        this.print("glMultiTexCoord2i(" + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glMultiTexCoord2i(n2, n3, n4);
        this.println("");
    }

    @Override
    public void glMultiTexCoord2iv(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord2iv(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glMultiTexCoord2iv(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glMultiTexCoord2iv(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glMultiTexCoord2iv(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glMultiTexCoord2iv(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glMultiTexCoord2s(int n2, short s2, short s3) {
        this.printIndent();
        this.print("glMultiTexCoord2s(" + n2 + "," + s2 + "," + s3 + ")");
        this.downstreamGL.glMultiTexCoord2s(n2, s2, s3);
        this.println("");
    }

    @Override
    public void glMultiTexCoord2sv(int n2, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord2sv(" + n2 + "," + shortBuffer + ")");
        this.downstreamGL.glMultiTexCoord2sv(n2, shortBuffer);
        this.println("");
    }

    @Override
    public void glMultiTexCoord2sv(int n2, short[] sArray, int n3) {
        this.printIndent();
        this.print("glMultiTexCoord2sv(" + n2 + "," + this.dumpArray(sArray) + "," + n3 + ")");
        this.downstreamGL.glMultiTexCoord2sv(n2, sArray, n3);
        this.println("");
    }

    @Override
    public void glMultiTexCoord3d(int n2, double d2, double d3, double d4) {
        this.printIndent();
        this.print("glMultiTexCoord3d(" + n2 + "," + d2 + "," + d3 + "," + d4 + ")");
        this.downstreamGL.glMultiTexCoord3d(n2, d2, d3, d4);
        this.println("");
    }

    @Override
    public void glMultiTexCoord3dv(int n2, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord3dv(" + n2 + "," + doubleBuffer + ")");
        this.downstreamGL.glMultiTexCoord3dv(n2, doubleBuffer);
        this.println("");
    }

    @Override
    public void glMultiTexCoord3dv(int n2, double[] dArray, int n3) {
        this.printIndent();
        this.print("glMultiTexCoord3dv(" + n2 + "," + this.dumpArray(dArray) + "," + n3 + ")");
        this.downstreamGL.glMultiTexCoord3dv(n2, dArray, n3);
        this.println("");
    }

    @Override
    public void glMultiTexCoord3f(int n2, float f2, float f3, float f4) {
        this.printIndent();
        this.print("glMultiTexCoord3f(" + n2 + "," + f2 + "," + f3 + "," + f4 + ")");
        this.downstreamGL.glMultiTexCoord3f(n2, f2, f3, f4);
        this.println("");
    }

    @Override
    public void glMultiTexCoord3fv(int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord3fv(" + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glMultiTexCoord3fv(n2, floatBuffer);
        this.println("");
    }

    @Override
    public void glMultiTexCoord3fv(int n2, float[] fArray, int n3) {
        this.printIndent();
        this.print("glMultiTexCoord3fv(" + n2 + "," + this.dumpArray(fArray) + "," + n3 + ")");
        this.downstreamGL.glMultiTexCoord3fv(n2, fArray, n3);
        this.println("");
    }

    @Override
    public void glMultiTexCoord3hNV(int n2, short s2, short s3, short s4) {
        this.printIndent();
        this.print("glMultiTexCoord3hNV(" + n2 + "," + s2 + "," + s3 + "," + s4 + ")");
        this.downstreamGL.glMultiTexCoord3hNV(n2, s2, s3, s4);
        this.println("");
    }

    @Override
    public void glMultiTexCoord3hvNV(int n2, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord3hvNV(" + n2 + "," + shortBuffer + ")");
        this.downstreamGL.glMultiTexCoord3hvNV(n2, shortBuffer);
        this.println("");
    }

    @Override
    public void glMultiTexCoord3hvNV(int n2, short[] sArray, int n3) {
        this.printIndent();
        this.print("glMultiTexCoord3hvNV(" + n2 + "," + this.dumpArray(sArray) + "," + n3 + ")");
        this.downstreamGL.glMultiTexCoord3hvNV(n2, sArray, n3);
        this.println("");
    }

    @Override
    public void glMultiTexCoord3i(int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glMultiTexCoord3i(" + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glMultiTexCoord3i(n2, n3, n4, n5);
        this.println("");
    }

    @Override
    public void glMultiTexCoord3iv(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord3iv(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glMultiTexCoord3iv(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glMultiTexCoord3iv(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glMultiTexCoord3iv(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glMultiTexCoord3iv(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glMultiTexCoord3s(int n2, short s2, short s3, short s4) {
        this.printIndent();
        this.print("glMultiTexCoord3s(" + n2 + "," + s2 + "," + s3 + "," + s4 + ")");
        this.downstreamGL.glMultiTexCoord3s(n2, s2, s3, s4);
        this.println("");
    }

    @Override
    public void glMultiTexCoord3sv(int n2, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord3sv(" + n2 + "," + shortBuffer + ")");
        this.downstreamGL.glMultiTexCoord3sv(n2, shortBuffer);
        this.println("");
    }

    @Override
    public void glMultiTexCoord3sv(int n2, short[] sArray, int n3) {
        this.printIndent();
        this.print("glMultiTexCoord3sv(" + n2 + "," + this.dumpArray(sArray) + "," + n3 + ")");
        this.downstreamGL.glMultiTexCoord3sv(n2, sArray, n3);
        this.println("");
    }

    @Override
    public void glMultiTexCoord4d(int n2, double d2, double d3, double d4, double d5) {
        this.printIndent();
        this.print("glMultiTexCoord4d(" + n2 + "," + d2 + "," + d3 + "," + d4 + "," + d5 + ")");
        this.downstreamGL.glMultiTexCoord4d(n2, d2, d3, d4, d5);
        this.println("");
    }

    @Override
    public void glMultiTexCoord4dv(int n2, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord4dv(" + n2 + "," + doubleBuffer + ")");
        this.downstreamGL.glMultiTexCoord4dv(n2, doubleBuffer);
        this.println("");
    }

    @Override
    public void glMultiTexCoord4dv(int n2, double[] dArray, int n3) {
        this.printIndent();
        this.print("glMultiTexCoord4dv(" + n2 + "," + this.dumpArray(dArray) + "," + n3 + ")");
        this.downstreamGL.glMultiTexCoord4dv(n2, dArray, n3);
        this.println("");
    }

    @Override
    public void glMultiTexCoord4f(int n2, float f2, float f3, float f4, float f5) {
        this.printIndent();
        this.print("glMultiTexCoord4f(" + n2 + "," + f2 + "," + f3 + "," + f4 + "," + f5 + ")");
        this.downstreamGL.glMultiTexCoord4f(n2, f2, f3, f4, f5);
        this.println("");
    }

    @Override
    public void glMultiTexCoord4fv(int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord4fv(" + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glMultiTexCoord4fv(n2, floatBuffer);
        this.println("");
    }

    @Override
    public void glMultiTexCoord4fv(int n2, float[] fArray, int n3) {
        this.printIndent();
        this.print("glMultiTexCoord4fv(" + n2 + "," + this.dumpArray(fArray) + "," + n3 + ")");
        this.downstreamGL.glMultiTexCoord4fv(n2, fArray, n3);
        this.println("");
    }

    @Override
    public void glMultiTexCoord4hNV(int n2, short s2, short s3, short s4, short s5) {
        this.printIndent();
        this.print("glMultiTexCoord4hNV(" + n2 + "," + s2 + "," + s3 + "," + s4 + "," + s5 + ")");
        this.downstreamGL.glMultiTexCoord4hNV(n2, s2, s3, s4, s5);
        this.println("");
    }

    @Override
    public void glMultiTexCoord4hvNV(int n2, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord4hvNV(" + n2 + "," + shortBuffer + ")");
        this.downstreamGL.glMultiTexCoord4hvNV(n2, shortBuffer);
        this.println("");
    }

    @Override
    public void glMultiTexCoord4hvNV(int n2, short[] sArray, int n3) {
        this.printIndent();
        this.print("glMultiTexCoord4hvNV(" + n2 + "," + this.dumpArray(sArray) + "," + n3 + ")");
        this.downstreamGL.glMultiTexCoord4hvNV(n2, sArray, n3);
        this.println("");
    }

    @Override
    public void glMultiTexCoord4i(int n2, int n3, int n4, int n5, int n6) {
        this.printIndent();
        this.print("glMultiTexCoord4i(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + ")");
        this.downstreamGL.glMultiTexCoord4i(n2, n3, n4, n5, n6);
        this.println("");
    }

    @Override
    public void glMultiTexCoord4iv(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord4iv(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glMultiTexCoord4iv(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glMultiTexCoord4iv(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glMultiTexCoord4iv(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glMultiTexCoord4iv(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glMultiTexCoord4s(int n2, short s2, short s3, short s4, short s5) {
        this.printIndent();
        this.print("glMultiTexCoord4s(" + n2 + "," + s2 + "," + s3 + "," + s4 + "," + s5 + ")");
        this.downstreamGL.glMultiTexCoord4s(n2, s2, s3, s4, s5);
        this.println("");
    }

    @Override
    public void glMultiTexCoord4sv(int n2, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glMultiTexCoord4sv(" + n2 + "," + shortBuffer + ")");
        this.downstreamGL.glMultiTexCoord4sv(n2, shortBuffer);
        this.println("");
    }

    @Override
    public void glMultiTexCoord4sv(int n2, short[] sArray, int n3) {
        this.printIndent();
        this.print("glMultiTexCoord4sv(" + n2 + "," + this.dumpArray(sArray) + "," + n3 + ")");
        this.downstreamGL.glMultiTexCoord4sv(n2, sArray, n3);
        this.println("");
    }

    @Override
    public int glNewBufferRegion(int n2) {
        this.printIndent();
        this.print("glNewBufferRegion(" + n2 + ")");
        n2 = this.downstreamGL.glNewBufferRegion(n2);
        this.println(" = " + n2);
        return n2;
    }

    @Override
    public void glNewList(int n2, int n3) {
        this.printIndent();
        this.print("glNewList(" + n2 + "," + n3 + ")");
        this.downstreamGL.glNewList(n2, n3);
        this.println("");
    }

    @Override
    public int glNewObjectBufferATI(int n2, Buffer buffer, int n3) {
        this.printIndent();
        this.print("glNewObjectBufferATI(" + n2 + "," + buffer + "," + n3 + ")");
        n2 = this.downstreamGL.glNewObjectBufferATI(n2, buffer, n3);
        this.println(" = " + n2);
        return n2;
    }

    @Override
    public void glNormal3b(byte by, byte by2, byte by3) {
        this.printIndent();
        this.print("glNormal3b(" + by + "," + by2 + "," + by3 + ")");
        this.downstreamGL.glNormal3b(by, by2, by3);
        this.println("");
    }

    @Override
    public void glNormal3bv(ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glNormal3bv(" + byteBuffer + ")");
        this.downstreamGL.glNormal3bv(byteBuffer);
        this.println("");
    }

    @Override
    public void glNormal3bv(byte[] byArray, int n2) {
        this.printIndent();
        this.print("glNormal3bv(" + this.dumpArray(byArray) + "," + n2 + ")");
        this.downstreamGL.glNormal3bv(byArray, n2);
        this.println("");
    }

    @Override
    public void glNormal3d(double d2, double d3, double d4) {
        this.printIndent();
        this.print("glNormal3d(" + d2 + "," + d3 + "," + d4 + ")");
        this.downstreamGL.glNormal3d(d2, d3, d4);
        this.println("");
    }

    @Override
    public void glNormal3dv(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glNormal3dv(" + doubleBuffer + ")");
        this.downstreamGL.glNormal3dv(doubleBuffer);
        this.println("");
    }

    @Override
    public void glNormal3dv(double[] dArray, int n2) {
        this.printIndent();
        this.print("glNormal3dv(" + this.dumpArray(dArray) + "," + n2 + ")");
        this.downstreamGL.glNormal3dv(dArray, n2);
        this.println("");
    }

    @Override
    public void glNormal3f(float f2, float f3, float f4) {
        this.printIndent();
        this.print("glNormal3f(" + f2 + "," + f3 + "," + f4 + ")");
        this.downstreamGL.glNormal3f(f2, f3, f4);
        this.println("");
    }

    @Override
    public void glNormal3fVertex3fSUN(float f2, float f3, float f4, float f5, float f6, float f7) {
        this.printIndent();
        this.print("glNormal3fVertex3fSUN(" + f2 + "," + f3 + "," + f4 + "," + f5 + "," + f6 + "," + f7 + ")");
        this.downstreamGL.glNormal3fVertex3fSUN(f2, f3, f4, f5, f6, f7);
        this.println("");
    }

    @Override
    public void glNormal3fVertex3fvSUN(FloatBuffer floatBuffer, FloatBuffer floatBuffer2) {
        this.printIndent();
        this.print("glNormal3fVertex3fvSUN(" + floatBuffer + "," + floatBuffer2 + ")");
        this.downstreamGL.glNormal3fVertex3fvSUN(floatBuffer, floatBuffer2);
        this.println("");
    }

    @Override
    public void glNormal3fVertex3fvSUN(float[] fArray, int n2, float[] fArray2, int n3) {
        this.printIndent();
        this.print("glNormal3fVertex3fvSUN(" + this.dumpArray(fArray) + "," + n2 + "," + this.dumpArray(fArray2) + "," + n3 + ")");
        this.downstreamGL.glNormal3fVertex3fvSUN(fArray, n2, fArray2, n3);
        this.println("");
    }

    @Override
    public void glNormal3fv(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glNormal3fv(" + floatBuffer + ")");
        this.downstreamGL.glNormal3fv(floatBuffer);
        this.println("");
    }

    @Override
    public void glNormal3fv(float[] fArray, int n2) {
        this.printIndent();
        this.print("glNormal3fv(" + this.dumpArray(fArray) + "," + n2 + ")");
        this.downstreamGL.glNormal3fv(fArray, n2);
        this.println("");
    }

    @Override
    public void glNormal3hNV(short s2, short s3, short s4) {
        this.printIndent();
        this.print("glNormal3hNV(" + s2 + "," + s3 + "," + s4 + ")");
        this.downstreamGL.glNormal3hNV(s2, s3, s4);
        this.println("");
    }

    @Override
    public void glNormal3hvNV(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glNormal3hvNV(" + shortBuffer + ")");
        this.downstreamGL.glNormal3hvNV(shortBuffer);
        this.println("");
    }

    @Override
    public void glNormal3hvNV(short[] sArray, int n2) {
        this.printIndent();
        this.print("glNormal3hvNV(" + this.dumpArray(sArray) + "," + n2 + ")");
        this.downstreamGL.glNormal3hvNV(sArray, n2);
        this.println("");
    }

    @Override
    public void glNormal3i(int n2, int n3, int n4) {
        this.printIndent();
        this.print("glNormal3i(" + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glNormal3i(n2, n3, n4);
        this.println("");
    }

    @Override
    public void glNormal3iv(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glNormal3iv(" + intBuffer + ")");
        this.downstreamGL.glNormal3iv(intBuffer);
        this.println("");
    }

    @Override
    public void glNormal3iv(int[] nArray, int n2) {
        this.printIndent();
        this.print("glNormal3iv(" + this.dumpArray(nArray) + "," + n2 + ")");
        this.downstreamGL.glNormal3iv(nArray, n2);
        this.println("");
    }

    @Override
    public void glNormal3s(short s2, short s3, short s4) {
        this.printIndent();
        this.print("glNormal3s(" + s2 + "," + s3 + "," + s4 + ")");
        this.downstreamGL.glNormal3s(s2, s3, s4);
        this.println("");
    }

    @Override
    public void glNormal3sv(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glNormal3sv(" + shortBuffer + ")");
        this.downstreamGL.glNormal3sv(shortBuffer);
        this.println("");
    }

    @Override
    public void glNormal3sv(short[] sArray, int n2) {
        this.printIndent();
        this.print("glNormal3sv(" + this.dumpArray(sArray) + "," + n2 + ")");
        this.downstreamGL.glNormal3sv(sArray, n2);
        this.println("");
    }

    @Override
    public void glNormalPointer(int n2, int n3, Buffer buffer) {
        this.printIndent();
        this.print("glNormalPointer(" + n2 + "," + n3 + "," + buffer + ")");
        this.downstreamGL.glNormalPointer(n2, n3, buffer);
        this.println("");
    }

    @Override
    public void glNormalPointer(int n2, int n3, long l2) {
        this.printIndent();
        this.print("glNormalPointer(" + n2 + "," + n3 + "," + l2 + ")");
        this.downstreamGL.glNormalPointer(n2, n3, l2);
        this.println("");
    }

    @Override
    public void glNormalStream3bATI(int n2, byte by, byte by2, byte by3) {
        this.printIndent();
        this.print("glNormalStream3bATI(" + n2 + "," + by + "," + by2 + "," + by3 + ")");
        this.downstreamGL.glNormalStream3bATI(n2, by, by2, by3);
        this.println("");
    }

    @Override
    public void glNormalStream3bvATI(int n2, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glNormalStream3bvATI(" + n2 + "," + byteBuffer + ")");
        this.downstreamGL.glNormalStream3bvATI(n2, byteBuffer);
        this.println("");
    }

    @Override
    public void glNormalStream3bvATI(int n2, byte[] byArray, int n3) {
        this.printIndent();
        this.print("glNormalStream3bvATI(" + n2 + "," + this.dumpArray(byArray) + "," + n3 + ")");
        this.downstreamGL.glNormalStream3bvATI(n2, byArray, n3);
        this.println("");
    }

    @Override
    public void glNormalStream3dATI(int n2, double d2, double d3, double d4) {
        this.printIndent();
        this.print("glNormalStream3dATI(" + n2 + "," + d2 + "," + d3 + "," + d4 + ")");
        this.downstreamGL.glNormalStream3dATI(n2, d2, d3, d4);
        this.println("");
    }

    @Override
    public void glNormalStream3dvATI(int n2, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glNormalStream3dvATI(" + n2 + "," + doubleBuffer + ")");
        this.downstreamGL.glNormalStream3dvATI(n2, doubleBuffer);
        this.println("");
    }

    @Override
    public void glNormalStream3dvATI(int n2, double[] dArray, int n3) {
        this.printIndent();
        this.print("glNormalStream3dvATI(" + n2 + "," + this.dumpArray(dArray) + "," + n3 + ")");
        this.downstreamGL.glNormalStream3dvATI(n2, dArray, n3);
        this.println("");
    }

    @Override
    public void glNormalStream3fATI(int n2, float f2, float f3, float f4) {
        this.printIndent();
        this.print("glNormalStream3fATI(" + n2 + "," + f2 + "," + f3 + "," + f4 + ")");
        this.downstreamGL.glNormalStream3fATI(n2, f2, f3, f4);
        this.println("");
    }

    @Override
    public void glNormalStream3fvATI(int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glNormalStream3fvATI(" + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glNormalStream3fvATI(n2, floatBuffer);
        this.println("");
    }

    @Override
    public void glNormalStream3fvATI(int n2, float[] fArray, int n3) {
        this.printIndent();
        this.print("glNormalStream3fvATI(" + n2 + "," + this.dumpArray(fArray) + "," + n3 + ")");
        this.downstreamGL.glNormalStream3fvATI(n2, fArray, n3);
        this.println("");
    }

    @Override
    public void glNormalStream3iATI(int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glNormalStream3iATI(" + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glNormalStream3iATI(n2, n3, n4, n5);
        this.println("");
    }

    @Override
    public void glNormalStream3ivATI(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glNormalStream3ivATI(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glNormalStream3ivATI(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glNormalStream3ivATI(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glNormalStream3ivATI(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glNormalStream3ivATI(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glNormalStream3sATI(int n2, short s2, short s3, short s4) {
        this.printIndent();
        this.print("glNormalStream3sATI(" + n2 + "," + s2 + "," + s3 + "," + s4 + ")");
        this.downstreamGL.glNormalStream3sATI(n2, s2, s3, s4);
        this.println("");
    }

    @Override
    public void glNormalStream3svATI(int n2, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glNormalStream3svATI(" + n2 + "," + shortBuffer + ")");
        this.downstreamGL.glNormalStream3svATI(n2, shortBuffer);
        this.println("");
    }

    @Override
    public void glNormalStream3svATI(int n2, short[] sArray, int n3) {
        this.printIndent();
        this.print("glNormalStream3svATI(" + n2 + "," + this.dumpArray(sArray) + "," + n3 + ")");
        this.downstreamGL.glNormalStream3svATI(n2, sArray, n3);
        this.println("");
    }

    @Override
    public void glOrtho(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.printIndent();
        this.print("glOrtho(" + d2 + "," + d3 + "," + d4 + "," + d5 + "," + d6 + "," + d7 + ")");
        this.downstreamGL.glOrtho(d2, d3, d4, d5, d6, d7);
        this.println("");
    }

    @Override
    public void glPNTrianglesfATI(int n2, float f2) {
        this.printIndent();
        this.print("glPNTrianglesfATI(" + n2 + "," + f2 + ")");
        this.downstreamGL.glPNTrianglesfATI(n2, f2);
        this.println("");
    }

    @Override
    public void glPNTrianglesiATI(int n2, int n3) {
        this.printIndent();
        this.print("glPNTrianglesiATI(" + n2 + "," + n3 + ")");
        this.downstreamGL.glPNTrianglesiATI(n2, n3);
        this.println("");
    }

    @Override
    public void glPassTexCoordATI(int n2, int n3, int n4) {
        this.printIndent();
        this.print("glPassTexCoordATI(" + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glPassTexCoordATI(n2, n3, n4);
        this.println("");
    }

    @Override
    public void glPassThrough(float f2) {
        this.printIndent();
        this.print("glPassThrough(" + f2 + ")");
        this.downstreamGL.glPassThrough(f2);
        this.println("");
    }

    @Override
    public void glPixelDataRangeNV(int n2, int n3, Buffer buffer) {
        this.printIndent();
        this.print("glPixelDataRangeNV(" + n2 + "," + n3 + "," + buffer + ")");
        this.downstreamGL.glPixelDataRangeNV(n2, n3, buffer);
        this.println("");
    }

    @Override
    public void glPixelMapfv(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glPixelMapfv(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glPixelMapfv(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glPixelMapfv(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glPixelMapfv(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glPixelMapfv(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glPixelMapfv(int n2, int n3, long l2) {
        this.printIndent();
        this.print("glPixelMapfv(" + n2 + "," + n3 + "," + l2 + ")");
        this.downstreamGL.glPixelMapfv(n2, n3, l2);
        this.println("");
    }

    @Override
    public void glPixelMapuiv(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glPixelMapuiv(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glPixelMapuiv(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glPixelMapuiv(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glPixelMapuiv(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glPixelMapuiv(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glPixelMapuiv(int n2, int n3, long l2) {
        this.printIndent();
        this.print("glPixelMapuiv(" + n2 + "," + n3 + "," + l2 + ")");
        this.downstreamGL.glPixelMapuiv(n2, n3, l2);
        this.println("");
    }

    @Override
    public void glPixelMapusv(int n2, int n3, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glPixelMapusv(" + n2 + "," + n3 + "," + shortBuffer + ")");
        this.downstreamGL.glPixelMapusv(n2, n3, shortBuffer);
        this.println("");
    }

    @Override
    public void glPixelMapusv(int n2, int n3, short[] sArray, int n4) {
        this.printIndent();
        this.print("glPixelMapusv(" + n2 + "," + n3 + "," + this.dumpArray(sArray) + "," + n4 + ")");
        this.downstreamGL.glPixelMapusv(n2, n3, sArray, n4);
        this.println("");
    }

    @Override
    public void glPixelMapusv(int n2, int n3, long l2) {
        this.printIndent();
        this.print("glPixelMapusv(" + n2 + "," + n3 + "," + l2 + ")");
        this.downstreamGL.glPixelMapusv(n2, n3, l2);
        this.println("");
    }

    @Override
    public void glPixelStoref(int n2, float f2) {
        this.printIndent();
        this.print("glPixelStoref(" + n2 + "," + f2 + ")");
        this.downstreamGL.glPixelStoref(n2, f2);
        this.println("");
    }

    @Override
    public void glPixelStorei(int n2, int n3) {
        this.printIndent();
        this.print("glPixelStorei(" + n2 + "," + n3 + ")");
        this.downstreamGL.glPixelStorei(n2, n3);
        this.println("");
    }

    @Override
    public void glPixelTexGenParameterfSGIS(int n2, float f2) {
        this.printIndent();
        this.print("glPixelTexGenParameterfSGIS(" + n2 + "," + f2 + ")");
        this.downstreamGL.glPixelTexGenParameterfSGIS(n2, f2);
        this.println("");
    }

    @Override
    public void glPixelTexGenParameterfvSGIS(int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glPixelTexGenParameterfvSGIS(" + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glPixelTexGenParameterfvSGIS(n2, floatBuffer);
        this.println("");
    }

    @Override
    public void glPixelTexGenParameterfvSGIS(int n2, float[] fArray, int n3) {
        this.printIndent();
        this.print("glPixelTexGenParameterfvSGIS(" + n2 + "," + this.dumpArray(fArray) + "," + n3 + ")");
        this.downstreamGL.glPixelTexGenParameterfvSGIS(n2, fArray, n3);
        this.println("");
    }

    @Override
    public void glPixelTexGenParameteriSGIS(int n2, int n3) {
        this.printIndent();
        this.print("glPixelTexGenParameteriSGIS(" + n2 + "," + n3 + ")");
        this.downstreamGL.glPixelTexGenParameteriSGIS(n2, n3);
        this.println("");
    }

    @Override
    public void glPixelTexGenParameterivSGIS(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glPixelTexGenParameterivSGIS(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glPixelTexGenParameterivSGIS(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glPixelTexGenParameterivSGIS(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glPixelTexGenParameterivSGIS(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glPixelTexGenParameterivSGIS(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glPixelTexGenSGIX(int n2) {
        this.printIndent();
        this.print("glPixelTexGenSGIX(" + n2 + ")");
        this.downstreamGL.glPixelTexGenSGIX(n2);
        this.println("");
    }

    @Override
    public void glPixelTransferf(int n2, float f2) {
        this.printIndent();
        this.print("glPixelTransferf(" + n2 + "," + f2 + ")");
        this.downstreamGL.glPixelTransferf(n2, f2);
        this.println("");
    }

    @Override
    public void glPixelTransferi(int n2, int n3) {
        this.printIndent();
        this.print("glPixelTransferi(" + n2 + "," + n3 + ")");
        this.downstreamGL.glPixelTransferi(n2, n3);
        this.println("");
    }

    @Override
    public void glPixelTransformParameterfEXT(int n2, int n3, float f2) {
        this.printIndent();
        this.print("glPixelTransformParameterfEXT(" + n2 + "," + n3 + "," + f2 + ")");
        this.downstreamGL.glPixelTransformParameterfEXT(n2, n3, f2);
        this.println("");
    }

    @Override
    public void glPixelTransformParameterfvEXT(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glPixelTransformParameterfvEXT(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glPixelTransformParameterfvEXT(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glPixelTransformParameterfvEXT(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glPixelTransformParameterfvEXT(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glPixelTransformParameterfvEXT(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glPixelTransformParameteriEXT(int n2, int n3, int n4) {
        this.printIndent();
        this.print("glPixelTransformParameteriEXT(" + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glPixelTransformParameteriEXT(n2, n3, n4);
        this.println("");
    }

    @Override
    public void glPixelTransformParameterivEXT(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glPixelTransformParameterivEXT(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glPixelTransformParameterivEXT(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glPixelTransformParameterivEXT(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glPixelTransformParameterivEXT(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glPixelTransformParameterivEXT(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glPixelZoom(float f2, float f3) {
        this.printIndent();
        this.print("glPixelZoom(" + f2 + "," + f3 + ")");
        this.downstreamGL.glPixelZoom(f2, f3);
        this.println("");
    }

    @Override
    public void glPointParameterf(int n2, float f2) {
        this.printIndent();
        this.print("glPointParameterf(" + n2 + "," + f2 + ")");
        this.downstreamGL.glPointParameterf(n2, f2);
        this.println("");
    }

    @Override
    public void glPointParameterfARB(int n2, float f2) {
        this.printIndent();
        this.print("glPointParameterfARB(" + n2 + "," + f2 + ")");
        this.downstreamGL.glPointParameterfARB(n2, f2);
        this.println("");
    }

    @Override
    public void glPointParameterfEXT(int n2, float f2) {
        this.printIndent();
        this.print("glPointParameterfEXT(" + n2 + "," + f2 + ")");
        this.downstreamGL.glPointParameterfEXT(n2, f2);
        this.println("");
    }

    @Override
    public void glPointParameterfSGIS(int n2, float f2) {
        this.printIndent();
        this.print("glPointParameterfSGIS(" + n2 + "," + f2 + ")");
        this.downstreamGL.glPointParameterfSGIS(n2, f2);
        this.println("");
    }

    @Override
    public void glPointParameterfv(int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glPointParameterfv(" + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glPointParameterfv(n2, floatBuffer);
        this.println("");
    }

    @Override
    public void glPointParameterfv(int n2, float[] fArray, int n3) {
        this.printIndent();
        this.print("glPointParameterfv(" + n2 + "," + this.dumpArray(fArray) + "," + n3 + ")");
        this.downstreamGL.glPointParameterfv(n2, fArray, n3);
        this.println("");
    }

    @Override
    public void glPointParameterfvARB(int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glPointParameterfvARB(" + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glPointParameterfvARB(n2, floatBuffer);
        this.println("");
    }

    @Override
    public void glPointParameterfvARB(int n2, float[] fArray, int n3) {
        this.printIndent();
        this.print("glPointParameterfvARB(" + n2 + "," + this.dumpArray(fArray) + "," + n3 + ")");
        this.downstreamGL.glPointParameterfvARB(n2, fArray, n3);
        this.println("");
    }

    @Override
    public void glPointParameterfvEXT(int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glPointParameterfvEXT(" + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glPointParameterfvEXT(n2, floatBuffer);
        this.println("");
    }

    @Override
    public void glPointParameterfvEXT(int n2, float[] fArray, int n3) {
        this.printIndent();
        this.print("glPointParameterfvEXT(" + n2 + "," + this.dumpArray(fArray) + "," + n3 + ")");
        this.downstreamGL.glPointParameterfvEXT(n2, fArray, n3);
        this.println("");
    }

    @Override
    public void glPointParameterfvSGIS(int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glPointParameterfvSGIS(" + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glPointParameterfvSGIS(n2, floatBuffer);
        this.println("");
    }

    @Override
    public void glPointParameterfvSGIS(int n2, float[] fArray, int n3) {
        this.printIndent();
        this.print("glPointParameterfvSGIS(" + n2 + "," + this.dumpArray(fArray) + "," + n3 + ")");
        this.downstreamGL.glPointParameterfvSGIS(n2, fArray, n3);
        this.println("");
    }

    @Override
    public void glPointParameteri(int n2, int n3) {
        this.printIndent();
        this.print("glPointParameteri(" + n2 + "," + n3 + ")");
        this.downstreamGL.glPointParameteri(n2, n3);
        this.println("");
    }

    @Override
    public void glPointParameteriNV(int n2, int n3) {
        this.printIndent();
        this.print("glPointParameteriNV(" + n2 + "," + n3 + ")");
        this.downstreamGL.glPointParameteriNV(n2, n3);
        this.println("");
    }

    @Override
    public void glPointParameteriv(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glPointParameteriv(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glPointParameteriv(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glPointParameteriv(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glPointParameteriv(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glPointParameteriv(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glPointParameterivNV(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glPointParameterivNV(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glPointParameterivNV(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glPointParameterivNV(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glPointParameterivNV(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glPointParameterivNV(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glPointSize(float f2) {
        this.printIndent();
        this.print("glPointSize(" + f2 + ")");
        this.downstreamGL.glPointSize(f2);
        this.println("");
    }

    @Override
    public int glPollAsyncSGIX(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glPollAsyncSGIX(" + intBuffer + ")");
        int n2 = this.downstreamGL.glPollAsyncSGIX(intBuffer);
        this.println(" = " + n2);
        return n2;
    }

    @Override
    public int glPollAsyncSGIX(int[] nArray, int n2) {
        this.printIndent();
        this.print("glPollAsyncSGIX(" + this.dumpArray(nArray) + "," + n2 + ")");
        int n3 = this.downstreamGL.glPollAsyncSGIX(nArray, n2);
        this.println(" = " + n3);
        return n3;
    }

    @Override
    public int glPollInstrumentsSGIX(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glPollInstrumentsSGIX(" + intBuffer + ")");
        int n2 = this.downstreamGL.glPollInstrumentsSGIX(intBuffer);
        this.println(" = " + n2);
        return n2;
    }

    @Override
    public int glPollInstrumentsSGIX(int[] nArray, int n2) {
        this.printIndent();
        this.print("glPollInstrumentsSGIX(" + this.dumpArray(nArray) + "," + n2 + ")");
        int n3 = this.downstreamGL.glPollInstrumentsSGIX(nArray, n2);
        this.println(" = " + n3);
        return n3;
    }

    @Override
    public void glPolygonMode(int n2, int n3) {
        this.printIndent();
        this.print("glPolygonMode(" + n2 + "," + n3 + ")");
        this.downstreamGL.glPolygonMode(n2, n3);
        this.println("");
    }

    @Override
    public void glPolygonOffset(float f2, float f3) {
        this.printIndent();
        this.print("glPolygonOffset(" + f2 + "," + f3 + ")");
        this.downstreamGL.glPolygonOffset(f2, f3);
        this.println("");
    }

    @Override
    public void glPolygonStipple(ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glPolygonStipple(" + byteBuffer + ")");
        this.downstreamGL.glPolygonStipple(byteBuffer);
        this.println("");
    }

    @Override
    public void glPolygonStipple(byte[] byArray, int n2) {
        this.printIndent();
        this.print("glPolygonStipple(" + this.dumpArray(byArray) + "," + n2 + ")");
        this.downstreamGL.glPolygonStipple(byArray, n2);
        this.println("");
    }

    @Override
    public void glPolygonStipple(long l2) {
        this.printIndent();
        this.print("glPolygonStipple(" + l2 + ")");
        this.downstreamGL.glPolygonStipple(l2);
        this.println("");
    }

    @Override
    public void glPopAttrib() {
        this.printIndent();
        this.print("glPopAttrib()");
        this.downstreamGL.glPopAttrib();
        this.println("");
    }

    @Override
    public void glPopClientAttrib() {
        this.printIndent();
        this.print("glPopClientAttrib()");
        this.downstreamGL.glPopClientAttrib();
        this.println("");
    }

    @Override
    public void glPopMatrix() {
        this.printIndent();
        this.print("glPopMatrix()");
        this.downstreamGL.glPopMatrix();
        this.println("");
    }

    @Override
    public void glPopName() {
        this.printIndent();
        this.print("glPopName()");
        this.downstreamGL.glPopName();
        this.println("");
    }

    @Override
    public void glPrimitiveRestartIndexNV(int n2) {
        this.printIndent();
        this.print("glPrimitiveRestartIndexNV(" + n2 + ")");
        this.downstreamGL.glPrimitiveRestartIndexNV(n2);
        this.println("");
    }

    @Override
    public void glPrimitiveRestartNV() {
        this.printIndent();
        this.print("glPrimitiveRestartNV()");
        this.downstreamGL.glPrimitiveRestartNV();
        this.println("");
    }

    @Override
    public void glPrioritizeTextures(int n2, IntBuffer intBuffer, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glPrioritizeTextures(" + n2 + "," + intBuffer + "," + floatBuffer + ")");
        this.downstreamGL.glPrioritizeTextures(n2, intBuffer, floatBuffer);
        this.println("");
    }

    @Override
    public void glPrioritizeTextures(int n2, int[] nArray, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glPrioritizeTextures(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glPrioritizeTextures(n2, nArray, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glProgramBufferParametersIivNV(int n2, int n3, int n4, int n5, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glProgramBufferParametersIivNV(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + intBuffer + ")");
        this.downstreamGL.glProgramBufferParametersIivNV(n2, n3, n4, n5, intBuffer);
        this.println("");
    }

    @Override
    public void glProgramBufferParametersIivNV(int n2, int n3, int n4, int n5, int[] nArray, int n6) {
        this.printIndent();
        this.print("glProgramBufferParametersIivNV(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(nArray) + "," + n6 + ")");
        this.downstreamGL.glProgramBufferParametersIivNV(n2, n3, n4, n5, nArray, n6);
        this.println("");
    }

    @Override
    public void glProgramBufferParametersIuivNV(int n2, int n3, int n4, int n5, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glProgramBufferParametersIuivNV(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + intBuffer + ")");
        this.downstreamGL.glProgramBufferParametersIuivNV(n2, n3, n4, n5, intBuffer);
        this.println("");
    }

    @Override
    public void glProgramBufferParametersIuivNV(int n2, int n3, int n4, int n5, int[] nArray, int n6) {
        this.printIndent();
        this.print("glProgramBufferParametersIuivNV(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(nArray) + "," + n6 + ")");
        this.downstreamGL.glProgramBufferParametersIuivNV(n2, n3, n4, n5, nArray, n6);
        this.println("");
    }

    @Override
    public void glProgramBufferParametersfvNV(int n2, int n3, int n4, int n5, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glProgramBufferParametersfvNV(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + floatBuffer + ")");
        this.downstreamGL.glProgramBufferParametersfvNV(n2, n3, n4, n5, floatBuffer);
        this.println("");
    }

    @Override
    public void glProgramBufferParametersfvNV(int n2, int n3, int n4, int n5, float[] fArray, int n6) {
        this.printIndent();
        this.print("glProgramBufferParametersfvNV(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + this.dumpArray(fArray) + "," + n6 + ")");
        this.downstreamGL.glProgramBufferParametersfvNV(n2, n3, n4, n5, fArray, n6);
        this.println("");
    }

    @Override
    public void glProgramEnvParameter4dARB(int n2, int n3, double d2, double d3, double d4, double d5) {
        this.printIndent();
        this.print("glProgramEnvParameter4dARB(" + n2 + "," + n3 + "," + d2 + "," + d3 + "," + d4 + "," + d5 + ")");
        this.downstreamGL.glProgramEnvParameter4dARB(n2, n3, d2, d3, d4, d5);
        this.println("");
    }

    @Override
    public void glProgramEnvParameter4dvARB(int n2, int n3, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glProgramEnvParameter4dvARB(" + n2 + "," + n3 + "," + doubleBuffer + ")");
        this.downstreamGL.glProgramEnvParameter4dvARB(n2, n3, doubleBuffer);
        this.println("");
    }

    @Override
    public void glProgramEnvParameter4dvARB(int n2, int n3, double[] dArray, int n4) {
        this.printIndent();
        this.print("glProgramEnvParameter4dvARB(" + n2 + "," + n3 + "," + this.dumpArray(dArray) + "," + n4 + ")");
        this.downstreamGL.glProgramEnvParameter4dvARB(n2, n3, dArray, n4);
        this.println("");
    }

    @Override
    public void glProgramEnvParameter4fARB(int n2, int n3, float f2, float f3, float f4, float f5) {
        this.printIndent();
        this.print("glProgramEnvParameter4fARB(" + n2 + "," + n3 + "," + f2 + "," + f3 + "," + f4 + "," + f5 + ")");
        this.downstreamGL.glProgramEnvParameter4fARB(n2, n3, f2, f3, f4, f5);
        this.println("");
    }

    @Override
    public void glProgramEnvParameter4fvARB(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glProgramEnvParameter4fvARB(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glProgramEnvParameter4fvARB(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glProgramEnvParameter4fvARB(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glProgramEnvParameter4fvARB(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glProgramEnvParameter4fvARB(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glProgramEnvParameterI4iNV(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.printIndent();
        this.print("glProgramEnvParameterI4iNV(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + ")");
        this.downstreamGL.glProgramEnvParameterI4iNV(n2, n3, n4, n5, n6, n7);
        this.println("");
    }

    @Override
    public void glProgramEnvParameterI4ivNV(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glProgramEnvParameterI4ivNV(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glProgramEnvParameterI4ivNV(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glProgramEnvParameterI4ivNV(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glProgramEnvParameterI4ivNV(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glProgramEnvParameterI4ivNV(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glProgramEnvParameterI4uiNV(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.printIndent();
        this.print("glProgramEnvParameterI4uiNV(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + ")");
        this.downstreamGL.glProgramEnvParameterI4uiNV(n2, n3, n4, n5, n6, n7);
        this.println("");
    }

    @Override
    public void glProgramEnvParameterI4uivNV(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glProgramEnvParameterI4uivNV(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glProgramEnvParameterI4uivNV(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glProgramEnvParameterI4uivNV(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glProgramEnvParameterI4uivNV(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glProgramEnvParameterI4uivNV(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glProgramEnvParameters4fvEXT(int n2, int n3, int n4, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glProgramEnvParameters4fvEXT(" + n2 + "," + n3 + "," + n4 + "," + floatBuffer + ")");
        this.downstreamGL.glProgramEnvParameters4fvEXT(n2, n3, n4, floatBuffer);
        this.println("");
    }

    @Override
    public void glProgramEnvParameters4fvEXT(int n2, int n3, int n4, float[] fArray, int n5) {
        this.printIndent();
        this.print("glProgramEnvParameters4fvEXT(" + n2 + "," + n3 + "," + n4 + "," + this.dumpArray(fArray) + "," + n5 + ")");
        this.downstreamGL.glProgramEnvParameters4fvEXT(n2, n3, n4, fArray, n5);
        this.println("");
    }

    @Override
    public void glProgramEnvParametersI4ivNV(int n2, int n3, int n4, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glProgramEnvParametersI4ivNV(" + n2 + "," + n3 + "," + n4 + "," + intBuffer + ")");
        this.downstreamGL.glProgramEnvParametersI4ivNV(n2, n3, n4, intBuffer);
        this.println("");
    }

    @Override
    public void glProgramEnvParametersI4ivNV(int n2, int n3, int n4, int[] nArray, int n5) {
        this.printIndent();
        this.print("glProgramEnvParametersI4ivNV(" + n2 + "," + n3 + "," + n4 + "," + this.dumpArray(nArray) + "," + n5 + ")");
        this.downstreamGL.glProgramEnvParametersI4ivNV(n2, n3, n4, nArray, n5);
        this.println("");
    }

    @Override
    public void glProgramEnvParametersI4uivNV(int n2, int n3, int n4, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glProgramEnvParametersI4uivNV(" + n2 + "," + n3 + "," + n4 + "," + intBuffer + ")");
        this.downstreamGL.glProgramEnvParametersI4uivNV(n2, n3, n4, intBuffer);
        this.println("");
    }

    @Override
    public void glProgramEnvParametersI4uivNV(int n2, int n3, int n4, int[] nArray, int n5) {
        this.printIndent();
        this.print("glProgramEnvParametersI4uivNV(" + n2 + "," + n3 + "," + n4 + "," + this.dumpArray(nArray) + "," + n5 + ")");
        this.downstreamGL.glProgramEnvParametersI4uivNV(n2, n3, n4, nArray, n5);
        this.println("");
    }

    @Override
    public void glProgramLocalParameter4dARB(int n2, int n3, double d2, double d3, double d4, double d5) {
        this.printIndent();
        this.print("glProgramLocalParameter4dARB(" + n2 + "," + n3 + "," + d2 + "," + d3 + "," + d4 + "," + d5 + ")");
        this.downstreamGL.glProgramLocalParameter4dARB(n2, n3, d2, d3, d4, d5);
        this.println("");
    }

    @Override
    public void glProgramLocalParameter4dvARB(int n2, int n3, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glProgramLocalParameter4dvARB(" + n2 + "," + n3 + "," + doubleBuffer + ")");
        this.downstreamGL.glProgramLocalParameter4dvARB(n2, n3, doubleBuffer);
        this.println("");
    }

    @Override
    public void glProgramLocalParameter4dvARB(int n2, int n3, double[] dArray, int n4) {
        this.printIndent();
        this.print("glProgramLocalParameter4dvARB(" + n2 + "," + n3 + "," + this.dumpArray(dArray) + "," + n4 + ")");
        this.downstreamGL.glProgramLocalParameter4dvARB(n2, n3, dArray, n4);
        this.println("");
    }

    @Override
    public void glProgramLocalParameter4fARB(int n2, int n3, float f2, float f3, float f4, float f5) {
        this.printIndent();
        this.print("glProgramLocalParameter4fARB(" + n2 + "," + n3 + "," + f2 + "," + f3 + "," + f4 + "," + f5 + ")");
        this.downstreamGL.glProgramLocalParameter4fARB(n2, n3, f2, f3, f4, f5);
        this.println("");
    }

    @Override
    public void glProgramLocalParameter4fvARB(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glProgramLocalParameter4fvARB(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glProgramLocalParameter4fvARB(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glProgramLocalParameter4fvARB(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glProgramLocalParameter4fvARB(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glProgramLocalParameter4fvARB(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glProgramLocalParameterI4iNV(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.printIndent();
        this.print("glProgramLocalParameterI4iNV(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + ")");
        this.downstreamGL.glProgramLocalParameterI4iNV(n2, n3, n4, n5, n6, n7);
        this.println("");
    }

    @Override
    public void glProgramLocalParameterI4ivNV(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glProgramLocalParameterI4ivNV(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glProgramLocalParameterI4ivNV(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glProgramLocalParameterI4ivNV(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glProgramLocalParameterI4ivNV(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glProgramLocalParameterI4ivNV(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glProgramLocalParameterI4uiNV(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.printIndent();
        this.print("glProgramLocalParameterI4uiNV(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + ")");
        this.downstreamGL.glProgramLocalParameterI4uiNV(n2, n3, n4, n5, n6, n7);
        this.println("");
    }

    @Override
    public void glProgramLocalParameterI4uivNV(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glProgramLocalParameterI4uivNV(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glProgramLocalParameterI4uivNV(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glProgramLocalParameterI4uivNV(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glProgramLocalParameterI4uivNV(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glProgramLocalParameterI4uivNV(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glProgramLocalParameters4fvEXT(int n2, int n3, int n4, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glProgramLocalParameters4fvEXT(" + n2 + "," + n3 + "," + n4 + "," + floatBuffer + ")");
        this.downstreamGL.glProgramLocalParameters4fvEXT(n2, n3, n4, floatBuffer);
        this.println("");
    }

    @Override
    public void glProgramLocalParameters4fvEXT(int n2, int n3, int n4, float[] fArray, int n5) {
        this.printIndent();
        this.print("glProgramLocalParameters4fvEXT(" + n2 + "," + n3 + "," + n4 + "," + this.dumpArray(fArray) + "," + n5 + ")");
        this.downstreamGL.glProgramLocalParameters4fvEXT(n2, n3, n4, fArray, n5);
        this.println("");
    }

    @Override
    public void glProgramLocalParametersI4ivNV(int n2, int n3, int n4, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glProgramLocalParametersI4ivNV(" + n2 + "," + n3 + "," + n4 + "," + intBuffer + ")");
        this.downstreamGL.glProgramLocalParametersI4ivNV(n2, n3, n4, intBuffer);
        this.println("");
    }

    @Override
    public void glProgramLocalParametersI4ivNV(int n2, int n3, int n4, int[] nArray, int n5) {
        this.printIndent();
        this.print("glProgramLocalParametersI4ivNV(" + n2 + "," + n3 + "," + n4 + "," + this.dumpArray(nArray) + "," + n5 + ")");
        this.downstreamGL.glProgramLocalParametersI4ivNV(n2, n3, n4, nArray, n5);
        this.println("");
    }

    @Override
    public void glProgramLocalParametersI4uivNV(int n2, int n3, int n4, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glProgramLocalParametersI4uivNV(" + n2 + "," + n3 + "," + n4 + "," + intBuffer + ")");
        this.downstreamGL.glProgramLocalParametersI4uivNV(n2, n3, n4, intBuffer);
        this.println("");
    }

    @Override
    public void glProgramLocalParametersI4uivNV(int n2, int n3, int n4, int[] nArray, int n5) {
        this.printIndent();
        this.print("glProgramLocalParametersI4uivNV(" + n2 + "," + n3 + "," + n4 + "," + this.dumpArray(nArray) + "," + n5 + ")");
        this.downstreamGL.glProgramLocalParametersI4uivNV(n2, n3, n4, nArray, n5);
        this.println("");
    }

    @Override
    public void glProgramNamedParameter4dNV(int n2, int n3, String string, double d2, double d3, double d4, double d5) {
        this.printIndent();
        this.print("glProgramNamedParameter4dNV(" + n2 + "," + n3 + "," + string + "," + d2 + "," + d3 + "," + d4 + "," + d5 + ")");
        this.downstreamGL.glProgramNamedParameter4dNV(n2, n3, string, d2, d3, d4, d5);
        this.println("");
    }

    @Override
    public void glProgramNamedParameter4dvNV(int n2, int n3, String string, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glProgramNamedParameter4dvNV(" + n2 + "," + n3 + "," + string + "," + doubleBuffer + ")");
        this.downstreamGL.glProgramNamedParameter4dvNV(n2, n3, string, doubleBuffer);
        this.println("");
    }

    @Override
    public void glProgramNamedParameter4dvNV(int n2, int n3, String string, double[] dArray, int n4) {
        this.printIndent();
        this.print("glProgramNamedParameter4dvNV(" + n2 + "," + n3 + "," + string + "," + this.dumpArray(dArray) + "," + n4 + ")");
        this.downstreamGL.glProgramNamedParameter4dvNV(n2, n3, string, dArray, n4);
        this.println("");
    }

    @Override
    public void glProgramNamedParameter4fNV(int n2, int n3, String string, float f2, float f3, float f4, float f5) {
        this.printIndent();
        this.print("glProgramNamedParameter4fNV(" + n2 + "," + n3 + "," + string + "," + f2 + "," + f3 + "," + f4 + "," + f5 + ")");
        this.downstreamGL.glProgramNamedParameter4fNV(n2, n3, string, f2, f3, f4, f5);
        this.println("");
    }

    @Override
    public void glProgramNamedParameter4fvNV(int n2, int n3, String string, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glProgramNamedParameter4fvNV(" + n2 + "," + n3 + "," + string + "," + floatBuffer + ")");
        this.downstreamGL.glProgramNamedParameter4fvNV(n2, n3, string, floatBuffer);
        this.println("");
    }

    @Override
    public void glProgramNamedParameter4fvNV(int n2, int n3, String string, float[] fArray, int n4) {
        this.printIndent();
        this.print("glProgramNamedParameter4fvNV(" + n2 + "," + n3 + "," + string + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glProgramNamedParameter4fvNV(n2, n3, string, fArray, n4);
        this.println("");
    }

    @Override
    public void glProgramParameter4dNV(int n2, int n3, double d2, double d3, double d4, double d5) {
        this.printIndent();
        this.print("glProgramParameter4dNV(" + n2 + "," + n3 + "," + d2 + "," + d3 + "," + d4 + "," + d5 + ")");
        this.downstreamGL.glProgramParameter4dNV(n2, n3, d2, d3, d4, d5);
        this.println("");
    }

    @Override
    public void glProgramParameter4dvNV(int n2, int n3, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glProgramParameter4dvNV(" + n2 + "," + n3 + "," + doubleBuffer + ")");
        this.downstreamGL.glProgramParameter4dvNV(n2, n3, doubleBuffer);
        this.println("");
    }

    @Override
    public void glProgramParameter4dvNV(int n2, int n3, double[] dArray, int n4) {
        this.printIndent();
        this.print("glProgramParameter4dvNV(" + n2 + "," + n3 + "," + this.dumpArray(dArray) + "," + n4 + ")");
        this.downstreamGL.glProgramParameter4dvNV(n2, n3, dArray, n4);
        this.println("");
    }

    @Override
    public void glProgramParameter4fNV(int n2, int n3, float f2, float f3, float f4, float f5) {
        this.printIndent();
        this.print("glProgramParameter4fNV(" + n2 + "," + n3 + "," + f2 + "," + f3 + "," + f4 + "," + f5 + ")");
        this.downstreamGL.glProgramParameter4fNV(n2, n3, f2, f3, f4, f5);
        this.println("");
    }

    @Override
    public void glProgramParameter4fvNV(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glProgramParameter4fvNV(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glProgramParameter4fvNV(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glProgramParameter4fvNV(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glProgramParameter4fvNV(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glProgramParameter4fvNV(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glProgramParameteriEXT(int n2, int n3, int n4) {
        this.printIndent();
        this.print("glProgramParameteriEXT(" + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glProgramParameteriEXT(n2, n3, n4);
        this.println("");
    }

    @Override
    public void glProgramParameters4dvNV(int n2, int n3, int n4, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glProgramParameters4dvNV(" + n2 + "," + n3 + "," + n4 + "," + doubleBuffer + ")");
        this.downstreamGL.glProgramParameters4dvNV(n2, n3, n4, doubleBuffer);
        this.println("");
    }

    @Override
    public void glProgramParameters4dvNV(int n2, int n3, int n4, double[] dArray, int n5) {
        this.printIndent();
        this.print("glProgramParameters4dvNV(" + n2 + "," + n3 + "," + n4 + "," + this.dumpArray(dArray) + "," + n5 + ")");
        this.downstreamGL.glProgramParameters4dvNV(n2, n3, n4, dArray, n5);
        this.println("");
    }

    @Override
    public void glProgramParameters4fvNV(int n2, int n3, int n4, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glProgramParameters4fvNV(" + n2 + "," + n3 + "," + n4 + "," + floatBuffer + ")");
        this.downstreamGL.glProgramParameters4fvNV(n2, n3, n4, floatBuffer);
        this.println("");
    }

    @Override
    public void glProgramParameters4fvNV(int n2, int n3, int n4, float[] fArray, int n5) {
        this.printIndent();
        this.print("glProgramParameters4fvNV(" + n2 + "," + n3 + "," + n4 + "," + this.dumpArray(fArray) + "," + n5 + ")");
        this.downstreamGL.glProgramParameters4fvNV(n2, n3, n4, fArray, n5);
        this.println("");
    }

    @Override
    public void glProgramStringARB(int n2, int n3, int n4, String string) {
        this.printIndent();
        this.print("glProgramStringARB(" + n2 + "," + n3 + "," + n4 + "," + string + ")");
        this.downstreamGL.glProgramStringARB(n2, n3, n4, string);
        this.println("");
    }

    @Override
    public void glProgramVertexLimitNV(int n2, int n3) {
        this.printIndent();
        this.print("glProgramVertexLimitNV(" + n2 + "," + n3 + ")");
        this.downstreamGL.glProgramVertexLimitNV(n2, n3);
        this.println("");
    }

    @Override
    public void glPushAttrib(int n2) {
        this.printIndent();
        this.print("glPushAttrib(" + n2 + ")");
        this.downstreamGL.glPushAttrib(n2);
        this.println("");
    }

    @Override
    public void glPushClientAttrib(int n2) {
        this.printIndent();
        this.print("glPushClientAttrib(" + n2 + ")");
        this.downstreamGL.glPushClientAttrib(n2);
        this.println("");
    }

    @Override
    public void glPushMatrix() {
        this.printIndent();
        this.print("glPushMatrix()");
        this.downstreamGL.glPushMatrix();
        this.println("");
    }

    @Override
    public void glPushName(int n2) {
        this.printIndent();
        this.print("glPushName(" + n2 + ")");
        this.downstreamGL.glPushName(n2);
        this.println("");
    }

    @Override
    public void glRasterPos2d(double d2, double d3) {
        this.printIndent();
        this.print("glRasterPos2d(" + d2 + "," + d3 + ")");
        this.downstreamGL.glRasterPos2d(d2, d3);
        this.println("");
    }

    @Override
    public void glRasterPos2dv(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glRasterPos2dv(" + doubleBuffer + ")");
        this.downstreamGL.glRasterPos2dv(doubleBuffer);
        this.println("");
    }

    @Override
    public void glRasterPos2dv(double[] dArray, int n2) {
        this.printIndent();
        this.print("glRasterPos2dv(" + this.dumpArray(dArray) + "," + n2 + ")");
        this.downstreamGL.glRasterPos2dv(dArray, n2);
        this.println("");
    }

    @Override
    public void glRasterPos2f(float f2, float f3) {
        this.printIndent();
        this.print("glRasterPos2f(" + f2 + "," + f3 + ")");
        this.downstreamGL.glRasterPos2f(f2, f3);
        this.println("");
    }

    @Override
    public void glRasterPos2fv(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glRasterPos2fv(" + floatBuffer + ")");
        this.downstreamGL.glRasterPos2fv(floatBuffer);
        this.println("");
    }

    @Override
    public void glRasterPos2fv(float[] fArray, int n2) {
        this.printIndent();
        this.print("glRasterPos2fv(" + this.dumpArray(fArray) + "," + n2 + ")");
        this.downstreamGL.glRasterPos2fv(fArray, n2);
        this.println("");
    }

    @Override
    public void glRasterPos2i(int n2, int n3) {
        this.printIndent();
        this.print("glRasterPos2i(" + n2 + "," + n3 + ")");
        this.downstreamGL.glRasterPos2i(n2, n3);
        this.println("");
    }

    @Override
    public void glRasterPos2iv(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glRasterPos2iv(" + intBuffer + ")");
        this.downstreamGL.glRasterPos2iv(intBuffer);
        this.println("");
    }

    @Override
    public void glRasterPos2iv(int[] nArray, int n2) {
        this.printIndent();
        this.print("glRasterPos2iv(" + this.dumpArray(nArray) + "," + n2 + ")");
        this.downstreamGL.glRasterPos2iv(nArray, n2);
        this.println("");
    }

    @Override
    public void glRasterPos2s(short s2, short s3) {
        this.printIndent();
        this.print("glRasterPos2s(" + s2 + "," + s3 + ")");
        this.downstreamGL.glRasterPos2s(s2, s3);
        this.println("");
    }

    @Override
    public void glRasterPos2sv(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glRasterPos2sv(" + shortBuffer + ")");
        this.downstreamGL.glRasterPos2sv(shortBuffer);
        this.println("");
    }

    @Override
    public void glRasterPos2sv(short[] sArray, int n2) {
        this.printIndent();
        this.print("glRasterPos2sv(" + this.dumpArray(sArray) + "," + n2 + ")");
        this.downstreamGL.glRasterPos2sv(sArray, n2);
        this.println("");
    }

    @Override
    public void glRasterPos3d(double d2, double d3, double d4) {
        this.printIndent();
        this.print("glRasterPos3d(" + d2 + "," + d3 + "," + d4 + ")");
        this.downstreamGL.glRasterPos3d(d2, d3, d4);
        this.println("");
    }

    @Override
    public void glRasterPos3dv(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glRasterPos3dv(" + doubleBuffer + ")");
        this.downstreamGL.glRasterPos3dv(doubleBuffer);
        this.println("");
    }

    @Override
    public void glRasterPos3dv(double[] dArray, int n2) {
        this.printIndent();
        this.print("glRasterPos3dv(" + this.dumpArray(dArray) + "," + n2 + ")");
        this.downstreamGL.glRasterPos3dv(dArray, n2);
        this.println("");
    }

    @Override
    public void glRasterPos3f(float f2, float f3, float f4) {
        this.printIndent();
        this.print("glRasterPos3f(" + f2 + "," + f3 + "," + f4 + ")");
        this.downstreamGL.glRasterPos3f(f2, f3, f4);
        this.println("");
    }

    @Override
    public void glRasterPos3fv(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glRasterPos3fv(" + floatBuffer + ")");
        this.downstreamGL.glRasterPos3fv(floatBuffer);
        this.println("");
    }

    @Override
    public void glRasterPos3fv(float[] fArray, int n2) {
        this.printIndent();
        this.print("glRasterPos3fv(" + this.dumpArray(fArray) + "," + n2 + ")");
        this.downstreamGL.glRasterPos3fv(fArray, n2);
        this.println("");
    }

    @Override
    public void glRasterPos3i(int n2, int n3, int n4) {
        this.printIndent();
        this.print("glRasterPos3i(" + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glRasterPos3i(n2, n3, n4);
        this.println("");
    }

    @Override
    public void glRasterPos3iv(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glRasterPos3iv(" + intBuffer + ")");
        this.downstreamGL.glRasterPos3iv(intBuffer);
        this.println("");
    }

    @Override
    public void glRasterPos3iv(int[] nArray, int n2) {
        this.printIndent();
        this.print("glRasterPos3iv(" + this.dumpArray(nArray) + "," + n2 + ")");
        this.downstreamGL.glRasterPos3iv(nArray, n2);
        this.println("");
    }

    @Override
    public void glRasterPos3s(short s2, short s3, short s4) {
        this.printIndent();
        this.print("glRasterPos3s(" + s2 + "," + s3 + "," + s4 + ")");
        this.downstreamGL.glRasterPos3s(s2, s3, s4);
        this.println("");
    }

    @Override
    public void glRasterPos3sv(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glRasterPos3sv(" + shortBuffer + ")");
        this.downstreamGL.glRasterPos3sv(shortBuffer);
        this.println("");
    }

    @Override
    public void glRasterPos3sv(short[] sArray, int n2) {
        this.printIndent();
        this.print("glRasterPos3sv(" + this.dumpArray(sArray) + "," + n2 + ")");
        this.downstreamGL.glRasterPos3sv(sArray, n2);
        this.println("");
    }

    @Override
    public void glRasterPos4d(double d2, double d3, double d4, double d5) {
        this.printIndent();
        this.print("glRasterPos4d(" + d2 + "," + d3 + "," + d4 + "," + d5 + ")");
        this.downstreamGL.glRasterPos4d(d2, d3, d4, d5);
        this.println("");
    }

    @Override
    public void glRasterPos4dv(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glRasterPos4dv(" + doubleBuffer + ")");
        this.downstreamGL.glRasterPos4dv(doubleBuffer);
        this.println("");
    }

    @Override
    public void glRasterPos4dv(double[] dArray, int n2) {
        this.printIndent();
        this.print("glRasterPos4dv(" + this.dumpArray(dArray) + "," + n2 + ")");
        this.downstreamGL.glRasterPos4dv(dArray, n2);
        this.println("");
    }

    @Override
    public void glRasterPos4f(float f2, float f3, float f4, float f5) {
        this.printIndent();
        this.print("glRasterPos4f(" + f2 + "," + f3 + "," + f4 + "," + f5 + ")");
        this.downstreamGL.glRasterPos4f(f2, f3, f4, f5);
        this.println("");
    }

    @Override
    public void glRasterPos4fv(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glRasterPos4fv(" + floatBuffer + ")");
        this.downstreamGL.glRasterPos4fv(floatBuffer);
        this.println("");
    }

    @Override
    public void glRasterPos4fv(float[] fArray, int n2) {
        this.printIndent();
        this.print("glRasterPos4fv(" + this.dumpArray(fArray) + "," + n2 + ")");
        this.downstreamGL.glRasterPos4fv(fArray, n2);
        this.println("");
    }

    @Override
    public void glRasterPos4i(int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glRasterPos4i(" + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glRasterPos4i(n2, n3, n4, n5);
        this.println("");
    }

    @Override
    public void glRasterPos4iv(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glRasterPos4iv(" + intBuffer + ")");
        this.downstreamGL.glRasterPos4iv(intBuffer);
        this.println("");
    }

    @Override
    public void glRasterPos4iv(int[] nArray, int n2) {
        this.printIndent();
        this.print("glRasterPos4iv(" + this.dumpArray(nArray) + "," + n2 + ")");
        this.downstreamGL.glRasterPos4iv(nArray, n2);
        this.println("");
    }

    @Override
    public void glRasterPos4s(short s2, short s3, short s4, short s5) {
        this.printIndent();
        this.print("glRasterPos4s(" + s2 + "," + s3 + "," + s4 + "," + s5 + ")");
        this.downstreamGL.glRasterPos4s(s2, s3, s4, s5);
        this.println("");
    }

    @Override
    public void glRasterPos4sv(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glRasterPos4sv(" + shortBuffer + ")");
        this.downstreamGL.glRasterPos4sv(shortBuffer);
        this.println("");
    }

    @Override
    public void glRasterPos4sv(short[] sArray, int n2) {
        this.printIndent();
        this.print("glRasterPos4sv(" + this.dumpArray(sArray) + "," + n2 + ")");
        this.downstreamGL.glRasterPos4sv(sArray, n2);
        this.println("");
    }

    @Override
    public void glReadBuffer(int n2) {
        this.printIndent();
        this.print("glReadBuffer(" + n2 + ")");
        this.downstreamGL.glReadBuffer(n2);
        this.println("");
    }

    @Override
    public void glReadBufferRegion(int n2, int n3, int n4, int n5, int n6) {
        this.printIndent();
        this.print("glReadBufferRegion(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + ")");
        this.downstreamGL.glReadBufferRegion(n2, n3, n4, n5, n6);
        this.println("");
    }

    @Override
    public void glReadInstrumentsSGIX(int n2) {
        this.printIndent();
        this.print("glReadInstrumentsSGIX(" + n2 + ")");
        this.downstreamGL.glReadInstrumentsSGIX(n2);
        this.println("");
    }

    @Override
    public void glReadPixels(int n2, int n3, int n4, int n5, int n6, int n7, Buffer buffer) {
        this.printIndent();
        this.print("glReadPixels(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + buffer + ")");
        this.downstreamGL.glReadPixels(n2, n3, n4, n5, n6, n7, buffer);
        this.println("");
    }

    @Override
    public void glReadPixels(int n2, int n3, int n4, int n5, int n6, int n7, long l2) {
        this.printIndent();
        this.print("glReadPixels(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + l2 + ")");
        this.downstreamGL.glReadPixels(n2, n3, n4, n5, n6, n7, l2);
        this.println("");
    }

    @Override
    public void glRectd(double d2, double d3, double d4, double d5) {
        this.printIndent();
        this.print("glRectd(" + d2 + "," + d3 + "," + d4 + "," + d5 + ")");
        this.downstreamGL.glRectd(d2, d3, d4, d5);
        this.println("");
    }

    @Override
    public void glRectdv(DoubleBuffer doubleBuffer, DoubleBuffer doubleBuffer2) {
        this.printIndent();
        this.print("glRectdv(" + doubleBuffer + "," + doubleBuffer2 + ")");
        this.downstreamGL.glRectdv(doubleBuffer, doubleBuffer2);
        this.println("");
    }

    @Override
    public void glRectdv(double[] dArray, int n2, double[] dArray2, int n3) {
        this.printIndent();
        this.print("glRectdv(" + this.dumpArray(dArray) + "," + n2 + "," + this.dumpArray(dArray2) + "," + n3 + ")");
        this.downstreamGL.glRectdv(dArray, n2, dArray2, n3);
        this.println("");
    }

    @Override
    public void glRectf(float f2, float f3, float f4, float f5) {
        this.printIndent();
        this.print("glRectf(" + f2 + "," + f3 + "," + f4 + "," + f5 + ")");
        this.downstreamGL.glRectf(f2, f3, f4, f5);
        this.println("");
    }

    @Override
    public void glRectfv(FloatBuffer floatBuffer, FloatBuffer floatBuffer2) {
        this.printIndent();
        this.print("glRectfv(" + floatBuffer + "," + floatBuffer2 + ")");
        this.downstreamGL.glRectfv(floatBuffer, floatBuffer2);
        this.println("");
    }

    @Override
    public void glRectfv(float[] fArray, int n2, float[] fArray2, int n3) {
        this.printIndent();
        this.print("glRectfv(" + this.dumpArray(fArray) + "," + n2 + "," + this.dumpArray(fArray2) + "," + n3 + ")");
        this.downstreamGL.glRectfv(fArray, n2, fArray2, n3);
        this.println("");
    }

    @Override
    public void glRecti(int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glRecti(" + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glRecti(n2, n3, n4, n5);
        this.println("");
    }

    @Override
    public void glRectiv(IntBuffer intBuffer, IntBuffer intBuffer2) {
        this.printIndent();
        this.print("glRectiv(" + intBuffer + "," + intBuffer2 + ")");
        this.downstreamGL.glRectiv(intBuffer, intBuffer2);
        this.println("");
    }

    @Override
    public void glRectiv(int[] nArray, int n2, int[] nArray2, int n3) {
        this.printIndent();
        this.print("glRectiv(" + this.dumpArray(nArray) + "," + n2 + "," + this.dumpArray(nArray2) + "," + n3 + ")");
        this.downstreamGL.glRectiv(nArray, n2, nArray2, n3);
        this.println("");
    }

    @Override
    public void glRects(short s2, short s3, short s4, short s5) {
        this.printIndent();
        this.print("glRects(" + s2 + "," + s3 + "," + s4 + "," + s5 + ")");
        this.downstreamGL.glRects(s2, s3, s4, s5);
        this.println("");
    }

    @Override
    public void glRectsv(ShortBuffer shortBuffer, ShortBuffer shortBuffer2) {
        this.printIndent();
        this.print("glRectsv(" + shortBuffer + "," + shortBuffer2 + ")");
        this.downstreamGL.glRectsv(shortBuffer, shortBuffer2);
        this.println("");
    }

    @Override
    public void glRectsv(short[] sArray, int n2, short[] sArray2, int n3) {
        this.printIndent();
        this.print("glRectsv(" + this.dumpArray(sArray) + "," + n2 + "," + this.dumpArray(sArray2) + "," + n3 + ")");
        this.downstreamGL.glRectsv(sArray, n2, sArray2, n3);
        this.println("");
    }

    @Override
    public void glReferencePlaneSGIX(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glReferencePlaneSGIX(" + doubleBuffer + ")");
        this.downstreamGL.glReferencePlaneSGIX(doubleBuffer);
        this.println("");
    }

    @Override
    public void glReferencePlaneSGIX(double[] dArray, int n2) {
        this.printIndent();
        this.print("glReferencePlaneSGIX(" + this.dumpArray(dArray) + "," + n2 + ")");
        this.downstreamGL.glReferencePlaneSGIX(dArray, n2);
        this.println("");
    }

    @Override
    public int glRenderMode(int n2) {
        this.printIndent();
        this.print("glRenderMode(" + n2 + ")");
        n2 = this.downstreamGL.glRenderMode(n2);
        this.println(" = " + n2);
        return n2;
    }

    @Override
    public void glRenderbufferStorageEXT(int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glRenderbufferStorageEXT(" + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glRenderbufferStorageEXT(n2, n3, n4, n5);
        this.println("");
    }

    @Override
    public void glRenderbufferStorageMultisampleCoverageNV(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.printIndent();
        this.print("glRenderbufferStorageMultisampleCoverageNV(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + ")");
        this.downstreamGL.glRenderbufferStorageMultisampleCoverageNV(n2, n3, n4, n5, n6, n7);
        this.println("");
    }

    @Override
    public void glRenderbufferStorageMultisampleEXT(int n2, int n3, int n4, int n5, int n6) {
        this.printIndent();
        this.print("glRenderbufferStorageMultisampleEXT(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + ")");
        this.downstreamGL.glRenderbufferStorageMultisampleEXT(n2, n3, n4, n5, n6);
        this.println("");
    }

    @Override
    public void glReplacementCodeuiColor3fVertex3fSUN(int n2, float f2, float f3, float f4, float f5, float f6, float f7) {
        this.printIndent();
        this.print("glReplacementCodeuiColor3fVertex3fSUN(" + n2 + "," + f2 + "," + f3 + "," + f4 + "," + f5 + "," + f6 + "," + f7 + ")");
        this.downstreamGL.glReplacementCodeuiColor3fVertex3fSUN(n2, f2, f3, f4, f5, f6, f7);
        this.println("");
    }

    @Override
    public void glReplacementCodeuiColor3fVertex3fvSUN(IntBuffer intBuffer, FloatBuffer floatBuffer, FloatBuffer floatBuffer2) {
        this.printIndent();
        this.print("glReplacementCodeuiColor3fVertex3fvSUN(" + intBuffer + "," + floatBuffer + "," + floatBuffer2 + ")");
        this.downstreamGL.glReplacementCodeuiColor3fVertex3fvSUN(intBuffer, floatBuffer, floatBuffer2);
        this.println("");
    }

    @Override
    public void glReplacementCodeuiColor3fVertex3fvSUN(int[] nArray, int n2, float[] fArray, int n3, float[] fArray2, int n4) {
        this.printIndent();
        this.print("glReplacementCodeuiColor3fVertex3fvSUN(" + this.dumpArray(nArray) + "," + n2 + "," + this.dumpArray(fArray) + "," + n3 + "," + this.dumpArray(fArray2) + "," + n4 + ")");
        this.downstreamGL.glReplacementCodeuiColor3fVertex3fvSUN(nArray, n2, fArray, n3, fArray2, n4);
        this.println("");
    }

    @Override
    public void glReplacementCodeuiColor4fNormal3fVertex3fSUN(int n2, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11) {
        this.printIndent();
        this.print("glReplacementCodeuiColor4fNormal3fVertex3fSUN(" + n2 + "," + f2 + "," + f3 + "," + f4 + "," + f5 + "," + f6 + "," + f7 + "," + f8 + "," + f9 + "," + f10 + "," + f11 + ")");
        this.downstreamGL.glReplacementCodeuiColor4fNormal3fVertex3fSUN(n2, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11);
        this.println("");
    }

    @Override
    public void glReplacementCodeuiColor4fNormal3fVertex3fvSUN(IntBuffer intBuffer, FloatBuffer floatBuffer, FloatBuffer floatBuffer2, FloatBuffer floatBuffer3) {
        this.printIndent();
        this.print("glReplacementCodeuiColor4fNormal3fVertex3fvSUN(" + intBuffer + "," + floatBuffer + "," + floatBuffer2 + "," + floatBuffer3 + ")");
        this.downstreamGL.glReplacementCodeuiColor4fNormal3fVertex3fvSUN(intBuffer, floatBuffer, floatBuffer2, floatBuffer3);
        this.println("");
    }

    @Override
    public void glReplacementCodeuiColor4fNormal3fVertex3fvSUN(int[] nArray, int n2, float[] fArray, int n3, float[] fArray2, int n4, float[] fArray3, int n5) {
        this.printIndent();
        this.print("glReplacementCodeuiColor4fNormal3fVertex3fvSUN(" + this.dumpArray(nArray) + "," + n2 + "," + this.dumpArray(fArray) + "," + n3 + "," + this.dumpArray(fArray2) + "," + n4 + "," + this.dumpArray(fArray3) + "," + n5 + ")");
        this.downstreamGL.glReplacementCodeuiColor4fNormal3fVertex3fvSUN(nArray, n2, fArray, n3, fArray2, n4, fArray3, n5);
        this.println("");
    }

    @Override
    public void glReplacementCodeuiColor4ubVertex3fSUN(int n2, byte by, byte by2, byte by3, byte by4, float f2, float f3, float f4) {
        this.printIndent();
        this.print("glReplacementCodeuiColor4ubVertex3fSUN(" + n2 + "," + by + "," + by2 + "," + by3 + "," + by4 + "," + f2 + "," + f3 + "," + f4 + ")");
        this.downstreamGL.glReplacementCodeuiColor4ubVertex3fSUN(n2, by, by2, by3, by4, f2, f3, f4);
        this.println("");
    }

    @Override
    public void glReplacementCodeuiColor4ubVertex3fvSUN(IntBuffer intBuffer, ByteBuffer byteBuffer, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glReplacementCodeuiColor4ubVertex3fvSUN(" + intBuffer + "," + byteBuffer + "," + floatBuffer + ")");
        this.downstreamGL.glReplacementCodeuiColor4ubVertex3fvSUN(intBuffer, byteBuffer, floatBuffer);
        this.println("");
    }

    @Override
    public void glReplacementCodeuiColor4ubVertex3fvSUN(int[] nArray, int n2, byte[] byArray, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glReplacementCodeuiColor4ubVertex3fvSUN(" + this.dumpArray(nArray) + "," + n2 + "," + this.dumpArray(byArray) + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glReplacementCodeuiColor4ubVertex3fvSUN(nArray, n2, byArray, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glReplacementCodeuiNormal3fVertex3fSUN(int n2, float f2, float f3, float f4, float f5, float f6, float f7) {
        this.printIndent();
        this.print("glReplacementCodeuiNormal3fVertex3fSUN(" + n2 + "," + f2 + "," + f3 + "," + f4 + "," + f5 + "," + f6 + "," + f7 + ")");
        this.downstreamGL.glReplacementCodeuiNormal3fVertex3fSUN(n2, f2, f3, f4, f5, f6, f7);
        this.println("");
    }

    @Override
    public void glReplacementCodeuiNormal3fVertex3fvSUN(IntBuffer intBuffer, FloatBuffer floatBuffer, FloatBuffer floatBuffer2) {
        this.printIndent();
        this.print("glReplacementCodeuiNormal3fVertex3fvSUN(" + intBuffer + "," + floatBuffer + "," + floatBuffer2 + ")");
        this.downstreamGL.glReplacementCodeuiNormal3fVertex3fvSUN(intBuffer, floatBuffer, floatBuffer2);
        this.println("");
    }

    @Override
    public void glReplacementCodeuiNormal3fVertex3fvSUN(int[] nArray, int n2, float[] fArray, int n3, float[] fArray2, int n4) {
        this.printIndent();
        this.print("glReplacementCodeuiNormal3fVertex3fvSUN(" + this.dumpArray(nArray) + "," + n2 + "," + this.dumpArray(fArray) + "," + n3 + "," + this.dumpArray(fArray2) + "," + n4 + ")");
        this.downstreamGL.glReplacementCodeuiNormal3fVertex3fvSUN(nArray, n2, fArray, n3, fArray2, n4);
        this.println("");
    }

    @Override
    public void glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN(int n2, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13) {
        this.printIndent();
        this.print("glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN(" + n2 + "," + f2 + "," + f3 + "," + f4 + "," + f5 + "," + f6 + "," + f7 + "," + f8 + "," + f9 + "," + f10 + "," + f11 + "," + f12 + "," + f13 + ")");
        this.downstreamGL.glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN(n2, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13);
        this.println("");
    }

    @Override
    public void glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN(IntBuffer intBuffer, FloatBuffer floatBuffer, FloatBuffer floatBuffer2, FloatBuffer floatBuffer3, FloatBuffer floatBuffer4) {
        this.printIndent();
        this.print("glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN(" + intBuffer + "," + floatBuffer + "," + floatBuffer2 + "," + floatBuffer3 + "," + floatBuffer4 + ")");
        this.downstreamGL.glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN(intBuffer, floatBuffer, floatBuffer2, floatBuffer3, floatBuffer4);
        this.println("");
    }

    @Override
    public void glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN(int[] nArray, int n2, float[] fArray, int n3, float[] fArray2, int n4, float[] fArray3, int n5, float[] fArray4, int n6) {
        this.printIndent();
        this.print("glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN(" + this.dumpArray(nArray) + "," + n2 + "," + this.dumpArray(fArray) + "," + n3 + "," + this.dumpArray(fArray2) + "," + n4 + "," + this.dumpArray(fArray3) + "," + n5 + "," + this.dumpArray(fArray4) + "," + n6 + ")");
        this.downstreamGL.glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN(nArray, n2, fArray, n3, fArray2, n4, fArray3, n5, fArray4, n6);
        this.println("");
    }

    @Override
    public void glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN(int n2, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.printIndent();
        this.print("glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN(" + n2 + "," + f2 + "," + f3 + "," + f4 + "," + f5 + "," + f6 + "," + f7 + "," + f8 + "," + f9 + ")");
        this.downstreamGL.glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN(n2, f2, f3, f4, f5, f6, f7, f8, f9);
        this.println("");
    }

    @Override
    public void glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN(IntBuffer intBuffer, FloatBuffer floatBuffer, FloatBuffer floatBuffer2, FloatBuffer floatBuffer3) {
        this.printIndent();
        this.print("glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN(" + intBuffer + "," + floatBuffer + "," + floatBuffer2 + "," + floatBuffer3 + ")");
        this.downstreamGL.glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN(intBuffer, floatBuffer, floatBuffer2, floatBuffer3);
        this.println("");
    }

    @Override
    public void glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN(int[] nArray, int n2, float[] fArray, int n3, float[] fArray2, int n4, float[] fArray3, int n5) {
        this.printIndent();
        this.print("glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN(" + this.dumpArray(nArray) + "," + n2 + "," + this.dumpArray(fArray) + "," + n3 + "," + this.dumpArray(fArray2) + "," + n4 + "," + this.dumpArray(fArray3) + "," + n5 + ")");
        this.downstreamGL.glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN(nArray, n2, fArray, n3, fArray2, n4, fArray3, n5);
        this.println("");
    }

    @Override
    public void glReplacementCodeuiTexCoord2fVertex3fSUN(int n2, float f2, float f3, float f4, float f5, float f6) {
        this.printIndent();
        this.print("glReplacementCodeuiTexCoord2fVertex3fSUN(" + n2 + "," + f2 + "," + f3 + "," + f4 + "," + f5 + "," + f6 + ")");
        this.downstreamGL.glReplacementCodeuiTexCoord2fVertex3fSUN(n2, f2, f3, f4, f5, f6);
        this.println("");
    }

    @Override
    public void glReplacementCodeuiTexCoord2fVertex3fvSUN(IntBuffer intBuffer, FloatBuffer floatBuffer, FloatBuffer floatBuffer2) {
        this.printIndent();
        this.print("glReplacementCodeuiTexCoord2fVertex3fvSUN(" + intBuffer + "," + floatBuffer + "," + floatBuffer2 + ")");
        this.downstreamGL.glReplacementCodeuiTexCoord2fVertex3fvSUN(intBuffer, floatBuffer, floatBuffer2);
        this.println("");
    }

    @Override
    public void glReplacementCodeuiTexCoord2fVertex3fvSUN(int[] nArray, int n2, float[] fArray, int n3, float[] fArray2, int n4) {
        this.printIndent();
        this.print("glReplacementCodeuiTexCoord2fVertex3fvSUN(" + this.dumpArray(nArray) + "," + n2 + "," + this.dumpArray(fArray) + "," + n3 + "," + this.dumpArray(fArray2) + "," + n4 + ")");
        this.downstreamGL.glReplacementCodeuiTexCoord2fVertex3fvSUN(nArray, n2, fArray, n3, fArray2, n4);
        this.println("");
    }

    @Override
    public void glReplacementCodeuiVertex3fSUN(int n2, float f2, float f3, float f4) {
        this.printIndent();
        this.print("glReplacementCodeuiVertex3fSUN(" + n2 + "," + f2 + "," + f3 + "," + f4 + ")");
        this.downstreamGL.glReplacementCodeuiVertex3fSUN(n2, f2, f3, f4);
        this.println("");
    }

    @Override
    public void glReplacementCodeuiVertex3fvSUN(IntBuffer intBuffer, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glReplacementCodeuiVertex3fvSUN(" + intBuffer + "," + floatBuffer + ")");
        this.downstreamGL.glReplacementCodeuiVertex3fvSUN(intBuffer, floatBuffer);
        this.println("");
    }

    @Override
    public void glReplacementCodeuiVertex3fvSUN(int[] nArray, int n2, float[] fArray, int n3) {
        this.printIndent();
        this.print("glReplacementCodeuiVertex3fvSUN(" + this.dumpArray(nArray) + "," + n2 + "," + this.dumpArray(fArray) + "," + n3 + ")");
        this.downstreamGL.glReplacementCodeuiVertex3fvSUN(nArray, n2, fArray, n3);
        this.println("");
    }

    @Override
    public void glRequestResidentProgramsNV(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glRequestResidentProgramsNV(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glRequestResidentProgramsNV(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glRequestResidentProgramsNV(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glRequestResidentProgramsNV(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glRequestResidentProgramsNV(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glResetHistogram(int n2) {
        this.printIndent();
        this.print("glResetHistogram(" + n2 + ")");
        this.downstreamGL.glResetHistogram(n2);
        this.println("");
    }

    @Override
    public void glResetMinmax(int n2) {
        this.printIndent();
        this.print("glResetMinmax(" + n2 + ")");
        this.downstreamGL.glResetMinmax(n2);
        this.println("");
    }

    @Override
    public void glResizeBuffersMESA() {
        this.printIndent();
        this.print("glResizeBuffersMESA()");
        this.downstreamGL.glResizeBuffersMESA();
        this.println("");
    }

    @Override
    public void glRotated(double d2, double d3, double d4, double d5) {
        this.printIndent();
        this.print("glRotated(" + d2 + "," + d3 + "," + d4 + "," + d5 + ")");
        this.downstreamGL.glRotated(d2, d3, d4, d5);
        this.println("");
    }

    @Override
    public void glRotatef(float f2, float f3, float f4, float f5) {
        this.printIndent();
        this.print("glRotatef(" + f2 + "," + f3 + "," + f4 + "," + f5 + ")");
        this.downstreamGL.glRotatef(f2, f3, f4, f5);
        this.println("");
    }

    @Override
    public void glSampleCoverage(float f2, boolean bl) {
        this.printIndent();
        this.print("glSampleCoverage(" + f2 + "," + bl + ")");
        this.downstreamGL.glSampleCoverage(f2, bl);
        this.println("");
    }

    @Override
    public void glSampleMapATI(int n2, int n3, int n4) {
        this.printIndent();
        this.print("glSampleMapATI(" + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glSampleMapATI(n2, n3, n4);
        this.println("");
    }

    @Override
    public void glSampleMaskEXT(float f2, boolean bl) {
        this.printIndent();
        this.print("glSampleMaskEXT(" + f2 + "," + bl + ")");
        this.downstreamGL.glSampleMaskEXT(f2, bl);
        this.println("");
    }

    @Override
    public void glSampleMaskSGIS(float f2, boolean bl) {
        this.printIndent();
        this.print("glSampleMaskSGIS(" + f2 + "," + bl + ")");
        this.downstreamGL.glSampleMaskSGIS(f2, bl);
        this.println("");
    }

    @Override
    public void glSamplePatternEXT(int n2) {
        this.printIndent();
        this.print("glSamplePatternEXT(" + n2 + ")");
        this.downstreamGL.glSamplePatternEXT(n2);
        this.println("");
    }

    @Override
    public void glSamplePatternSGIS(int n2) {
        this.printIndent();
        this.print("glSamplePatternSGIS(" + n2 + ")");
        this.downstreamGL.glSamplePatternSGIS(n2);
        this.println("");
    }

    @Override
    public void glScaled(double d2, double d3, double d4) {
        this.printIndent();
        this.print("glScaled(" + d2 + "," + d3 + "," + d4 + ")");
        this.downstreamGL.glScaled(d2, d3, d4);
        this.println("");
    }

    @Override
    public void glScalef(float f2, float f3, float f4) {
        this.printIndent();
        this.print("glScalef(" + f2 + "," + f3 + "," + f4 + ")");
        this.downstreamGL.glScalef(f2, f3, f4);
        this.println("");
    }

    @Override
    public void glScissor(int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glScissor(" + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glScissor(n2, n3, n4, n5);
        this.println("");
    }

    @Override
    public void glSecondaryColor3b(byte by, byte by2, byte by3) {
        this.printIndent();
        this.print("glSecondaryColor3b(" + by + "," + by2 + "," + by3 + ")");
        this.downstreamGL.glSecondaryColor3b(by, by2, by3);
        this.println("");
    }

    @Override
    public void glSecondaryColor3bEXT(byte by, byte by2, byte by3) {
        this.printIndent();
        this.print("glSecondaryColor3bEXT(" + by + "," + by2 + "," + by3 + ")");
        this.downstreamGL.glSecondaryColor3bEXT(by, by2, by3);
        this.println("");
    }

    @Override
    public void glSecondaryColor3bv(ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glSecondaryColor3bv(" + byteBuffer + ")");
        this.downstreamGL.glSecondaryColor3bv(byteBuffer);
        this.println("");
    }

    @Override
    public void glSecondaryColor3bv(byte[] byArray, int n2) {
        this.printIndent();
        this.print("glSecondaryColor3bv(" + this.dumpArray(byArray) + "," + n2 + ")");
        this.downstreamGL.glSecondaryColor3bv(byArray, n2);
        this.println("");
    }

    @Override
    public void glSecondaryColor3bvEXT(ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glSecondaryColor3bvEXT(" + byteBuffer + ")");
        this.downstreamGL.glSecondaryColor3bvEXT(byteBuffer);
        this.println("");
    }

    @Override
    public void glSecondaryColor3bvEXT(byte[] byArray, int n2) {
        this.printIndent();
        this.print("glSecondaryColor3bvEXT(" + this.dumpArray(byArray) + "," + n2 + ")");
        this.downstreamGL.glSecondaryColor3bvEXT(byArray, n2);
        this.println("");
    }

    @Override
    public void glSecondaryColor3d(double d2, double d3, double d4) {
        this.printIndent();
        this.print("glSecondaryColor3d(" + d2 + "," + d3 + "," + d4 + ")");
        this.downstreamGL.glSecondaryColor3d(d2, d3, d4);
        this.println("");
    }

    @Override
    public void glSecondaryColor3dEXT(double d2, double d3, double d4) {
        this.printIndent();
        this.print("glSecondaryColor3dEXT(" + d2 + "," + d3 + "," + d4 + ")");
        this.downstreamGL.glSecondaryColor3dEXT(d2, d3, d4);
        this.println("");
    }

    @Override
    public void glSecondaryColor3dv(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glSecondaryColor3dv(" + doubleBuffer + ")");
        this.downstreamGL.glSecondaryColor3dv(doubleBuffer);
        this.println("");
    }

    @Override
    public void glSecondaryColor3dv(double[] dArray, int n2) {
        this.printIndent();
        this.print("glSecondaryColor3dv(" + this.dumpArray(dArray) + "," + n2 + ")");
        this.downstreamGL.glSecondaryColor3dv(dArray, n2);
        this.println("");
    }

    @Override
    public void glSecondaryColor3dvEXT(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glSecondaryColor3dvEXT(" + doubleBuffer + ")");
        this.downstreamGL.glSecondaryColor3dvEXT(doubleBuffer);
        this.println("");
    }

    @Override
    public void glSecondaryColor3dvEXT(double[] dArray, int n2) {
        this.printIndent();
        this.print("glSecondaryColor3dvEXT(" + this.dumpArray(dArray) + "," + n2 + ")");
        this.downstreamGL.glSecondaryColor3dvEXT(dArray, n2);
        this.println("");
    }

    @Override
    public void glSecondaryColor3f(float f2, float f3, float f4) {
        this.printIndent();
        this.print("glSecondaryColor3f(" + f2 + "," + f3 + "," + f4 + ")");
        this.downstreamGL.glSecondaryColor3f(f2, f3, f4);
        this.println("");
    }

    @Override
    public void glSecondaryColor3fEXT(float f2, float f3, float f4) {
        this.printIndent();
        this.print("glSecondaryColor3fEXT(" + f2 + "," + f3 + "," + f4 + ")");
        this.downstreamGL.glSecondaryColor3fEXT(f2, f3, f4);
        this.println("");
    }

    @Override
    public void glSecondaryColor3fv(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glSecondaryColor3fv(" + floatBuffer + ")");
        this.downstreamGL.glSecondaryColor3fv(floatBuffer);
        this.println("");
    }

    @Override
    public void glSecondaryColor3fv(float[] fArray, int n2) {
        this.printIndent();
        this.print("glSecondaryColor3fv(" + this.dumpArray(fArray) + "," + n2 + ")");
        this.downstreamGL.glSecondaryColor3fv(fArray, n2);
        this.println("");
    }

    @Override
    public void glSecondaryColor3fvEXT(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glSecondaryColor3fvEXT(" + floatBuffer + ")");
        this.downstreamGL.glSecondaryColor3fvEXT(floatBuffer);
        this.println("");
    }

    @Override
    public void glSecondaryColor3fvEXT(float[] fArray, int n2) {
        this.printIndent();
        this.print("glSecondaryColor3fvEXT(" + this.dumpArray(fArray) + "," + n2 + ")");
        this.downstreamGL.glSecondaryColor3fvEXT(fArray, n2);
        this.println("");
    }

    @Override
    public void glSecondaryColor3hNV(short s2, short s3, short s4) {
        this.printIndent();
        this.print("glSecondaryColor3hNV(" + s2 + "," + s3 + "," + s4 + ")");
        this.downstreamGL.glSecondaryColor3hNV(s2, s3, s4);
        this.println("");
    }

    @Override
    public void glSecondaryColor3hvNV(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glSecondaryColor3hvNV(" + shortBuffer + ")");
        this.downstreamGL.glSecondaryColor3hvNV(shortBuffer);
        this.println("");
    }

    @Override
    public void glSecondaryColor3hvNV(short[] sArray, int n2) {
        this.printIndent();
        this.print("glSecondaryColor3hvNV(" + this.dumpArray(sArray) + "," + n2 + ")");
        this.downstreamGL.glSecondaryColor3hvNV(sArray, n2);
        this.println("");
    }

    @Override
    public void glSecondaryColor3i(int n2, int n3, int n4) {
        this.printIndent();
        this.print("glSecondaryColor3i(" + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glSecondaryColor3i(n2, n3, n4);
        this.println("");
    }

    @Override
    public void glSecondaryColor3iEXT(int n2, int n3, int n4) {
        this.printIndent();
        this.print("glSecondaryColor3iEXT(" + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glSecondaryColor3iEXT(n2, n3, n4);
        this.println("");
    }

    @Override
    public void glSecondaryColor3iv(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glSecondaryColor3iv(" + intBuffer + ")");
        this.downstreamGL.glSecondaryColor3iv(intBuffer);
        this.println("");
    }

    @Override
    public void glSecondaryColor3iv(int[] nArray, int n2) {
        this.printIndent();
        this.print("glSecondaryColor3iv(" + this.dumpArray(nArray) + "," + n2 + ")");
        this.downstreamGL.glSecondaryColor3iv(nArray, n2);
        this.println("");
    }

    @Override
    public void glSecondaryColor3ivEXT(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glSecondaryColor3ivEXT(" + intBuffer + ")");
        this.downstreamGL.glSecondaryColor3ivEXT(intBuffer);
        this.println("");
    }

    @Override
    public void glSecondaryColor3ivEXT(int[] nArray, int n2) {
        this.printIndent();
        this.print("glSecondaryColor3ivEXT(" + this.dumpArray(nArray) + "," + n2 + ")");
        this.downstreamGL.glSecondaryColor3ivEXT(nArray, n2);
        this.println("");
    }

    @Override
    public void glSecondaryColor3s(short s2, short s3, short s4) {
        this.printIndent();
        this.print("glSecondaryColor3s(" + s2 + "," + s3 + "," + s4 + ")");
        this.downstreamGL.glSecondaryColor3s(s2, s3, s4);
        this.println("");
    }

    @Override
    public void glSecondaryColor3sEXT(short s2, short s3, short s4) {
        this.printIndent();
        this.print("glSecondaryColor3sEXT(" + s2 + "," + s3 + "," + s4 + ")");
        this.downstreamGL.glSecondaryColor3sEXT(s2, s3, s4);
        this.println("");
    }

    @Override
    public void glSecondaryColor3sv(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glSecondaryColor3sv(" + shortBuffer + ")");
        this.downstreamGL.glSecondaryColor3sv(shortBuffer);
        this.println("");
    }

    @Override
    public void glSecondaryColor3sv(short[] sArray, int n2) {
        this.printIndent();
        this.print("glSecondaryColor3sv(" + this.dumpArray(sArray) + "," + n2 + ")");
        this.downstreamGL.glSecondaryColor3sv(sArray, n2);
        this.println("");
    }

    @Override
    public void glSecondaryColor3svEXT(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glSecondaryColor3svEXT(" + shortBuffer + ")");
        this.downstreamGL.glSecondaryColor3svEXT(shortBuffer);
        this.println("");
    }

    @Override
    public void glSecondaryColor3svEXT(short[] sArray, int n2) {
        this.printIndent();
        this.print("glSecondaryColor3svEXT(" + this.dumpArray(sArray) + "," + n2 + ")");
        this.downstreamGL.glSecondaryColor3svEXT(sArray, n2);
        this.println("");
    }

    @Override
    public void glSecondaryColor3ub(byte by, byte by2, byte by3) {
        this.printIndent();
        this.print("glSecondaryColor3ub(" + by + "," + by2 + "," + by3 + ")");
        this.downstreamGL.glSecondaryColor3ub(by, by2, by3);
        this.println("");
    }

    @Override
    public void glSecondaryColor3ubEXT(byte by, byte by2, byte by3) {
        this.printIndent();
        this.print("glSecondaryColor3ubEXT(" + by + "," + by2 + "," + by3 + ")");
        this.downstreamGL.glSecondaryColor3ubEXT(by, by2, by3);
        this.println("");
    }

    @Override
    public void glSecondaryColor3ubv(ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glSecondaryColor3ubv(" + byteBuffer + ")");
        this.downstreamGL.glSecondaryColor3ubv(byteBuffer);
        this.println("");
    }

    @Override
    public void glSecondaryColor3ubv(byte[] byArray, int n2) {
        this.printIndent();
        this.print("glSecondaryColor3ubv(" + this.dumpArray(byArray) + "," + n2 + ")");
        this.downstreamGL.glSecondaryColor3ubv(byArray, n2);
        this.println("");
    }

    @Override
    public void glSecondaryColor3ubvEXT(ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glSecondaryColor3ubvEXT(" + byteBuffer + ")");
        this.downstreamGL.glSecondaryColor3ubvEXT(byteBuffer);
        this.println("");
    }

    @Override
    public void glSecondaryColor3ubvEXT(byte[] byArray, int n2) {
        this.printIndent();
        this.print("glSecondaryColor3ubvEXT(" + this.dumpArray(byArray) + "," + n2 + ")");
        this.downstreamGL.glSecondaryColor3ubvEXT(byArray, n2);
        this.println("");
    }

    @Override
    public void glSecondaryColor3ui(int n2, int n3, int n4) {
        this.printIndent();
        this.print("glSecondaryColor3ui(" + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glSecondaryColor3ui(n2, n3, n4);
        this.println("");
    }

    @Override
    public void glSecondaryColor3uiEXT(int n2, int n3, int n4) {
        this.printIndent();
        this.print("glSecondaryColor3uiEXT(" + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glSecondaryColor3uiEXT(n2, n3, n4);
        this.println("");
    }

    @Override
    public void glSecondaryColor3uiv(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glSecondaryColor3uiv(" + intBuffer + ")");
        this.downstreamGL.glSecondaryColor3uiv(intBuffer);
        this.println("");
    }

    @Override
    public void glSecondaryColor3uiv(int[] nArray, int n2) {
        this.printIndent();
        this.print("glSecondaryColor3uiv(" + this.dumpArray(nArray) + "," + n2 + ")");
        this.downstreamGL.glSecondaryColor3uiv(nArray, n2);
        this.println("");
    }

    @Override
    public void glSecondaryColor3uivEXT(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glSecondaryColor3uivEXT(" + intBuffer + ")");
        this.downstreamGL.glSecondaryColor3uivEXT(intBuffer);
        this.println("");
    }

    @Override
    public void glSecondaryColor3uivEXT(int[] nArray, int n2) {
        this.printIndent();
        this.print("glSecondaryColor3uivEXT(" + this.dumpArray(nArray) + "," + n2 + ")");
        this.downstreamGL.glSecondaryColor3uivEXT(nArray, n2);
        this.println("");
    }

    @Override
    public void glSecondaryColor3us(short s2, short s3, short s4) {
        this.printIndent();
        this.print("glSecondaryColor3us(" + s2 + "," + s3 + "," + s4 + ")");
        this.downstreamGL.glSecondaryColor3us(s2, s3, s4);
        this.println("");
    }

    @Override
    public void glSecondaryColor3usEXT(short s2, short s3, short s4) {
        this.printIndent();
        this.print("glSecondaryColor3usEXT(" + s2 + "," + s3 + "," + s4 + ")");
        this.downstreamGL.glSecondaryColor3usEXT(s2, s3, s4);
        this.println("");
    }

    @Override
    public void glSecondaryColor3usv(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glSecondaryColor3usv(" + shortBuffer + ")");
        this.downstreamGL.glSecondaryColor3usv(shortBuffer);
        this.println("");
    }

    @Override
    public void glSecondaryColor3usv(short[] sArray, int n2) {
        this.printIndent();
        this.print("glSecondaryColor3usv(" + this.dumpArray(sArray) + "," + n2 + ")");
        this.downstreamGL.glSecondaryColor3usv(sArray, n2);
        this.println("");
    }

    @Override
    public void glSecondaryColor3usvEXT(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glSecondaryColor3usvEXT(" + shortBuffer + ")");
        this.downstreamGL.glSecondaryColor3usvEXT(shortBuffer);
        this.println("");
    }

    @Override
    public void glSecondaryColor3usvEXT(short[] sArray, int n2) {
        this.printIndent();
        this.print("glSecondaryColor3usvEXT(" + this.dumpArray(sArray) + "," + n2 + ")");
        this.downstreamGL.glSecondaryColor3usvEXT(sArray, n2);
        this.println("");
    }

    @Override
    public void glSecondaryColorPointer(int n2, int n3, int n4, Buffer buffer) {
        this.printIndent();
        this.print("glSecondaryColorPointer(" + n2 + "," + n3 + "," + n4 + "," + buffer + ")");
        this.downstreamGL.glSecondaryColorPointer(n2, n3, n4, buffer);
        this.println("");
    }

    @Override
    public void glSecondaryColorPointer(int n2, int n3, int n4, long l2) {
        this.printIndent();
        this.print("glSecondaryColorPointer(" + n2 + "," + n3 + "," + n4 + "," + l2 + ")");
        this.downstreamGL.glSecondaryColorPointer(n2, n3, n4, l2);
        this.println("");
    }

    @Override
    public void glSecondaryColorPointerEXT(int n2, int n3, int n4, Buffer buffer) {
        this.printIndent();
        this.print("glSecondaryColorPointerEXT(" + n2 + "," + n3 + "," + n4 + "," + buffer + ")");
        this.downstreamGL.glSecondaryColorPointerEXT(n2, n3, n4, buffer);
        this.println("");
    }

    @Override
    public void glSecondaryColorPointerEXT(int n2, int n3, int n4, long l2) {
        this.printIndent();
        this.print("glSecondaryColorPointerEXT(" + n2 + "," + n3 + "," + n4 + "," + l2 + ")");
        this.downstreamGL.glSecondaryColorPointerEXT(n2, n3, n4, l2);
        this.println("");
    }

    @Override
    public void glSelectBuffer(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glSelectBuffer(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glSelectBuffer(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glSeparableFilter2D(int n2, int n3, int n4, int n5, int n6, int n7, Buffer buffer, Buffer buffer2) {
        this.printIndent();
        this.print("glSeparableFilter2D(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + buffer + "," + buffer2 + ")");
        this.downstreamGL.glSeparableFilter2D(n2, n3, n4, n5, n6, n7, buffer, buffer2);
        this.println("");
    }

    @Override
    public void glSeparableFilter2D(int n2, int n3, int n4, int n5, int n6, int n7, long l2, long l3) {
        this.printIndent();
        this.print("glSeparableFilter2D(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + l2 + "," + l3 + ")");
        this.downstreamGL.glSeparableFilter2D(n2, n3, n4, n5, n6, n7, l2, l3);
        this.println("");
    }

    @Override
    public void glSetFenceAPPLE(int n2) {
        this.printIndent();
        this.print("glSetFenceAPPLE(" + n2 + ")");
        this.downstreamGL.glSetFenceAPPLE(n2);
        this.println("");
    }

    @Override
    public void glSetFenceNV(int n2, int n3) {
        this.printIndent();
        this.print("glSetFenceNV(" + n2 + "," + n3 + ")");
        this.downstreamGL.glSetFenceNV(n2, n3);
        this.println("");
    }

    @Override
    public void glSetFragmentShaderConstantATI(int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glSetFragmentShaderConstantATI(" + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glSetFragmentShaderConstantATI(n2, floatBuffer);
        this.println("");
    }

    @Override
    public void glSetFragmentShaderConstantATI(int n2, float[] fArray, int n3) {
        this.printIndent();
        this.print("glSetFragmentShaderConstantATI(" + n2 + "," + this.dumpArray(fArray) + "," + n3 + ")");
        this.downstreamGL.glSetFragmentShaderConstantATI(n2, fArray, n3);
        this.println("");
    }

    @Override
    public void glSetInvariantEXT(int n2, int n3, Buffer buffer) {
        this.printIndent();
        this.print("glSetInvariantEXT(" + n2 + "," + n3 + "," + buffer + ")");
        this.downstreamGL.glSetInvariantEXT(n2, n3, buffer);
        this.println("");
    }

    @Override
    public void glSetLocalConstantEXT(int n2, int n3, Buffer buffer) {
        this.printIndent();
        this.print("glSetLocalConstantEXT(" + n2 + "," + n3 + "," + buffer + ")");
        this.downstreamGL.glSetLocalConstantEXT(n2, n3, buffer);
        this.println("");
    }

    @Override
    public void glShadeModel(int n2) {
        this.printIndent();
        this.print("glShadeModel(" + n2 + ")");
        this.downstreamGL.glShadeModel(n2);
        this.println("");
    }

    @Override
    public void glShaderOp1EXT(int n2, int n3, int n4) {
        this.printIndent();
        this.print("glShaderOp1EXT(" + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glShaderOp1EXT(n2, n3, n4);
        this.println("");
    }

    @Override
    public void glShaderOp2EXT(int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glShaderOp2EXT(" + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glShaderOp2EXT(n2, n3, n4, n5);
        this.println("");
    }

    @Override
    public void glShaderOp3EXT(int n2, int n3, int n4, int n5, int n6) {
        this.printIndent();
        this.print("glShaderOp3EXT(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + ")");
        this.downstreamGL.glShaderOp3EXT(n2, n3, n4, n5, n6);
        this.println("");
    }

    @Override
    public void glShaderSource(int n2, int n3, String[] stringArray, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glShaderSource(" + n2 + "," + n3 + "," + this.dumpArray(stringArray) + "," + intBuffer + ")");
        this.downstreamGL.glShaderSource(n2, n3, stringArray, intBuffer);
        this.println("");
    }

    @Override
    public void glShaderSource(int n2, int n3, String[] stringArray, int[] nArray, int n4) {
        this.printIndent();
        this.print("glShaderSource(" + n2 + "," + n3 + "," + this.dumpArray(stringArray) + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glShaderSource(n2, n3, stringArray, nArray, n4);
        this.println("");
    }

    @Override
    public void glShaderSourceARB(int n2, int n3, String[] stringArray, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glShaderSourceARB(" + n2 + "," + n3 + "," + this.dumpArray(stringArray) + "," + intBuffer + ")");
        this.downstreamGL.glShaderSourceARB(n2, n3, stringArray, intBuffer);
        this.println("");
    }

    @Override
    public void glShaderSourceARB(int n2, int n3, String[] stringArray, int[] nArray, int n4) {
        this.printIndent();
        this.print("glShaderSourceARB(" + n2 + "," + n3 + "," + this.dumpArray(stringArray) + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glShaderSourceARB(n2, n3, stringArray, nArray, n4);
        this.println("");
    }

    @Override
    public void glSharpenTexFuncSGIS(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glSharpenTexFuncSGIS(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glSharpenTexFuncSGIS(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glSharpenTexFuncSGIS(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glSharpenTexFuncSGIS(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glSharpenTexFuncSGIS(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glSpriteParameterfSGIX(int n2, float f2) {
        this.printIndent();
        this.print("glSpriteParameterfSGIX(" + n2 + "," + f2 + ")");
        this.downstreamGL.glSpriteParameterfSGIX(n2, f2);
        this.println("");
    }

    @Override
    public void glSpriteParameterfvSGIX(int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glSpriteParameterfvSGIX(" + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glSpriteParameterfvSGIX(n2, floatBuffer);
        this.println("");
    }

    @Override
    public void glSpriteParameterfvSGIX(int n2, float[] fArray, int n3) {
        this.printIndent();
        this.print("glSpriteParameterfvSGIX(" + n2 + "," + this.dumpArray(fArray) + "," + n3 + ")");
        this.downstreamGL.glSpriteParameterfvSGIX(n2, fArray, n3);
        this.println("");
    }

    @Override
    public void glSpriteParameteriSGIX(int n2, int n3) {
        this.printIndent();
        this.print("glSpriteParameteriSGIX(" + n2 + "," + n3 + ")");
        this.downstreamGL.glSpriteParameteriSGIX(n2, n3);
        this.println("");
    }

    @Override
    public void glSpriteParameterivSGIX(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glSpriteParameterivSGIX(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glSpriteParameterivSGIX(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glSpriteParameterivSGIX(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glSpriteParameterivSGIX(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glSpriteParameterivSGIX(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glStartInstrumentsSGIX() {
        this.printIndent();
        this.print("glStartInstrumentsSGIX()");
        this.downstreamGL.glStartInstrumentsSGIX();
        this.println("");
    }

    @Override
    public void glStencilClearTagEXT(int n2, int n3) {
        this.printIndent();
        this.print("glStencilClearTagEXT(" + n2 + "," + n3 + ")");
        this.downstreamGL.glStencilClearTagEXT(n2, n3);
        this.println("");
    }

    @Override
    public void glStencilFunc(int n2, int n3, int n4) {
        this.printIndent();
        this.print("glStencilFunc(" + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glStencilFunc(n2, n3, n4);
        this.println("");
    }

    @Override
    public void glStencilFuncSeparate(int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glStencilFuncSeparate(" + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glStencilFuncSeparate(n2, n3, n4, n5);
        this.println("");
    }

    @Override
    public void glStencilFuncSeparateATI(int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glStencilFuncSeparateATI(" + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glStencilFuncSeparateATI(n2, n3, n4, n5);
        this.println("");
    }

    @Override
    public void glStencilMask(int n2) {
        this.printIndent();
        this.print("glStencilMask(" + n2 + ")");
        this.downstreamGL.glStencilMask(n2);
        this.println("");
    }

    @Override
    public void glStencilMaskSeparate(int n2, int n3) {
        this.printIndent();
        this.print("glStencilMaskSeparate(" + n2 + "," + n3 + ")");
        this.downstreamGL.glStencilMaskSeparate(n2, n3);
        this.println("");
    }

    @Override
    public void glStencilOp(int n2, int n3, int n4) {
        this.printIndent();
        this.print("glStencilOp(" + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glStencilOp(n2, n3, n4);
        this.println("");
    }

    @Override
    public void glStencilOpSeparate(int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glStencilOpSeparate(" + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glStencilOpSeparate(n2, n3, n4, n5);
        this.println("");
    }

    @Override
    public void glStencilOpSeparateATI(int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glStencilOpSeparateATI(" + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glStencilOpSeparateATI(n2, n3, n4, n5);
        this.println("");
    }

    @Override
    public void glStopInstrumentsSGIX(int n2) {
        this.printIndent();
        this.print("glStopInstrumentsSGIX(" + n2 + ")");
        this.downstreamGL.glStopInstrumentsSGIX(n2);
        this.println("");
    }

    @Override
    public void glStringMarkerGREMEDY(int n2, Buffer buffer) {
        this.printIndent();
        this.print("glStringMarkerGREMEDY(" + n2 + "," + buffer + ")");
        this.downstreamGL.glStringMarkerGREMEDY(n2, buffer);
        this.println("");
    }

    @Override
    public void glSwapAPPLE() {
        this.printIndent();
        this.print("glSwapAPPLE()");
        this.downstreamGL.glSwapAPPLE();
        this.println("");
    }

    @Override
    public void glSwizzleEXT(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.printIndent();
        this.print("glSwizzleEXT(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + ")");
        this.downstreamGL.glSwizzleEXT(n2, n3, n4, n5, n6, n7);
        this.println("");
    }

    @Override
    public void glTagSampleBufferSGIX() {
        this.printIndent();
        this.print("glTagSampleBufferSGIX()");
        this.downstreamGL.glTagSampleBufferSGIX();
        this.println("");
    }

    @Override
    public void glTbufferMask3DFX(int n2) {
        this.printIndent();
        this.print("glTbufferMask3DFX(" + n2 + ")");
        this.downstreamGL.glTbufferMask3DFX(n2);
        this.println("");
    }

    @Override
    public boolean glTestFenceAPPLE(int n2) {
        this.printIndent();
        this.print("glTestFenceAPPLE(" + n2 + ")");
        n2 = this.downstreamGL.glTestFenceAPPLE(n2) ? 1 : 0;
        this.println(" = " + (n2 != 0));
        return n2 != 0;
    }

    @Override
    public boolean glTestFenceNV(int n2) {
        this.printIndent();
        this.print("glTestFenceNV(" + n2 + ")");
        n2 = this.downstreamGL.glTestFenceNV(n2) ? 1 : 0;
        this.println(" = " + (n2 != 0));
        return n2 != 0;
    }

    @Override
    public boolean glTestObjectAPPLE(int n2, int n3) {
        this.printIndent();
        this.print("glTestObjectAPPLE(" + n2 + "," + n3 + ")");
        n2 = this.downstreamGL.glTestObjectAPPLE(n2, n3) ? 1 : 0;
        this.println(" = " + (n2 != 0));
        return n2 != 0;
    }

    @Override
    public void glTexBufferEXT(int n2, int n3, int n4) {
        this.printIndent();
        this.print("glTexBufferEXT(" + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glTexBufferEXT(n2, n3, n4);
        this.println("");
    }

    @Override
    public void glTexBumpParameterfvATI(int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glTexBumpParameterfvATI(" + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glTexBumpParameterfvATI(n2, floatBuffer);
        this.println("");
    }

    @Override
    public void glTexBumpParameterfvATI(int n2, float[] fArray, int n3) {
        this.printIndent();
        this.print("glTexBumpParameterfvATI(" + n2 + "," + this.dumpArray(fArray) + "," + n3 + ")");
        this.downstreamGL.glTexBumpParameterfvATI(n2, fArray, n3);
        this.println("");
    }

    @Override
    public void glTexBumpParameterivATI(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glTexBumpParameterivATI(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glTexBumpParameterivATI(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glTexBumpParameterivATI(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glTexBumpParameterivATI(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glTexBumpParameterivATI(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glTexCoord1d(double d2) {
        this.printIndent();
        this.print("glTexCoord1d(" + d2 + ")");
        this.downstreamGL.glTexCoord1d(d2);
        this.println("");
    }

    @Override
    public void glTexCoord1dv(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glTexCoord1dv(" + doubleBuffer + ")");
        this.downstreamGL.glTexCoord1dv(doubleBuffer);
        this.println("");
    }

    @Override
    public void glTexCoord1dv(double[] dArray, int n2) {
        this.printIndent();
        this.print("glTexCoord1dv(" + this.dumpArray(dArray) + "," + n2 + ")");
        this.downstreamGL.glTexCoord1dv(dArray, n2);
        this.println("");
    }

    @Override
    public void glTexCoord1f(float f2) {
        this.printIndent();
        this.print("glTexCoord1f(" + f2 + ")");
        this.downstreamGL.glTexCoord1f(f2);
        this.println("");
    }

    @Override
    public void glTexCoord1fv(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glTexCoord1fv(" + floatBuffer + ")");
        this.downstreamGL.glTexCoord1fv(floatBuffer);
        this.println("");
    }

    @Override
    public void glTexCoord1fv(float[] fArray, int n2) {
        this.printIndent();
        this.print("glTexCoord1fv(" + this.dumpArray(fArray) + "," + n2 + ")");
        this.downstreamGL.glTexCoord1fv(fArray, n2);
        this.println("");
    }

    @Override
    public void glTexCoord1hNV(short s2) {
        this.printIndent();
        this.print("glTexCoord1hNV(" + s2 + ")");
        this.downstreamGL.glTexCoord1hNV(s2);
        this.println("");
    }

    @Override
    public void glTexCoord1hvNV(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glTexCoord1hvNV(" + shortBuffer + ")");
        this.downstreamGL.glTexCoord1hvNV(shortBuffer);
        this.println("");
    }

    @Override
    public void glTexCoord1hvNV(short[] sArray, int n2) {
        this.printIndent();
        this.print("glTexCoord1hvNV(" + this.dumpArray(sArray) + "," + n2 + ")");
        this.downstreamGL.glTexCoord1hvNV(sArray, n2);
        this.println("");
    }

    @Override
    public void glTexCoord1i(int n2) {
        this.printIndent();
        this.print("glTexCoord1i(" + n2 + ")");
        this.downstreamGL.glTexCoord1i(n2);
        this.println("");
    }

    @Override
    public void glTexCoord1iv(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glTexCoord1iv(" + intBuffer + ")");
        this.downstreamGL.glTexCoord1iv(intBuffer);
        this.println("");
    }

    @Override
    public void glTexCoord1iv(int[] nArray, int n2) {
        this.printIndent();
        this.print("glTexCoord1iv(" + this.dumpArray(nArray) + "," + n2 + ")");
        this.downstreamGL.glTexCoord1iv(nArray, n2);
        this.println("");
    }

    @Override
    public void glTexCoord1s(short s2) {
        this.printIndent();
        this.print("glTexCoord1s(" + s2 + ")");
        this.downstreamGL.glTexCoord1s(s2);
        this.println("");
    }

    @Override
    public void glTexCoord1sv(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glTexCoord1sv(" + shortBuffer + ")");
        this.downstreamGL.glTexCoord1sv(shortBuffer);
        this.println("");
    }

    @Override
    public void glTexCoord1sv(short[] sArray, int n2) {
        this.printIndent();
        this.print("glTexCoord1sv(" + this.dumpArray(sArray) + "," + n2 + ")");
        this.downstreamGL.glTexCoord1sv(sArray, n2);
        this.println("");
    }

    @Override
    public void glTexCoord2d(double d2, double d3) {
        this.printIndent();
        this.print("glTexCoord2d(" + d2 + "," + d3 + ")");
        this.downstreamGL.glTexCoord2d(d2, d3);
        this.println("");
    }

    @Override
    public void glTexCoord2dv(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glTexCoord2dv(" + doubleBuffer + ")");
        this.downstreamGL.glTexCoord2dv(doubleBuffer);
        this.println("");
    }

    @Override
    public void glTexCoord2dv(double[] dArray, int n2) {
        this.printIndent();
        this.print("glTexCoord2dv(" + this.dumpArray(dArray) + "," + n2 + ")");
        this.downstreamGL.glTexCoord2dv(dArray, n2);
        this.println("");
    }

    @Override
    public void glTexCoord2f(float f2, float f3) {
        this.printIndent();
        this.print("glTexCoord2f(" + f2 + "," + f3 + ")");
        this.downstreamGL.glTexCoord2f(f2, f3);
        this.println("");
    }

    @Override
    public void glTexCoord2fColor3fVertex3fSUN(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.printIndent();
        this.print("glTexCoord2fColor3fVertex3fSUN(" + f2 + "," + f3 + "," + f4 + "," + f5 + "," + f6 + "," + f7 + "," + f8 + "," + f9 + ")");
        this.downstreamGL.glTexCoord2fColor3fVertex3fSUN(f2, f3, f4, f5, f6, f7, f8, f9);
        this.println("");
    }

    @Override
    public void glTexCoord2fColor3fVertex3fvSUN(FloatBuffer floatBuffer, FloatBuffer floatBuffer2, FloatBuffer floatBuffer3) {
        this.printIndent();
        this.print("glTexCoord2fColor3fVertex3fvSUN(" + floatBuffer + "," + floatBuffer2 + "," + floatBuffer3 + ")");
        this.downstreamGL.glTexCoord2fColor3fVertex3fvSUN(floatBuffer, floatBuffer2, floatBuffer3);
        this.println("");
    }

    @Override
    public void glTexCoord2fColor3fVertex3fvSUN(float[] fArray, int n2, float[] fArray2, int n3, float[] fArray3, int n4) {
        this.printIndent();
        this.print("glTexCoord2fColor3fVertex3fvSUN(" + this.dumpArray(fArray) + "," + n2 + "," + this.dumpArray(fArray2) + "," + n3 + "," + this.dumpArray(fArray3) + "," + n4 + ")");
        this.downstreamGL.glTexCoord2fColor3fVertex3fvSUN(fArray, n2, fArray2, n3, fArray3, n4);
        this.println("");
    }

    @Override
    public void glTexCoord2fColor4fNormal3fVertex3fSUN(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13) {
        this.printIndent();
        this.print("glTexCoord2fColor4fNormal3fVertex3fSUN(" + f2 + "," + f3 + "," + f4 + "," + f5 + "," + f6 + "," + f7 + "," + f8 + "," + f9 + "," + f10 + "," + f11 + "," + f12 + "," + f13 + ")");
        this.downstreamGL.glTexCoord2fColor4fNormal3fVertex3fSUN(f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13);
        this.println("");
    }

    @Override
    public void glTexCoord2fColor4fNormal3fVertex3fvSUN(FloatBuffer floatBuffer, FloatBuffer floatBuffer2, FloatBuffer floatBuffer3, FloatBuffer floatBuffer4) {
        this.printIndent();
        this.print("glTexCoord2fColor4fNormal3fVertex3fvSUN(" + floatBuffer + "," + floatBuffer2 + "," + floatBuffer3 + "," + floatBuffer4 + ")");
        this.downstreamGL.glTexCoord2fColor4fNormal3fVertex3fvSUN(floatBuffer, floatBuffer2, floatBuffer3, floatBuffer4);
        this.println("");
    }

    @Override
    public void glTexCoord2fColor4fNormal3fVertex3fvSUN(float[] fArray, int n2, float[] fArray2, int n3, float[] fArray3, int n4, float[] fArray4, int n5) {
        this.printIndent();
        this.print("glTexCoord2fColor4fNormal3fVertex3fvSUN(" + this.dumpArray(fArray) + "," + n2 + "," + this.dumpArray(fArray2) + "," + n3 + "," + this.dumpArray(fArray3) + "," + n4 + "," + this.dumpArray(fArray4) + "," + n5 + ")");
        this.downstreamGL.glTexCoord2fColor4fNormal3fVertex3fvSUN(fArray, n2, fArray2, n3, fArray3, n4, fArray4, n5);
        this.println("");
    }

    @Override
    public void glTexCoord2fColor4ubVertex3fSUN(float f2, float f3, byte by, byte by2, byte by3, byte by4, float f4, float f5, float f6) {
        this.printIndent();
        this.print("glTexCoord2fColor4ubVertex3fSUN(" + f2 + "," + f3 + "," + by + "," + by2 + "," + by3 + "," + by4 + "," + f4 + "," + f5 + "," + f6 + ")");
        this.downstreamGL.glTexCoord2fColor4ubVertex3fSUN(f2, f3, by, by2, by3, by4, f4, f5, f6);
        this.println("");
    }

    @Override
    public void glTexCoord2fColor4ubVertex3fvSUN(FloatBuffer floatBuffer, ByteBuffer byteBuffer, FloatBuffer floatBuffer2) {
        this.printIndent();
        this.print("glTexCoord2fColor4ubVertex3fvSUN(" + floatBuffer + "," + byteBuffer + "," + floatBuffer2 + ")");
        this.downstreamGL.glTexCoord2fColor4ubVertex3fvSUN(floatBuffer, byteBuffer, floatBuffer2);
        this.println("");
    }

    @Override
    public void glTexCoord2fColor4ubVertex3fvSUN(float[] fArray, int n2, byte[] byArray, int n3, float[] fArray2, int n4) {
        this.printIndent();
        this.print("glTexCoord2fColor4ubVertex3fvSUN(" + this.dumpArray(fArray) + "," + n2 + "," + this.dumpArray(byArray) + "," + n3 + "," + this.dumpArray(fArray2) + "," + n4 + ")");
        this.downstreamGL.glTexCoord2fColor4ubVertex3fvSUN(fArray, n2, byArray, n3, fArray2, n4);
        this.println("");
    }

    @Override
    public void glTexCoord2fNormal3fVertex3fSUN(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.printIndent();
        this.print("glTexCoord2fNormal3fVertex3fSUN(" + f2 + "," + f3 + "," + f4 + "," + f5 + "," + f6 + "," + f7 + "," + f8 + "," + f9 + ")");
        this.downstreamGL.glTexCoord2fNormal3fVertex3fSUN(f2, f3, f4, f5, f6, f7, f8, f9);
        this.println("");
    }

    @Override
    public void glTexCoord2fNormal3fVertex3fvSUN(FloatBuffer floatBuffer, FloatBuffer floatBuffer2, FloatBuffer floatBuffer3) {
        this.printIndent();
        this.print("glTexCoord2fNormal3fVertex3fvSUN(" + floatBuffer + "," + floatBuffer2 + "," + floatBuffer3 + ")");
        this.downstreamGL.glTexCoord2fNormal3fVertex3fvSUN(floatBuffer, floatBuffer2, floatBuffer3);
        this.println("");
    }

    @Override
    public void glTexCoord2fNormal3fVertex3fvSUN(float[] fArray, int n2, float[] fArray2, int n3, float[] fArray3, int n4) {
        this.printIndent();
        this.print("glTexCoord2fNormal3fVertex3fvSUN(" + this.dumpArray(fArray) + "," + n2 + "," + this.dumpArray(fArray2) + "," + n3 + "," + this.dumpArray(fArray3) + "," + n4 + ")");
        this.downstreamGL.glTexCoord2fNormal3fVertex3fvSUN(fArray, n2, fArray2, n3, fArray3, n4);
        this.println("");
    }

    @Override
    public void glTexCoord2fVertex3fSUN(float f2, float f3, float f4, float f5, float f6) {
        this.printIndent();
        this.print("glTexCoord2fVertex3fSUN(" + f2 + "," + f3 + "," + f4 + "," + f5 + "," + f6 + ")");
        this.downstreamGL.glTexCoord2fVertex3fSUN(f2, f3, f4, f5, f6);
        this.println("");
    }

    @Override
    public void glTexCoord2fVertex3fvSUN(FloatBuffer floatBuffer, FloatBuffer floatBuffer2) {
        this.printIndent();
        this.print("glTexCoord2fVertex3fvSUN(" + floatBuffer + "," + floatBuffer2 + ")");
        this.downstreamGL.glTexCoord2fVertex3fvSUN(floatBuffer, floatBuffer2);
        this.println("");
    }

    @Override
    public void glTexCoord2fVertex3fvSUN(float[] fArray, int n2, float[] fArray2, int n3) {
        this.printIndent();
        this.print("glTexCoord2fVertex3fvSUN(" + this.dumpArray(fArray) + "," + n2 + "," + this.dumpArray(fArray2) + "," + n3 + ")");
        this.downstreamGL.glTexCoord2fVertex3fvSUN(fArray, n2, fArray2, n3);
        this.println("");
    }

    @Override
    public void glTexCoord2fv(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glTexCoord2fv(" + floatBuffer + ")");
        this.downstreamGL.glTexCoord2fv(floatBuffer);
        this.println("");
    }

    @Override
    public void glTexCoord2fv(float[] fArray, int n2) {
        this.printIndent();
        this.print("glTexCoord2fv(" + this.dumpArray(fArray) + "," + n2 + ")");
        this.downstreamGL.glTexCoord2fv(fArray, n2);
        this.println("");
    }

    @Override
    public void glTexCoord2hNV(short s2, short s3) {
        this.printIndent();
        this.print("glTexCoord2hNV(" + s2 + "," + s3 + ")");
        this.downstreamGL.glTexCoord2hNV(s2, s3);
        this.println("");
    }

    @Override
    public void glTexCoord2hvNV(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glTexCoord2hvNV(" + shortBuffer + ")");
        this.downstreamGL.glTexCoord2hvNV(shortBuffer);
        this.println("");
    }

    @Override
    public void glTexCoord2hvNV(short[] sArray, int n2) {
        this.printIndent();
        this.print("glTexCoord2hvNV(" + this.dumpArray(sArray) + "," + n2 + ")");
        this.downstreamGL.glTexCoord2hvNV(sArray, n2);
        this.println("");
    }

    @Override
    public void glTexCoord2i(int n2, int n3) {
        this.printIndent();
        this.print("glTexCoord2i(" + n2 + "," + n3 + ")");
        this.downstreamGL.glTexCoord2i(n2, n3);
        this.println("");
    }

    @Override
    public void glTexCoord2iv(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glTexCoord2iv(" + intBuffer + ")");
        this.downstreamGL.glTexCoord2iv(intBuffer);
        this.println("");
    }

    @Override
    public void glTexCoord2iv(int[] nArray, int n2) {
        this.printIndent();
        this.print("glTexCoord2iv(" + this.dumpArray(nArray) + "," + n2 + ")");
        this.downstreamGL.glTexCoord2iv(nArray, n2);
        this.println("");
    }

    @Override
    public void glTexCoord2s(short s2, short s3) {
        this.printIndent();
        this.print("glTexCoord2s(" + s2 + "," + s3 + ")");
        this.downstreamGL.glTexCoord2s(s2, s3);
        this.println("");
    }

    @Override
    public void glTexCoord2sv(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glTexCoord2sv(" + shortBuffer + ")");
        this.downstreamGL.glTexCoord2sv(shortBuffer);
        this.println("");
    }

    @Override
    public void glTexCoord2sv(short[] sArray, int n2) {
        this.printIndent();
        this.print("glTexCoord2sv(" + this.dumpArray(sArray) + "," + n2 + ")");
        this.downstreamGL.glTexCoord2sv(sArray, n2);
        this.println("");
    }

    @Override
    public void glTexCoord3d(double d2, double d3, double d4) {
        this.printIndent();
        this.print("glTexCoord3d(" + d2 + "," + d3 + "," + d4 + ")");
        this.downstreamGL.glTexCoord3d(d2, d3, d4);
        this.println("");
    }

    @Override
    public void glTexCoord3dv(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glTexCoord3dv(" + doubleBuffer + ")");
        this.downstreamGL.glTexCoord3dv(doubleBuffer);
        this.println("");
    }

    @Override
    public void glTexCoord3dv(double[] dArray, int n2) {
        this.printIndent();
        this.print("glTexCoord3dv(" + this.dumpArray(dArray) + "," + n2 + ")");
        this.downstreamGL.glTexCoord3dv(dArray, n2);
        this.println("");
    }

    @Override
    public void glTexCoord3f(float f2, float f3, float f4) {
        this.printIndent();
        this.print("glTexCoord3f(" + f2 + "," + f3 + "," + f4 + ")");
        this.downstreamGL.glTexCoord3f(f2, f3, f4);
        this.println("");
    }

    @Override
    public void glTexCoord3fv(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glTexCoord3fv(" + floatBuffer + ")");
        this.downstreamGL.glTexCoord3fv(floatBuffer);
        this.println("");
    }

    @Override
    public void glTexCoord3fv(float[] fArray, int n2) {
        this.printIndent();
        this.print("glTexCoord3fv(" + this.dumpArray(fArray) + "," + n2 + ")");
        this.downstreamGL.glTexCoord3fv(fArray, n2);
        this.println("");
    }

    @Override
    public void glTexCoord3hNV(short s2, short s3, short s4) {
        this.printIndent();
        this.print("glTexCoord3hNV(" + s2 + "," + s3 + "," + s4 + ")");
        this.downstreamGL.glTexCoord3hNV(s2, s3, s4);
        this.println("");
    }

    @Override
    public void glTexCoord3hvNV(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glTexCoord3hvNV(" + shortBuffer + ")");
        this.downstreamGL.glTexCoord3hvNV(shortBuffer);
        this.println("");
    }

    @Override
    public void glTexCoord3hvNV(short[] sArray, int n2) {
        this.printIndent();
        this.print("glTexCoord3hvNV(" + this.dumpArray(sArray) + "," + n2 + ")");
        this.downstreamGL.glTexCoord3hvNV(sArray, n2);
        this.println("");
    }

    @Override
    public void glTexCoord3i(int n2, int n3, int n4) {
        this.printIndent();
        this.print("glTexCoord3i(" + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glTexCoord3i(n2, n3, n4);
        this.println("");
    }

    @Override
    public void glTexCoord3iv(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glTexCoord3iv(" + intBuffer + ")");
        this.downstreamGL.glTexCoord3iv(intBuffer);
        this.println("");
    }

    @Override
    public void glTexCoord3iv(int[] nArray, int n2) {
        this.printIndent();
        this.print("glTexCoord3iv(" + this.dumpArray(nArray) + "," + n2 + ")");
        this.downstreamGL.glTexCoord3iv(nArray, n2);
        this.println("");
    }

    @Override
    public void glTexCoord3s(short s2, short s3, short s4) {
        this.printIndent();
        this.print("glTexCoord3s(" + s2 + "," + s3 + "," + s4 + ")");
        this.downstreamGL.glTexCoord3s(s2, s3, s4);
        this.println("");
    }

    @Override
    public void glTexCoord3sv(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glTexCoord3sv(" + shortBuffer + ")");
        this.downstreamGL.glTexCoord3sv(shortBuffer);
        this.println("");
    }

    @Override
    public void glTexCoord3sv(short[] sArray, int n2) {
        this.printIndent();
        this.print("glTexCoord3sv(" + this.dumpArray(sArray) + "," + n2 + ")");
        this.downstreamGL.glTexCoord3sv(sArray, n2);
        this.println("");
    }

    @Override
    public void glTexCoord4d(double d2, double d3, double d4, double d5) {
        this.printIndent();
        this.print("glTexCoord4d(" + d2 + "," + d3 + "," + d4 + "," + d5 + ")");
        this.downstreamGL.glTexCoord4d(d2, d3, d4, d5);
        this.println("");
    }

    @Override
    public void glTexCoord4dv(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glTexCoord4dv(" + doubleBuffer + ")");
        this.downstreamGL.glTexCoord4dv(doubleBuffer);
        this.println("");
    }

    @Override
    public void glTexCoord4dv(double[] dArray, int n2) {
        this.printIndent();
        this.print("glTexCoord4dv(" + this.dumpArray(dArray) + "," + n2 + ")");
        this.downstreamGL.glTexCoord4dv(dArray, n2);
        this.println("");
    }

    @Override
    public void glTexCoord4f(float f2, float f3, float f4, float f5) {
        this.printIndent();
        this.print("glTexCoord4f(" + f2 + "," + f3 + "," + f4 + "," + f5 + ")");
        this.downstreamGL.glTexCoord4f(f2, f3, f4, f5);
        this.println("");
    }

    @Override
    public void glTexCoord4fColor4fNormal3fVertex4fSUN(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        this.printIndent();
        this.print("glTexCoord4fColor4fNormal3fVertex4fSUN(" + f2 + "," + f3 + "," + f4 + "," + f5 + "," + f6 + "," + f7 + "," + f8 + "," + f9 + "," + f10 + "," + f11 + "," + f12 + "," + f13 + "," + f14 + "," + f15 + "," + f16 + ")");
        this.downstreamGL.glTexCoord4fColor4fNormal3fVertex4fSUN(f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16);
        this.println("");
    }

    @Override
    public void glTexCoord4fColor4fNormal3fVertex4fvSUN(FloatBuffer floatBuffer, FloatBuffer floatBuffer2, FloatBuffer floatBuffer3, FloatBuffer floatBuffer4) {
        this.printIndent();
        this.print("glTexCoord4fColor4fNormal3fVertex4fvSUN(" + floatBuffer + "," + floatBuffer2 + "," + floatBuffer3 + "," + floatBuffer4 + ")");
        this.downstreamGL.glTexCoord4fColor4fNormal3fVertex4fvSUN(floatBuffer, floatBuffer2, floatBuffer3, floatBuffer4);
        this.println("");
    }

    @Override
    public void glTexCoord4fColor4fNormal3fVertex4fvSUN(float[] fArray, int n2, float[] fArray2, int n3, float[] fArray3, int n4, float[] fArray4, int n5) {
        this.printIndent();
        this.print("glTexCoord4fColor4fNormal3fVertex4fvSUN(" + this.dumpArray(fArray) + "," + n2 + "," + this.dumpArray(fArray2) + "," + n3 + "," + this.dumpArray(fArray3) + "," + n4 + "," + this.dumpArray(fArray4) + "," + n5 + ")");
        this.downstreamGL.glTexCoord4fColor4fNormal3fVertex4fvSUN(fArray, n2, fArray2, n3, fArray3, n4, fArray4, n5);
        this.println("");
    }

    @Override
    public void glTexCoord4fVertex4fSUN(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.printIndent();
        this.print("glTexCoord4fVertex4fSUN(" + f2 + "," + f3 + "," + f4 + "," + f5 + "," + f6 + "," + f7 + "," + f8 + "," + f9 + ")");
        this.downstreamGL.glTexCoord4fVertex4fSUN(f2, f3, f4, f5, f6, f7, f8, f9);
        this.println("");
    }

    @Override
    public void glTexCoord4fVertex4fvSUN(FloatBuffer floatBuffer, FloatBuffer floatBuffer2) {
        this.printIndent();
        this.print("glTexCoord4fVertex4fvSUN(" + floatBuffer + "," + floatBuffer2 + ")");
        this.downstreamGL.glTexCoord4fVertex4fvSUN(floatBuffer, floatBuffer2);
        this.println("");
    }

    @Override
    public void glTexCoord4fVertex4fvSUN(float[] fArray, int n2, float[] fArray2, int n3) {
        this.printIndent();
        this.print("glTexCoord4fVertex4fvSUN(" + this.dumpArray(fArray) + "," + n2 + "," + this.dumpArray(fArray2) + "," + n3 + ")");
        this.downstreamGL.glTexCoord4fVertex4fvSUN(fArray, n2, fArray2, n3);
        this.println("");
    }

    @Override
    public void glTexCoord4fv(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glTexCoord4fv(" + floatBuffer + ")");
        this.downstreamGL.glTexCoord4fv(floatBuffer);
        this.println("");
    }

    @Override
    public void glTexCoord4fv(float[] fArray, int n2) {
        this.printIndent();
        this.print("glTexCoord4fv(" + this.dumpArray(fArray) + "," + n2 + ")");
        this.downstreamGL.glTexCoord4fv(fArray, n2);
        this.println("");
    }

    @Override
    public void glTexCoord4hNV(short s2, short s3, short s4, short s5) {
        this.printIndent();
        this.print("glTexCoord4hNV(" + s2 + "," + s3 + "," + s4 + "," + s5 + ")");
        this.downstreamGL.glTexCoord4hNV(s2, s3, s4, s5);
        this.println("");
    }

    @Override
    public void glTexCoord4hvNV(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glTexCoord4hvNV(" + shortBuffer + ")");
        this.downstreamGL.glTexCoord4hvNV(shortBuffer);
        this.println("");
    }

    @Override
    public void glTexCoord4hvNV(short[] sArray, int n2) {
        this.printIndent();
        this.print("glTexCoord4hvNV(" + this.dumpArray(sArray) + "," + n2 + ")");
        this.downstreamGL.glTexCoord4hvNV(sArray, n2);
        this.println("");
    }

    @Override
    public void glTexCoord4i(int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glTexCoord4i(" + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glTexCoord4i(n2, n3, n4, n5);
        this.println("");
    }

    @Override
    public void glTexCoord4iv(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glTexCoord4iv(" + intBuffer + ")");
        this.downstreamGL.glTexCoord4iv(intBuffer);
        this.println("");
    }

    @Override
    public void glTexCoord4iv(int[] nArray, int n2) {
        this.printIndent();
        this.print("glTexCoord4iv(" + this.dumpArray(nArray) + "," + n2 + ")");
        this.downstreamGL.glTexCoord4iv(nArray, n2);
        this.println("");
    }

    @Override
    public void glTexCoord4s(short s2, short s3, short s4, short s5) {
        this.printIndent();
        this.print("glTexCoord4s(" + s2 + "," + s3 + "," + s4 + "," + s5 + ")");
        this.downstreamGL.glTexCoord4s(s2, s3, s4, s5);
        this.println("");
    }

    @Override
    public void glTexCoord4sv(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glTexCoord4sv(" + shortBuffer + ")");
        this.downstreamGL.glTexCoord4sv(shortBuffer);
        this.println("");
    }

    @Override
    public void glTexCoord4sv(short[] sArray, int n2) {
        this.printIndent();
        this.print("glTexCoord4sv(" + this.dumpArray(sArray) + "," + n2 + ")");
        this.downstreamGL.glTexCoord4sv(sArray, n2);
        this.println("");
    }

    @Override
    public void glTexCoordPointer(int n2, int n3, int n4, Buffer buffer) {
        this.printIndent();
        this.print("glTexCoordPointer(" + n2 + "," + n3 + "," + n4 + "," + buffer + ")");
        this.downstreamGL.glTexCoordPointer(n2, n3, n4, buffer);
        this.println("");
    }

    @Override
    public void glTexCoordPointer(int n2, int n3, int n4, long l2) {
        this.printIndent();
        this.print("glTexCoordPointer(" + n2 + "," + n3 + "," + n4 + "," + l2 + ")");
        this.downstreamGL.glTexCoordPointer(n2, n3, n4, l2);
        this.println("");
    }

    @Override
    public void glTexEnvf(int n2, int n3, float f2) {
        this.printIndent();
        this.print("glTexEnvf(" + n2 + "," + n3 + "," + f2 + ")");
        this.downstreamGL.glTexEnvf(n2, n3, f2);
        this.println("");
    }

    @Override
    public void glTexEnvfv(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glTexEnvfv(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glTexEnvfv(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glTexEnvfv(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glTexEnvfv(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glTexEnvfv(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glTexEnvi(int n2, int n3, int n4) {
        this.printIndent();
        this.print("glTexEnvi(" + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glTexEnvi(n2, n3, n4);
        this.println("");
    }

    @Override
    public void glTexEnviv(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glTexEnviv(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glTexEnviv(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glTexEnviv(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glTexEnviv(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glTexEnviv(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glTexFilterFuncSGIS(int n2, int n3, int n4, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glTexFilterFuncSGIS(" + n2 + "," + n3 + "," + n4 + "," + floatBuffer + ")");
        this.downstreamGL.glTexFilterFuncSGIS(n2, n3, n4, floatBuffer);
        this.println("");
    }

    @Override
    public void glTexFilterFuncSGIS(int n2, int n3, int n4, float[] fArray, int n5) {
        this.printIndent();
        this.print("glTexFilterFuncSGIS(" + n2 + "," + n3 + "," + n4 + "," + this.dumpArray(fArray) + "," + n5 + ")");
        this.downstreamGL.glTexFilterFuncSGIS(n2, n3, n4, fArray, n5);
        this.println("");
    }

    @Override
    public void glTexGend(int n2, int n3, double d2) {
        this.printIndent();
        this.print("glTexGend(" + n2 + "," + n3 + "," + d2 + ")");
        this.downstreamGL.glTexGend(n2, n3, d2);
        this.println("");
    }

    @Override
    public void glTexGendv(int n2, int n3, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glTexGendv(" + n2 + "," + n3 + "," + doubleBuffer + ")");
        this.downstreamGL.glTexGendv(n2, n3, doubleBuffer);
        this.println("");
    }

    @Override
    public void glTexGendv(int n2, int n3, double[] dArray, int n4) {
        this.printIndent();
        this.print("glTexGendv(" + n2 + "," + n3 + "," + this.dumpArray(dArray) + "," + n4 + ")");
        this.downstreamGL.glTexGendv(n2, n3, dArray, n4);
        this.println("");
    }

    @Override
    public void glTexGenf(int n2, int n3, float f2) {
        this.printIndent();
        this.print("glTexGenf(" + n2 + "," + n3 + "," + f2 + ")");
        this.downstreamGL.glTexGenf(n2, n3, f2);
        this.println("");
    }

    @Override
    public void glTexGenfv(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glTexGenfv(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glTexGenfv(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glTexGenfv(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glTexGenfv(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glTexGenfv(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glTexGeni(int n2, int n3, int n4) {
        this.printIndent();
        this.print("glTexGeni(" + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glTexGeni(n2, n3, n4);
        this.println("");
    }

    @Override
    public void glTexGeniv(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glTexGeniv(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glTexGeniv(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glTexGeniv(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glTexGeniv(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glTexGeniv(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glTexImage1D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, Buffer buffer) {
        this.printIndent();
        this.print("glTexImage1D(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + buffer + ")");
        this.downstreamGL.glTexImage1D(n2, n3, n4, n5, n6, n7, n8, buffer);
        this.println("");
    }

    @Override
    public void glTexImage1D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, long l2) {
        this.printIndent();
        this.print("glTexImage1D(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + l2 + ")");
        this.downstreamGL.glTexImage1D(n2, n3, n4, n5, n6, n7, n8, l2);
        this.println("");
    }

    @Override
    public void glTexImage2D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Buffer buffer) {
        this.printIndent();
        this.print("glTexImage2D(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + buffer + ")");
        this.downstreamGL.glTexImage2D(n2, n3, n4, n5, n6, n7, n8, n9, buffer);
        this.println("");
    }

    @Override
    public void glTexImage2D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, long l2) {
        this.printIndent();
        this.print("glTexImage2D(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + l2 + ")");
        this.downstreamGL.glTexImage2D(n2, n3, n4, n5, n6, n7, n8, n9, l2);
        this.println("");
    }

    @Override
    public void glTexImage3D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, Buffer buffer) {
        this.printIndent();
        this.print("glTexImage3D(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + buffer + ")");
        this.downstreamGL.glTexImage3D(n2, n3, n4, n5, n6, n7, n8, n9, n10, buffer);
        this.println("");
    }

    @Override
    public void glTexImage3D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, long l2) {
        this.printIndent();
        this.print("glTexImage3D(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + l2 + ")");
        this.downstreamGL.glTexImage3D(n2, n3, n4, n5, n6, n7, n8, n9, n10, l2);
        this.println("");
    }

    @Override
    public void glTexImage4DSGIS(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, Buffer buffer) {
        this.printIndent();
        this.print("glTexImage4DSGIS(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + n11 + "," + buffer + ")");
        this.downstreamGL.glTexImage4DSGIS(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, buffer);
        this.println("");
    }

    @Override
    public void glTexParameterIivEXT(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glTexParameterIivEXT(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glTexParameterIivEXT(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glTexParameterIivEXT(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glTexParameterIivEXT(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glTexParameterIivEXT(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glTexParameterIuivEXT(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glTexParameterIuivEXT(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glTexParameterIuivEXT(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glTexParameterIuivEXT(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glTexParameterIuivEXT(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glTexParameterIuivEXT(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glTexParameterf(int n2, int n3, float f2) {
        this.printIndent();
        this.print("glTexParameterf(" + n2 + "," + n3 + "," + f2 + ")");
        this.downstreamGL.glTexParameterf(n2, n3, f2);
        this.println("");
    }

    @Override
    public void glTexParameterfv(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glTexParameterfv(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glTexParameterfv(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glTexParameterfv(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glTexParameterfv(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glTexParameterfv(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glTexParameteri(int n2, int n3, int n4) {
        this.printIndent();
        this.print("glTexParameteri(" + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glTexParameteri(n2, n3, n4);
        this.println("");
    }

    @Override
    public void glTexParameteriv(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glTexParameteriv(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glTexParameteriv(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glTexParameteriv(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glTexParameteriv(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glTexParameteriv(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glTexSubImage1D(int n2, int n3, int n4, int n5, int n6, int n7, Buffer buffer) {
        this.printIndent();
        this.print("glTexSubImage1D(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + buffer + ")");
        this.downstreamGL.glTexSubImage1D(n2, n3, n4, n5, n6, n7, buffer);
        this.println("");
    }

    @Override
    public void glTexSubImage1D(int n2, int n3, int n4, int n5, int n6, int n7, long l2) {
        this.printIndent();
        this.print("glTexSubImage1D(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + l2 + ")");
        this.downstreamGL.glTexSubImage1D(n2, n3, n4, n5, n6, n7, l2);
        this.println("");
    }

    @Override
    public void glTexSubImage2D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Buffer buffer) {
        this.printIndent();
        this.print("glTexSubImage2D(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + buffer + ")");
        this.downstreamGL.glTexSubImage2D(n2, n3, n4, n5, n6, n7, n8, n9, buffer);
        this.println("");
    }

    @Override
    public void glTexSubImage2D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, long l2) {
        this.printIndent();
        this.print("glTexSubImage2D(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + l2 + ")");
        this.downstreamGL.glTexSubImage2D(n2, n3, n4, n5, n6, n7, n8, n9, l2);
        this.println("");
    }

    @Override
    public void glTexSubImage3D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, Buffer buffer) {
        this.printIndent();
        this.print("glTexSubImage3D(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + n11 + "," + buffer + ")");
        this.downstreamGL.glTexSubImage3D(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, buffer);
        this.println("");
    }

    @Override
    public void glTexSubImage3D(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, long l2) {
        this.printIndent();
        this.print("glTexSubImage3D(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + n11 + "," + l2 + ")");
        this.downstreamGL.glTexSubImage3D(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, l2);
        this.println("");
    }

    @Override
    public void glTexSubImage4DSGIS(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, Buffer buffer) {
        this.printIndent();
        this.print("glTexSubImage4DSGIS(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8 + "," + n9 + "," + n10 + "," + n11 + "," + n12 + "," + n13 + "," + buffer + ")");
        this.downstreamGL.glTexSubImage4DSGIS(n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, buffer);
        this.println("");
    }

    @Override
    public void glTextureColorMaskSGIS(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.printIndent();
        this.print("glTextureColorMaskSGIS(" + bl + "," + bl2 + "," + bl3 + "," + bl4 + ")");
        this.downstreamGL.glTextureColorMaskSGIS(bl, bl2, bl3, bl4);
        this.println("");
    }

    @Override
    public void glTextureLightEXT(int n2) {
        this.printIndent();
        this.print("glTextureLightEXT(" + n2 + ")");
        this.downstreamGL.glTextureLightEXT(n2);
        this.println("");
    }

    @Override
    public void glTextureMaterialEXT(int n2, int n3) {
        this.printIndent();
        this.print("glTextureMaterialEXT(" + n2 + "," + n3 + ")");
        this.downstreamGL.glTextureMaterialEXT(n2, n3);
        this.println("");
    }

    @Override
    public void glTextureNormalEXT(int n2) {
        this.printIndent();
        this.print("glTextureNormalEXT(" + n2 + ")");
        this.downstreamGL.glTextureNormalEXT(n2);
        this.println("");
    }

    @Override
    public void glTextureRangeAPPLE(int n2, int n3, Buffer buffer) {
        this.printIndent();
        this.print("glTextureRangeAPPLE(" + n2 + "," + n3 + "," + buffer + ")");
        this.downstreamGL.glTextureRangeAPPLE(n2, n3, buffer);
        this.println("");
    }

    @Override
    public void glTrackMatrixNV(int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glTrackMatrixNV(" + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glTrackMatrixNV(n2, n3, n4, n5);
        this.println("");
    }

    @Override
    public void glTransformFeedbackAttribsNV(int n2, IntBuffer intBuffer, int n3) {
        this.printIndent();
        this.print("glTransformFeedbackAttribsNV(" + n2 + "," + intBuffer + "," + n3 + ")");
        this.downstreamGL.glTransformFeedbackAttribsNV(n2, intBuffer, n3);
        this.println("");
    }

    @Override
    public void glTransformFeedbackAttribsNV(int n2, int[] nArray, int n3, int n4) {
        this.printIndent();
        this.print("glTransformFeedbackAttribsNV(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glTransformFeedbackAttribsNV(n2, nArray, n3, n4);
        this.println("");
    }

    @Override
    public void glTransformFeedbackVaryingsNV(int n2, int n3, IntBuffer intBuffer, int n4) {
        this.printIndent();
        this.print("glTransformFeedbackVaryingsNV(" + n2 + "," + n3 + "," + intBuffer + "," + n4 + ")");
        this.downstreamGL.glTransformFeedbackVaryingsNV(n2, n3, intBuffer, n4);
        this.println("");
    }

    @Override
    public void glTransformFeedbackVaryingsNV(int n2, int n3, int[] nArray, int n4, int n5) {
        this.printIndent();
        this.print("glTransformFeedbackVaryingsNV(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glTransformFeedbackVaryingsNV(n2, n3, nArray, n4, n5);
        this.println("");
    }

    @Override
    public void glTranslated(double d2, double d3, double d4) {
        this.printIndent();
        this.print("glTranslated(" + d2 + "," + d3 + "," + d4 + ")");
        this.downstreamGL.glTranslated(d2, d3, d4);
        this.println("");
    }

    @Override
    public void glTranslatef(float f2, float f3, float f4) {
        this.printIndent();
        this.print("glTranslatef(" + f2 + "," + f3 + "," + f4 + ")");
        this.downstreamGL.glTranslatef(f2, f3, f4);
        this.println("");
    }

    @Override
    public void glUniform1f(int n2, float f2) {
        this.printIndent();
        this.print("glUniform1f(" + n2 + "," + f2 + ")");
        this.downstreamGL.glUniform1f(n2, f2);
        this.println("");
    }

    @Override
    public void glUniform1fARB(int n2, float f2) {
        this.printIndent();
        this.print("glUniform1fARB(" + n2 + "," + f2 + ")");
        this.downstreamGL.glUniform1fARB(n2, f2);
        this.println("");
    }

    @Override
    public void glUniform1fv(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glUniform1fv(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glUniform1fv(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glUniform1fv(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glUniform1fv(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glUniform1fv(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glUniform1fvARB(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glUniform1fvARB(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glUniform1fvARB(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glUniform1fvARB(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glUniform1fvARB(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glUniform1fvARB(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glUniform1i(int n2, int n3) {
        this.printIndent();
        this.print("glUniform1i(" + n2 + "," + n3 + ")");
        this.downstreamGL.glUniform1i(n2, n3);
        this.println("");
    }

    @Override
    public void glUniform1iARB(int n2, int n3) {
        this.printIndent();
        this.print("glUniform1iARB(" + n2 + "," + n3 + ")");
        this.downstreamGL.glUniform1iARB(n2, n3);
        this.println("");
    }

    @Override
    public void glUniform1iv(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glUniform1iv(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glUniform1iv(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glUniform1iv(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glUniform1iv(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glUniform1iv(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glUniform1ivARB(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glUniform1ivARB(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glUniform1ivARB(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glUniform1ivARB(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glUniform1ivARB(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glUniform1ivARB(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glUniform1uiEXT(int n2, int n3) {
        this.printIndent();
        this.print("glUniform1uiEXT(" + n2 + "," + n3 + ")");
        this.downstreamGL.glUniform1uiEXT(n2, n3);
        this.println("");
    }

    @Override
    public void glUniform1uivEXT(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glUniform1uivEXT(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glUniform1uivEXT(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glUniform1uivEXT(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glUniform1uivEXT(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glUniform1uivEXT(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glUniform2f(int n2, float f2, float f3) {
        this.printIndent();
        this.print("glUniform2f(" + n2 + "," + f2 + "," + f3 + ")");
        this.downstreamGL.glUniform2f(n2, f2, f3);
        this.println("");
    }

    @Override
    public void glUniform2fARB(int n2, float f2, float f3) {
        this.printIndent();
        this.print("glUniform2fARB(" + n2 + "," + f2 + "," + f3 + ")");
        this.downstreamGL.glUniform2fARB(n2, f2, f3);
        this.println("");
    }

    @Override
    public void glUniform2fv(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glUniform2fv(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glUniform2fv(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glUniform2fv(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glUniform2fv(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glUniform2fv(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glUniform2fvARB(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glUniform2fvARB(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glUniform2fvARB(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glUniform2fvARB(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glUniform2fvARB(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glUniform2fvARB(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glUniform2i(int n2, int n3, int n4) {
        this.printIndent();
        this.print("glUniform2i(" + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glUniform2i(n2, n3, n4);
        this.println("");
    }

    @Override
    public void glUniform2iARB(int n2, int n3, int n4) {
        this.printIndent();
        this.print("glUniform2iARB(" + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glUniform2iARB(n2, n3, n4);
        this.println("");
    }

    @Override
    public void glUniform2iv(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glUniform2iv(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glUniform2iv(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glUniform2iv(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glUniform2iv(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glUniform2iv(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glUniform2ivARB(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glUniform2ivARB(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glUniform2ivARB(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glUniform2ivARB(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glUniform2ivARB(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glUniform2ivARB(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glUniform2uiEXT(int n2, int n3, int n4) {
        this.printIndent();
        this.print("glUniform2uiEXT(" + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glUniform2uiEXT(n2, n3, n4);
        this.println("");
    }

    @Override
    public void glUniform2uivEXT(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glUniform2uivEXT(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glUniform2uivEXT(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glUniform2uivEXT(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glUniform2uivEXT(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glUniform2uivEXT(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glUniform3f(int n2, float f2, float f3, float f4) {
        this.printIndent();
        this.print("glUniform3f(" + n2 + "," + f2 + "," + f3 + "," + f4 + ")");
        this.downstreamGL.glUniform3f(n2, f2, f3, f4);
        this.println("");
    }

    @Override
    public void glUniform3fARB(int n2, float f2, float f3, float f4) {
        this.printIndent();
        this.print("glUniform3fARB(" + n2 + "," + f2 + "," + f3 + "," + f4 + ")");
        this.downstreamGL.glUniform3fARB(n2, f2, f3, f4);
        this.println("");
    }

    @Override
    public void glUniform3fv(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glUniform3fv(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glUniform3fv(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glUniform3fv(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glUniform3fv(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glUniform3fv(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glUniform3fvARB(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glUniform3fvARB(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glUniform3fvARB(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glUniform3fvARB(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glUniform3fvARB(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glUniform3fvARB(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glUniform3i(int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glUniform3i(" + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glUniform3i(n2, n3, n4, n5);
        this.println("");
    }

    @Override
    public void glUniform3iARB(int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glUniform3iARB(" + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glUniform3iARB(n2, n3, n4, n5);
        this.println("");
    }

    @Override
    public void glUniform3iv(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glUniform3iv(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glUniform3iv(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glUniform3iv(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glUniform3iv(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glUniform3iv(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glUniform3ivARB(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glUniform3ivARB(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glUniform3ivARB(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glUniform3ivARB(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glUniform3ivARB(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glUniform3ivARB(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glUniform3uiEXT(int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glUniform3uiEXT(" + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glUniform3uiEXT(n2, n3, n4, n5);
        this.println("");
    }

    @Override
    public void glUniform3uivEXT(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glUniform3uivEXT(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glUniform3uivEXT(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glUniform3uivEXT(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glUniform3uivEXT(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glUniform3uivEXT(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glUniform4f(int n2, float f2, float f3, float f4, float f5) {
        this.printIndent();
        this.print("glUniform4f(" + n2 + "," + f2 + "," + f3 + "," + f4 + "," + f5 + ")");
        this.downstreamGL.glUniform4f(n2, f2, f3, f4, f5);
        this.println("");
    }

    @Override
    public void glUniform4fARB(int n2, float f2, float f3, float f4, float f5) {
        this.printIndent();
        this.print("glUniform4fARB(" + n2 + "," + f2 + "," + f3 + "," + f4 + "," + f5 + ")");
        this.downstreamGL.glUniform4fARB(n2, f2, f3, f4, f5);
        this.println("");
    }

    @Override
    public void glUniform4fv(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glUniform4fv(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glUniform4fv(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glUniform4fv(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glUniform4fv(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glUniform4fv(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glUniform4fvARB(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glUniform4fvARB(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glUniform4fvARB(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glUniform4fvARB(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glUniform4fvARB(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glUniform4fvARB(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glUniform4i(int n2, int n3, int n4, int n5, int n6) {
        this.printIndent();
        this.print("glUniform4i(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + ")");
        this.downstreamGL.glUniform4i(n2, n3, n4, n5, n6);
        this.println("");
    }

    @Override
    public void glUniform4iARB(int n2, int n3, int n4, int n5, int n6) {
        this.printIndent();
        this.print("glUniform4iARB(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + ")");
        this.downstreamGL.glUniform4iARB(n2, n3, n4, n5, n6);
        this.println("");
    }

    @Override
    public void glUniform4iv(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glUniform4iv(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glUniform4iv(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glUniform4iv(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glUniform4iv(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glUniform4iv(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glUniform4ivARB(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glUniform4ivARB(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glUniform4ivARB(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glUniform4ivARB(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glUniform4ivARB(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glUniform4ivARB(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glUniform4uiEXT(int n2, int n3, int n4, int n5, int n6) {
        this.printIndent();
        this.print("glUniform4uiEXT(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + ")");
        this.downstreamGL.glUniform4uiEXT(n2, n3, n4, n5, n6);
        this.println("");
    }

    @Override
    public void glUniform4uivEXT(int n2, int n3, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glUniform4uivEXT(" + n2 + "," + n3 + "," + intBuffer + ")");
        this.downstreamGL.glUniform4uivEXT(n2, n3, intBuffer);
        this.println("");
    }

    @Override
    public void glUniform4uivEXT(int n2, int n3, int[] nArray, int n4) {
        this.printIndent();
        this.print("glUniform4uivEXT(" + n2 + "," + n3 + "," + this.dumpArray(nArray) + "," + n4 + ")");
        this.downstreamGL.glUniform4uivEXT(n2, n3, nArray, n4);
        this.println("");
    }

    @Override
    public void glUniformBufferEXT(int n2, int n3, int n4) {
        this.printIndent();
        this.print("glUniformBufferEXT(" + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glUniformBufferEXT(n2, n3, n4);
        this.println("");
    }

    @Override
    public void glUniformMatrix2fv(int n2, int n3, boolean bl, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glUniformMatrix2fv(" + n2 + "," + n3 + "," + bl + "," + floatBuffer + ")");
        this.downstreamGL.glUniformMatrix2fv(n2, n3, bl, floatBuffer);
        this.println("");
    }

    @Override
    public void glUniformMatrix2fv(int n2, int n3, boolean bl, float[] fArray, int n4) {
        this.printIndent();
        this.print("glUniformMatrix2fv(" + n2 + "," + n3 + "," + bl + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glUniformMatrix2fv(n2, n3, bl, fArray, n4);
        this.println("");
    }

    @Override
    public void glUniformMatrix2fvARB(int n2, int n3, boolean bl, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glUniformMatrix2fvARB(" + n2 + "," + n3 + "," + bl + "," + floatBuffer + ")");
        this.downstreamGL.glUniformMatrix2fvARB(n2, n3, bl, floatBuffer);
        this.println("");
    }

    @Override
    public void glUniformMatrix2fvARB(int n2, int n3, boolean bl, float[] fArray, int n4) {
        this.printIndent();
        this.print("glUniformMatrix2fvARB(" + n2 + "," + n3 + "," + bl + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glUniformMatrix2fvARB(n2, n3, bl, fArray, n4);
        this.println("");
    }

    @Override
    public void glUniformMatrix2x3fv(int n2, int n3, boolean bl, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glUniformMatrix2x3fv(" + n2 + "," + n3 + "," + bl + "," + floatBuffer + ")");
        this.downstreamGL.glUniformMatrix2x3fv(n2, n3, bl, floatBuffer);
        this.println("");
    }

    @Override
    public void glUniformMatrix2x3fv(int n2, int n3, boolean bl, float[] fArray, int n4) {
        this.printIndent();
        this.print("glUniformMatrix2x3fv(" + n2 + "," + n3 + "," + bl + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glUniformMatrix2x3fv(n2, n3, bl, fArray, n4);
        this.println("");
    }

    @Override
    public void glUniformMatrix2x4fv(int n2, int n3, boolean bl, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glUniformMatrix2x4fv(" + n2 + "," + n3 + "," + bl + "," + floatBuffer + ")");
        this.downstreamGL.glUniformMatrix2x4fv(n2, n3, bl, floatBuffer);
        this.println("");
    }

    @Override
    public void glUniformMatrix2x4fv(int n2, int n3, boolean bl, float[] fArray, int n4) {
        this.printIndent();
        this.print("glUniformMatrix2x4fv(" + n2 + "," + n3 + "," + bl + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glUniformMatrix2x4fv(n2, n3, bl, fArray, n4);
        this.println("");
    }

    @Override
    public void glUniformMatrix3fv(int n2, int n3, boolean bl, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glUniformMatrix3fv(" + n2 + "," + n3 + "," + bl + "," + floatBuffer + ")");
        this.downstreamGL.glUniformMatrix3fv(n2, n3, bl, floatBuffer);
        this.println("");
    }

    @Override
    public void glUniformMatrix3fv(int n2, int n3, boolean bl, float[] fArray, int n4) {
        this.printIndent();
        this.print("glUniformMatrix3fv(" + n2 + "," + n3 + "," + bl + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glUniformMatrix3fv(n2, n3, bl, fArray, n4);
        this.println("");
    }

    @Override
    public void glUniformMatrix3fvARB(int n2, int n3, boolean bl, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glUniformMatrix3fvARB(" + n2 + "," + n3 + "," + bl + "," + floatBuffer + ")");
        this.downstreamGL.glUniformMatrix3fvARB(n2, n3, bl, floatBuffer);
        this.println("");
    }

    @Override
    public void glUniformMatrix3fvARB(int n2, int n3, boolean bl, float[] fArray, int n4) {
        this.printIndent();
        this.print("glUniformMatrix3fvARB(" + n2 + "," + n3 + "," + bl + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glUniformMatrix3fvARB(n2, n3, bl, fArray, n4);
        this.println("");
    }

    @Override
    public void glUniformMatrix3x2fv(int n2, int n3, boolean bl, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glUniformMatrix3x2fv(" + n2 + "," + n3 + "," + bl + "," + floatBuffer + ")");
        this.downstreamGL.glUniformMatrix3x2fv(n2, n3, bl, floatBuffer);
        this.println("");
    }

    @Override
    public void glUniformMatrix3x2fv(int n2, int n3, boolean bl, float[] fArray, int n4) {
        this.printIndent();
        this.print("glUniformMatrix3x2fv(" + n2 + "," + n3 + "," + bl + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glUniformMatrix3x2fv(n2, n3, bl, fArray, n4);
        this.println("");
    }

    @Override
    public void glUniformMatrix3x4fv(int n2, int n3, boolean bl, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glUniformMatrix3x4fv(" + n2 + "," + n3 + "," + bl + "," + floatBuffer + ")");
        this.downstreamGL.glUniformMatrix3x4fv(n2, n3, bl, floatBuffer);
        this.println("");
    }

    @Override
    public void glUniformMatrix3x4fv(int n2, int n3, boolean bl, float[] fArray, int n4) {
        this.printIndent();
        this.print("glUniformMatrix3x4fv(" + n2 + "," + n3 + "," + bl + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glUniformMatrix3x4fv(n2, n3, bl, fArray, n4);
        this.println("");
    }

    @Override
    public void glUniformMatrix4fv(int n2, int n3, boolean bl, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glUniformMatrix4fv(" + n2 + "," + n3 + "," + bl + "," + floatBuffer + ")");
        this.downstreamGL.glUniformMatrix4fv(n2, n3, bl, floatBuffer);
        this.println("");
    }

    @Override
    public void glUniformMatrix4fv(int n2, int n3, boolean bl, float[] fArray, int n4) {
        this.printIndent();
        this.print("glUniformMatrix4fv(" + n2 + "," + n3 + "," + bl + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glUniformMatrix4fv(n2, n3, bl, fArray, n4);
        this.println("");
    }

    @Override
    public void glUniformMatrix4fvARB(int n2, int n3, boolean bl, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glUniformMatrix4fvARB(" + n2 + "," + n3 + "," + bl + "," + floatBuffer + ")");
        this.downstreamGL.glUniformMatrix4fvARB(n2, n3, bl, floatBuffer);
        this.println("");
    }

    @Override
    public void glUniformMatrix4fvARB(int n2, int n3, boolean bl, float[] fArray, int n4) {
        this.printIndent();
        this.print("glUniformMatrix4fvARB(" + n2 + "," + n3 + "," + bl + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glUniformMatrix4fvARB(n2, n3, bl, fArray, n4);
        this.println("");
    }

    @Override
    public void glUniformMatrix4x2fv(int n2, int n3, boolean bl, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glUniformMatrix4x2fv(" + n2 + "," + n3 + "," + bl + "," + floatBuffer + ")");
        this.downstreamGL.glUniformMatrix4x2fv(n2, n3, bl, floatBuffer);
        this.println("");
    }

    @Override
    public void glUniformMatrix4x2fv(int n2, int n3, boolean bl, float[] fArray, int n4) {
        this.printIndent();
        this.print("glUniformMatrix4x2fv(" + n2 + "," + n3 + "," + bl + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glUniformMatrix4x2fv(n2, n3, bl, fArray, n4);
        this.println("");
    }

    @Override
    public void glUniformMatrix4x3fv(int n2, int n3, boolean bl, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glUniformMatrix4x3fv(" + n2 + "," + n3 + "," + bl + "," + floatBuffer + ")");
        this.downstreamGL.glUniformMatrix4x3fv(n2, n3, bl, floatBuffer);
        this.println("");
    }

    @Override
    public void glUniformMatrix4x3fv(int n2, int n3, boolean bl, float[] fArray, int n4) {
        this.printIndent();
        this.print("glUniformMatrix4x3fv(" + n2 + "," + n3 + "," + bl + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glUniformMatrix4x3fv(n2, n3, bl, fArray, n4);
        this.println("");
    }

    @Override
    public void glUnlockArraysEXT() {
        this.printIndent();
        this.print("glUnlockArraysEXT()");
        this.downstreamGL.glUnlockArraysEXT();
        this.println("");
    }

    @Override
    public boolean glUnmapBuffer(int n2) {
        this.printIndent();
        this.print("glUnmapBuffer(" + n2 + ")");
        n2 = this.downstreamGL.glUnmapBuffer(n2) ? 1 : 0;
        this.println(" = " + (n2 != 0));
        return n2 != 0;
    }

    @Override
    public boolean glUnmapBufferARB(int n2) {
        this.printIndent();
        this.print("glUnmapBufferARB(" + n2 + ")");
        n2 = this.downstreamGL.glUnmapBufferARB(n2) ? 1 : 0;
        this.println(" = " + (n2 != 0));
        return n2 != 0;
    }

    @Override
    public void glUpdateObjectBufferATI(int n2, int n3, int n4, Buffer buffer, int n5) {
        this.printIndent();
        this.print("glUpdateObjectBufferATI(" + n2 + "," + n3 + "," + n4 + "," + buffer + "," + n5 + ")");
        this.downstreamGL.glUpdateObjectBufferATI(n2, n3, n4, buffer, n5);
        this.println("");
    }

    @Override
    public void glUseProgram(int n2) {
        this.printIndent();
        this.print("glUseProgram(" + n2 + ")");
        this.downstreamGL.glUseProgram(n2);
        this.println("");
    }

    @Override
    public void glUseProgramObjectARB(int n2) {
        this.printIndent();
        this.print("glUseProgramObjectARB(" + n2 + ")");
        this.downstreamGL.glUseProgramObjectARB(n2);
        this.println("");
    }

    @Override
    public void glValidateProgram(int n2) {
        this.printIndent();
        this.print("glValidateProgram(" + n2 + ")");
        this.downstreamGL.glValidateProgram(n2);
        this.println("");
    }

    @Override
    public void glValidateProgramARB(int n2) {
        this.printIndent();
        this.print("glValidateProgramARB(" + n2 + ")");
        this.downstreamGL.glValidateProgramARB(n2);
        this.println("");
    }

    @Override
    public void glVariantArrayObjectATI(int n2, int n3, int n4, int n5, int n6) {
        this.printIndent();
        this.print("glVariantArrayObjectATI(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + ")");
        this.downstreamGL.glVariantArrayObjectATI(n2, n3, n4, n5, n6);
        this.println("");
    }

    @Override
    public void glVariantPointerEXT(int n2, int n3, int n4, Buffer buffer) {
        this.printIndent();
        this.print("glVariantPointerEXT(" + n2 + "," + n3 + "," + n4 + "," + buffer + ")");
        this.downstreamGL.glVariantPointerEXT(n2, n3, n4, buffer);
        this.println("");
    }

    @Override
    public void glVariantPointerEXT(int n2, int n3, int n4, long l2) {
        this.printIndent();
        this.print("glVariantPointerEXT(" + n2 + "," + n3 + "," + n4 + "," + l2 + ")");
        this.downstreamGL.glVariantPointerEXT(n2, n3, n4, l2);
        this.println("");
    }

    @Override
    public void glVariantbvEXT(int n2, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glVariantbvEXT(" + n2 + "," + byteBuffer + ")");
        this.downstreamGL.glVariantbvEXT(n2, byteBuffer);
        this.println("");
    }

    @Override
    public void glVariantbvEXT(int n2, byte[] byArray, int n3) {
        this.printIndent();
        this.print("glVariantbvEXT(" + n2 + "," + this.dumpArray(byArray) + "," + n3 + ")");
        this.downstreamGL.glVariantbvEXT(n2, byArray, n3);
        this.println("");
    }

    @Override
    public void glVariantdvEXT(int n2, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glVariantdvEXT(" + n2 + "," + doubleBuffer + ")");
        this.downstreamGL.glVariantdvEXT(n2, doubleBuffer);
        this.println("");
    }

    @Override
    public void glVariantdvEXT(int n2, double[] dArray, int n3) {
        this.printIndent();
        this.print("glVariantdvEXT(" + n2 + "," + this.dumpArray(dArray) + "," + n3 + ")");
        this.downstreamGL.glVariantdvEXT(n2, dArray, n3);
        this.println("");
    }

    @Override
    public void glVariantfvEXT(int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glVariantfvEXT(" + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glVariantfvEXT(n2, floatBuffer);
        this.println("");
    }

    @Override
    public void glVariantfvEXT(int n2, float[] fArray, int n3) {
        this.printIndent();
        this.print("glVariantfvEXT(" + n2 + "," + this.dumpArray(fArray) + "," + n3 + ")");
        this.downstreamGL.glVariantfvEXT(n2, fArray, n3);
        this.println("");
    }

    @Override
    public void glVariantivEXT(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glVariantivEXT(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glVariantivEXT(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glVariantivEXT(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glVariantivEXT(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glVariantivEXT(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glVariantsvEXT(int n2, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVariantsvEXT(" + n2 + "," + shortBuffer + ")");
        this.downstreamGL.glVariantsvEXT(n2, shortBuffer);
        this.println("");
    }

    @Override
    public void glVariantsvEXT(int n2, short[] sArray, int n3) {
        this.printIndent();
        this.print("glVariantsvEXT(" + n2 + "," + this.dumpArray(sArray) + "," + n3 + ")");
        this.downstreamGL.glVariantsvEXT(n2, sArray, n3);
        this.println("");
    }

    @Override
    public void glVariantubvEXT(int n2, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glVariantubvEXT(" + n2 + "," + byteBuffer + ")");
        this.downstreamGL.glVariantubvEXT(n2, byteBuffer);
        this.println("");
    }

    @Override
    public void glVariantubvEXT(int n2, byte[] byArray, int n3) {
        this.printIndent();
        this.print("glVariantubvEXT(" + n2 + "," + this.dumpArray(byArray) + "," + n3 + ")");
        this.downstreamGL.glVariantubvEXT(n2, byArray, n3);
        this.println("");
    }

    @Override
    public void glVariantuivEXT(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glVariantuivEXT(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glVariantuivEXT(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glVariantuivEXT(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glVariantuivEXT(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glVariantuivEXT(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glVariantusvEXT(int n2, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVariantusvEXT(" + n2 + "," + shortBuffer + ")");
        this.downstreamGL.glVariantusvEXT(n2, shortBuffer);
        this.println("");
    }

    @Override
    public void glVariantusvEXT(int n2, short[] sArray, int n3) {
        this.printIndent();
        this.print("glVariantusvEXT(" + n2 + "," + this.dumpArray(sArray) + "," + n3 + ")");
        this.downstreamGL.glVariantusvEXT(n2, sArray, n3);
        this.println("");
    }

    @Override
    public void glVertex2d(double d2, double d3) {
        this.printIndent();
        this.print("glVertex2d(" + d2 + "," + d3 + ")");
        this.downstreamGL.glVertex2d(d2, d3);
        this.println("");
    }

    @Override
    public void glVertex2dv(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glVertex2dv(" + doubleBuffer + ")");
        this.downstreamGL.glVertex2dv(doubleBuffer);
        this.println("");
    }

    @Override
    public void glVertex2dv(double[] dArray, int n2) {
        this.printIndent();
        this.print("glVertex2dv(" + this.dumpArray(dArray) + "," + n2 + ")");
        this.downstreamGL.glVertex2dv(dArray, n2);
        this.println("");
    }

    @Override
    public void glVertex2f(float f2, float f3) {
        this.printIndent();
        this.print("glVertex2f(" + f2 + "," + f3 + ")");
        this.downstreamGL.glVertex2f(f2, f3);
        this.println("");
    }

    @Override
    public void glVertex2fv(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glVertex2fv(" + floatBuffer + ")");
        this.downstreamGL.glVertex2fv(floatBuffer);
        this.println("");
    }

    @Override
    public void glVertex2fv(float[] fArray, int n2) {
        this.printIndent();
        this.print("glVertex2fv(" + this.dumpArray(fArray) + "," + n2 + ")");
        this.downstreamGL.glVertex2fv(fArray, n2);
        this.println("");
    }

    @Override
    public void glVertex2hNV(short s2, short s3) {
        this.printIndent();
        this.print("glVertex2hNV(" + s2 + "," + s3 + ")");
        this.downstreamGL.glVertex2hNV(s2, s3);
        this.println("");
    }

    @Override
    public void glVertex2hvNV(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertex2hvNV(" + shortBuffer + ")");
        this.downstreamGL.glVertex2hvNV(shortBuffer);
        this.println("");
    }

    @Override
    public void glVertex2hvNV(short[] sArray, int n2) {
        this.printIndent();
        this.print("glVertex2hvNV(" + this.dumpArray(sArray) + "," + n2 + ")");
        this.downstreamGL.glVertex2hvNV(sArray, n2);
        this.println("");
    }

    @Override
    public void glVertex2i(int n2, int n3) {
        this.printIndent();
        this.print("glVertex2i(" + n2 + "," + n3 + ")");
        this.downstreamGL.glVertex2i(n2, n3);
        this.println("");
    }

    @Override
    public void glVertex2iv(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glVertex2iv(" + intBuffer + ")");
        this.downstreamGL.glVertex2iv(intBuffer);
        this.println("");
    }

    @Override
    public void glVertex2iv(int[] nArray, int n2) {
        this.printIndent();
        this.print("glVertex2iv(" + this.dumpArray(nArray) + "," + n2 + ")");
        this.downstreamGL.glVertex2iv(nArray, n2);
        this.println("");
    }

    @Override
    public void glVertex2s(short s2, short s3) {
        this.printIndent();
        this.print("glVertex2s(" + s2 + "," + s3 + ")");
        this.downstreamGL.glVertex2s(s2, s3);
        this.println("");
    }

    @Override
    public void glVertex2sv(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertex2sv(" + shortBuffer + ")");
        this.downstreamGL.glVertex2sv(shortBuffer);
        this.println("");
    }

    @Override
    public void glVertex2sv(short[] sArray, int n2) {
        this.printIndent();
        this.print("glVertex2sv(" + this.dumpArray(sArray) + "," + n2 + ")");
        this.downstreamGL.glVertex2sv(sArray, n2);
        this.println("");
    }

    @Override
    public void glVertex3d(double d2, double d3, double d4) {
        this.printIndent();
        this.print("glVertex3d(" + d2 + "," + d3 + "," + d4 + ")");
        this.downstreamGL.glVertex3d(d2, d3, d4);
        this.println("");
    }

    @Override
    public void glVertex3dv(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glVertex3dv(" + doubleBuffer + ")");
        this.downstreamGL.glVertex3dv(doubleBuffer);
        this.println("");
    }

    @Override
    public void glVertex3dv(double[] dArray, int n2) {
        this.printIndent();
        this.print("glVertex3dv(" + this.dumpArray(dArray) + "," + n2 + ")");
        this.downstreamGL.glVertex3dv(dArray, n2);
        this.println("");
    }

    @Override
    public void glVertex3f(float f2, float f3, float f4) {
        this.printIndent();
        this.print("glVertex3f(" + f2 + "," + f3 + "," + f4 + ")");
        this.downstreamGL.glVertex3f(f2, f3, f4);
        this.println("");
    }

    @Override
    public void glVertex3fv(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glVertex3fv(" + floatBuffer + ")");
        this.downstreamGL.glVertex3fv(floatBuffer);
        this.println("");
    }

    @Override
    public void glVertex3fv(float[] fArray, int n2) {
        this.printIndent();
        this.print("glVertex3fv(" + this.dumpArray(fArray) + "," + n2 + ")");
        this.downstreamGL.glVertex3fv(fArray, n2);
        this.println("");
    }

    @Override
    public void glVertex3hNV(short s2, short s3, short s4) {
        this.printIndent();
        this.print("glVertex3hNV(" + s2 + "," + s3 + "," + s4 + ")");
        this.downstreamGL.glVertex3hNV(s2, s3, s4);
        this.println("");
    }

    @Override
    public void glVertex3hvNV(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertex3hvNV(" + shortBuffer + ")");
        this.downstreamGL.glVertex3hvNV(shortBuffer);
        this.println("");
    }

    @Override
    public void glVertex3hvNV(short[] sArray, int n2) {
        this.printIndent();
        this.print("glVertex3hvNV(" + this.dumpArray(sArray) + "," + n2 + ")");
        this.downstreamGL.glVertex3hvNV(sArray, n2);
        this.println("");
    }

    @Override
    public void glVertex3i(int n2, int n3, int n4) {
        this.printIndent();
        this.print("glVertex3i(" + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glVertex3i(n2, n3, n4);
        this.println("");
    }

    @Override
    public void glVertex3iv(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glVertex3iv(" + intBuffer + ")");
        this.downstreamGL.glVertex3iv(intBuffer);
        this.println("");
    }

    @Override
    public void glVertex3iv(int[] nArray, int n2) {
        this.printIndent();
        this.print("glVertex3iv(" + this.dumpArray(nArray) + "," + n2 + ")");
        this.downstreamGL.glVertex3iv(nArray, n2);
        this.println("");
    }

    @Override
    public void glVertex3s(short s2, short s3, short s4) {
        this.printIndent();
        this.print("glVertex3s(" + s2 + "," + s3 + "," + s4 + ")");
        this.downstreamGL.glVertex3s(s2, s3, s4);
        this.println("");
    }

    @Override
    public void glVertex3sv(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertex3sv(" + shortBuffer + ")");
        this.downstreamGL.glVertex3sv(shortBuffer);
        this.println("");
    }

    @Override
    public void glVertex3sv(short[] sArray, int n2) {
        this.printIndent();
        this.print("glVertex3sv(" + this.dumpArray(sArray) + "," + n2 + ")");
        this.downstreamGL.glVertex3sv(sArray, n2);
        this.println("");
    }

    @Override
    public void glVertex4d(double d2, double d3, double d4, double d5) {
        this.printIndent();
        this.print("glVertex4d(" + d2 + "," + d3 + "," + d4 + "," + d5 + ")");
        this.downstreamGL.glVertex4d(d2, d3, d4, d5);
        this.println("");
    }

    @Override
    public void glVertex4dv(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glVertex4dv(" + doubleBuffer + ")");
        this.downstreamGL.glVertex4dv(doubleBuffer);
        this.println("");
    }

    @Override
    public void glVertex4dv(double[] dArray, int n2) {
        this.printIndent();
        this.print("glVertex4dv(" + this.dumpArray(dArray) + "," + n2 + ")");
        this.downstreamGL.glVertex4dv(dArray, n2);
        this.println("");
    }

    @Override
    public void glVertex4f(float f2, float f3, float f4, float f5) {
        this.printIndent();
        this.print("glVertex4f(" + f2 + "," + f3 + "," + f4 + "," + f5 + ")");
        this.downstreamGL.glVertex4f(f2, f3, f4, f5);
        this.println("");
    }

    @Override
    public void glVertex4fv(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glVertex4fv(" + floatBuffer + ")");
        this.downstreamGL.glVertex4fv(floatBuffer);
        this.println("");
    }

    @Override
    public void glVertex4fv(float[] fArray, int n2) {
        this.printIndent();
        this.print("glVertex4fv(" + this.dumpArray(fArray) + "," + n2 + ")");
        this.downstreamGL.glVertex4fv(fArray, n2);
        this.println("");
    }

    @Override
    public void glVertex4hNV(short s2, short s3, short s4, short s5) {
        this.printIndent();
        this.print("glVertex4hNV(" + s2 + "," + s3 + "," + s4 + "," + s5 + ")");
        this.downstreamGL.glVertex4hNV(s2, s3, s4, s5);
        this.println("");
    }

    @Override
    public void glVertex4hvNV(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertex4hvNV(" + shortBuffer + ")");
        this.downstreamGL.glVertex4hvNV(shortBuffer);
        this.println("");
    }

    @Override
    public void glVertex4hvNV(short[] sArray, int n2) {
        this.printIndent();
        this.print("glVertex4hvNV(" + this.dumpArray(sArray) + "," + n2 + ")");
        this.downstreamGL.glVertex4hvNV(sArray, n2);
        this.println("");
    }

    @Override
    public void glVertex4i(int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glVertex4i(" + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glVertex4i(n2, n3, n4, n5);
        this.println("");
    }

    @Override
    public void glVertex4iv(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glVertex4iv(" + intBuffer + ")");
        this.downstreamGL.glVertex4iv(intBuffer);
        this.println("");
    }

    @Override
    public void glVertex4iv(int[] nArray, int n2) {
        this.printIndent();
        this.print("glVertex4iv(" + this.dumpArray(nArray) + "," + n2 + ")");
        this.downstreamGL.glVertex4iv(nArray, n2);
        this.println("");
    }

    @Override
    public void glVertex4s(short s2, short s3, short s4, short s5) {
        this.printIndent();
        this.print("glVertex4s(" + s2 + "," + s3 + "," + s4 + "," + s5 + ")");
        this.downstreamGL.glVertex4s(s2, s3, s4, s5);
        this.println("");
    }

    @Override
    public void glVertex4sv(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertex4sv(" + shortBuffer + ")");
        this.downstreamGL.glVertex4sv(shortBuffer);
        this.println("");
    }

    @Override
    public void glVertex4sv(short[] sArray, int n2) {
        this.printIndent();
        this.print("glVertex4sv(" + this.dumpArray(sArray) + "," + n2 + ")");
        this.downstreamGL.glVertex4sv(sArray, n2);
        this.println("");
    }

    @Override
    public void glVertexArrayParameteriAPPLE(int n2, int n3) {
        this.printIndent();
        this.print("glVertexArrayParameteriAPPLE(" + n2 + "," + n3 + ")");
        this.downstreamGL.glVertexArrayParameteriAPPLE(n2, n3);
        this.println("");
    }

    @Override
    public void glVertexArrayRangeAPPLE(int n2, Buffer buffer) {
        this.printIndent();
        this.print("glVertexArrayRangeAPPLE(" + n2 + "," + buffer + ")");
        this.downstreamGL.glVertexArrayRangeAPPLE(n2, buffer);
        this.println("");
    }

    @Override
    public void glVertexArrayRangeNV(int n2, Buffer buffer) {
        this.printIndent();
        this.print("glVertexArrayRangeNV(" + n2 + "," + buffer + ")");
        this.downstreamGL.glVertexArrayRangeNV(n2, buffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib1d(int n2, double d2) {
        this.printIndent();
        this.print("glVertexAttrib1d(" + n2 + "," + d2 + ")");
        this.downstreamGL.glVertexAttrib1d(n2, d2);
        this.println("");
    }

    @Override
    public void glVertexAttrib1dARB(int n2, double d2) {
        this.printIndent();
        this.print("glVertexAttrib1dARB(" + n2 + "," + d2 + ")");
        this.downstreamGL.glVertexAttrib1dARB(n2, d2);
        this.println("");
    }

    @Override
    public void glVertexAttrib1dNV(int n2, double d2) {
        this.printIndent();
        this.print("glVertexAttrib1dNV(" + n2 + "," + d2 + ")");
        this.downstreamGL.glVertexAttrib1dNV(n2, d2);
        this.println("");
    }

    @Override
    public void glVertexAttrib1dv(int n2, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glVertexAttrib1dv(" + n2 + "," + doubleBuffer + ")");
        this.downstreamGL.glVertexAttrib1dv(n2, doubleBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib1dv(int n2, double[] dArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib1dv(" + n2 + "," + this.dumpArray(dArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib1dv(n2, dArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib1dvARB(int n2, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glVertexAttrib1dvARB(" + n2 + "," + doubleBuffer + ")");
        this.downstreamGL.glVertexAttrib1dvARB(n2, doubleBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib1dvARB(int n2, double[] dArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib1dvARB(" + n2 + "," + this.dumpArray(dArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib1dvARB(n2, dArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib1dvNV(int n2, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glVertexAttrib1dvNV(" + n2 + "," + doubleBuffer + ")");
        this.downstreamGL.glVertexAttrib1dvNV(n2, doubleBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib1dvNV(int n2, double[] dArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib1dvNV(" + n2 + "," + this.dumpArray(dArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib1dvNV(n2, dArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib1f(int n2, float f2) {
        this.printIndent();
        this.print("glVertexAttrib1f(" + n2 + "," + f2 + ")");
        this.downstreamGL.glVertexAttrib1f(n2, f2);
        this.println("");
    }

    @Override
    public void glVertexAttrib1fARB(int n2, float f2) {
        this.printIndent();
        this.print("glVertexAttrib1fARB(" + n2 + "," + f2 + ")");
        this.downstreamGL.glVertexAttrib1fARB(n2, f2);
        this.println("");
    }

    @Override
    public void glVertexAttrib1fNV(int n2, float f2) {
        this.printIndent();
        this.print("glVertexAttrib1fNV(" + n2 + "," + f2 + ")");
        this.downstreamGL.glVertexAttrib1fNV(n2, f2);
        this.println("");
    }

    @Override
    public void glVertexAttrib1fv(int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glVertexAttrib1fv(" + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glVertexAttrib1fv(n2, floatBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib1fv(int n2, float[] fArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib1fv(" + n2 + "," + this.dumpArray(fArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib1fv(n2, fArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib1fvARB(int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glVertexAttrib1fvARB(" + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glVertexAttrib1fvARB(n2, floatBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib1fvARB(int n2, float[] fArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib1fvARB(" + n2 + "," + this.dumpArray(fArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib1fvARB(n2, fArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib1fvNV(int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glVertexAttrib1fvNV(" + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glVertexAttrib1fvNV(n2, floatBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib1fvNV(int n2, float[] fArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib1fvNV(" + n2 + "," + this.dumpArray(fArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib1fvNV(n2, fArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib1hNV(int n2, short s2) {
        this.printIndent();
        this.print("glVertexAttrib1hNV(" + n2 + "," + s2 + ")");
        this.downstreamGL.glVertexAttrib1hNV(n2, s2);
        this.println("");
    }

    @Override
    public void glVertexAttrib1hvNV(int n2, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttrib1hvNV(" + n2 + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttrib1hvNV(n2, shortBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib1hvNV(int n2, short[] sArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib1hvNV(" + n2 + "," + this.dumpArray(sArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib1hvNV(n2, sArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib1s(int n2, short s2) {
        this.printIndent();
        this.print("glVertexAttrib1s(" + n2 + "," + s2 + ")");
        this.downstreamGL.glVertexAttrib1s(n2, s2);
        this.println("");
    }

    @Override
    public void glVertexAttrib1sARB(int n2, short s2) {
        this.printIndent();
        this.print("glVertexAttrib1sARB(" + n2 + "," + s2 + ")");
        this.downstreamGL.glVertexAttrib1sARB(n2, s2);
        this.println("");
    }

    @Override
    public void glVertexAttrib1sNV(int n2, short s2) {
        this.printIndent();
        this.print("glVertexAttrib1sNV(" + n2 + "," + s2 + ")");
        this.downstreamGL.glVertexAttrib1sNV(n2, s2);
        this.println("");
    }

    @Override
    public void glVertexAttrib1sv(int n2, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttrib1sv(" + n2 + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttrib1sv(n2, shortBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib1sv(int n2, short[] sArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib1sv(" + n2 + "," + this.dumpArray(sArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib1sv(n2, sArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib1svARB(int n2, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttrib1svARB(" + n2 + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttrib1svARB(n2, shortBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib1svARB(int n2, short[] sArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib1svARB(" + n2 + "," + this.dumpArray(sArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib1svARB(n2, sArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib1svNV(int n2, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttrib1svNV(" + n2 + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttrib1svNV(n2, shortBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib1svNV(int n2, short[] sArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib1svNV(" + n2 + "," + this.dumpArray(sArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib1svNV(n2, sArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib2d(int n2, double d2, double d3) {
        this.printIndent();
        this.print("glVertexAttrib2d(" + n2 + "," + d2 + "," + d3 + ")");
        this.downstreamGL.glVertexAttrib2d(n2, d2, d3);
        this.println("");
    }

    @Override
    public void glVertexAttrib2dARB(int n2, double d2, double d3) {
        this.printIndent();
        this.print("glVertexAttrib2dARB(" + n2 + "," + d2 + "," + d3 + ")");
        this.downstreamGL.glVertexAttrib2dARB(n2, d2, d3);
        this.println("");
    }

    @Override
    public void glVertexAttrib2dNV(int n2, double d2, double d3) {
        this.printIndent();
        this.print("glVertexAttrib2dNV(" + n2 + "," + d2 + "," + d3 + ")");
        this.downstreamGL.glVertexAttrib2dNV(n2, d2, d3);
        this.println("");
    }

    @Override
    public void glVertexAttrib2dv(int n2, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glVertexAttrib2dv(" + n2 + "," + doubleBuffer + ")");
        this.downstreamGL.glVertexAttrib2dv(n2, doubleBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib2dv(int n2, double[] dArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib2dv(" + n2 + "," + this.dumpArray(dArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib2dv(n2, dArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib2dvARB(int n2, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glVertexAttrib2dvARB(" + n2 + "," + doubleBuffer + ")");
        this.downstreamGL.glVertexAttrib2dvARB(n2, doubleBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib2dvARB(int n2, double[] dArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib2dvARB(" + n2 + "," + this.dumpArray(dArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib2dvARB(n2, dArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib2dvNV(int n2, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glVertexAttrib2dvNV(" + n2 + "," + doubleBuffer + ")");
        this.downstreamGL.glVertexAttrib2dvNV(n2, doubleBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib2dvNV(int n2, double[] dArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib2dvNV(" + n2 + "," + this.dumpArray(dArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib2dvNV(n2, dArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib2f(int n2, float f2, float f3) {
        this.printIndent();
        this.print("glVertexAttrib2f(" + n2 + "," + f2 + "," + f3 + ")");
        this.downstreamGL.glVertexAttrib2f(n2, f2, f3);
        this.println("");
    }

    @Override
    public void glVertexAttrib2fARB(int n2, float f2, float f3) {
        this.printIndent();
        this.print("glVertexAttrib2fARB(" + n2 + "," + f2 + "," + f3 + ")");
        this.downstreamGL.glVertexAttrib2fARB(n2, f2, f3);
        this.println("");
    }

    @Override
    public void glVertexAttrib2fNV(int n2, float f2, float f3) {
        this.printIndent();
        this.print("glVertexAttrib2fNV(" + n2 + "," + f2 + "," + f3 + ")");
        this.downstreamGL.glVertexAttrib2fNV(n2, f2, f3);
        this.println("");
    }

    @Override
    public void glVertexAttrib2fv(int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glVertexAttrib2fv(" + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glVertexAttrib2fv(n2, floatBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib2fv(int n2, float[] fArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib2fv(" + n2 + "," + this.dumpArray(fArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib2fv(n2, fArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib2fvARB(int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glVertexAttrib2fvARB(" + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glVertexAttrib2fvARB(n2, floatBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib2fvARB(int n2, float[] fArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib2fvARB(" + n2 + "," + this.dumpArray(fArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib2fvARB(n2, fArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib2fvNV(int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glVertexAttrib2fvNV(" + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glVertexAttrib2fvNV(n2, floatBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib2fvNV(int n2, float[] fArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib2fvNV(" + n2 + "," + this.dumpArray(fArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib2fvNV(n2, fArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib2hNV(int n2, short s2, short s3) {
        this.printIndent();
        this.print("glVertexAttrib2hNV(" + n2 + "," + s2 + "," + s3 + ")");
        this.downstreamGL.glVertexAttrib2hNV(n2, s2, s3);
        this.println("");
    }

    @Override
    public void glVertexAttrib2hvNV(int n2, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttrib2hvNV(" + n2 + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttrib2hvNV(n2, shortBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib2hvNV(int n2, short[] sArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib2hvNV(" + n2 + "," + this.dumpArray(sArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib2hvNV(n2, sArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib2s(int n2, short s2, short s3) {
        this.printIndent();
        this.print("glVertexAttrib2s(" + n2 + "," + s2 + "," + s3 + ")");
        this.downstreamGL.glVertexAttrib2s(n2, s2, s3);
        this.println("");
    }

    @Override
    public void glVertexAttrib2sARB(int n2, short s2, short s3) {
        this.printIndent();
        this.print("glVertexAttrib2sARB(" + n2 + "," + s2 + "," + s3 + ")");
        this.downstreamGL.glVertexAttrib2sARB(n2, s2, s3);
        this.println("");
    }

    @Override
    public void glVertexAttrib2sNV(int n2, short s2, short s3) {
        this.printIndent();
        this.print("glVertexAttrib2sNV(" + n2 + "," + s2 + "," + s3 + ")");
        this.downstreamGL.glVertexAttrib2sNV(n2, s2, s3);
        this.println("");
    }

    @Override
    public void glVertexAttrib2sv(int n2, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttrib2sv(" + n2 + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttrib2sv(n2, shortBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib2sv(int n2, short[] sArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib2sv(" + n2 + "," + this.dumpArray(sArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib2sv(n2, sArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib2svARB(int n2, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttrib2svARB(" + n2 + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttrib2svARB(n2, shortBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib2svARB(int n2, short[] sArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib2svARB(" + n2 + "," + this.dumpArray(sArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib2svARB(n2, sArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib2svNV(int n2, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttrib2svNV(" + n2 + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttrib2svNV(n2, shortBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib2svNV(int n2, short[] sArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib2svNV(" + n2 + "," + this.dumpArray(sArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib2svNV(n2, sArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib3d(int n2, double d2, double d3, double d4) {
        this.printIndent();
        this.print("glVertexAttrib3d(" + n2 + "," + d2 + "," + d3 + "," + d4 + ")");
        this.downstreamGL.glVertexAttrib3d(n2, d2, d3, d4);
        this.println("");
    }

    @Override
    public void glVertexAttrib3dARB(int n2, double d2, double d3, double d4) {
        this.printIndent();
        this.print("glVertexAttrib3dARB(" + n2 + "," + d2 + "," + d3 + "," + d4 + ")");
        this.downstreamGL.glVertexAttrib3dARB(n2, d2, d3, d4);
        this.println("");
    }

    @Override
    public void glVertexAttrib3dNV(int n2, double d2, double d3, double d4) {
        this.printIndent();
        this.print("glVertexAttrib3dNV(" + n2 + "," + d2 + "," + d3 + "," + d4 + ")");
        this.downstreamGL.glVertexAttrib3dNV(n2, d2, d3, d4);
        this.println("");
    }

    @Override
    public void glVertexAttrib3dv(int n2, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glVertexAttrib3dv(" + n2 + "," + doubleBuffer + ")");
        this.downstreamGL.glVertexAttrib3dv(n2, doubleBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib3dv(int n2, double[] dArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib3dv(" + n2 + "," + this.dumpArray(dArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib3dv(n2, dArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib3dvARB(int n2, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glVertexAttrib3dvARB(" + n2 + "," + doubleBuffer + ")");
        this.downstreamGL.glVertexAttrib3dvARB(n2, doubleBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib3dvARB(int n2, double[] dArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib3dvARB(" + n2 + "," + this.dumpArray(dArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib3dvARB(n2, dArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib3dvNV(int n2, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glVertexAttrib3dvNV(" + n2 + "," + doubleBuffer + ")");
        this.downstreamGL.glVertexAttrib3dvNV(n2, doubleBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib3dvNV(int n2, double[] dArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib3dvNV(" + n2 + "," + this.dumpArray(dArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib3dvNV(n2, dArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib3f(int n2, float f2, float f3, float f4) {
        this.printIndent();
        this.print("glVertexAttrib3f(" + n2 + "," + f2 + "," + f3 + "," + f4 + ")");
        this.downstreamGL.glVertexAttrib3f(n2, f2, f3, f4);
        this.println("");
    }

    @Override
    public void glVertexAttrib3fARB(int n2, float f2, float f3, float f4) {
        this.printIndent();
        this.print("glVertexAttrib3fARB(" + n2 + "," + f2 + "," + f3 + "," + f4 + ")");
        this.downstreamGL.glVertexAttrib3fARB(n2, f2, f3, f4);
        this.println("");
    }

    @Override
    public void glVertexAttrib3fNV(int n2, float f2, float f3, float f4) {
        this.printIndent();
        this.print("glVertexAttrib3fNV(" + n2 + "," + f2 + "," + f3 + "," + f4 + ")");
        this.downstreamGL.glVertexAttrib3fNV(n2, f2, f3, f4);
        this.println("");
    }

    @Override
    public void glVertexAttrib3fv(int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glVertexAttrib3fv(" + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glVertexAttrib3fv(n2, floatBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib3fv(int n2, float[] fArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib3fv(" + n2 + "," + this.dumpArray(fArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib3fv(n2, fArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib3fvARB(int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glVertexAttrib3fvARB(" + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glVertexAttrib3fvARB(n2, floatBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib3fvARB(int n2, float[] fArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib3fvARB(" + n2 + "," + this.dumpArray(fArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib3fvARB(n2, fArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib3fvNV(int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glVertexAttrib3fvNV(" + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glVertexAttrib3fvNV(n2, floatBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib3fvNV(int n2, float[] fArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib3fvNV(" + n2 + "," + this.dumpArray(fArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib3fvNV(n2, fArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib3hNV(int n2, short s2, short s3, short s4) {
        this.printIndent();
        this.print("glVertexAttrib3hNV(" + n2 + "," + s2 + "," + s3 + "," + s4 + ")");
        this.downstreamGL.glVertexAttrib3hNV(n2, s2, s3, s4);
        this.println("");
    }

    @Override
    public void glVertexAttrib3hvNV(int n2, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttrib3hvNV(" + n2 + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttrib3hvNV(n2, shortBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib3hvNV(int n2, short[] sArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib3hvNV(" + n2 + "," + this.dumpArray(sArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib3hvNV(n2, sArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib3s(int n2, short s2, short s3, short s4) {
        this.printIndent();
        this.print("glVertexAttrib3s(" + n2 + "," + s2 + "," + s3 + "," + s4 + ")");
        this.downstreamGL.glVertexAttrib3s(n2, s2, s3, s4);
        this.println("");
    }

    @Override
    public void glVertexAttrib3sARB(int n2, short s2, short s3, short s4) {
        this.printIndent();
        this.print("glVertexAttrib3sARB(" + n2 + "," + s2 + "," + s3 + "," + s4 + ")");
        this.downstreamGL.glVertexAttrib3sARB(n2, s2, s3, s4);
        this.println("");
    }

    @Override
    public void glVertexAttrib3sNV(int n2, short s2, short s3, short s4) {
        this.printIndent();
        this.print("glVertexAttrib3sNV(" + n2 + "," + s2 + "," + s3 + "," + s4 + ")");
        this.downstreamGL.glVertexAttrib3sNV(n2, s2, s3, s4);
        this.println("");
    }

    @Override
    public void glVertexAttrib3sv(int n2, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttrib3sv(" + n2 + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttrib3sv(n2, shortBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib3sv(int n2, short[] sArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib3sv(" + n2 + "," + this.dumpArray(sArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib3sv(n2, sArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib3svARB(int n2, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttrib3svARB(" + n2 + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttrib3svARB(n2, shortBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib3svARB(int n2, short[] sArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib3svARB(" + n2 + "," + this.dumpArray(sArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib3svARB(n2, sArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib3svNV(int n2, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttrib3svNV(" + n2 + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttrib3svNV(n2, shortBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib3svNV(int n2, short[] sArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib3svNV(" + n2 + "," + this.dumpArray(sArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib3svNV(n2, sArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib4Nbv(int n2, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4Nbv(" + n2 + "," + byteBuffer + ")");
        this.downstreamGL.glVertexAttrib4Nbv(n2, byteBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib4Nbv(int n2, byte[] byArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib4Nbv(" + n2 + "," + this.dumpArray(byArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib4Nbv(n2, byArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib4NbvARB(int n2, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4NbvARB(" + n2 + "," + byteBuffer + ")");
        this.downstreamGL.glVertexAttrib4NbvARB(n2, byteBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib4NbvARB(int n2, byte[] byArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib4NbvARB(" + n2 + "," + this.dumpArray(byArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib4NbvARB(n2, byArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib4Niv(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4Niv(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glVertexAttrib4Niv(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib4Niv(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib4Niv(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib4Niv(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib4NivARB(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4NivARB(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glVertexAttrib4NivARB(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib4NivARB(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib4NivARB(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib4NivARB(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib4Nsv(int n2, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4Nsv(" + n2 + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttrib4Nsv(n2, shortBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib4Nsv(int n2, short[] sArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib4Nsv(" + n2 + "," + this.dumpArray(sArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib4Nsv(n2, sArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib4NsvARB(int n2, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4NsvARB(" + n2 + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttrib4NsvARB(n2, shortBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib4NsvARB(int n2, short[] sArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib4NsvARB(" + n2 + "," + this.dumpArray(sArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib4NsvARB(n2, sArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib4Nub(int n2, byte by, byte by2, byte by3, byte by4) {
        this.printIndent();
        this.print("glVertexAttrib4Nub(" + n2 + "," + by + "," + by2 + "," + by3 + "," + by4 + ")");
        this.downstreamGL.glVertexAttrib4Nub(n2, by, by2, by3, by4);
        this.println("");
    }

    @Override
    public void glVertexAttrib4NubARB(int n2, byte by, byte by2, byte by3, byte by4) {
        this.printIndent();
        this.print("glVertexAttrib4NubARB(" + n2 + "," + by + "," + by2 + "," + by3 + "," + by4 + ")");
        this.downstreamGL.glVertexAttrib4NubARB(n2, by, by2, by3, by4);
        this.println("");
    }

    @Override
    public void glVertexAttrib4Nubv(int n2, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4Nubv(" + n2 + "," + byteBuffer + ")");
        this.downstreamGL.glVertexAttrib4Nubv(n2, byteBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib4Nubv(int n2, byte[] byArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib4Nubv(" + n2 + "," + this.dumpArray(byArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib4Nubv(n2, byArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib4NubvARB(int n2, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4NubvARB(" + n2 + "," + byteBuffer + ")");
        this.downstreamGL.glVertexAttrib4NubvARB(n2, byteBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib4NubvARB(int n2, byte[] byArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib4NubvARB(" + n2 + "," + this.dumpArray(byArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib4NubvARB(n2, byArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib4Nuiv(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4Nuiv(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glVertexAttrib4Nuiv(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib4Nuiv(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib4Nuiv(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib4Nuiv(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib4NuivARB(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4NuivARB(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glVertexAttrib4NuivARB(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib4NuivARB(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib4NuivARB(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib4NuivARB(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib4Nusv(int n2, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4Nusv(" + n2 + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttrib4Nusv(n2, shortBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib4Nusv(int n2, short[] sArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib4Nusv(" + n2 + "," + this.dumpArray(sArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib4Nusv(n2, sArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib4NusvARB(int n2, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4NusvARB(" + n2 + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttrib4NusvARB(n2, shortBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib4NusvARB(int n2, short[] sArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib4NusvARB(" + n2 + "," + this.dumpArray(sArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib4NusvARB(n2, sArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib4bv(int n2, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4bv(" + n2 + "," + byteBuffer + ")");
        this.downstreamGL.glVertexAttrib4bv(n2, byteBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib4bv(int n2, byte[] byArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib4bv(" + n2 + "," + this.dumpArray(byArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib4bv(n2, byArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib4bvARB(int n2, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4bvARB(" + n2 + "," + byteBuffer + ")");
        this.downstreamGL.glVertexAttrib4bvARB(n2, byteBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib4bvARB(int n2, byte[] byArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib4bvARB(" + n2 + "," + this.dumpArray(byArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib4bvARB(n2, byArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib4d(int n2, double d2, double d3, double d4, double d5) {
        this.printIndent();
        this.print("glVertexAttrib4d(" + n2 + "," + d2 + "," + d3 + "," + d4 + "," + d5 + ")");
        this.downstreamGL.glVertexAttrib4d(n2, d2, d3, d4, d5);
        this.println("");
    }

    @Override
    public void glVertexAttrib4dARB(int n2, double d2, double d3, double d4, double d5) {
        this.printIndent();
        this.print("glVertexAttrib4dARB(" + n2 + "," + d2 + "," + d3 + "," + d4 + "," + d5 + ")");
        this.downstreamGL.glVertexAttrib4dARB(n2, d2, d3, d4, d5);
        this.println("");
    }

    @Override
    public void glVertexAttrib4dNV(int n2, double d2, double d3, double d4, double d5) {
        this.printIndent();
        this.print("glVertexAttrib4dNV(" + n2 + "," + d2 + "," + d3 + "," + d4 + "," + d5 + ")");
        this.downstreamGL.glVertexAttrib4dNV(n2, d2, d3, d4, d5);
        this.println("");
    }

    @Override
    public void glVertexAttrib4dv(int n2, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4dv(" + n2 + "," + doubleBuffer + ")");
        this.downstreamGL.glVertexAttrib4dv(n2, doubleBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib4dv(int n2, double[] dArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib4dv(" + n2 + "," + this.dumpArray(dArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib4dv(n2, dArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib4dvARB(int n2, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4dvARB(" + n2 + "," + doubleBuffer + ")");
        this.downstreamGL.glVertexAttrib4dvARB(n2, doubleBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib4dvARB(int n2, double[] dArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib4dvARB(" + n2 + "," + this.dumpArray(dArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib4dvARB(n2, dArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib4dvNV(int n2, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4dvNV(" + n2 + "," + doubleBuffer + ")");
        this.downstreamGL.glVertexAttrib4dvNV(n2, doubleBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib4dvNV(int n2, double[] dArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib4dvNV(" + n2 + "," + this.dumpArray(dArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib4dvNV(n2, dArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib4f(int n2, float f2, float f3, float f4, float f5) {
        this.printIndent();
        this.print("glVertexAttrib4f(" + n2 + "," + f2 + "," + f3 + "," + f4 + "," + f5 + ")");
        this.downstreamGL.glVertexAttrib4f(n2, f2, f3, f4, f5);
        this.println("");
    }

    @Override
    public void glVertexAttrib4fARB(int n2, float f2, float f3, float f4, float f5) {
        this.printIndent();
        this.print("glVertexAttrib4fARB(" + n2 + "," + f2 + "," + f3 + "," + f4 + "," + f5 + ")");
        this.downstreamGL.glVertexAttrib4fARB(n2, f2, f3, f4, f5);
        this.println("");
    }

    @Override
    public void glVertexAttrib4fNV(int n2, float f2, float f3, float f4, float f5) {
        this.printIndent();
        this.print("glVertexAttrib4fNV(" + n2 + "," + f2 + "," + f3 + "," + f4 + "," + f5 + ")");
        this.downstreamGL.glVertexAttrib4fNV(n2, f2, f3, f4, f5);
        this.println("");
    }

    @Override
    public void glVertexAttrib4fv(int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4fv(" + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glVertexAttrib4fv(n2, floatBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib4fv(int n2, float[] fArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib4fv(" + n2 + "," + this.dumpArray(fArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib4fv(n2, fArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib4fvARB(int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4fvARB(" + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glVertexAttrib4fvARB(n2, floatBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib4fvARB(int n2, float[] fArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib4fvARB(" + n2 + "," + this.dumpArray(fArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib4fvARB(n2, fArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib4fvNV(int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4fvNV(" + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glVertexAttrib4fvNV(n2, floatBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib4fvNV(int n2, float[] fArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib4fvNV(" + n2 + "," + this.dumpArray(fArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib4fvNV(n2, fArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib4hNV(int n2, short s2, short s3, short s4, short s5) {
        this.printIndent();
        this.print("glVertexAttrib4hNV(" + n2 + "," + s2 + "," + s3 + "," + s4 + "," + s5 + ")");
        this.downstreamGL.glVertexAttrib4hNV(n2, s2, s3, s4, s5);
        this.println("");
    }

    @Override
    public void glVertexAttrib4hvNV(int n2, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4hvNV(" + n2 + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttrib4hvNV(n2, shortBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib4hvNV(int n2, short[] sArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib4hvNV(" + n2 + "," + this.dumpArray(sArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib4hvNV(n2, sArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib4iv(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4iv(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glVertexAttrib4iv(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib4iv(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib4iv(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib4iv(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib4ivARB(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4ivARB(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glVertexAttrib4ivARB(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib4ivARB(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib4ivARB(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib4ivARB(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib4s(int n2, short s2, short s3, short s4, short s5) {
        this.printIndent();
        this.print("glVertexAttrib4s(" + n2 + "," + s2 + "," + s3 + "," + s4 + "," + s5 + ")");
        this.downstreamGL.glVertexAttrib4s(n2, s2, s3, s4, s5);
        this.println("");
    }

    @Override
    public void glVertexAttrib4sARB(int n2, short s2, short s3, short s4, short s5) {
        this.printIndent();
        this.print("glVertexAttrib4sARB(" + n2 + "," + s2 + "," + s3 + "," + s4 + "," + s5 + ")");
        this.downstreamGL.glVertexAttrib4sARB(n2, s2, s3, s4, s5);
        this.println("");
    }

    @Override
    public void glVertexAttrib4sNV(int n2, short s2, short s3, short s4, short s5) {
        this.printIndent();
        this.print("glVertexAttrib4sNV(" + n2 + "," + s2 + "," + s3 + "," + s4 + "," + s5 + ")");
        this.downstreamGL.glVertexAttrib4sNV(n2, s2, s3, s4, s5);
        this.println("");
    }

    @Override
    public void glVertexAttrib4sv(int n2, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4sv(" + n2 + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttrib4sv(n2, shortBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib4sv(int n2, short[] sArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib4sv(" + n2 + "," + this.dumpArray(sArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib4sv(n2, sArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib4svARB(int n2, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4svARB(" + n2 + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttrib4svARB(n2, shortBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib4svARB(int n2, short[] sArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib4svARB(" + n2 + "," + this.dumpArray(sArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib4svARB(n2, sArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib4svNV(int n2, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4svNV(" + n2 + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttrib4svNV(n2, shortBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib4svNV(int n2, short[] sArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib4svNV(" + n2 + "," + this.dumpArray(sArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib4svNV(n2, sArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib4ubNV(int n2, byte by, byte by2, byte by3, byte by4) {
        this.printIndent();
        this.print("glVertexAttrib4ubNV(" + n2 + "," + by + "," + by2 + "," + by3 + "," + by4 + ")");
        this.downstreamGL.glVertexAttrib4ubNV(n2, by, by2, by3, by4);
        this.println("");
    }

    @Override
    public void glVertexAttrib4ubv(int n2, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4ubv(" + n2 + "," + byteBuffer + ")");
        this.downstreamGL.glVertexAttrib4ubv(n2, byteBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib4ubv(int n2, byte[] byArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib4ubv(" + n2 + "," + this.dumpArray(byArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib4ubv(n2, byArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib4ubvARB(int n2, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4ubvARB(" + n2 + "," + byteBuffer + ")");
        this.downstreamGL.glVertexAttrib4ubvARB(n2, byteBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib4ubvARB(int n2, byte[] byArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib4ubvARB(" + n2 + "," + this.dumpArray(byArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib4ubvARB(n2, byArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib4ubvNV(int n2, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4ubvNV(" + n2 + "," + byteBuffer + ")");
        this.downstreamGL.glVertexAttrib4ubvNV(n2, byteBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib4ubvNV(int n2, byte[] byArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib4ubvNV(" + n2 + "," + this.dumpArray(byArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib4ubvNV(n2, byArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib4uiv(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4uiv(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glVertexAttrib4uiv(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib4uiv(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib4uiv(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib4uiv(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib4uivARB(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4uivARB(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glVertexAttrib4uivARB(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib4uivARB(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib4uivARB(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib4uivARB(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib4usv(int n2, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4usv(" + n2 + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttrib4usv(n2, shortBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib4usv(int n2, short[] sArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib4usv(" + n2 + "," + this.dumpArray(sArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib4usv(n2, sArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttrib4usvARB(int n2, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttrib4usvARB(" + n2 + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttrib4usvARB(n2, shortBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttrib4usvARB(int n2, short[] sArray, int n3) {
        this.printIndent();
        this.print("glVertexAttrib4usvARB(" + n2 + "," + this.dumpArray(sArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttrib4usvARB(n2, sArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttribArrayObjectATI(int n2, int n3, int n4, boolean bl, int n5, int n6, int n7) {
        this.printIndent();
        this.print("glVertexAttribArrayObjectATI(" + n2 + "," + n3 + "," + n4 + "," + bl + "," + n5 + "," + n6 + "," + n7 + ")");
        this.downstreamGL.glVertexAttribArrayObjectATI(n2, n3, n4, bl, n5, n6, n7);
        this.println("");
    }

    @Override
    public void glVertexAttribI1iEXT(int n2, int n3) {
        this.printIndent();
        this.print("glVertexAttribI1iEXT(" + n2 + "," + n3 + ")");
        this.downstreamGL.glVertexAttribI1iEXT(n2, n3);
        this.println("");
    }

    @Override
    public void glVertexAttribI1ivEXT(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glVertexAttribI1ivEXT(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glVertexAttribI1ivEXT(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttribI1ivEXT(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glVertexAttribI1ivEXT(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttribI1ivEXT(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttribI1uiEXT(int n2, int n3) {
        this.printIndent();
        this.print("glVertexAttribI1uiEXT(" + n2 + "," + n3 + ")");
        this.downstreamGL.glVertexAttribI1uiEXT(n2, n3);
        this.println("");
    }

    @Override
    public void glVertexAttribI1uivEXT(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glVertexAttribI1uivEXT(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glVertexAttribI1uivEXT(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttribI1uivEXT(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glVertexAttribI1uivEXT(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttribI1uivEXT(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttribI2iEXT(int n2, int n3, int n4) {
        this.printIndent();
        this.print("glVertexAttribI2iEXT(" + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glVertexAttribI2iEXT(n2, n3, n4);
        this.println("");
    }

    @Override
    public void glVertexAttribI2ivEXT(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glVertexAttribI2ivEXT(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glVertexAttribI2ivEXT(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttribI2ivEXT(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glVertexAttribI2ivEXT(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttribI2ivEXT(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttribI2uiEXT(int n2, int n3, int n4) {
        this.printIndent();
        this.print("glVertexAttribI2uiEXT(" + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glVertexAttribI2uiEXT(n2, n3, n4);
        this.println("");
    }

    @Override
    public void glVertexAttribI2uivEXT(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glVertexAttribI2uivEXT(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glVertexAttribI2uivEXT(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttribI2uivEXT(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glVertexAttribI2uivEXT(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttribI2uivEXT(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttribI3iEXT(int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glVertexAttribI3iEXT(" + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glVertexAttribI3iEXT(n2, n3, n4, n5);
        this.println("");
    }

    @Override
    public void glVertexAttribI3ivEXT(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glVertexAttribI3ivEXT(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glVertexAttribI3ivEXT(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttribI3ivEXT(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glVertexAttribI3ivEXT(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttribI3ivEXT(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttribI3uiEXT(int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glVertexAttribI3uiEXT(" + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glVertexAttribI3uiEXT(n2, n3, n4, n5);
        this.println("");
    }

    @Override
    public void glVertexAttribI3uivEXT(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glVertexAttribI3uivEXT(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glVertexAttribI3uivEXT(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttribI3uivEXT(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glVertexAttribI3uivEXT(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttribI3uivEXT(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttribI4bvEXT(int n2, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glVertexAttribI4bvEXT(" + n2 + "," + byteBuffer + ")");
        this.downstreamGL.glVertexAttribI4bvEXT(n2, byteBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttribI4bvEXT(int n2, byte[] byArray, int n3) {
        this.printIndent();
        this.print("glVertexAttribI4bvEXT(" + n2 + "," + this.dumpArray(byArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttribI4bvEXT(n2, byArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttribI4iEXT(int n2, int n3, int n4, int n5, int n6) {
        this.printIndent();
        this.print("glVertexAttribI4iEXT(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + ")");
        this.downstreamGL.glVertexAttribI4iEXT(n2, n3, n4, n5, n6);
        this.println("");
    }

    @Override
    public void glVertexAttribI4ivEXT(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glVertexAttribI4ivEXT(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glVertexAttribI4ivEXT(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttribI4ivEXT(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glVertexAttribI4ivEXT(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttribI4ivEXT(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttribI4svEXT(int n2, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttribI4svEXT(" + n2 + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttribI4svEXT(n2, shortBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttribI4svEXT(int n2, short[] sArray, int n3) {
        this.printIndent();
        this.print("glVertexAttribI4svEXT(" + n2 + "," + this.dumpArray(sArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttribI4svEXT(n2, sArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttribI4ubvEXT(int n2, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glVertexAttribI4ubvEXT(" + n2 + "," + byteBuffer + ")");
        this.downstreamGL.glVertexAttribI4ubvEXT(n2, byteBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttribI4ubvEXT(int n2, byte[] byArray, int n3) {
        this.printIndent();
        this.print("glVertexAttribI4ubvEXT(" + n2 + "," + this.dumpArray(byArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttribI4ubvEXT(n2, byArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttribI4uiEXT(int n2, int n3, int n4, int n5, int n6) {
        this.printIndent();
        this.print("glVertexAttribI4uiEXT(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + ")");
        this.downstreamGL.glVertexAttribI4uiEXT(n2, n3, n4, n5, n6);
        this.println("");
    }

    @Override
    public void glVertexAttribI4uivEXT(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glVertexAttribI4uivEXT(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glVertexAttribI4uivEXT(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttribI4uivEXT(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glVertexAttribI4uivEXT(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttribI4uivEXT(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttribI4usvEXT(int n2, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttribI4usvEXT(" + n2 + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttribI4usvEXT(n2, shortBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttribI4usvEXT(int n2, short[] sArray, int n3) {
        this.printIndent();
        this.print("glVertexAttribI4usvEXT(" + n2 + "," + this.dumpArray(sArray) + "," + n3 + ")");
        this.downstreamGL.glVertexAttribI4usvEXT(n2, sArray, n3);
        this.println("");
    }

    @Override
    public void glVertexAttribIPointerEXT(int n2, int n3, int n4, int n5, Buffer buffer) {
        this.printIndent();
        this.print("glVertexAttribIPointerEXT(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + buffer + ")");
        this.downstreamGL.glVertexAttribIPointerEXT(n2, n3, n4, n5, buffer);
        this.println("");
    }

    @Override
    public void glVertexAttribPointer(int n2, int n3, int n4, boolean bl, int n5, Buffer buffer) {
        this.printIndent();
        this.print("glVertexAttribPointer(" + n2 + "," + n3 + "," + n4 + "," + bl + "," + n5 + "," + buffer + ")");
        this.downstreamGL.glVertexAttribPointer(n2, n3, n4, bl, n5, buffer);
        this.println("");
    }

    @Override
    public void glVertexAttribPointer(int n2, int n3, int n4, boolean bl, int n5, long l2) {
        this.printIndent();
        this.print("glVertexAttribPointer(" + n2 + "," + n3 + "," + n4 + "," + bl + "," + n5 + "," + l2 + ")");
        this.downstreamGL.glVertexAttribPointer(n2, n3, n4, bl, n5, l2);
        this.println("");
    }

    @Override
    public void glVertexAttribPointerARB(int n2, int n3, int n4, boolean bl, int n5, Buffer buffer) {
        this.printIndent();
        this.print("glVertexAttribPointerARB(" + n2 + "," + n3 + "," + n4 + "," + bl + "," + n5 + "," + buffer + ")");
        this.downstreamGL.glVertexAttribPointerARB(n2, n3, n4, bl, n5, buffer);
        this.println("");
    }

    @Override
    public void glVertexAttribPointerARB(int n2, int n3, int n4, boolean bl, int n5, long l2) {
        this.printIndent();
        this.print("glVertexAttribPointerARB(" + n2 + "," + n3 + "," + n4 + "," + bl + "," + n5 + "," + l2 + ")");
        this.downstreamGL.glVertexAttribPointerARB(n2, n3, n4, bl, n5, l2);
        this.println("");
    }

    @Override
    public void glVertexAttribPointerNV(int n2, int n3, int n4, int n5, Buffer buffer) {
        this.printIndent();
        this.print("glVertexAttribPointerNV(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + buffer + ")");
        this.downstreamGL.glVertexAttribPointerNV(n2, n3, n4, n5, buffer);
        this.println("");
    }

    @Override
    public void glVertexAttribPointerNV(int n2, int n3, int n4, int n5, long l2) {
        this.printIndent();
        this.print("glVertexAttribPointerNV(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + l2 + ")");
        this.downstreamGL.glVertexAttribPointerNV(n2, n3, n4, n5, l2);
        this.println("");
    }

    @Override
    public void glVertexAttribs1dvNV(int n2, int n3, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glVertexAttribs1dvNV(" + n2 + "," + n3 + "," + doubleBuffer + ")");
        this.downstreamGL.glVertexAttribs1dvNV(n2, n3, doubleBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttribs1dvNV(int n2, int n3, double[] dArray, int n4) {
        this.printIndent();
        this.print("glVertexAttribs1dvNV(" + n2 + "," + n3 + "," + this.dumpArray(dArray) + "," + n4 + ")");
        this.downstreamGL.glVertexAttribs1dvNV(n2, n3, dArray, n4);
        this.println("");
    }

    @Override
    public void glVertexAttribs1fvNV(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glVertexAttribs1fvNV(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glVertexAttribs1fvNV(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttribs1fvNV(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glVertexAttribs1fvNV(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glVertexAttribs1fvNV(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glVertexAttribs1hvNV(int n2, int n3, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttribs1hvNV(" + n2 + "," + n3 + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttribs1hvNV(n2, n3, shortBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttribs1hvNV(int n2, int n3, short[] sArray, int n4) {
        this.printIndent();
        this.print("glVertexAttribs1hvNV(" + n2 + "," + n3 + "," + this.dumpArray(sArray) + "," + n4 + ")");
        this.downstreamGL.glVertexAttribs1hvNV(n2, n3, sArray, n4);
        this.println("");
    }

    @Override
    public void glVertexAttribs1svNV(int n2, int n3, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttribs1svNV(" + n2 + "," + n3 + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttribs1svNV(n2, n3, shortBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttribs1svNV(int n2, int n3, short[] sArray, int n4) {
        this.printIndent();
        this.print("glVertexAttribs1svNV(" + n2 + "," + n3 + "," + this.dumpArray(sArray) + "," + n4 + ")");
        this.downstreamGL.glVertexAttribs1svNV(n2, n3, sArray, n4);
        this.println("");
    }

    @Override
    public void glVertexAttribs2dvNV(int n2, int n3, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glVertexAttribs2dvNV(" + n2 + "," + n3 + "," + doubleBuffer + ")");
        this.downstreamGL.glVertexAttribs2dvNV(n2, n3, doubleBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttribs2dvNV(int n2, int n3, double[] dArray, int n4) {
        this.printIndent();
        this.print("glVertexAttribs2dvNV(" + n2 + "," + n3 + "," + this.dumpArray(dArray) + "," + n4 + ")");
        this.downstreamGL.glVertexAttribs2dvNV(n2, n3, dArray, n4);
        this.println("");
    }

    @Override
    public void glVertexAttribs2fvNV(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glVertexAttribs2fvNV(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glVertexAttribs2fvNV(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttribs2fvNV(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glVertexAttribs2fvNV(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glVertexAttribs2fvNV(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glVertexAttribs2hvNV(int n2, int n3, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttribs2hvNV(" + n2 + "," + n3 + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttribs2hvNV(n2, n3, shortBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttribs2hvNV(int n2, int n3, short[] sArray, int n4) {
        this.printIndent();
        this.print("glVertexAttribs2hvNV(" + n2 + "," + n3 + "," + this.dumpArray(sArray) + "," + n4 + ")");
        this.downstreamGL.glVertexAttribs2hvNV(n2, n3, sArray, n4);
        this.println("");
    }

    @Override
    public void glVertexAttribs2svNV(int n2, int n3, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttribs2svNV(" + n2 + "," + n3 + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttribs2svNV(n2, n3, shortBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttribs2svNV(int n2, int n3, short[] sArray, int n4) {
        this.printIndent();
        this.print("glVertexAttribs2svNV(" + n2 + "," + n3 + "," + this.dumpArray(sArray) + "," + n4 + ")");
        this.downstreamGL.glVertexAttribs2svNV(n2, n3, sArray, n4);
        this.println("");
    }

    @Override
    public void glVertexAttribs3dvNV(int n2, int n3, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glVertexAttribs3dvNV(" + n2 + "," + n3 + "," + doubleBuffer + ")");
        this.downstreamGL.glVertexAttribs3dvNV(n2, n3, doubleBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttribs3dvNV(int n2, int n3, double[] dArray, int n4) {
        this.printIndent();
        this.print("glVertexAttribs3dvNV(" + n2 + "," + n3 + "," + this.dumpArray(dArray) + "," + n4 + ")");
        this.downstreamGL.glVertexAttribs3dvNV(n2, n3, dArray, n4);
        this.println("");
    }

    @Override
    public void glVertexAttribs3fvNV(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glVertexAttribs3fvNV(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glVertexAttribs3fvNV(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttribs3fvNV(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glVertexAttribs3fvNV(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glVertexAttribs3fvNV(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glVertexAttribs3hvNV(int n2, int n3, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttribs3hvNV(" + n2 + "," + n3 + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttribs3hvNV(n2, n3, shortBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttribs3hvNV(int n2, int n3, short[] sArray, int n4) {
        this.printIndent();
        this.print("glVertexAttribs3hvNV(" + n2 + "," + n3 + "," + this.dumpArray(sArray) + "," + n4 + ")");
        this.downstreamGL.glVertexAttribs3hvNV(n2, n3, sArray, n4);
        this.println("");
    }

    @Override
    public void glVertexAttribs3svNV(int n2, int n3, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttribs3svNV(" + n2 + "," + n3 + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttribs3svNV(n2, n3, shortBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttribs3svNV(int n2, int n3, short[] sArray, int n4) {
        this.printIndent();
        this.print("glVertexAttribs3svNV(" + n2 + "," + n3 + "," + this.dumpArray(sArray) + "," + n4 + ")");
        this.downstreamGL.glVertexAttribs3svNV(n2, n3, sArray, n4);
        this.println("");
    }

    @Override
    public void glVertexAttribs4dvNV(int n2, int n3, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glVertexAttribs4dvNV(" + n2 + "," + n3 + "," + doubleBuffer + ")");
        this.downstreamGL.glVertexAttribs4dvNV(n2, n3, doubleBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttribs4dvNV(int n2, int n3, double[] dArray, int n4) {
        this.printIndent();
        this.print("glVertexAttribs4dvNV(" + n2 + "," + n3 + "," + this.dumpArray(dArray) + "," + n4 + ")");
        this.downstreamGL.glVertexAttribs4dvNV(n2, n3, dArray, n4);
        this.println("");
    }

    @Override
    public void glVertexAttribs4fvNV(int n2, int n3, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glVertexAttribs4fvNV(" + n2 + "," + n3 + "," + floatBuffer + ")");
        this.downstreamGL.glVertexAttribs4fvNV(n2, n3, floatBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttribs4fvNV(int n2, int n3, float[] fArray, int n4) {
        this.printIndent();
        this.print("glVertexAttribs4fvNV(" + n2 + "," + n3 + "," + this.dumpArray(fArray) + "," + n4 + ")");
        this.downstreamGL.glVertexAttribs4fvNV(n2, n3, fArray, n4);
        this.println("");
    }

    @Override
    public void glVertexAttribs4hvNV(int n2, int n3, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttribs4hvNV(" + n2 + "," + n3 + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttribs4hvNV(n2, n3, shortBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttribs4hvNV(int n2, int n3, short[] sArray, int n4) {
        this.printIndent();
        this.print("glVertexAttribs4hvNV(" + n2 + "," + n3 + "," + this.dumpArray(sArray) + "," + n4 + ")");
        this.downstreamGL.glVertexAttribs4hvNV(n2, n3, sArray, n4);
        this.println("");
    }

    @Override
    public void glVertexAttribs4svNV(int n2, int n3, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexAttribs4svNV(" + n2 + "," + n3 + "," + shortBuffer + ")");
        this.downstreamGL.glVertexAttribs4svNV(n2, n3, shortBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttribs4svNV(int n2, int n3, short[] sArray, int n4) {
        this.printIndent();
        this.print("glVertexAttribs4svNV(" + n2 + "," + n3 + "," + this.dumpArray(sArray) + "," + n4 + ")");
        this.downstreamGL.glVertexAttribs4svNV(n2, n3, sArray, n4);
        this.println("");
    }

    @Override
    public void glVertexAttribs4ubvNV(int n2, int n3, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glVertexAttribs4ubvNV(" + n2 + "," + n3 + "," + byteBuffer + ")");
        this.downstreamGL.glVertexAttribs4ubvNV(n2, n3, byteBuffer);
        this.println("");
    }

    @Override
    public void glVertexAttribs4ubvNV(int n2, int n3, byte[] byArray, int n4) {
        this.printIndent();
        this.print("glVertexAttribs4ubvNV(" + n2 + "," + n3 + "," + this.dumpArray(byArray) + "," + n4 + ")");
        this.downstreamGL.glVertexAttribs4ubvNV(n2, n3, byArray, n4);
        this.println("");
    }

    @Override
    public void glVertexBlendARB(int n2) {
        this.printIndent();
        this.print("glVertexBlendARB(" + n2 + ")");
        this.downstreamGL.glVertexBlendARB(n2);
        this.println("");
    }

    @Override
    public void glVertexBlendEnvfATI(int n2, float f2) {
        this.printIndent();
        this.print("glVertexBlendEnvfATI(" + n2 + "," + f2 + ")");
        this.downstreamGL.glVertexBlendEnvfATI(n2, f2);
        this.println("");
    }

    @Override
    public void glVertexBlendEnviATI(int n2, int n3) {
        this.printIndent();
        this.print("glVertexBlendEnviATI(" + n2 + "," + n3 + ")");
        this.downstreamGL.glVertexBlendEnviATI(n2, n3);
        this.println("");
    }

    @Override
    public void glVertexPointer(int n2, int n3, int n4, Buffer buffer) {
        this.printIndent();
        this.print("glVertexPointer(" + n2 + "," + n3 + "," + n4 + "," + buffer + ")");
        this.downstreamGL.glVertexPointer(n2, n3, n4, buffer);
        this.println("");
    }

    @Override
    public void glVertexPointer(int n2, int n3, int n4, long l2) {
        this.printIndent();
        this.print("glVertexPointer(" + n2 + "," + n3 + "," + n4 + "," + l2 + ")");
        this.downstreamGL.glVertexPointer(n2, n3, n4, l2);
        this.println("");
    }

    @Override
    public void glVertexStream1dATI(int n2, double d2) {
        this.printIndent();
        this.print("glVertexStream1dATI(" + n2 + "," + d2 + ")");
        this.downstreamGL.glVertexStream1dATI(n2, d2);
        this.println("");
    }

    @Override
    public void glVertexStream1dvATI(int n2, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glVertexStream1dvATI(" + n2 + "," + doubleBuffer + ")");
        this.downstreamGL.glVertexStream1dvATI(n2, doubleBuffer);
        this.println("");
    }

    @Override
    public void glVertexStream1dvATI(int n2, double[] dArray, int n3) {
        this.printIndent();
        this.print("glVertexStream1dvATI(" + n2 + "," + this.dumpArray(dArray) + "," + n3 + ")");
        this.downstreamGL.glVertexStream1dvATI(n2, dArray, n3);
        this.println("");
    }

    @Override
    public void glVertexStream1fATI(int n2, float f2) {
        this.printIndent();
        this.print("glVertexStream1fATI(" + n2 + "," + f2 + ")");
        this.downstreamGL.glVertexStream1fATI(n2, f2);
        this.println("");
    }

    @Override
    public void glVertexStream1fvATI(int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glVertexStream1fvATI(" + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glVertexStream1fvATI(n2, floatBuffer);
        this.println("");
    }

    @Override
    public void glVertexStream1fvATI(int n2, float[] fArray, int n3) {
        this.printIndent();
        this.print("glVertexStream1fvATI(" + n2 + "," + this.dumpArray(fArray) + "," + n3 + ")");
        this.downstreamGL.glVertexStream1fvATI(n2, fArray, n3);
        this.println("");
    }

    @Override
    public void glVertexStream1iATI(int n2, int n3) {
        this.printIndent();
        this.print("glVertexStream1iATI(" + n2 + "," + n3 + ")");
        this.downstreamGL.glVertexStream1iATI(n2, n3);
        this.println("");
    }

    @Override
    public void glVertexStream1ivATI(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glVertexStream1ivATI(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glVertexStream1ivATI(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glVertexStream1ivATI(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glVertexStream1ivATI(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glVertexStream1ivATI(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glVertexStream1sATI(int n2, short s2) {
        this.printIndent();
        this.print("glVertexStream1sATI(" + n2 + "," + s2 + ")");
        this.downstreamGL.glVertexStream1sATI(n2, s2);
        this.println("");
    }

    @Override
    public void glVertexStream1svATI(int n2, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexStream1svATI(" + n2 + "," + shortBuffer + ")");
        this.downstreamGL.glVertexStream1svATI(n2, shortBuffer);
        this.println("");
    }

    @Override
    public void glVertexStream1svATI(int n2, short[] sArray, int n3) {
        this.printIndent();
        this.print("glVertexStream1svATI(" + n2 + "," + this.dumpArray(sArray) + "," + n3 + ")");
        this.downstreamGL.glVertexStream1svATI(n2, sArray, n3);
        this.println("");
    }

    @Override
    public void glVertexStream2dATI(int n2, double d2, double d3) {
        this.printIndent();
        this.print("glVertexStream2dATI(" + n2 + "," + d2 + "," + d3 + ")");
        this.downstreamGL.glVertexStream2dATI(n2, d2, d3);
        this.println("");
    }

    @Override
    public void glVertexStream2dvATI(int n2, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glVertexStream2dvATI(" + n2 + "," + doubleBuffer + ")");
        this.downstreamGL.glVertexStream2dvATI(n2, doubleBuffer);
        this.println("");
    }

    @Override
    public void glVertexStream2dvATI(int n2, double[] dArray, int n3) {
        this.printIndent();
        this.print("glVertexStream2dvATI(" + n2 + "," + this.dumpArray(dArray) + "," + n3 + ")");
        this.downstreamGL.glVertexStream2dvATI(n2, dArray, n3);
        this.println("");
    }

    @Override
    public void glVertexStream2fATI(int n2, float f2, float f3) {
        this.printIndent();
        this.print("glVertexStream2fATI(" + n2 + "," + f2 + "," + f3 + ")");
        this.downstreamGL.glVertexStream2fATI(n2, f2, f3);
        this.println("");
    }

    @Override
    public void glVertexStream2fvATI(int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glVertexStream2fvATI(" + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glVertexStream2fvATI(n2, floatBuffer);
        this.println("");
    }

    @Override
    public void glVertexStream2fvATI(int n2, float[] fArray, int n3) {
        this.printIndent();
        this.print("glVertexStream2fvATI(" + n2 + "," + this.dumpArray(fArray) + "," + n3 + ")");
        this.downstreamGL.glVertexStream2fvATI(n2, fArray, n3);
        this.println("");
    }

    @Override
    public void glVertexStream2iATI(int n2, int n3, int n4) {
        this.printIndent();
        this.print("glVertexStream2iATI(" + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glVertexStream2iATI(n2, n3, n4);
        this.println("");
    }

    @Override
    public void glVertexStream2ivATI(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glVertexStream2ivATI(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glVertexStream2ivATI(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glVertexStream2ivATI(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glVertexStream2ivATI(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glVertexStream2ivATI(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glVertexStream2sATI(int n2, short s2, short s3) {
        this.printIndent();
        this.print("glVertexStream2sATI(" + n2 + "," + s2 + "," + s3 + ")");
        this.downstreamGL.glVertexStream2sATI(n2, s2, s3);
        this.println("");
    }

    @Override
    public void glVertexStream2svATI(int n2, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexStream2svATI(" + n2 + "," + shortBuffer + ")");
        this.downstreamGL.glVertexStream2svATI(n2, shortBuffer);
        this.println("");
    }

    @Override
    public void glVertexStream2svATI(int n2, short[] sArray, int n3) {
        this.printIndent();
        this.print("glVertexStream2svATI(" + n2 + "," + this.dumpArray(sArray) + "," + n3 + ")");
        this.downstreamGL.glVertexStream2svATI(n2, sArray, n3);
        this.println("");
    }

    @Override
    public void glVertexStream3dATI(int n2, double d2, double d3, double d4) {
        this.printIndent();
        this.print("glVertexStream3dATI(" + n2 + "," + d2 + "," + d3 + "," + d4 + ")");
        this.downstreamGL.glVertexStream3dATI(n2, d2, d3, d4);
        this.println("");
    }

    @Override
    public void glVertexStream3dvATI(int n2, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glVertexStream3dvATI(" + n2 + "," + doubleBuffer + ")");
        this.downstreamGL.glVertexStream3dvATI(n2, doubleBuffer);
        this.println("");
    }

    @Override
    public void glVertexStream3dvATI(int n2, double[] dArray, int n3) {
        this.printIndent();
        this.print("glVertexStream3dvATI(" + n2 + "," + this.dumpArray(dArray) + "," + n3 + ")");
        this.downstreamGL.glVertexStream3dvATI(n2, dArray, n3);
        this.println("");
    }

    @Override
    public void glVertexStream3fATI(int n2, float f2, float f3, float f4) {
        this.printIndent();
        this.print("glVertexStream3fATI(" + n2 + "," + f2 + "," + f3 + "," + f4 + ")");
        this.downstreamGL.glVertexStream3fATI(n2, f2, f3, f4);
        this.println("");
    }

    @Override
    public void glVertexStream3fvATI(int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glVertexStream3fvATI(" + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glVertexStream3fvATI(n2, floatBuffer);
        this.println("");
    }

    @Override
    public void glVertexStream3fvATI(int n2, float[] fArray, int n3) {
        this.printIndent();
        this.print("glVertexStream3fvATI(" + n2 + "," + this.dumpArray(fArray) + "," + n3 + ")");
        this.downstreamGL.glVertexStream3fvATI(n2, fArray, n3);
        this.println("");
    }

    @Override
    public void glVertexStream3iATI(int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glVertexStream3iATI(" + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glVertexStream3iATI(n2, n3, n4, n5);
        this.println("");
    }

    @Override
    public void glVertexStream3ivATI(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glVertexStream3ivATI(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glVertexStream3ivATI(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glVertexStream3ivATI(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glVertexStream3ivATI(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glVertexStream3ivATI(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glVertexStream3sATI(int n2, short s2, short s3, short s4) {
        this.printIndent();
        this.print("glVertexStream3sATI(" + n2 + "," + s2 + "," + s3 + "," + s4 + ")");
        this.downstreamGL.glVertexStream3sATI(n2, s2, s3, s4);
        this.println("");
    }

    @Override
    public void glVertexStream3svATI(int n2, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexStream3svATI(" + n2 + "," + shortBuffer + ")");
        this.downstreamGL.glVertexStream3svATI(n2, shortBuffer);
        this.println("");
    }

    @Override
    public void glVertexStream3svATI(int n2, short[] sArray, int n3) {
        this.printIndent();
        this.print("glVertexStream3svATI(" + n2 + "," + this.dumpArray(sArray) + "," + n3 + ")");
        this.downstreamGL.glVertexStream3svATI(n2, sArray, n3);
        this.println("");
    }

    @Override
    public void glVertexStream4dATI(int n2, double d2, double d3, double d4, double d5) {
        this.printIndent();
        this.print("glVertexStream4dATI(" + n2 + "," + d2 + "," + d3 + "," + d4 + "," + d5 + ")");
        this.downstreamGL.glVertexStream4dATI(n2, d2, d3, d4, d5);
        this.println("");
    }

    @Override
    public void glVertexStream4dvATI(int n2, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glVertexStream4dvATI(" + n2 + "," + doubleBuffer + ")");
        this.downstreamGL.glVertexStream4dvATI(n2, doubleBuffer);
        this.println("");
    }

    @Override
    public void glVertexStream4dvATI(int n2, double[] dArray, int n3) {
        this.printIndent();
        this.print("glVertexStream4dvATI(" + n2 + "," + this.dumpArray(dArray) + "," + n3 + ")");
        this.downstreamGL.glVertexStream4dvATI(n2, dArray, n3);
        this.println("");
    }

    @Override
    public void glVertexStream4fATI(int n2, float f2, float f3, float f4, float f5) {
        this.printIndent();
        this.print("glVertexStream4fATI(" + n2 + "," + f2 + "," + f3 + "," + f4 + "," + f5 + ")");
        this.downstreamGL.glVertexStream4fATI(n2, f2, f3, f4, f5);
        this.println("");
    }

    @Override
    public void glVertexStream4fvATI(int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glVertexStream4fvATI(" + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glVertexStream4fvATI(n2, floatBuffer);
        this.println("");
    }

    @Override
    public void glVertexStream4fvATI(int n2, float[] fArray, int n3) {
        this.printIndent();
        this.print("glVertexStream4fvATI(" + n2 + "," + this.dumpArray(fArray) + "," + n3 + ")");
        this.downstreamGL.glVertexStream4fvATI(n2, fArray, n3);
        this.println("");
    }

    @Override
    public void glVertexStream4iATI(int n2, int n3, int n4, int n5, int n6) {
        this.printIndent();
        this.print("glVertexStream4iATI(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + ")");
        this.downstreamGL.glVertexStream4iATI(n2, n3, n4, n5, n6);
        this.println("");
    }

    @Override
    public void glVertexStream4ivATI(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glVertexStream4ivATI(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glVertexStream4ivATI(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glVertexStream4ivATI(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glVertexStream4ivATI(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glVertexStream4ivATI(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glVertexStream4sATI(int n2, short s2, short s3, short s4, short s5) {
        this.printIndent();
        this.print("glVertexStream4sATI(" + n2 + "," + s2 + "," + s3 + "," + s4 + "," + s5 + ")");
        this.downstreamGL.glVertexStream4sATI(n2, s2, s3, s4, s5);
        this.println("");
    }

    @Override
    public void glVertexStream4svATI(int n2, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexStream4svATI(" + n2 + "," + shortBuffer + ")");
        this.downstreamGL.glVertexStream4svATI(n2, shortBuffer);
        this.println("");
    }

    @Override
    public void glVertexStream4svATI(int n2, short[] sArray, int n3) {
        this.printIndent();
        this.print("glVertexStream4svATI(" + n2 + "," + this.dumpArray(sArray) + "," + n3 + ")");
        this.downstreamGL.glVertexStream4svATI(n2, sArray, n3);
        this.println("");
    }

    @Override
    public void glVertexWeightPointerEXT(int n2, int n3, int n4, Buffer buffer) {
        this.printIndent();
        this.print("glVertexWeightPointerEXT(" + n2 + "," + n3 + "," + n4 + "," + buffer + ")");
        this.downstreamGL.glVertexWeightPointerEXT(n2, n3, n4, buffer);
        this.println("");
    }

    @Override
    public void glVertexWeightPointerEXT(int n2, int n3, int n4, long l2) {
        this.printIndent();
        this.print("glVertexWeightPointerEXT(" + n2 + "," + n3 + "," + n4 + "," + l2 + ")");
        this.downstreamGL.glVertexWeightPointerEXT(n2, n3, n4, l2);
        this.println("");
    }

    @Override
    public void glVertexWeightfEXT(float f2) {
        this.printIndent();
        this.print("glVertexWeightfEXT(" + f2 + ")");
        this.downstreamGL.glVertexWeightfEXT(f2);
        this.println("");
    }

    @Override
    public void glVertexWeightfvEXT(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glVertexWeightfvEXT(" + floatBuffer + ")");
        this.downstreamGL.glVertexWeightfvEXT(floatBuffer);
        this.println("");
    }

    @Override
    public void glVertexWeightfvEXT(float[] fArray, int n2) {
        this.printIndent();
        this.print("glVertexWeightfvEXT(" + this.dumpArray(fArray) + "," + n2 + ")");
        this.downstreamGL.glVertexWeightfvEXT(fArray, n2);
        this.println("");
    }

    @Override
    public void glVertexWeighthNV(short s2) {
        this.printIndent();
        this.print("glVertexWeighthNV(" + s2 + ")");
        this.downstreamGL.glVertexWeighthNV(s2);
        this.println("");
    }

    @Override
    public void glVertexWeighthvNV(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glVertexWeighthvNV(" + shortBuffer + ")");
        this.downstreamGL.glVertexWeighthvNV(shortBuffer);
        this.println("");
    }

    @Override
    public void glVertexWeighthvNV(short[] sArray, int n2) {
        this.printIndent();
        this.print("glVertexWeighthvNV(" + this.dumpArray(sArray) + "," + n2 + ")");
        this.downstreamGL.glVertexWeighthvNV(sArray, n2);
        this.println("");
    }

    @Override
    public void glViewport(int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glViewport(" + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glViewport(n2, n3, n4, n5);
        this.println("");
    }

    @Override
    public void glWeightPointerARB(int n2, int n3, int n4, Buffer buffer) {
        this.printIndent();
        this.print("glWeightPointerARB(" + n2 + "," + n3 + "," + n4 + "," + buffer + ")");
        this.downstreamGL.glWeightPointerARB(n2, n3, n4, buffer);
        this.println("");
    }

    @Override
    public void glWeightPointerARB(int n2, int n3, int n4, long l2) {
        this.printIndent();
        this.print("glWeightPointerARB(" + n2 + "," + n3 + "," + n4 + "," + l2 + ")");
        this.downstreamGL.glWeightPointerARB(n2, n3, n4, l2);
        this.println("");
    }

    @Override
    public void glWeightbvARB(int n2, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glWeightbvARB(" + n2 + "," + byteBuffer + ")");
        this.downstreamGL.glWeightbvARB(n2, byteBuffer);
        this.println("");
    }

    @Override
    public void glWeightbvARB(int n2, byte[] byArray, int n3) {
        this.printIndent();
        this.print("glWeightbvARB(" + n2 + "," + this.dumpArray(byArray) + "," + n3 + ")");
        this.downstreamGL.glWeightbvARB(n2, byArray, n3);
        this.println("");
    }

    @Override
    public void glWeightdvARB(int n2, DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glWeightdvARB(" + n2 + "," + doubleBuffer + ")");
        this.downstreamGL.glWeightdvARB(n2, doubleBuffer);
        this.println("");
    }

    @Override
    public void glWeightdvARB(int n2, double[] dArray, int n3) {
        this.printIndent();
        this.print("glWeightdvARB(" + n2 + "," + this.dumpArray(dArray) + "," + n3 + ")");
        this.downstreamGL.glWeightdvARB(n2, dArray, n3);
        this.println("");
    }

    @Override
    public void glWeightfvARB(int n2, FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glWeightfvARB(" + n2 + "," + floatBuffer + ")");
        this.downstreamGL.glWeightfvARB(n2, floatBuffer);
        this.println("");
    }

    @Override
    public void glWeightfvARB(int n2, float[] fArray, int n3) {
        this.printIndent();
        this.print("glWeightfvARB(" + n2 + "," + this.dumpArray(fArray) + "," + n3 + ")");
        this.downstreamGL.glWeightfvARB(n2, fArray, n3);
        this.println("");
    }

    @Override
    public void glWeightivARB(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glWeightivARB(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glWeightivARB(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glWeightivARB(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glWeightivARB(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glWeightivARB(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glWeightsvARB(int n2, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glWeightsvARB(" + n2 + "," + shortBuffer + ")");
        this.downstreamGL.glWeightsvARB(n2, shortBuffer);
        this.println("");
    }

    @Override
    public void glWeightsvARB(int n2, short[] sArray, int n3) {
        this.printIndent();
        this.print("glWeightsvARB(" + n2 + "," + this.dumpArray(sArray) + "," + n3 + ")");
        this.downstreamGL.glWeightsvARB(n2, sArray, n3);
        this.println("");
    }

    @Override
    public void glWeightubvARB(int n2, ByteBuffer byteBuffer) {
        this.printIndent();
        this.print("glWeightubvARB(" + n2 + "," + byteBuffer + ")");
        this.downstreamGL.glWeightubvARB(n2, byteBuffer);
        this.println("");
    }

    @Override
    public void glWeightubvARB(int n2, byte[] byArray, int n3) {
        this.printIndent();
        this.print("glWeightubvARB(" + n2 + "," + this.dumpArray(byArray) + "," + n3 + ")");
        this.downstreamGL.glWeightubvARB(n2, byArray, n3);
        this.println("");
    }

    @Override
    public void glWeightuivARB(int n2, IntBuffer intBuffer) {
        this.printIndent();
        this.print("glWeightuivARB(" + n2 + "," + intBuffer + ")");
        this.downstreamGL.glWeightuivARB(n2, intBuffer);
        this.println("");
    }

    @Override
    public void glWeightuivARB(int n2, int[] nArray, int n3) {
        this.printIndent();
        this.print("glWeightuivARB(" + n2 + "," + this.dumpArray(nArray) + "," + n3 + ")");
        this.downstreamGL.glWeightuivARB(n2, nArray, n3);
        this.println("");
    }

    @Override
    public void glWeightusvARB(int n2, ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glWeightusvARB(" + n2 + "," + shortBuffer + ")");
        this.downstreamGL.glWeightusvARB(n2, shortBuffer);
        this.println("");
    }

    @Override
    public void glWeightusvARB(int n2, short[] sArray, int n3) {
        this.printIndent();
        this.print("glWeightusvARB(" + n2 + "," + this.dumpArray(sArray) + "," + n3 + ")");
        this.downstreamGL.glWeightusvARB(n2, sArray, n3);
        this.println("");
    }

    @Override
    public void glWindowPos2d(double d2, double d3) {
        this.printIndent();
        this.print("glWindowPos2d(" + d2 + "," + d3 + ")");
        this.downstreamGL.glWindowPos2d(d2, d3);
        this.println("");
    }

    @Override
    public void glWindowPos2dARB(double d2, double d3) {
        this.printIndent();
        this.print("glWindowPos2dARB(" + d2 + "," + d3 + ")");
        this.downstreamGL.glWindowPos2dARB(d2, d3);
        this.println("");
    }

    @Override
    public void glWindowPos2dMESA(double d2, double d3) {
        this.printIndent();
        this.print("glWindowPos2dMESA(" + d2 + "," + d3 + ")");
        this.downstreamGL.glWindowPos2dMESA(d2, d3);
        this.println("");
    }

    @Override
    public void glWindowPos2dv(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glWindowPos2dv(" + doubleBuffer + ")");
        this.downstreamGL.glWindowPos2dv(doubleBuffer);
        this.println("");
    }

    @Override
    public void glWindowPos2dv(double[] dArray, int n2) {
        this.printIndent();
        this.print("glWindowPos2dv(" + this.dumpArray(dArray) + "," + n2 + ")");
        this.downstreamGL.glWindowPos2dv(dArray, n2);
        this.println("");
    }

    @Override
    public void glWindowPos2dvARB(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glWindowPos2dvARB(" + doubleBuffer + ")");
        this.downstreamGL.glWindowPos2dvARB(doubleBuffer);
        this.println("");
    }

    @Override
    public void glWindowPos2dvARB(double[] dArray, int n2) {
        this.printIndent();
        this.print("glWindowPos2dvARB(" + this.dumpArray(dArray) + "," + n2 + ")");
        this.downstreamGL.glWindowPos2dvARB(dArray, n2);
        this.println("");
    }

    @Override
    public void glWindowPos2dvMESA(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glWindowPos2dvMESA(" + doubleBuffer + ")");
        this.downstreamGL.glWindowPos2dvMESA(doubleBuffer);
        this.println("");
    }

    @Override
    public void glWindowPos2dvMESA(double[] dArray, int n2) {
        this.printIndent();
        this.print("glWindowPos2dvMESA(" + this.dumpArray(dArray) + "," + n2 + ")");
        this.downstreamGL.glWindowPos2dvMESA(dArray, n2);
        this.println("");
    }

    @Override
    public void glWindowPos2f(float f2, float f3) {
        this.printIndent();
        this.print("glWindowPos2f(" + f2 + "," + f3 + ")");
        this.downstreamGL.glWindowPos2f(f2, f3);
        this.println("");
    }

    @Override
    public void glWindowPos2fARB(float f2, float f3) {
        this.printIndent();
        this.print("glWindowPos2fARB(" + f2 + "," + f3 + ")");
        this.downstreamGL.glWindowPos2fARB(f2, f3);
        this.println("");
    }

    @Override
    public void glWindowPos2fMESA(float f2, float f3) {
        this.printIndent();
        this.print("glWindowPos2fMESA(" + f2 + "," + f3 + ")");
        this.downstreamGL.glWindowPos2fMESA(f2, f3);
        this.println("");
    }

    @Override
    public void glWindowPos2fv(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glWindowPos2fv(" + floatBuffer + ")");
        this.downstreamGL.glWindowPos2fv(floatBuffer);
        this.println("");
    }

    @Override
    public void glWindowPos2fv(float[] fArray, int n2) {
        this.printIndent();
        this.print("glWindowPos2fv(" + this.dumpArray(fArray) + "," + n2 + ")");
        this.downstreamGL.glWindowPos2fv(fArray, n2);
        this.println("");
    }

    @Override
    public void glWindowPos2fvARB(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glWindowPos2fvARB(" + floatBuffer + ")");
        this.downstreamGL.glWindowPos2fvARB(floatBuffer);
        this.println("");
    }

    @Override
    public void glWindowPos2fvARB(float[] fArray, int n2) {
        this.printIndent();
        this.print("glWindowPos2fvARB(" + this.dumpArray(fArray) + "," + n2 + ")");
        this.downstreamGL.glWindowPos2fvARB(fArray, n2);
        this.println("");
    }

    @Override
    public void glWindowPos2fvMESA(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glWindowPos2fvMESA(" + floatBuffer + ")");
        this.downstreamGL.glWindowPos2fvMESA(floatBuffer);
        this.println("");
    }

    @Override
    public void glWindowPos2fvMESA(float[] fArray, int n2) {
        this.printIndent();
        this.print("glWindowPos2fvMESA(" + this.dumpArray(fArray) + "," + n2 + ")");
        this.downstreamGL.glWindowPos2fvMESA(fArray, n2);
        this.println("");
    }

    @Override
    public void glWindowPos2i(int n2, int n3) {
        this.printIndent();
        this.print("glWindowPos2i(" + n2 + "," + n3 + ")");
        this.downstreamGL.glWindowPos2i(n2, n3);
        this.println("");
    }

    @Override
    public void glWindowPos2iARB(int n2, int n3) {
        this.printIndent();
        this.print("glWindowPos2iARB(" + n2 + "," + n3 + ")");
        this.downstreamGL.glWindowPos2iARB(n2, n3);
        this.println("");
    }

    @Override
    public void glWindowPos2iMESA(int n2, int n3) {
        this.printIndent();
        this.print("glWindowPos2iMESA(" + n2 + "," + n3 + ")");
        this.downstreamGL.glWindowPos2iMESA(n2, n3);
        this.println("");
    }

    @Override
    public void glWindowPos2iv(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glWindowPos2iv(" + intBuffer + ")");
        this.downstreamGL.glWindowPos2iv(intBuffer);
        this.println("");
    }

    @Override
    public void glWindowPos2iv(int[] nArray, int n2) {
        this.printIndent();
        this.print("glWindowPos2iv(" + this.dumpArray(nArray) + "," + n2 + ")");
        this.downstreamGL.glWindowPos2iv(nArray, n2);
        this.println("");
    }

    @Override
    public void glWindowPos2ivARB(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glWindowPos2ivARB(" + intBuffer + ")");
        this.downstreamGL.glWindowPos2ivARB(intBuffer);
        this.println("");
    }

    @Override
    public void glWindowPos2ivARB(int[] nArray, int n2) {
        this.printIndent();
        this.print("glWindowPos2ivARB(" + this.dumpArray(nArray) + "," + n2 + ")");
        this.downstreamGL.glWindowPos2ivARB(nArray, n2);
        this.println("");
    }

    @Override
    public void glWindowPos2ivMESA(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glWindowPos2ivMESA(" + intBuffer + ")");
        this.downstreamGL.glWindowPos2ivMESA(intBuffer);
        this.println("");
    }

    @Override
    public void glWindowPos2ivMESA(int[] nArray, int n2) {
        this.printIndent();
        this.print("glWindowPos2ivMESA(" + this.dumpArray(nArray) + "," + n2 + ")");
        this.downstreamGL.glWindowPos2ivMESA(nArray, n2);
        this.println("");
    }

    @Override
    public void glWindowPos2s(short s2, short s3) {
        this.printIndent();
        this.print("glWindowPos2s(" + s2 + "," + s3 + ")");
        this.downstreamGL.glWindowPos2s(s2, s3);
        this.println("");
    }

    @Override
    public void glWindowPos2sARB(short s2, short s3) {
        this.printIndent();
        this.print("glWindowPos2sARB(" + s2 + "," + s3 + ")");
        this.downstreamGL.glWindowPos2sARB(s2, s3);
        this.println("");
    }

    @Override
    public void glWindowPos2sMESA(short s2, short s3) {
        this.printIndent();
        this.print("glWindowPos2sMESA(" + s2 + "," + s3 + ")");
        this.downstreamGL.glWindowPos2sMESA(s2, s3);
        this.println("");
    }

    @Override
    public void glWindowPos2sv(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glWindowPos2sv(" + shortBuffer + ")");
        this.downstreamGL.glWindowPos2sv(shortBuffer);
        this.println("");
    }

    @Override
    public void glWindowPos2sv(short[] sArray, int n2) {
        this.printIndent();
        this.print("glWindowPos2sv(" + this.dumpArray(sArray) + "," + n2 + ")");
        this.downstreamGL.glWindowPos2sv(sArray, n2);
        this.println("");
    }

    @Override
    public void glWindowPos2svARB(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glWindowPos2svARB(" + shortBuffer + ")");
        this.downstreamGL.glWindowPos2svARB(shortBuffer);
        this.println("");
    }

    @Override
    public void glWindowPos2svARB(short[] sArray, int n2) {
        this.printIndent();
        this.print("glWindowPos2svARB(" + this.dumpArray(sArray) + "," + n2 + ")");
        this.downstreamGL.glWindowPos2svARB(sArray, n2);
        this.println("");
    }

    @Override
    public void glWindowPos2svMESA(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glWindowPos2svMESA(" + shortBuffer + ")");
        this.downstreamGL.glWindowPos2svMESA(shortBuffer);
        this.println("");
    }

    @Override
    public void glWindowPos2svMESA(short[] sArray, int n2) {
        this.printIndent();
        this.print("glWindowPos2svMESA(" + this.dumpArray(sArray) + "," + n2 + ")");
        this.downstreamGL.glWindowPos2svMESA(sArray, n2);
        this.println("");
    }

    @Override
    public void glWindowPos3d(double d2, double d3, double d4) {
        this.printIndent();
        this.print("glWindowPos3d(" + d2 + "," + d3 + "," + d4 + ")");
        this.downstreamGL.glWindowPos3d(d2, d3, d4);
        this.println("");
    }

    @Override
    public void glWindowPos3dARB(double d2, double d3, double d4) {
        this.printIndent();
        this.print("glWindowPos3dARB(" + d2 + "," + d3 + "," + d4 + ")");
        this.downstreamGL.glWindowPos3dARB(d2, d3, d4);
        this.println("");
    }

    @Override
    public void glWindowPos3dMESA(double d2, double d3, double d4) {
        this.printIndent();
        this.print("glWindowPos3dMESA(" + d2 + "," + d3 + "," + d4 + ")");
        this.downstreamGL.glWindowPos3dMESA(d2, d3, d4);
        this.println("");
    }

    @Override
    public void glWindowPos3dv(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glWindowPos3dv(" + doubleBuffer + ")");
        this.downstreamGL.glWindowPos3dv(doubleBuffer);
        this.println("");
    }

    @Override
    public void glWindowPos3dv(double[] dArray, int n2) {
        this.printIndent();
        this.print("glWindowPos3dv(" + this.dumpArray(dArray) + "," + n2 + ")");
        this.downstreamGL.glWindowPos3dv(dArray, n2);
        this.println("");
    }

    @Override
    public void glWindowPos3dvARB(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glWindowPos3dvARB(" + doubleBuffer + ")");
        this.downstreamGL.glWindowPos3dvARB(doubleBuffer);
        this.println("");
    }

    @Override
    public void glWindowPos3dvARB(double[] dArray, int n2) {
        this.printIndent();
        this.print("glWindowPos3dvARB(" + this.dumpArray(dArray) + "," + n2 + ")");
        this.downstreamGL.glWindowPos3dvARB(dArray, n2);
        this.println("");
    }

    @Override
    public void glWindowPos3dvMESA(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glWindowPos3dvMESA(" + doubleBuffer + ")");
        this.downstreamGL.glWindowPos3dvMESA(doubleBuffer);
        this.println("");
    }

    @Override
    public void glWindowPos3dvMESA(double[] dArray, int n2) {
        this.printIndent();
        this.print("glWindowPos3dvMESA(" + this.dumpArray(dArray) + "," + n2 + ")");
        this.downstreamGL.glWindowPos3dvMESA(dArray, n2);
        this.println("");
    }

    @Override
    public void glWindowPos3f(float f2, float f3, float f4) {
        this.printIndent();
        this.print("glWindowPos3f(" + f2 + "," + f3 + "," + f4 + ")");
        this.downstreamGL.glWindowPos3f(f2, f3, f4);
        this.println("");
    }

    @Override
    public void glWindowPos3fARB(float f2, float f3, float f4) {
        this.printIndent();
        this.print("glWindowPos3fARB(" + f2 + "," + f3 + "," + f4 + ")");
        this.downstreamGL.glWindowPos3fARB(f2, f3, f4);
        this.println("");
    }

    @Override
    public void glWindowPos3fMESA(float f2, float f3, float f4) {
        this.printIndent();
        this.print("glWindowPos3fMESA(" + f2 + "," + f3 + "," + f4 + ")");
        this.downstreamGL.glWindowPos3fMESA(f2, f3, f4);
        this.println("");
    }

    @Override
    public void glWindowPos3fv(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glWindowPos3fv(" + floatBuffer + ")");
        this.downstreamGL.glWindowPos3fv(floatBuffer);
        this.println("");
    }

    @Override
    public void glWindowPos3fv(float[] fArray, int n2) {
        this.printIndent();
        this.print("glWindowPos3fv(" + this.dumpArray(fArray) + "," + n2 + ")");
        this.downstreamGL.glWindowPos3fv(fArray, n2);
        this.println("");
    }

    @Override
    public void glWindowPos3fvARB(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glWindowPos3fvARB(" + floatBuffer + ")");
        this.downstreamGL.glWindowPos3fvARB(floatBuffer);
        this.println("");
    }

    @Override
    public void glWindowPos3fvARB(float[] fArray, int n2) {
        this.printIndent();
        this.print("glWindowPos3fvARB(" + this.dumpArray(fArray) + "," + n2 + ")");
        this.downstreamGL.glWindowPos3fvARB(fArray, n2);
        this.println("");
    }

    @Override
    public void glWindowPos3fvMESA(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glWindowPos3fvMESA(" + floatBuffer + ")");
        this.downstreamGL.glWindowPos3fvMESA(floatBuffer);
        this.println("");
    }

    @Override
    public void glWindowPos3fvMESA(float[] fArray, int n2) {
        this.printIndent();
        this.print("glWindowPos3fvMESA(" + this.dumpArray(fArray) + "," + n2 + ")");
        this.downstreamGL.glWindowPos3fvMESA(fArray, n2);
        this.println("");
    }

    @Override
    public void glWindowPos3i(int n2, int n3, int n4) {
        this.printIndent();
        this.print("glWindowPos3i(" + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glWindowPos3i(n2, n3, n4);
        this.println("");
    }

    @Override
    public void glWindowPos3iARB(int n2, int n3, int n4) {
        this.printIndent();
        this.print("glWindowPos3iARB(" + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glWindowPos3iARB(n2, n3, n4);
        this.println("");
    }

    @Override
    public void glWindowPos3iMESA(int n2, int n3, int n4) {
        this.printIndent();
        this.print("glWindowPos3iMESA(" + n2 + "," + n3 + "," + n4 + ")");
        this.downstreamGL.glWindowPos3iMESA(n2, n3, n4);
        this.println("");
    }

    @Override
    public void glWindowPos3iv(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glWindowPos3iv(" + intBuffer + ")");
        this.downstreamGL.glWindowPos3iv(intBuffer);
        this.println("");
    }

    @Override
    public void glWindowPos3iv(int[] nArray, int n2) {
        this.printIndent();
        this.print("glWindowPos3iv(" + this.dumpArray(nArray) + "," + n2 + ")");
        this.downstreamGL.glWindowPos3iv(nArray, n2);
        this.println("");
    }

    @Override
    public void glWindowPos3ivARB(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glWindowPos3ivARB(" + intBuffer + ")");
        this.downstreamGL.glWindowPos3ivARB(intBuffer);
        this.println("");
    }

    @Override
    public void glWindowPos3ivARB(int[] nArray, int n2) {
        this.printIndent();
        this.print("glWindowPos3ivARB(" + this.dumpArray(nArray) + "," + n2 + ")");
        this.downstreamGL.glWindowPos3ivARB(nArray, n2);
        this.println("");
    }

    @Override
    public void glWindowPos3ivMESA(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glWindowPos3ivMESA(" + intBuffer + ")");
        this.downstreamGL.glWindowPos3ivMESA(intBuffer);
        this.println("");
    }

    @Override
    public void glWindowPos3ivMESA(int[] nArray, int n2) {
        this.printIndent();
        this.print("glWindowPos3ivMESA(" + this.dumpArray(nArray) + "," + n2 + ")");
        this.downstreamGL.glWindowPos3ivMESA(nArray, n2);
        this.println("");
    }

    @Override
    public void glWindowPos3s(short s2, short s3, short s4) {
        this.printIndent();
        this.print("glWindowPos3s(" + s2 + "," + s3 + "," + s4 + ")");
        this.downstreamGL.glWindowPos3s(s2, s3, s4);
        this.println("");
    }

    @Override
    public void glWindowPos3sARB(short s2, short s3, short s4) {
        this.printIndent();
        this.print("glWindowPos3sARB(" + s2 + "," + s3 + "," + s4 + ")");
        this.downstreamGL.glWindowPos3sARB(s2, s3, s4);
        this.println("");
    }

    @Override
    public void glWindowPos3sMESA(short s2, short s3, short s4) {
        this.printIndent();
        this.print("glWindowPos3sMESA(" + s2 + "," + s3 + "," + s4 + ")");
        this.downstreamGL.glWindowPos3sMESA(s2, s3, s4);
        this.println("");
    }

    @Override
    public void glWindowPos3sv(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glWindowPos3sv(" + shortBuffer + ")");
        this.downstreamGL.glWindowPos3sv(shortBuffer);
        this.println("");
    }

    @Override
    public void glWindowPos3sv(short[] sArray, int n2) {
        this.printIndent();
        this.print("glWindowPos3sv(" + this.dumpArray(sArray) + "," + n2 + ")");
        this.downstreamGL.glWindowPos3sv(sArray, n2);
        this.println("");
    }

    @Override
    public void glWindowPos3svARB(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glWindowPos3svARB(" + shortBuffer + ")");
        this.downstreamGL.glWindowPos3svARB(shortBuffer);
        this.println("");
    }

    @Override
    public void glWindowPos3svARB(short[] sArray, int n2) {
        this.printIndent();
        this.print("glWindowPos3svARB(" + this.dumpArray(sArray) + "," + n2 + ")");
        this.downstreamGL.glWindowPos3svARB(sArray, n2);
        this.println("");
    }

    @Override
    public void glWindowPos3svMESA(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glWindowPos3svMESA(" + shortBuffer + ")");
        this.downstreamGL.glWindowPos3svMESA(shortBuffer);
        this.println("");
    }

    @Override
    public void glWindowPos3svMESA(short[] sArray, int n2) {
        this.printIndent();
        this.print("glWindowPos3svMESA(" + this.dumpArray(sArray) + "," + n2 + ")");
        this.downstreamGL.glWindowPos3svMESA(sArray, n2);
        this.println("");
    }

    @Override
    public void glWindowPos4dMESA(double d2, double d3, double d4, double d5) {
        this.printIndent();
        this.print("glWindowPos4dMESA(" + d2 + "," + d3 + "," + d4 + "," + d5 + ")");
        this.downstreamGL.glWindowPos4dMESA(d2, d3, d4, d5);
        this.println("");
    }

    @Override
    public void glWindowPos4dvMESA(DoubleBuffer doubleBuffer) {
        this.printIndent();
        this.print("glWindowPos4dvMESA(" + doubleBuffer + ")");
        this.downstreamGL.glWindowPos4dvMESA(doubleBuffer);
        this.println("");
    }

    @Override
    public void glWindowPos4dvMESA(double[] dArray, int n2) {
        this.printIndent();
        this.print("glWindowPos4dvMESA(" + this.dumpArray(dArray) + "," + n2 + ")");
        this.downstreamGL.glWindowPos4dvMESA(dArray, n2);
        this.println("");
    }

    @Override
    public void glWindowPos4fMESA(float f2, float f3, float f4, float f5) {
        this.printIndent();
        this.print("glWindowPos4fMESA(" + f2 + "," + f3 + "," + f4 + "," + f5 + ")");
        this.downstreamGL.glWindowPos4fMESA(f2, f3, f4, f5);
        this.println("");
    }

    @Override
    public void glWindowPos4fvMESA(FloatBuffer floatBuffer) {
        this.printIndent();
        this.print("glWindowPos4fvMESA(" + floatBuffer + ")");
        this.downstreamGL.glWindowPos4fvMESA(floatBuffer);
        this.println("");
    }

    @Override
    public void glWindowPos4fvMESA(float[] fArray, int n2) {
        this.printIndent();
        this.print("glWindowPos4fvMESA(" + this.dumpArray(fArray) + "," + n2 + ")");
        this.downstreamGL.glWindowPos4fvMESA(fArray, n2);
        this.println("");
    }

    @Override
    public void glWindowPos4iMESA(int n2, int n3, int n4, int n5) {
        this.printIndent();
        this.print("glWindowPos4iMESA(" + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        this.downstreamGL.glWindowPos4iMESA(n2, n3, n4, n5);
        this.println("");
    }

    @Override
    public void glWindowPos4ivMESA(IntBuffer intBuffer) {
        this.printIndent();
        this.print("glWindowPos4ivMESA(" + intBuffer + ")");
        this.downstreamGL.glWindowPos4ivMESA(intBuffer);
        this.println("");
    }

    @Override
    public void glWindowPos4ivMESA(int[] nArray, int n2) {
        this.printIndent();
        this.print("glWindowPos4ivMESA(" + this.dumpArray(nArray) + "," + n2 + ")");
        this.downstreamGL.glWindowPos4ivMESA(nArray, n2);
        this.println("");
    }

    @Override
    public void glWindowPos4sMESA(short s2, short s3, short s4, short s5) {
        this.printIndent();
        this.print("glWindowPos4sMESA(" + s2 + "," + s3 + "," + s4 + "," + s5 + ")");
        this.downstreamGL.glWindowPos4sMESA(s2, s3, s4, s5);
        this.println("");
    }

    @Override
    public void glWindowPos4svMESA(ShortBuffer shortBuffer) {
        this.printIndent();
        this.print("glWindowPos4svMESA(" + shortBuffer + ")");
        this.downstreamGL.glWindowPos4svMESA(shortBuffer);
        this.println("");
    }

    @Override
    public void glWindowPos4svMESA(short[] sArray, int n2) {
        this.printIndent();
        this.print("glWindowPos4svMESA(" + this.dumpArray(sArray) + "," + n2 + ")");
        this.downstreamGL.glWindowPos4svMESA(sArray, n2);
        this.println("");
    }

    @Override
    public void glWriteMaskEXT(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.printIndent();
        this.print("glWriteMaskEXT(" + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + ")");
        this.downstreamGL.glWriteMaskEXT(n2, n3, n4, n5, n6, n7);
        this.println("");
    }

    @Override
    public boolean isFunctionAvailable(String string) {
        this.printIndent();
        this.print("isFunctionAvailable(" + string + ")");
        boolean bl = this.downstreamGL.isFunctionAvailable(string);
        this.println(" = " + bl);
        return bl;
    }

    @Override
    public boolean isExtensionAvailable(String string) {
        this.printIndent();
        this.print("isExtensionAvailable(" + string + ")");
        boolean bl = this.downstreamGL.isExtensionAvailable(string);
        this.println(" = " + bl);
        return bl;
    }

    @Override
    public ByteBuffer glAllocateMemoryNV(int n2, float f2, float f3, float f4) {
        this.printIndent();
        this.print("glAllocateMemoryNV(" + n2 + "," + f2 + "," + f3 + "," + f4 + ")");
        ByteBuffer byteBuffer = this.downstreamGL.glAllocateMemoryNV(n2, f2, f3, f4);
        this.println(" = " + byteBuffer);
        return byteBuffer;
    }

    @Override
    public void setSwapInterval(int n2) {
        this.printIndent();
        this.print("setSwapInterval(" + n2 + ")");
        this.downstreamGL.setSwapInterval(n2);
        this.println("");
    }

    @Override
    public Object getPlatformGLExtensions() {
        this.printIndent();
        this.print("getPlatformGLExtensions()");
        Object object = this.downstreamGL.getPlatformGLExtensions();
        this.println(" = " + object);
        return object;
    }

    @Override
    public Object getExtension(String object) {
        this.printIndent();
        this.print("getExtension(" + (String)object + ")");
        object = this.downstreamGL.getExtension((String)object);
        this.println(" = " + object);
        return object;
    }

    protected String dumpArray(Object object) {
        if (object == null) {
            return "[null]";
        }
        StringBuffer stringBuffer = new StringBuffer("[");
        int n2 = Array.getLength(object);
        int n3 = Math.min(n2, 16);
        for (int i2 = 0; i2 < n3; ++i2) {
            stringBuffer.append(Array.get(object, i2));
            if (i2 >= n3 - 1) continue;
            stringBuffer.append(',');
        }
        if (n2 > 16) {
            stringBuffer.append("...").append(n2);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    protected void print(String string) {
        this.stream.print(string);
    }

    protected void println(String string) {
        this.stream.println(string);
    }

    protected void printIndent() {
        for (int i2 = 0; i2 < this.indent; ++i2) {
            this.stream.print(' ');
        }
    }
}

