/*
 * Decompiled with CFR 0.152.
 */
package javax.media.opengl;

import com.sun.opengl.impl.Debug;
import com.sun.opengl.impl.GLDrawableHelper;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.geom.Rectangle2D;
import java.beans.Beans;
import java.lang.reflect.Method;
import java.security.AccessController;
import javax.media.opengl.AWTGraphicsConfiguration;
import javax.media.opengl.AWTGraphicsDevice;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas$1;
import javax.media.opengl.GLCanvas$DestroyAction;
import javax.media.opengl.GLCanvas$DisplayAction;
import javax.media.opengl.GLCanvas$DisplayOnEventDispatchThreadAction;
import javax.media.opengl.GLCanvas$InitAction;
import javax.media.opengl.GLCanvas$SwapBuffersAction;
import javax.media.opengl.GLCanvas$SwapBuffersOnEventDispatchThreadAction;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.Threading;

public class GLCanvas
extends Canvas
implements GLAutoDrawable {
    private static final boolean DEBUG = Debug.debug("GLCanvas");
    private GLDrawableHelper drawableHelper = new GLDrawableHelper();
    private GLDrawable drawable;
    private GLContext context;
    private boolean autoSwapBufferMode = true;
    private boolean sendReshape = false;
    private GraphicsConfiguration chosen;
    private GLCapabilities glCaps;
    private GLCapabilitiesChooser glCapChooser;
    private GLCanvas$InitAction initAction = new GLCanvas$InitAction(this);
    private GLCanvas$DisplayAction displayAction = new GLCanvas$DisplayAction(this);
    private GLCanvas$SwapBuffersAction swapBuffersAction = new GLCanvas$SwapBuffersAction(this);
    private GLCanvas$DisplayOnEventDispatchThreadAction displayOnEventDispatchThreadAction = new GLCanvas$DisplayOnEventDispatchThreadAction(this);
    private GLCanvas$SwapBuffersOnEventDispatchThreadAction swapBuffersOnEventDispatchThreadAction = new GLCanvas$SwapBuffersOnEventDispatchThreadAction(this);
    private GLCanvas$DestroyAction destroyAction = new GLCanvas$DestroyAction(this);
    private static boolean disableBackgroundEraseInitialized;
    private static Method disableBackgroundEraseMethod;

    public GLCanvas() {
        this((GLCapabilities)null);
    }

    public GLCanvas(GLCapabilities gLCapabilities) {
        this(gLCapabilities, null, null, null);
    }

    public GLCanvas(GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser, GLContext gLContext, GraphicsDevice graphicsDevice) {
        this.chosen = GLCanvas.chooseGraphicsConfiguration(gLCapabilities, gLCapabilitiesChooser, graphicsDevice);
        if (this.chosen != null) {
            this.glCapChooser = gLCapabilitiesChooser;
            this.glCaps = gLCapabilities;
        }
        if (!Beans.isDesignTime()) {
            this.drawable = GLDrawableFactory.getFactory().getGLDrawable(this, gLCapabilities, gLCapabilitiesChooser);
            this.context = this.drawable.createContext(gLContext);
            this.context.setSynchronized(true);
        }
    }

    @Override
    public GraphicsConfiguration getGraphicsConfiguration() {
        GraphicsConfiguration graphicsConfiguration = super.getGraphicsConfiguration();
        if (graphicsConfiguration != null && this.chosen != null && !this.chosen.equals(graphicsConfiguration)) {
            if (!this.chosen.getDevice().getIDstring().equals(graphicsConfiguration.getDevice().getIDstring()) && (graphicsConfiguration = GLCanvas.chooseGraphicsConfiguration(this.glCaps, this.glCapChooser, graphicsConfiguration.getDevice())) != null) {
                this.chosen = graphicsConfiguration;
            }
            return this.chosen;
        }
        if (graphicsConfiguration == null) {
            return this.chosen;
        }
        return graphicsConfiguration;
    }

    @Override
    public GLContext createContext(GLContext gLContext) {
        return this.drawable.createContext(gLContext);
    }

    @Override
    public void setRealized(boolean bl) {
    }

    @Override
    public void display() {
        this.maybeDoSingleThreadedWorkaround(this.displayOnEventDispatchThreadAction, this.displayAction);
    }

    @Override
    public void paint(Graphics graphics) {
        if (Beans.isDesignTime()) {
            int n2;
            graphics.setColor(Color.BLACK);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            FontMetrics fontMetrics = graphics.getFontMetrics();
            String string = this.getName();
            if (string == null && (n2 = (string = this.getClass().getName()).lastIndexOf(46)) >= 0) {
                string = string.substring(n2 + 1);
            }
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics);
            graphics.setColor(Color.WHITE);
            graphics.drawString(string, (int)(((double)this.getWidth() - rectangle2D.getWidth()) / 2.0), (int)(((double)this.getHeight() + rectangle2D.getHeight()) / 2.0));
            return;
        }
        this.display();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (!Beans.isDesignTime()) {
            this.disableBackgroundErase();
            this.drawable.setRealized(true);
        }
        if (DEBUG) {
            System.err.println("GLCanvas.addNotify()");
        }
    }

    @Override
    public void removeNotify() {
        if (Beans.isDesignTime()) {
            super.removeNotify();
            return;
        }
        try {
            if (Threading.isSingleThreaded() && !Threading.isOpenGLThread()) {
                if (Threading.isAWTMode() && Thread.holdsLock(this.getTreeLock())) {
                    this.destroyAction.run();
                } else {
                    Threading.invokeOnOpenGLThread(this.destroyAction);
                }
            } else {
                this.destroyAction.run();
            }
            this.drawable.setRealized(false);
        }
        catch (Throwable throwable) {
            this.drawable.setRealized(false);
            super.removeNotify();
            if (DEBUG) {
                System.err.println("GLCanvas.removeNotify()");
            }
            throw throwable;
        }
        super.removeNotify();
        if (DEBUG) {
            System.err.println("GLCanvas.removeNotify()");
            return;
        }
    }

    @Override
    public void reshape(int n2, int n3, int n4, int n5) {
        super.reshape(n2, n3, n4, n5);
        this.sendReshape = true;
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void addGLEventListener(GLEventListener gLEventListener) {
        this.drawableHelper.addGLEventListener(gLEventListener);
    }

    @Override
    public void removeGLEventListener(GLEventListener gLEventListener) {
        this.drawableHelper.removeGLEventListener(gLEventListener);
    }

    @Override
    public GLContext getContext() {
        return this.context;
    }

    @Override
    public GL getGL() {
        if (Beans.isDesignTime()) {
            return null;
        }
        return this.getContext().getGL();
    }

    @Override
    public void setGL(GL gL) {
        if (!Beans.isDesignTime()) {
            this.getContext().setGL(gL);
        }
    }

    @Override
    public void setAutoSwapBufferMode(boolean bl) {
        this.drawableHelper.setAutoSwapBufferMode(bl);
    }

    @Override
    public boolean getAutoSwapBufferMode() {
        return this.drawableHelper.getAutoSwapBufferMode();
    }

    @Override
    public void swapBuffers() {
        this.maybeDoSingleThreadedWorkaround(this.swapBuffersOnEventDispatchThreadAction, this.swapBuffersAction);
    }

    @Override
    public GLCapabilities getChosenGLCapabilities() {
        if (this.drawable == null) {
            return null;
        }
        return this.drawable.getChosenGLCapabilities();
    }

    private void maybeDoSingleThreadedWorkaround(Runnable runnable, Runnable runnable2) {
        if (Threading.isSingleThreaded() && !Threading.isOpenGLThread()) {
            Threading.invokeOnOpenGLThread(runnable);
            return;
        }
        this.drawableHelper.invokeGL(this.drawable, this.context, runnable2, this.initAction);
    }

    private void disableBackgroundErase() {
        if (!disableBackgroundEraseInitialized) {
            try {
                AccessController.doPrivileged(new GLCanvas$1(this));
            }
            catch (Exception exception) {}
            disableBackgroundEraseInitialized = true;
        }
        if (disableBackgroundEraseMethod != null) {
            try {
                disableBackgroundEraseMethod.invoke((Object)this.getToolkit(), this);
                return;
            }
            catch (Exception exception) {}
        }
    }

    private static GraphicsConfiguration chooseGraphicsConfiguration(GLCapabilities object, GLCapabilitiesChooser gLCapabilitiesChooser, GraphicsDevice graphicsDevice) {
        if (Beans.isDesignTime()) {
            return null;
        }
        object = (AWTGraphicsConfiguration)GLDrawableFactory.getFactory().chooseGraphicsConfiguration((GLCapabilities)object, gLCapabilitiesChooser, new AWTGraphicsDevice(graphicsDevice));
        if (object == null) {
            return null;
        }
        return ((AWTGraphicsConfiguration)object).getGraphicsConfiguration();
    }

    static /* synthetic */ GLDrawableHelper access$000(GLCanvas gLCanvas) {
        return gLCanvas.drawableHelper;
    }

    static /* synthetic */ boolean access$100(GLCanvas gLCanvas) {
        return gLCanvas.sendReshape;
    }

    static /* synthetic */ boolean access$102(GLCanvas gLCanvas, boolean bl) {
        gLCanvas.sendReshape = bl;
        return gLCanvas.sendReshape;
    }

    static /* synthetic */ GLDrawable access$200(GLCanvas gLCanvas) {
        return gLCanvas.drawable;
    }

    static /* synthetic */ GLContext access$300(GLCanvas gLCanvas) {
        return gLCanvas.context;
    }

    static /* synthetic */ GLCanvas$DisplayAction access$400(GLCanvas gLCanvas) {
        return gLCanvas.displayAction;
    }

    static /* synthetic */ GLCanvas$InitAction access$500(GLCanvas gLCanvas) {
        return gLCanvas.initAction;
    }

    static /* synthetic */ GLCanvas$SwapBuffersAction access$600(GLCanvas gLCanvas) {
        return gLCanvas.swapBuffersAction;
    }

    static /* synthetic */ Method access$702(Method method) {
        disableBackgroundEraseMethod = method;
        return disableBackgroundEraseMethod;
    }

    static /* synthetic */ Method access$700() {
        return disableBackgroundEraseMethod;
    }
}

