/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.util.texture;

import com.sun.opengl.util.FileUtil;
import com.sun.opengl.util.texture.TextureData;
import com.sun.opengl.util.texture.spi.SGIImage;
import com.sun.opengl.util.texture.spi.TextureWriter;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;

class TextureIO$SGITextureWriter
implements TextureWriter {
    TextureIO$SGITextureWriter() {
    }

    @Override
    public boolean write(File file, TextureData textureData) {
        String string = FileUtil.getFileSuffix(file);
        if ("sgi".equals(string) || "rgb".equals(string)) {
            int n2 = textureData.getPixelFormat();
            int n3 = textureData.getPixelType();
            if (!(n2 != 6407 && n2 != 6408 || n3 != 5120 && n3 != 5121)) {
                byte[] byArray;
                ByteBuffer byteBuffer = textureData.getBuffer() != null ? (ByteBuffer)textureData.getBuffer() : (ByteBuffer)textureData.getMipmapData()[0];
                if (byteBuffer.hasArray()) {
                    byArray = byteBuffer.array();
                } else {
                    byteBuffer.rewind();
                    byArray = new byte[byteBuffer.remaining()];
                    byteBuffer.get(byArray);
                    byteBuffer.rewind();
                }
                SGIImage.createFromData(textureData.getWidth(), textureData.getHeight(), n2 == 6408, byArray).write(file, false);
                return true;
            }
            throw new IOException("SGI writer doesn't support this pixel format / type (only GL_RGB/A + bytes)");
        }
        return false;
    }
}

