/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.util.texture;

import com.sun.opengl.util.FileUtil;
import com.sun.opengl.util.StreamUtil;
import com.sun.opengl.util.texture.TextureData;
import com.sun.opengl.util.texture.TextureIO$DDSTextureProvider$1;
import com.sun.opengl.util.texture.spi.DDSImage;
import com.sun.opengl.util.texture.spi.DDSImage$ImageInfo;
import com.sun.opengl.util.texture.spi.TextureProvider;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;

class TextureIO$DDSTextureProvider
implements TextureProvider {
    TextureIO$DDSTextureProvider() {
    }

    @Override
    public TextureData newTextureData(File object, int n2, int n3, boolean bl, String string) {
        if ("dds".equals(string) || "dds".equals(FileUtil.getFileSuffix((File)object))) {
            object = DDSImage.read((File)object);
            return this.newTextureData((DDSImage)object, n2, n3, bl);
        }
        return null;
    }

    @Override
    public TextureData newTextureData(InputStream object, int n2, int n3, boolean bl, String string) {
        if ("dds".equals(string) || DDSImage.isDDSImage((InputStream)object)) {
            object = DDSImage.read(ByteBuffer.wrap(StreamUtil.readAll((InputStream)object)));
            return this.newTextureData((DDSImage)object, n2, n3, bl);
        }
        return null;
    }

    @Override
    public TextureData newTextureData(URL object, int n2, int n3, boolean bl, String string) {
        object = new BufferedInputStream(((URL)object).openStream());
        try {
            TextureData textureData = this.newTextureData((InputStream)object, n2, n3, bl, string);
            return textureData;
        }
        finally {
            ((InputStream)object).close();
        }
    }

    private TextureData newTextureData(DDSImage object, int n2, int n3, boolean bl) {
        DDSImage$ImageInfo dDSImage$ImageInfo = ((DDSImage)object).getMipMap(0);
        if (n3 == 0) {
            switch (((DDSImage)object).getPixelFormat()) {
                case 20: {
                    n3 = 6407;
                    break;
                }
                default: {
                    n3 = 6408;
                }
            }
        }
        if (dDSImage$ImageInfo.isCompressed()) {
            switch (dDSImage$ImageInfo.getCompressionFormat()) {
                case 827611204: {
                    n2 = 33776;
                    break;
                }
                case 861165636: {
                    n2 = 33778;
                    break;
                }
                case 894720068: {
                    n2 = 33779;
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported DDS compression format \"" + DDSImage.getCompressionFormatName(dDSImage$ImageInfo.getCompressionFormat()) + "\"");
                }
            }
        }
        if (n2 == 0) {
            switch (((DDSImage)object).getPixelFormat()) {
                case 20: {
                    n3 = 6407;
                    break;
                }
                default: {
                    n3 = 6408;
                }
            }
        }
        TextureIO$DDSTextureProvider$1 textureIO$DDSTextureProvider$1 = new TextureIO$DDSTextureProvider$1(this, (DDSImage)object);
        if (bl && ((DDSImage)object).getNumMipMaps() > 0) {
            Buffer[] bufferArray = new Buffer[((DDSImage)object).getNumMipMaps()];
            for (int i2 = 0; i2 < ((DDSImage)object).getNumMipMaps(); ++i2) {
                bufferArray[i2] = ((DDSImage)object).getMipMap(i2).getData();
            }
            object = new TextureData(n2, dDSImage$ImageInfo.getWidth(), dDSImage$ImageInfo.getHeight(), 0, n3, 5121, dDSImage$ImageInfo.isCompressed(), true, bufferArray, textureIO$DDSTextureProvider$1);
        } else {
            object = new TextureData(n2, dDSImage$ImageInfo.getWidth(), dDSImage$ImageInfo.getHeight(), 0, n3, 5121, false, dDSImage$ImageInfo.isCompressed(), true, dDSImage$ImageInfo.getData(), textureIO$DDSTextureProvider$1);
        }
        return object;
    }
}

