/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.util.texture;

import com.sun.opengl.util.texture.TextureData$Flusher;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public class TextureData {
    private int width;
    private int height;
    private int border;
    private int pixelFormat;
    private int pixelType;
    private int internalFormat;
    private boolean mipmap;
    private boolean dataIsCompressed;
    private boolean mustFlipVertically;
    private Buffer buffer;
    private Buffer[] mipmapData;
    private TextureData$Flusher flusher;
    private int rowLength;
    private int alignment;
    private int estimatedMemorySize;
    private BufferedImage imageForLazyCustomConversion;
    private boolean expectingEXTABGR;
    private boolean haveEXTABGR;
    private boolean expectingGL12;
    private boolean haveGL12;
    private static final ColorModel rgbaColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8, 8}, true, true, 3, 0);
    private static final ColorModel rgbColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8, 0}, false, false, 1, 0);

    public TextureData(int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, boolean bl2, boolean bl3, Buffer buffer, TextureData$Flusher textureData$Flusher) {
        if (bl && bl2) {
            throw new IllegalArgumentException("Can not generate mipmaps for compressed textures");
        }
        this.width = n3;
        this.height = n4;
        this.border = n5;
        this.pixelFormat = n6;
        this.pixelType = n7;
        this.internalFormat = n2;
        this.mipmap = bl;
        this.dataIsCompressed = bl2;
        this.mustFlipVertically = bl3;
        this.buffer = buffer;
        this.flusher = textureData$Flusher;
        this.alignment = 1;
        this.estimatedMemorySize = this.estimatedMemorySize(buffer);
    }

    public TextureData(int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, boolean bl2, Buffer[] bufferArray, TextureData$Flusher textureData$Flusher) {
        this.width = n3;
        this.height = n4;
        this.border = n5;
        this.pixelFormat = n6;
        this.pixelType = n7;
        this.internalFormat = n2;
        this.dataIsCompressed = bl;
        this.mustFlipVertically = bl2;
        this.mipmapData = (Buffer[])bufferArray.clone();
        this.flusher = textureData$Flusher;
        this.alignment = 1;
        for (n2 = 0; n2 < bufferArray.length; ++n2) {
            this.estimatedMemorySize += this.estimatedMemorySize(bufferArray[n2]);
        }
    }

    public TextureData(int n2, int n3, boolean bl, BufferedImage bufferedImage) {
        this.internalFormat = n2 == 0 ? (bufferedImage.getColorModel().hasAlpha() ? 6408 : 6407) : n2;
        this.createFromImage(bufferedImage);
        this.mipmap = bl;
        if (this.buffer != null) {
            this.estimatedMemorySize = this.estimatedMemorySize(this.buffer);
            return;
        }
        if (this.imageForLazyCustomConversion != null) {
            this.estimatedMemorySize = this.estimatedMemorySize(this.wrapImageDataBuffer(this.imageForLazyCustomConversion));
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getBorder() {
        return this.border;
    }

    public int getPixelFormat() {
        if (!(this.imageForLazyCustomConversion == null || this.expectingEXTABGR && this.haveEXTABGR || this.expectingGL12 && this.haveGL12)) {
            this.revertPixelFormatAndType();
        }
        return this.pixelFormat;
    }

    public int getPixelType() {
        if (!(this.imageForLazyCustomConversion == null || this.expectingEXTABGR && this.haveEXTABGR || this.expectingGL12 && this.haveGL12)) {
            this.revertPixelFormatAndType();
        }
        return this.pixelType;
    }

    public int getInternalFormat() {
        return this.internalFormat;
    }

    public boolean getMipmap() {
        return this.mipmap;
    }

    public boolean isDataCompressed() {
        return this.dataIsCompressed;
    }

    public boolean getMustFlipVertically() {
        return this.mustFlipVertically;
    }

    public Buffer getBuffer() {
        if (!(this.imageForLazyCustomConversion == null || this.expectingEXTABGR && this.haveEXTABGR || this.expectingGL12 && this.haveGL12)) {
            this.revertPixelFormatAndType();
            this.createFromCustom(this.imageForLazyCustomConversion);
        }
        return this.buffer;
    }

    public Buffer[] getMipmapData() {
        return this.mipmapData;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public int getRowLength() {
        return this.rowLength;
    }

    public void setWidth(int n2) {
        this.width = n2;
    }

    public void setHeight(int n2) {
        this.height = n2;
    }

    public void setBorder(int n2) {
        this.border = n2;
    }

    public void setPixelFormat(int n2) {
        this.pixelFormat = n2;
    }

    public void setPixelType(int n2) {
        this.pixelType = n2;
    }

    public void setInternalFormat(int n2) {
        this.internalFormat = n2;
    }

    public void setMipmap(boolean bl) {
        this.mipmap = bl;
    }

    public void setIsDataCompressed(boolean bl) {
        this.dataIsCompressed = bl;
    }

    public void setMustFlipVertically(boolean bl) {
        this.mustFlipVertically = bl;
    }

    public void setBuffer(Buffer buffer) {
        this.buffer = buffer;
        this.estimatedMemorySize = this.estimatedMemorySize(buffer);
    }

    public void setAlignment(int n2) {
        this.alignment = n2;
    }

    public void setRowLength(int n2) {
        this.rowLength = n2;
    }

    public void setHaveEXTABGR(boolean bl) {
        this.haveEXTABGR = bl;
    }

    public void setHaveGL12(boolean bl) {
        this.haveGL12 = bl;
    }

    public int getEstimatedMemorySize() {
        return this.estimatedMemorySize;
    }

    public void flush() {
        if (this.flusher != null) {
            this.flusher.flush();
            this.flusher = null;
        }
    }

    private void createNIOBufferFromImage(BufferedImage bufferedImage) {
        this.buffer = this.wrapImageDataBuffer(bufferedImage);
    }

    private Buffer wrapImageDataBuffer(BufferedImage object) {
        if ((object = ((BufferedImage)object).getRaster().getDataBuffer()) instanceof DataBufferByte) {
            return ByteBuffer.wrap(((DataBufferByte)object).getData());
        }
        if (object instanceof DataBufferDouble) {
            throw new RuntimeException("DataBufferDouble rasters not supported by OpenGL");
        }
        if (object instanceof DataBufferFloat) {
            return FloatBuffer.wrap(((DataBufferFloat)object).getData());
        }
        if (object instanceof DataBufferInt) {
            return IntBuffer.wrap(((DataBufferInt)object).getData());
        }
        if (object instanceof DataBufferShort) {
            return ShortBuffer.wrap(((DataBufferShort)object).getData());
        }
        if (object instanceof DataBufferUShort) {
            return ShortBuffer.wrap(((DataBufferUShort)object).getData());
        }
        throw new RuntimeException("Unexpected DataBuffer type?");
    }

    private void createFromImage(BufferedImage bufferedImage) {
        int n2;
        this.pixelType = 0;
        this.mustFlipVertically = true;
        this.width = bufferedImage.getWidth();
        this.height = bufferedImage.getHeight();
        SampleModel sampleModel = bufferedImage.getRaster().getSampleModel();
        if (sampleModel instanceof SinglePixelPackedSampleModel) {
            n2 = ((SinglePixelPackedSampleModel)sampleModel).getScanlineStride();
        } else if (sampleModel instanceof MultiPixelPackedSampleModel) {
            n2 = ((MultiPixelPackedSampleModel)sampleModel).getScanlineStride();
        } else if (sampleModel instanceof ComponentSampleModel) {
            n2 = ((ComponentSampleModel)sampleModel).getScanlineStride();
        } else {
            this.setupLazyCustomConversion(bufferedImage);
            return;
        }
        switch (bufferedImage.getType()) {
            case 1: {
                this.pixelFormat = 32993;
                this.pixelType = 33639;
                this.rowLength = n2;
                this.alignment = 4;
                this.expectingGL12 = true;
                this.setupLazyCustomConversion(bufferedImage);
                break;
            }
            case 3: {
                this.pixelFormat = 32993;
                this.pixelType = 33639;
                this.rowLength = n2;
                this.alignment = 4;
                this.expectingGL12 = true;
                this.setupLazyCustomConversion(bufferedImage);
                break;
            }
            case 4: {
                this.pixelFormat = 6408;
                this.pixelType = 33639;
                this.rowLength = n2;
                this.alignment = 4;
                this.expectingGL12 = true;
                this.setupLazyCustomConversion(bufferedImage);
                break;
            }
            case 5: {
                if (n2 % 3 == 0) {
                    this.pixelFormat = 32992;
                    this.pixelType = 5121;
                    this.rowLength = n2 / 3;
                    this.alignment = 1;
                    break;
                }
                this.setupLazyCustomConversion(bufferedImage);
                return;
            }
            case 7: {
                this.setupLazyCustomConversion(bufferedImage);
                return;
            }
            case 8: {
                this.pixelFormat = 6407;
                this.pixelType = 33635;
                this.rowLength = n2;
                this.alignment = 2;
                this.expectingGL12 = true;
                this.setupLazyCustomConversion(bufferedImage);
                break;
            }
            case 9: {
                this.pixelFormat = 32993;
                this.pixelType = 33638;
                this.rowLength = n2;
                this.alignment = 2;
                this.expectingGL12 = true;
                this.setupLazyCustomConversion(bufferedImage);
                break;
            }
            case 10: {
                this.pixelFormat = 6409;
                this.pixelType = 5121;
                this.rowLength = n2;
                this.alignment = 1;
                break;
            }
            case 11: {
                this.pixelFormat = 6409;
                this.pixelType = 5123;
                this.rowLength = n2;
                this.alignment = 2;
                break;
            }
            default: {
                ColorModel colorModel = bufferedImage.getColorModel();
                if (colorModel.equals(rgbColorModel)) {
                    this.pixelFormat = 6407;
                    this.pixelType = 5121;
                    this.rowLength = n2 / 3;
                    this.alignment = 1;
                    break;
                }
                if (colorModel.equals(rgbaColorModel)) {
                    this.pixelFormat = 6408;
                    this.pixelType = 5121;
                    this.rowLength = n2 / 4;
                    this.alignment = 4;
                    break;
                }
                this.setupLazyCustomConversion(bufferedImage);
                return;
            }
        }
        this.createNIOBufferFromImage(bufferedImage);
    }

    private void setupLazyCustomConversion(BufferedImage bufferedImage) {
        this.imageForLazyCustomConversion = bufferedImage;
        boolean bl = bufferedImage.getColorModel().hasAlpha();
        if (this.pixelFormat == 0) {
            this.pixelFormat = bl ? 6408 : 6407;
        }
        this.alignment = 1;
        this.rowLength = this.width;
        DataBuffer dataBuffer = bufferedImage.getRaster().getDataBuffer();
        if (dataBuffer instanceof DataBufferByte || this.isPackedInt(bufferedImage)) {
            if (this.pixelType == 0) {
                this.pixelType = 5121;
                return;
            }
        } else {
            if (dataBuffer instanceof DataBufferDouble) {
                throw new RuntimeException("DataBufferDouble rasters not supported by OpenGL");
            }
            if (dataBuffer instanceof DataBufferFloat) {
                if (this.pixelType == 0) {
                    this.pixelType = 5126;
                    return;
                }
            } else if (dataBuffer instanceof DataBufferInt) {
                if (this.pixelType == 0) {
                    this.pixelType = 5125;
                    return;
                }
            } else if (dataBuffer instanceof DataBufferShort) {
                if (this.pixelType == 0) {
                    this.pixelType = 5122;
                    return;
                }
            } else if (dataBuffer instanceof DataBufferUShort) {
                if (this.pixelType == 0) {
                    this.pixelType = 5123;
                    return;
                }
            } else {
                throw new RuntimeException("Unexpected DataBuffer type?");
            }
        }
    }

    private void createFromCustom(BufferedImage bufferedImage) {
        int n2;
        int n22 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        boolean bl = bufferedImage.getColorModel().hasAlpha();
        int bl2 = bufferedImage.getRaster().getDataBuffer().getDataType();
        if (this.isPackedInt(bufferedImage)) {
            n2 = 0;
        }
        ColorModel colorModel = n2 == 0 ? (bl ? rgbaColorModel : rgbColorModel) : (bl ? new ComponentColorModel(ColorSpace.getInstance(1000), null, true, true, 3, n2) : new ComponentColorModel(ColorSpace.getInstance(1000), null, false, false, 1, n2));
        boolean bl3 = colorModel.isAlphaPremultiplied();
        Object object = colorModel.createCompatibleWritableRaster(n22, n3);
        object = new BufferedImage(colorModel, (WritableRaster)object, bl3, null);
        Graphics2D graphics2D = ((BufferedImage)object).createGraphics();
        graphics2D.setComposite(AlphaComposite.Src);
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        this.createNIOBufferFromImage((BufferedImage)object);
    }

    private boolean isPackedInt(BufferedImage bufferedImage) {
        int n2 = bufferedImage.getType();
        return n2 == 1 || n2 == 4 || n2 == 2 || n2 == 3;
    }

    private void revertPixelFormatAndType() {
        this.pixelFormat = 0;
        this.pixelType = 0;
        this.setupLazyCustomConversion(this.imageForLazyCustomConversion);
    }

    private int estimatedMemorySize(Buffer buffer) {
        if (buffer == null) {
            return 0;
        }
        int n2 = buffer.capacity();
        if (buffer instanceof ByteBuffer) {
            return n2;
        }
        if (buffer instanceof IntBuffer) {
            return n2 << 2;
        }
        if (buffer instanceof FloatBuffer) {
            return n2 << 2;
        }
        if (buffer instanceof ShortBuffer) {
            return n2 << 1;
        }
        if (buffer instanceof LongBuffer) {
            return n2 << 3;
        }
        if (buffer instanceof DoubleBuffer) {
            return n2 << 3;
        }
        throw new RuntimeException(new StringBuffer("Unexpected buffer type ").append(buffer.getClass().getName()).toString());
    }
}

