/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.util.j2d;

import com.sun.opengl.impl.Debug;
import com.sun.opengl.impl.packrect.Rect;
import com.sun.opengl.impl.packrect.RectanglePacker;
import com.sun.opengl.util.FPSAnimator;
import com.sun.opengl.util.j2d.TextRenderer$1;
import com.sun.opengl.util.j2d.TextRenderer$2;
import com.sun.opengl.util.j2d.TextRenderer$DebugListener;
import com.sun.opengl.util.j2d.TextRenderer$DefaultRenderDelegate;
import com.sun.opengl.util.j2d.TextRenderer$Glyph;
import com.sun.opengl.util.j2d.TextRenderer$GlyphProducer;
import com.sun.opengl.util.j2d.TextRenderer$Manager;
import com.sun.opengl.util.j2d.TextRenderer$Pipelined_QuadRenderer;
import com.sun.opengl.util.j2d.TextRenderer$RenderDelegate;
import com.sun.opengl.util.j2d.TextRenderer$TextData;
import com.sun.opengl.util.j2d.TextureRenderer;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLContext;
import javax.media.opengl.glu.GLU;

public class TextRenderer {
    private static final boolean DEBUG = Debug.debug("TextRenderer");
    private static final boolean DISABLE_GLYPH_CACHE = false;
    private static final boolean DRAW_BBOXES = false;
    static final int kSize = 256;
    private static final int CYCLES_PER_FLUSH = 100;
    private static final float MAX_VERTICAL_FRAGMENTATION = 0.7f;
    static final int kQuadsPerBuffer = 100;
    static final int kCoordsPerVertVerts = 3;
    static final int kCoordsPerVertTex = 2;
    static final int kVertsPerQuad = 4;
    static final int kTotalBufferSizeVerts = 400;
    static final int kTotalBufferSizeCoordsVerts = 1200;
    static final int kTotalBufferSizeCoordsTex = 800;
    static final int kTotalBufferSizeBytesVerts = 4800;
    static final int kTotalBufferSizeBytesTex = 3200;
    static final int kSizeInBytes_OneVertices_VertexData = 12;
    static final int kSizeInBytes_OneVertices_TexData = 8;
    private Font font;
    private boolean antialiased;
    private boolean useFractionalMetrics;
    private boolean mipmap;
    private RectanglePacker packer;
    private boolean haveMaxSize;
    private TextRenderer$RenderDelegate renderDelegate;
    private TextureRenderer cachedBackingStore;
    private Graphics2D cachedGraphics;
    private FontRenderContext cachedFontRenderContext;
    private Map stringLocations = new HashMap();
    private TextRenderer$GlyphProducer mGlyphProducer;
    private int numRenderCycles;
    private boolean inBeginEndPair;
    private boolean isOrthoMode;
    private int beginRenderingWidth;
    private int beginRenderingHeight;
    private boolean beginRenderingDepthTestDisabled;
    private boolean haveCachedColor;
    private float cachedR;
    private float cachedG;
    private float cachedB;
    private float cachedA;
    private Color cachedColor;
    private boolean needToResetColor;
    private Frame dbgFrame;
    private boolean debugged;
    TextRenderer$Pipelined_QuadRenderer mPipelinedQuadRenderer;
    private boolean useVertexArrays = true;
    private boolean isExtensionAvailable_GL_VERSION_1_5;
    private boolean checkFor_isExtensionAvailable_GL_VERSION_1_5;
    private boolean smoothing = true;
    private char[] singleUnicode = new char[1];

    public TextRenderer(Font font) {
        this(font, false, false, null, false);
    }

    public TextRenderer(Font font, boolean bl) {
        this(font, false, false, null, bl);
    }

    public TextRenderer(Font font, boolean bl, boolean bl2) {
        this(font, bl, bl2, null, false);
    }

    public TextRenderer(Font font, boolean bl, boolean bl2, TextRenderer$RenderDelegate textRenderer$RenderDelegate) {
        this(font, bl, bl2, textRenderer$RenderDelegate, false);
    }

    public TextRenderer(Font font, boolean bl, boolean bl2, TextRenderer$RenderDelegate textRenderer$RenderDelegate, boolean bl3) {
        this.font = font;
        this.antialiased = bl;
        this.useFractionalMetrics = bl2;
        this.mipmap = bl3;
        this.packer = new RectanglePacker(new TextRenderer$Manager(this), 256, 256);
        if (textRenderer$RenderDelegate == null) {
            textRenderer$RenderDelegate = new TextRenderer$DefaultRenderDelegate();
        }
        this.renderDelegate = textRenderer$RenderDelegate;
        this.mGlyphProducer = new TextRenderer$GlyphProducer(this, font.getNumGlyphs());
    }

    public Rectangle2D getBounds(String string) {
        return this.getBounds((CharSequence)string);
    }

    public Rectangle2D getBounds(CharSequence object) {
        Rect rect = (Rect)this.stringLocations.get(object);
        if (rect != null) {
            object = (TextRenderer$TextData)rect.getUserData();
            return new Rectangle2D.Double(-((TextRenderer$TextData)object).origin().x, -((TextRenderer$TextData)object).origin().y, rect.w(), rect.h());
        }
        return this.normalize(this.renderDelegate.getBounds((CharSequence)object, this.font, this.getFontRenderContext()));
    }

    public Font getFont() {
        return this.font;
    }

    public FontRenderContext getFontRenderContext() {
        if (this.cachedFontRenderContext == null) {
            this.cachedFontRenderContext = this.getGraphics2D().getFontRenderContext();
        }
        return this.cachedFontRenderContext;
    }

    public void beginRendering(int n2, int n3) {
        this.beginRendering(n2, n3, true);
    }

    public void beginRendering(int n2, int n3, boolean bl) {
        this.beginRendering(true, n2, n3, bl);
    }

    public void begin3DRendering() {
        this.beginRendering(false, 0, 0, false);
    }

    public void setColor(Color color) {
        if (!(this.haveCachedColor && this.cachedColor != null && color.equals(this.cachedColor))) {
            this.flushGlyphPipeline();
        }
        this.getBackingStore().setColor(color);
        this.haveCachedColor = true;
        this.cachedColor = color;
    }

    public void setColor(float f2, float f3, float f4, float f5) {
        if (!(this.haveCachedColor && this.cachedColor == null && f2 == this.cachedR && f3 == this.cachedG && f4 == this.cachedB && f5 == this.cachedA)) {
            this.flushGlyphPipeline();
        }
        this.getBackingStore().setColor(f2, f3, f4, f5);
        this.haveCachedColor = true;
        this.cachedR = f2;
        this.cachedG = f3;
        this.cachedB = f4;
        this.cachedA = f5;
        this.cachedColor = null;
    }

    public void draw(CharSequence charSequence, int n2, int n3) {
        this.draw3D(charSequence, (float)n2, (float)n3, 0.0f, 1.0f);
    }

    public void draw(String string, int n2, int n3) {
        this.draw3D(string, (float)n2, (float)n3, 0.0f, 1.0f);
    }

    public void draw3D(CharSequence charSequence, float f2, float f3, float f4, float f5) {
        this.internal_draw3D(charSequence, f2, f3, f4, f5);
    }

    public void draw3D(String string, float f2, float f3, float f4, float f5) {
        this.internal_draw3D(string, f2, f3, f4, f5);
    }

    public float getCharWidth(char c2) {
        return this.mGlyphProducer.getGlyphPixelWidth(c2);
    }

    public void flush() {
        this.flushGlyphPipeline();
    }

    public void endRendering() {
        this.endRendering(true);
    }

    public void end3DRendering() {
        this.endRendering(false);
    }

    public void dispose() {
        this.packer.dispose();
        this.packer = null;
        this.cachedBackingStore = null;
        this.cachedGraphics = null;
        this.cachedFontRenderContext = null;
        if (this.dbgFrame != null) {
            this.dbgFrame.dispose();
        }
    }

    private static Rectangle2D preNormalize(Rectangle2D rectangle2D) {
        int n2 = (int)Math.floor(rectangle2D.getMinX()) - 1;
        int n3 = (int)Math.floor(rectangle2D.getMinY()) - 1;
        int n4 = (int)Math.ceil(rectangle2D.getMaxX()) + 1;
        int n5 = (int)Math.ceil(rectangle2D.getMaxY()) + 1;
        return new Rectangle2D.Double(n2, n3, n4 - n2, n5 - n3);
    }

    private Rectangle2D normalize(Rectangle2D rectangle2D) {
        int n2 = (int)Math.max(1.0, 0.015 * (double)this.font.getSize());
        return new Rectangle2D.Double((int)Math.floor(rectangle2D.getMinX() - (double)n2), (int)Math.floor(rectangle2D.getMinY() - (double)n2), (int)Math.ceil(rectangle2D.getWidth() + (double)(2 * n2)), (int)Math.ceil(rectangle2D.getHeight()) + 2 * n2);
    }

    private TextureRenderer getBackingStore() {
        TextureRenderer textureRenderer = (TextureRenderer)this.packer.getBackingStore();
        if (textureRenderer != this.cachedBackingStore) {
            if (this.cachedGraphics != null) {
                this.cachedGraphics.dispose();
                this.cachedGraphics = null;
                this.cachedFontRenderContext = null;
            }
            this.cachedBackingStore = textureRenderer;
        }
        return this.cachedBackingStore;
    }

    private Graphics2D getGraphics2D() {
        TextureRenderer textureRenderer = this.getBackingStore();
        if (this.cachedGraphics == null) {
            this.cachedGraphics = textureRenderer.createGraphics();
            this.cachedGraphics.setComposite(AlphaComposite.Src);
            this.cachedGraphics.setColor(Color.WHITE);
            this.cachedGraphics.setFont(this.font);
            this.cachedGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, this.antialiased ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            this.cachedGraphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, this.useFractionalMetrics ? RenderingHints.VALUE_FRACTIONALMETRICS_ON : RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        }
        return this.cachedGraphics;
    }

    private void beginRendering(boolean bl, int n2, int n3, boolean bl2) {
        if (DEBUG && !this.debugged) {
            this.debug();
        }
        this.inBeginEndPair = true;
        this.isOrthoMode = bl;
        this.beginRenderingWidth = n2;
        this.beginRenderingHeight = n3;
        this.beginRenderingDepthTestDisabled = bl2;
        if (bl) {
            this.getBackingStore().beginOrthoRendering(n2, n3, bl2);
        } else {
            this.getBackingStore().begin3DRendering();
        }
        GL gL = GLU.getCurrentGL();
        gL.glPushClientAttrib(-1);
        if (!this.haveMaxSize) {
            int[] nArray = new int[1];
            gL.glGetIntegerv(3379, nArray, 0);
            this.packer.setMaxSize(nArray[0], nArray[0]);
            this.haveMaxSize = true;
        }
        if (this.needToResetColor && this.haveCachedColor) {
            if (this.cachedColor == null) {
                this.getBackingStore().setColor(this.cachedR, this.cachedG, this.cachedB, this.cachedA);
            } else {
                this.getBackingStore().setColor(this.cachedColor);
            }
            this.needToResetColor = false;
        }
        if (this.mipmap && !this.getBackingStore().isUsingAutoMipmapGeneration()) {
            if (DEBUG) {
                System.err.println("Disabled mipmapping in TextRenderer");
            }
            this.mipmap = false;
        }
    }

    private void endRendering(boolean bl) {
        this.flushGlyphPipeline();
        this.inBeginEndPair = false;
        GL gL = GLU.getCurrentGL();
        gL.glPopClientAttrib();
        if (this.is15Available(gL)) {
            try {
                gL.glBindBuffer(34962, 0);
            }
            catch (Exception exception) {
                this.isExtensionAvailable_GL_VERSION_1_5 = false;
            }
        }
        if (bl) {
            this.getBackingStore().endOrthoRendering();
        } else {
            this.getBackingStore().end3DRendering();
        }
        if (++this.numRenderCycles >= 100) {
            this.numRenderCycles = 0;
            if (DEBUG) {
                System.err.println("Clearing unused entries in endRendering()");
            }
            this.clearUnusedEntries();
        }
    }

    private void clearUnusedEntries() {
        ArrayList arrayList = new ArrayList();
        this.packer.visit(new TextRenderer$1(this, arrayList));
        for (Rect rect : arrayList) {
            this.packer.remove(rect);
            this.stringLocations.remove(((TextRenderer$TextData)rect.getUserData()).string());
            int n2 = ((TextRenderer$TextData)rect.getUserData()).unicodeID;
            if (n2 <= 0) continue;
            this.mGlyphProducer.clearCacheEntry(n2);
        }
        float f2 = this.packer.verticalFragmentationRatio();
        if (!arrayList.isEmpty() && f2 > 0.7f) {
            if (DEBUG) {
                System.err.println("Compacting TextRenderer backing store due to vertical fragmentation " + f2);
            }
            this.packer.compact();
        }
        if (DEBUG) {
            this.getBackingStore().markDirty(0, 0, this.getBackingStore().getWidth(), this.getBackingStore().getHeight());
        }
    }

    private void internal_draw3D(CharSequence object, float f2, float f3, float f4, float f5) {
        object = this.mGlyphProducer.getGlyphs((CharSequence)object).iterator();
        while (object.hasNext()) {
            float f6 = ((TextRenderer$Glyph)object.next()).draw3D(f2, f3, f4, f5);
            f2 += f6 * f5;
        }
    }

    private void flushGlyphPipeline() {
        if (this.mPipelinedQuadRenderer != null) {
            TextRenderer$Pipelined_QuadRenderer.access$000(this.mPipelinedQuadRenderer);
        }
    }

    private void draw3D_ROBUST(CharSequence charSequence, float f2, float f3, float f4, float f5) {
        Object object;
        Rect rect = (Rect)this.stringLocations.get(charSequence = charSequence instanceof String ? (String)charSequence : charSequence.toString());
        if (rect == null) {
            this.getGraphics2D();
            Rectangle2D rectangle2D = TextRenderer.preNormalize(this.renderDelegate.getBounds((String)charSequence, this.font, this.getFontRenderContext()));
            Rectangle2D rectangle2D2 = this.normalize(rectangle2D);
            Point point = new Point((int)(-rectangle2D2.getMinX()), (int)(-rectangle2D2.getMinY()));
            rect = new Rect(0, 0, (int)rectangle2D2.getWidth(), (int)rectangle2D2.getHeight(), new TextRenderer$TextData((String)charSequence, point, rectangle2D, -1));
            this.packer.add(rect);
            this.stringLocations.put(charSequence, rect);
            object = this.getGraphics2D();
            int n2 = rect.x() + point.x;
            int n3 = rect.y() + point.y;
            ((Graphics2D)object).setComposite(AlphaComposite.Clear);
            ((Graphics)object).fillRect(rect.x(), rect.y(), rect.w(), rect.h());
            ((Graphics2D)object).setComposite(AlphaComposite.Src);
            this.renderDelegate.draw((Graphics2D)object, (String)charSequence, n2, n3);
            this.getBackingStore().markDirty(rect.x(), rect.y(), rect.w(), rect.h());
        }
        object = this.getBackingStore();
        TextRenderer$TextData textRenderer$TextData = (TextRenderer$TextData)rect.getUserData();
        textRenderer$TextData.markUsed();
        Rectangle2D rectangle2D = textRenderer$TextData.origRect();
        ((TextureRenderer)object).draw3DRect(f2 - f5 * (float)textRenderer$TextData.origOriginX(), f3 - f5 * ((float)rectangle2D.getHeight() - (float)textRenderer$TextData.origOriginY()), f4, rect.x() + (textRenderer$TextData.origin().x - textRenderer$TextData.origOriginX()), ((TextureRenderer)object).getHeight() - rect.y() - (int)rectangle2D.getHeight() - (textRenderer$TextData.origin().y - textRenderer$TextData.origOriginY()), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), f5);
    }

    private void debug() {
        this.dbgFrame = new Frame("TextRenderer Debug Output");
        Object object = new GLCanvas(new GLCapabilities(), null, GLContext.getCurrent(), null);
        ((GLCanvas)object).addGLEventListener(new TextRenderer$DebugListener(this, this.dbgFrame));
        this.dbgFrame.add((Component)object);
        object = new FPSAnimator((GLAutoDrawable)object, 10);
        this.dbgFrame.addWindowListener(new TextRenderer$2(this, (FPSAnimator)object));
        this.dbgFrame.setSize(256, 256);
        this.dbgFrame.setVisible(true);
        ((FPSAnimator)object).start();
        this.debugged = true;
    }

    public void setUseVertexArrays(boolean bl) {
        this.useVertexArrays = bl;
    }

    public boolean getUseVertexArrays() {
        return this.useVertexArrays;
    }

    public void setSmoothing(boolean bl) {
        this.smoothing = bl;
        this.getBackingStore().setSmoothing(bl);
    }

    public boolean getSmoothing() {
        return this.smoothing;
    }

    private boolean is15Available(GL gL) {
        if (!this.checkFor_isExtensionAvailable_GL_VERSION_1_5) {
            this.isExtensionAvailable_GL_VERSION_1_5 = gL.isExtensionAvailable("GL_VERSION_1_5");
            this.checkFor_isExtensionAvailable_GL_VERSION_1_5 = true;
        }
        return this.isExtensionAvailable_GL_VERSION_1_5;
    }

    static /* synthetic */ TextRenderer$RenderDelegate access$100(TextRenderer textRenderer) {
        return textRenderer.renderDelegate;
    }

    static /* synthetic */ boolean access$200(TextRenderer textRenderer) {
        return textRenderer.mipmap;
    }

    static /* synthetic */ boolean access$300(TextRenderer textRenderer) {
        return textRenderer.smoothing;
    }

    static /* synthetic */ boolean access$400() {
        return DEBUG;
    }

    static /* synthetic */ boolean access$500(TextRenderer textRenderer) {
        return textRenderer.inBeginEndPair;
    }

    static /* synthetic */ void access$600(TextRenderer textRenderer) {
        textRenderer.clearUnusedEntries();
    }

    static /* synthetic */ RectanglePacker access$700(TextRenderer textRenderer) {
        return textRenderer.packer;
    }

    static /* synthetic */ Map access$800(TextRenderer textRenderer) {
        return textRenderer.stringLocations;
    }

    static /* synthetic */ TextRenderer$GlyphProducer access$900(TextRenderer textRenderer) {
        return textRenderer.mGlyphProducer;
    }

    static /* synthetic */ boolean access$1000(TextRenderer textRenderer, GL gL) {
        return textRenderer.is15Available(gL);
    }

    static /* synthetic */ boolean access$1102(TextRenderer textRenderer, boolean bl) {
        textRenderer.isExtensionAvailable_GL_VERSION_1_5 = bl;
        return textRenderer.isExtensionAvailable_GL_VERSION_1_5;
    }

    static /* synthetic */ boolean access$1200(TextRenderer textRenderer) {
        return textRenderer.isOrthoMode;
    }

    static /* synthetic */ int access$1300(TextRenderer textRenderer) {
        return textRenderer.beginRenderingWidth;
    }

    static /* synthetic */ int access$1400(TextRenderer textRenderer) {
        return textRenderer.beginRenderingHeight;
    }

    static /* synthetic */ boolean access$1500(TextRenderer textRenderer) {
        return textRenderer.beginRenderingDepthTestDisabled;
    }

    static /* synthetic */ boolean access$1600(TextRenderer textRenderer) {
        return textRenderer.haveCachedColor;
    }

    static /* synthetic */ Color access$1700(TextRenderer textRenderer) {
        return textRenderer.cachedColor;
    }

    static /* synthetic */ float access$1800(TextRenderer textRenderer) {
        return textRenderer.cachedR;
    }

    static /* synthetic */ float access$1900(TextRenderer textRenderer) {
        return textRenderer.cachedG;
    }

    static /* synthetic */ float access$2000(TextRenderer textRenderer) {
        return textRenderer.cachedB;
    }

    static /* synthetic */ float access$2100(TextRenderer textRenderer) {
        return textRenderer.cachedA;
    }

    static /* synthetic */ boolean access$2202(TextRenderer textRenderer, boolean bl) {
        textRenderer.needToResetColor = bl;
        return textRenderer.needToResetColor;
    }

    static /* synthetic */ void access$2300(TextRenderer textRenderer, CharSequence charSequence, float f2, float f3, float f4, float f5) {
        textRenderer.draw3D_ROBUST(charSequence, f2, f3, f4, f5);
    }

    static /* synthetic */ Font access$2400(TextRenderer textRenderer) {
        return textRenderer.font;
    }

    static /* synthetic */ TextureRenderer access$2500(TextRenderer textRenderer) {
        return textRenderer.getBackingStore();
    }

    static /* synthetic */ Rectangle2D access$2600(Rectangle2D rectangle2D) {
        return TextRenderer.preNormalize(rectangle2D);
    }

    static /* synthetic */ Rectangle2D access$2700(TextRenderer textRenderer, Rectangle2D rectangle2D) {
        return textRenderer.normalize(rectangle2D);
    }

    static /* synthetic */ Graphics2D access$2800(TextRenderer textRenderer) {
        return textRenderer.getGraphics2D();
    }

    static /* synthetic */ char[] access$2900(TextRenderer textRenderer) {
        return textRenderer.singleUnicode;
    }

    static /* synthetic */ boolean access$3000(TextRenderer textRenderer) {
        return textRenderer.useVertexArrays;
    }
}

