/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.util;

import com.sun.opengl.util.BitmapCharRec;
import com.sun.opengl.util.BitmapFontRec;
import com.sun.opengl.util.CoordRec;
import com.sun.opengl.util.GLUTBitmap8x13;
import com.sun.opengl.util.GLUTBitmap9x15;
import com.sun.opengl.util.GLUTBitmapHelvetica10;
import com.sun.opengl.util.GLUTBitmapHelvetica12;
import com.sun.opengl.util.GLUTBitmapHelvetica18;
import com.sun.opengl.util.GLUTBitmapTimesRoman10;
import com.sun.opengl.util.GLUTBitmapTimesRoman24;
import com.sun.opengl.util.GLUTStrokeMonoRoman;
import com.sun.opengl.util.GLUTStrokeRoman;
import com.sun.opengl.util.StrokeCharRec;
import com.sun.opengl.util.StrokeFontRec;
import com.sun.opengl.util.StrokeRec;
import javax.media.opengl.GL;
import javax.media.opengl.GLException;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.GLUquadric;

public class GLUT {
    public static final int STROKE_ROMAN = 0;
    public static final int STROKE_MONO_ROMAN = 1;
    public static final int BITMAP_9_BY_15 = 2;
    public static final int BITMAP_8_BY_13 = 3;
    public static final int BITMAP_TIMES_ROMAN_10 = 4;
    public static final int BITMAP_TIMES_ROMAN_24 = 5;
    public static final int BITMAP_HELVETICA_10 = 6;
    public static final int BITMAP_HELVETICA_12 = 7;
    public static final int BITMAP_HELVETICA_18 = 8;
    private GLU glu = new GLU();
    private GLUquadric quadObj;
    private static float[][] boxVertices;
    private static final float[][] boxNormals;
    private static final int[][] boxFaces;
    private float[][] dodec;
    private static final float[][] odata;
    private static final int[][] ondex;
    private static final float X = 0.5257311f;
    private static final float Z = 0.8506508f;
    private static final float[][] idata;
    private static final int[][] index;
    private static final double[][] rdod_r;
    private static final int[][] rdod_v;
    private static final double[][] rdod_n;
    private static final float T = 1.7320508f;
    private static final float[][] tdata;
    private static final int[][] tndex;
    private static final int[][] teapotPatchData;
    private static final float[][] teapotCPData;
    private static final float[] teapotTex;
    private static final BitmapFontRec[] bitmapFonts;
    private static final StrokeFontRec[] strokeFonts;

    public void glutWireSphere(double d2, int n2, int n3) {
        this.quadObjInit(this.glu);
        this.glu.gluQuadricDrawStyle(this.quadObj, 100011);
        this.glu.gluQuadricNormals(this.quadObj, 100000);
        this.glu.gluSphere(this.quadObj, d2, n2, n3);
    }

    public void glutSolidSphere(double d2, int n2, int n3) {
        this.quadObjInit(this.glu);
        this.glu.gluQuadricDrawStyle(this.quadObj, 100012);
        this.glu.gluQuadricNormals(this.quadObj, 100000);
        this.glu.gluSphere(this.quadObj, d2, n2, n3);
    }

    public void glutWireCone(double d2, double d3, int n2, int n3) {
        this.quadObjInit(this.glu);
        this.glu.gluQuadricDrawStyle(this.quadObj, 100011);
        this.glu.gluQuadricNormals(this.quadObj, 100000);
        this.glu.gluCylinder(this.quadObj, d2, 0.0, d3, n2, n3);
    }

    public void glutSolidCone(double d2, double d3, int n2, int n3) {
        this.quadObjInit(this.glu);
        this.glu.gluQuadricDrawStyle(this.quadObj, 100012);
        this.glu.gluQuadricNormals(this.quadObj, 100000);
        this.glu.gluCylinder(this.quadObj, d2, 0.0, d3, n2, n3);
    }

    public void glutWireCylinder(double d2, double d3, int n2, int n3) {
        this.quadObjInit(this.glu);
        this.glu.gluQuadricDrawStyle(this.quadObj, 100011);
        this.glu.gluQuadricNormals(this.quadObj, 100000);
        this.glu.gluCylinder(this.quadObj, d2, d2, d3, n2, n3);
    }

    public void glutSolidCylinder(double d2, double d3, int n2, int n3) {
        int n4;
        GL gL = GLU.getCurrentGL();
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        double d4 = Math.PI * 2 / (double)n2;
        for (n4 = 0; n4 < n2; ++n4) {
            double d5 = (double)n4 * d4;
            dArray[n4] = Math.cos(d5) * d2;
            dArray2[n4] = Math.sin(d5) * d2;
        }
        gL.glBegin(6);
        gL.glNormal3d(0.0, 0.0, -1.0);
        gL.glVertex3d(0.0, 0.0, 0.0);
        for (n4 = 0; n4 < n2; ++n4) {
            gL.glVertex3d(dArray[n4], dArray2[n4], 0.0);
        }
        gL.glVertex3d(dArray[0], dArray2[0], 0.0);
        gL.glEnd();
        gL.glBegin(6);
        gL.glNormal3d(0.0, 0.0, 1.0);
        gL.glVertex3d(0.0, 0.0, d3);
        for (n4 = 0; n4 < n2; ++n4) {
            gL.glVertex3d(dArray[n4], dArray2[n4], d3);
        }
        gL.glVertex3d(dArray[0], dArray2[0], d3);
        gL.glEnd();
        this.quadObjInit(this.glu);
        this.glu.gluQuadricDrawStyle(this.quadObj, 100012);
        this.glu.gluQuadricNormals(this.quadObj, 100000);
        this.glu.gluCylinder(this.quadObj, d2, d2, d3, n2, n3);
    }

    public void glutWireCube(float f2) {
        this.drawBox(GLU.getCurrentGL(), f2, 2);
    }

    public void glutSolidCube(float f2) {
        this.drawBox(GLU.getCurrentGL(), f2, 7);
    }

    public void glutWireTorus(double d2, double d3, int n2, int n3) {
        GL gL = GLU.getCurrentGL();
        gL.glPushAttrib(8);
        gL.glPolygonMode(1032, 6913);
        GLUT.doughnut(gL, d2, d3, n2, n3);
        gL.glPopAttrib();
    }

    public void glutSolidTorus(double d2, double d3, int n2, int n3) {
        GLUT.doughnut(GLU.getCurrentGL(), d2, d3, n2, n3);
    }

    public void glutWireDodecahedron() {
        this.dodecahedron(GLU.getCurrentGL(), 2);
    }

    public void glutSolidDodecahedron() {
        this.dodecahedron(GLU.getCurrentGL(), 6);
    }

    public void glutWireOctahedron() {
        GLUT.octahedron(GLU.getCurrentGL(), 2);
    }

    public void glutSolidOctahedron() {
        GLUT.octahedron(GLU.getCurrentGL(), 4);
    }

    public void glutWireIcosahedron() {
        GLUT.icosahedron(GLU.getCurrentGL(), 2);
    }

    public void glutSolidIcosahedron() {
        GLUT.icosahedron(GLU.getCurrentGL(), 4);
    }

    public void glutWireTetrahedron() {
        GLUT.tetrahedron(GLU.getCurrentGL(), 2);
    }

    public void glutSolidTetrahedron() {
        GLUT.tetrahedron(GLU.getCurrentGL(), 4);
    }

    public void glutSolidTeapot(double d2) {
        this.glutSolidTeapot(d2, true);
    }

    public void glutSolidTeapot(double d2, boolean bl) {
        GLUT.teapot(GLU.getCurrentGL(), 14, d2, 6914, bl);
    }

    public void glutWireTeapot(double d2) {
        this.glutWireTeapot(d2, true);
    }

    public void glutWireTeapot(double d2, boolean bl) {
        GLUT.teapot(GLU.getCurrentGL(), 10, d2, 6913, bl);
    }

    public void glutBitmapCharacter(int n2, char c2) {
        GL gL = GLU.getCurrentGL();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        int[] nArray5 = new int[1];
        int[] nArray6 = new int[1];
        GLUT.beginBitmap(gL, nArray, nArray2, nArray3, nArray4, nArray5, nArray6);
        GLUT.bitmapCharacterImpl(gL, n2, c2);
        GLUT.endBitmap(gL, nArray, nArray2, nArray3, nArray4, nArray5, nArray6);
    }

    public void glutBitmapString(int n2, String string) {
        GL gL = GLU.getCurrentGL();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        int[] nArray5 = new int[1];
        int[] nArray6 = new int[1];
        GLUT.beginBitmap(gL, nArray, nArray2, nArray3, nArray4, nArray5, nArray6);
        int n3 = string.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            GLUT.bitmapCharacterImpl(gL, n2, string.charAt(i2));
        }
        GLUT.endBitmap(gL, nArray, nArray2, nArray3, nArray4, nArray5, nArray6);
    }

    public int glutBitmapWidth(int n2, char c2) {
        Object object = GLUT.getBitmapFont(n2);
        int n3 = c2 & 0xFFFF;
        c2 = (char)n3;
        if (n3 < ((BitmapFontRec)object).first || c2 >= ((BitmapFontRec)object).first + ((BitmapFontRec)object).num_chars) {
            return 0;
        }
        object = ((BitmapFontRec)object).ch[c2 - ((BitmapFontRec)object).first];
        if (object != null) {
            return (int)((BitmapCharRec)object).advance;
        }
        return 0;
    }

    public void glutStrokeCharacter(int n2, char c2) {
        GL gL = GLU.getCurrentGL();
        Object object = GLUT.getStrokeFont(n2);
        int n3 = c2 & 0xFFFF;
        c2 = (char)n3;
        if (n3 < 0 || c2 >= ((StrokeFontRec)object).num_chars) {
            return;
        }
        object = ((StrokeFontRec)object).ch[c2];
        if (object != null) {
            for (c2 = '\u0000'; c2 < ((StrokeCharRec)object).num_strokes; c2 = (char)(c2 + 1)) {
                StrokeRec strokeRec = ((StrokeCharRec)object).stroke[c2];
                gL.glBegin(3);
                for (int i2 = 0; i2 < strokeRec.num_coords; ++i2) {
                    CoordRec coordRec = strokeRec.coord[i2];
                    gL.glVertex2f(coordRec.x, coordRec.y);
                }
                gL.glEnd();
            }
            gL.glTranslatef(((StrokeCharRec)object).right, 0.0f, 0.0f);
        }
    }

    public void glutStrokeString(int n2, String string) {
        GL gL = GLU.getCurrentGL();
        StrokeFontRec strokeFontRec = GLUT.getStrokeFont(n2);
        int n3 = string.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            StrokeCharRec strokeCharRec;
            int n4 = string.charAt(i2) & 0xFFFF;
            if (n4 < 0 || n4 >= strokeFontRec.num_chars || (strokeCharRec = strokeFontRec.ch[n4]) == null) continue;
            for (int i3 = 0; i3 < strokeCharRec.num_strokes; ++i3) {
                StrokeRec strokeRec = strokeCharRec.stroke[i3];
                gL.glBegin(3);
                for (int i4 = 0; i4 < strokeRec.num_coords; ++i4) {
                    CoordRec coordRec = strokeRec.coord[i4];
                    gL.glVertex2f(coordRec.x, coordRec.y);
                }
                gL.glEnd();
            }
            gL.glTranslatef(strokeCharRec.right, 0.0f, 0.0f);
        }
    }

    public int glutStrokeWidth(int n2, char c2) {
        return (int)this.glutStrokeWidthf(n2, c2);
    }

    public float glutStrokeWidthf(int n2, char c2) {
        Object object = GLUT.getStrokeFont(n2);
        int n3 = c2 & 0xFFFF;
        c2 = (char)n3;
        if (n3 < 0 || c2 >= ((StrokeFontRec)object).num_chars) {
            return 0.0f;
        }
        object = ((StrokeFontRec)object).ch[c2];
        if (object != null) {
            return ((StrokeCharRec)object).right;
        }
        return 0.0f;
    }

    public int glutBitmapLength(int n2, String string) {
        BitmapFontRec bitmapFontRec = GLUT.getBitmapFont(n2);
        int n3 = 0;
        int n4 = string.length();
        for (int i2 = 0; i2 < n4; ++i2) {
            BitmapCharRec bitmapCharRec;
            int n5 = string.charAt(i2) & 0xFFFF;
            if (n5 < bitmapFontRec.first || n5 >= bitmapFontRec.first + bitmapFontRec.num_chars || (bitmapCharRec = bitmapFontRec.ch[n5 - bitmapFontRec.first]) == null) continue;
            n3 = (int)((float)n3 + bitmapCharRec.advance);
        }
        return n3;
    }

    public int glutStrokeLength(int n2, String string) {
        return (int)this.glutStrokeLengthf(n2, string);
    }

    public float glutStrokeLengthf(int n2, String string) {
        StrokeFontRec strokeFontRec = GLUT.getStrokeFont(n2);
        float f2 = 0.0f;
        int n3 = string.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            StrokeCharRec strokeCharRec;
            char c2 = string.charAt(i2);
            if (c2 < '\u0000' || c2 >= strokeFontRec.num_chars || (strokeCharRec = strokeFontRec.ch[c2]) == null) continue;
            f2 += strokeCharRec.right;
        }
        return f2;
    }

    public void glutWireRhombicDodecahedron() {
        GL gL = GLU.getCurrentGL();
        for (int i2 = 0; i2 < 12; ++i2) {
            gL.glBegin(2);
            gL.glNormal3dv(rdod_n[i2], 0);
            gL.glVertex3dv(rdod_r[rdod_v[i2][0]], 0);
            gL.glVertex3dv(rdod_r[rdod_v[i2][1]], 0);
            gL.glVertex3dv(rdod_r[rdod_v[i2][2]], 0);
            gL.glVertex3dv(rdod_r[rdod_v[i2][3]], 0);
            gL.glEnd();
        }
    }

    public void glutSolidRhombicDodecahedron() {
        GL gL = GLU.getCurrentGL();
        gL.glBegin(7);
        for (int i2 = 0; i2 < 12; ++i2) {
            gL.glNormal3dv(rdod_n[i2], 0);
            gL.glVertex3dv(rdod_r[rdod_v[i2][0]], 0);
            gL.glVertex3dv(rdod_r[rdod_v[i2][1]], 0);
            gL.glVertex3dv(rdod_r[rdod_v[i2][2]], 0);
            gL.glVertex3dv(rdod_r[rdod_v[i2][3]], 0);
        }
        gL.glEnd();
    }

    private void quadObjInit(GLU gLU) {
        if (this.quadObj == null) {
            this.quadObj = gLU.gluNewQuadric();
        }
        if (this.quadObj == null) {
            throw new GLException("Out of memory");
        }
    }

    private static void doughnut(GL gL, double d2, double d3, int n2, int n3) {
        float f2 = (float)(Math.PI * 2 / (double)n3);
        float f3 = (float)(Math.PI * 2 / (double)n2);
        float f4 = 0.0f;
        float f5 = 1.0f;
        float f6 = 0.0f;
        --n3;
        while (n3 >= 0) {
            float f7 = f4 + f2;
            float f8 = (float)Math.cos(f7);
            float f9 = (float)Math.sin(f7);
            gL.glBegin(8);
            float f10 = 0.0f;
            for (int i2 = n2; i2 >= 0; --i2) {
                float f11 = (float)Math.cos(f10 += f3);
                float f12 = (float)Math.sin(f10);
                float f13 = (float)(d3 + d2 * (double)f11);
                gL.glNormal3f(f8 * f11, -f9 * f11, f12);
                gL.glVertex3f(f8 * f13, -f9 * f13, (float)d2 * f12);
                gL.glNormal3f(f5 * f11, -f6 * f11, f12);
                gL.glVertex3f(f5 * f13, -f6 * f13, (float)d2 * f12);
            }
            gL.glEnd();
            f4 = f7;
            f5 = f8;
            f6 = f9;
            --n3;
        }
    }

    private void drawBox(GL gL, float f2, int n2) {
        Object object;
        if (boxVertices == null) {
            object = new float[8][];
            for (int i2 = 0; i2 < 8; ++i2) {
                object[i2] = new float[3];
            }
            object[3][0] = -0.5f;
            object[2][0] = -0.5f;
            object[1][0] = -0.5f;
            object[0][0] = -0.5f;
            object[7][0] = 0.5f;
            object[6][0] = 0.5f;
            object[5][0] = 0.5f;
            object[4][0] = 0.5f;
            object[5][1] = -0.5f;
            object[4][1] = -0.5f;
            object[1][1] = -0.5f;
            object[0][1] = -0.5f;
            object[7][1] = 0.5f;
            object[6][1] = 0.5f;
            object[3][1] = 0.5f;
            object[2][1] = 0.5f;
            object[7][2] = -0.5f;
            object[4][2] = -0.5f;
            object[3][2] = -0.5f;
            object[0][2] = -0.5f;
            object[6][2] = 0.5f;
            object[5][2] = 0.5f;
            object[2][2] = 0.5f;
            object[1][2] = 0.5f;
            boxVertices = object;
        }
        object = boxVertices;
        float[][] fArray = boxNormals;
        int[][] nArray = boxFaces;
        for (int i3 = 5; i3 >= 0; --i3) {
            gL.glBegin(n2);
            gL.glNormal3fv(fArray[i3], 0);
            float[] fArray2 = object[nArray[i3][0]];
            gL.glVertex3f(fArray2[0] * f2, fArray2[1] * f2, fArray2[2] * f2);
            fArray2 = object[nArray[i3][1]];
            gL.glVertex3f(fArray2[0] * f2, fArray2[1] * f2, fArray2[2] * f2);
            fArray2 = object[nArray[i3][2]];
            gL.glVertex3f(fArray2[0] * f2, fArray2[1] * f2, fArray2[2] * f2);
            fArray2 = object[nArray[i3][3]];
            gL.glVertex3f(fArray2[0] * f2, fArray2[1] * f2, fArray2[2] * f2);
            gL.glEnd();
        }
    }

    private void initDodecahedron() {
        this.dodec = new float[20][];
        for (int i2 = 0; i2 < this.dodec.length; ++i2) {
            this.dodec[i2] = new float[3];
        }
        float f2 = (float)Math.sqrt(2.0 / (3.0 + Math.sqrt(5.0)));
        float f3 = 1.0f + (float)Math.sqrt(6.0 / (3.0 + Math.sqrt(5.0)) - 2.0 + 2.0 * Math.sqrt(2.0 / (3.0 + Math.sqrt(5.0))));
        this.dodec[0][0] = -f2;
        this.dodec[0][1] = 0.0f;
        this.dodec[0][2] = f3;
        this.dodec[1][0] = f2;
        this.dodec[1][1] = 0.0f;
        this.dodec[1][2] = f3;
        this.dodec[2][0] = -1.0f;
        this.dodec[2][1] = -1.0f;
        this.dodec[2][2] = -1.0f;
        this.dodec[3][0] = -1.0f;
        this.dodec[3][1] = -1.0f;
        this.dodec[3][2] = 1.0f;
        this.dodec[4][0] = -1.0f;
        this.dodec[4][1] = 1.0f;
        this.dodec[4][2] = -1.0f;
        this.dodec[5][0] = -1.0f;
        this.dodec[5][1] = 1.0f;
        this.dodec[5][2] = 1.0f;
        this.dodec[6][0] = 1.0f;
        this.dodec[6][1] = -1.0f;
        this.dodec[6][2] = -1.0f;
        this.dodec[7][0] = 1.0f;
        this.dodec[7][1] = -1.0f;
        this.dodec[7][2] = 1.0f;
        this.dodec[8][0] = 1.0f;
        this.dodec[8][1] = 1.0f;
        this.dodec[8][2] = -1.0f;
        this.dodec[9][0] = 1.0f;
        this.dodec[9][1] = 1.0f;
        this.dodec[9][2] = 1.0f;
        this.dodec[10][0] = f3;
        this.dodec[10][1] = f2;
        this.dodec[10][2] = 0.0f;
        this.dodec[11][0] = f3;
        this.dodec[11][1] = -f2;
        this.dodec[11][2] = 0.0f;
        this.dodec[12][0] = -f3;
        this.dodec[12][1] = f2;
        this.dodec[12][2] = 0.0f;
        this.dodec[13][0] = -f3;
        this.dodec[13][1] = -f2;
        this.dodec[13][2] = 0.0f;
        this.dodec[14][0] = -f2;
        this.dodec[14][1] = 0.0f;
        this.dodec[14][2] = -f3;
        this.dodec[15][0] = f2;
        this.dodec[15][1] = 0.0f;
        this.dodec[15][2] = -f3;
        this.dodec[16][0] = 0.0f;
        this.dodec[16][1] = f3;
        this.dodec[16][2] = f2;
        this.dodec[17][0] = 0.0f;
        this.dodec[17][1] = f3;
        this.dodec[17][2] = -f2;
        this.dodec[18][0] = 0.0f;
        this.dodec[18][1] = -f3;
        this.dodec[18][2] = f2;
        this.dodec[19][0] = 0.0f;
        this.dodec[19][1] = -f3;
        this.dodec[19][2] = -f2;
    }

    private static void diff3(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray3[0] = fArray[0] - fArray2[0];
        fArray3[1] = fArray[1] - fArray2[1];
        fArray3[2] = fArray[2] - fArray2[2];
    }

    private static void crossprod(float[] fArray, float[] fArray2, float[] fArray3) {
        float[] fArray4 = new float[3];
        float[] fArray5 = fArray4;
        fArray4[0] = fArray[1] * fArray2[2] - fArray2[1] * fArray[2];
        fArray5[1] = fArray[2] * fArray2[0] - fArray2[2] * fArray[0];
        fArray5[2] = fArray[0] * fArray2[1] - fArray2[0] * fArray[1];
        fArray3[0] = fArray5[0];
        fArray3[1] = fArray5[1];
        fArray3[2] = fArray5[2];
    }

    private static void normalize(float[] fArray) {
        float f2 = (float)Math.sqrt(fArray[0] * fArray[0] + fArray[1] * fArray[1] + fArray[2] * fArray[2]);
        if ((double)f2 == 0.0) {
            f2 = 1.0f;
            fArray[0] = 1.0f;
        }
        f2 = 1.0f / f2;
        fArray[0] = fArray[0] * f2;
        fArray[1] = fArray[1] * f2;
        fArray[2] = fArray[2] * f2;
    }

    private void pentagon(GL gL, int n2, int n3, int n4, int n5, int n6, int n7) {
        float[] fArray = new float[3];
        float[] fArray2 = new float[3];
        float[] fArray3 = new float[3];
        GLUT.diff3(this.dodec[n2], this.dodec[n3], fArray2);
        GLUT.diff3(this.dodec[n3], this.dodec[n4], fArray3);
        GLUT.crossprod(fArray2, fArray3, fArray);
        GLUT.normalize(fArray);
        gL.glBegin(n7);
        gL.glNormal3fv(fArray, 0);
        gL.glVertex3fv(this.dodec[n2], 0);
        gL.glVertex3fv(this.dodec[n3], 0);
        gL.glVertex3fv(this.dodec[n4], 0);
        gL.glVertex3fv(this.dodec[n5], 0);
        gL.glVertex3fv(this.dodec[n6], 0);
        gL.glEnd();
    }

    private void dodecahedron(GL gL, int n2) {
        if (this.dodec == null) {
            this.initDodecahedron();
        }
        this.pentagon(gL, 0, 1, 9, 16, 5, n2);
        this.pentagon(gL, 1, 0, 3, 18, 7, n2);
        this.pentagon(gL, 1, 7, 11, 10, 9, n2);
        this.pentagon(gL, 11, 7, 18, 19, 6, n2);
        this.pentagon(gL, 8, 17, 16, 9, 10, n2);
        this.pentagon(gL, 2, 14, 15, 6, 19, n2);
        this.pentagon(gL, 2, 13, 12, 4, 14, n2);
        this.pentagon(gL, 2, 19, 18, 3, 13, n2);
        this.pentagon(gL, 3, 0, 5, 12, 13, n2);
        this.pentagon(gL, 6, 15, 8, 10, 11, n2);
        this.pentagon(gL, 4, 17, 8, 15, 14, n2);
        this.pentagon(gL, 4, 12, 5, 16, 17, n2);
    }

    private static void recorditem(GL gL, float[] fArray, float[] fArray2, float[] fArray3, int n2) {
        float[] fArray4 = new float[3];
        float[] fArray5 = new float[3];
        GLUT.diff3(fArray, fArray2, fArray4);
        GLUT.diff3(fArray2, fArray3, fArray5);
        GLUT.crossprod(fArray4, fArray5, fArray5);
        GLUT.normalize(fArray5);
        gL.glBegin(n2);
        gL.glNormal3fv(fArray5, 0);
        gL.glVertex3fv(fArray, 0);
        gL.glVertex3fv(fArray2, 0);
        gL.glVertex3fv(fArray3, 0);
        gL.glEnd();
    }

    private static void subdivide(GL gL, float[] fArray, float[] fArray2, float[] fArray3, int n2) {
        float[] fArray4 = new float[3];
        float[] fArray5 = new float[3];
        float[] fArray6 = new float[3];
        for (int i2 = 0; i2 <= 0; ++i2) {
            for (int i3 = 0; i3 <= 0; ++i3) {
                for (int i4 = 0; i4 < 3; ++i4) {
                    fArray4[i4] = 0.0f * fArray[i4] + 0.0f * fArray2[i4] + 1.0f * fArray3[i4];
                    fArray5[i4] = 1.0f * fArray[i4] + 0.0f * fArray2[i4] + 0.0f * fArray3[i4];
                    fArray6[i4] = 0.0f * fArray[i4] + 1.0f * fArray2[i4] + 0.0f * fArray3[i4];
                }
                float f2 = (float)Math.sqrt(fArray4[0] * fArray4[0] + fArray4[1] * fArray4[1] + fArray4[2] * fArray4[2]);
                fArray4[0] = fArray4[0] / f2;
                fArray4[1] = fArray4[1] / f2;
                fArray4[2] = fArray4[2] / f2;
                f2 = (float)Math.sqrt(fArray5[0] * fArray5[0] + fArray5[1] * fArray5[1] + fArray5[2] * fArray5[2]);
                fArray5[0] = fArray5[0] / f2;
                fArray5[1] = fArray5[1] / f2;
                fArray5[2] = fArray5[2] / f2;
                f2 = (float)Math.sqrt(fArray6[0] * fArray6[0] + fArray6[1] * fArray6[1] + fArray6[2] * fArray6[2]);
                fArray6[0] = fArray6[0] / f2;
                fArray6[1] = fArray6[1] / f2;
                fArray6[2] = fArray6[2] / f2;
                GLUT.recorditem(gL, fArray5, fArray4, fArray6, n2);
            }
        }
    }

    private static void drawtriangle(GL gL, int n2, float[][] fArray, int[][] nArray, int n3) {
        float[] fArray2 = fArray[nArray[n2][0]];
        float[] fArray3 = fArray[nArray[n2][1]];
        float[] fArray4 = fArray[nArray[n2][2]];
        GLUT.subdivide(gL, fArray2, fArray3, fArray4, n3);
    }

    private static void octahedron(GL gL, int n2) {
        for (int i2 = 7; i2 >= 0; --i2) {
            GLUT.drawtriangle(gL, i2, odata, ondex, n2);
        }
    }

    private static void icosahedron(GL gL, int n2) {
        for (int i2 = 19; i2 >= 0; --i2) {
            GLUT.drawtriangle(gL, i2, idata, index, n2);
        }
    }

    private static final void tetrahedron(GL gL, int n2) {
        for (int i2 = 3; i2 >= 0; --i2) {
            GLUT.drawtriangle(gL, i2, tdata, tndex, n2);
        }
    }

    private static void teapot(GL gL, int n2, double d2, int n3, boolean bl) {
        float[] fArray = new float[48];
        float[] fArray2 = new float[48];
        float[] fArray3 = new float[48];
        float[] fArray4 = new float[48];
        gL.glPushAttrib(73736);
        gL.glEnable(3456);
        gL.glEnable(2977);
        gL.glEnable(3511);
        gL.glEnable(3508);
        gL.glPushMatrix();
        if (!bl) {
            gL.glFrontFace(2304);
            gL.glScaled(d2 * 0.5, d2 * 0.5, d2 * 0.5);
        } else {
            gL.glRotatef(270.0f, 1.0f, 0.0f, 0.0f);
            gL.glScalef((float)(d2 * 0.5), (float)(d2 * 0.5), (float)(d2 * 0.5));
            gL.glTranslatef(0.0f, 0.0f, -1.5f);
        }
        for (int i2 = 0; i2 < 10; ++i2) {
            for (int i3 = 0; i3 < 4; ++i3) {
                for (int i4 = 0; i4 < 4; ++i4) {
                    for (int i5 = 0; i5 < 3; ++i5) {
                        fArray[((i3 << 2) + i4) * 3 + i5] = teapotCPData[teapotPatchData[i2][(i3 << 2) + i4]][i5];
                        fArray2[((i3 << 2) + i4) * 3 + i5] = teapotCPData[teapotPatchData[i2][(i3 << 2) + (3 - i4)]][i5];
                        if (i5 == 1) {
                            int n4 = ((i3 << 2) + i4) * 3 + i5;
                            fArray2[n4] = (float)(-((double)fArray2[n4]));
                        }
                        if (i2 >= 6) continue;
                        fArray3[((i3 << 2) + i4) * 3 + i5] = teapotCPData[teapotPatchData[i2][(i3 << 2) + (3 - i4)]][i5];
                        if (i5 == 0) {
                            int n5 = ((i3 << 2) + i4) * 3 + i5;
                            fArray3[n5] = (float)(-((double)fArray3[n5]));
                        }
                        fArray4[((i3 << 2) + i4) * 3 + i5] = teapotCPData[teapotPatchData[i2][(i3 << 2) + i4]][i5];
                        if (i5 == 0) {
                            int n6 = ((i3 << 2) + i4) * 3 + i5;
                            fArray4[n6] = (float)(-((double)fArray4[n6]));
                        }
                        if (i5 != 1) continue;
                        int n7 = ((i3 << 2) + i4) * 3 + i5;
                        fArray4[n7] = (float)(-((double)fArray4[n7]));
                    }
                }
            }
            gL.glMap2f(3508, 0.0f, 1.0f, 2, 2, 0.0f, 1.0f, 4, 2, teapotTex, 0);
            gL.glMap2f(3511, 0.0f, 1.0f, 3, 4, 0.0f, 1.0f, 12, 4, fArray, 0);
            gL.glMapGrid2f(n2, 0.0f, 1.0f, n2, 0.0f, 1.0f);
            GLUT.evaluateTeapotMesh(gL, n2, n3, i2, !bl);
            gL.glMap2f(3511, 0.0f, 1.0f, 3, 4, 0.0f, 1.0f, 12, 4, fArray2, 0);
            GLUT.evaluateTeapotMesh(gL, n2, n3, i2, !bl);
            if (i2 >= 6) continue;
            gL.glMap2f(3511, 0.0f, 1.0f, 3, 4, 0.0f, 1.0f, 12, 4, fArray3, 0);
            GLUT.evaluateTeapotMesh(gL, n2, n3, i2, !bl);
            gL.glMap2f(3511, 0.0f, 1.0f, 3, 4, 0.0f, 1.0f, 12, 4, fArray4, 0);
            GLUT.evaluateTeapotMesh(gL, n2, n3, i2, !bl);
        }
        gL.glPopMatrix();
        gL.glPopAttrib();
    }

    private static void evaluateTeapotMesh(GL gL, int n2, int n3, int n4, boolean n5) {
        if (n5 != 0 && (n4 == 5 || n4 == 3)) {
            gL.glPolygonMode(1032, n3);
            for (n3 = 0; n3 < n2; ++n3) {
                if (n3 == 0) {
                    gL.glDisable(3456);
                    gL.glNormal3f(0.0f, 0.0f, n4 == 3 ? 1.0f : -1.0f);
                    gL.glBegin(6);
                    gL.glEvalCoord2f(0.0f, 0.0f);
                    for (n5 = 0; n5 <= n2; ++n5) {
                        gL.glEvalCoord2f((float)n5 / (float)n2, 1.0f / (float)n2 / (float)n2);
                    }
                    gL.glEnd();
                    gL.glEnable(3456);
                }
                gL.glBegin(8);
                for (n5 = n2; n5 >= 0; --n5) {
                    gL.glEvalCoord2f((float)n5 / (float)n2, (float)(n3 + 1) / (float)n2);
                    gL.glEvalCoord2f((float)n5 / (float)n2, Math.max((float)n3, 1.0f / (float)n2) / (float)n2);
                }
                gL.glEnd();
            }
            return;
        }
        gL.glEvalMesh2(n3, 0, n2, 0, n2);
    }

    private static void bitmapCharacterImpl(GL gL, int n2, char c2) {
        Object object = GLUT.getBitmapFont(n2);
        int n3 = c2 & 0xFFFF;
        c2 = (char)n3;
        if (n3 < ((BitmapFontRec)object).first || c2 >= ((BitmapFontRec)object).first + ((BitmapFontRec)object).num_chars) {
            return;
        }
        object = ((BitmapFontRec)object).ch[c2 - ((BitmapFontRec)object).first];
        if (object != null) {
            gL.glBitmap(((BitmapCharRec)object).width, ((BitmapCharRec)object).height, ((BitmapCharRec)object).xorig, ((BitmapCharRec)object).yorig, ((BitmapCharRec)object).advance, 0.0f, ((BitmapCharRec)object).bitmap, 0);
        }
    }

    private static BitmapFontRec getBitmapFont(int n2) {
        BitmapFontRec bitmapFontRec = bitmapFonts[n2];
        if (bitmapFontRec == null) {
            switch (n2) {
                case 2: {
                    bitmapFontRec = GLUTBitmap9x15.glutBitmap9By15;
                    break;
                }
                case 3: {
                    bitmapFontRec = GLUTBitmap8x13.glutBitmap8By13;
                    break;
                }
                case 4: {
                    bitmapFontRec = GLUTBitmapTimesRoman10.glutBitmapTimesRoman10;
                    break;
                }
                case 5: {
                    bitmapFontRec = GLUTBitmapTimesRoman24.glutBitmapTimesRoman24;
                    break;
                }
                case 6: {
                    bitmapFontRec = GLUTBitmapHelvetica10.glutBitmapHelvetica10;
                    break;
                }
                case 7: {
                    bitmapFontRec = GLUTBitmapHelvetica12.glutBitmapHelvetica12;
                    break;
                }
                case 8: {
                    bitmapFontRec = GLUTBitmapHelvetica18.glutBitmapHelvetica18;
                    break;
                }
                default: {
                    throw new GLException("Unknown bitmap font number " + n2);
                }
            }
            GLUT.bitmapFonts[n2] = bitmapFontRec;
        }
        return bitmapFontRec;
    }

    private static StrokeFontRec getStrokeFont(int n2) {
        StrokeFontRec strokeFontRec = strokeFonts[n2];
        if (strokeFontRec == null) {
            switch (n2) {
                case 0: {
                    strokeFontRec = GLUTStrokeRoman.glutStrokeRoman;
                    break;
                }
                case 1: {
                    strokeFontRec = GLUTStrokeMonoRoman.glutStrokeMonoRoman;
                    break;
                }
                default: {
                    throw new GLException("Unknown stroke font number " + n2);
                }
            }
        }
        return strokeFontRec;
    }

    private static void beginBitmap(GL gL, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, int[] nArray6) {
        gL.glGetIntegerv(3312, nArray, 0);
        gL.glGetIntegerv(3313, nArray2, 0);
        gL.glGetIntegerv(3314, nArray3, 0);
        gL.glGetIntegerv(3315, nArray4, 0);
        gL.glGetIntegerv(3316, nArray5, 0);
        gL.glGetIntegerv(3317, nArray6, 0);
        gL.glPixelStorei(3312, 0);
        gL.glPixelStorei(3313, 0);
        gL.glPixelStorei(3314, 0);
        gL.glPixelStorei(3315, 0);
        gL.glPixelStorei(3316, 0);
        gL.glPixelStorei(3317, 1);
    }

    private static void endBitmap(GL gL, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, int[] nArray6) {
        gL.glPixelStorei(3312, nArray[0]);
        gL.glPixelStorei(3313, nArray2[0]);
        gL.glPixelStorei(3314, nArray3[0]);
        gL.glPixelStorei(3315, nArray4[0]);
        gL.glPixelStorei(3316, nArray5[0]);
        gL.glPixelStorei(3317, nArray6[0]);
    }

    static {
        boxNormals = new float[][]{{-1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {1.0f, 0.0f, 0.0f}, {0.0f, -1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}, {0.0f, 0.0f, -1.0f}};
        boxFaces = new int[][]{{0, 1, 2, 3}, {3, 2, 6, 7}, {7, 6, 5, 4}, {4, 5, 1, 0}, {5, 6, 2, 1}, {7, 4, 0, 3}};
        odata = new float[][]{{1.0f, 0.0f, 0.0f}, {-1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, -1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}, {0.0f, 0.0f, -1.0f}};
        ondex = new int[][]{{0, 4, 2}, {1, 2, 4}, {0, 3, 4}, {1, 4, 3}, {0, 2, 5}, {1, 5, 2}, {0, 5, 3}, {1, 3, 5}};
        idata = new float[][]{{-0.5257311f, 0.0f, 0.8506508f}, {0.5257311f, 0.0f, 0.8506508f}, {-0.5257311f, 0.0f, -0.8506508f}, {0.5257311f, 0.0f, -0.8506508f}, {0.0f, 0.8506508f, 0.5257311f}, {0.0f, 0.8506508f, -0.5257311f}, {0.0f, -0.8506508f, 0.5257311f}, {0.0f, -0.8506508f, -0.5257311f}, {0.8506508f, 0.5257311f, 0.0f}, {-0.8506508f, 0.5257311f, 0.0f}, {0.8506508f, -0.5257311f, 0.0f}, {-0.8506508f, -0.5257311f, 0.0f}};
        index = new int[][]{{0, 4, 1}, {0, 9, 4}, {9, 5, 4}, {4, 5, 8}, {4, 8, 1}, {8, 10, 1}, {8, 3, 10}, {5, 3, 8}, {5, 2, 3}, {2, 7, 3}, {7, 10, 3}, {7, 6, 10}, {7, 11, 6}, {11, 0, 6}, {0, 1, 6}, {6, 1, 10}, {9, 0, 11}, {9, 11, 2}, {9, 2, 5}, {7, 2, 11}};
        rdod_r = new double[][]{{0.0, 0.0, 1.0}, {0.707106781187, 0.0, 0.5}, {0.0, 0.707106781187, 0.5}, {-0.707106781187, 0.0, 0.5}, {0.0, -0.707106781187, 0.5}, {0.707106781187, 0.707106781187, 0.0}, {-0.707106781187, 0.707106781187, 0.0}, {-0.707106781187, -0.707106781187, 0.0}, {0.707106781187, -0.707106781187, 0.0}, {0.707106781187, 0.0, -0.5}, {0.0, 0.707106781187, -0.5}, {-0.707106781187, 0.0, -0.5}, {0.0, -0.707106781187, -0.5}, {0.0, 0.0, -1.0}};
        rdod_v = new int[][]{{0, 1, 5, 2}, {0, 2, 6, 3}, {0, 3, 7, 4}, {0, 4, 8, 1}, {5, 10, 6, 2}, {6, 11, 7, 3}, {7, 12, 8, 4}, {8, 9, 5, 1}, {5, 9, 13, 10}, {6, 10, 13, 11}, {7, 11, 13, 12}, {8, 12, 13, 9}};
        rdod_n = new double[][]{{0.353553390594, 0.353553390594, 0.5}, {-0.353553390594, 0.353553390594, 0.5}, {-0.353553390594, -0.353553390594, 0.5}, {0.353553390594, -0.353553390594, 0.5}, {0.0, 1.0, 0.0}, {-1.0, 0.0, 0.0}, {0.0, -1.0, 0.0}, {1.0, 0.0, 0.0}, {0.353553390594, 0.353553390594, -0.5}, {-0.353553390594, 0.353553390594, -0.5}, {-0.353553390594, -0.353553390594, -0.5}, {0.353553390594, -0.353553390594, -0.5}};
        tdata = new float[][]{{1.7320508f, 1.7320508f, 1.7320508f}, {1.7320508f, -1.7320508f, -1.7320508f}, {-1.7320508f, 1.7320508f, -1.7320508f}, {-1.7320508f, -1.7320508f, 1.7320508f}};
        tndex = new int[][]{{0, 1, 3}, {2, 1, 0}, {3, 2, 0}, {1, 2, 3}};
        teapotPatchData = new int[][]{{102, 103, 104, 105, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, {12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27}, {24, 25, 26, 27, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40}, {96, 96, 96, 96, 97, 98, 99, 100, 101, 101, 101, 101, 0, 1, 2, 3}, {0, 1, 2, 3, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117}, {118, 118, 118, 118, 124, 122, 119, 121, 123, 126, 125, 120, 40, 39, 38, 37}, {41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56}, {53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 28, 65, 66, 67}, {68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83}, {80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95}};
        teapotCPData = new float[][]{{0.2f, 0.0f, 2.7f}, {0.2f, -0.112f, 2.7f}, {0.112f, -0.2f, 2.7f}, {0.0f, -0.2f, 2.7f}, {1.3375f, 0.0f, 2.53125f}, {1.3375f, -0.749f, 2.53125f}, {0.749f, -1.3375f, 2.53125f}, {0.0f, -1.3375f, 2.53125f}, {1.4375f, 0.0f, 2.53125f}, {1.4375f, -0.805f, 2.53125f}, {0.805f, -1.4375f, 2.53125f}, {0.0f, -1.4375f, 2.53125f}, {1.5f, 0.0f, 2.4f}, {1.5f, -0.84f, 2.4f}, {0.84f, -1.5f, 2.4f}, {0.0f, -1.5f, 2.4f}, {1.75f, 0.0f, 1.875f}, {1.75f, -0.98f, 1.875f}, {0.98f, -1.75f, 1.875f}, {0.0f, -1.75f, 1.875f}, {2.0f, 0.0f, 1.35f}, {2.0f, -1.12f, 1.35f}, {1.12f, -2.0f, 1.35f}, {0.0f, -2.0f, 1.35f}, {2.0f, 0.0f, 0.9f}, {2.0f, -1.12f, 0.9f}, {1.12f, -2.0f, 0.9f}, {0.0f, -2.0f, 0.9f}, {-2.0f, 0.0f, 0.9f}, {2.0f, 0.0f, 0.45f}, {2.0f, -1.12f, 0.45f}, {1.12f, -2.0f, 0.45f}, {0.0f, -2.0f, 0.45f}, {1.5f, 0.0f, 0.225f}, {1.5f, -0.84f, 0.225f}, {0.84f, -1.5f, 0.225f}, {0.0f, -1.5f, 0.225f}, {1.5f, 0.0f, 0.15f}, {1.5f, -0.84f, 0.15f}, {0.84f, -1.5f, 0.15f}, {0.0f, -1.5f, 0.15f}, {-1.6f, 0.0f, 2.025f}, {-1.6f, -0.3f, 2.025f}, {-1.5f, -0.3f, 2.25f}, {-1.5f, 0.0f, 2.25f}, {-2.3f, 0.0f, 2.025f}, {-2.3f, -0.3f, 2.025f}, {-2.5f, -0.3f, 2.25f}, {-2.5f, 0.0f, 2.25f}, {-2.7f, 0.0f, 2.025f}, {-2.7f, -0.3f, 2.025f}, {-3.0f, -0.3f, 2.25f}, {-3.0f, 0.0f, 2.25f}, {-2.7f, 0.0f, 1.8f}, {-2.7f, -0.3f, 1.8f}, {-3.0f, -0.3f, 1.8f}, {-3.0f, 0.0f, 1.8f}, {-2.7f, 0.0f, 1.575f}, {-2.7f, -0.3f, 1.575f}, {-3.0f, -0.3f, 1.35f}, {-3.0f, 0.0f, 1.35f}, {-2.5f, 0.0f, 1.125f}, {-2.5f, -0.3f, 1.125f}, {-2.65f, -0.3f, 0.9375f}, {-2.65f, 0.0f, 0.9375f}, {-2.0f, -0.3f, 0.9f}, {-1.9f, -0.3f, 0.6f}, {-1.9f, 0.0f, 0.6f}, {1.7f, 0.0f, 1.425f}, {1.7f, -0.66f, 1.425f}, {1.7f, -0.66f, 0.6f}, {1.7f, 0.0f, 0.6f}, {2.6f, 0.0f, 1.425f}, {2.6f, -0.66f, 1.425f}, {3.1f, -0.66f, 0.825f}, {3.1f, 0.0f, 0.825f}, {2.3f, 0.0f, 2.1f}, {2.3f, -0.25f, 2.1f}, {2.4f, -0.25f, 2.025f}, {2.4f, 0.0f, 2.025f}, {2.7f, 0.0f, 2.4f}, {2.7f, -0.25f, 2.4f}, {3.3f, -0.25f, 2.4f}, {3.3f, 0.0f, 2.4f}, {2.8f, 0.0f, 2.475f}, {2.8f, -0.25f, 2.475f}, {3.525f, -0.25f, 2.49375f}, {3.525f, 0.0f, 2.49375f}, {2.9f, 0.0f, 2.475f}, {2.9f, -0.15f, 2.475f}, {3.45f, -0.15f, 2.5125f}, {3.45f, 0.0f, 2.5125f}, {2.8f, 0.0f, 2.4f}, {2.8f, -0.15f, 2.4f}, {3.2f, -0.15f, 2.4f}, {3.2f, 0.0f, 2.4f}, {0.0f, 0.0f, 3.15f}, {0.8f, 0.0f, 3.15f}, {0.8f, -0.45f, 3.15f}, {0.45f, -0.8f, 3.15f}, {0.0f, -0.8f, 3.15f}, {0.0f, 0.0f, 2.85f}, {1.4f, 0.0f, 2.4f}, {1.4f, -0.784f, 2.4f}, {0.784f, -1.4f, 2.4f}, {0.0f, -1.4f, 2.4f}, {0.4f, 0.0f, 2.55f}, {0.4f, -0.224f, 2.55f}, {0.224f, -0.4f, 2.55f}, {0.0f, -0.4f, 2.55f}, {1.3f, 0.0f, 2.55f}, {1.3f, -0.728f, 2.55f}, {0.728f, -1.3f, 2.55f}, {0.0f, -1.3f, 2.55f}, {1.3f, 0.0f, 2.4f}, {1.3f, -0.728f, 2.4f}, {0.728f, -1.3f, 2.4f}, {0.0f, -1.3f, 2.4f}, {0.0f, 0.0f, 0.0f}, {1.425f, -0.798f, 0.0f}, {1.5f, 0.0f, 0.075f}, {1.425f, 0.0f, 0.0f}, {0.798f, -1.425f, 0.0f}, {0.0f, -1.5f, 0.075f}, {0.0f, -1.425f, 0.0f}, {1.5f, -0.84f, 0.075f}, {0.84f, -1.5f, 0.075f}};
        teapotTex = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
        bitmapFonts = new BitmapFontRec[9];
        strokeFonts = new StrokeFontRec[9];
    }
}

