/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.windows;

import com.sun.opengl.impl.windows.WGL;
import com.sun.opengl.impl.windows.WGLExt;
import com.sun.opengl.impl.windows.WindowsGLDrawable;
import com.sun.opengl.impl.windows.WindowsGLDrawableFactory;
import com.sun.opengl.impl.windows.WindowsPbufferGLContext;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;

public class WindowsPbufferGLDrawable
extends WindowsGLDrawable {
    private int initWidth;
    private int initHeight;
    private WGLExt cachedWGLExt;
    private long buffer;
    private int width;
    private int height;
    private int floatMode;

    public WindowsPbufferGLDrawable(GLCapabilities gLCapabilities, int n2, int n3, WindowsGLDrawable windowsGLDrawable, WGLExt wGLExt) {
        super(gLCapabilities, null);
        this.initWidth = n2;
        this.initHeight = n3;
        if (this.initWidth <= 0 || this.initHeight <= 0) {
            throw new GLException(new StringBuffer("Initial width and height of pbuffer must be positive (were (").append(this.initWidth).append(", ").append(this.initHeight).append("))").toString());
        }
        if (DEBUG) {
            System.out.println(new StringBuffer("Pbuffer caps on init: ").append(gLCapabilities).append(gLCapabilities.getPbufferRenderToTexture() ? " [rtt]" : "").append(gLCapabilities.getPbufferRenderToTextureRectangle() ? " [rect]" : "").append(gLCapabilities.getPbufferFloatingPointBuffers() ? " [float]" : "").toString());
        }
        this.createPbuffer(windowsGLDrawable.getHDC(), wGLExt);
    }

    @Override
    public GLContext createContext(GLContext gLContext) {
        return new WindowsPbufferGLContext(this, gLContext);
    }

    @Override
    public void destroy() {
        if (this.hdc != 0L) {
            WGLExt wGLExt = this.cachedWGLExt;
            if (wGLExt.wglReleasePbufferDCARB(this.buffer, this.hdc) == 0) {
                throw new GLException(new StringBuffer("Error releasing pbuffer device context: error code ").append(WGL.GetLastError()).toString());
            }
            this.hdc = 0L;
            if (!wGLExt.wglDestroyPbufferARB(this.buffer)) {
                throw new GLException(new StringBuffer("Error destroying pbuffer: error code ").append(WGL.GetLastError()).toString());
            }
            this.buffer = 0L;
            this.setChosenGLCapabilities(null);
        }
    }

    @Override
    public void setSize(int n2, int n3) {
        throw new GLException("Not yet implemented");
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public GLCapabilities getCapabilities() {
        return this.capabilities;
    }

    public long getPbuffer() {
        return this.buffer;
    }

    public int getFloatingPointMode() {
        return this.floatMode;
    }

    @Override
    public void swapBuffers() {
    }

    private void createPbuffer(long l2, WGLExt wGLExt) {
        int n2;
        int[] nArray;
        int[] nArray2;
        int[] nArray3 = new int[512];
        Object[] objectArray = new float[1];
        int[] nArray4 = new int[1];
        if (DEBUG) {
            System.out.println(new StringBuffer("Pbuffer parentHdc = ").append(WindowsPbufferGLDrawable.toHexString(l2)).toString());
            System.out.println(new StringBuffer("Pbuffer caps: ").append(this.capabilities).append(this.capabilities.getPbufferRenderToTexture() ? " [rtt]" : "").append(this.capabilities.getPbufferRenderToTextureRectangle() ? " [rect]" : "").append(this.capabilities.getPbufferFloatingPointBuffers() ? " [float]" : "").toString());
        }
        if (!WindowsPbufferGLDrawable.glCapabilities2iattributes(this.capabilities, nArray3, wGLExt, true, nArray4)) {
            throw new GLException("Pbuffer-related extensions not supported");
        }
        this.floatMode = nArray4[0];
        boolean bl = this.capabilities.getPbufferRenderToTexture();
        boolean bl2 = this.capabilities.getPbufferRenderToTextureRectangle();
        boolean bl3 = this.capabilities.getPbufferFloatingPointBuffers();
        boolean bl4 = false;
        if (bl3) {
            boolean bl5 = bl4 = this.floatMode == 2;
        }
        if (!wGLExt.wglChoosePixelFormatARB(l2, nArray3, 0, (float[])objectArray, 0, 256, nArray2 = new int[256], 0, nArray = new int[1], 0)) {
            throw new GLException("pbuffer creation error: wglChoosePixelFormatARB() failed");
        }
        int n3 = nArray[0];
        if (n3 <= 0) {
            throw new GLException("pbuffer creation error: Couldn't find a suitable pixel format");
        }
        boolean bl6 = wGLExt.isExtensionAvailable("WGL_ARB_multisample");
        if (DEBUG) {
            System.err.println(new StringBuffer().append(n3).append(" suitable pixel formats found").toString());
            nArray3[0] = 8213;
            nArray3[1] = 8215;
            nArray3[2] = 8217;
            nArray3[3] = 8219;
            nArray3[4] = 8226;
            nArray3[5] = bl3 ? (bl4 ? 8211 : 8368) : 8213;
            nArray3[6] = bl6 ? 8257 : 8213;
            nArray3[7] = bl6 ? 8258 : 8213;
            nArray3[8] = 8237;
            int[] nArray5 = new int[9];
            for (int i2 = 0; i2 < n3; ++i2) {
                if (!wGLExt.wglGetPixelFormatAttribivARB(l2, nArray2[i2], 0, 9, nArray3, 0, nArray5, 0)) {
                    throw new GLException(new StringBuffer("Error while querying pixel format ").append(nArray2[i2]).append("'s (index ").append(i2).append("'s) capabilities for debugging").toString());
                }
                System.err.print(new StringBuffer("pixel format ").append(nArray2[i2]).append(" (index ").append(i2).append("): ").toString());
                System.err.print(new StringBuffer("r: ").append(nArray5[0]).toString());
                System.err.print(new StringBuffer(" g: ").append(nArray5[1]).toString());
                System.err.print(new StringBuffer(" b: ").append(nArray5[2]).toString());
                System.err.print(new StringBuffer(" a: ").append(nArray5[3]).toString());
                System.err.print(new StringBuffer(" depth: ").append(nArray5[4]).toString());
                if (bl6) {
                    System.err.print(new StringBuffer(" multisample: ").append(nArray5[6]).toString());
                }
                System.err.print(new StringBuffer(" samples: ").append(nArray5[7]).toString());
                if (bl3) {
                    if (bl4) {
                        if (nArray5[5] == 8608) {
                            System.err.print(" [ati float]");
                        } else if (nArray5[5] != 8235) {
                            System.err.print(new StringBuffer(" [unknown pixel type ").append(nArray5[5]).append("]").toString());
                        }
                    } else if (nArray5[5] != 0) {
                        System.err.print(" [float]");
                    }
                }
                if (nArray5[8] != 0) {
                    System.err.print(" [pbuffer]");
                }
                System.err.println();
            }
        }
        long l3 = 0L;
        for (n2 = 0; n2 < n3; ++n2) {
            int n4 = nArray2[n2];
            int n5 = 0;
            if (bl) {
                ++n5;
                nArray3[0] = 8306;
                if (bl3) {
                    ++n5;
                    nArray3[1] = 8375;
                } else {
                    ++n5;
                    nArray3[1] = 8310;
                }
                ++n5;
                nArray3[2] = 8307;
                ++n5;
                nArray3[3] = bl2 ? 8354 : 8314;
                ++n5;
                nArray3[4] = 8308;
                ++n5;
                nArray3[5] = 0;
                ++n5;
                nArray3[6] = 8243;
                ++n5;
                nArray3[7] = 0;
            }
            nArray3[n5] = 0;
            l3 = wGLExt.wglCreatePbufferARB(l2, n4, this.initWidth, this.initHeight, nArray3, 0);
            if (l3 != 0L) break;
        }
        if (l3 == 0L) {
            throw new GLException(new StringBuffer("pbuffer creation error: wglCreatePbufferARB() failed: tried ").append(n3).append(" pixel formats, last error was: ").append(WindowsPbufferGLDrawable.wglGetLastError()).toString());
        }
        long l4 = wGLExt.wglGetPbufferDCARB(l3);
        if (l4 == 0L) {
            throw new GLException("pbuffer creation error: wglGetPbufferDCARB() failed");
        }
        this.buffer = l3;
        this.hdc = l4;
        this.cachedWGLExt = wGLExt;
        nArray3[0] = 8195;
        nArray3[1] = 8213;
        nArray3[2] = 8215;
        nArray3[3] = 8217;
        nArray3[4] = 8219;
        nArray3[5] = 8226;
        nArray3[6] = 8227;
        nArray3[7] = 8209;
        nArray3[8] = 8210;
        nArray3[9] = 8222;
        nArray3[10] = 8223;
        nArray3[11] = 8224;
        nArray3[12] = 8225;
        nArray3[13] = bl3 ? (bl4 ? 8211 : 8368) : 8213;
        nArray3[14] = bl6 ? 8257 : 8213;
        nArray3[15] = bl6 ? 8258 : 8213;
        nArray3[16] = 8237;
        objectArray = new int[17];
        if (wGLExt.wglGetPixelFormatAttribivARB(l2, nArray2[n2], 0, 17, nArray3, 0, (int[])objectArray, 0)) {
            this.setChosenGLCapabilities(WindowsPbufferGLDrawable.iattributes2GLCapabilities(nArray3, 17, (int[])objectArray, false));
        }
        objectArray = new int[1];
        wGLExt.wglQueryPbufferARB(this.buffer, 8244, (int[])objectArray, 0);
        this.width = (int)objectArray[0];
        wGLExt.wglQueryPbufferARB(this.buffer, 8245, (int[])objectArray, 0);
        this.height = (int)objectArray[0];
        if (DEBUG) {
            System.err.println(new StringBuffer("Created pbuffer ").append(this.width).append(" x ").append(this.height).toString());
        }
    }

    private static String wglGetLastError() {
        return WindowsGLDrawableFactory.wglGetLastError();
    }
}

