/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.windows;

import com.sun.opengl.impl.Debug;
import com.sun.opengl.impl.JAWT;
import com.sun.opengl.impl.JAWT_DrawingSurface;
import com.sun.opengl.impl.JAWT_DrawingSurfaceInfo;
import com.sun.opengl.impl.windows.JAWT_Win32DrawingSurfaceInfo;
import com.sun.opengl.impl.windows.WGL;
import com.sun.opengl.impl.windows.WindowsGLDrawable;
import com.sun.opengl.impl.windows.WindowsOnscreenGLContext;
import java.awt.Component;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;

public class WindowsOnscreenGLDrawable
extends WindowsGLDrawable {
    public static final int LOCK_SURFACE_NOT_READY = 1;
    public static final int LOCK_SURFACE_CHANGED = 2;
    public static final int LOCK_SUCCESS = 3;
    protected Component component;
    private JAWT_DrawingSurface ds;
    private JAWT_DrawingSurfaceInfo dsi;
    private JAWT_Win32DrawingSurfaceInfo win32dsi;
    protected boolean realized;
    private static final boolean PROFILING = Debug.debug("WindowsOnscreenGLDrawable.profiling");
    private static final int PROFILING_TICKS = 200;
    private int profilingLockSurfaceTicks;
    private long profilingLockSurfaceTime;
    private int profilingUnlockSurfaceTicks;
    private long profilingUnlockSurfaceTime;
    private int profilingSwapBuffersTicks;
    private long profilingSwapBuffersTime;
    private int setPixelFormatFailCount;
    private static final int MAX_SET_PIXEL_FORMAT_FAIL_COUNT = 5;

    public WindowsOnscreenGLDrawable(Component component, GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser) {
        super(gLCapabilities, gLCapabilitiesChooser);
        this.component = component;
    }

    @Override
    public GLContext createContext(GLContext gLContext) {
        return new WindowsOnscreenGLContext(this, gLContext);
    }

    @Override
    public void setRealized(boolean bl) {
        this.realized = bl;
        if (!bl) {
            this.setChosenGLCapabilities(null);
            this.pixelFormatChosen = false;
        }
    }

    @Override
    public void setSize(int n2, int n3) {
        this.component.setSize(n2, n3);
    }

    @Override
    public int getWidth() {
        return this.component.getWidth();
    }

    @Override
    public int getHeight() {
        return this.component.getHeight();
    }

    @Override
    public void swapBuffers() {
        boolean bl = false;
        if (this.hdc == 0L) {
            if (this.lockSurface() == 1) {
                return;
            }
            bl = true;
        }
        long l2 = 0L;
        if (PROFILING) {
            l2 = System.currentTimeMillis();
        }
        if (!WGL.SwapBuffers(this.hdc) && WGL.GetLastError() != 0) {
            throw new GLException("Error swapping buffers");
        }
        if (PROFILING) {
            long l3 = System.currentTimeMillis();
            this.profilingSwapBuffersTime += l3 - l2;
            if (++this.profilingSwapBuffersTicks == 200) {
                System.err.println(new StringBuffer("SwapBuffers calls: ").append(this.profilingSwapBuffersTime).append(" ms / 200  calls (").append((float)this.profilingSwapBuffersTime / 200.0f).append(" ms/call)").toString());
                this.profilingSwapBuffersTime = 0L;
                this.profilingSwapBuffersTicks = 0;
            }
        }
        if (bl) {
            this.unlockSurface();
        }
    }

    public int lockSurface() {
        if (!this.realized) {
            return 1;
        }
        if (this.hdc != 0L) {
            throw new GLException("Surface already locked");
        }
        long l2 = 0L;
        if (PROFILING) {
            l2 = System.currentTimeMillis();
        }
        this.ds = JAWT.getJAWT().GetDrawingSurface(this.component);
        if (this.ds == null) {
            return 1;
        }
        int n2 = this.ds.Lock();
        if ((n2 & 1) != 0) {
            throw new GLException("Unable to lock surface");
        }
        int n3 = 3;
        if ((n2 & 8) != 0) {
            n3 = 2;
        }
        this.dsi = this.ds.GetDrawingSurfaceInfo();
        if (this.dsi == null) {
            this.ds.Unlock();
            JAWT.getJAWT().FreeDrawingSurface(this.ds);
            this.ds = null;
            return 1;
        }
        this.win32dsi = (JAWT_Win32DrawingSurfaceInfo)this.dsi.platformInfo();
        this.hdc = this.win32dsi.hdc();
        if (this.hdc == 0L) {
            this.ds.FreeDrawingSurfaceInfo(this.dsi);
            this.ds.Unlock();
            JAWT.getJAWT().FreeDrawingSurface(this.ds);
            this.ds = null;
            this.dsi = null;
            this.win32dsi = null;
            return 1;
        }
        if (!this.pixelFormatChosen) {
            try {
                this.choosePixelFormat(true);
                this.setPixelFormatFailCount = 0;
            }
            catch (RuntimeException runtimeException) {
                this.unlockSurface();
                if (runtimeException instanceof GLException) {
                    if (++this.setPixelFormatFailCount == 5) {
                        this.setPixelFormatFailCount = 0;
                        throw runtimeException;
                    }
                    return 1;
                }
                throw new GLException(runtimeException);
            }
        }
        if (PROFILING) {
            long l3 = System.currentTimeMillis();
            this.profilingLockSurfaceTime += l3 - l2;
            if (++this.profilingLockSurfaceTicks == 200) {
                System.err.println(new StringBuffer("LockSurface calls: ").append(this.profilingLockSurfaceTime).append(" ms / 200 calls (").append((float)this.profilingLockSurfaceTime / 200.0f).append(" ms/call)").toString());
                this.profilingLockSurfaceTime = 0L;
                this.profilingLockSurfaceTicks = 0;
            }
        }
        return n3;
    }

    public void unlockSurface() {
        if (this.hdc == 0L) {
            throw new GLException("Surface already unlocked");
        }
        long l2 = 0L;
        if (PROFILING) {
            l2 = System.currentTimeMillis();
        }
        this.ds.FreeDrawingSurfaceInfo(this.dsi);
        this.ds.Unlock();
        JAWT.getJAWT().FreeDrawingSurface(this.ds);
        this.ds = null;
        this.dsi = null;
        this.win32dsi = null;
        this.hdc = 0L;
        if (PROFILING) {
            long l3 = System.currentTimeMillis();
            this.profilingUnlockSurfaceTime += l3 - l2;
            if (++this.profilingUnlockSurfaceTicks == 200) {
                System.err.println(new StringBuffer("UnlockSurface calls: ").append(this.profilingUnlockSurfaceTime).append(" ms / 200 calls (").append((float)this.profilingUnlockSurfaceTime / 200.0f).append(" ms/call)").toString());
                this.profilingUnlockSurfaceTime = 0L;
                this.profilingUnlockSurfaceTicks = 0;
            }
        }
    }
}

