/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.packrect;

import com.sun.opengl.impl.packrect.BackingStoreManager;
import com.sun.opengl.impl.packrect.Level;
import com.sun.opengl.impl.packrect.Rect;
import com.sun.opengl.impl.packrect.RectVisitor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LevelSet {
    private List levels = new ArrayList();
    private int nextAddY;
    private int w;
    private int h;

    public LevelSet(int n2, int n3) {
        this.w = n2;
        this.h = n3;
    }

    public int w() {
        return this.w;
    }

    public int h() {
        return this.h;
    }

    public boolean add(Rect rect) {
        int n2;
        if (rect.w() > this.w) {
            return false;
        }
        for (n2 = this.levels.size() - 1; n2 >= 0; --n2) {
            if (!((Level)this.levels.get(n2)).add(rect)) continue;
            return true;
        }
        for (n2 = this.levels.size() - 1; n2 >= 0; --n2) {
            if (!((Level)this.levels.get(n2)).couldAllocateIfCompacted(rect)) continue;
            return false;
        }
        if (this.nextAddY + rect.h() > this.h) {
            return false;
        }
        Level level = new Level(this.w, rect.h(), this.nextAddY, this);
        this.levels.add(level);
        this.nextAddY += rect.h();
        if (!level.add(rect)) {
            throw new RuntimeException("Unexpected failure in addition to new Level");
        }
        return true;
    }

    public boolean remove(Rect rect) {
        for (int i2 = this.levels.size() - 1; i2 >= 0; --i2) {
            if (!((Level)this.levels.get(i2)).remove(rect)) continue;
            return true;
        }
        return false;
    }

    public boolean compactAndAdd(Rect rect, Object object, BackingStoreManager backingStoreManager) {
        for (int i2 = this.levels.size() - 1; i2 >= 0; --i2) {
            Level level = (Level)this.levels.get(i2);
            if (!level.couldAllocateIfCompacted(rect)) continue;
            level.compact(object, backingStoreManager);
            if (!level.add(rect)) {
                throw new RuntimeException("Unexpected failure to add after compaction");
            }
            return true;
        }
        return false;
    }

    public boolean canExpand(Level level, int n2) {
        if (this.levels.isEmpty()) {
            return false;
        }
        return this.levels.get(this.levels.size() - 1) == level && this.h - this.nextAddY >= n2 - level.h();
    }

    public void expand(Level level, int n2, int n3) {
        this.nextAddY += n3 - n2;
    }

    public int getUsedHeight() {
        return this.nextAddY;
    }

    public void setHeight(int n2) {
        if (n2 < this.getUsedHeight()) {
            throw new IllegalArgumentException("May not reduce height below currently used height");
        }
        this.h = n2;
    }

    public float verticalFragmentationRatio() {
        int n2 = 0;
        int n3 = this.getUsedHeight();
        if (n3 == 0) {
            return 0.0f;
        }
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Level level = (Level)iterator.next();
            if (!level.isEmpty()) continue;
            n2 += level.h();
        }
        return (float)n2 / (float)n3;
    }

    public Iterator iterator() {
        return this.levels.iterator();
    }

    public void visit(RectVisitor rectVisitor) {
        Iterator iterator = this.levels.iterator();
        while (iterator.hasNext()) {
            ((Level)iterator.next()).visit(rectVisitor);
        }
    }

    public void updateRectangleReferences() {
        Iterator iterator = this.levels.iterator();
        while (iterator.hasNext()) {
            ((Level)iterator.next()).updateRectangleReferences();
        }
    }

    public void clear() {
        this.levels.clear();
        this.nextAddY = 0;
    }
}

