/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.nurbs;

import com.sun.opengl.impl.nurbs.Arc;
import com.sun.opengl.impl.nurbs.ArcSdirSorter;
import com.sun.opengl.impl.nurbs.ArcTdirSorter;
import com.sun.opengl.impl.nurbs.ArcTesselator;
import com.sun.opengl.impl.nurbs.Backend;
import com.sun.opengl.impl.nurbs.Bin;
import com.sun.opengl.impl.nurbs.CArrayOfArcs;
import com.sun.opengl.impl.nurbs.Curvelist;
import com.sun.opengl.impl.nurbs.Flist;
import com.sun.opengl.impl.nurbs.Patchlist;
import com.sun.opengl.impl.nurbs.Quilt;
import com.sun.opengl.impl.nurbs.Renderhints;

class Subdivider {
    public static final int CULL_TRIVIAL_REJECT = 0;
    public static final int CULL_ACCEPT = 1;
    private static final int MAXARCS = 10;
    Quilt qlist;
    private Renderhints renderhints;
    private Backend backend;
    private int subdivisions;
    private float domain_distance_u_rate;
    private int is_domain_distance_sampling;
    private Bin initialbin;
    private boolean showDegenerate;
    private boolean isArcTypeBezier;
    private Flist tpbrkpts;
    private Flist spbrkpts;
    private int s_index;
    private Arc pjarc;
    private ArcTesselator arctesselator;
    private int t_index;
    private Flist smbrkpts;
    private float[] stepsizes;
    private float domain_distance_v_rate;

    Subdivider() {
    }

    public void beginQuilts() {
        this.qlist = null;
        this.renderhints = new Renderhints();
        this.backend = new Backend();
        this.initialbin = new Bin();
        this.arctesselator = new ArcTesselator();
    }

    public void addQuilt(Quilt quilt) {
        if (this.qlist == null) {
            this.qlist = quilt;
            return;
        }
        quilt.next = this.qlist;
        this.qlist = quilt;
    }

    public void endQuilts() {
    }

    public void drawSurfaces() {
        this.renderhints.init();
        if (this.qlist == null) {
            return;
        }
        Object object = this.qlist;
        while (object != null) {
            if (((Quilt)object).isCulled() == 0) {
                this.freejarcs(this.initialbin);
                return;
            }
            object = ((Quilt)object).next;
        }
        object = new float[2];
        float[] fArray = new float[2];
        this.spbrkpts = new Flist();
        this.tpbrkpts = new Flist();
        this.qlist.getRange((float[])object, fArray, this.spbrkpts, this.tpbrkpts);
        if (this.initialbin.isnonempty()) {
            object = new float[2];
            this.qlist.findRates(this.spbrkpts, this.tpbrkpts, (float[])object);
        }
        this.backend.bgnsurf(this.renderhints.wiretris, this.renderhints.wirequads);
        if (!this.initialbin.isnonempty()) {
            for (int i2 = this.spbrkpts.start; i2 < this.spbrkpts.end - 1; ++i2) {
                for (int i3 = this.tpbrkpts.start; i3 < this.tpbrkpts.end - 1; ++i3) {
                    float[] fArray2 = new float[2];
                    float[] fArray3 = new float[2];
                    fArray2[0] = this.spbrkpts.pts[i2];
                    fArray3[0] = this.spbrkpts.pts[i2 + 1];
                    fArray2[1] = this.tpbrkpts.pts[i3];
                    fArray3[1] = this.tpbrkpts.pts[i3 + 1];
                    this.qlist.downloadAll(fArray2, fArray3, this.backend);
                    int n2 = (int)(this.domain_distance_u_rate * (fArray3[0] - fArray2[0]));
                    int n3 = (int)(this.domain_distance_v_rate * (fArray3[1] - fArray2[1]));
                    if (n2 <= 0) {
                        n2 = 1;
                    }
                    if (n3 <= 0) {
                        n3 = 1;
                    }
                    this.backend.surfgrid(fArray2[0], fArray3[0], n2, fArray3[1], fArray2[1], n3);
                    this.backend.surfmesh(0, 0, n2, n3);
                }
            }
        } else {
            this.subdivideInS(this.initialbin);
        }
        this.backend.endsurf();
    }

    private void freejarcs(Bin bin) {
    }

    private void subdivideInS(Bin bin) {
        if (this.renderhints.display_method == 6) {
            this.outline(bin);
            this.freejarcs(bin);
            return;
        }
        this.setArcTypeBezier();
        this.setNonDegenerate();
        this.splitInS(bin, this.spbrkpts.start, this.spbrkpts.end);
    }

    private void splitInS(Bin bin, int n2, int n3) {
        while (bin.isnonempty()) {
            if (n2 != n3) {
                int n4 = n2 + (n3 - n2) / 2;
                Bin bin2 = new Bin();
                Bin bin3 = new Bin();
                this.split(bin, bin2, bin3, 0, this.spbrkpts.pts[n4]);
                this.splitInS(bin2, n2, n4);
                n2 = n4 + 1;
                bin = bin3;
                continue;
            }
            if (n2 == this.spbrkpts.start || n2 == this.spbrkpts.end) {
                this.freejarcs(bin);
                return;
            }
            if (this.renderhints.display_method == 7) {
                this.outline(bin);
                this.freejarcs(bin);
                return;
            }
            this.setArcTypeBezier();
            this.setNonDegenerate();
            this.s_index = n2;
            this.splitInT(bin, this.tpbrkpts.start, this.tpbrkpts.end);
            break;
        }
    }

    private void splitInT(Bin bin, int n2, int n3) {
        while (bin.isnonempty()) {
            Object object;
            Object object2;
            if (n2 != n3) {
                int n4 = n2 + (n3 - n2) / 2;
                object2 = new Bin();
                object = new Bin();
                this.split(bin, (Bin)object2, (Bin)object, 1, this.tpbrkpts.pts[n4 + 1]);
                this.splitInT((Bin)object2, n2, n4);
                n2 = n4 + 1;
                bin = object;
                continue;
            }
            if (n2 == this.tpbrkpts.start || n2 == this.tpbrkpts.end) {
                this.freejarcs(bin);
                return;
            }
            if (this.renderhints.display_method == 8) {
                this.outline(bin);
                this.freejarcs(bin);
                return;
            }
            this.t_index = n2;
            this.setArcTypeBezier();
            this.setDegenerate();
            float[] fArray = new float[2];
            object2 = new float[2];
            fArray[0] = this.spbrkpts.pts[this.s_index - 1];
            fArray[1] = this.tpbrkpts.pts[this.t_index - 1];
            object2[0] = this.spbrkpts.pts[this.s_index];
            object2[1] = this.tpbrkpts.pts[this.t_index];
            this.qlist.downloadAll(fArray, (float[])object2, this.backend);
            object = new Patchlist(this.qlist, fArray, (float[])object2);
            this.samplingSplit(bin, (Patchlist)object, this.renderhints.maxsubdivisions, 0);
            this.setNonDegenerate();
            this.setArcTypeBezier();
            break;
        }
    }

    private void samplingSplit(Bin object, Patchlist object2, int n2, int n3) {
        while (true) {
            if (!((Bin)object).isnonempty()) {
                return;
            }
            if (((Patchlist)object2).cullCheck() == 0) {
                this.freejarcs((Bin)object);
                return;
            }
            ((Patchlist)object2).getstepsize();
            if (this.renderhints.display_method == 5) {
                this.tesselation((Bin)object, (Patchlist)object2);
                this.outline((Bin)object);
                this.freejarcs((Bin)object);
                return;
            }
            this.tesselation((Bin)object, (Patchlist)object2);
            if (!((Patchlist)object2).needsSamplingSubdivision() || n2 <= 0) break;
            n3 = !((Patchlist)object2).needsSubdivision(0) ? 1 : (((Patchlist)object2).needsSubdivision(1) ? 0 : 1 - n3);
            Bin bin = new Bin();
            Bin bin2 = new Bin();
            float f2 = (float)((double)(((Patchlist)object2).pspec[n3].range[0] + ((Patchlist)object2).pspec[n3].range[1]) * 0.5);
            this.split((Bin)object, bin, bin2, n3, f2);
            object = new Patchlist((Patchlist)object2, n3, f2);
            this.samplingSplit(bin, (Patchlist)object, n2 - 1, n3);
            --n2;
            object2 = object;
            object = bin2;
        }
        this.setArcTypePwl();
        this.setDegenerate();
        this.nonSamplingSplit((Bin)object, (Patchlist)object2, n2, n3);
        this.setDegenerate();
        this.setArcTypeBezier();
    }

    private void nonSamplingSplit(Bin object, Patchlist object2, int n2, int n3) {
        block7: {
            while (((Patchlist)object2).needsNonSamplingSubdivision() && n2 > 0) {
                n3 = 1 - n3;
                Bin bin = new Bin();
                Bin bin2 = new Bin();
                float f2 = (float)((double)(((Patchlist)object2).pspec[n3].range[0] + ((Patchlist)object2).pspec[n3].range[1]) * 0.5);
                this.split((Bin)object, bin, bin2, n3, f2);
                object = new Patchlist((Patchlist)object2, n3, f2);
                if (bin.isnonempty()) {
                    if (((Patchlist)object).cullCheck() == 0) {
                        this.freejarcs(bin);
                    } else {
                        this.nonSamplingSplit(bin, (Patchlist)object, n2 - 1, n3);
                    }
                }
                if (bin2.isnonempty()) {
                    if (((Patchlist)object2).cullCheck() == 0) {
                        this.freejarcs(bin2);
                        return;
                    }
                    --n2;
                    object2 = object;
                    object = bin2;
                    continue;
                }
                break block7;
            }
            ((Patchlist)object2).bbox();
            this.backend.patch(((Patchlist)object2).pspec[0].range[0], ((Patchlist)object2).pspec[0].range[1], ((Patchlist)object2).pspec[1].range[0], ((Patchlist)object2).pspec[1].range[1]);
            if (this.renderhints.display_method == 9) {
                this.outline((Bin)object);
                this.freejarcs((Bin)object);
                return;
            }
            this.setArcTypePwl();
            this.setDegenerate();
            this.findIrregularS((Bin)object);
            this.monosplitInS((Bin)object, this.smbrkpts.start, this.smbrkpts.end);
        }
    }

    private void monosplitInS(Bin bin, int n2, int n3) {
    }

    private void findIrregularS(Bin bin) {
    }

    private void setArcTypePwl() {
    }

    private void tesselation(Bin bin, Patchlist patchlist) {
    }

    private void setDegenerate() {
    }

    private void split(Bin bin, Bin bin2, Bin bin3, int n2, float f2) {
        Bin bin4 = new Bin();
        Bin bin5 = new Bin();
        this.partition(bin, bin2, bin4, bin3, bin5, n2, f2);
        int n3 = bin4.numarcs();
        if (n3 % 2 == 0) {
            Arc arc;
            Object object = new Arc[10];
            object = n3 >= 10 ? new CArrayOfArcs(new Arc[n3]) : new CArrayOfArcs((Arc[])object);
            CArrayOfArcs cArrayOfArcs = new CArrayOfArcs((CArrayOfArcs)object);
            while ((arc = bin4.removearc()) != null) {
                cArrayOfArcs.set(arc);
                cArrayOfArcs.pp();
            }
            if (n2 == 0) {
                new ArcSdirSorter(this).qsort((CArrayOfArcs)object, n3);
                CArrayOfArcs cArrayOfArcs2 = new CArrayOfArcs((CArrayOfArcs)object);
                while (cArrayOfArcs2.getPointer() < cArrayOfArcs.getPointer()) {
                    this.check_s(cArrayOfArcs2.get(), cArrayOfArcs2.getRelative(1));
                    cArrayOfArcs2.raisePointerBy(2);
                }
                cArrayOfArcs2 = new CArrayOfArcs((CArrayOfArcs)object);
                while (cArrayOfArcs2.getPointer() < cArrayOfArcs.getPointer()) {
                    this.join_s(bin2, bin3, cArrayOfArcs2.get(), cArrayOfArcs2.getRelative(1));
                    cArrayOfArcs2.raisePointerBy(2);
                }
                cArrayOfArcs2 = new CArrayOfArcs((CArrayOfArcs)object);
                while (cArrayOfArcs2.getPointer() != cArrayOfArcs.getPointer()) {
                    if (cArrayOfArcs2.get().head()[0] <= f2 && cArrayOfArcs2.get().tail()[0] <= f2) {
                        bin2.addarc(cArrayOfArcs2.get());
                    } else {
                        bin3.addarc(cArrayOfArcs2.get());
                    }
                    cArrayOfArcs2.pp();
                }
            } else {
                new ArcTdirSorter(this).qsort((CArrayOfArcs)object, n3);
                CArrayOfArcs cArrayOfArcs3 = new CArrayOfArcs((CArrayOfArcs)object);
                while (cArrayOfArcs3.getPointer() < cArrayOfArcs.getPointer()) {
                    this.check_t(cArrayOfArcs3.get(), cArrayOfArcs3.getRelative(1));
                    cArrayOfArcs3.raisePointerBy(2);
                }
                cArrayOfArcs3 = new CArrayOfArcs((CArrayOfArcs)object);
                while (cArrayOfArcs3.getPointer() < cArrayOfArcs.getPointer()) {
                    this.join_t(bin2, bin3, cArrayOfArcs3.get(), cArrayOfArcs3.getRelative(1));
                    cArrayOfArcs3.raisePointerBy(2);
                }
                cArrayOfArcs3 = new CArrayOfArcs((CArrayOfArcs)object);
                while (cArrayOfArcs3.getPointer() != cArrayOfArcs.getPointer()) {
                    if (cArrayOfArcs3.get().head()[0] <= f2 && cArrayOfArcs3.get().tail()[0] <= f2) {
                        bin2.addarc(cArrayOfArcs3.get());
                    } else {
                        bin3.addarc(cArrayOfArcs3.get());
                    }
                    cArrayOfArcs3.raisePointerBy(2);
                }
            }
            bin5.adopt();
        }
    }

    private void join_t(Bin bin, Bin bin2, Arc arc, Arc arc2) {
    }

    private void check_t(Arc arc, Arc arc2) {
    }

    private void join_s(Bin bin, Bin bin2, Arc arc, Arc arc2) {
        float f2;
        if (!arc.getitail()) {
            arc = arc.next;
        }
        if (!arc2.getitail()) {
            arc2 = arc2.next;
        }
        float f3 = arc.tail()[0];
        float f4 = arc.tail()[1];
        if (f4 == (f2 = arc2.tail()[1])) {
            this.simplelink(arc, arc2);
            return;
        }
        Arc arc3 = new Arc(1);
        Arc arc4 = new Arc(3);
        if (this.isBezierArcType()) {
            this.arctesselator.bezier(arc3, f3, f3, f4, f2);
            this.arctesselator.bezier(arc4, f3, f3, f2, f4);
        } else {
            this.arctesselator.pwl_right(arc3, f3, f4, f2, this.stepsizes[0]);
            this.arctesselator.pwl_left(arc3, f3, f2, f4, this.stepsizes[2]);
        }
        this.link(arc, arc2, arc3, arc4);
        bin.addarc(arc3);
        bin2.addarc(arc4);
    }

    private void link(Arc arc, Arc arc2, Arc arc3, Arc arc4) {
    }

    private boolean isBezierArcType() {
        return true;
    }

    private void simplelink(Arc arc, Arc arc2) {
    }

    private void check_s(Arc arc, Arc arc2) {
    }

    private void partition(Bin bin, Bin bin2, Bin bin3, Bin bin4, Bin bin5, int n2, float f2) {
        Bin bin6 = new Bin();
        Bin bin7 = new Bin();
        Bin bin8 = new Bin();
        Bin bin9 = new Bin();
        Arc arc = bin.removearc();
        while (arc != null) {
            float f3 = arc.tail()[n2] - f2;
            float f4 = arc.head()[n2] - f2;
            if (f3 > 0.0f) {
                if (f4 > 0.0f) {
                    bin4.addarc(arc);
                } else if (f4 == 0.0f) {
                    bin9.addarc(arc);
                } else {
                    switch (this.arc_split(arc, n2, f2, 0)) {
                        case 2: {
                            bin9.addarc(arc);
                            bin6.addarc(arc.next);
                            break;
                        }
                        default: {
                            System.out.println("TODO subdivider.partition rest cases");
                            break;
                        }
                    }
                }
            } else if (f3 == 0.0f) {
                if (f4 > 0.0f) {
                    bin7.addarc(arc);
                } else if (f4 == 0.0f) {
                    bin5.addarc(arc);
                } else {
                    bin7.addarc(arc);
                }
            } else if (!(f4 > 0.0f)) {
                if (f4 == 0.0f) {
                    bin8.addarc(arc);
                } else {
                    bin2.addarc(arc);
                }
            }
            arc = bin.removearc();
        }
        if (n2 == 0) {
            this.classify_headonleft_s(bin6, bin3, bin2, f2);
            this.classify_tailonleft_s(bin8, bin3, bin2, f2);
            this.classify_headonright_s(bin7, bin3, bin4, f2);
            this.classify_tailonright_s(bin9, bin3, bin4, f2);
            return;
        }
        this.classify_headonleft_t(bin6, bin3, bin2, f2);
        this.classify_tailonleft_t(bin8, bin3, bin2, f2);
        this.classify_headonright_t(bin7, bin3, bin4, f2);
        this.classify_tailonright_t(bin9, bin3, bin4, f2);
    }

    private void classify_tailonright_t(Bin bin, Bin bin2, Bin bin3, float f2) {
    }

    private void classify_tailonleft_s(Bin bin, Bin bin2, Bin bin3, float f2) {
        Arc arc;
        while ((arc = bin.removearc()) != null) {
            float f3;
            arc.clearitail();
            float f4 = arc.next.head()[0] - f2;
            if (f3 > 0.0f) {
                bin2.addarc(arc);
                continue;
            }
            if (f4 < 0.0f) {
                if (this.ccwTurn_sl(arc, arc.next)) {
                    bin3.addarc(arc);
                    continue;
                }
                bin2.addarc(arc);
                continue;
            }
            if (arc.next.tail()[1] > arc.next.head()[1]) {
                bin2.addarc(arc);
                continue;
            }
            bin3.addarc(arc);
        }
    }

    private void classify_headonright_s(Bin bin, Bin bin2, Bin bin3, float f2) {
        Arc arc;
        while ((arc = bin.removearc()) != null) {
            float f3;
            arc.setitail();
            float f4 = arc.prev.tail()[0] - f2;
            if (f3 > 0.0f) {
                if (this.ccwTurn_sr(arc.prev, arc)) {
                    bin3.addarc(arc);
                    continue;
                }
                bin2.addarc(arc);
                continue;
            }
            if (f4 < 0.0f) {
                bin3.addarc(arc);
                continue;
            }
            if (arc.prev.tail()[1] > arc.prev.head()[1]) {
                bin3.addarc(arc);
                continue;
            }
            bin2.addarc(arc);
        }
    }

    private boolean ccwTurn_sr(Arc arc, Arc arc2) {
        return false;
    }

    private void classify_headonright_t(Bin bin, Bin bin2, Bin bin3, float f2) {
    }

    private void classify_tailonleft_t(Bin bin, Bin bin2, Bin bin3, float f2) {
    }

    private void classify_headonleft_t(Bin bin, Bin bin2, Bin bin3, float f2) {
        Arc arc;
        while ((arc = bin.removearc()) != null) {
            float f3;
            arc.setitail();
            float f4 = arc.prev.tail()[1] - f2;
            if (f3 > 0.0f) {
                bin3.addarc(arc);
                continue;
            }
            if (f4 < 0.0f) {
                if (this.ccwTurn_tl(arc.prev, arc)) {
                    bin3.addarc(arc);
                    continue;
                }
                bin2.addarc(arc);
                continue;
            }
            if (arc.prev.tail()[0] > arc.prev.head()[0]) {
                bin3.addarc(arc);
                continue;
            }
            bin2.addarc(arc);
        }
    }

    private boolean ccwTurn_tl(Arc arc, Arc arc2) {
        return false;
    }

    private void classify_tailonright_s(Bin bin, Bin bin2, Bin bin3, float f2) {
        Arc arc;
        while ((arc = bin.removearc()) != null) {
            float f3;
            arc.clearitail();
            float f4 = arc.next.head()[0] - f2;
            if (f3 > 0.0f) {
                if (this.ccwTurn_sr(arc, arc.next)) {
                    bin3.addarc(arc);
                    continue;
                }
                bin2.addarc(arc);
                continue;
            }
            if (f4 < 0.0f) {
                bin2.addarc(arc);
                continue;
            }
            if (arc.next.tail()[1] > arc.next.head()[1]) {
                bin3.addarc(arc);
                continue;
            }
            bin2.addarc(arc);
        }
    }

    private void classify_headonleft_s(Bin bin, Bin bin2, Bin bin3, float f2) {
        Arc arc;
        while ((arc = bin.removearc()) != null) {
            float f3;
            arc.setitail();
            float f4 = arc.prev.tail()[0] - f2;
            if (f3 > 0.0f) {
                bin3.addarc(arc);
                continue;
            }
            if (f4 < 0.0f) {
                if (this.ccwTurn_sl(arc.prev, arc)) {
                    bin3.addarc(arc);
                    continue;
                }
                bin2.addarc(arc);
                continue;
            }
            if (arc.prev.tail()[1] > arc.prev.head()[1]) {
                bin2.addarc(arc);
                continue;
            }
            bin3.addarc(arc);
        }
    }

    private boolean ccwTurn_sl(Arc arc, Arc arc2) {
        return false;
    }

    private int arc_split(Arc arc, int n2, float f2, int n3) {
        return 0;
    }

    private void setNonDegenerate() {
        this.showDegenerate = false;
    }

    private void setArcTypeBezier() {
        this.isArcTypeBezier = true;
    }

    private void outline(Bin bin) {
    }

    private void makeBorderTrim(float[] fArray, float[] fArray2) {
        float f2 = fArray[0];
        float f3 = fArray2[0];
        float f4 = fArray[1];
        float f5 = fArray2[1];
        this.pjarc = null;
        Arc arc = new Arc(4);
        this.arctesselator.bezier(arc, f2, f3, f4, f4);
        this.initialbin.addarc(arc);
        this.pjarc = arc.append(this.pjarc);
        arc = new Arc(1);
        this.arctesselator.bezier(arc, f3, f3, f4, f5);
        this.initialbin.addarc(arc);
        this.pjarc = arc.append(this.pjarc);
        arc = new Arc(2);
        this.arctesselator.bezier(arc, f3, f2, f5, f5);
        this.initialbin.addarc(arc);
        this.pjarc = arc.append(this.pjarc);
        arc = new Arc(3);
        this.arctesselator.bezier(arc, f2, f2, f5, f4);
        this.initialbin.addarc(arc);
        arc.append(this.pjarc);
    }

    public void drawCurves() {
        float[] fArray = new float[1];
        Object object = new float[1];
        Flist flist = new Flist();
        this.qlist.getRange(fArray, (float[])object, flist);
        this.renderhints.init();
        this.backend.bgncurv();
        for (int i2 = flist.start; i2 < flist.end - 1; ++i2) {
            object = new float[1];
            float[] fArray2 = new float[1];
            object[0] = flist.pts[i2];
            fArray2[0] = flist.pts[i2 + 1];
            this.qlist.downloadAll((float[])object, fArray2, this.backend);
            object = new Curvelist(this.qlist, (float[])object, fArray2);
            this.samplingSplit((Curvelist)object, this.renderhints.maxsubdivisions);
        }
        this.backend.endcurv();
    }

    private void samplingSplit(Curvelist curvelist, int n2) {
        if (curvelist.cullCheck() == 0) {
            return;
        }
        curvelist.getstepsize();
        if (!curvelist.needsSamplingSubdivision() || this.subdivisions <= 0) {
            n2 = (int)(1.0f + curvelist.range[2] / curvelist.stepsize);
            this.backend.curvgrid(curvelist.range[0], curvelist.range[1], n2);
            this.backend.curvmesh(0, n2);
        }
    }

    public void set_domain_distance_u_rate(double d2) {
        this.domain_distance_u_rate = (float)d2;
    }

    public void set_domain_distance_v_rate(double d2) {
        this.domain_distance_v_rate = (float)d2;
    }

    public void set_is_domain_distance_sampling(int n2) {
        this.is_domain_distance_sampling = n2;
    }
}

