/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.nurbs;

import com.sun.opengl.impl.nurbs.Breakpt;
import com.sun.opengl.impl.nurbs.CArrayOfBreakpts;
import com.sun.opengl.impl.nurbs.CArrayOfFloats;
import com.sun.opengl.impl.nurbs.Knotvector;

class Knotspec {
    public CArrayOfFloats inkbegin;
    public CArrayOfFloats inkend;
    public int prestride;
    public int order;
    public Knotspec next;
    public CArrayOfFloats klast;
    CArrayOfFloats kfirst;
    CArrayOfBreakpts bbegin;
    CArrayOfBreakpts bend;
    CArrayOfFloats kleft;
    CArrayOfFloats kright;
    int preoffset;
    int postwidth;
    private CArrayOfFloats sbegin;
    private CArrayOfFloats outkbegin;
    private CArrayOfFloats outkend;
    int prewidth;
    int postoffset;
    public int poststride;
    public int ncoords;
    public boolean istransformed;
    public Knotspec kspectotrans;

    Knotspec() {
    }

    public void preselect() {
        this.klast = new CArrayOfFloats(this.inkend);
        this.klast.lessenPointerBy(this.order);
        float f2 = this.klast.get();
        while (this.klast.getPointer() != this.inkend.getPointer() && Knotvector.identical(this.klast.get(), f2)) {
            this.klast.pp();
        }
        this.kfirst = new CArrayOfFloats(this.inkbegin);
        this.kfirst.raisePointerBy(this.order - 1);
        f2 = this.kfirst.get();
        while (this.kfirst.getPointer() != this.inkend.getPointer() && Knotvector.identical(this.kfirst.get(), f2)) {
            this.kfirst.pp();
        }
        CArrayOfFloats cArrayOfFloats = new CArrayOfFloats(this.kfirst);
        cArrayOfFloats.mm();
        while (cArrayOfFloats.getPointer() >= this.inkbegin.getPointer() && Knotvector.identical(f2, cArrayOfFloats.get())) {
            cArrayOfFloats.mm();
        }
        cArrayOfFloats.pp();
        Breakpt[] breakptArray = new Breakpt[this.klast.getPointer() - this.kfirst.getPointer() + 1];
        for (int i2 = 0; i2 < breakptArray.length; ++i2) {
            breakptArray[i2] = new Breakpt();
        }
        this.bbegin = new CArrayOfBreakpts(breakptArray, 0);
        this.bbegin.get().multi = this.kfirst.getPointer() - cArrayOfFloats.getPointer();
        this.bbegin.get().value = f2;
        this.bend = new CArrayOfBreakpts(this.bbegin);
        this.kleft = new CArrayOfFloats(this.kfirst);
        this.kright = new CArrayOfFloats(this.kfirst);
    }

    public void select() {
        this.breakpoints();
        this.knots();
        this.factors();
        this.preoffset = this.kleft.getPointer() - (this.inkbegin.getPointer() + this.order);
        this.postwidth = (this.bend.getPointer() - this.bbegin.getPointer()) * this.order;
        this.prewidth = this.outkend.getPointer() - this.outkbegin.getPointer() - this.order;
        this.postoffset = this.bbegin.get().def > 1 ? this.bbegin.get().def - 1 : 0;
    }

    private void factors() {
        CArrayOfFloats cArrayOfFloats = new CArrayOfFloats(this.outkend.getArray(), this.outkend.getPointer() - 1 - this.order + this.bend.get().multi);
        CArrayOfFloats cArrayOfFloats2 = null;
        if (this.sbegin != null) {
            cArrayOfFloats2 = new CArrayOfFloats(this.sbegin);
        }
        CArrayOfBreakpts cArrayOfBreakpts = new CArrayOfBreakpts(this.bend);
        while (cArrayOfBreakpts.getPointer() >= this.bbegin.getPointer()) {
            cArrayOfFloats.lessenPointerBy(cArrayOfBreakpts.get().multi);
            int n2 = cArrayOfBreakpts.get().def - 1;
            if (n2 >= 0) {
                float f2 = cArrayOfBreakpts.get().value;
                CArrayOfFloats cArrayOfFloats3 = new CArrayOfFloats(cArrayOfFloats.getArray(), cArrayOfFloats.getPointer() - n2 + (this.order - 1));
                CArrayOfFloats cArrayOfFloats4 = new CArrayOfFloats(cArrayOfFloats3.getArray(), cArrayOfFloats3.getPointer() + n2);
                while (cArrayOfFloats4.getPointer() != cArrayOfFloats3.getPointer()) {
                    CArrayOfFloats cArrayOfFloats5 = new CArrayOfFloats(cArrayOfFloats4);
                    CArrayOfFloats cArrayOfFloats6 = new CArrayOfFloats(cArrayOfFloats);
                    while (cArrayOfFloats5.getPointer() != cArrayOfFloats3.getPointer()) {
                        cArrayOfFloats2.set((f2 - cArrayOfFloats6.get()) / (cArrayOfFloats5.get() - cArrayOfFloats6.get()));
                        cArrayOfFloats2.pp();
                        cArrayOfFloats6.mm();
                        cArrayOfFloats5.mm();
                    }
                    cArrayOfFloats4.set(f2);
                    cArrayOfFloats4.mm();
                }
            }
            cArrayOfBreakpts.mm();
        }
    }

    private void knots() {
        CArrayOfFloats cArrayOfFloats = new CArrayOfFloats(this.kleft.getArray(), this.kleft.getPointer() - this.order);
        CArrayOfFloats cArrayOfFloats2 = new CArrayOfFloats(this.kright.getArray(), this.kright.getPointer() + this.bend.get().def);
        this.outkbegin = new CArrayOfFloats(new float[cArrayOfFloats2.getPointer() - cArrayOfFloats.getPointer()], 0);
        CArrayOfFloats cArrayOfFloats3 = new CArrayOfFloats(this.outkbegin);
        while (cArrayOfFloats.getPointer() != cArrayOfFloats2.getPointer()) {
            cArrayOfFloats3.set(cArrayOfFloats.get());
            cArrayOfFloats.pp();
            cArrayOfFloats3.pp();
        }
        this.outkend = new CArrayOfFloats(cArrayOfFloats3);
    }

    private void breakpoints() {
        CArrayOfBreakpts cArrayOfBreakpts = new CArrayOfBreakpts(this.bbegin);
        CArrayOfBreakpts cArrayOfBreakpts2 = new CArrayOfBreakpts(this.bend);
        int n2 = 0;
        cArrayOfBreakpts.get().value = cArrayOfBreakpts2.get().value;
        cArrayOfBreakpts.get().multi = cArrayOfBreakpts2.get().multi;
        this.kleft = new CArrayOfFloats(this.kright);
        while (this.kright.getPointer() != this.klast.getPointer()) {
            if (Knotvector.identical(this.kright.get(), cArrayOfBreakpts.get().value)) {
                ++cArrayOfBreakpts.get().multi;
            } else {
                cArrayOfBreakpts.get().def = this.order - cArrayOfBreakpts.get().multi;
                n2 += cArrayOfBreakpts.get().def * (cArrayOfBreakpts.get().def - 1) / 2;
                cArrayOfBreakpts.pp();
                cArrayOfBreakpts.get().value = this.kright.get();
                cArrayOfBreakpts.get().multi = 1;
            }
            this.kright.pp();
        }
        cArrayOfBreakpts.get().def = this.order - cArrayOfBreakpts.get().multi;
        this.bend = new CArrayOfBreakpts(cArrayOfBreakpts);
        if ((n2 += cArrayOfBreakpts.get().def * (cArrayOfBreakpts.get().def - 1) / 2) > 0) {
            this.sbegin = new CArrayOfFloats(new float[n2], 0);
            return;
        }
        this.sbegin = null;
    }

    public void copy(CArrayOfFloats cArrayOfFloats, CArrayOfFloats cArrayOfFloats2) {
        cArrayOfFloats = new CArrayOfFloats(cArrayOfFloats);
        cArrayOfFloats2 = new CArrayOfFloats(cArrayOfFloats2);
        cArrayOfFloats.raisePointerBy(this.preoffset);
        if (this.next != null) {
            CArrayOfFloats cArrayOfFloats3 = new CArrayOfFloats(cArrayOfFloats2.getArray(), cArrayOfFloats2.getPointer() + this.prewidth);
            while (cArrayOfFloats2.getPointer() != cArrayOfFloats3.getPointer()) {
                this.next.copy(cArrayOfFloats, cArrayOfFloats2);
                cArrayOfFloats.raisePointerBy(this.prestride);
                cArrayOfFloats2.raisePointerBy(this.poststride);
            }
        } else {
            CArrayOfFloats cArrayOfFloats4 = new CArrayOfFloats(cArrayOfFloats2.getArray(), cArrayOfFloats2.getPointer() + this.prewidth);
            while (cArrayOfFloats2.getPointer() != cArrayOfFloats4.getPointer()) {
                this.pt_io_copy(cArrayOfFloats2, cArrayOfFloats);
                cArrayOfFloats.raisePointerBy(this.prestride);
                cArrayOfFloats2.raisePointerBy(this.poststride);
            }
        }
    }

    private void pt_io_copy(CArrayOfFloats cArrayOfFloats, CArrayOfFloats cArrayOfFloats2) {
        switch (this.ncoords) {
            case 4: {
                cArrayOfFloats.setRelative(3, cArrayOfFloats2.getRelative(3));
            }
            case 3: {
                cArrayOfFloats.setRelative(2, cArrayOfFloats2.getRelative(2));
            }
            case 2: {
                cArrayOfFloats.setRelative(1, cArrayOfFloats2.getRelative(1));
            }
            case 1: {
                cArrayOfFloats.set(cArrayOfFloats2.get());
            }
        }
    }

    public void transform(CArrayOfFloats cArrayOfFloats) {
        cArrayOfFloats = new CArrayOfFloats(cArrayOfFloats);
        if (this.next != null) {
            if (this.equals(this.kspectotrans)) {
                this.next.transform(cArrayOfFloats);
                return;
            }
            if (this.istransformed) {
                cArrayOfFloats.raisePointerBy(this.postoffset);
                CArrayOfFloats cArrayOfFloats2 = new CArrayOfFloats(cArrayOfFloats.getArray(), cArrayOfFloats.getPointer() + this.postwidth);
                while (cArrayOfFloats.getPointer() != cArrayOfFloats2.getPointer()) {
                    this.next.transform(cArrayOfFloats);
                    cArrayOfFloats.raisePointerBy(this.poststride);
                }
            } else {
                CArrayOfFloats cArrayOfFloats3 = new CArrayOfFloats(cArrayOfFloats.getArray(), cArrayOfFloats.getPointer() + this.prewidth);
                while (cArrayOfFloats.getPointer() != cArrayOfFloats3.getPointer()) {
                    this.next.transform(cArrayOfFloats);
                    cArrayOfFloats.raisePointerBy(this.poststride);
                }
            }
        } else {
            if (this.equals(this.kspectotrans)) {
                this.insert(cArrayOfFloats);
                return;
            }
            if (this.istransformed) {
                cArrayOfFloats.raisePointerBy(this.postoffset);
                CArrayOfFloats cArrayOfFloats4 = new CArrayOfFloats(cArrayOfFloats.getArray(), cArrayOfFloats.getPointer() + this.postwidth);
                while (cArrayOfFloats.getPointer() != cArrayOfFloats4.getPointer()) {
                    this.kspectotrans.insert(cArrayOfFloats);
                    cArrayOfFloats.raisePointerBy(this.poststride);
                }
            } else {
                CArrayOfFloats cArrayOfFloats5 = new CArrayOfFloats(cArrayOfFloats.getArray(), cArrayOfFloats.getPointer() + this.prewidth);
                while (cArrayOfFloats.getPointer() != cArrayOfFloats5.getPointer()) {
                    this.kspectotrans.insert(cArrayOfFloats);
                    cArrayOfFloats.raisePointerBy(this.poststride);
                }
            }
        }
    }

    private void insert(CArrayOfFloats cArrayOfFloats) {
        CArrayOfFloats cArrayOfFloats2;
        CArrayOfFloats cArrayOfFloats3;
        CArrayOfFloats cArrayOfFloats4 = null;
        if (this.sbegin != null) {
            cArrayOfFloats4 = new CArrayOfFloats(this.sbegin);
        }
        CArrayOfFloats cArrayOfFloats5 = new CArrayOfFloats(cArrayOfFloats.getArray(), cArrayOfFloats.getPointer() + this.prewidth - this.poststride);
        cArrayOfFloats = new CArrayOfFloats(cArrayOfFloats.getArray(), cArrayOfFloats.getPointer() + this.postwidth + this.postoffset - this.poststride);
        CArrayOfBreakpts cArrayOfBreakpts = new CArrayOfBreakpts(this.bend);
        CArrayOfFloats cArrayOfFloats6 = new CArrayOfFloats(cArrayOfFloats5.getArray(), cArrayOfFloats5.getPointer() - this.poststride * cArrayOfBreakpts.get().def);
        while (cArrayOfFloats5.getPointer() != cArrayOfFloats6.getPointer()) {
            cArrayOfFloats3 = new CArrayOfFloats(cArrayOfFloats5);
            cArrayOfFloats2 = new CArrayOfFloats(cArrayOfFloats5.getArray(), cArrayOfFloats5.getPointer() - this.poststride);
            while (cArrayOfFloats2.getPointer() != cArrayOfFloats6.getPointer()) {
                this.pt_oo_sum(cArrayOfFloats3, cArrayOfFloats3, cArrayOfFloats2, cArrayOfFloats4.get(), 1.0 - (double)cArrayOfFloats4.get());
                cArrayOfFloats4.pp();
                cArrayOfFloats3.setPointer(cArrayOfFloats2.getPointer());
                cArrayOfFloats2.lessenPointerBy(this.poststride);
            }
            cArrayOfFloats6.raisePointerBy(this.poststride);
        }
        cArrayOfBreakpts.mm();
        while (cArrayOfBreakpts.getPointer() >= this.bbegin.getPointer()) {
            for (int i2 = cArrayOfBreakpts.get().multi; i2 > 0; --i2) {
                this.pt_oo_copy(cArrayOfFloats, cArrayOfFloats5);
                cArrayOfFloats.lessenPointerBy(this.poststride);
                cArrayOfFloats5.lessenPointerBy(this.poststride);
            }
            cArrayOfFloats6 = new CArrayOfFloats(cArrayOfFloats5.getArray(), cArrayOfFloats5.getPointer() - this.poststride * cArrayOfBreakpts.get().def);
            while (cArrayOfFloats5.getPointer() != cArrayOfFloats6.getPointer()) {
                this.pt_oo_copy(cArrayOfFloats, cArrayOfFloats5);
                cArrayOfFloats3 = new CArrayOfFloats(cArrayOfFloats5);
                cArrayOfFloats2 = new CArrayOfFloats(cArrayOfFloats5.getArray(), cArrayOfFloats5.getPointer() - this.poststride);
                while (cArrayOfFloats2.getPointer() != cArrayOfFloats6.getPointer()) {
                    this.pt_oo_sum(cArrayOfFloats3, cArrayOfFloats3, cArrayOfFloats2, cArrayOfFloats4.get(), 1.0 - (double)cArrayOfFloats4.get());
                    cArrayOfFloats4.pp();
                    cArrayOfFloats3.setPointer(cArrayOfFloats2.getPointer());
                    cArrayOfFloats2.lessenPointerBy(this.poststride);
                }
                cArrayOfFloats6.raisePointerBy(this.poststride);
                cArrayOfFloats.lessenPointerBy(this.poststride);
            }
            cArrayOfBreakpts.mm();
        }
    }

    private void pt_oo_copy(CArrayOfFloats cArrayOfFloats, CArrayOfFloats cArrayOfFloats2) {
        switch (this.ncoords) {
            case 4: {
                cArrayOfFloats.setRelative(3, cArrayOfFloats2.getRelative(3));
            }
            case 3: {
                cArrayOfFloats.setRelative(2, cArrayOfFloats2.getRelative(2));
            }
            case 2: {
                cArrayOfFloats.setRelative(1, cArrayOfFloats2.getRelative(1));
            }
            case 1: {
                cArrayOfFloats.setRelative(0, cArrayOfFloats2.getRelative(0));
            }
        }
    }

    private void pt_oo_sum(CArrayOfFloats cArrayOfFloats, CArrayOfFloats cArrayOfFloats2, CArrayOfFloats cArrayOfFloats3, float f2, double d2) {
        switch (this.ncoords) {
            case 4: {
                cArrayOfFloats.setRelative(3, (float)((double)(f2 * cArrayOfFloats2.getRelative(3)) + d2 * (double)cArrayOfFloats3.getRelative(3)));
            }
            case 3: {
                cArrayOfFloats.setRelative(2, (float)((double)(f2 * cArrayOfFloats2.getRelative(2)) + d2 * (double)cArrayOfFloats3.getRelative(2)));
            }
            case 2: {
                cArrayOfFloats.setRelative(1, (float)((double)(f2 * cArrayOfFloats2.getRelative(1)) + d2 * (double)cArrayOfFloats3.getRelative(1)));
            }
            case 1: {
                cArrayOfFloats.setRelative(0, (float)((double)(f2 * cArrayOfFloats2.getRelative(0)) + d2 * (double)cArrayOfFloats3.getRelative(0)));
            }
        }
    }
}

