/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.macosx;

import com.sun.opengl.impl.Debug;
import com.sun.opengl.impl.macosx.MacOSXGLDrawable;
import com.sun.opengl.impl.macosx.MacOSXPbufferGLContext;
import com.sun.opengl.impl.macosx.MacOSXPbufferGLDrawable$CGLImpl;
import com.sun.opengl.impl.macosx.MacOSXPbufferGLDrawable$Impl;
import com.sun.opengl.impl.macosx.MacOSXPbufferGLDrawable$NSOpenGLImpl;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;

public class MacOSXPbufferGLDrawable
extends MacOSXGLDrawable {
    private static final boolean DEBUG = Debug.debug("MacOSXPbufferGLDrawable");
    protected int initWidth;
    protected int initHeight;
    protected long pBuffer;
    protected int width;
    protected int height;
    private int textureTarget;
    private int texture;
    private boolean haveSetOpenGLMode = false;
    private int openGLMode = 1;
    protected MacOSXPbufferGLDrawable$Impl impl;

    public MacOSXPbufferGLDrawable(GLCapabilities gLCapabilities, int n2, int n3) {
        super(gLCapabilities, null);
        this.initWidth = n2;
        this.initHeight = n3;
        this.initOpenGLImpl();
        this.createPbuffer();
    }

    @Override
    public GLContext createContext(GLContext gLContext) {
        return new MacOSXPbufferGLContext(this, gLContext);
    }

    @Override
    public void destroy() {
        if (this.pBuffer != 0L) {
            this.impl.destroy(this.pBuffer);
            this.pBuffer = 0L;
            if (DEBUG) {
                System.err.println(new StringBuffer("Destroyed pbuffer ").append(this.width).append(" x ").append(this.height).toString());
            }
        }
    }

    @Override
    public void setSize(int n2, int n3) {
        throw new GLException("Not yet implemented");
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public GLCapabilities getCapabilities() {
        return this.capabilities;
    }

    public long getPbuffer() {
        return this.pBuffer;
    }

    @Override
    public void swapBuffers() {
    }

    protected void createPbuffer() {
        int n2;
        if (this.capabilities.getPbufferRenderToTextureRectangle()) {
            this.width = this.initWidth;
            this.height = this.initHeight;
            n2 = 34037;
        } else {
            this.width = this.getNextPowerOf2(this.initWidth);
            this.height = this.getNextPowerOf2(this.initHeight);
            n2 = 3553;
        }
        int n3 = 6408;
        if (this.capabilities.getPbufferFloatingPointBuffers()) {
            switch (this.capabilities.getRedBits()) {
                case 16: {
                    n3 = 34842;
                    break;
                }
                case 32: {
                    n3 = 34836;
                    break;
                }
                default: {
                    throw new GLException("Invalid floating-point bit depth (only 16 and 32 supported)");
                }
            }
        }
        this.pBuffer = this.impl.create(n2, n3, this.width, this.height);
        if (this.pBuffer == 0L) {
            throw new GLException("pbuffer creation error: CGL.createPBuffer() failed");
        }
        if (DEBUG) {
            System.err.println(new StringBuffer("Created pbuffer ").append(MacOSXPbufferGLDrawable.toHexString(this.pBuffer)).append(", ").append(this.width).append(" x ").append(this.height).append(" for ").append(this).toString());
        }
    }

    private int getNextPowerOf2(int n2) {
        if ((n2 - 1 & n2) == 0) {
            return n2;
        }
        int n3 = 0;
        while (n2 > 0) {
            n2 >>= 1;
            ++n3;
        }
        return 1 << n3;
    }

    @Override
    public void setOpenGLMode(int n2) {
        if (n2 == this.openGLMode) {
            return;
        }
        if (this.haveSetOpenGLMode) {
            throw new GLException("Can't switch between using NSOpenGLPixelBuffer and CGLPBufferObj more than once");
        }
        this.destroy();
        this.openGLMode = n2;
        this.haveSetOpenGLMode = true;
        if (DEBUG) {
            System.err.println(new StringBuffer("Switching PBuffer drawable mode to ").append(n2 == 1 ? "NSOPENGL_MODE" : "CGL_MODE").toString());
        }
        this.initOpenGLImpl();
        this.createPbuffer();
    }

    @Override
    public int getOpenGLMode() {
        return this.openGLMode;
    }

    private void initOpenGLImpl() {
        switch (this.openGLMode) {
            case 1: {
                this.impl = new MacOSXPbufferGLDrawable$NSOpenGLImpl(this);
                return;
            }
            case 2: {
                this.impl = new MacOSXPbufferGLDrawable$CGLImpl(this);
                return;
            }
        }
        throw new InternalError(new StringBuffer("Illegal implementation mode ").append(this.openGLMode).toString());
    }
}

