/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jorbis;

import com.jcraft.jogg.Buffer;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.FuncFloor;
import com.jcraft.jorbis.FuncMapping;
import com.jcraft.jorbis.FuncResidue;
import com.jcraft.jorbis.FuncTime;
import com.jcraft.jorbis.Info;
import com.jcraft.jorbis.InfoMapping0;
import com.jcraft.jorbis.InfoMode;
import com.jcraft.jorbis.LookMapping0;
import com.jcraft.jorbis.Mdct;

class Mapping0
extends FuncMapping {
    static int seq = 0;
    float[][] pcmbundle = null;
    int[] zerobundle = null;
    int[] nonzero = null;
    Object[] floormemo = null;

    Mapping0() {
    }

    @Override
    void free_info(Object object) {
    }

    @Override
    void free_look(Object object) {
    }

    @Override
    Object look(DspState dspState, InfoMode infoMode, Object object) {
        Info info = dspState.vi;
        LookMapping0 lookMapping0 = new LookMapping0();
        new LookMapping0().map = (InfoMapping0)object;
        object = new LookMapping0().map;
        lookMapping0.mode = infoMode;
        lookMapping0.time_look = new Object[((InfoMapping0)object).submaps];
        lookMapping0.floor_look = new Object[((InfoMapping0)object).submaps];
        lookMapping0.residue_look = new Object[((InfoMapping0)object).submaps];
        lookMapping0.time_func = new FuncTime[((InfoMapping0)object).submaps];
        lookMapping0.floor_func = new FuncFloor[((InfoMapping0)object).submaps];
        lookMapping0.residue_func = new FuncResidue[((InfoMapping0)object).submaps];
        for (int i2 = 0; i2 < ((InfoMapping0)object).submaps; ++i2) {
            int n2 = ((InfoMapping0)object).timesubmap[i2];
            int n3 = ((InfoMapping0)object).floorsubmap[i2];
            int n4 = ((InfoMapping0)object).residuesubmap[i2];
            lookMapping0.time_func[i2] = FuncTime.time_P[info.time_type[n2]];
            lookMapping0.time_look[i2] = lookMapping0.time_func[i2].look(dspState, infoMode, info.time_param[n2]);
            lookMapping0.floor_func[i2] = FuncFloor.floor_P[info.floor_type[n3]];
            lookMapping0.floor_look[i2] = lookMapping0.floor_func[i2].look(dspState, infoMode, info.floor_param[n3]);
            lookMapping0.residue_func[i2] = FuncResidue.residue_P[info.residue_type[n4]];
            lookMapping0.residue_look[i2] = lookMapping0.residue_func[i2].look(dspState, infoMode, info.residue_param[n4]);
        }
        int cfr_ignored_0 = info.psys;
        lookMapping0.ch = info.channels;
        return lookMapping0;
    }

    @Override
    void pack(Info info, Object object, Buffer buffer) {
        int n2;
        object = (InfoMapping0)object;
        if (((InfoMapping0)object).submaps > 1) {
            buffer.write(1, 1);
            buffer.write(((InfoMapping0)object).submaps - 1, 4);
        } else {
            buffer.write(0, 1);
        }
        if (((InfoMapping0)object).coupling_steps > 0) {
            buffer.write(1, 1);
            buffer.write(((InfoMapping0)object).coupling_steps - 1, 8);
            for (n2 = 0; n2 < ((InfoMapping0)object).coupling_steps; ++n2) {
                buffer.write(((InfoMapping0)object).coupling_mag[n2], Mapping0.ilog2(info.channels));
                buffer.write(((InfoMapping0)object).coupling_ang[n2], Mapping0.ilog2(info.channels));
            }
        } else {
            buffer.write(0, 1);
        }
        buffer.write(0, 2);
        if (((InfoMapping0)object).submaps > 1) {
            for (n2 = 0; n2 < info.channels; ++n2) {
                buffer.write(((InfoMapping0)object).chmuxlist[n2], 4);
            }
        }
        for (n2 = 0; n2 < ((InfoMapping0)object).submaps; ++n2) {
            buffer.write(((InfoMapping0)object).timesubmap[n2], 8);
            buffer.write(((InfoMapping0)object).floorsubmap[n2], 8);
            buffer.write(((InfoMapping0)object).residuesubmap[n2], 8);
        }
    }

    @Override
    Object unpack(Info info, Buffer buffer) {
        int n2;
        InfoMapping0 infoMapping0 = new InfoMapping0();
        infoMapping0.submaps = buffer.read(1) != 0 ? buffer.read(4) + 1 : 1;
        if (buffer.read(1) != 0) {
            infoMapping0.coupling_steps = buffer.read(8) + 1;
            for (n2 = 0; n2 < infoMapping0.coupling_steps; ++n2) {
                int n3 = infoMapping0.coupling_mag[n2] = buffer.read(Mapping0.ilog2(info.channels));
                int n4 = infoMapping0.coupling_ang[n2] = buffer.read(Mapping0.ilog2(info.channels));
                if (n3 >= 0 && n4 >= 0 && n3 != n4 && n3 < info.channels && n4 < info.channels) continue;
                infoMapping0.free();
                return null;
            }
        }
        if (buffer.read(2) > 0) {
            infoMapping0.free();
            return null;
        }
        if (infoMapping0.submaps > 1) {
            for (n2 = 0; n2 < info.channels; ++n2) {
                infoMapping0.chmuxlist[n2] = buffer.read(4);
                if (infoMapping0.chmuxlist[n2] < infoMapping0.submaps) continue;
                infoMapping0.free();
                return null;
            }
        }
        for (n2 = 0; n2 < infoMapping0.submaps; ++n2) {
            infoMapping0.timesubmap[n2] = buffer.read(8);
            if (infoMapping0.timesubmap[n2] >= info.times) {
                infoMapping0.free();
                return null;
            }
            infoMapping0.floorsubmap[n2] = buffer.read(8);
            if (infoMapping0.floorsubmap[n2] >= info.floors) {
                infoMapping0.free();
                return null;
            }
            infoMapping0.residuesubmap[n2] = buffer.read(8);
            if (infoMapping0.residuesubmap[n2] < info.residues) continue;
            infoMapping0.free();
            return null;
        }
        return infoMapping0;
    }

    @Override
    synchronized int inverse(Block block, Object object) {
        int n2;
        int n3;
        int n4;
        DspState dspState = block.vd;
        Info info = dspState.vi;
        object = (LookMapping0)object;
        InfoMapping0 infoMapping0 = ((LookMapping0)object).map;
        Object object2 = ((LookMapping0)object).mode;
        int n5 = block.pcmend = info.blocksizes[block.W];
        object2 = dspState.window[block.W][block.lW][block.nW][((InfoMode)object2).windowtype];
        if (this.pcmbundle == null || this.pcmbundle.length < info.channels) {
            this.pcmbundle = new float[info.channels][];
            this.nonzero = new int[info.channels];
            this.zerobundle = new int[info.channels];
            this.floormemo = new Object[info.channels];
        }
        for (n4 = 0; n4 < info.channels; ++n4) {
            float[] fArray = block.pcm[n4];
            n3 = infoMapping0.chmuxlist[n4];
            this.floormemo[n4] = ((LookMapping0)object).floor_func[n3].inverse1(block, ((LookMapping0)object).floor_look[n3], this.floormemo[n4]);
            this.nonzero[n4] = this.floormemo[n4] != null ? 1 : 0;
            for (n2 = 0; n2 < n5 / 2; ++n2) {
                fArray[n2] = 0.0f;
            }
        }
        for (n4 = 0; n4 < infoMapping0.coupling_steps; ++n4) {
            if (this.nonzero[infoMapping0.coupling_mag[n4]] == 0 && this.nonzero[infoMapping0.coupling_ang[n4]] == 0) continue;
            this.nonzero[infoMapping0.coupling_mag[n4]] = 1;
            this.nonzero[infoMapping0.coupling_ang[n4]] = 1;
        }
        for (n4 = 0; n4 < infoMapping0.submaps; ++n4) {
            int n6 = 0;
            for (n3 = 0; n3 < info.channels; ++n3) {
                if (infoMapping0.chmuxlist[n3] != n4) continue;
                this.zerobundle[n6] = this.nonzero[n3] != 0 ? 1 : 0;
                this.pcmbundle[n6++] = block.pcm[n3];
            }
            ((LookMapping0)object).residue_func[n4].inverse(block, ((LookMapping0)object).residue_look[n4], this.pcmbundle, this.zerobundle, n6);
        }
        for (n4 = infoMapping0.coupling_steps - 1; n4 >= 0; --n4) {
            float[] fArray = block.pcm[infoMapping0.coupling_mag[n4]];
            float[] fArray2 = block.pcm[infoMapping0.coupling_ang[n4]];
            for (n2 = 0; n2 < n5 / 2; ++n2) {
                float f2 = fArray[n2];
                float f3 = fArray2[n2];
                if (f2 > 0.0f) {
                    if (f3 > 0.0f) {
                        fArray[n2] = f2;
                        fArray2[n2] = f2 - f3;
                        continue;
                    }
                    fArray2[n2] = f2;
                    fArray[n2] = f2 + f3;
                    continue;
                }
                if (f3 > 0.0f) {
                    fArray[n2] = f2;
                    fArray2[n2] = f2 + f3;
                    continue;
                }
                fArray2[n2] = f2;
                fArray[n2] = f2 - f3;
            }
        }
        for (n4 = 0; n4 < info.channels; ++n4) {
            float[] fArray = block.pcm[n4];
            int n7 = infoMapping0.chmuxlist[n4];
            ((LookMapping0)object).floor_func[n7].inverse2(block, ((LookMapping0)object).floor_look[n7], this.floormemo[n4], fArray);
        }
        for (n4 = 0; n4 < info.channels; ++n4) {
            float[] fArray = block.pcm[n4];
            ((Mdct)dspState.transform[block.W][0]).backward(fArray, fArray);
        }
        for (n4 = 0; n4 < info.channels; ++n4) {
            int n8;
            float[] fArray = block.pcm[n4];
            if (this.nonzero[n4] != 0) {
                for (n8 = 0; n8 < n5; ++n8) {
                    int n9 = n8;
                    fArray[n9] = fArray[n9] * object2[n8];
                }
                continue;
            }
            for (n8 = 0; n8 < n5; ++n8) {
                fArray[n8] = 0.0f;
            }
        }
        return 0;
    }

    private static int ilog2(int n2) {
        int n3 = 0;
        while (n2 > 1) {
            ++n3;
            n2 >>>= 1;
        }
        return n3;
    }
}

