/*

 @ author, GLSL & OpenGL code author Athanasios Theocharidis, Michael Kargas, 2008-2009-2010

*/

uniform sampler2D voronoi2DTexture;
uniform sampler2D voronoiEmbossSpecial2DTexture;

uniform float voronoiTimer;
uniform float voronoiTransparency;
uniform bool voronoiOldLCDStyleTransparency;
uniform int voronoiState;
uniform bool voronoiInterpolation;

const vec4 VORONOI_BLACK_COLOR = vec4(1.0, 1.0, 1.0, 1.0);
const vec2 VORONOI_TEXTURE_CENTER_POINT = vec2(0.5, 0.5);
const int VORONOI_N = 32;

void applyOldStyleTransparency();

void main()
{
    if (voronoiOldLCDStyleTransparency)
        applyOldStyleTransparency();

    vec4 textureColor = (voronoiInterpolation) ? 
                        mix(VORONOI_BLACK_COLOR, vec4(texture2D(voronoi2DTexture, gl_TexCoord[0].st).xyz, 1.0), 0.5) :
                        mix(VORONOI_BLACK_COLOR, vec4(texture2D(voronoiEmbossSpecial2DTexture, gl_TexCoord[0].st).xyz, 1.0), 0.5);
    vec2 coord = vec2( 2.0 * (gl_TexCoord[0].st - VORONOI_TEXTURE_CENTER_POINT) );
    float ii = 0.0;
    float dist = 0.0;

    if (voronoiState == 1) // process voronoi blob effect
    {
	for (int i = 0; i < VORONOI_N; i++)
	{
            ii = float(i);
            dist += 1.0 / pow( distance( coord, vec2( sin(ii * ii + voronoiTimer), sin(ii * ii * ii + voronoiTimer) ) ), 1.5);
	}

        textureColor *= vec4(vec3(0.01 * dist), 1.0);
    }
    else // process voronoi cell effect
    {
        float minimum = 256.0;
        for (int i = 0; i < VORONOI_N; i++)
        {
            ii = float(i);
            dist = distance( coord, vec2( sin(ii * ii + voronoiTimer), sin(ii * ii * ii + voronoiTimer) ) );
            minimum = min(minimum, dist);
        }

        textureColor *= vec4(vec3(3.0 * minimum), 1.0);
    }

    gl_FragColor = voronoiTransparency * textureColor;
}
