/*

 @ author, GLSL & OpenGL code author Athanasios Theocharidis, Michael Kargas, 2008-2009-2010

*/

varying vec2 coord;

uniform float plasmaTimer;
uniform float plasmaTransparency;
uniform bool plasmaOldLCDStyleTransparency;

void applyOldStyleTransparency();

void main()
{
    if (plasmaOldLCDStyleTransparency)
        applyOldStyleTransparency();

    vec4 color = vec4(0.0, 0.0, 0.0, plasmaTransparency);

    float x = coord.x / 8.0;
    float y = coord.y / 6.0;

    float timer = plasmaTimer / 256.0;

    color.r = plasmaTransparency * (sin((x + timer) / 2.0) + sin(y / 3.0) + sin((x - timer) / 3.0 + sin((y - 2.0 * timer) / 2.0)) + sin((x + y) / 4.0 + sin((x - y + timer) / 3.0)) + 4.0) / 8.0;
    color.g = plasmaTransparency * (sin(x / 3.0) + sin((y + timer) / 2.0) + sin(x / 4.0 + sin((y + 2.0 * timer) / 5.0)) + sin((x + y + 5.0 * timer) / 3.0 + sin((x - y - 2.0 * timer) / 6.0)) + 4.0) / 8.0;
    color.b = plasmaTransparency * (sin((x + 3.0 * timer) / 3.0) + sin((y + timer) / 3.0) + sin(x / 3.0 + sin((y - 3.0 * timer) / 4.0)) + sin((x + y + 4.0 * timer) / 2.0 + sin((x - y) / 4.0)) + 4.0) / 8.0;

    gl_FragColor = color;
}
