/*

 @ author, GLSL & OpenGL code author Athanasios Theocharidis, Michael Kargas, 2008-2009-2010

*/

uniform sampler2D blur2DTexture;

uniform float blurTransparency;
uniform bool blurOldLCDStyleTransparency;
uniform int blurState;
uniform bool blurInterpolation;
uniform float blurSize;

const float N = 10.0;
const float N_HALF = N / 2.0;

void applyOldStyleTransparency();

void main()
{
    if (blurOldLCDStyleTransparency)
        applyOldStyleTransparency();

    float localBlurSize = 0.001 * blurSize;

    vec2 tcoordsBlur, tcoords = gl_TexCoord[0].st;
    vec4 blur2DTextureColor, colorSum = vec4(0.0, 0.0, 0.0, 0.0);
    float blurValue = 0.0;
    float blurDivideRation = 0.0;

    if (blurState == 0)
    {
        for (float x = -N_HALF; x <= N_HALF; x++)
        {
            blurValue = (localBlurSize * x);
            tcoordsBlur.s = tcoords.s + blurValue;
            tcoordsBlur.t = tcoords.t;

            blur2DTextureColor = texture2D(blur2DTexture, tcoordsBlur);
            colorSum += (blurInterpolation) ? mix(blur2DTextureColor, colorSum, blurValue) : blur2DTextureColor;
        }

        blurDivideRation = N;
    }
    else if (blurState == 1)
    {
        for (float y = -N_HALF; y <= N_HALF; y++)
        {
            blurValue = (localBlurSize * y);
            tcoordsBlur.s = tcoords.s;
            tcoordsBlur.t = tcoords.t + blurValue;

            blur2DTextureColor = texture2D(blur2DTexture, tcoordsBlur);
            colorSum += (blurInterpolation) ? mix(blur2DTextureColor, colorSum, blurValue) : blur2DTextureColor;
        }

        blurDivideRation = N;
    }
    else // if (blurState == 2)
    {
        for (float y = -N_HALF; y <= N_HALF; y++)
        {
            for (float x = -N_HALF; x <= N_HALF; x++)
            {
                tcoordsBlur.s = tcoords.s + (localBlurSize * x);
                tcoordsBlur.t = tcoords.t + (localBlurSize * y);

                blur2DTextureColor = texture2D(blur2DTexture, tcoordsBlur);
                colorSum += (blurInterpolation) ? mix(blur2DTextureColor, colorSum, blurValue) : blur2DTextureColor;
            }
        }

        blurDivideRation = N * N;
    }

    gl_FragColor = blurTransparency * (colorSum / blurDivideRation);
}
