/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share.sampled.mixer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.spi.MixerProvider;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.mixer.TMixerProvider$MixerProviderStruct;

public abstract class TMixerProvider
extends MixerProvider {
    private static final Mixer.Info[] EMPTY_MIXER_INFO_ARRAY = new Mixer.Info[0];
    private static Map sm_mixerProviderStructs = new HashMap();
    private boolean m_bDisabled = false;

    public TMixerProvider() {
        if (TDebug.TraceMixerProvider) {
            TDebug.out("TMixerProvider.<init>(): begin");
        }
        if (TDebug.TraceMixerProvider) {
            TDebug.out("TMixerProvider.<init>(): end");
        }
    }

    protected void staticInit() {
    }

    private TMixerProvider$MixerProviderStruct getMixerProviderStruct() {
        if (TDebug.TraceMixerProvider) {
            TDebug.out("TMixerProvider.getMixerProviderStruct(): begin");
        }
        Class<?> clazz = this.getClass();
        if (TDebug.TraceMixerProvider) {
            TDebug.out("TMixerProvider.getMixerProviderStruct(): called from " + clazz);
        }
        Class<TMixerProvider> clazz2 = TMixerProvider.class;
        synchronized (TMixerProvider.class) {
            TMixerProvider$MixerProviderStruct tMixerProvider$MixerProviderStruct = (TMixerProvider$MixerProviderStruct)sm_mixerProviderStructs.get(clazz);
            if (tMixerProvider$MixerProviderStruct == null) {
                if (TDebug.TraceMixerProvider) {
                    TDebug.out("TMixerProvider.getMixerProviderStruct(): creating new MixerProviderStruct for " + clazz);
                }
                tMixerProvider$MixerProviderStruct = new TMixerProvider$MixerProviderStruct(this);
                sm_mixerProviderStructs.put(clazz, tMixerProvider$MixerProviderStruct);
            }
            if (TDebug.TraceMixerProvider) {
                TDebug.out("TMixerProvider.getMixerProviderStruct(): end");
            }
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return tMixerProvider$MixerProviderStruct;
        }
    }

    protected void disable() {
        if (TDebug.TraceMixerProvider) {
            TDebug.out("disabling " + this.getClass().getName());
        }
        this.m_bDisabled = true;
    }

    protected boolean isDisabled() {
        return this.m_bDisabled;
    }

    protected void addMixer(Mixer mixer) {
        TMixerProvider$MixerProviderStruct tMixerProvider$MixerProviderStruct;
        if (TDebug.TraceMixerProvider) {
            TDebug.out("TMixerProvider.addMixer(): begin");
        }
        TMixerProvider$MixerProviderStruct tMixerProvider$MixerProviderStruct2 = tMixerProvider$MixerProviderStruct = this.getMixerProviderStruct();
        synchronized (tMixerProvider$MixerProviderStruct) {
            tMixerProvider$MixerProviderStruct.m_mixers.add(mixer);
            if (tMixerProvider$MixerProviderStruct.m_defaultMixer == null) {
                tMixerProvider$MixerProviderStruct.m_defaultMixer = mixer;
            }
            // ** MonitorExit[var3_4] (shouldn't be in output)
            if (TDebug.TraceMixerProvider) {
                TDebug.out("TMixerProvider.addMixer(): end");
            }
            return;
        }
    }

    protected void removeMixer(Mixer mixer) {
        TMixerProvider$MixerProviderStruct tMixerProvider$MixerProviderStruct;
        if (TDebug.TraceMixerProvider) {
            TDebug.out("TMixerProvider.removeMixer(): begin");
        }
        TMixerProvider$MixerProviderStruct tMixerProvider$MixerProviderStruct2 = tMixerProvider$MixerProviderStruct = this.getMixerProviderStruct();
        synchronized (tMixerProvider$MixerProviderStruct) {
            tMixerProvider$MixerProviderStruct.m_mixers.remove(mixer);
            if (tMixerProvider$MixerProviderStruct.m_defaultMixer == mixer) {
                tMixerProvider$MixerProviderStruct.m_defaultMixer = null;
            }
            // ** MonitorExit[var3_4] (shouldn't be in output)
            if (TDebug.TraceMixerProvider) {
                TDebug.out("TMixerProvider.removeMixer(): end");
            }
            return;
        }
    }

    @Override
    public boolean isMixerSupported(Mixer.Info info) {
        if (TDebug.TraceMixerProvider) {
            TDebug.out("TMixerProvider.isMixerSupported(): begin");
        }
        boolean bl = false;
        Mixer.Info[] infoArray = this.getMixerInfo();
        for (int i2 = 0; i2 < infoArray.length; ++i2) {
            if (!infoArray[i2].equals(info)) continue;
            bl = true;
            break;
        }
        if (TDebug.TraceMixerProvider) {
            TDebug.out("TMixerProvider.isMixerSupported(): end");
        }
        return bl;
    }

    @Override
    public Mixer getMixer(Mixer.Info info) {
        if (TDebug.TraceMixerProvider) {
            TDebug.out("TMixerProvider.getMixer(): begin");
        }
        TMixerProvider$MixerProviderStruct tMixerProvider$MixerProviderStruct = this.getMixerProviderStruct();
        Mixer mixer = null;
        TMixerProvider$MixerProviderStruct tMixerProvider$MixerProviderStruct2 = tMixerProvider$MixerProviderStruct;
        synchronized (tMixerProvider$MixerProviderStruct2) {
            if (info == null) {
                mixer = tMixerProvider$MixerProviderStruct.m_defaultMixer;
            } else {
                for (Mixer mixer2 : tMixerProvider$MixerProviderStruct.m_mixers) {
                    if (!mixer2.getMixerInfo().equals(info)) continue;
                    mixer = mixer2;
                    break;
                }
            }
        }
        if (mixer == null) {
            throw new IllegalArgumentException("no mixer available for " + info);
        }
        if (TDebug.TraceMixerProvider) {
            TDebug.out("TMixerProvider.getMixer(): end");
        }
        return mixer;
    }

    @Override
    public Mixer.Info[] getMixerInfo() {
        if (TDebug.TraceMixerProvider) {
            TDebug.out("TMixerProvider.getMixerInfo(): begin");
        }
        HashSet<Mixer.Info> hashSet = new HashSet<Mixer.Info>();
        TMixerProvider$MixerProviderStruct tMixerProvider$MixerProviderStruct = this.getMixerProviderStruct();
        TMixerProvider$MixerProviderStruct tMixerProvider$MixerProviderStruct2 = tMixerProvider$MixerProviderStruct;
        synchronized (tMixerProvider$MixerProviderStruct) {
            for (Mixer mixer : tMixerProvider$MixerProviderStruct.m_mixers) {
                hashSet.add(mixer.getMixerInfo());
            }
            // ** MonitorExit[var3_4] (shouldn't be in output)
            if (TDebug.TraceMixerProvider) {
                TDebug.out("TMixerProvider.getMixerInfo(): end");
            }
            return hashSet.toArray(EMPTY_MIXER_INFO_ARRAY);
        }
    }
}

