/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share.sampled.convert;

import java.util.Collection;
import java.util.Iterator;
import javax.sound.sampled.AudioFormat;
import org.tritonus.share.ArraySet;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.AudioFormats;
import org.tritonus.share.sampled.convert.TFormatConversionProvider;

public abstract class TSimpleFormatConversionProvider
extends TFormatConversionProvider {
    private Collection m_sourceEncodings = new ArraySet();
    private Collection m_targetEncodings = new ArraySet();
    private Collection m_sourceFormats;
    private Collection m_targetFormats;

    protected TSimpleFormatConversionProvider(Collection collection, Collection collection2) {
        this.m_sourceFormats = collection;
        this.m_targetFormats = collection2;
        TSimpleFormatConversionProvider.collectEncodings(this.m_sourceFormats, this.m_sourceEncodings);
        TSimpleFormatConversionProvider.collectEncodings(this.m_targetFormats, this.m_targetEncodings);
    }

    protected void disable() {
        if (TDebug.TraceAudioConverter) {
            TDebug.out("TSimpleFormatConversionProvider.disable(): disabling " + this.getClass().getName());
        }
        this.m_sourceEncodings = new ArraySet();
        this.m_targetEncodings = new ArraySet();
        this.m_sourceFormats = new ArraySet();
        this.m_targetFormats = new ArraySet();
    }

    private static void collectEncodings(Collection object, Collection collection) {
        object = object.iterator();
        while (object.hasNext()) {
            AudioFormat audioFormat = (AudioFormat)object.next();
            collection.add(audioFormat.getEncoding());
        }
    }

    @Override
    public AudioFormat.Encoding[] getSourceEncodings() {
        return this.m_sourceEncodings.toArray(EMPTY_ENCODING_ARRAY);
    }

    @Override
    public AudioFormat.Encoding[] getTargetEncodings() {
        return this.m_targetEncodings.toArray(EMPTY_ENCODING_ARRAY);
    }

    @Override
    public boolean isSourceEncodingSupported(AudioFormat.Encoding encoding) {
        return this.m_sourceEncodings.contains(encoding);
    }

    @Override
    public boolean isTargetEncodingSupported(AudioFormat.Encoding encoding) {
        return this.m_targetEncodings.contains(encoding);
    }

    @Override
    public AudioFormat.Encoding[] getTargetEncodings(AudioFormat audioFormat) {
        if (this.isAllowedSourceFormat(audioFormat)) {
            return this.getTargetEncodings();
        }
        return EMPTY_ENCODING_ARRAY;
    }

    @Override
    public AudioFormat[] getTargetFormats(AudioFormat.Encoding encoding, AudioFormat audioFormat) {
        if (this.isConversionSupported(encoding, audioFormat)) {
            return this.m_targetFormats.toArray(EMPTY_FORMAT_ARRAY);
        }
        return EMPTY_FORMAT_ARRAY;
    }

    protected boolean isAllowedSourceEncoding(AudioFormat.Encoding encoding) {
        return this.m_sourceEncodings.contains(encoding);
    }

    protected boolean isAllowedTargetEncoding(AudioFormat.Encoding encoding) {
        return this.m_targetEncodings.contains(encoding);
    }

    protected boolean isAllowedSourceFormat(AudioFormat audioFormat) {
        Iterator iterator = this.m_sourceFormats.iterator();
        while (iterator.hasNext()) {
            if (!AudioFormats.matches((AudioFormat)iterator.next(), audioFormat)) continue;
            return true;
        }
        return false;
    }

    protected boolean isAllowedTargetFormat(AudioFormat audioFormat) {
        Iterator iterator = this.m_targetFormats.iterator();
        while (iterator.hasNext()) {
            if (!AudioFormats.matches((AudioFormat)iterator.next(), audioFormat)) continue;
            return true;
        }
        return false;
    }

    protected Collection getCollectionSourceEncodings() {
        return this.m_sourceEncodings;
    }

    protected Collection getCollectionTargetEncodings() {
        return this.m_targetEncodings;
    }

    protected Collection getCollectionSourceFormats() {
        return this.m_sourceFormats;
    }

    protected Collection getCollectionTargetFormats() {
        return this.m_targetFormats;
    }

    protected static boolean doMatch(int n2, int n3) {
        return n2 == -1 || n3 == -1 || n2 == n3;
    }

    protected static boolean doMatch(float f2, float f3) {
        return f2 == -1.0f || f3 == -1.0f || (double)Math.abs(f2 - f3) < 1.0E-9;
    }

    protected AudioFormat replaceNotSpecified(AudioFormat audioFormat, AudioFormat audioFormat2) {
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = false;
        if (audioFormat2.getSampleSizeInBits() == -1 && audioFormat.getSampleSizeInBits() != -1) {
            n2 = 1;
        }
        if (audioFormat2.getChannels() == -1 && audioFormat.getChannels() != -1) {
            n3 = 1;
        }
        if (audioFormat2.getSampleRate() == -1.0f && audioFormat.getSampleRate() != -1.0f) {
            bl = true;
        }
        if (audioFormat2.getFrameRate() == -1.0f && audioFormat.getFrameRate() != -1.0f) {
            bl2 = true;
        }
        if (n2 != 0 || n3 != 0 || bl || bl2 || audioFormat2.getFrameSize() == -1 && audioFormat.getFrameSize() != -1) {
            float f2 = bl ? audioFormat.getSampleRate() : audioFormat2.getSampleRate();
            float f3 = bl2 ? audioFormat.getFrameRate() : audioFormat2.getFrameRate();
            n2 = n2 != 0 ? audioFormat.getSampleSizeInBits() : audioFormat2.getSampleSizeInBits();
            int n4 = n3 != 0 ? audioFormat.getChannels() : audioFormat2.getChannels();
            n3 = this.getFrameSize(audioFormat2.getEncoding(), f2, n2, n4, f3, audioFormat2.isBigEndian(), audioFormat2.getFrameSize());
            audioFormat2 = new AudioFormat(audioFormat2.getEncoding(), f2, n2, n4, n3, f3, audioFormat2.isBigEndian());
        }
        return audioFormat2;
    }

    protected int getFrameSize(AudioFormat.Encoding encoding, float f2, int n2, int n3, float f3, boolean bl, int n4) {
        if (n2 == -1 || n3 == -1) {
            return -1;
        }
        return n2 * n3 / 8;
    }
}

