/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share.sampled;

import java.util.List;
import java.util.Random;
import javax.sound.sampled.AudioFormat;

public class FloatSampleTools {
    public static final float DEFAULT_DITHER_BITS = 0.7f;
    private static Random random = null;
    static final int F_8 = 1;
    static final int F_16 = 2;
    static final int F_24 = 3;
    static final int F_32 = 4;
    static final int F_SAMPLE_WIDTH_MASK = 7;
    static final int F_SIGNED = 8;
    static final int F_BIGENDIAN = 16;
    static final int CT_8S = 9;
    static final int CT_8U = 1;
    static final int CT_16SB = 26;
    static final int CT_16SL = 10;
    static final int CT_24SB = 27;
    static final int CT_24SL = 11;
    static final int CT_32SB = 28;
    static final int CT_32SL = 12;
    private static final float twoPower7 = 128.0f;
    private static final float twoPower15 = 32768.0f;
    private static final float twoPower23 = 8388608.0f;
    private static final float twoPower31 = 2.1474836E9f;
    private static final float invTwoPower7 = 0.0078125f;
    private static final float invTwoPower15 = 3.0517578E-5f;
    private static final float invTwoPower23 = 1.1920929E-7f;
    private static final float invTwoPower31 = 4.656613E-10f;

    private FloatSampleTools() {
    }

    static void checkSupportedSampleSize(int n2, int n3, int n4) {
        if (n2 * n3 != n4 << 3) {
            throw new IllegalArgumentException("unsupported sample size: " + n2 + " stored in " + n4 / n3 + " bytes.");
        }
    }

    static int getFormatType(AudioFormat audioFormat) {
        boolean bl = audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED);
        if (!bl && !audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED)) {
            throw new IllegalArgumentException("unsupported encoding: only PCM encoding supported.");
        }
        if (!bl && audioFormat.getSampleSizeInBits() != 8) {
            throw new IllegalArgumentException("unsupported encoding: only 8-bit can be unsigned");
        }
        FloatSampleTools.checkSupportedSampleSize(audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getFrameSize());
        return FloatSampleTools.getFormatType(audioFormat.getSampleSizeInBits(), bl, audioFormat.isBigEndian());
    }

    static int getFormatType(int n2, boolean bl, boolean bl2) {
        int n3 = n2 / 8;
        int n4 = 0;
        if (n2 == 8) {
            n4 = 1;
        } else if (n2 == 16) {
            n4 = 2;
        } else if (n2 == 24) {
            n4 = 3;
        } else if (n2 == 32) {
            n4 = 4;
        }
        if (n4 == 0) {
            throw new IllegalArgumentException("FloatSampleBuffer: unsupported sample size of " + n2 + " bits per sample.");
        }
        if (!bl && n3 > 1) {
            throw new IllegalArgumentException("FloatSampleBuffer: unsigned samples larger than 8 bit are not supported");
        }
        if (bl) {
            n4 |= 8;
        }
        if (bl2 && n2 != 8) {
            n4 |= 0x10;
        }
        return n4;
    }

    static int getSampleSize(int n2) {
        switch (n2 & 7) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
        }
        return 0;
    }

    static String formatType2Str(int n2) {
        String string = n2 + ": ";
        switch (n2 & 7) {
            case 1: {
                string = string + "8bit";
                break;
            }
            case 2: {
                string = string + "16bit";
                break;
            }
            case 3: {
                string = string + "24bit";
                break;
            }
            case 4: {
                string = string + "32bit";
            }
        }
        string = string + ((n2 & 8) == 8 ? " signed" : " unsigned");
        if ((n2 & 7) != 1) {
            string = string + ((n2 & 0x10) == 16 ? " big endian" : " little endian");
        }
        return string;
    }

    public static void byte2float(byte[] byArray, int n2, List list, int n3, int n4, AudioFormat audioFormat) {
        for (int i2 = 0; i2 < audioFormat.getChannels(); ++i2) {
            float[] fArray;
            if (list.size() < i2) {
                fArray = new float[n4 + n3];
                list.add(fArray);
            } else {
                fArray = (float[])list.get(i2);
                if (fArray.length < n4 + n3) {
                    fArray = new float[n4 + n3];
                    list.set(i2, fArray);
                }
            }
            FloatSampleTools.byte2floatGeneric(byArray, n2, audioFormat.getFrameSize(), fArray, n3, n4, audioFormat);
            n2 += audioFormat.getFrameSize() / audioFormat.getChannels();
        }
    }

    public static void byte2floatInterleaved(byte[] byArray, int n2, float[] fArray, int n3, int n4, AudioFormat audioFormat) {
        FloatSampleTools.byte2floatGeneric(byArray, n2, audioFormat.getFrameSize() / audioFormat.getChannels(), fArray, n3, n4 * audioFormat.getChannels(), audioFormat);
    }

    static void byte2floatGeneric(byte[] byArray, int n2, int n3, float[] fArray, int n4, int n5, AudioFormat audioFormat) {
        int n6 = FloatSampleTools.getFormatType(audioFormat);
        FloatSampleTools.byte2floatGeneric(byArray, n2, n3, fArray, n4, n5, n6);
    }

    static void byte2floatGeneric(byte[] byArray, int n2, int n3, float[] fArray, int n4, int n5, int n6) {
        n5 = n4 + n5;
        while (n4 < n5) {
            switch (n6) {
                case 9: {
                    fArray[n4] = (float)byArray[n2] * 0.0078125f;
                    break;
                }
                case 1: {
                    fArray[n4] = (float)((byArray[n2] & 0xFF) - 128) * 0.0078125f;
                    break;
                }
                case 26: {
                    fArray[n4] = (float)(byArray[n2] << 8 | byArray[n2 + 1] & 0xFF) * 3.0517578E-5f;
                    break;
                }
                case 10: {
                    fArray[n4] = (float)(byArray[n2 + 1] << 8 | byArray[n2] & 0xFF) * 3.0517578E-5f;
                    break;
                }
                case 27: {
                    fArray[n4] = (float)(byArray[n2] << 16 | (byArray[n2 + 1] & 0xFF) << 8 | byArray[n2 + 2] & 0xFF) * 1.1920929E-7f;
                    break;
                }
                case 11: {
                    fArray[n4] = (float)(byArray[n2 + 2] << 16 | (byArray[n2 + 1] & 0xFF) << 8 | byArray[n2] & 0xFF) * 1.1920929E-7f;
                    break;
                }
                case 28: {
                    fArray[n4] = (float)(byArray[n2] << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF) * 4.656613E-10f;
                    break;
                }
                case 12: {
                    fArray[n4] = (float)(byArray[n2 + 3] << 24 | (byArray[n2 + 2] & 0xFF) << 16 | (byArray[n2 + 1] & 0xFF) << 8 | byArray[n2] & 0xFF) * 4.656613E-10f;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unsupported format=" + FloatSampleTools.formatType2Str(n6));
                }
            }
            ++n4;
            n2 += n3;
        }
    }

    private static byte quantize8(float f2, float f3) {
        if (f3 != 0.0f) {
            f2 += random.nextFloat() * f3;
        }
        if (f2 >= 127.0f) {
            return 127;
        }
        if (f2 <= -128.0f) {
            return -128;
        }
        return (byte)(f2 < 0.0f ? f2 - 0.5f : f2 + 0.5f);
    }

    private static int quantize16(float f2, float f3) {
        if (f3 != 0.0f) {
            f2 += random.nextFloat() * f3;
        }
        if (f2 >= 32767.0f) {
            return Short.MAX_VALUE;
        }
        if (f2 <= -32768.0f) {
            return Short.MIN_VALUE;
        }
        return (int)(f2 < 0.0f ? f2 - 0.5f : f2 + 0.5f);
    }

    private static int quantize24(float f2, float f3) {
        if (f3 != 0.0f) {
            f2 += random.nextFloat() * f3;
        }
        if (f2 >= 8388607.0f) {
            return 0x7FFFFF;
        }
        if (f2 <= -8388608.0f) {
            return -8388608;
        }
        return (int)(f2 < 0.0f ? f2 - 0.5f : f2 + 0.5f);
    }

    private static int quantize32(float f2, float f3) {
        if (f3 != 0.0f) {
            f2 += random.nextFloat() * f3;
        }
        if (f2 >= 2.1474836E9f) {
            return Integer.MAX_VALUE;
        }
        if (f2 <= -2.1474836E9f) {
            return Integer.MIN_VALUE;
        }
        return (int)(f2 < 0.0f ? f2 - 0.5f : f2 + 0.5f);
    }

    public static void float2byte(List list, int n2, byte[] byArray, int n3, int n4, AudioFormat audioFormat, float f2) {
        for (int i2 = 0; i2 < audioFormat.getChannels(); ++i2) {
            FloatSampleTools.float2byteGeneric((float[])list.get(i2), n2, byArray, n3, audioFormat.getFrameSize(), n4, audioFormat, f2);
            n3 += audioFormat.getFrameSize() / audioFormat.getChannels();
        }
    }

    public static void float2byteInterleaved(float[] fArray, int n2, byte[] byArray, int n3, int n4, AudioFormat audioFormat, float f2) {
        FloatSampleTools.float2byteGeneric(fArray, n2, byArray, n3, audioFormat.getFrameSize() / audioFormat.getChannels(), n4 * audioFormat.getChannels(), audioFormat, f2);
    }

    static void float2byteGeneric(float[] fArray, int n2, byte[] byArray, int n3, int n4, int n5, AudioFormat audioFormat, float f2) {
        int n6 = FloatSampleTools.getFormatType(audioFormat);
        FloatSampleTools.float2byteGeneric(fArray, n2, byArray, n3, n4, n5, n6, f2);
    }

    static void float2byteGeneric(float[] fArray, int n2, byte[] byArray, int n3, int n4, int n5, int n6, float f2) {
        if (n2 < 0 || n2 + n5 > fArray.length || n5 < 0) {
            throw new IllegalArgumentException("invalid input index: input.length=" + fArray.length + " inOffset=" + n2 + " sampleCount=" + n5);
        }
        if (n3 < 0 || n3 + n5 * n4 >= byArray.length + n4 || n4 < FloatSampleTools.getSampleSize(n6)) {
            throw new IllegalArgumentException("invalid output index: output.length=" + byArray.length + " outByteOffset=" + n3 + " outByteStep=" + n4 + " sampleCount=" + n5 + " format=" + FloatSampleTools.formatType2Str(n6));
        }
        if (f2 != 0.0f && random == null) {
            random = new Random();
        }
        n5 = n2 + n5;
        int n7 = n2;
        while (n7 < n5) {
            switch (n6) {
                case 9: {
                    byArray[n3] = FloatSampleTools.quantize8(fArray[n7] * 128.0f, f2);
                    break;
                }
                case 1: {
                    byArray[n3] = (byte)(FloatSampleTools.quantize8(fArray[n7] * 128.0f, f2) + 128);
                    break;
                }
                case 26: {
                    n2 = FloatSampleTools.quantize16(fArray[n7] * 32768.0f, f2);
                    byArray[n3] = (byte)(n2 >> 8);
                    byArray[n3 + 1] = (byte)n2;
                    break;
                }
                case 10: {
                    n2 = FloatSampleTools.quantize16(fArray[n7] * 32768.0f, f2);
                    byArray[n3 + 1] = (byte)(n2 >> 8);
                    byArray[n3] = (byte)n2;
                    break;
                }
                case 27: {
                    n2 = FloatSampleTools.quantize24(fArray[n7] * 8388608.0f, f2);
                    byArray[n3] = (byte)(n2 >> 16);
                    byArray[n3 + 1] = (byte)(n2 >>> 8);
                    byArray[n3 + 2] = (byte)n2;
                    break;
                }
                case 11: {
                    n2 = FloatSampleTools.quantize24(fArray[n7] * 8388608.0f, f2);
                    byArray[n3 + 2] = (byte)(n2 >> 16);
                    byArray[n3 + 1] = (byte)(n2 >>> 8);
                    byArray[n3] = (byte)n2;
                    break;
                }
                case 28: {
                    n2 = FloatSampleTools.quantize32(fArray[n7] * 2.1474836E9f, f2);
                    byArray[n3] = n2 >> 24;
                    byArray[n3 + 1] = (byte)(n2 >>> 16);
                    byArray[n3 + 2] = (byte)(n2 >>> 8);
                    byArray[n3 + 3] = (byte)n2;
                    break;
                }
                case 12: {
                    n2 = FloatSampleTools.quantize32(fArray[n7] * 2.1474836E9f, f2);
                    byArray[n3 + 3] = n2 >> 24;
                    byArray[n3 + 2] = (byte)(n2 >>> 16);
                    byArray[n3 + 1] = (byte)(n2 >>> 8);
                    byArray[n3] = (byte)n2;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unsupported format=" + FloatSampleTools.formatType2Str(n6));
                }
            }
            ++n7;
            n3 += n4;
        }
    }
}

