/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share.midi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Transmitter;
import org.tritonus.share.TDebug;
import org.tritonus.share.midi.TMidiDevice$TReceiver;
import org.tritonus.share.midi.TMidiDevice$TTransmitter;

public abstract class TMidiDevice
implements MidiDevice {
    private MidiDevice.Info m_info;
    private boolean m_bOpen;
    private boolean m_bUseIn;
    private boolean m_bUseOut;
    private List m_receivers;
    private List m_transmitters;

    public TMidiDevice(MidiDevice.Info info) {
        this(info, true, true);
    }

    public TMidiDevice(MidiDevice.Info info, boolean bl, boolean bl2) {
        this.m_info = info;
        this.m_bUseIn = bl;
        this.m_bUseOut = bl2;
        this.m_bOpen = false;
        this.m_receivers = new ArrayList();
        this.m_transmitters = new ArrayList();
    }

    @Override
    public MidiDevice.Info getDeviceInfo() {
        return this.m_info;
    }

    @Override
    public void open() {
        if (TDebug.TraceMidiDevice) {
            TDebug.out("TMidiDevice.open(): begin");
        }
        if (!this.isOpen()) {
            this.m_bOpen = true;
            this.openImpl();
        }
        if (TDebug.TraceMidiDevice) {
            TDebug.out("TMidiDevice.open(): end");
        }
    }

    protected void openImpl() {
        if (TDebug.TraceMidiDevice) {
            TDebug.out("TMidiDevice.openImpl(): begin");
        }
        if (TDebug.TraceMidiDevice) {
            TDebug.out("TMidiDevice.openImpl(): end");
        }
    }

    @Override
    public void close() {
        if (TDebug.TraceMidiDevice) {
            TDebug.out("TMidiDevice.close(): begin");
        }
        if (this.isOpen()) {
            this.closeImpl();
            this.m_bOpen = false;
        }
        if (TDebug.TraceMidiDevice) {
            TDebug.out("TMidiDevice.close(): end");
        }
    }

    protected void closeImpl() {
        if (TDebug.TraceMidiDevice) {
            TDebug.out("TMidiDevice.closeImpl(): begin");
        }
        if (TDebug.TraceMidiDevice) {
            TDebug.out("TMidiDevice.closeImpl(): end");
        }
    }

    @Override
    public boolean isOpen() {
        return this.m_bOpen;
    }

    protected boolean getUseIn() {
        return this.m_bUseIn;
    }

    protected boolean getUseOut() {
        return this.m_bUseOut;
    }

    @Override
    public long getMicrosecondPosition() {
        return -1L;
    }

    @Override
    public int getMaxReceivers() {
        int n2 = 0;
        if (this.getUseOut()) {
            n2 = -1;
        }
        return n2;
    }

    @Override
    public int getMaxTransmitters() {
        int n2 = 0;
        if (this.getUseIn()) {
            n2 = -1;
        }
        return n2;
    }

    @Override
    public Receiver getReceiver() {
        if (!this.getUseOut()) {
            throw new MidiUnavailableException("Receivers are not supported by this device");
        }
        return new TMidiDevice$TReceiver(this);
    }

    @Override
    public Transmitter getTransmitter() {
        if (!this.getUseIn()) {
            throw new MidiUnavailableException("Transmitters are not supported by this device");
        }
        return new TMidiDevice$TTransmitter(this);
    }

    public List getReceivers() {
        return Collections.unmodifiableList(this.m_receivers);
    }

    public List getTransmitters() {
        return Collections.unmodifiableList(this.m_transmitters);
    }

    protected void receive(MidiMessage midiMessage, long l2) {
        if (TDebug.TraceMidiDevice) {
            TDebug.out("### [should be overridden] TMidiDevice.receive(): message " + midiMessage);
        }
    }

    private void addReceiver(Receiver receiver) {
        List list = this.m_receivers;
        synchronized (list) {
            this.m_receivers.add(receiver);
            return;
        }
    }

    private void removeReceiver(Receiver receiver) {
        List list = this.m_receivers;
        synchronized (list) {
            this.m_receivers.remove(receiver);
            return;
        }
    }

    private void addTransmitter(Transmitter transmitter) {
        List list = this.m_transmitters;
        synchronized (list) {
            this.m_transmitters.add(transmitter);
            return;
        }
    }

    private void removeTransmitter(Transmitter transmitter) {
        List list = this.m_transmitters;
        synchronized (list) {
            this.m_transmitters.remove(transmitter);
            return;
        }
    }

    protected void sendImpl(MidiMessage midiMessage, long l2) {
        if (TDebug.TraceMidiDevice) {
            TDebug.out("TMidiDevice.sendImpl(): begin");
        }
        for (TMidiDevice$TTransmitter tMidiDevice$TTransmitter : this.m_transmitters) {
            MidiMessage midiMessage2;
            if (midiMessage instanceof MetaMessage) {
                MetaMessage metaMessage;
                block10: {
                    midiMessage2 = (MetaMessage)midiMessage;
                    metaMessage = new MetaMessage();
                    try {
                        metaMessage.setMessage(((MetaMessage)midiMessage2).getType(), ((MetaMessage)midiMessage2).getData(), ((MetaMessage)midiMessage2).getData().length);
                    }
                    catch (InvalidMidiDataException invalidMidiDataException) {
                        if (!TDebug.TraceAllExceptions) break block10;
                        TDebug.out(invalidMidiDataException);
                    }
                }
                midiMessage2 = metaMessage;
            } else {
                midiMessage2 = (MidiMessage)midiMessage.clone();
            }
            if (midiMessage instanceof MetaMessage) {
                if (TDebug.TraceMidiDevice) {
                    TDebug.out("TMidiDevice.sendImpl(): MetaMessage.getData().length (original): " + ((MetaMessage)midiMessage).getData().length);
                }
                if (TDebug.TraceMidiDevice) {
                    TDebug.out("TMidiDevice.sendImpl(): MetaMessage.getData().length (cloned): " + ((MetaMessage)midiMessage2).getData().length);
                }
            }
            tMidiDevice$TTransmitter.send(midiMessage2, l2);
        }
        if (TDebug.TraceMidiDevice) {
            TDebug.out("TMidiDevice.sendImpl(): end");
        }
    }

    static /* synthetic */ void access$000(TMidiDevice tMidiDevice, Receiver receiver) {
        tMidiDevice.addReceiver(receiver);
    }

    static /* synthetic */ void access$100(TMidiDevice tMidiDevice, Receiver receiver) {
        tMidiDevice.removeReceiver(receiver);
    }

    static /* synthetic */ void access$200(TMidiDevice tMidiDevice, Transmitter transmitter) {
        tMidiDevice.addTransmitter(transmitter);
    }

    static /* synthetic */ void access$300(TMidiDevice tMidiDevice, Transmitter transmitter) {
        tMidiDevice.removeTransmitter(transmitter);
    }
}

