/*
 * Decompiled with CFR 0.152.
 */
package javax.media.opengl;

import com.sun.opengl.impl.Debug;
import com.sun.opengl.impl.GLWorkerThread;
import com.sun.opengl.impl.Java2D;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import javax.media.opengl.GLException;
import javax.media.opengl.Threading$1;

public class Threading {
    private static boolean singleThreaded = true;
    private static final int AWT = 1;
    private static final int WORKER = 2;
    private static int mode;
    private static boolean isX11;
    static Class class$com$sun$opengl$impl$GLWorkerThread;

    private Threading() {
    }

    public static void disableSingleThreading() {
        singleThreaded = false;
        if (Debug.verbose()) {
            System.err.println("Application forced disabling of single-threading of javax.media.opengl implementation");
        }
    }

    public static boolean isSingleThreaded() {
        return singleThreaded;
    }

    public static boolean isOpenGLThread() {
        if (!Threading.isSingleThreaded()) {
            throw new GLException("Should only call this in single-threaded mode");
        }
        switch (mode) {
            case 1: {
                if (Java2D.isOGLPipelineActive()) {
                    return Java2D.isQueueFlusherThread() || isX11 && EventQueue.isDispatchThread();
                }
                return EventQueue.isDispatchThread();
            }
            case 2: {
                if (Java2D.isOGLPipelineActive()) {
                    return Java2D.isQueueFlusherThread() || isX11 && GLWorkerThread.isWorkerThread();
                }
                return GLWorkerThread.isWorkerThread();
            }
        }
        throw new InternalError(new StringBuffer("Illegal single-threading mode ").append(mode).toString());
    }

    public static void invokeOnOpenGLThread(Runnable runnable) {
        if (!Threading.isSingleThreaded()) {
            throw new GLException("Should only call this in single-threaded mode");
        }
        if (Threading.isOpenGLThread()) {
            throw new GLException("Should only call this from other threads than the OpenGL thread");
        }
        switch (mode) {
            case 1: {
                if (Java2D.isOGLPipelineActive() && !isX11) {
                    Java2D.invokeWithOGLContextCurrent(null, runnable);
                    return;
                }
                try {
                    EventQueue.invokeAndWait(runnable);
                    return;
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new GLException(invocationTargetException.getTargetException());
                }
                catch (InterruptedException interruptedException) {
                    throw new GLException(interruptedException);
                }
            }
            case 2: {
                if (!GLWorkerThread.isStarted()) {
                    Class clazz = class$com$sun$opengl$impl$GLWorkerThread == null ? (class$com$sun$opengl$impl$GLWorkerThread = Threading.class$("com.sun.opengl.impl.GLWorkerThread")) : class$com$sun$opengl$impl$GLWorkerThread;
                    synchronized (clazz) {
                        if (!GLWorkerThread.isStarted()) {
                            GLWorkerThread.start();
                        }
                    }
                }
                try {
                    GLWorkerThread.invokeAndWait(runnable);
                    return;
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new GLException(invocationTargetException.getTargetException());
                }
                catch (InterruptedException interruptedException) {
                    throw new GLException(interruptedException);
                }
            }
        }
        throw new InternalError(new StringBuffer("Illegal single-threading mode ").append(mode).toString());
    }

    static boolean isAWTMode() {
        return mode == 1;
    }

    private static void printWorkaroundNotice() {
        if (singleThreaded && Debug.verbose()) {
            System.err.println(new StringBuffer("Using ").append(mode == 1 ? "AWT" : "OpenGL worker").append(" thread for performing OpenGL work in javax.media.opengl implementation").toString());
        }
    }

    static boolean access$002(boolean bl) {
        isX11 = bl;
        return isX11;
    }

    static int access$102(int n2) {
        mode = n2;
        return mode;
    }

    static boolean access$202(boolean bl) {
        singleThreaded = bl;
        return singleThreaded;
    }

    static void access$300() {
        Threading.printWorkaroundNotice();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        AccessController.doPrivileged(new Threading$1());
    }
}

