/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.util.texture.spi;

import com.sun.opengl.util.texture.spi.LEDataInputStream;
import com.sun.opengl.util.texture.spi.TGAImage$Header;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

public class TGAImage {
    private TGAImage$Header header;
    private int format;
    private ByteBuffer data;
    static final boolean $assertionsDisabled = !(class$com$sun$opengl$util$texture$spi$TGAImage == null ? (class$com$sun$opengl$util$texture$spi$TGAImage = TGAImage.class$("com.sun.opengl.util.texture.spi.TGAImage")) : class$com$sun$opengl$util$texture$spi$TGAImage).desiredAssertionStatus();
    static Class class$com$sun$opengl$util$texture$spi$TGAImage;

    private TGAImage(TGAImage$Header tGAImage$Header) {
        this.header = tGAImage$Header;
    }

    private void decodeImage(LEDataInputStream lEDataInputStream) {
        switch (this.header.imageType()) {
            case 1: {
                throw new IOException("TGADecoder Uncompressed Colormapped images not supported");
            }
            case 2: {
                switch (TGAImage$Header.access$000(this.header)) {
                    case 16: {
                        throw new IOException("TGADecoder Compressed 16-bit True Color images not supported");
                    }
                    case 24: 
                    case 32: {
                        this.decodeRGBImageU24_32(lEDataInputStream);
                    }
                }
                return;
            }
            case 3: {
                throw new IOException("TGADecoder Uncompressed Grayscale images not supported");
            }
            case 9: {
                throw new IOException("TGADecoder Compressed Colormapped images not supported");
            }
            case 10: {
                throw new IOException("TGADecoder Compressed True Color images not supported");
            }
            case 11: {
                throw new IOException("TGADecoder Compressed Grayscale images not supported");
            }
        }
    }

    private void decodeRGBImageU24_32(LEDataInputStream lEDataInputStream) {
        int n2 = this.header.width() * (this.header.pixelDepth() / 8);
        byte[] byArray = new byte[n2];
        byte[] byArray2 = new byte[n2 * this.header.height()];
        if (this.header.pixelDepth() == 24) {
            this.format = 32992;
        } else {
            if (!$assertionsDisabled && this.header.pixelDepth() != 32) {
                throw new AssertionError();
            }
            this.format = 32993;
        }
        for (int i2 = 0; i2 < this.header.height(); ++i2) {
            lEDataInputStream.readFully(byArray, 0, n2);
            int n3 = this.header.topToBottom() ? TGAImage$Header.access$100(this.header) - i2 - 1 : i2;
            System.arraycopy(byArray, 0, byArray2, n3 * n2, byArray.length);
        }
        this.data = ByteBuffer.wrap(byArray2);
    }

    public int getWidth() {
        return this.header.width();
    }

    public int getHeight() {
        return this.header.height();
    }

    public int getGLFormat() {
        return this.format;
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public static TGAImage read(String string) {
        return TGAImage.read(new FileInputStream(string));
    }

    public static TGAImage read(InputStream inputStream) {
        inputStream = new LEDataInputStream(new BufferedInputStream(inputStream));
        Object object = new TGAImage$Header((LEDataInputStream)inputStream);
        object = new TGAImage((TGAImage$Header)object);
        ((TGAImage)object).decodeImage((LEDataInputStream)inputStream);
        return object;
    }

    public void write(String string) {
        this.write(new File(string));
    }

    public void write(File object) {
        object = new FileOutputStream((File)object);
        FileChannel fileChannel = ((FileOutputStream)object).getChannel();
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.header.size());
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        TGAImage$Header.access$200(this.header, byteBuffer);
        byteBuffer.rewind();
        fileChannel.write(byteBuffer);
        fileChannel.write(this.data);
        this.data.rewind();
        fileChannel.force(true);
        fileChannel.close();
        ((FileOutputStream)object).close();
    }

    public static TGAImage createFromData(int n2, int n3, boolean bl, boolean bl2, ByteBuffer byteBuffer) {
        TGAImage$Header tGAImage$Header = new TGAImage$Header();
        TGAImage$Header.access$302(tGAImage$Header, 2);
        TGAImage$Header.access$402(tGAImage$Header, n2);
        TGAImage$Header.access$102(tGAImage$Header, n3);
        TGAImage$Header.access$002(tGAImage$Header, (byte)(bl ? 32 : 24));
        TGAImage$Header.access$502(tGAImage$Header, (byte)(bl2 ? 32 : 0));
        TGAImage tGAImage = new TGAImage(tGAImage$Header);
        new TGAImage(tGAImage$Header).data = byteBuffer;
        return tGAImage;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

