/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.util.texture;

import com.sun.opengl.impl.Debug;
import com.sun.opengl.util.FileUtil;
import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureData;
import com.sun.opengl.util.texture.TextureIO$DDSTextureProvider;
import com.sun.opengl.util.texture.TextureIO$DDSTextureWriter;
import com.sun.opengl.util.texture.TextureIO$IIOTextureProvider;
import com.sun.opengl.util.texture.TextureIO$IIOTextureWriter;
import com.sun.opengl.util.texture.TextureIO$SGITextureProvider;
import com.sun.opengl.util.texture.TextureIO$SGITextureWriter;
import com.sun.opengl.util.texture.TextureIO$TGATextureProvider;
import com.sun.opengl.util.texture.TextureIO$TGATextureWriter;
import com.sun.opengl.util.texture.spi.TextureProvider;
import com.sun.opengl.util.texture.spi.TextureWriter;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.media.opengl.GL;
import javax.media.opengl.GLException;
import javax.media.opengl.glu.GLU;

public class TextureIO {
    public static final String DDS = "dds";
    public static final String SGI = "sgi";
    public static final String SGI_RGB = "rgb";
    public static final String GIF = "gif";
    public static final String JPG = "jpg";
    public static final String PNG = "png";
    public static final String TGA = "tga";
    public static final String TIFF = "tiff";
    private static final boolean DEBUG = Debug.debug("TextureIO");
    private static boolean texRectEnabled = true;
    private static List textureProviders = new ArrayList();
    private static List textureWriters = new ArrayList();

    public static TextureData newTextureData(File file, boolean bl, String string) {
        if (string == null) {
            string = FileUtil.getFileSuffix(file);
        }
        return TextureIO.newTextureDataImpl(file, 0, 0, bl, string);
    }

    public static TextureData newTextureData(InputStream inputStream, boolean bl, String string) {
        return TextureIO.newTextureDataImpl(inputStream, 0, 0, bl, string);
    }

    public static TextureData newTextureData(URL uRL, boolean bl, String string) {
        if (string == null) {
            string = FileUtil.getFileSuffix(uRL.getPath());
        }
        return TextureIO.newTextureDataImpl(uRL, 0, 0, bl, string);
    }

    public static TextureData newTextureData(BufferedImage bufferedImage, boolean bl) {
        return TextureIO.newTextureDataImpl(bufferedImage, 0, 0, bl);
    }

    public static TextureData newTextureData(File file, int n2, int n3, boolean bl, String string) {
        if (n2 == 0 || n3 == 0) {
            throw new IllegalArgumentException("internalFormat and pixelFormat must be non-zero");
        }
        if (string == null) {
            string = FileUtil.getFileSuffix(file);
        }
        return TextureIO.newTextureDataImpl(file, n2, n3, bl, string);
    }

    public static TextureData newTextureData(InputStream inputStream, int n2, int n3, boolean bl, String string) {
        if (n2 == 0 || n3 == 0) {
            throw new IllegalArgumentException("internalFormat and pixelFormat must be non-zero");
        }
        return TextureIO.newTextureDataImpl(inputStream, n2, n3, bl, string);
    }

    public static TextureData newTextureData(URL uRL, int n2, int n3, boolean bl, String string) {
        if (n2 == 0 || n3 == 0) {
            throw new IllegalArgumentException("internalFormat and pixelFormat must be non-zero");
        }
        if (string == null) {
            string = FileUtil.getFileSuffix(uRL.getPath());
        }
        return TextureIO.newTextureDataImpl(uRL, n2, n3, bl, string);
    }

    public static TextureData newTextureData(BufferedImage bufferedImage, int n2, int n3, boolean bl) {
        if (n2 == 0 || n3 == 0) {
            throw new IllegalArgumentException("internalFormat and pixelFormat must be non-zero");
        }
        return TextureIO.newTextureDataImpl(bufferedImage, n2, n3, bl);
    }

    public static Texture newTexture(TextureData textureData) {
        if (textureData == null) {
            throw new IllegalArgumentException("Null TextureData");
        }
        return new Texture(textureData);
    }

    public static Texture newTexture(File object, boolean bl) {
        object = TextureIO.newTextureData((File)object, bl, FileUtil.getFileSuffix((File)object));
        Texture texture = TextureIO.newTexture((TextureData)object);
        ((TextureData)object).flush();
        return texture;
    }

    public static Texture newTexture(InputStream object, boolean bl, String string) {
        object = TextureIO.newTextureData((InputStream)object, bl, string);
        Texture texture = TextureIO.newTexture((TextureData)object);
        ((TextureData)object).flush();
        return texture;
    }

    public static Texture newTexture(URL object, boolean bl, String string) {
        if (string == null) {
            string = FileUtil.getFileSuffix(((URL)object).getPath());
        }
        object = TextureIO.newTextureData((URL)object, bl, string);
        Texture texture = TextureIO.newTexture((TextureData)object);
        ((TextureData)object).flush();
        return texture;
    }

    public static Texture newTexture(BufferedImage object, boolean bl) {
        object = TextureIO.newTextureData((BufferedImage)object, bl);
        Texture texture = TextureIO.newTexture((TextureData)object);
        ((TextureData)object).flush();
        return texture;
    }

    public static Texture newTexture(int n2) {
        return new Texture(n2);
    }

    public static void write(Texture texture, File file) {
        Object object;
        TextureData textureData;
        if (texture.getTarget() != 3553) {
            throw new GLException("Only GL_TEXTURE_2D textures are supported");
        }
        GL gL = GLU.getCurrentGL();
        texture.bind();
        int n2 = TextureIO.glGetTexLevelParameteri(3553, 0, 4099);
        int n3 = TextureIO.glGetTexLevelParameteri(3553, 0, 4096);
        int n4 = TextureIO.glGetTexLevelParameteri(3553, 0, 4097);
        int n5 = TextureIO.glGetTexLevelParameteri(3553, 0, 4101);
        if (n2 == 33776 || n2 == 33777 || n2 == 33778 || n2 == 33779) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(TextureIO.glGetTexLevelParameteri(3553, 0, 34464));
            gL.glGetCompressedTexImage(3553, 0, byteBuffer);
            textureData = new TextureData(n2, n3, n4, n5, n2, 5121, false, true, true, byteBuffer, null);
        } else {
            int n6;
            int n7;
            switch (n2) {
                case 6407: 
                case 32849: 
                case 32992: {
                    n7 = 3;
                    n6 = 6407;
                    break;
                }
                case 6408: 
                case 32768: 
                case 32856: 
                case 32993: {
                    n7 = 4;
                    n6 = 6408;
                    break;
                }
                default: {
                    throw new IOException("Unsupported texture internal format 0x" + Integer.toHexString(n2));
                }
            }
            int n8 = TextureIO.glGetInteger(3333);
            int n9 = TextureIO.glGetInteger(3330);
            int n10 = TextureIO.glGetInteger(3331);
            int n11 = TextureIO.glGetInteger(3332);
            int n12 = TextureIO.glGetInteger(3328);
            gL.glPixelStorei(3333, 1);
            gL.glPixelStorei(3330, 0);
            gL.glPixelStorei(3331, 0);
            gL.glPixelStorei(3332, 0);
            gL.glPixelStorei(3328, 0);
            object = ByteBuffer.allocate((n3 + 2 * n5) * (n4 + 2 * n5) * n7);
            if (DEBUG) {
                System.out.println("Allocated buffer of size " + ((Buffer)object).remaining() + " for fetched image (" + (n6 == 6407 ? "GL_RGB" : "GL_RGBA") + ")");
            }
            gL.glGetTexImage(3553, 0, n6, 5121, (Buffer)object);
            gL.glPixelStorei(3333, n8);
            gL.glPixelStorei(3330, n9);
            gL.glPixelStorei(3331, n10);
            gL.glPixelStorei(3332, n11);
            gL.glPixelStorei(3328, n12);
            textureData = new TextureData(n2, n3, n4, n5, n6, 5121, false, false, false, (Buffer)object, null);
            if (DEBUG) {
                System.out.println("data.getPixelFormat() = " + (textureData.getPixelFormat() == 6407 ? "GL_RGB" : "GL_RGBA"));
            }
        }
        object = textureWriters.iterator();
        while (object.hasNext()) {
            if (!((TextureWriter)object.next()).write(file, textureData)) continue;
            return;
        }
        throw new IOException("No suitable texture writer found");
    }

    public static void addTextureProvider(TextureProvider textureProvider) {
        textureProviders.add(0, textureProvider);
    }

    public static void addTextureWriter(TextureWriter textureWriter) {
        textureWriters.add(0, textureWriter);
    }

    public static void setTexRectEnabled(boolean bl) {
        texRectEnabled = bl;
    }

    public static boolean isTexRectEnabled() {
        return texRectEnabled;
    }

    private static TextureData newTextureDataImpl(File file, int n2, int n3, boolean bl, String string) {
        if (file == null) {
            throw new IOException("File was null");
        }
        string = TextureIO.toLowerCase(string);
        Iterator iterator = textureProviders.iterator();
        while (iterator.hasNext()) {
            TextureData textureData = ((TextureProvider)iterator.next()).newTextureData(file, n2, n3, bl, string);
            if (textureData == null) continue;
            return textureData;
        }
        throw new IOException("No suitable reader for given file");
    }

    private static TextureData newTextureDataImpl(InputStream inputStream, int n2, int n3, boolean bl, String string) {
        if (inputStream == null) {
            throw new IOException("Stream was null");
        }
        string = TextureIO.toLowerCase(string);
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        Iterator iterator = textureProviders.iterator();
        while (iterator.hasNext()) {
            TextureData textureData = ((TextureProvider)iterator.next()).newTextureData(inputStream, n2, n3, bl, string);
            if (textureData == null) continue;
            return textureData;
        }
        throw new IOException("No suitable reader for given stream");
    }

    private static TextureData newTextureDataImpl(URL uRL, int n2, int n3, boolean bl, String string) {
        if (uRL == null) {
            throw new IOException("URL was null");
        }
        string = TextureIO.toLowerCase(string);
        Iterator iterator = textureProviders.iterator();
        while (iterator.hasNext()) {
            TextureData textureData = ((TextureProvider)iterator.next()).newTextureData(uRL, n2, n3, bl, string);
            if (textureData == null) continue;
            return textureData;
        }
        throw new IOException("No suitable reader for given URL");
    }

    private static TextureData newTextureDataImpl(BufferedImage bufferedImage, int n2, int n3, boolean bl) {
        return new TextureData(n2, n3, bl, bufferedImage);
    }

    private static int glGetInteger(int n2) {
        int[] nArray = new int[1];
        GLU.getCurrentGL().glGetIntegerv(n2, nArray, 0);
        return nArray[0];
    }

    private static int glGetTexLevelParameteri(int n2, int n3, int n4) {
        int[] nArray = new int[1];
        GLU.getCurrentGL().glGetTexLevelParameteriv(n2, 0, n4, nArray, 0);
        return nArray[0];
    }

    private static String toLowerCase(String string) {
        if (string == null) {
            return null;
        }
        return string.toLowerCase();
    }

    static /* synthetic */ boolean access$000() {
        return DEBUG;
    }

    static {
        TextureIO.addTextureProvider(new TextureIO$IIOTextureProvider());
        TextureIO.addTextureProvider(new TextureIO$DDSTextureProvider());
        TextureIO.addTextureProvider(new TextureIO$SGITextureProvider());
        TextureIO.addTextureProvider(new TextureIO$TGATextureProvider());
        textureWriters.add(new TextureIO$IIOTextureWriter());
        TextureIO.addTextureWriter(new TextureIO$DDSTextureWriter());
        TextureIO.addTextureWriter(new TextureIO$SGITextureWriter());
        TextureIO.addTextureWriter(new TextureIO$TGATextureWriter());
    }
}

