/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.util.texture;

import com.sun.opengl.util.FileUtil;
import com.sun.opengl.util.texture.TextureData;
import com.sun.opengl.util.texture.spi.TGAImage;
import com.sun.opengl.util.texture.spi.TextureWriter;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;

class TextureIO$TGATextureWriter
implements TextureWriter {
    TextureIO$TGATextureWriter() {
    }

    @Override
    public boolean write(File file, TextureData textureData) {
        if ("tga".equals(FileUtil.getFileSuffix(file))) {
            int n2 = textureData.getPixelFormat();
            int n3 = textureData.getPixelType();
            if (!(n2 != 6407 && n2 != 6408 || n3 != 5120 && n3 != 5121)) {
                ByteBuffer byteBuffer = textureData.getBuffer() != null ? (ByteBuffer)textureData.getBuffer() : (ByteBuffer)textureData.getMipmapData()[0];
                int n4 = n2 == 6407 ? 3 : 4;
                for (int i2 = 0; i2 < byteBuffer.remaining(); i2 += n4) {
                    byte by = byteBuffer.get(i2);
                    byte by2 = byteBuffer.get(i2 + 2);
                    byteBuffer.put(i2, by2);
                    byteBuffer.put(i2 + 2, by);
                }
                TGAImage.createFromData(textureData.getWidth(), textureData.getHeight(), n2 == 6408, false, textureData.getBuffer() != null ? (ByteBuffer)textureData.getBuffer() : (ByteBuffer)textureData.getMipmapData()[0]).write(file);
                return true;
            }
            throw new IOException("TGA writer doesn't support this pixel format / type (only GL_RGB/A + bytes)");
        }
        return false;
    }
}

