/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.util.texture;

import com.sun.opengl.impl.Debug;
import com.sun.opengl.util.texture.TextureCoords;
import com.sun.opengl.util.texture.TextureData;
import com.sun.opengl.util.texture.TextureIO;
import com.sun.opengl.util.texture.spi.DDSImage;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GLException;
import javax.media.opengl.glu.GLU;

public class Texture {
    private int target;
    private int texID;
    private int texWidth;
    private int texHeight;
    private int imgWidth;
    private int imgHeight;
    private float aspectRatio;
    private boolean mustFlipVertically;
    private boolean usingAutoMipmapGeneration;
    private TextureCoords coords;
    private int estimatedMemorySize;
    private static final boolean DEBUG = Debug.debug("Texture");
    private static final boolean VERBOSE = Debug.verbose();
    private static final boolean disableNPOT = Debug.isPropertyDefined("jogl.texture.nonpot");
    private static final boolean disableTexRect = Debug.isPropertyDefined("jogl.texture.notexrect");

    Texture(TextureData textureData) {
        GL gL = GLU.getCurrentGL();
        this.texID = Texture.createTextureID(gL);
        this.updateImage(textureData);
    }

    Texture(int n2) {
        GL gL = GLU.getCurrentGL();
        this.texID = Texture.createTextureID(gL);
        this.target = n2;
    }

    public void enable() {
        GLU.getCurrentGL().glEnable(this.target);
    }

    public void disable() {
        GLU.getCurrentGL().glDisable(this.target);
    }

    public void bind() {
        GLU.getCurrentGL().glBindTexture(this.target, this.texID);
    }

    public void dispose() {
        GLU.getCurrentGL().glDeleteTextures(1, new int[]{this.texID}, 0);
        this.texID = 0;
    }

    public int getTarget() {
        return this.target;
    }

    public int getWidth() {
        return this.texWidth;
    }

    public int getHeight() {
        return this.texHeight;
    }

    public int getImageWidth() {
        return this.imgWidth;
    }

    public int getImageHeight() {
        return this.imgHeight;
    }

    public float getAspectRatio() {
        return this.aspectRatio;
    }

    public TextureCoords getImageTexCoords() {
        return this.coords;
    }

    public TextureCoords getSubImageTexCoords(int n2, int n3, int n4, int n5) {
        if (this.target == 34037) {
            if (this.mustFlipVertically) {
                return new TextureCoords(n2, this.texHeight - n3, n4, this.texHeight - n5);
            }
            return new TextureCoords(n2, n3, n4, n5);
        }
        float f2 = (float)n2 / (float)this.texWidth;
        float f3 = (float)n3 / (float)this.texHeight;
        float f4 = (float)n4 / (float)this.texWidth;
        float f5 = (float)n5 / (float)this.texHeight;
        if (this.mustFlipVertically) {
            float f6 = (float)this.imgHeight / (float)this.texHeight;
            return new TextureCoords(f2, f6 - f3, f4, f6 - f5);
        }
        return new TextureCoords(f2, f3, f4, f5);
    }

    public void updateImage(TextureData textureData) {
        this.updateImage(textureData, 0);
    }

    public boolean getMustFlipVertically() {
        return this.mustFlipVertically;
    }

    public void updateImage(TextureData textureData, int n2) {
        Object[] objectArray;
        int n3;
        GL gL = GLU.getCurrentGL();
        this.imgWidth = textureData.getWidth();
        this.imgHeight = textureData.getHeight();
        this.aspectRatio = (float)this.imgWidth / (float)this.imgHeight;
        this.mustFlipVertically = textureData.getMustFlipVertically();
        int n4 = gL.isExtensionAvailable("GL_VERSION_1_4") || gL.isExtensionAvailable("GL_SGIS_generate_mipmap") ? 1 : 0;
        textureData.setHaveEXTABGR(gL.isExtensionAvailable("GL_EXT_abgr"));
        textureData.setHaveGL12(gL.isExtensionAvailable("GL_VERSION_1_2"));
        if (!(Texture.isPowerOfTwo(this.imgWidth) && Texture.isPowerOfTwo(this.imgHeight) || Texture.haveNPOT(gL))) {
            n4 = 0;
        }
        int n5 = 0;
        if (textureData.getMipmap() && n4 == 0) {
            this.imgWidth = Texture.nextPowerOfTwo(this.imgWidth);
            this.imgHeight = Texture.nextPowerOfTwo(this.imgHeight);
            this.texWidth = this.imgWidth;
            this.texHeight = this.imgHeight;
            n3 = 3553;
        } else if (Texture.isPowerOfTwo(this.imgWidth) && Texture.isPowerOfTwo(this.imgHeight) || Texture.haveNPOT(gL)) {
            if (DEBUG) {
                if (Texture.isPowerOfTwo(this.imgWidth) && Texture.isPowerOfTwo(this.imgHeight)) {
                    System.err.println("Power-of-two texture");
                } else {
                    System.err.println("Using GL_ARB_texture_non_power_of_two");
                }
            }
            this.texWidth = this.imgWidth;
            this.texHeight = this.imgHeight;
            n3 = 3553;
        } else if (Texture.haveTexRect(gL) && !textureData.isDataCompressed()) {
            if (DEBUG) {
                System.err.println("Using GL_ARB_texture_rectangle");
            }
            this.texWidth = this.imgWidth;
            this.texHeight = this.imgHeight;
            n3 = 34037;
        } else {
            if (textureData.isDataCompressed()) {
                if (textureData.getMipmapData() != null) {
                    throw new GLException("Mipmapped non-power-of-two compressed textures only supported on OpenGL 2.0 hardware (GL_ARB_texture_non_power_of_two)");
                }
                n5 = 1;
            }
            if (DEBUG) {
                System.err.println("Expanding texture to power-of-two dimensions");
            }
            if (textureData.getBorder() != 0) {
                throw new RuntimeException("Scaling up a non-power-of-two texture which has a border won't work");
            }
            this.texWidth = Texture.nextPowerOfTwo(this.imgWidth);
            this.texHeight = Texture.nextPowerOfTwo(this.imgHeight);
            n3 = 3553;
        }
        int n6 = n3;
        this.setImageSize(this.imgWidth, this.imgHeight, n3);
        if (n2 != 0) {
            n3 = n2;
            if (this.target == 0) {
                throw new GLException("Override of target failed; no target specified yet");
            }
            n6 = this.target;
            gL.glBindTexture(n6, this.texID);
        } else {
            gL.glBindTexture(n3, this.texID);
        }
        if (textureData.getMipmap() && n4 == 0) {
            objectArray = new int[1];
            gL.glGetIntegerv(3317, (int[])objectArray, 0);
            gL.glPixelStorei(3317, textureData.getAlignment());
            if (textureData.isDataCompressed()) {
                throw new GLException("May not request mipmap generation for compressed textures");
            }
            try {
                new GLU().gluBuild2DMipmaps(n3, textureData.getInternalFormat(), textureData.getWidth(), textureData.getHeight(), textureData.getPixelFormat(), textureData.getPixelType(), textureData.getBuffer());
            }
            finally {
                gL.glPixelStorei(3317, objectArray[0]);
            }
        } else {
            this.checkCompressedTextureExtensions(textureData);
            Buffer[] bufferArray = textureData.getMipmapData();
            objectArray = bufferArray;
            if (bufferArray != null) {
                n4 = this.texWidth;
                n5 = this.texHeight;
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    if (textureData.isDataCompressed()) {
                        gL.glCompressedTexImage2D(n3, i2, textureData.getInternalFormat(), n4, n5, textureData.getBorder(), objectArray[i2].remaining(), (Buffer)objectArray[i2]);
                    } else {
                        gL.glTexImage2D(n3, i2, textureData.getInternalFormat(), n4, n5, textureData.getBorder(), textureData.getPixelFormat(), textureData.getPixelType(), null);
                        this.updateSubImageImpl(textureData, n3, i2, 0, 0, 0, 0, textureData.getWidth(), textureData.getHeight());
                    }
                    n4 = Math.max(n4 / 2, 1);
                    n5 = Math.max(n5 / 2, 1);
                }
            } else if (textureData.isDataCompressed()) {
                if (n5 == 0) {
                    gL.glCompressedTexImage2D(n3, 0, textureData.getInternalFormat(), this.texWidth, this.texHeight, textureData.getBorder(), textureData.getBuffer().capacity(), textureData.getBuffer());
                } else {
                    ByteBuffer byteBuffer = DDSImage.allocateBlankBuffer(this.texWidth, this.texHeight, textureData.getInternalFormat());
                    gL.glCompressedTexImage2D(n3, 0, textureData.getInternalFormat(), this.texWidth, this.texHeight, textureData.getBorder(), byteBuffer.capacity(), byteBuffer);
                    this.updateSubImageImpl(textureData, n3, 0, 0, 0, 0, 0, textureData.getWidth(), textureData.getHeight());
                }
            } else {
                if (textureData.getMipmap() && n4 != 0) {
                    gL.glTexParameteri(n6, 33169, 1);
                    this.usingAutoMipmapGeneration = true;
                }
                gL.glTexImage2D(n3, 0, textureData.getInternalFormat(), this.texWidth, this.texHeight, textureData.getBorder(), textureData.getPixelFormat(), textureData.getPixelType(), null);
                this.updateSubImageImpl(textureData, n3, 0, 0, 0, 0, 0, textureData.getWidth(), textureData.getHeight());
            }
        }
        int n7 = textureData.getMipmap() ? 9987 : 9729;
        int n8 = n5 = gL.isExtensionAvailable("GL_VERSION_1_2") ? 33071 : 10496;
        if (n3 != 34037) {
            gL.glTexParameteri(n6, 10241, n7);
            gL.glTexParameteri(n6, 10240, 9729);
            gL.glTexParameteri(n6, 10242, n5);
            gL.glTexParameteri(n6, 10243, n5);
            if (this.target == 34067) {
                gL.glTexParameteri(n6, 32882, n5);
            }
        }
        if (this.target == 0 || this.target == 3553 || this.target == 34037) {
            this.target = n3;
        }
        this.estimatedMemorySize = textureData.getEstimatedMemorySize();
    }

    public void updateSubImage(TextureData textureData, int n2, int n3, int n4) {
        if (this.usingAutoMipmapGeneration && n2 != 0) {
            return;
        }
        this.bind();
        this.updateSubImageImpl(textureData, this.target, n2, n3, n4, 0, 0, textureData.getWidth(), textureData.getHeight());
    }

    public void updateSubImage(TextureData textureData, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (textureData.isDataCompressed()) {
            throw new GLException("updateSubImage specifying a sub-rectangle is not supported for compressed TextureData");
        }
        if (this.usingAutoMipmapGeneration && n2 != 0) {
            return;
        }
        this.bind();
        this.updateSubImageImpl(textureData, this.target, n2, n3, n4, n5, n6, n7, n8);
    }

    public void setTexParameterf(int n2, float f2) {
        this.bind();
        GLU.getCurrentGL().glTexParameterf(this.target, n2, f2);
    }

    public void setTexParameterfv(int n2, FloatBuffer floatBuffer) {
        this.bind();
        GLU.getCurrentGL().glTexParameterfv(this.target, n2, floatBuffer);
    }

    public void setTexParameterfv(int n2, float[] fArray, int n3) {
        this.bind();
        GLU.getCurrentGL().glTexParameterfv(this.target, n2, fArray, n3);
    }

    public void setTexParameteri(int n2, int n3) {
        this.bind();
        GLU.getCurrentGL().glTexParameteri(this.target, n2, n3);
    }

    public void setTexParameteriv(int n2, IntBuffer intBuffer) {
        this.bind();
        GLU.getCurrentGL().glTexParameteriv(this.target, n2, intBuffer);
    }

    public void setTexParameteriv(int n2, int[] nArray, int n3) {
        this.bind();
        GLU.getCurrentGL().glTexParameteriv(this.target, n2, nArray, n3);
    }

    public int getTextureObject() {
        return this.texID;
    }

    public int getEstimatedMemorySize() {
        return this.estimatedMemorySize;
    }

    public boolean isUsingAutoMipmapGeneration() {
        return this.usingAutoMipmapGeneration;
    }

    private static boolean isPowerOfTwo(int n2) {
        return (n2 & n2 - 1) == 0;
    }

    private static int nextPowerOfTwo(int n2) {
        int n3;
        for (n3 = 1; n3 < n2; n3 <<= 1) {
        }
        return n3;
    }

    private void setImageSize(int n2, int n3, int n4) {
        this.imgWidth = n2;
        this.imgHeight = n3;
        if (n4 == 34037) {
            if (this.mustFlipVertically) {
                this.coords = new TextureCoords(0.0f, this.imgHeight, this.imgWidth, 0.0f);
                return;
            }
            this.coords = new TextureCoords(0.0f, 0.0f, this.imgWidth, this.imgHeight);
            return;
        }
        if (this.mustFlipVertically) {
            this.coords = new TextureCoords(0.0f, (float)this.imgHeight / (float)this.texHeight, (float)this.imgWidth / (float)this.texWidth, 0.0f);
            return;
        }
        this.coords = new TextureCoords(0.0f, 0.0f, (float)this.imgWidth / (float)this.texWidth, (float)this.imgHeight / (float)this.texHeight);
    }

    private void updateSubImageImpl(TextureData textureData, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        GL gL = GLU.getCurrentGL();
        textureData.setHaveEXTABGR(gL.isExtensionAvailable("GL_EXT_abgr"));
        textureData.setHaveGL12(gL.isExtensionAvailable("GL_VERSION_1_2"));
        Buffer buffer = textureData.getBuffer();
        if (buffer == null && textureData.getMipmapData() == null) {
            return;
        }
        int n10 = textureData.getRowLength();
        int n11 = textureData.getWidth();
        int n12 = textureData.getHeight();
        if (textureData.getMipmapData() != null) {
            for (int i2 = 0; i2 < n3; ++i2) {
                n8 = Math.max(n8 / 2, 1);
                n9 = Math.max(n9 / 2, 1);
                n11 = Math.max(n11 / 2, 1);
                n12 = Math.max(n12 / 2, 1);
            }
            n10 = 0;
            buffer = textureData.getMipmapData()[n3];
        }
        if (n6 < 0) {
            n8 += n6;
            n6 = 0;
        }
        if (n7 < 0) {
            n9 += n7;
            n7 = 0;
        }
        if (n4 < 0) {
            n8 += n4;
            n4 = 0;
        }
        if (n5 < 0) {
            n9 += n5;
            n5 = 0;
        }
        if (n6 + n8 > n11) {
            n8 = n11 - n6;
        }
        if (n7 + n9 > n12) {
            n9 = n12 - n7;
        }
        if (n4 + n8 > this.texWidth) {
            n8 = this.texWidth - n4;
        }
        if (n5 + n9 > this.texHeight) {
            n9 = this.texHeight - n5;
        }
        this.checkCompressedTextureExtensions(textureData);
        if (textureData.isDataCompressed()) {
            gL.glCompressedTexSubImage2D(n2, n3, n4, n5, n8, n9, textureData.getInternalFormat(), buffer.remaining(), buffer);
            return;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        gL.glGetIntegerv(3317, nArray, 0);
        gL.glGetIntegerv(3314, nArray2, 0);
        gL.glGetIntegerv(3315, nArray3, 0);
        gL.glGetIntegerv(3316, nArray4, 0);
        gL.glPixelStorei(3317, textureData.getAlignment());
        if (DEBUG && VERBOSE) {
            System.out.println("Row length  = " + n10);
            System.out.println("skip pixels = " + n6);
            System.out.println("skip rows   = " + n7);
            System.out.println("dstx        = " + n4);
            System.out.println("dsty        = " + n5);
            System.out.println("width       = " + n8);
            System.out.println("height      = " + n9);
        }
        gL.glPixelStorei(3314, n10);
        gL.glPixelStorei(3315, n7);
        gL.glPixelStorei(3316, n6);
        gL.glTexSubImage2D(n2, n3, n4, n5, n8, n9, textureData.getPixelFormat(), textureData.getPixelType(), buffer);
        gL.glPixelStorei(3317, nArray[0]);
        gL.glPixelStorei(3314, nArray2[0]);
        gL.glPixelStorei(3315, nArray3[0]);
        gL.glPixelStorei(3316, nArray4[0]);
    }

    private void checkCompressedTextureExtensions(TextureData textureData) {
        GL gL = GLU.getCurrentGL();
        if (textureData.isDataCompressed()) {
            switch (textureData.getInternalFormat()) {
                case 33776: 
                case 33777: 
                case 33778: 
                case 33779: {
                    if (gL.isExtensionAvailable("GL_EXT_texture_compression_s3tc") || gL.isExtensionAvailable("GL_NV_texture_compression_vtc")) break;
                    throw new GLException("DXTn compressed textures not supported by this graphics card");
                }
            }
        }
    }

    private static int createTextureID(GL gL) {
        int[] nArray = new int[1];
        gL.glGenTextures(1, nArray, 0);
        return nArray[0];
    }

    private static boolean haveNPOT(GL gL) {
        return !disableNPOT && gL.isExtensionAvailable("GL_ARB_texture_non_power_of_two");
    }

    private static boolean haveTexRect(GL gL) {
        return !disableTexRect && TextureIO.isTexRectEnabled() && gL.isExtensionAvailable("GL_ARB_texture_rectangle");
    }
}

