/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.util.j2d;

import com.sun.opengl.util.j2d.TextureRenderer;
import java.awt.Graphics2D;
import javax.media.opengl.GLDrawable;

public class Overlay {
    private GLDrawable drawable;
    private TextureRenderer renderer;
    private boolean contentsLost;

    public Overlay(GLDrawable gLDrawable) {
        this.drawable = gLDrawable;
    }

    public Graphics2D createGraphics() {
        this.validateRenderer();
        return this.renderer.createGraphics();
    }

    public boolean contentsLost() {
        return this.contentsLost;
    }

    public void markDirty(int n2, int n3, int n4, int n5) {
        this.renderer.markDirty(n2, n3, n4, n5);
    }

    public void drawAll() {
        this.beginRendering();
        this.draw(0, 0, this.drawable.getWidth(), this.drawable.getHeight());
        this.endRendering();
    }

    public void beginRendering() {
        this.renderer.beginOrthoRendering(this.drawable.getWidth(), this.drawable.getHeight());
    }

    public void endRendering() {
        this.renderer.endOrthoRendering();
    }

    public void draw(int n2, int n3, int n4, int n5) {
        this.draw(n2, n3, n2, n3, n4, n5);
    }

    public void draw(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.renderer.drawOrthoRect(n2, n3, n4, n5, n6, n7);
    }

    private void validateRenderer() {
        if (this.renderer == null) {
            this.renderer = new TextureRenderer(this.drawable.getWidth(), this.drawable.getHeight(), true);
            this.contentsLost = true;
            return;
        }
        if (this.renderer.getWidth() != this.drawable.getWidth() || this.renderer.getHeight() != this.drawable.getHeight()) {
            this.renderer.setSize(this.drawable.getWidth(), this.drawable.getHeight());
            this.contentsLost = true;
            return;
        }
        this.contentsLost = false;
    }
}

