/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.x11;

import com.sun.opengl.impl.Debug;
import com.sun.opengl.impl.GLDrawableImpl;
import com.sun.opengl.impl.x11.GLX;
import com.sun.opengl.impl.x11.X11GLDrawableFactory;
import com.sun.opengl.impl.x11.XVisualInfo;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLException;

public abstract class X11GLDrawable
extends GLDrawableImpl {
    protected static final boolean DEBUG = Debug.debug("X11GLDrawable");
    protected long display;
    protected long drawable;
    protected long visualID;
    protected GLCapabilities capabilities;
    protected GLCapabilitiesChooser chooser;

    public X11GLDrawable(GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser) {
        this.capabilities = gLCapabilities == null ? null : (GLCapabilities)gLCapabilities.clone();
        this.chooser = gLCapabilitiesChooser;
    }

    @Override
    public void setRealized(boolean bl) {
        throw new GLException("Should not call this (should only be called for onscreen GLDrawables)");
    }

    @Override
    public void destroy() {
        throw new GLException("Should not call this (should only be called for offscreen GLDrawables)");
    }

    @Override
    public void swapBuffers() {
    }

    public long getDisplay() {
        return this.display;
    }

    public long getDrawable() {
        return this.drawable;
    }

    protected XVisualInfo chooseVisual(boolean bl) {
        int n2;
        if (this.display == 0L) {
            throw new GLException("null display");
        }
        if (bl) {
            Object[] objectArray = new int[1];
            XVisualInfo xVisualInfo = XVisualInfo.create();
            xVisualInfo.visualid((int)this.visualID);
            this.lockToolkit();
            objectArray = GLX.XGetVisualInfo(this.display, 1L, xVisualInfo, objectArray, 0);
            this.unlockToolkit();
            if (objectArray == null || objectArray.length == 0) {
                throw new GLException("Error while getting XVisualInfo for visual ID " + this.visualID);
            }
            if (DEBUG) {
                System.err.println("!!! Fetched XVisualInfo for visual ID 0x" + Long.toHexString(this.visualID));
                System.err.println("!!! Resulting XVisualInfo: visualid = 0x" + Long.toHexString(objectArray[0].visualid()));
            }
            return objectArray[0];
        }
        Object[] objectArray = new int[1];
        Object object = XVisualInfo.create();
        object.screen(0);
        this.lockToolkit();
        try {
            XVisualInfo[] xVisualInfoArray = GLX.XGetVisualInfo(this.display, 2L, (XVisualInfo)object, objectArray, 0);
            objectArray = xVisualInfoArray;
            if (xVisualInfoArray == null) {
                throw new GLException("Error while enumerating available XVisualInfos");
            }
            object = new GLCapabilities[objectArray.length];
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                object[n2] = X11GLDrawableFactory.xvi2GLCapabilities(this.display, (XVisualInfo)objectArray[n2]);
            }
        }
        finally {
            this.unlockToolkit();
        }
        n2 = this.chooser.chooseCapabilities(this.capabilities, (GLCapabilities[])object, -1);
        if (n2 < 0 || n2 >= ((GLCapabilities[])object).length) {
            throw new GLException("GLCapabilitiesChooser specified invalid index (expected 0.." + (((GLCapabilities[])object).length - 1) + ")");
        }
        if (DEBUG) {
            System.err.println("Chosen visual (" + n2 + "):");
            System.err.println(object[n2]);
        }
        int n3 = objectArray[n2];
        object = n3;
        if (n3 == null) {
            throw new GLException("GLCapabilitiesChooser chose an invalid visual");
        }
        return object;
    }

    protected void lockToolkit() {
        X11GLDrawableFactory.getX11Factory().lockToolkit();
    }

    protected void unlockToolkit() {
        X11GLDrawableFactory.getX11Factory().unlockToolkit();
    }
}

