/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.x11;

import com.sun.opengl.impl.FunctionAvailabilityCache;
import com.sun.opengl.impl.GLContextImpl;
import com.sun.opengl.impl.GLContextShareSet;
import com.sun.opengl.impl.GLDrawableFactoryImpl;
import com.sun.opengl.impl.x11.GLX;
import com.sun.opengl.impl.x11.GLXExt;
import com.sun.opengl.impl.x11.GLXExtImpl;
import com.sun.opengl.impl.x11.GLXExtProcAddressTable;
import com.sun.opengl.impl.x11.X11GLDrawable;
import com.sun.opengl.impl.x11.X11GLDrawableFactory;
import com.sun.opengl.impl.x11.XVisualInfo;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;

public abstract class X11GLContext
extends GLContextImpl {
    protected X11GLDrawable drawable;
    protected long context;
    private boolean glXQueryExtensionsStringInitialized;
    private boolean glXQueryExtensionsStringAvailable;
    private static final Map functionNameMap = new HashMap<String, String>();
    private GLXExt glXExt;
    private GLXExtProcAddressTable glXExtProcAddressTable;
    protected long mostRecentDisplay;

    public X11GLContext(X11GLDrawable x11GLDrawable, GLContext gLContext) {
        super(gLContext);
        this.drawable = x11GLDrawable;
    }

    @Override
    public Object getPlatformGLExtensions() {
        return this.getGLXExt();
    }

    public GLXExt getGLXExt() {
        if (this.glXExt == null) {
            this.glXExt = new GLXExtImpl(this);
        }
        return this.glXExt;
    }

    @Override
    public GLDrawable getGLDrawable() {
        return this.drawable;
    }

    @Override
    protected String mapToRealGLFunctionName(String string) {
        String string2 = (String)functionNameMap.get(string);
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    @Override
    protected String mapToRealGLExtensionName(String string) {
        return string;
    }

    protected abstract void create();

    protected void createContext(boolean bl) {
        XVisualInfo xVisualInfo = this.drawable.chooseVisual(bl);
        X11GLContext x11GLContext = (X11GLContext)GLContextShareSet.getShareContext(this);
        long l2 = 0L;
        if (x11GLContext != null && (l2 = x11GLContext.getContext()) == 0L) {
            throw new GLException("GLContextShareSet returned an invalid OpenGL context");
        }
        this.context = GLX.glXCreateContext(this.drawable.getDisplay(), xVisualInfo, l2, bl);
        if (this.context == 0L) {
            throw new GLException("Unable to create OpenGL context");
        }
        GLContextShareSet.contextCreated(this);
    }

    @Override
    protected int makeCurrentImpl() {
        boolean bl = false;
        if (this.context == 0L) {
            this.create();
            if (DEBUG) {
                System.err.println(X11GLContext.getThreadName() + ": !!! Created GL context for " + this.getClass().getName());
            }
            bl = true;
        }
        if (!GLX.glXMakeCurrent(this.drawable.getDisplay(), this.drawable.getDrawable(), this.context)) {
            throw new GLException("Error making context current");
        }
        this.mostRecentDisplay = this.drawable.getDisplay();
        if (DEBUG && (VERBOSE || bl)) {
            System.err.println(X11GLContext.getThreadName() + ": glXMakeCurrent(display " + X11GLContext.toHexString(this.drawable.getDisplay()) + ", drawable " + X11GLContext.toHexString(this.drawable.getDrawable()) + ", context " + X11GLContext.toHexString(this.context) + ") succeeded");
        }
        if (bl) {
            this.resetGLFunctionAvailability();
            return 2;
        }
        return 1;
    }

    @Override
    protected void releaseImpl() {
        this.lockToolkit();
        try {
            if (!GLX.glXMakeCurrent(this.mostRecentDisplay, 0L, 0L)) {
                throw new GLException("Error freeing OpenGL context");
            }
            return;
        }
        finally {
            this.unlockToolkit();
        }
    }

    @Override
    protected void destroyImpl() {
        this.lockToolkit();
        try {
            if (this.context != 0L) {
                if (DEBUG) {
                    System.err.println("glXDestroyContext(0x" + Long.toHexString(this.mostRecentDisplay) + ", 0x" + Long.toHexString(this.context) + ")");
                }
                GLX.glXDestroyContext(this.mostRecentDisplay, this.context);
                if (DEBUG) {
                    System.err.println("!!! Destroyed OpenGL context " + this.context);
                }
                this.context = 0L;
                this.mostRecentDisplay = 0L;
                GLContextShareSet.contextDestroyed(this);
            }
            return;
        }
        finally {
            this.unlockToolkit();
        }
    }

    @Override
    public boolean isCreated() {
        return this.context != 0L;
    }

    @Override
    public void copy(GLContext gLContext, int n2) {
        long l2 = this.getContext();
        long l3 = ((X11GLContext)gLContext).getContext();
        if (l3 == 0L) {
            throw new GLException("Source OpenGL context has not been created");
        }
        if (l2 == 0L) {
            throw new GLException("Destination OpenGL context has not been created");
        }
        if (this.mostRecentDisplay == 0L) {
            throw new GLException("Connection to X display not yet set up");
        }
        this.lockToolkit();
        try {
            GLX.glXCopyContext(this.mostRecentDisplay, l3, l2, n2);
            return;
        }
        finally {
            this.unlockToolkit();
        }
    }

    @Override
    protected void resetGLFunctionAvailability() {
        super.resetGLFunctionAvailability();
        if (DEBUG) {
            System.err.println(X11GLContext.getThreadName() + ": !!! Initializing GLX extension address table");
        }
        this.resetProcAddressTable(this.getGLXExtProcAddressTable());
    }

    public GLXExtProcAddressTable getGLXExtProcAddressTable() {
        if (this.glXExtProcAddressTable == null) {
            this.glXExtProcAddressTable = new GLXExtProcAddressTable();
        }
        return this.glXExtProcAddressTable;
    }

    @Override
    public synchronized String getPlatformExtensionsString() {
        if (this.mostRecentDisplay == 0L) {
            throw new GLException("Context not current");
        }
        if (!this.glXQueryExtensionsStringInitialized) {
            this.glXQueryExtensionsStringAvailable = GLDrawableFactoryImpl.getFactoryImpl().dynamicLookupFunction("glXQueryExtensionsString") != 0L;
            this.glXQueryExtensionsStringInitialized = true;
        }
        if (this.glXQueryExtensionsStringAvailable) {
            this.lockToolkit();
            try {
                String string = GLX.glXQueryExtensionsString(this.mostRecentDisplay, GLX.DefaultScreen(this.mostRecentDisplay));
                if (DEBUG) {
                    System.err.println("!!! GLX extensions: " + string);
                }
                return string;
            }
            finally {
                this.unlockToolkit();
            }
        }
        return "";
    }

    @Override
    protected boolean isFunctionAvailable(String string) {
        boolean bl = super.isFunctionAvailable(string);
        assert (!bl || this.getGLProcAddressTable().getAddressFor(this.mapToRealGLFunctionName(string)) != 0L || FunctionAvailabilityCache.isPartOfGLCore("1.1", this.mapToRealGLFunctionName(string)));
        return bl;
    }

    @Override
    public boolean isExtensionAvailable(String string) {
        if (string.equals("GL_ARB_pbuffer") || string.equals("GL_ARB_pixel_format")) {
            return GLDrawableFactory.getFactory().canCreateGLPbuffer();
        }
        return super.isExtensionAvailable(string);
    }

    @Override
    public void setSwapInterval(int n2) {
        this.lockToolkit();
        try {
            GLXExt gLXExt = this.getGLXExt();
            if (gLXExt.isExtensionAvailable("GLX_SGI_swap_control")) {
                gLXExt.glXSwapIntervalSGI(n2);
            }
            return;
        }
        finally {
            this.unlockToolkit();
        }
    }

    @Override
    public ByteBuffer glAllocateMemoryNV(int n2, float f2, float f3, float f4) {
        return this.getGLXExt().glXAllocateMemoryNV(n2, f2, f3, f4);
    }

    @Override
    public int getOffscreenContextPixelDataType() {
        throw new GLException("Should not call this");
    }

    public int getOffscreenContextReadBuffer() {
        throw new GLException("Should not call this");
    }

    @Override
    public boolean offscreenImageNeedsVerticalFlip() {
        throw new GLException("Should not call this");
    }

    @Override
    public void bindPbufferToTexture() {
        throw new GLException("Should not call this");
    }

    @Override
    public void releasePbufferFromTexture() {
        throw new GLException("Should not call this");
    }

    @Override
    public boolean isOptimizable() {
        if (super.isOptimizable()) {
            X11GLDrawableFactory.getX11Factory();
            if (!X11GLDrawableFactory.isVendorATI()) {
                return true;
            }
        }
        return false;
    }

    public long getContext() {
        return this.context;
    }

    protected void lockToolkit() {
        X11GLDrawableFactory.getX11Factory().lockToolkit();
    }

    protected void unlockToolkit() {
        X11GLDrawableFactory.getX11Factory().unlockToolkit();
    }

    static {
        functionNameMap.put("glAllocateMemoryNV", "glXAllocateMemoryNV");
        functionNameMap.put("glFreeMemoryNV", "glXFreeMemoryNV");
    }
}

