/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.windows;

import com.sun.opengl.impl.Debug;
import com.sun.opengl.impl.windows.WGLExt;
import com.sun.opengl.impl.windows.WindowsGLContext;
import com.sun.opengl.impl.windows.WindowsGLDrawableFactory;
import com.sun.opengl.impl.windows.WindowsPbufferGLDrawable;
import javax.media.opengl.GL;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;

public class WindowsPbufferGLContext
extends WindowsGLContext {
    private static final boolean DEBUG = Debug.debug("WindowsPbufferGLContext");
    private WindowsPbufferGLDrawable drawable;
    private boolean rtt;
    private boolean hasRTT;
    private boolean rect;
    private int textureTarget;
    private int texture;

    public WindowsPbufferGLContext(WindowsPbufferGLDrawable windowsPbufferGLDrawable, GLContext gLContext) {
        super(windowsPbufferGLDrawable, gLContext);
        this.drawable = windowsPbufferGLDrawable;
    }

    @Override
    public void bindPbufferToTexture() {
        if (!this.rtt) {
            throw new GLException("Shouldn't try to bind a pbuffer to a texture if render-to-texture hasn't been specified in its GLCapabilities");
        }
        GL gL = this.getGL();
        WGLExt wGLExt = this.getWGLExt();
        gL.glBindTexture(this.textureTarget, this.texture);
        if (this.rtt && this.hasRTT && !wGLExt.wglBindTexImageARB(this.drawable.getPbuffer(), 8323)) {
            throw new GLException("Binding of pbuffer to texture failed: " + WindowsPbufferGLContext.wglGetLastError());
        }
    }

    @Override
    public void releasePbufferFromTexture() {
        if (!this.rtt) {
            throw new GLException("Shouldn't try to bind a pbuffer to a texture if render-to-texture hasn't been specified in its GLCapabilities");
        }
        if (this.rtt && this.hasRTT && !this.getWGLExt().wglReleaseTexImageARB(this.drawable.getPbuffer(), 8323)) {
            throw new GLException("Releasing of pbuffer from texture failed: " + WindowsPbufferGLContext.wglGetLastError());
        }
    }

    @Override
    protected int makeCurrentImpl() {
        if (this.drawable.getHDC() == 0L) {
            if (DEBUG) {
                System.err.println("pbuffer not instantiated");
            }
            return 0;
        }
        int n2 = super.makeCurrentImpl();
        if (DEBUG && VERBOSE) {
            System.err.println("WindowsPbufferGLContext: super.makeCurrentImpl() = " + n2);
        }
        if (n2 == 2) {
            Object object = this.drawable.getCapabilities();
            this.rtt = ((GLCapabilities)object).getPbufferRenderToTexture();
            this.rect = ((GLCapabilities)object).getPbufferRenderToTextureRectangle();
            object = this.getGL();
            if (this.rtt) {
                if (DEBUG) {
                    System.err.println("Initializing render-to-texture support");
                }
                if (!object.isExtensionAvailable("WGL_ARB_render_texture")) {
                    System.err.println("WindowsPbufferGLContext: WARNING: WGL_ARB_render_texture extension not supported; implementing render_to_texture support using slow texture readback");
                } else {
                    this.hasRTT = true;
                    if (this.rect && !object.isExtensionAvailable("GL_NV_texture_rectangle")) {
                        System.err.println("WindowsPbufferGLContext: WARNING: GL_NV_texture_rectangle extension not supported; skipping requested render_to_texture_rectangle support for pbuffer");
                        this.rect = false;
                    }
                    if (this.rect) {
                        if (DEBUG) {
                            System.err.println("  Using render-to-texture-rectangle");
                        }
                        this.textureTarget = 34037;
                    } else {
                        if (DEBUG) {
                            System.err.println("  Using vanilla render-to-texture");
                        }
                        this.textureTarget = 3553;
                    }
                    int[] nArray = new int[1];
                    object.glGenTextures(1, nArray, 0);
                    this.texture = nArray[0];
                    object.glBindTexture(this.textureTarget, this.texture);
                    object.glTexParameteri(this.textureTarget, 10241, 9728);
                    object.glTexParameteri(this.textureTarget, 10240, 9728);
                    object.glTexParameteri(this.textureTarget, 10242, 33071);
                    object.glTexParameteri(this.textureTarget, 10243, 33071);
                    object.glCopyTexImage2D(this.textureTarget, 0, 6407, 0, 0, this.drawable.getWidth(), this.drawable.getHeight(), 0);
                }
            }
        }
        return n2;
    }

    @Override
    public int getFloatingPointMode() {
        return this.drawable.getFloatingPointMode();
    }

    private static String wglGetLastError() {
        return WindowsGLDrawableFactory.wglGetLastError();
    }
}

