/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.windows;

import com.sun.opengl.impl.Debug;
import com.sun.opengl.impl.GLDrawableFactoryImpl;
import com.sun.opengl.impl.GLDrawableImpl;
import com.sun.opengl.impl.NativeLibLoader;
import com.sun.opengl.impl.windows.WGL;
import com.sun.opengl.impl.windows.WindowsExternalGLContext;
import com.sun.opengl.impl.windows.WindowsExternalGLDrawable;
import com.sun.opengl.impl.windows.WindowsGLDrawableFactory$1;
import com.sun.opengl.impl.windows.WindowsGLDrawableFactory$2;
import com.sun.opengl.impl.windows.WindowsOffscreenGLDrawable;
import com.sun.opengl.impl.windows.WindowsOnscreenGLDrawable;
import java.awt.Component;
import java.awt.Graphics;
import java.nio.Buffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.AbstractGraphicsConfiguration;
import javax.media.opengl.AbstractGraphicsDevice;
import javax.media.opengl.DefaultGLCapabilitiesChooser;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLException;
import javax.media.opengl.GLPbuffer;
import javax.media.opengl.Threading;

public class WindowsGLDrawableFactory
extends GLDrawableFactoryImpl {
    private static final boolean DEBUG = Debug.debug("WindowsGLDrawableFactory");
    private static final boolean VERBOSE = Debug.verbose();
    private long hglu32;
    private boolean pbufferSupportInitialized = false;
    private boolean canCreateGLPbuffer = false;
    private static final int GAMMA_RAMP_LENGTH = 256;

    @Override
    public AbstractGraphicsConfiguration chooseGraphicsConfiguration(GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser, AbstractGraphicsDevice abstractGraphicsDevice) {
        return null;
    }

    @Override
    public GLDrawable getGLDrawable(Object object, GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser) {
        if (object == null) {
            throw new IllegalArgumentException("Null target");
        }
        if (!(object instanceof Component)) {
            throw new IllegalArgumentException("GLDrawables not supported for objects of type " + object.getClass().getName() + " (only Components are supported in this implementation)");
        }
        if (gLCapabilities == null) {
            gLCapabilities = new GLCapabilities();
        }
        if (gLCapabilitiesChooser == null) {
            gLCapabilitiesChooser = new DefaultGLCapabilitiesChooser();
        }
        return new WindowsOnscreenGLDrawable((Component)object, gLCapabilities, gLCapabilitiesChooser);
    }

    @Override
    public GLDrawableImpl createOffscreenDrawable(GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser) {
        return new WindowsOffscreenGLDrawable(gLCapabilities, gLCapabilitiesChooser);
    }

    @Override
    public boolean canCreateGLPbuffer() {
        if (!this.pbufferSupportInitialized) {
            WindowsGLDrawableFactory$1 windowsGLDrawableFactory$1 = new WindowsGLDrawableFactory$1(this);
            this.maybeDoSingleThreadedWorkaround(windowsGLDrawableFactory$1);
        }
        if (DEBUG) {
            System.err.println("WindowsGLDrawableFactory.canCreateGLPbuffer() = " + this.canCreateGLPbuffer);
        }
        return this.canCreateGLPbuffer;
    }

    @Override
    public GLPbuffer createGLPbuffer(GLCapabilities object, GLCapabilitiesChooser object2, int n2, int n3, GLContext gLContext) {
        if (!this.canCreateGLPbuffer()) {
            throw new GLException("Pbuffer support not available with current graphics card");
        }
        object2 = new ArrayList();
        object = new WindowsGLDrawableFactory$2(this, (GLCapabilities)object, n2, n3, gLContext, (List)object2);
        this.maybeDoSingleThreadedWorkaround((Runnable)object);
        return (GLPbuffer)object2.get(0);
    }

    @Override
    public GLContext createExternalGLContext() {
        return new WindowsExternalGLContext();
    }

    @Override
    public boolean canCreateExternalGLDrawable() {
        return true;
    }

    @Override
    public GLDrawable createExternalGLDrawable() {
        return new WindowsExternalGLDrawable();
    }

    @Override
    public void loadGLULibrary() {
        if (this.hglu32 == 0L) {
            this.hglu32 = WGL.LoadLibraryA("GLU32");
            if (this.hglu32 == 0L) {
                throw new GLException("Error loading GLU32.DLL");
            }
        }
    }

    @Override
    public long dynamicLookupFunction(String string) {
        long l2 = WGL.wglGetProcAddress(string);
        if (l2 == 0L && this.hglu32 != 0L) {
            l2 = WGL.GetProcAddress(this.hglu32, string);
        }
        return l2;
    }

    static String wglGetLastError() {
        String string;
        long l2 = WGL.GetLastError();
        switch ((int)l2) {
            case 2000: {
                string = "ERROR_INVALID_PIXEL_FORMAT";
                break;
            }
            case 1450: {
                string = "ERROR_NO_SYSTEM_RESOURCES";
                break;
            }
            case 13: {
                string = "ERROR_INVALID_DATA";
                break;
            }
            case 127: {
                string = "ERROR_PROC_NOT_FOUND";
                break;
            }
            case 1400: {
                string = "ERROR_INVALID_WINDOW_HANDLE";
                break;
            }
            default: {
                string = "(Unknown error code " + l2 + ")";
            }
        }
        return string;
    }

    private void maybeDoSingleThreadedWorkaround(Runnable runnable) {
        if (Threading.isSingleThreaded() && !Threading.isOpenGLThread()) {
            Threading.invokeOnOpenGLThread(runnable);
            return;
        }
        runnable.run();
    }

    @Override
    public void lockAWTForJava2D() {
    }

    @Override
    public void unlockAWTForJava2D() {
    }

    @Override
    public boolean canCreateContextOnJava2DSurface() {
        return false;
    }

    @Override
    public GLContext createContextOnJava2DSurface(Graphics graphics, GLContext gLContext) {
        throw new GLException("Unimplemented on this platform");
    }

    @Override
    protected int getGammaRampLength() {
        return 256;
    }

    @Override
    protected boolean setGammaRamp(float[] fArray) {
        short[] sArray = new short[768];
        for (int i2 = 0; i2 < 256; ++i2) {
            short s;
            sArray[i2] = s = (short)(fArray[i2] * 65535.0f);
            sArray[i2 + 256] = s;
            sArray[i2 + 512] = s;
        }
        long l2 = WGL.GetDC(0L);
        boolean bl = WGL.SetDeviceGammaRamp(l2, ShortBuffer.wrap(sArray));
        WGL.ReleaseDC(0L, l2);
        return bl;
    }

    @Override
    protected Buffer getGammaRamp() {
        ShortBuffer shortBuffer = ShortBuffer.allocate(768);
        long l2 = WGL.GetDC(0L);
        boolean bl = WGL.GetDeviceGammaRamp(l2, shortBuffer);
        WGL.ReleaseDC(0L, l2);
        if (!bl) {
            return null;
        }
        return shortBuffer;
    }

    @Override
    protected void resetGammaRamp(Buffer buffer) {
        if (buffer == null) {
            return;
        }
        long l2 = WGL.GetDC(0L);
        WGL.SetDeviceGammaRamp(l2, buffer);
        WGL.ReleaseDC(0L, l2);
    }

    static /* synthetic */ boolean access$002(WindowsGLDrawableFactory windowsGLDrawableFactory, boolean bl) {
        windowsGLDrawableFactory.canCreateGLPbuffer = bl;
        return windowsGLDrawableFactory.canCreateGLPbuffer;
    }

    static /* synthetic */ boolean access$102(WindowsGLDrawableFactory windowsGLDrawableFactory, boolean bl) {
        windowsGLDrawableFactory.pbufferSupportInitialized = bl;
        return windowsGLDrawableFactory.pbufferSupportInitialized;
    }

    static {
        NativeLibLoader.loadCore();
    }
}

