/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.windows;

import com.sun.opengl.impl.FunctionAvailabilityCache;
import com.sun.opengl.impl.GLContextImpl;
import com.sun.opengl.impl.GLContextShareSet;
import com.sun.opengl.impl.windows.WGL;
import com.sun.opengl.impl.windows.WGLExt;
import com.sun.opengl.impl.windows.WGLExtImpl;
import com.sun.opengl.impl.windows.WGLExtProcAddressTable;
import com.sun.opengl.impl.windows.WindowsGLDrawable;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLException;

public class WindowsGLContext
extends GLContextImpl {
    protected WindowsGLDrawable drawable;
    protected long hglrc;
    private boolean wglGetExtensionsStringEXTInitialized;
    private boolean wglGetExtensionsStringEXTAvailable;
    private static final Map functionNameMap = new HashMap<String, String>();
    private static final Map extensionNameMap;
    private WGLExt wglExt;
    private WGLExtProcAddressTable wglExtProcAddressTable;

    public WindowsGLContext(WindowsGLDrawable windowsGLDrawable, GLContext gLContext) {
        this(windowsGLDrawable, gLContext, false);
    }

    public WindowsGLContext(WindowsGLDrawable windowsGLDrawable, GLContext gLContext, boolean bl) {
        super(gLContext, bl);
        this.drawable = windowsGLDrawable;
    }

    @Override
    public Object getPlatformGLExtensions() {
        return this.getWGLExt();
    }

    public WGLExt getWGLExt() {
        if (this.wglExt == null) {
            this.wglExt = new WGLExtImpl(this);
        }
        return this.wglExt;
    }

    @Override
    public GLDrawable getGLDrawable() {
        return this.drawable;
    }

    @Override
    protected String mapToRealGLFunctionName(String string) {
        String string2 = (String)functionNameMap.get(string);
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    @Override
    protected String mapToRealGLExtensionName(String string) {
        String string2 = (String)extensionNameMap.get(string);
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    protected void create() {
        if (this.drawable.getHDC() == 0L) {
            throw new GLException("Internal error: attempted to create OpenGL context without an associated drawable");
        }
        this.hglrc = WGL.wglCreateContext(this.drawable.getHDC());
        if (this.hglrc == 0L) {
            throw new GLException("Unable to create OpenGL context for device context " + WindowsGLContext.toHexString(this.drawable.getHDC()));
        }
        if (DEBUG) {
            System.err.println(WindowsGLContext.getThreadName() + ": !!! Created OpenGL context " + WindowsGLContext.toHexString(this.hglrc) + " for " + this + ", device context " + WindowsGLContext.toHexString(this.drawable.getHDC()) + ", not yet sharing");
        }
        WindowsGLContext windowsGLContext = (WindowsGLContext)GLContextShareSet.getShareContext(this);
        long l2 = 0L;
        if (windowsGLContext != null) {
            l2 = windowsGLContext.getHGLRC();
            if (l2 == 0L) {
                throw new GLException("GLContextShareSet returned an invalid OpenGL context");
            }
            if (!WGL.wglShareLists(l2, this.hglrc)) {
                throw new GLException("wglShareLists(" + WindowsGLContext.toHexString(l2) + ", " + WindowsGLContext.toHexString(this.hglrc) + ") failed: error code " + WGL.GetLastError());
            }
        }
        GLContextShareSet.contextCreated(this);
        if (DEBUG) {
            System.err.println(WindowsGLContext.getThreadName() + ": !!! Created OpenGL context " + WindowsGLContext.toHexString(this.hglrc) + " for " + this + ", device context " + WindowsGLContext.toHexString(this.drawable.getHDC()) + ", sharing with " + WindowsGLContext.toHexString(l2));
        }
    }

    @Override
    protected int makeCurrentImpl() {
        boolean bl = false;
        if (this.hglrc == 0L) {
            this.create();
            if (DEBUG) {
                System.err.println(WindowsGLContext.getThreadName() + ": !!! Created GL context for " + this.getClass().getName());
            }
            bl = true;
        }
        boolean bl2 = false;
        if (NO_FREE && WGL.wglGetCurrentContext() == this.hglrc) {
            if (DEBUG && VERBOSE) {
                System.err.println(WindowsGLContext.getThreadName() + ": skipping wglMakeCurrent because context already current");
            }
            bl2 = true;
        }
        if (!bl2) {
            if (!WGL.wglMakeCurrent(this.drawable.getHDC(), this.hglrc)) {
                throw new GLException("Error making context current: " + WGL.GetLastError());
            }
            if (DEBUG && VERBOSE) {
                System.err.println(WindowsGLContext.getThreadName() + ": wglMakeCurrent(hdc " + WindowsGLContext.toHexString(this.drawable.getHDC()) + ", hglrc " + WindowsGLContext.toHexString(this.hglrc) + ") succeeded");
            }
        }
        if (bl) {
            this.resetGLFunctionAvailability();
            return 2;
        }
        return 1;
    }

    @Override
    protected void releaseImpl() {
        if (!NO_FREE && !WGL.wglMakeCurrent(0L, 0L)) {
            throw new GLException("Error freeing OpenGL context: " + WGL.GetLastError());
        }
    }

    @Override
    protected void destroyImpl() {
        if (this.hglrc != 0L) {
            if (!WGL.wglDeleteContext(this.hglrc)) {
                throw new GLException("Unable to delete OpenGL context");
            }
            if (DEBUG) {
                System.err.println(WindowsGLContext.getThreadName() + ": !!! Destroyed OpenGL context " + WindowsGLContext.toHexString(this.hglrc));
            }
            this.hglrc = 0L;
            GLContextShareSet.contextDestroyed(this);
        }
    }

    @Override
    public boolean isCreated() {
        return this.hglrc != 0L;
    }

    @Override
    public void copy(GLContext gLContext, int n2) {
        long l2 = this.getHGLRC();
        long l3 = ((WindowsGLContext)gLContext).getHGLRC();
        if (l3 == 0L) {
            throw new GLException("Source OpenGL context has not been created");
        }
        if (l2 == 0L) {
            throw new GLException("Destination OpenGL context has not been created");
        }
        if (!WGL.wglCopyContext(l3, l2, n2)) {
            throw new GLException("wglCopyContext failed");
        }
    }

    @Override
    protected void resetGLFunctionAvailability() {
        super.resetGLFunctionAvailability();
        if (DEBUG) {
            System.err.println(WindowsGLContext.getThreadName() + ": !!! Initializing WGL extension address table for " + this);
        }
        this.resetProcAddressTable(this.getWGLExtProcAddressTable());
    }

    public WGLExtProcAddressTable getWGLExtProcAddressTable() {
        if (this.wglExtProcAddressTable == null) {
            this.wglExtProcAddressTable = new WGLExtProcAddressTable();
        }
        return this.wglExtProcAddressTable;
    }

    @Override
    public String getPlatformExtensionsString() {
        if (!this.wglGetExtensionsStringEXTInitialized) {
            this.wglGetExtensionsStringEXTAvailable = WGL.wglGetProcAddress("wglGetExtensionsStringEXT") != 0L;
            this.wglGetExtensionsStringEXTInitialized = true;
        }
        if (this.wglGetExtensionsStringEXTAvailable) {
            return this.getWGLExt().wglGetExtensionsStringEXT();
        }
        return "";
    }

    @Override
    protected boolean isFunctionAvailable(String string) {
        boolean bl = super.isFunctionAvailable(string);
        assert (!bl || this.getGLProcAddressTable().getAddressFor(this.mapToRealGLFunctionName(string)) != 0L || FunctionAvailabilityCache.isPartOfGLCore("1.1", this.mapToRealGLFunctionName(string)));
        return bl;
    }

    @Override
    public void setSwapInterval(int n2) {
        WGLExt wGLExt = this.getWGLExt();
        if (wGLExt.isExtensionAvailable("WGL_EXT_swap_control")) {
            wGLExt.wglSwapIntervalEXT(n2);
        }
    }

    @Override
    public ByteBuffer glAllocateMemoryNV(int n2, float f2, float f3, float f4) {
        return this.getWGLExt().wglAllocateMemoryNV(n2, f2, f3, f4);
    }

    @Override
    public int getOffscreenContextPixelDataType() {
        throw new GLException("Should not call this");
    }

    public int getOffscreenContextReadBuffer() {
        throw new GLException("Should not call this");
    }

    @Override
    public boolean offscreenImageNeedsVerticalFlip() {
        throw new GLException("Should not call this");
    }

    @Override
    public void bindPbufferToTexture() {
        throw new GLException("Should not call this");
    }

    @Override
    public void releasePbufferFromTexture() {
        throw new GLException("Should not call this");
    }

    public long getHGLRC() {
        return this.hglrc;
    }

    static {
        functionNameMap.put("glAllocateMemoryNV", "wglAllocateMemoryNV");
        functionNameMap.put("glFreeMemoryNV", "wglFreeMemoryNV");
        extensionNameMap = new HashMap<String, String>();
        extensionNameMap.put("GL_ARB_pbuffer", "WGL_ARB_pbuffer");
        extensionNameMap.put("GL_ARB_pixel_format", "WGL_ARB_pixel_format");
    }
}

