/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.tessellator;

import com.sun.opengl.impl.tessellator.ActiveRegion;
import com.sun.opengl.impl.tessellator.Dict;
import com.sun.opengl.impl.tessellator.DictNode;
import com.sun.opengl.impl.tessellator.GLUface;
import com.sun.opengl.impl.tessellator.GLUhalfEdge;
import com.sun.opengl.impl.tessellator.GLUmesh;
import com.sun.opengl.impl.tessellator.GLUtessellatorImpl;
import com.sun.opengl.impl.tessellator.GLUvertex;
import com.sun.opengl.impl.tessellator.Geom;
import com.sun.opengl.impl.tessellator.Mesh;
import com.sun.opengl.impl.tessellator.PriorityQ;
import com.sun.opengl.impl.tessellator.Sweep$1;
import com.sun.opengl.impl.tessellator.Sweep$2;

class Sweep {
    private static final boolean TOLERANCE_NONZERO = false;
    private static final double SENTINEL_COORD = 4.0E150;
    static final boolean $assertionsDisabled = !(class$com$sun$opengl$impl$tessellator$Sweep == null ? (class$com$sun$opengl$impl$tessellator$Sweep = Sweep.class$("com.sun.opengl.impl.tessellator.Sweep")) : class$com$sun$opengl$impl$tessellator$Sweep).desiredAssertionStatus();
    static Class class$com$sun$opengl$impl$tessellator$Sweep;

    private Sweep() {
    }

    private static void DebugEvent(GLUtessellatorImpl gLUtessellatorImpl) {
    }

    private static void AddWinding(GLUhalfEdge gLUhalfEdge, GLUhalfEdge gLUhalfEdge2) {
        gLUhalfEdge.winding += gLUhalfEdge2.winding;
        gLUhalfEdge.Sym.winding += gLUhalfEdge2.Sym.winding;
    }

    private static ActiveRegion RegionBelow(ActiveRegion activeRegion) {
        return (ActiveRegion)Dict.dictKey(Dict.dictPred(activeRegion.nodeUp));
    }

    private static ActiveRegion RegionAbove(ActiveRegion activeRegion) {
        return (ActiveRegion)Dict.dictKey(Dict.dictSucc(activeRegion.nodeUp));
    }

    static boolean EdgeLeq(GLUtessellatorImpl object, ActiveRegion object2, ActiveRegion object3) {
        double d2;
        object = ((GLUtessellatorImpl)object).event;
        object2 = ((ActiveRegion)object2).eUp;
        object3 = ((ActiveRegion)object3).eUp;
        if (((GLUhalfEdge)object2).Sym.Org == object) {
            if (((GLUhalfEdge)object3).Sym.Org == object) {
                if (Geom.VertLeq(((GLUhalfEdge)object2).Org, ((GLUhalfEdge)object3).Org)) {
                    return Geom.EdgeSign(((GLUhalfEdge)object3).Sym.Org, ((GLUhalfEdge)object2).Org, ((GLUhalfEdge)object3).Org) <= 0.0;
                }
                return Geom.EdgeSign(((GLUhalfEdge)object2).Sym.Org, ((GLUhalfEdge)object3).Org, ((GLUhalfEdge)object2).Org) >= 0.0;
            }
            return Geom.EdgeSign(((GLUhalfEdge)object3).Sym.Org, (GLUvertex)object, ((GLUhalfEdge)object3).Org) <= 0.0;
        }
        if (((GLUhalfEdge)object3).Sym.Org == object) {
            return Geom.EdgeSign(((GLUhalfEdge)object2).Sym.Org, (GLUvertex)object, ((GLUhalfEdge)object2).Org) >= 0.0;
        }
        double d3 = Geom.EdgeEval(((GLUhalfEdge)object2).Sym.Org, (GLUvertex)object, ((GLUhalfEdge)object2).Org);
        return d3 >= (d2 = Geom.EdgeEval(((GLUhalfEdge)object3).Sym.Org, (GLUvertex)object, ((GLUhalfEdge)object3).Org));
    }

    static void DeleteRegion(GLUtessellatorImpl gLUtessellatorImpl, ActiveRegion activeRegion) {
        if (activeRegion.fixUpperEdge && !$assertionsDisabled && activeRegion.eUp.winding != 0) {
            throw new AssertionError();
        }
        activeRegion.eUp.activeRegion = null;
        Dict.dictDelete(gLUtessellatorImpl.dict, activeRegion.nodeUp);
    }

    static boolean FixUpperEdge(ActiveRegion activeRegion, GLUhalfEdge gLUhalfEdge) {
        if (!$assertionsDisabled && !activeRegion.fixUpperEdge) {
            throw new AssertionError();
        }
        if (!Mesh.__gl_meshDelete(activeRegion.eUp)) {
            return false;
        }
        activeRegion.fixUpperEdge = false;
        activeRegion.eUp = gLUhalfEdge;
        gLUhalfEdge.activeRegion = activeRegion;
        return true;
    }

    static ActiveRegion TopLeftRegion(ActiveRegion activeRegion) {
        Object object = activeRegion.eUp.Org;
        do {
            activeRegion = Sweep.RegionAbove(activeRegion);
        } while (activeRegion.eUp.Org == object);
        if (activeRegion.fixUpperEdge) {
            object = Mesh.__gl_meshConnect(Sweep.RegionBelow((ActiveRegion)activeRegion).eUp.Sym, activeRegion.eUp.Lnext);
            if (object == null) {
                return null;
            }
            if (!Sweep.FixUpperEdge(activeRegion, (GLUhalfEdge)object)) {
                return null;
            }
            activeRegion = Sweep.RegionAbove(activeRegion);
        }
        return activeRegion;
    }

    static ActiveRegion TopRightRegion(ActiveRegion activeRegion) {
        GLUvertex gLUvertex = activeRegion.eUp.Sym.Org;
        do {
            activeRegion = Sweep.RegionAbove(activeRegion);
        } while (activeRegion.eUp.Sym.Org == gLUvertex);
        return activeRegion;
    }

    static ActiveRegion AddRegionBelow(GLUtessellatorImpl gLUtessellatorImpl, ActiveRegion activeRegion, GLUhalfEdge gLUhalfEdge) {
        ActiveRegion activeRegion2 = new ActiveRegion();
        new ActiveRegion().eUp = gLUhalfEdge;
        activeRegion2.nodeUp = Dict.dictInsertBefore(gLUtessellatorImpl.dict, activeRegion.nodeUp, activeRegion2);
        if (activeRegion2.nodeUp == null) {
            throw new RuntimeException();
        }
        activeRegion2.fixUpperEdge = false;
        activeRegion2.sentinel = false;
        activeRegion2.dirty = false;
        gLUhalfEdge.activeRegion = activeRegion2;
        return activeRegion2;
    }

    static boolean IsWindingInside(GLUtessellatorImpl gLUtessellatorImpl, int n2) {
        switch (gLUtessellatorImpl.windingRule) {
            case 100130: {
                return (n2 & 1) != 0;
            }
            case 100131: {
                return n2 != 0;
            }
            case 100132: {
                return n2 > 0;
            }
            case 100133: {
                return n2 < 0;
            }
            case 100134: {
                return n2 >= 2 || n2 <= -2;
            }
        }
        throw new InternalError();
    }

    static void ComputeWinding(GLUtessellatorImpl gLUtessellatorImpl, ActiveRegion activeRegion) {
        activeRegion.windingNumber = Sweep.RegionAbove((ActiveRegion)activeRegion).windingNumber + activeRegion.eUp.winding;
        activeRegion.inside = Sweep.IsWindingInside(gLUtessellatorImpl, activeRegion.windingNumber);
    }

    static void FinishRegion(GLUtessellatorImpl gLUtessellatorImpl, ActiveRegion activeRegion) {
        GLUhalfEdge gLUhalfEdge = activeRegion.eUp;
        GLUface gLUface = gLUhalfEdge.Lface;
        gLUhalfEdge.Lface.inside = activeRegion.inside;
        gLUface.anEdge = gLUhalfEdge;
        Sweep.DeleteRegion(gLUtessellatorImpl, activeRegion);
    }

    static GLUhalfEdge FinishLeftRegions(GLUtessellatorImpl gLUtessellatorImpl, ActiveRegion activeRegion, ActiveRegion activeRegion2) {
        ActiveRegion activeRegion3 = activeRegion;
        GLUhalfEdge gLUhalfEdge = activeRegion.eUp;
        while (activeRegion3 != activeRegion2) {
            activeRegion3.fixUpperEdge = false;
            activeRegion = Sweep.RegionBelow(activeRegion3);
            GLUhalfEdge gLUhalfEdge2 = activeRegion.eUp;
            if (gLUhalfEdge2.Org != gLUhalfEdge.Org) {
                if (!activeRegion.fixUpperEdge) {
                    Sweep.FinishRegion(gLUtessellatorImpl, activeRegion3);
                    break;
                }
                gLUhalfEdge2 = Mesh.__gl_meshConnect(gLUhalfEdge.Onext.Sym, gLUhalfEdge2.Sym);
                if (gLUhalfEdge2 == null) {
                    throw new RuntimeException();
                }
                if (!Sweep.FixUpperEdge(activeRegion, gLUhalfEdge2)) {
                    throw new RuntimeException();
                }
            }
            if (gLUhalfEdge.Onext != gLUhalfEdge2) {
                if (!Mesh.__gl_meshSplice(gLUhalfEdge2.Sym.Lnext, gLUhalfEdge2)) {
                    throw new RuntimeException();
                }
                if (!Mesh.__gl_meshSplice(gLUhalfEdge, gLUhalfEdge2)) {
                    throw new RuntimeException();
                }
            }
            Sweep.FinishRegion(gLUtessellatorImpl, activeRegion3);
            gLUhalfEdge = activeRegion.eUp;
            activeRegion3 = activeRegion;
        }
        return gLUhalfEdge;
    }

    static void AddRightEdges(GLUtessellatorImpl gLUtessellatorImpl, ActiveRegion activeRegion, GLUhalfEdge object, GLUhalfEdge gLUhalfEdge, GLUhalfEdge gLUhalfEdge2, boolean bl) {
        boolean bl2 = true;
        GLUhalfEdge gLUhalfEdge3 = object;
        do {
            if (!$assertionsDisabled && !Geom.VertLeq(gLUhalfEdge3.Org, gLUhalfEdge3.Sym.Org)) {
                throw new AssertionError();
            }
            Sweep.AddRegionBelow(gLUtessellatorImpl, activeRegion, gLUhalfEdge3.Sym);
        } while ((gLUhalfEdge3 = gLUhalfEdge3.Onext) != gLUhalfEdge);
        if (gLUhalfEdge2 == null) {
            gLUhalfEdge2 = Sweep.RegionBelow((ActiveRegion)activeRegion).eUp.Sym.Onext;
        }
        object = activeRegion;
        gLUhalfEdge = gLUhalfEdge2;
        while (true) {
            activeRegion = Sweep.RegionBelow((ActiveRegion)object);
            gLUhalfEdge3 = activeRegion.eUp.Sym;
            if (gLUhalfEdge3.Org != gLUhalfEdge.Org) break;
            if (gLUhalfEdge3.Onext != gLUhalfEdge) {
                if (!Mesh.__gl_meshSplice(gLUhalfEdge3.Sym.Lnext, gLUhalfEdge3)) {
                    throw new RuntimeException();
                }
                if (!Mesh.__gl_meshSplice(gLUhalfEdge.Sym.Lnext, gLUhalfEdge3)) {
                    throw new RuntimeException();
                }
            }
            activeRegion.windingNumber = ((ActiveRegion)object).windingNumber - gLUhalfEdge3.winding;
            activeRegion.inside = Sweep.IsWindingInside(gLUtessellatorImpl, activeRegion.windingNumber);
            ((ActiveRegion)object).dirty = true;
            if (!bl2 && Sweep.CheckForRightSplice(gLUtessellatorImpl, (ActiveRegion)object)) {
                Sweep.AddWinding(gLUhalfEdge3, gLUhalfEdge);
                Sweep.DeleteRegion(gLUtessellatorImpl, (ActiveRegion)object);
                if (!Mesh.__gl_meshDelete(gLUhalfEdge)) {
                    throw new RuntimeException();
                }
            }
            bl2 = false;
            object = activeRegion;
            gLUhalfEdge = gLUhalfEdge3;
        }
        ((ActiveRegion)object).dirty = true;
        if (!$assertionsDisabled && ((ActiveRegion)object).windingNumber - gLUhalfEdge3.winding != activeRegion.windingNumber) {
            throw new AssertionError();
        }
        if (bl) {
            Sweep.WalkDirtyRegions(gLUtessellatorImpl, (ActiveRegion)object);
        }
    }

    static void CallCombine(GLUtessellatorImpl gLUtessellatorImpl, GLUvertex gLUvertex, Object[] objectArray, float[] fArray, boolean bl) {
        double[] dArray = new double[3];
        double[] dArray2 = dArray;
        dArray[0] = gLUvertex.coords[0];
        dArray2[1] = gLUvertex.coords[1];
        dArray2[2] = gLUvertex.coords[2];
        Object[] objectArray2 = new Object[1];
        gLUtessellatorImpl.callCombineOrCombineData(dArray2, objectArray, fArray, objectArray2);
        gLUvertex.data = objectArray2[0];
        if (gLUvertex.data == null) {
            if (!bl) {
                gLUvertex.data = objectArray[0];
                return;
            }
            if (!gLUtessellatorImpl.fatalError) {
                gLUtessellatorImpl.callErrorOrErrorData(100156);
                gLUtessellatorImpl.fatalError = true;
            }
        }
    }

    static void SpliceMergeVertices(GLUtessellatorImpl gLUtessellatorImpl, GLUhalfEdge gLUhalfEdge, GLUhalfEdge gLUhalfEdge2) {
        Object[] objectArray = new Object[4];
        float[] fArray = new float[]{0.5f, 0.5f, 0.0f, 0.0f};
        objectArray[0] = gLUhalfEdge.Org.data;
        objectArray[1] = gLUhalfEdge2.Org.data;
        Sweep.CallCombine(gLUtessellatorImpl, gLUhalfEdge.Org, objectArray, fArray, false);
        if (!Mesh.__gl_meshSplice(gLUhalfEdge, gLUhalfEdge2)) {
            throw new RuntimeException();
        }
    }

    static void VertexWeights(GLUvertex gLUvertex, GLUvertex gLUvertex2, GLUvertex gLUvertex3, float[] fArray) {
        double d2 = Geom.VertL1dist(gLUvertex2, gLUvertex);
        double d3 = Geom.VertL1dist(gLUvertex3, gLUvertex);
        fArray[0] = (float)(d3 * 0.5 / (d2 + d3));
        fArray[1] = (float)(d2 * 0.5 / (d2 + d3));
        gLUvertex.coords[0] = gLUvertex.coords[0] + ((double)fArray[0] * gLUvertex2.coords[0] + (double)fArray[1] * gLUvertex3.coords[0]);
        gLUvertex.coords[1] = gLUvertex.coords[1] + ((double)fArray[0] * gLUvertex2.coords[1] + (double)fArray[1] * gLUvertex3.coords[1]);
        gLUvertex.coords[2] = gLUvertex.coords[2] + ((double)fArray[0] * gLUvertex2.coords[2] + (double)fArray[1] * gLUvertex3.coords[2]);
    }

    static void GetIntersectData(GLUtessellatorImpl gLUtessellatorImpl, GLUvertex gLUvertex, GLUvertex gLUvertex2, GLUvertex gLUvertex3, GLUvertex gLUvertex4, GLUvertex gLUvertex5) {
        Object[] objectArray = new Object[4];
        float[] fArray = new float[4];
        float[] fArray2 = new float[2];
        float[] fArray3 = new float[2];
        objectArray[0] = gLUvertex2.data;
        objectArray[1] = gLUvertex3.data;
        objectArray[2] = gLUvertex4.data;
        objectArray[3] = gLUvertex5.data;
        gLUvertex.coords[2] = 0.0;
        gLUvertex.coords[1] = 0.0;
        gLUvertex.coords[0] = 0.0;
        Sweep.VertexWeights(gLUvertex, gLUvertex2, gLUvertex3, fArray2);
        Sweep.VertexWeights(gLUvertex, gLUvertex4, gLUvertex5, fArray3);
        System.arraycopy(fArray2, 0, fArray, 0, 2);
        System.arraycopy(fArray3, 0, fArray, 2, 2);
        Sweep.CallCombine(gLUtessellatorImpl, gLUvertex, objectArray, fArray, true);
    }

    static boolean CheckForRightSplice(GLUtessellatorImpl gLUtessellatorImpl, ActiveRegion activeRegion) {
        ActiveRegion activeRegion2 = Sweep.RegionBelow(activeRegion);
        GLUhalfEdge gLUhalfEdge = activeRegion.eUp;
        GLUhalfEdge gLUhalfEdge2 = activeRegion2.eUp;
        if (Geom.VertLeq(gLUhalfEdge.Org, gLUhalfEdge2.Org)) {
            if (Geom.EdgeSign(gLUhalfEdge2.Sym.Org, gLUhalfEdge.Org, gLUhalfEdge2.Org) > 0.0) {
                return false;
            }
            if (!Geom.VertEq(gLUhalfEdge.Org, gLUhalfEdge2.Org)) {
                if (Mesh.__gl_meshSplitEdge(gLUhalfEdge2.Sym) == null) {
                    throw new RuntimeException();
                }
                if (!Mesh.__gl_meshSplice(gLUhalfEdge, gLUhalfEdge2.Sym.Lnext)) {
                    throw new RuntimeException();
                }
                activeRegion2.dirty = true;
                activeRegion.dirty = true;
            } else if (gLUhalfEdge.Org != gLUhalfEdge2.Org) {
                gLUtessellatorImpl.pq.pqDelete(gLUhalfEdge.Org.pqHandle);
                Sweep.SpliceMergeVertices(gLUtessellatorImpl, gLUhalfEdge2.Sym.Lnext, gLUhalfEdge);
            }
        } else {
            if (Geom.EdgeSign(gLUhalfEdge.Sym.Org, gLUhalfEdge2.Org, gLUhalfEdge.Org) < 0.0) {
                return false;
            }
            activeRegion.dirty = true;
            Sweep.RegionAbove((ActiveRegion)activeRegion).dirty = true;
            if (Mesh.__gl_meshSplitEdge(gLUhalfEdge.Sym) == null) {
                throw new RuntimeException();
            }
            if (!Mesh.__gl_meshSplice(gLUhalfEdge2.Sym.Lnext, gLUhalfEdge)) {
                throw new RuntimeException();
            }
        }
        return true;
    }

    static boolean CheckForLeftSplice(GLUtessellatorImpl object, ActiveRegion activeRegion) {
        object = Sweep.RegionBelow(activeRegion);
        GLUhalfEdge gLUhalfEdge = activeRegion.eUp;
        GLUhalfEdge gLUhalfEdge2 = ((ActiveRegion)object).eUp;
        if (!$assertionsDisabled && Geom.VertEq(gLUhalfEdge.Sym.Org, gLUhalfEdge2.Sym.Org)) {
            throw new AssertionError();
        }
        if (Geom.VertLeq(gLUhalfEdge.Sym.Org, gLUhalfEdge2.Sym.Org)) {
            if (Geom.EdgeSign(gLUhalfEdge.Sym.Org, gLUhalfEdge2.Sym.Org, gLUhalfEdge.Org) < 0.0) {
                return false;
            }
            activeRegion.dirty = true;
            Sweep.RegionAbove((ActiveRegion)activeRegion).dirty = true;
            object = Mesh.__gl_meshSplitEdge(gLUhalfEdge);
            if (object == null) {
                throw new RuntimeException();
            }
            if (!Mesh.__gl_meshSplice(gLUhalfEdge2.Sym, (GLUhalfEdge)object)) {
                throw new RuntimeException();
            }
            ((GLUhalfEdge)object).Lface.inside = activeRegion.inside;
        } else {
            if (Geom.EdgeSign(gLUhalfEdge2.Sym.Org, gLUhalfEdge.Sym.Org, gLUhalfEdge2.Org) > 0.0) {
                return false;
            }
            ((ActiveRegion)object).dirty = true;
            activeRegion.dirty = true;
            object = Mesh.__gl_meshSplitEdge(gLUhalfEdge2);
            if (object == null) {
                throw new RuntimeException();
            }
            if (!Mesh.__gl_meshSplice(gLUhalfEdge.Lnext, gLUhalfEdge2.Sym)) {
                throw new RuntimeException();
            }
            ((GLUhalfEdge)object).Sym.Lface.inside = activeRegion.inside;
        }
        return true;
    }

    static boolean CheckForIntersect(GLUtessellatorImpl gLUtessellatorImpl, ActiveRegion activeRegion) {
        GLUvertex gLUvertex;
        double d2;
        ActiveRegion activeRegion2 = Sweep.RegionBelow(activeRegion);
        GLUhalfEdge gLUhalfEdge = activeRegion.eUp;
        GLUhalfEdge gLUhalfEdge2 = activeRegion2.eUp;
        Object object = gLUhalfEdge.Org;
        GLUvertex gLUvertex2 = gLUhalfEdge2.Org;
        GLUvertex gLUvertex3 = gLUhalfEdge.Sym.Org;
        GLUvertex gLUvertex4 = gLUhalfEdge2.Sym.Org;
        GLUvertex gLUvertex5 = new GLUvertex();
        if (!$assertionsDisabled && Geom.VertEq(gLUvertex4, gLUvertex3)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !(Geom.EdgeSign(gLUvertex3, gLUtessellatorImpl.event, (GLUvertex)object) <= 0.0)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !(Geom.EdgeSign(gLUvertex4, gLUtessellatorImpl.event, gLUvertex2) >= 0.0)) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || object != gLUtessellatorImpl.event && gLUvertex2 != gLUtessellatorImpl.event)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && (activeRegion.fixUpperEdge || activeRegion2.fixUpperEdge)) {
            throw new AssertionError();
        }
        if (object == gLUvertex2) {
            return false;
        }
        double d3 = Math.min(((GLUvertex)object).t, gLUvertex3.t);
        if (d3 > (d2 = Math.max(gLUvertex2.t, gLUvertex4.t))) {
            return false;
        }
        if (Geom.VertLeq((GLUvertex)object, gLUvertex2) ? Geom.EdgeSign(gLUvertex4, (GLUvertex)object, gLUvertex2) > 0.0 : Geom.EdgeSign(gLUvertex3, gLUvertex2, (GLUvertex)object) < 0.0) {
            return false;
        }
        Sweep.DebugEvent(gLUtessellatorImpl);
        Geom.EdgeIntersect(gLUvertex3, (GLUvertex)object, gLUvertex4, gLUvertex2, gLUvertex5);
        if (!$assertionsDisabled && !(Math.min(((GLUvertex)object).t, gLUvertex3.t) <= gLUvertex5.t)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !(gLUvertex5.t <= Math.max(gLUvertex2.t, gLUvertex4.t))) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !(Math.min(gLUvertex4.s, gLUvertex3.s) <= gLUvertex5.s)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !(gLUvertex5.s <= Math.max(gLUvertex2.s, ((GLUvertex)object).s))) {
            throw new AssertionError();
        }
        if (Geom.VertLeq(gLUvertex5, gLUtessellatorImpl.event)) {
            gLUvertex5.s = gLUtessellatorImpl.event.s;
            gLUvertex5.t = gLUtessellatorImpl.event.t;
        }
        if (Geom.VertLeq(gLUvertex = Geom.VertLeq((GLUvertex)object, gLUvertex2) ? object : gLUvertex2, gLUvertex5)) {
            gLUvertex5.s = gLUvertex.s;
            gLUvertex5.t = gLUvertex.t;
        }
        if (Geom.VertEq(gLUvertex5, (GLUvertex)object) || Geom.VertEq(gLUvertex5, gLUvertex2)) {
            Sweep.CheckForRightSplice(gLUtessellatorImpl, activeRegion);
            return false;
        }
        if (!Geom.VertEq(gLUvertex3, gLUtessellatorImpl.event) && Geom.EdgeSign(gLUvertex3, gLUtessellatorImpl.event, gLUvertex5) >= 0.0 || !Geom.VertEq(gLUvertex4, gLUtessellatorImpl.event) && Geom.EdgeSign(gLUvertex4, gLUtessellatorImpl.event, gLUvertex5) <= 0.0) {
            if (gLUvertex4 == gLUtessellatorImpl.event) {
                if (Mesh.__gl_meshSplitEdge(gLUhalfEdge.Sym) == null) {
                    throw new RuntimeException();
                }
                if (!Mesh.__gl_meshSplice(gLUhalfEdge2.Sym, gLUhalfEdge)) {
                    throw new RuntimeException();
                }
                if ((activeRegion = Sweep.TopLeftRegion(activeRegion)) == null) {
                    throw new RuntimeException();
                }
                gLUhalfEdge = Sweep.RegionBelow((ActiveRegion)activeRegion).eUp;
                Sweep.FinishLeftRegions(gLUtessellatorImpl, Sweep.RegionBelow(activeRegion), activeRegion2);
                Sweep.AddRightEdges(gLUtessellatorImpl, activeRegion, gLUhalfEdge.Sym.Lnext, gLUhalfEdge, gLUhalfEdge, true);
                return true;
            }
            if (gLUvertex3 == gLUtessellatorImpl.event) {
                if (Mesh.__gl_meshSplitEdge(gLUhalfEdge2.Sym) == null) {
                    throw new RuntimeException();
                }
                if (!Mesh.__gl_meshSplice(gLUhalfEdge.Lnext, gLUhalfEdge2.Sym.Lnext)) {
                    throw new RuntimeException();
                }
                activeRegion2 = activeRegion;
                activeRegion = Sweep.TopRightRegion(activeRegion);
                object = Sweep.RegionBelow((ActiveRegion)activeRegion).eUp.Sym.Onext;
                activeRegion2.eUp = gLUhalfEdge2.Sym.Lnext;
                gLUhalfEdge2 = Sweep.FinishLeftRegions(gLUtessellatorImpl, activeRegion2, null);
                Sweep.AddRightEdges(gLUtessellatorImpl, activeRegion, gLUhalfEdge2.Onext, gLUhalfEdge.Sym.Onext, (GLUhalfEdge)object, true);
                return true;
            }
            if (Geom.EdgeSign(gLUvertex3, gLUtessellatorImpl.event, gLUvertex5) >= 0.0) {
                activeRegion.dirty = true;
                Sweep.RegionAbove((ActiveRegion)activeRegion).dirty = true;
                if (Mesh.__gl_meshSplitEdge(gLUhalfEdge.Sym) == null) {
                    throw new RuntimeException();
                }
                gLUhalfEdge.Org.s = gLUtessellatorImpl.event.s;
                gLUhalfEdge.Org.t = gLUtessellatorImpl.event.t;
            }
            if (Geom.EdgeSign(gLUvertex4, gLUtessellatorImpl.event, gLUvertex5) <= 0.0) {
                activeRegion2.dirty = true;
                activeRegion.dirty = true;
                if (Mesh.__gl_meshSplitEdge(gLUhalfEdge2.Sym) == null) {
                    throw new RuntimeException();
                }
                gLUhalfEdge2.Org.s = gLUtessellatorImpl.event.s;
                gLUhalfEdge2.Org.t = gLUtessellatorImpl.event.t;
            }
            return false;
        }
        if (Mesh.__gl_meshSplitEdge(gLUhalfEdge.Sym) == null) {
            throw new RuntimeException();
        }
        if (Mesh.__gl_meshSplitEdge(gLUhalfEdge2.Sym) == null) {
            throw new RuntimeException();
        }
        if (!Mesh.__gl_meshSplice(gLUhalfEdge2.Sym.Lnext, gLUhalfEdge)) {
            throw new RuntimeException();
        }
        gLUhalfEdge.Org.s = gLUvertex5.s;
        gLUhalfEdge.Org.t = gLUvertex5.t;
        gLUhalfEdge.Org.pqHandle = gLUtessellatorImpl.pq.pqInsert(gLUhalfEdge.Org);
        if ((long)gLUhalfEdge.Org.pqHandle == Long.MAX_VALUE) {
            gLUtessellatorImpl.pq.pqDeletePriorityQ();
            gLUtessellatorImpl.pq = null;
            throw new RuntimeException();
        }
        Sweep.GetIntersectData(gLUtessellatorImpl, gLUhalfEdge.Org, (GLUvertex)object, gLUvertex3, gLUvertex2, gLUvertex4);
        activeRegion2.dirty = true;
        activeRegion.dirty = true;
        Sweep.RegionAbove((ActiveRegion)activeRegion).dirty = true;
        return false;
    }

    static void WalkDirtyRegions(GLUtessellatorImpl gLUtessellatorImpl, ActiveRegion activeRegion) {
        ActiveRegion activeRegion2 = Sweep.RegionBelow(activeRegion);
        while (true) {
            if (activeRegion2.dirty) {
                activeRegion = activeRegion2;
                activeRegion2 = Sweep.RegionBelow(activeRegion2);
                continue;
            }
            if (!activeRegion.dirty) {
                activeRegion2 = activeRegion;
                if ((activeRegion = Sweep.RegionAbove(activeRegion)) == null || !activeRegion.dirty) {
                    return;
                }
            }
            activeRegion.dirty = false;
            GLUhalfEdge gLUhalfEdge = activeRegion.eUp;
            GLUhalfEdge gLUhalfEdge2 = activeRegion2.eUp;
            if (gLUhalfEdge.Sym.Org != gLUhalfEdge2.Sym.Org && Sweep.CheckForLeftSplice(gLUtessellatorImpl, activeRegion)) {
                if (activeRegion2.fixUpperEdge) {
                    Sweep.DeleteRegion(gLUtessellatorImpl, activeRegion2);
                    if (!Mesh.__gl_meshDelete(gLUhalfEdge2)) {
                        throw new RuntimeException();
                    }
                    activeRegion2 = Sweep.RegionBelow(activeRegion);
                    gLUhalfEdge2 = activeRegion2.eUp;
                } else if (activeRegion.fixUpperEdge) {
                    Sweep.DeleteRegion(gLUtessellatorImpl, activeRegion);
                    if (!Mesh.__gl_meshDelete(gLUhalfEdge)) {
                        throw new RuntimeException();
                    }
                    activeRegion = Sweep.RegionAbove(activeRegion2);
                    gLUhalfEdge = activeRegion.eUp;
                }
            }
            if (gLUhalfEdge.Org != gLUhalfEdge2.Org) {
                if (!(gLUhalfEdge.Sym.Org == gLUhalfEdge2.Sym.Org || activeRegion.fixUpperEdge || activeRegion2.fixUpperEdge || gLUhalfEdge.Sym.Org != gLUtessellatorImpl.event && gLUhalfEdge2.Sym.Org != gLUtessellatorImpl.event)) {
                    if (Sweep.CheckForIntersect(gLUtessellatorImpl, activeRegion)) {
                        return;
                    }
                } else {
                    Sweep.CheckForRightSplice(gLUtessellatorImpl, activeRegion);
                }
            }
            if (gLUhalfEdge.Org != gLUhalfEdge2.Org || gLUhalfEdge.Sym.Org != gLUhalfEdge2.Sym.Org) continue;
            Sweep.AddWinding(gLUhalfEdge2, gLUhalfEdge);
            Sweep.DeleteRegion(gLUtessellatorImpl, activeRegion);
            if (!Mesh.__gl_meshDelete(gLUhalfEdge)) {
                throw new RuntimeException();
            }
            activeRegion = Sweep.RegionAbove(activeRegion2);
        }
    }

    static void ConnectRightVertex(GLUtessellatorImpl gLUtessellatorImpl, ActiveRegion activeRegion, GLUhalfEdge gLUhalfEdge) {
        GLUhalfEdge gLUhalfEdge2 = gLUhalfEdge.Onext;
        ActiveRegion activeRegion2 = Sweep.RegionBelow(activeRegion);
        GLUhalfEdge gLUhalfEdge3 = activeRegion.eUp;
        GLUhalfEdge gLUhalfEdge4 = activeRegion2.eUp;
        boolean bl = false;
        if (gLUhalfEdge3.Sym.Org != gLUhalfEdge4.Sym.Org) {
            Sweep.CheckForIntersect(gLUtessellatorImpl, activeRegion);
        }
        if (Geom.VertEq(gLUhalfEdge3.Org, gLUtessellatorImpl.event)) {
            if (!Mesh.__gl_meshSplice(gLUhalfEdge2.Sym.Lnext, gLUhalfEdge3)) {
                throw new RuntimeException();
            }
            if ((activeRegion = Sweep.TopLeftRegion(activeRegion)) == null) {
                throw new RuntimeException();
            }
            gLUhalfEdge2 = Sweep.RegionBelow((ActiveRegion)activeRegion).eUp;
            Sweep.FinishLeftRegions(gLUtessellatorImpl, Sweep.RegionBelow(activeRegion), activeRegion2);
            bl = true;
        }
        if (Geom.VertEq(gLUhalfEdge4.Org, gLUtessellatorImpl.event)) {
            if (!Mesh.__gl_meshSplice(gLUhalfEdge, gLUhalfEdge4.Sym.Lnext)) {
                throw new RuntimeException();
            }
            gLUhalfEdge = Sweep.FinishLeftRegions(gLUtessellatorImpl, activeRegion2, null);
            bl = true;
        }
        if (bl) {
            Sweep.AddRightEdges(gLUtessellatorImpl, activeRegion, gLUhalfEdge.Onext, gLUhalfEdge2, gLUhalfEdge2, true);
            return;
        }
        gLUhalfEdge2 = Geom.VertLeq(gLUhalfEdge4.Org, gLUhalfEdge3.Org) ? gLUhalfEdge4.Sym.Lnext : gLUhalfEdge3;
        if ((gLUhalfEdge2 = Mesh.__gl_meshConnect(gLUhalfEdge.Onext.Sym, gLUhalfEdge2)) == null) {
            throw new RuntimeException();
        }
        Sweep.AddRightEdges(gLUtessellatorImpl, activeRegion, gLUhalfEdge2, gLUhalfEdge2.Onext, gLUhalfEdge2.Onext, false);
        gLUhalfEdge2.Sym.activeRegion.fixUpperEdge = true;
        Sweep.WalkDirtyRegions(gLUtessellatorImpl, activeRegion);
    }

    static void ConnectLeftDegenerate(GLUtessellatorImpl gLUtessellatorImpl, ActiveRegion activeRegion, GLUvertex gLUvertex) {
        GLUhalfEdge gLUhalfEdge;
        GLUhalfEdge gLUhalfEdge2 = activeRegion.eUp;
        if (Geom.VertEq(gLUhalfEdge2.Org, gLUvertex)) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            Sweep.SpliceMergeVertices(gLUtessellatorImpl, gLUhalfEdge2, gLUvertex.anEdge);
            return;
        }
        if (!Geom.VertEq(gLUhalfEdge2.Sym.Org, gLUvertex)) {
            if (Mesh.__gl_meshSplitEdge(gLUhalfEdge2.Sym) == null) {
                throw new RuntimeException();
            }
            if (activeRegion.fixUpperEdge) {
                if (!Mesh.__gl_meshDelete(gLUhalfEdge2.Onext)) {
                    throw new RuntimeException();
                }
                activeRegion.fixUpperEdge = false;
            }
            if (!Mesh.__gl_meshSplice(gLUvertex.anEdge, gLUhalfEdge2)) {
                throw new RuntimeException();
            }
            Sweep.SweepEvent(gLUtessellatorImpl, gLUvertex);
            return;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        activeRegion = Sweep.TopRightRegion(activeRegion);
        ActiveRegion activeRegion2 = Sweep.RegionBelow(activeRegion);
        GLUhalfEdge gLUhalfEdge3 = activeRegion2.eUp.Sym;
        gLUhalfEdge2 = gLUhalfEdge = gLUhalfEdge3.Onext;
        if (activeRegion2.fixUpperEdge) {
            if (!$assertionsDisabled && gLUhalfEdge2 == gLUhalfEdge3) {
                throw new AssertionError();
            }
            Sweep.DeleteRegion(gLUtessellatorImpl, activeRegion2);
            if (!Mesh.__gl_meshDelete(gLUhalfEdge3)) {
                throw new RuntimeException();
            }
            gLUhalfEdge3 = gLUhalfEdge2.Sym.Lnext;
        }
        if (!Mesh.__gl_meshSplice(gLUvertex.anEdge, gLUhalfEdge3)) {
            throw new RuntimeException();
        }
        if (!Geom.EdgeGoesLeft(gLUhalfEdge2)) {
            gLUhalfEdge2 = null;
        }
        Sweep.AddRightEdges(gLUtessellatorImpl, activeRegion, gLUhalfEdge3.Onext, gLUhalfEdge, gLUhalfEdge2, true);
    }

    static void ConnectLeftVertex(GLUtessellatorImpl gLUtessellatorImpl, GLUvertex gLUvertex) {
        ActiveRegion activeRegion = new ActiveRegion();
        new ActiveRegion().eUp = gLUvertex.anEdge.Sym;
        activeRegion = (ActiveRegion)Dict.dictKey(Dict.dictSearch(gLUtessellatorImpl.dict, activeRegion));
        ActiveRegion activeRegion2 = Sweep.RegionBelow(activeRegion);
        GLUhalfEdge gLUhalfEdge = activeRegion.eUp;
        GLUhalfEdge gLUhalfEdge2 = activeRegion2.eUp;
        if (Geom.EdgeSign(gLUhalfEdge.Sym.Org, gLUvertex, gLUhalfEdge.Org) == 0.0) {
            Sweep.ConnectLeftDegenerate(gLUtessellatorImpl, activeRegion, gLUvertex);
            return;
        }
        ActiveRegion activeRegion3 = activeRegion2 = Geom.VertLeq(gLUhalfEdge2.Sym.Org, gLUhalfEdge.Sym.Org) ? activeRegion : activeRegion2;
        if (activeRegion.inside || activeRegion2.fixUpperEdge) {
            if (activeRegion2 == activeRegion) {
                gLUhalfEdge = Mesh.__gl_meshConnect(gLUvertex.anEdge.Sym, gLUhalfEdge.Lnext);
                if (gLUhalfEdge == null) {
                    throw new RuntimeException();
                }
            } else {
                gLUhalfEdge = Mesh.__gl_meshConnect(gLUhalfEdge2.Sym.Onext.Sym, gLUvertex.anEdge);
                if (gLUhalfEdge == null) {
                    throw new RuntimeException();
                }
                gLUhalfEdge = gLUhalfEdge.Sym;
            }
            if (activeRegion2.fixUpperEdge) {
                if (!Sweep.FixUpperEdge(activeRegion2, gLUhalfEdge)) {
                    throw new RuntimeException();
                }
            } else {
                Sweep.ComputeWinding(gLUtessellatorImpl, Sweep.AddRegionBelow(gLUtessellatorImpl, activeRegion, gLUhalfEdge));
            }
            Sweep.SweepEvent(gLUtessellatorImpl, gLUvertex);
            return;
        }
        Sweep.AddRightEdges(gLUtessellatorImpl, activeRegion, gLUvertex.anEdge, gLUvertex.anEdge, null, true);
    }

    static void SweepEvent(GLUtessellatorImpl gLUtessellatorImpl, GLUvertex object) {
        gLUtessellatorImpl.event = object;
        Sweep.DebugEvent(gLUtessellatorImpl);
        Object object2 = ((GLUvertex)object).anEdge;
        while (((GLUhalfEdge)object2).activeRegion == null) {
            object2 = ((GLUhalfEdge)object2).Onext;
            if (object2 != ((GLUvertex)object).anEdge) continue;
            Sweep.ConnectLeftVertex(gLUtessellatorImpl, (GLUvertex)object);
            return;
        }
        object = Sweep.TopLeftRegion(((GLUhalfEdge)object2).activeRegion);
        if (object == null) {
            throw new RuntimeException();
        }
        object2 = Sweep.RegionBelow((ActiveRegion)object);
        GLUhalfEdge gLUhalfEdge = ((ActiveRegion)object2).eUp;
        object2 = Sweep.FinishLeftRegions(gLUtessellatorImpl, (ActiveRegion)object2, null);
        if (((GLUhalfEdge)object2).Onext == gLUhalfEdge) {
            Sweep.ConnectRightVertex(gLUtessellatorImpl, (ActiveRegion)object, (GLUhalfEdge)object2);
            return;
        }
        Sweep.AddRightEdges(gLUtessellatorImpl, (ActiveRegion)object, ((GLUhalfEdge)object2).Onext, gLUhalfEdge, gLUhalfEdge, true);
    }

    static void AddSentinel(GLUtessellatorImpl gLUtessellatorImpl, double d2) {
        ActiveRegion activeRegion = new ActiveRegion();
        GLUhalfEdge gLUhalfEdge = Mesh.__gl_meshMakeEdge(gLUtessellatorImpl.mesh);
        if (gLUhalfEdge == null) {
            throw new RuntimeException();
        }
        gLUhalfEdge.Org.s = 4.0E150;
        gLUhalfEdge.Org.t = d2;
        gLUhalfEdge.Sym.Org.s = -4.0E150;
        gLUhalfEdge.Sym.Org.t = d2;
        gLUtessellatorImpl.event = gLUhalfEdge.Sym.Org;
        activeRegion.eUp = gLUhalfEdge;
        activeRegion.windingNumber = 0;
        activeRegion.inside = false;
        activeRegion.fixUpperEdge = false;
        activeRegion.sentinel = true;
        activeRegion.dirty = false;
        activeRegion.nodeUp = Dict.dictInsert(gLUtessellatorImpl.dict, activeRegion);
        if (activeRegion.nodeUp == null) {
            throw new RuntimeException();
        }
    }

    static void InitEdgeDict(GLUtessellatorImpl gLUtessellatorImpl) {
        gLUtessellatorImpl.dict = Dict.dictNewDict(gLUtessellatorImpl, new Sweep$1(gLUtessellatorImpl));
        if (gLUtessellatorImpl.dict == null) {
            throw new RuntimeException();
        }
        Sweep.AddSentinel(gLUtessellatorImpl, -4.0E150);
        Sweep.AddSentinel(gLUtessellatorImpl, 4.0E150);
    }

    static void DoneEdgeDict(GLUtessellatorImpl gLUtessellatorImpl) {
        ActiveRegion activeRegion;
        int n2 = 0;
        while ((activeRegion = (ActiveRegion)Dict.dictKey(Dict.dictMin(gLUtessellatorImpl.dict))) != null) {
            if (!activeRegion.sentinel) {
                if (!$assertionsDisabled && !activeRegion.fixUpperEdge) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && ++n2 != 1) {
                    throw new AssertionError();
                }
            }
            if (!$assertionsDisabled && activeRegion.windingNumber != 0) {
                throw new AssertionError();
            }
            Sweep.DeleteRegion(gLUtessellatorImpl, activeRegion);
        }
        Dict.dictDeleteDict(gLUtessellatorImpl.dict);
    }

    static void RemoveDegenerateEdges(GLUtessellatorImpl gLUtessellatorImpl) {
        GLUhalfEdge gLUhalfEdge = gLUtessellatorImpl.mesh.eHead;
        GLUhalfEdge gLUhalfEdge2 = gLUhalfEdge.next;
        while (gLUhalfEdge2 != gLUhalfEdge) {
            GLUhalfEdge gLUhalfEdge3 = gLUhalfEdge2.next;
            GLUhalfEdge gLUhalfEdge4 = gLUhalfEdge2.Lnext;
            if (Geom.VertEq(gLUhalfEdge2.Org, gLUhalfEdge2.Sym.Org) && gLUhalfEdge2.Lnext.Lnext != gLUhalfEdge2) {
                Sweep.SpliceMergeVertices(gLUtessellatorImpl, gLUhalfEdge4, gLUhalfEdge2);
                if (!Mesh.__gl_meshDelete(gLUhalfEdge2)) {
                    throw new RuntimeException();
                }
                gLUhalfEdge2 = gLUhalfEdge4;
                gLUhalfEdge4 = gLUhalfEdge2.Lnext;
            }
            if (gLUhalfEdge4.Lnext == gLUhalfEdge2) {
                if (gLUhalfEdge4 != gLUhalfEdge2) {
                    if (gLUhalfEdge4 == gLUhalfEdge3 || gLUhalfEdge4 == gLUhalfEdge3.Sym) {
                        gLUhalfEdge3 = gLUhalfEdge3.next;
                    }
                    if (!Mesh.__gl_meshDelete(gLUhalfEdge4)) {
                        throw new RuntimeException();
                    }
                }
                if (gLUhalfEdge2 == gLUhalfEdge3 || gLUhalfEdge2 == gLUhalfEdge3.Sym) {
                    gLUhalfEdge3 = gLUhalfEdge3.next;
                }
                if (!Mesh.__gl_meshDelete(gLUhalfEdge2)) {
                    throw new RuntimeException();
                }
            }
            gLUhalfEdge2 = gLUhalfEdge3;
        }
    }

    static boolean InitPriorityQ(GLUtessellatorImpl gLUtessellatorImpl) {
        PriorityQ priorityQ = gLUtessellatorImpl.pq = PriorityQ.pqNewPriorityQ(new Sweep$2());
        if (gLUtessellatorImpl.pq == null) {
            return false;
        }
        GLUvertex gLUvertex = gLUtessellatorImpl.mesh.vHead;
        GLUvertex gLUvertex2 = gLUvertex.next;
        while (gLUvertex2 != gLUvertex) {
            gLUvertex2.pqHandle = priorityQ.pqInsert(gLUvertex2);
            if ((long)gLUvertex2.pqHandle == Long.MAX_VALUE) break;
            gLUvertex2 = gLUvertex2.next;
        }
        if (gLUvertex2 != gLUvertex || !priorityQ.pqInit()) {
            gLUtessellatorImpl.pq.pqDeletePriorityQ();
            gLUtessellatorImpl.pq = null;
            return false;
        }
        return true;
    }

    static void DonePriorityQ(GLUtessellatorImpl gLUtessellatorImpl) {
        gLUtessellatorImpl.pq.pqDeletePriorityQ();
    }

    static boolean RemoveDegenerateFaces(GLUmesh gLUmesh) {
        Object object = gLUmesh.fHead.next;
        while (object != gLUmesh.fHead) {
            GLUface gLUface = ((GLUface)object).next;
            object = ((GLUface)object).anEdge;
            if (!$assertionsDisabled && ((GLUhalfEdge)object).Lnext == object) {
                throw new AssertionError();
            }
            if (((GLUhalfEdge)object).Lnext.Lnext == object) {
                Sweep.AddWinding(((GLUhalfEdge)object).Onext, (GLUhalfEdge)object);
                if (!Mesh.__gl_meshDelete((GLUhalfEdge)object)) {
                    return false;
                }
            }
            object = gLUface;
        }
        return true;
    }

    public static boolean __gl_computeInterior(GLUtessellatorImpl gLUtessellatorImpl) {
        GLUvertex gLUvertex;
        gLUtessellatorImpl.fatalError = false;
        Sweep.RemoveDegenerateEdges(gLUtessellatorImpl);
        if (!Sweep.InitPriorityQ(gLUtessellatorImpl)) {
            return false;
        }
        Sweep.InitEdgeDict(gLUtessellatorImpl);
        while ((gLUvertex = (GLUvertex)gLUtessellatorImpl.pq.pqExtractMin()) != null) {
            GLUvertex gLUvertex2;
            while ((gLUvertex2 = (GLUvertex)gLUtessellatorImpl.pq.pqMinimum()) != null && Geom.VertEq(gLUvertex2, gLUvertex)) {
                gLUvertex2 = (GLUvertex)gLUtessellatorImpl.pq.pqExtractMin();
                Sweep.SpliceMergeVertices(gLUtessellatorImpl, gLUvertex.anEdge, gLUvertex2.anEdge);
            }
            Sweep.SweepEvent(gLUtessellatorImpl, gLUvertex);
        }
        gLUtessellatorImpl.event = ((ActiveRegion)Dict.dictKey((DictNode)Dict.dictMin((Dict)gLUtessellatorImpl.dict))).eUp.Org;
        Sweep.DebugEvent(gLUtessellatorImpl);
        Sweep.DoneEdgeDict(gLUtessellatorImpl);
        Sweep.DonePriorityQ(gLUtessellatorImpl);
        if (!Sweep.RemoveDegenerateFaces(gLUtessellatorImpl.mesh)) {
            return false;
        }
        Mesh.__gl_meshCheckMesh(gLUtessellatorImpl.mesh);
        return true;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

