/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.packrect;

import com.sun.opengl.impl.packrect.BackingStoreManager;
import com.sun.opengl.impl.packrect.Level;
import com.sun.opengl.impl.packrect.LevelSet;
import com.sun.opengl.impl.packrect.Rect;
import com.sun.opengl.impl.packrect.RectVisitor;
import com.sun.opengl.impl.packrect.RectanglePacker$RectHComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public class RectanglePacker {
    private BackingStoreManager manager;
    private Object backingStore;
    private LevelSet levels;
    private float EXPANSION_FACTOR = 0.5f;
    private float SHRINK_FACTOR = 0.3f;
    private int initialWidth;
    private int initialHeight;
    private int maxWidth = -1;
    private int maxHeight = -1;
    private static final Comparator rectHComparator = new RectanglePacker$RectHComparator();

    public RectanglePacker(BackingStoreManager backingStoreManager, int n2, int n3) {
        this.manager = backingStoreManager;
        this.levels = new LevelSet(n2, n3);
        this.initialWidth = n2;
        this.initialHeight = n3;
    }

    public Object getBackingStore() {
        if (this.backingStore == null) {
            this.backingStore = this.manager.allocateBackingStore(this.levels.w(), this.levels.h());
        }
        return this.backingStore;
    }

    public void setMaxSize(int n2, int n3) {
        this.maxWidth = n2;
        this.maxHeight = n3;
    }

    public void add(Rect rect) {
        if (this.backingStore == null) {
            this.backingStore = this.manager.allocateBackingStore(this.levels.w(), this.levels.h());
        }
        int n2 = 0;
        do {
            if (this.levels.add(rect)) {
                return;
            }
            if (!this.levels.compactAndAdd(rect, this.backingStore, this.manager)) continue;
            return;
        } while (this.manager.preExpand(rect, n2++));
        this.compactImpl(rect);
        this.add(rect);
    }

    public void remove(Rect rect) {
        this.levels.remove(rect);
    }

    public void visit(RectVisitor rectVisitor) {
        this.levels.visit(rectVisitor);
    }

    public float verticalFragmentationRatio() {
        return this.levels.verticalFragmentationRatio();
    }

    public void compact() {
        this.compactImpl(null);
    }

    private void compactImpl(Rect rect) {
        Rect rect2;
        Iterator iterator;
        boolean bl = false;
        int n2 = this.levels.w();
        int n3 = this.levels.h();
        LevelSet levelSet = null;
        int n4 = 0;
        while (!bl) {
            if (rect != null) {
                if (rect.w() > n2) {
                    n2 = rect.w();
                } else {
                    n3 = (int)((float)n3 * (1.0f + this.EXPANSION_FACTOR));
                }
            }
            boolean bl2 = false;
            if (this.maxWidth > 0 && n2 > this.maxWidth) {
                n2 = this.maxWidth;
                bl2 = true;
            }
            if (this.maxHeight > 0 && n3 > this.maxHeight) {
                n3 = this.maxHeight;
                bl2 = true;
            }
            levelSet = new LevelSet(n2, n3);
            ArrayList<Rect> arrayList = new ArrayList<Rect>();
            iterator = this.levels.iterator();
            while (iterator.hasNext()) {
                Iterator iterator2 = ((Level)iterator.next()).iterator();
                while (iterator2.hasNext()) {
                    rect2 = (Rect)iterator2.next();
                    Rect rect3 = new Rect(0, 0, rect2.w(), rect2.h(), null);
                    rect2.setNextLocation(rect3);
                    rect3.setNextLocation(rect2);
                    arrayList.add(rect3);
                }
            }
            Collections.sort(arrayList, rectHComparator);
            bl = true;
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                if (levelSet.add((Rect)iterator.next())) continue;
                bl = false;
                break;
            }
            if (bl && rect != null && !levelSet.add(rect)) {
                bl = false;
            }
            if (!bl && bl2 && rect != null) {
                this.manager.additionFailed(rect, n4);
            }
            ++n4;
        }
        if (levelSet.getUsedHeight() > 0 && (float)levelSet.getUsedHeight() < (float)levelSet.h() * this.SHRINK_FACTOR) {
            int n5 = Math.max(this.initialHeight, (int)((float)levelSet.getUsedHeight() * (1.0f + this.EXPANSION_FACTOR)));
            if (this.maxHeight > 0 && n5 > this.maxHeight) {
                n5 = this.maxHeight;
            }
            levelSet.setHeight(n5);
        }
        if (rect != null) {
            levelSet.remove(rect);
        }
        Object object = this.manager.allocateBackingStore(levelSet.w(), levelSet.h());
        this.manager.beginMovement(this.backingStore, object);
        iterator = this.levels.iterator();
        while (iterator.hasNext()) {
            Iterator iterator3 = ((Level)iterator.next()).iterator();
            while (iterator3.hasNext()) {
                rect2 = (Rect)iterator3.next();
                this.manager.move(this.backingStore, rect2, object, rect2.getNextLocation());
            }
        }
        levelSet.updateRectangleReferences();
        this.manager.endMovement(this.backingStore, object);
        this.manager.deleteBackingStore(this.backingStore);
        this.backingStore = object;
        this.levels = levelSet;
    }

    public void clear() {
        this.levels.clear();
    }

    public void dispose() {
        if (this.backingStore != null) {
            this.manager.deleteBackingStore(this.backingStore);
        }
        this.backingStore = null;
        this.levels = null;
    }
}

