/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.nurbs;

import com.sun.opengl.impl.nurbs.CArrayOfFloats;
import com.sun.opengl.impl.nurbs.CArrayOfQuiltspecs;
import com.sun.opengl.impl.nurbs.Mapdesc;
import com.sun.opengl.impl.nurbs.Quilt;

class Curve {
    private static final int MAXCOORDS = 5;
    private static final int MAXORDER = 24;
    public Curve next;
    private Mapdesc mapdesc;
    private boolean needsSampling;
    private int cullval;
    private int stride;
    private int order;
    private float[] range;
    public float stepsize;
    private float minstepsize;
    float[] spts = new float[120];
    static final boolean $assertionsDisabled = !(class$com$sun$opengl$impl$nurbs$Curve == null ? (class$com$sun$opengl$impl$nurbs$Curve = Curve.class$("com.sun.opengl.impl.nurbs.Curve")) : class$com$sun$opengl$impl$nurbs$Curve).desiredAssertionStatus();
    static Class class$com$sun$opengl$impl$nurbs$Curve;

    public Curve(Quilt object, float[] object2, float[] fArray, Curve curve) {
        this.mapdesc = ((Quilt)object).mapdesc;
        this.next = curve;
        this.needsSampling = this.mapdesc.isRangeSampling();
        this.cullval = this.mapdesc.isCulling() ? 1 : 0;
        this.order = ((Quilt)object).qspec.get((int)0).order;
        this.stride = 5;
        object2 = new CArrayOfFloats(((Quilt)object).cpts.getArray(), 0);
        object = ((Quilt)object).qspec;
        ((CArrayOfFloats)object2).raisePointerBy(((CArrayOfQuiltspecs)object).get().offset);
        ((CArrayOfFloats)object2).raisePointerBy(((CArrayOfQuiltspecs)object).get().index * ((CArrayOfQuiltspecs)object).get().order * ((CArrayOfQuiltspecs)object).get().stride);
        if (this.needsSampling) {
            this.mapdesc.xformSampling((CArrayOfFloats)object2, ((CArrayOfQuiltspecs)object).get().order, ((CArrayOfQuiltspecs)object).get().stride, this.spts, this.stride);
        }
        this.range = new float[3];
        this.range[0] = ((CArrayOfQuiltspecs)object).get().breakpoints[((CArrayOfQuiltspecs)object).get().index];
        this.range[1] = ((CArrayOfQuiltspecs)object).get().breakpoints[((CArrayOfQuiltspecs)object).get().index + 1];
        this.range[2] = this.range[1] - this.range[0];
    }

    public int cullCheck() {
        return 1;
    }

    public void getStepSize() {
        this.minstepsize = 0.0f;
        if (!this.mapdesc.isConstantSampling()) {
            if (this.mapdesc.isDomainSampling()) {
                this.setstepsize(this.mapdesc.maxrate * this.range[2]);
                return;
            }
            if (!$assertionsDisabled && this.order > 24) {
                throw new AssertionError();
            }
        }
        this.setstepsize(this.mapdesc.maxrate);
    }

    private void setstepsize(float f2) {
        this.minstepsize = this.stepsize = f2 >= 1.0f ? this.range[2] / f2 : this.range[2];
    }

    public void clamp() {
        if (this.stepsize < this.minstepsize) {
            this.stepsize = this.mapdesc.clampfactor * this.minstepsize;
        }
    }

    public boolean needsSamplingSubdivision() {
        return this.stepsize < this.minstepsize;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

