/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.macosx;

import com.sun.opengl.impl.GLContextShareSet;
import com.sun.opengl.impl.macosx.CGL;
import com.sun.opengl.impl.macosx.MacOSXGLContext;
import com.sun.opengl.impl.macosx.MacOSXPbufferGLContext$1;
import com.sun.opengl.impl.macosx.MacOSXPbufferGLContext$CGLImpl;
import com.sun.opengl.impl.macosx.MacOSXPbufferGLContext$Impl;
import com.sun.opengl.impl.macosx.MacOSXPbufferGLContext$NSOpenGLImpl;
import com.sun.opengl.impl.macosx.MacOSXPbufferGLDrawable;
import java.security.AccessController;
import java.util.StringTokenizer;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;

public class MacOSXPbufferGLContext
extends MacOSXGLContext {
    protected MacOSXPbufferGLDrawable drawable;
    private int textureTarget;
    private int texture;
    private static boolean isTigerOrLater;
    private boolean haveSetOpenGLMode = false;
    private int openGLMode = 1;
    protected MacOSXPbufferGLContext$Impl impl;

    public MacOSXPbufferGLContext(MacOSXPbufferGLDrawable macOSXPbufferGLDrawable, GLContext gLContext) {
        super(macOSXPbufferGLDrawable, gLContext);
        this.drawable = macOSXPbufferGLDrawable;
        this.initOpenGLImpl();
    }

    @Override
    public void bindPbufferToTexture() {
        this.getGL().glBindTexture(this.textureTarget, this.texture);
        CGL.setContextTextureImageToPBuffer(this.nsContext, this.drawable.getPbuffer(), 1028);
    }

    @Override
    public void releasePbufferFromTexture() {
    }

    @Override
    protected int makeCurrentImpl() {
        if (this.drawable.getPbuffer() == 0L) {
            if (DEBUG) {
                System.err.println("Pbuffer not instantiated yet for " + this);
            }
            return 0;
        }
        if (this.getOpenGLMode() != this.drawable.getOpenGLMode()) {
            this.setOpenGLMode(this.drawable.getOpenGLMode());
        }
        boolean bl = false;
        if (this.nsContext == 0L) {
            if (!this.create()) {
                return 0;
            }
            if (DEBUG) {
                System.err.println("!!! Created OpenGL context " + MacOSXPbufferGLContext.toHexString(this.nsContext) + " for " + this.getClass().getName());
            }
            bl = true;
        }
        if (!this.impl.makeCurrent(this.nsContext)) {
            throw new GLException("Error making nsContext current");
        }
        if (bl) {
            this.resetGLFunctionAvailability();
            bl = this.drawable.getCapabilities().getPbufferRenderToTextureRectangle();
            GL gL = this.getGL();
            if (bl && !gL.isExtensionAvailable("GL_EXT_texture_rectangle")) {
                System.err.println("MacOSXPbufferGLContext: WARNING: GL_EXT_texture_rectangle extension not supported; skipping requested render_to_texture_rectangle support for pbuffer");
                bl = false;
            }
            this.textureTarget = bl ? 34037 : 3553;
            int[] nArray = new int[1];
            gL.glGenTextures(1, nArray, 0);
            this.texture = nArray[0];
            gL.glBindTexture(this.textureTarget, this.texture);
            gL.glTexParameteri(this.textureTarget, 10241, 9728);
            gL.glTexParameteri(this.textureTarget, 10240, 9728);
            gL.glTexParameteri(this.textureTarget, 10242, 33071);
            gL.glTexParameteri(this.textureTarget, 10243, 33071);
            gL.glCopyTexImage2D(this.textureTarget, 0, 6407, 0, 0, this.drawable.getWidth(), this.drawable.getHeight(), 0);
            return 2;
        }
        return 1;
    }

    @Override
    protected void releaseImpl() {
        if (!this.impl.release(this.nsContext)) {
            throw new GLException("Error releasing OpenGL nsContext");
        }
    }

    @Override
    protected void destroyImpl() {
        if (this.nsContext != 0L) {
            if (!this.impl.destroy(this.nsContext)) {
                throw new GLException("Unable to delete OpenGL context");
            }
            if (DEBUG) {
                System.err.println("!!! Destroyed OpenGL context " + this.nsContext);
            }
            this.nsContext = 0L;
            GLContextShareSet.contextDestroyed(this);
        }
    }

    @Override
    public void setSwapInterval(int n2) {
        if (this.nsContext == 0L) {
            throw new GLException("OpenGL context not current");
        }
        this.impl.setSwapInterval(this.nsContext, n2);
    }

    @Override
    public int getFloatingPointMode() {
        return 1;
    }

    @Override
    protected boolean create() {
        if (this.drawable.getCapabilities().getPbufferFloatingPointBuffers() && !isTigerOrLater) {
            throw new GLException("Floating-point pbuffers supported only on OS X 10.4 or later");
        }
        MacOSXGLContext macOSXGLContext = (MacOSXGLContext)GLContextShareSet.getShareContext(this);
        if (macOSXGLContext != null) {
            this.setOpenGLMode(macOSXGLContext.getOpenGLMode());
        }
        this.nsContext = this.impl.create();
        return true;
    }

    @Override
    public void setOpenGLMode(int n2) {
        if (n2 == this.openGLMode) {
            return;
        }
        if (this.haveSetOpenGLMode) {
            throw new GLException("Can't switch between using NSOpenGLPixelBuffer and CGLPBufferObj more than once");
        }
        this.destroyImpl();
        this.drawable.setOpenGLMode(n2);
        this.openGLMode = n2;
        this.haveSetOpenGLMode = true;
        if (DEBUG) {
            System.err.println("Switching PBuffer context mode to " + (n2 == 1 ? "NSOPENGL_MODE" : "CGL_MODE"));
        }
        this.initOpenGLImpl();
    }

    @Override
    public int getOpenGLMode() {
        return this.openGLMode;
    }

    private void initOpenGLImpl() {
        switch (this.openGLMode) {
            case 1: {
                this.impl = new MacOSXPbufferGLContext$NSOpenGLImpl(this);
                return;
            }
            case 2: {
                this.impl = new MacOSXPbufferGLContext$CGLImpl(this);
                return;
            }
        }
        throw new InternalError("Illegal implementation mode " + this.openGLMode);
    }

    static /* synthetic */ boolean access$000() {
        return isTigerOrLater;
    }

    static /* synthetic */ boolean access$100() {
        return DEBUG;
    }

    static {
        Object object = (String)AccessController.doPrivileged(new MacOSXPbufferGLContext$1());
        object = new StringTokenizer((String)object, ". ");
        int n2 = Integer.parseInt(((StringTokenizer)object).nextToken());
        int n3 = Integer.parseInt(((StringTokenizer)object).nextToken());
        isTigerOrLater = n2 > 10 || n3 > 3;
    }
}

