/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.macosx;

import com.sun.opengl.impl.GLContextImpl;
import com.sun.opengl.impl.GLContextShareSet;
import com.sun.opengl.impl.macosx.CGL;
import com.sun.opengl.impl.macosx.CGLExt;
import com.sun.opengl.impl.macosx.CGLExtImpl;
import com.sun.opengl.impl.macosx.CGLExtProcAddressTable;
import com.sun.opengl.impl.macosx.MacOSXGLDrawable;
import java.nio.ByteBuffer;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLException;

public abstract class MacOSXGLContext
extends GLContextImpl {
    protected MacOSXGLDrawable drawable;
    protected long nsContext;
    private CGLExt cglExt;
    private CGLExtProcAddressTable cglExtProcAddressTable;

    public MacOSXGLContext(MacOSXGLDrawable macOSXGLDrawable, GLContext gLContext) {
        super(gLContext);
        this.drawable = macOSXGLDrawable;
    }

    @Override
    public Object getPlatformGLExtensions() {
        return this.getCGLExt();
    }

    public CGLExt getCGLExt() {
        if (this.cglExt == null) {
            this.cglExt = new CGLExtImpl(this);
        }
        return this.cglExt;
    }

    @Override
    public GLDrawable getGLDrawable() {
        return this.drawable;
    }

    @Override
    protected String mapToRealGLFunctionName(String string) {
        return string;
    }

    @Override
    protected String mapToRealGLExtensionName(String string) {
        return string;
    }

    protected abstract boolean create();

    protected boolean create(boolean bl, boolean n2) {
        long l2;
        Object object = (MacOSXGLContext)GLContextShareSet.getShareContext(this);
        long l3 = 0L;
        if (object != null && (l3 = ((MacOSXGLContext)object).getNSContext()) == 0L) {
            throw new GLException("GLContextShareSet returned an invalid OpenGL context");
        }
        object = new int[1];
        GLCapabilities gLCapabilities = this.drawable.getCapabilities();
        int[] nArray = new int[128];
        int[] nArray2 = new int[128];
        int n3 = 0;
        if (bl) {
            nArray[0] = 90;
            nArray2[0] = 1;
            ++n3;
        }
        if (n2 != 0) {
            nArray[n3] = 58;
            nArray2[n3] = 1;
            ++n3;
        }
        nArray[n3] = 5;
        nArray2[n3] = gLCapabilities.getDoubleBuffered() ? 1 : 0;
        nArray[++n3] = 6;
        nArray2[n3] = gLCapabilities.getStereo() ? 1 : 0;
        nArray[++n3] = 8;
        nArray2[n3] = gLCapabilities.getRedBits() + gLCapabilities.getGreenBits() + gLCapabilities.getBlueBits();
        nArray[++n3] = 11;
        nArray2[n3] = gLCapabilities.getAlphaBits();
        nArray[++n3] = 12;
        nArray2[n3] = gLCapabilities.getDepthBits();
        nArray[++n3] = 14;
        nArray2[n3] = gLCapabilities.getAccumRedBits() + gLCapabilities.getAccumGreenBits() + gLCapabilities.getAccumBlueBits() + gLCapabilities.getAccumAlphaBits();
        nArray[++n3] = 13;
        nArray2[n3] = gLCapabilities.getStencilBits();
        ++n3;
        if (gLCapabilities.getSampleBuffers()) {
            nArray[n3] = 55;
            nArray2[n3] = 1;
            nArray[++n3] = 56;
            nArray2[n3] = gLCapabilities.getNumSamples();
            ++n3;
        }
        if ((l2 = CGL.createPixelFormat(nArray, 0, n3, nArray2, 0)) == 0L) {
            throw new GLException("Unable to allocate pixel format with requested GLCapabilities");
        }
        try {
            this.nsContext = CGL.createContext(l3, this.drawable.getView(), l2, (int[])object, 0);
            if (this.nsContext == 0L) {
                if (object[0] == true) {
                    if (DEBUG) {
                        System.err.println(new StringBuffer("!!! View not ready for ").append(this.getClass().getName()).toString());
                    }
                    return false;
                }
                throw new GLException("Error creating NSOpenGLContext with requested pixel format");
            }
            if (this.drawable.getChosenGLCapabilities() == null) {
                GLCapabilities gLCapabilities2 = new GLCapabilities();
                CGL.queryPixelFormat(l2, nArray, 0, n3, nArray2, 0);
                block16: for (n2 = 0; n2 < n3; ++n2) {
                    switch (nArray[n2]) {
                        case 58: {
                            gLCapabilities2.setPbufferFloatingPointBuffers(nArray2[n2] != 0);
                            continue block16;
                        }
                        case 5: {
                            gLCapabilities2.setDoubleBuffered(nArray2[n2] != 0);
                            continue block16;
                        }
                        case 6: {
                            gLCapabilities2.setStereo(nArray2[n2] != 0);
                            continue block16;
                        }
                        case 8: {
                            int n4 = nArray2[n2];
                            if (n4 == 32) {
                                n4 = 24;
                            }
                            gLCapabilities2.setRedBits(n4 /= 3);
                            gLCapabilities2.setGreenBits(n4);
                            gLCapabilities2.setBlueBits(n4);
                            continue block16;
                        }
                        case 11: {
                            gLCapabilities2.setAlphaBits(nArray2[n2]);
                            continue block16;
                        }
                        case 12: {
                            gLCapabilities2.setDepthBits(nArray2[n2]);
                            continue block16;
                        }
                        case 14: {
                            int n4 = nArray2[n2] / 4;
                            gLCapabilities2.setAccumRedBits(n4);
                            gLCapabilities2.setAccumGreenBits(n4);
                            gLCapabilities2.setAccumBlueBits(n4);
                            gLCapabilities2.setAccumAlphaBits(n4);
                            continue block16;
                        }
                        case 13: {
                            gLCapabilities2.setStencilBits(nArray2[n2]);
                            continue block16;
                        }
                        case 55: {
                            gLCapabilities2.setSampleBuffers(nArray2[n2] != 0);
                            continue block16;
                        }
                        case 56: {
                            gLCapabilities2.setNumSamples(nArray2[n2]);
                        }
                    }
                }
                this.drawable.setChosenGLCapabilities(gLCapabilities2);
            }
        }
        finally {
            CGL.deletePixelFormat(l2);
        }
        GLContextShareSet.contextCreated(this);
        return true;
    }

    @Override
    protected int makeCurrentImpl() {
        boolean bl = false;
        if (this.nsContext == 0L) {
            if (!this.create()) {
                return 0;
            }
            if (DEBUG) {
                System.err.println(new StringBuffer("!!! Created OpenGL context ").append(MacOSXGLContext.toHexString(this.nsContext)).append(" for ").append(this.getClass().getName()).toString());
            }
            bl = true;
        }
        if (!CGL.makeCurrentContext(this.nsContext)) {
            throw new GLException("Error making nsContext current");
        }
        if (bl) {
            this.resetGLFunctionAvailability();
            return 2;
        }
        return 1;
    }

    @Override
    protected void releaseImpl() {
        if (!CGL.clearCurrentContext(this.nsContext)) {
            throw new GLException("Error freeing OpenGL nsContext");
        }
    }

    @Override
    protected void destroyImpl() {
        if (this.nsContext != 0L) {
            if (!CGL.deleteContext(this.nsContext)) {
                throw new GLException("Unable to delete OpenGL context");
            }
            if (DEBUG) {
                System.err.println(new StringBuffer("!!! Destroyed OpenGL context ").append(this.nsContext).toString());
            }
            this.nsContext = 0L;
            GLContextShareSet.contextDestroyed(this);
        }
    }

    @Override
    public boolean isCreated() {
        return this.nsContext != 0L;
    }

    @Override
    public void copy(GLContext gLContext, int n2) {
        long l2 = this.getNSContext();
        long l3 = ((MacOSXGLContext)gLContext).getNSContext();
        if (l3 == 0L) {
            throw new GLException("Source OpenGL context has not been created");
        }
        if (l2 == 0L) {
            throw new GLException("Destination OpenGL context has not been created");
        }
        CGL.copyContext(l2, l3, n2);
    }

    @Override
    protected void resetGLFunctionAvailability() {
        super.resetGLFunctionAvailability();
        if (DEBUG) {
            System.err.println("!!! Initializing CGL extension address table");
        }
        this.resetProcAddressTable(this.getCGLExtProcAddressTable());
    }

    public CGLExtProcAddressTable getCGLExtProcAddressTable() {
        if (this.cglExtProcAddressTable == null) {
            this.cglExtProcAddressTable = new CGLExtProcAddressTable();
        }
        return this.cglExtProcAddressTable;
    }

    @Override
    public String getPlatformExtensionsString() {
        return "";
    }

    @Override
    public void setSwapInterval(int n2) {
        if (this.nsContext == 0L) {
            throw new GLException("OpenGL context not current");
        }
        CGL.setSwapInterval(this.nsContext, n2);
    }

    @Override
    public ByteBuffer glAllocateMemoryNV(int n2, float f2, float f3, float f4) {
        throw new GLException("Not yet implemented");
    }

    @Override
    protected boolean isFunctionAvailable(String string) {
        return super.isFunctionAvailable(string);
    }

    @Override
    public boolean isExtensionAvailable(String string) {
        if (string.equals("GL_ARB_pbuffer") || string.equals("GL_ARB_pixel_format")) {
            return true;
        }
        return super.isExtensionAvailable(string);
    }

    @Override
    public int getOffscreenContextPixelDataType() {
        throw new GLException("Should not call this");
    }

    public int getOffscreenContextReadBuffer() {
        throw new GLException("Should not call this");
    }

    @Override
    public boolean offscreenImageNeedsVerticalFlip() {
        throw new GLException("Should not call this");
    }

    @Override
    public void bindPbufferToTexture() {
        throw new GLException("Should not call this");
    }

    @Override
    public void releasePbufferFromTexture() {
        throw new GLException("Should not call this");
    }

    public abstract void setOpenGLMode(int var1);

    public abstract int getOpenGLMode();

    public long getNSContext() {
        return this.nsContext;
    }
}

